/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.FullCanvas;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class SeedCanvas
extends FullCanvas
implements Runnable {
    protected static final int COLOR_YELLOW = 0xFFFF00;
    protected static final int COLOR_ORANGE = 16753152;
    protected static final int COLOR_RED = 0xFF0000;
    protected static final int COLOR_BROWN = 0x773300;
    protected static final int COLOR_SKY_BLUE = 9231100;
    protected static final int COLOR_WHITE = 0xFFFFFF;
    protected static final int COLOR_BLACK = 0;
    protected static final int COLOR_LIGHT_GRAY = 0xC0C0C0;
    protected static final int COLOR_GRAY = 0x808080;
    protected static final int COLOR_DARK_GRAY = 0x404040;
    protected static final int COLOR_BLUE = 255;
    protected static final int COLOR_LIGHT_BLUE = 0x8080FF;
    protected static final int COLOR_BACKGROUND = 0xCEFFFF;
    protected static final int COLOR_NORMAL_BLOCK = 0xFF9900;
    protected static final int COLOR_LIST_BG = 0xCEFFFF;
    protected static final int COLOR_LIST_SHADOW = 0x404040;
    protected static final int COLOR_LIST_BORDER = 0;
    protected static final int COLOR_LIST_PANE = 0xFFFFFF;
    protected static final int COLOR_LIST_TEXT = 0;
    protected static final int COLOR_LIST_SELECTED = 0x8080FF;
    protected static final int COLOR_LIST_SELECTED_TEXT = -1;
    protected final int SCREEN_WIDTH = this.getWidth();
    protected final int SCREEN_HEIGHT = this.getHeight();
    protected static final int RANKING_COUNT = 4;
    protected static final int HEADER_HEIGHT_MARGIN = 7;
    protected final int SCORE_BOARD_HEIGHT;
    protected final Font FONT_LARGE = Font.getFont((int)0, (int)0, (int)0);
    protected final Font FONT_MEDIUM = Font.getFont((int)0, (int)0, (int)0);
    protected final Font FONT_SMALL;
    protected final Font FONT_SCORE_BOARD = this.FONT_SMALL = Font.getFont((int)0, (int)0, (int)8);
    protected static final int BOARD_WIDTH = 12;
    protected static final int BOARD_HEIGHT = 11;
    protected static final String[] STAGE_DATA = new String[]{"222222222222200760005002201111111102200300005002201111111102200000000002202020202002200000000002202020202002240000000042222222222222", "222222222222207000000002211110000002200000055552211100022222260005520042211002222222200552000042210222222222230200000042222222222222", "222222222222200003000002200000000002222251152222200250052002200251152002204250052402222251152222200256752002204251152402222222222222", "222222222222206002200702201105501102200002200002201105501102200002200002201105501102200002200002201105501102230002200042222222222222", "222222222222216101010702200000000002201010101012210101010102200505050502214141414102201014101012205050505052231010101012222222222222", "222222222222245500005622201100201102200050550002200020110022200055000002202011002002205500700552201100200112230000000042222222222222", "222222222222220000000422200500050002200100010002250005000502210071000102200500050002200100610052210022200012232000000002222222222222", "222222222222250003006052251111111152250007000052251111111152250000000052251111111152250000000452251111111152255555555552222222222222", "222222222222205050505052201010101012205050505052201010101012205057505052201010101012205050505052201010101012235056505452222222222222", "222222222222205050505052202010201012205050505052201020102012205057505052202010201012205050505052201020102012235056505452222222222222", "222222222222235550455552222220022222200000000002200000000002255550755552211110611112255550055552211110011112255555555552222222222222", "222222222222235500554062201100110022205500550052201100110022205500550052201107110022205500550052201100110022205500550052222222222222", "222222222222255000000552211000000222255500005552211100002222255550055552211110022222255550055552211116722222230000000042222222222222", "222222222222230205000502220502050162220105020502220101050102220101010502220101010102220101010102220101010102227141414142222222222222", "222222222222200055550002200522220562255220505522252250502522255550202522253020202522252020202022252020202022222424242722222222222222", "222222222222203000400072205050505052205050500112205050505052200000011102205050505052215011111012211002605052222222222222222222222222", "222222222222235555555502251545545152255155551552255510015552255557055552255051150552255515515552200100001002265555555552222222222222", "222222222222255547645552211102201112255502205552211102201112255502205552211102201112255502205552211102201112255532205552222222222222", "222222222222205545505502201101101102250555555052210111111312205500005502201100001102250555555062210111111012200004700002222222222222", "222222222222254506705452210101101012205005500502201001100102250503005052210101101012250555555052210111111012255555555552222222222222", "222222222222264505450572210101010102255005500552211001100112255500355502211100011102255550000552211110000112255555555552222222222222", "222222222222220000000652202505505252240251152052200025520052200001100752202200002252200002200052211000000112231222222142222222222222", "222222222222200700555552212222222222200000555552211111111112260000000002212222222222255555000042211111111112235555000042222222222222", "222222222222270420042462205505550552202505250522250555055502220515051502203505550552202020202022202020202022242024202022222222222222", "222222222222204000400042201000100012230000700002211111111152265555555552251111111112255555555552211111111152255555555552222222222222", "222222222222255505505552211101101112255055550552211011110112255505505552211101101112200007600002211111111112241013010142222222222222", "222222222222250004000052215000000512251500005152215150051512255516715552215100001512251010010152210100001012230000000042222222222222", "222222222222255404040552251000055052255006052052201005552002255000000552212001107212232000000242222001100222222000000222222222222222", "222222222222255404040552251000005052255005502052201000002002265000000552212001155212232000055242222001100222222000007222222222222222", "222222222222235555555562210000000012205555555502210007000012205555555502210000000012205555555502210000000012245555555542222222222222", "222222222222235555555562210100001012205555555502210107001012205555555502210100001012205555555502210100001012245555555542222222222222", "222222222222235550055502251210012152255250052552251210012152255256752552251210012152255250052552251210012152204004000402222222222222", "222222222222240000000042202120021202201510015102202120021202200006700002202120021202201510015102202120021202230000000042222222222222", "222222222222240001140072200015510002200155551002201511115102215555555512261115511102200155551002210015510012230001100042222222222222", "222222222222245555555542215510015512255000000552251010010152250006700052251010010152255000000552215510015512235555555542222222222222"};
    protected final int VIEW_HEIGHT = this.SCREEN_HEIGHT - this.FONT_MEDIUM.getHeight() - 1;
    protected String leftCommand;
    protected String rightCommand;
    private SeedMIDlet midlet;
    private Thread thread;
    private int nCurrentIndex;
    private boolean noticeDestroy;
    protected static final int STATE_INIT = 0;
    protected static final int STATE_CARRIER = 1;
    protected static final int STATE_COM2US = 2;
    protected static final int STATE_TITLE = 3;
    protected static final int STATE_MENU = 4;
    protected static final int STATE_MODE = 5;
    protected static final int STATE_INSTRUCTION = 6;
    protected static final int STATE_SETTINGS = 7;
    protected static final int STATE_SCORE = 8;
    protected static final int STATE_ABOUT = 9;
    protected static final int STATE_GAMEOVER = 10;
    protected static final int STATE_RUN = 11;
    protected static final int STATE_PAUSE = 12;
    protected static final int STATE_LOAD = 1000;
    protected static final int STATE_TITLE_Q = 1002;
    protected static final int STATE_SAVE_COMPLETE = 1003;
    protected int nState;
    protected int nPreviousState;
    protected int nSecondPreviousState;
    protected static final int KEY_OFF = 0;
    protected static final int KEY_PRESSED = 1;
    protected static final int KEY_RELEASED = 2;
    protected static final int KEY_REPEATED = 3;
    protected int nKeyCode;
    protected int nKeyState;
    protected long lStopWatchStartTime;
    protected final int HEADER_HEIGHT = this.FONT_LARGE.getHeight() + 7;
    protected static final int REFRESH_RATE = 250;
    protected int BOARD_X;
    protected int BOARD_Y;
    protected int TILE_WIDTH;
    protected int TILE_HEIGHT;
    protected int SCORE_Y;
    protected String[] INSTRUCTION_TEXT;
    protected String[] DEMO_TEXT;
    protected static final int IDB_CARRIER = 0;
    protected static final int IDB_COM2US = 1;
    protected static final int IDB_ABOUT = 2;
    protected static final int IDB_ICON = 3;
    protected static final int IDB_COPYRIGHT = 4;
    protected static final int IDB_FAIL = 5;
    protected static final int IDB_FLOWER_MIN = 6;
    protected static final int IDB_FLOWER_MAX = 9;
    protected static final int IDB_FLOWER_CLEAR_MIN = 10;
    protected static final int IDB_FLOWER_CLEAR_MAX = 13;
    protected static final int IDB_FLOWER_S = 14;
    protected static final int IDB_TITLE = 15;
    protected static final int IDB_MON_MIN = 16;
    protected static final int IDB_MON_MAX = 19;
    protected static final int IDB_TITLESKY = 20;
    protected static final int IDB_SEED_MIN = 21;
    protected static final int IDB_SEED_MAX = 24;
    protected static final int IDB_SEED_FLY = 25;
    protected static final int IDB_TILE_MIN = 26;
    protected static final int IDB_TILE_MAX = 31;
    protected static final int IDB_COUNT = 32;
    protected static final int IDS_TITLE = 0;
    protected static final int IDS_CLEAR = 1;
    protected static final int IDS_FAIL = 2;
    protected static final int IDS_ITEM = 3;
    protected static final int IDS_COUNT = 4;
    private Image[] IMAGES = new Image[32];
    private static int[] SOUND_SIZES = new int[]{110, 53, 56, 28};
    private Sound[] SOUNDS = new Sound[4];
    private Sound currentSound;
    protected static final int SETTING_ITEMS_COUNT = 2;
    protected static final byte SETTING_ON = 0;
    protected static final byte SETTING_OFF = 1;
    protected RecordStore rsData;
    protected byte[] byGameSetting = new byte[4];
    protected int[] nHighScore = new int[4];
    protected int nScore;
    protected int nStage;
    protected int nLife;
    protected int nStageStored;
    protected int nScoreStored;
    protected int nLifeStored;
    protected int nFlagStored;
    private int nTitleAniSeq;
    protected static final String[] MENU_ITEMS = new String[]{"Continue", "Play", "Instructions", "Score", "Settings", "About", "Quit"};
    private int nMenuIndex;
    protected static final int MODE_INDEX_MIN = 0;
    private int nModeIndex;
    protected static final String[] PAUSE_ITEMS = new String[]{"Save", "Instructions", "Score", "Settings", "About", "Quit"};
    private int nPauseIndex;
    private int nInstructionIndex;
    protected int nSettingIndex;
    private static final int STAGE_MINIMUM = 0;
    private static final int STAGE_DEMO = 3;
    public static final int RUN_STATE_READY = 0;
    public static final int RUN_STATE_ALIVE = 1;
    public static final int RUN_STATE_CLEAR = 2;
    public static final int RUN_STATE_ALL_CLEAR = 3;
    public static final int RUN_STATE_DEAD = 4;
    public static final int RUN_STATE_ALL_DEAD = 5;
    private boolean bContinueGame;
    private boolean bEasyMode;
    private static final int MAX_MONKEY = 6;
    private static final int N_MONKEY_FROZEN_TIME = 35;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int H = 2;
    private static final int D = 3;
    private static final int TILE_EMPTY = 0;
    private static final int TILE_NORMAL_BLOCK = 1;
    private static final int TILE_SOLID_BLOCK = 2;
    private static final int TILE_NORMAL_SEED = 3;
    private static final int TILE_GOLDEN_SEED = 4;
    private static final int TILE_FLOWER = 5;
    private static final int CHAR_STATE_NORMAL = 0;
    private static final int CHAR_STATE_ANGRY = 1;
    private static final int CHAR_STATE_DEAD = 2;
    private static final int DIRECTION_DOWN = 0;
    private static final int DIRECTION_UP = 1;
    private static final int DIRECTION_LEFT = 2;
    private static final int DIRECTION_RIGHT = 3;
    private Random random = new Random();
    private int[][] board = new int[12][11];
    private boolean[][] layer = new boolean[12][11];
    private int nRunState;
    private long lSleepingTime;
    private int nCurrentTile;
    private int nMaintainIndex;
    private volatile boolean bUpdatingScreen = false;
    private int nDandelionState;
    private int[] nDandelionPosition = new int[4];
    private int[] nDandelionPreviousPosition = new int[2];
    private int nMonkeyCount;
    private int nMonkeyFrozenTime;
    private int[] nMonkeyState = new int[6];
    private int[][] nMonkeyPosition = new int[6][4];
    private int[][] nMonkeyPreviousPosition = new int[6][2];
    private int nNormalSeedCount;
    private int[] nGoldenSeedPosition = new int[2];
    private int[] nFlowerPosition = new int[2];
    private int nAnimationIndex;

    protected void setCommands(String string, String string2) {
        this.leftCommand = string;
        this.rightCommand = string2;
    }

    protected void updateCommands(int n) {
        if (n == 12) {
            this.setCommands("Select", "Back");
        } else if (n == 4) {
            this.setCommands("Select", "Back");
        } else if (n == 5) {
            this.setCommands("Select", "Back");
        } else if (n == 10) {
            this.setCommands("Close", "Retry");
        } else if (n == 6) {
            this.setCommands(null, "Back");
        } else if (n == 8) {
            this.setCommands(null, "Back");
        } else if (n == 7) {
            this.setCommands("Change", "Back");
        } else if (n == 3) {
            this.setCommands("Options", "Play");
        } else if (n == 9) {
            this.setCommands(null, "Back");
        } else if (n == 11) {
            this.setCommands(null, "Options");
        } else if (n == 1003) {
            this.setCommands(null, "Back");
        }
    }

    private void drawCurrentCommands(Graphics graphics, int n) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(n);
        graphics.fillRect(0, this.VIEW_HEIGHT, this.SCREEN_WIDTH, this.SCREEN_HEIGHT - this.VIEW_HEIGHT);
        graphics.setColor(0);
        graphics.setFont(this.FONT_MEDIUM);
        if (this.leftCommand != null) {
            graphics.drawString(this.leftCommand, 2, this.SCREEN_HEIGHT, 36);
        }
        if (this.rightCommand != null) {
            graphics.drawString(this.rightCommand, this.SCREEN_WIDTH - 2, this.SCREEN_HEIGHT, 40);
        }
    }

    public SeedCanvas(SeedMIDlet seedMIDlet) {
        this.SCORE_BOARD_HEIGHT = 15;
        this.midlet = seedMIDlet;
        this.noticeDestroy = false;
    }

    protected void startCanvas() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    protected void pauseCanvas() {
        if (this.nState == 11) {
            this.initializePause();
        }
    }

    protected void destroyCanvas() {
        this.noticeDestroy = true;
        this.midlet.notifyDestroyed();
    }

    protected void setCurrentState(int n) {
        this.nSecondPreviousState = this.nPreviousState;
        this.nPreviousState = this.nState;
        this.nState = n;
        this.bUpdatingScreen = true;
        this.updateCommands(this.nState);
        this.repaint();
    }

    protected void goPreviousState() {
        this.nState = this.nPreviousState;
        this.nPreviousState = this.nSecondPreviousState;
        this.bUpdatingScreen = true;
        this.updateCommands(this.nState);
        this.repaint();
    }

    protected void doJob(String string) {
        if (string == "Continue") {
            this.bContinueGame = true;
            this.initializePlaying(true);
        } else if (string == "Play") {
            this.bContinueGame = false;
            this.initializePlaying(true);
        } else if (string == "Instructions") {
            this.initializeInstruction();
        } else if (string == "Score") {
            this.initializeScore();
        } else if (string == "Settings") {
            this.initializeSettings();
        } else if (string == "About") {
            this.initializeAbout();
        } else if (string == "Quit") {
            if (this.nState == 4) {
                this.destroyCanvas();
            } else {
                this.initializeTitle();
            }
        } else if (string == "Save") {
            this.initializeSaveGame();
        }
    }

    protected void keyPressed(int n) {
        this.nKeyCode = this.getKeyDirection(n);
        if (this.nState == 11) {
            this.keyPressedPlaying(this.nKeyCode);
        } else if (this.nState == 4) {
            this.keyPressedMenu(this.nKeyCode);
        } else if (this.nState == 5) {
            this.keyPressedMode(this.nKeyCode);
        } else if (this.nState == 6) {
            this.keyPressedInstruction(this.nKeyCode);
        } else if (this.nState == 8) {
            this.keyPressedScore(this.nKeyCode);
        } else if (this.nState == 7) {
            this.keyPressedSetup(this.nKeyCode);
        } else if (this.nState == 9) {
            this.keyPressedAbout(this.nKeyCode);
        } else if (this.nState == 10) {
            this.keyPressedGameOver(this.nKeyCode);
        } else if (this.nState == 3) {
            this.keyPressedTitle(this.nKeyCode);
        } else if (this.nState == 12) {
            this.keyPressedPause(this.nKeyCode);
        } else if (this.nState == 1003) {
            this.keyPressedSaveGame(this.nKeyCode);
        } else if (this.nState == 1 || this.nState == 2) {
            this.keyPressedSplash();
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        if (this.nKeyState == 1) {
            this.nKeyState = 2;
        } else {
            this.nKeyState = 0;
            this.nKeyCode = 0;
        }
    }

    protected void keyReset() {
        if (this.nKeyState == 1) {
            this.nKeyState = 3;
        } else if (this.nKeyState == 2) {
            this.nKeyState = 0;
            this.nKeyCode = 0;
        }
    }

    public void run() {
        do {
            this.sleep(100);
        } while (!this.isShown());
        this.nCurrentIndex = 0;
        this.waitForID(this.nCurrentIndex);
        this.waitForID(this.nCurrentIndex);
        this.initializeSplash(1);
        while (true) {
            if (this.nState == 11) {
                this.runPlaying();
                continue;
            }
            if (this.nState == 1 || this.nState == 2 || this.nState == 1000) {
                this.runSplash();
                continue;
            }
            if (this.nState == 3) {
                this.sleep(200);
                continue;
            }
            if (this.nState == 1003) {
                this.sleep(200);
                this.repaint();
                continue;
            }
            this.sleep(200);
        }
    }

    protected void paint(Graphics graphics) {
        if (this.nState == 11) {
            this.paintPlaying(graphics);
        } else if (this.nState == 12) {
            this.clearScreen(graphics, 0xCEFFFF);
            this.showPlaying(graphics);
            this.paintPause(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 4) {
            this.paintMenu(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 5) {
            this.paintMode(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 10) {
            this.clearScreen(graphics, 0xCEFFFF);
            this.showPlaying(graphics);
            this.paintGameOver(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 6) {
            this.paintInstruction(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 8) {
            this.paintScore(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 7) {
            this.paintSettings(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 3) {
            this.paintTitle(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 9) {
            this.paintAbout(graphics);
            this.drawCurrentCommands(graphics, 0xFFFFFF);
        } else if (this.nState == 1003) {
            this.paintSaveGame(graphics);
            this.drawCurrentCommands(graphics, 0xCEFFFF);
        } else if (this.nState == 1 || this.nState == 2 || this.nState == 1000) {
            this.paintSplash(graphics);
        }
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] readFile(String string, int n) {
        byte[] byArray = new byte[n];
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            inputStream.read(byArray);
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    private void drawBoldString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n4);
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    protected void clearScreen(Graphics graphics, int n) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(n);
        graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
    }

    private void drawImageClip(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6) {
        graphics.setClip(n, n2, n5, n6);
        graphics.drawImage(image, n - n3, n2 - n4, 20);
    }

    private void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n * n3 / n5;
        if (n4 > n5) {
            n4 = n5;
        }
        graphics.setColor(n6);
        graphics.fillRect(this.SCREEN_WIDTH - n2, 0, n2, n);
        graphics.setColor(n7);
        graphics.fillRect(this.SCREEN_WIDTH + 1 - n2, 1, n2 - 2, n - 2);
        graphics.setColor(n8);
        graphics.fillRect(this.SCREEN_WIDTH + 1 - n2, n9 + 1, n2 - 2, n * n4 / n5 - n9 - 2);
    }

    protected int drawText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        do {
            if ((n7 = ((n6 = string.indexOf("&", n5)) == -1 ? string.length() : n6) - n5) > 0 && n2 >= 0 && n2 < this.SCREEN_HEIGHT) {
                graphics.drawSubstring(string, n5, n7, n, n2, n3);
            }
            n5 = n6 + 1;
            n2 += n4;
        } while (n6 != -1);
        return n2;
    }

    private void drawFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(n3);
        graphics.fillRect(0, n - n2, this.SCREEN_WIDTH, n2);
        graphics.setColor(n4);
        graphics.fillRect(4, n - n2 + 4, this.SCREEN_WIDTH - 5, n2 - 5);
        graphics.setColor(n5);
        graphics.fillRect(2, n - n2 + 2, this.SCREEN_WIDTH - 5, n2 - 5);
        graphics.setColor(n6);
        graphics.fillRect(3, n - n2 + 3, this.SCREEN_WIDTH - 7, n2 - 7);
    }

    private void drawAlert(Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        this.drawFrame(graphics, n, n2, n3, n4, n5, n6);
        graphics.setColor(n7);
        graphics.setFont(this.FONT_MEDIUM);
        this.drawText(graphics, string, 10, n - n2 + 7, 20, this.FONT_MEDIUM.getHeight());
    }

    protected void drawItems(Graphics graphics, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11 = n3 * this.FONT_MEDIUM.getHeight() + 7;
        if (n < n2) {
            n = n2;
        }
        if (n11 > this.VIEW_HEIGHT) {
            n3 = (this.VIEW_HEIGHT - 7) / this.FONT_MEDIUM.getHeight();
            n11 = n3 * this.FONT_MEDIUM.getHeight() + 7;
            if (n - n2 >= n3) {
                n2 = n - n3 + 1;
            }
        }
        this.drawFrame(graphics, this.VIEW_HEIGHT, n11, n4, n5, n6, n7);
        graphics.setColor(n9);
        graphics.fillRect(3, this.VIEW_HEIGHT - n11 + 3 + this.FONT_MEDIUM.getHeight() * (n - n2), this.SCREEN_WIDTH - 7, this.FONT_MEDIUM.getHeight());
        graphics.setFont(this.FONT_MEDIUM);
        graphics.setColor(n8);
        int n12 = this.VIEW_HEIGHT - n11 + 3;
        int n13 = n2;
        while (n13 < n2 + n3) {
            graphics.drawString(stringArray[n13], 10, n12, 20);
            n12 += this.FONT_MEDIUM.getHeight();
            ++n13;
        }
        if (n10 != -1) {
            graphics.setColor(n4);
            graphics.drawString(stringArray[n], 10, this.VIEW_HEIGHT - n11 + 4 + this.FONT_MEDIUM.getHeight() * (n - n2), 20);
        }
    }

    private void drawImageCenter(Graphics graphics, Image image) {
        this.drawImageCenter(graphics, image, 0, 0);
    }

    private void drawImageCenter(Graphics graphics, Image image, int n, int n2) {
        if (image != null) {
            graphics.drawImage(image, this.SCREEN_WIDTH / 2 + n, (this.SCREEN_HEIGHT - image.getHeight()) / 2 + n2, 17);
        }
    }

    public static void drawOutlineString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n4);
        graphics.drawString(string, n - 1, n2, n3);
        graphics.drawString(string, n + 1, n2, n3);
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    public static String[] getStringArray(Font font, String string, int n) {
        int n2 = string.length();
        String[] stringArray = new String[font.stringWidth(string) / n * 2];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = string.indexOf(38);
        if (-1 == n7) {
            n7 = n2;
        }
        do {
            if (-1 == (n5 = string.indexOf(32, n5 + 1))) {
                n5 = n2;
            } else {
                int n8;
                n6 = string.indexOf(32, n5 + 1);
                if (-1 == n6) {
                    n6 = n2;
                }
                if (n7 != n2 && (n8 = string.indexOf(38, n5 + 1)) < n6) {
                    n6 = n8;
                }
            }
            if (n7 <= n5) {
                bl = true;
                n5 = n7;
                if (-1 == (n7 = string.indexOf(38, n7 + 1))) {
                    n7 = n2;
                }
            }
            if (!bl && n >= font.substringWidth(string, n4, n6 - n4)) continue;
            bl = false;
            if (n < font.substringWidth(string, n4, n5 - n4)) {
                while (n - 10 < font.substringWidth(string, n4, --n5 - n4)) {
                }
                stringArray[n3] = string.substring(n4, n5) + "-";
                --n5;
            } else {
                stringArray[n3] = string.substring(n4, n5);
            }
            ++n3;
            n4 = ++n5;
        } while (n5 < n2);
        String[] stringArray2 = new String[n3];
        System.arraycopy(stringArray, 0, stringArray2, 0, n3);
        return stringArray2;
    }

    public static int drawStringArray(Graphics graphics, int n, int n2, Font font, String[] stringArray, int n3, int n4, int n5) {
        int n6 = font.getHeight() + 1;
        int n7 = 0;
        while (n7 < stringArray.length) {
            if (n <= n4 && n4 < n2) {
                graphics.drawString(stringArray[n7], n3, n4, n5);
            }
            n4 += n6;
            ++n7;
        }
        return n4;
    }

    private int getKeyDirection(int n) {
        if (n == 53) {
            return 8;
        }
        if (n == 50) {
            return 1;
        }
        if (n == 56) {
            return 6;
        }
        if (n == 54) {
            return 5;
        }
        if (n == 52) {
            return 2;
        }
        if (n == -6) {
            return -6;
        }
        if (n == -7) {
            return -7;
        }
        if (n == -5) {
            return 8;
        }
        return this.getGameAction(n);
    }

    protected void drawHeader(Graphics graphics, String string) {
        int n = 0xFFFFFF;
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        int n2 = 10;
        while (n2 >= 0) {
            graphics.setColor(n);
            n -= 0x191900;
            graphics.fillRect(n2 * (this.SCREEN_WIDTH / 10), this.HEADER_HEIGHT - 7, (n2 + 1) * (this.SCREEN_WIDTH / 10), 7);
            --n2;
        }
        graphics.setColor(0);
        graphics.setFont(this.FONT_LARGE);
        graphics.drawString(string, this.SCREEN_WIDTH / 2, 0, 17);
    }

    protected void initialize() {
        int n = 0;
        while (n < 12) {
            this.board[n][0] = 2;
            ++n;
        }
        this.TILE_WIDTH = this.IMAGES[21].getWidth();
        this.TILE_HEIGHT = this.IMAGES[21].getHeight();
        this.BOARD_X = (this.SCREEN_WIDTH - 12 * this.TILE_WIDTH) / 2;
        this.BOARD_Y = 0;
        this.SCORE_Y = this.SCREEN_HEIGHT - this.FONT_SMALL.getHeight();
        this.INSTRUCTION_TEXT = SeedCanvas.getStringArray(this.FONT_MEDIUM, "left-arrow key&or number key 4& - Move left&right-arrow key&or number key 6& - Move right&up-arrow key&or number key 2& - Jump&fire key&or number key 5& - OK&& While dodging all the monsters, gather all the seeds lying around.& When the flower blooms, pick the flower to move to the next stage.& Get the leaf to freeze all monsters temporarily.", this.SCREEN_WIDTH - 12);
        this.DEMO_TEXT = SeedCanvas.getStringArray(this.FONT_MEDIUM, "This is a demo version. The full version is available from your carrier / operator.", this.SCREEN_WIDTH - 4);
        if (this.TILE_HEIGHT * 11 > this.SCORE_Y - this.IMAGES[31].getHeight()) {
            this.IMAGES[14] = null;
        }
    }

    private boolean waitForID(int n) {
        block4: {
            try {
                if (n < 32) {
                    this.IMAGES[n] = Image.createImage((String)("/image/" + (n + 100) + ".png"));
                    break block4;
                }
                if (n < 36) {
                    this.SOUNDS[n - 32] = new Sound(this.readFile("/sound/" + (n - 32) + ".ott", SOUND_SIZES[n - 32]), 1);
                    break block4;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++this.nCurrentIndex;
        return false;
    }

    private void playSound(int n) {
        if (this.byGameSetting[0] == 0) {
            try {
                this.currentSound = this.SOUNDS[n];
                this.currentSound.play(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopSound() {
        if (this.currentSound != null) {
            try {
                this.currentSound.stop();
                this.currentSound = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void vibrate(int n, int n2) {
        if (this.byGameSetting[1] == 0) {
            try {
                DeviceControl.startVibra((int)n, (long)n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void flashLights(long l) {
        if (this.byGameSetting[2] == 0) {
            try {
                this.flashLights(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setBacklight() {
        try {
            DeviceControl.setLights((int)0, (int)(this.byGameSetting[2] == 0 ? 100 : 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveDataUnexpectedly() {
        if (!this.noticeDestroy && this.nFlagStored != 0 && this.nLife > 0) {
            this.setDataStored(true);
            this.saveData();
        }
    }

    protected void setDataStored(boolean bl) {
        if (!bl) {
            this.nStage = 0;
            this.nScore = 0;
            this.nLife = 0;
            this.nFlagStored = 0;
        } else {
            this.nFlagStored = 1;
        }
        this.nStageStored = this.nStage;
        this.nScoreStored = this.nScore;
        this.nLifeStored = this.nLife;
    }

    protected void loadData() {
        try {
            this.rsData = RecordStore.openRecordStore((String)"glide", (boolean)true);
            if (this.rsData.getNumRecords() < 2) {
                this.putInt(this.byGameSetting, 0);
                int n = 0;
                while (n < 9) {
                    this.rsData.addRecord(this.byGameSetting, 0, this.byGameSetting.length);
                    ++n;
                }
            } else {
                this.byGameSetting = this.rsData.getRecord(1);
                this.nStageStored = this.getInt(this.rsData.getRecord(2));
                this.nScoreStored = this.getInt(this.rsData.getRecord(3));
                this.nLifeStored = this.getInt(this.rsData.getRecord(4));
                this.nFlagStored = this.getInt(this.rsData.getRecord(5));
                int n = 0;
                while (n < 4) {
                    this.nHighScore[n] = this.getInt(this.rsData.getRecord(6 + n));
                    ++n;
                }
            }
            this.rsData.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    protected void saveData() {
        try {
            this.rsData = RecordStore.openRecordStore((String)"glide", (boolean)true);
            byte[] byArray = new byte[4];
            this.rsData.setRecord(1, this.byGameSetting, 0, this.byGameSetting.length);
            this.putInt(byArray, this.nStageStored);
            this.rsData.setRecord(2, byArray, 0, byArray.length);
            this.putInt(byArray, this.nScoreStored);
            this.rsData.setRecord(3, byArray, 0, byArray.length);
            this.putInt(byArray, this.nLifeStored);
            this.rsData.setRecord(4, byArray, 0, byArray.length);
            this.putInt(byArray, this.nFlagStored);
            this.rsData.setRecord(5, byArray, 0, byArray.length);
            int n = 0;
            while (n < 4) {
                this.putInt(byArray, this.nHighScore[n]);
                this.rsData.setRecord(6 + n, byArray, 0, byArray.length);
                ++n;
            }
            this.rsData.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    protected void updateHighScore() {
        int n = 0;
        while (n < 4) {
            if (this.nHighScore[n] < this.nScore) {
                if (3 != n) {
                    int[] nArray = new int[3 - n];
                    System.arraycopy(this.nHighScore, n, nArray, 0, nArray.length);
                    System.arraycopy(nArray, 0, this.nHighScore, n + 1, nArray.length);
                }
                this.nHighScore[n] = this.nScore;
                this.nScore = 0;
                return;
            }
            ++n;
        }
    }

    private int getInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private void putInt(byte[] byArray, int n) {
        byArray[0] = (byte)(n >> 24 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n >> 0 & 0xFF);
    }

    protected void initializeSaveGame() {
        this.setDataStored(true);
        this.saveData();
        this.setCurrentState(1003);
    }

    protected void keyPressedSaveGame(int n) {
        if (n == 8 || n == -7 || n == -5) {
            this.setCurrentState(11);
        }
    }

    protected void paintSaveGame(Graphics graphics) {
        this.clearScreen(graphics, 0xCEFFFF);
        graphics.setColor(0);
        graphics.setFont(this.FONT_MEDIUM);
        this.drawText(graphics, "Save complete", this.SCREEN_WIDTH / 2, this.VIEW_HEIGHT / 2, 17, this.FONT_MEDIUM.getHeight());
    }

    protected void initializeSplash(int n) {
        if (n == 1 || n == 2) {
            this.lStopWatchStartTime = System.currentTimeMillis();
        }
        this.setCurrentState(n);
    }

    protected void keyPressedSplash() {
        if (this.nState == 1) {
            this.initializeSplash(2);
        } else if (this.nState == 2) {
            this.initializeSplash(1000);
        }
    }

    protected void runSplash() {
        if (this.nState == 1) {
            this.waitForID(this.nCurrentIndex);
            this.repaint();
            if (System.currentTimeMillis() - this.lStopWatchStartTime >= 3000L) {
                this.initializeSplash(2);
            }
        } else if (this.nState == 2) {
            this.waitForID(this.nCurrentIndex);
            this.repaint();
            if (System.currentTimeMillis() - this.lStopWatchStartTime >= 3000L) {
                this.initializeSplash(1000);
            }
        } else if (this.nState == 1000) {
            this.repaint();
            if (this.waitForID(this.nCurrentIndex)) {
                this.loadData();
                this.initialize();
                this.initializeTitle();
            }
        }
    }

    protected void paintSplash(Graphics graphics) {
        if (this.nState == 1) {
            this.clearScreen(graphics, 0);
            this.drawImageCenter(graphics, this.IMAGES[0]);
        } else if (this.nState == 2) {
            this.clearScreen(graphics, 0xFFFFFF);
            this.drawImageCenter(graphics, this.IMAGES[1]);
        } else if (this.nState == 1000) {
            this.paintLoading(graphics);
        }
    }

    private void paintLoading(Graphics graphics) {
        int n = this.SCREEN_WIDTH - 30;
        int n2 = this.nCurrentIndex * n / 35;
        if (n2 > n) {
            n2 = n;
        }
        this.drawAlert(graphics, this.SCREEN_HEIGHT, 45, "Loading...", 0xFFFFFF, 0xC0C0C0, 0, 0xFFFFFF, 0x404040);
        graphics.setColor(0x404040);
        graphics.fillRect((this.SCREEN_WIDTH - n) / 2 - 1, this.SCREEN_HEIGHT - 18, n + 2, 11);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect((this.SCREEN_WIDTH - n) / 2, this.SCREEN_HEIGHT - 17, n, 9);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect((this.SCREEN_WIDTH - n) / 2, this.SCREEN_HEIGHT - 17, n2, 9);
    }

    protected void initializeTitle() {
        this.nStage = 0;
        this.stopSound();
        this.playSound(0);
        this.repaint();
        this.setCurrentState(3);
    }

    protected void keyPressedTitle(int n) {
        if (n == -6) {
            this.initializeMenu();
        } else if (n == 8 || n == -7 || n == -5) {
            this.initializePlaying(true);
        }
    }

    private void paintTitle(Graphics graphics) {
        this.clearScreen(graphics, 0xCEFFFF);
        if (this.TILE_HEIGHT * 11 > this.VIEW_HEIGHT - 15) {
            this.drawBlockBorder(graphics, 12, 11);
            graphics.setClip(0, 0, this.SCREEN_WIDTH, this.VIEW_HEIGHT);
            if (this.IMAGES[20] != null) {
                graphics.drawImage(this.IMAGES[20], this.SCREEN_WIDTH / 2, this.TILE_HEIGHT, 0x10 | 1);
            }
            graphics.drawImage(this.IMAGES[15], this.SCREEN_WIDTH / 2, this.TILE_HEIGHT * 2, 0x10 | 1);
            graphics.drawImage(this.IMAGES[4], this.SCREEN_WIDTH / 2, this.TILE_HEIGHT * 10 - 3, 33);
        } else {
            if (this.IMAGES[20] != null) {
                graphics.drawImage(this.IMAGES[20], this.SCREEN_WIDTH / 2, this.TILE_HEIGHT, 0x10 | 4);
                graphics.drawImage(this.IMAGES[20], this.SCREEN_WIDTH / 2, this.TILE_HEIGHT, 0x10 | 8);
            }
            graphics.setColor(0xFFFF00);
            graphics.fillRect(this.BOARD_X, this.TILE_HEIGHT * 10, this.TILE_WIDTH * 12, this.TILE_HEIGHT * 2);
            graphics.setColor(0xCEFFFF);
            graphics.fillRect(0, 0, this.BOARD_X, this.SCREEN_HEIGHT);
            graphics.fillRect(this.BOARD_X + this.TILE_WIDTH * 12, 0, this.BOARD_X + 1, this.SCREEN_HEIGHT);
            this.drawBlockBorder(graphics, 12, 13);
            graphics.setClip(0, 0, this.SCREEN_WIDTH, this.VIEW_HEIGHT);
            graphics.drawImage(this.IMAGES[15], this.SCREEN_WIDTH / 2, this.TILE_HEIGHT * 2, 0x10 | 1);
            graphics.drawImage(this.IMAGES[4], this.SCREEN_WIDTH / 2, this.TILE_HEIGHT * 12 - 3, 33);
        }
    }

    protected void initializeMenu() {
        if (this.nMenuIndex > MENU_ITEMS.length - 1) {
            this.nMenuIndex = MENU_ITEMS.length - 1;
        } else if (this.nFlagStored == 0) {
            if (this.nMenuIndex < 1) {
                this.nMenuIndex = 1;
            }
        } else if (this.nMenuIndex < 0) {
            this.nMenuIndex = 0;
        }
        this.setCurrentState(4);
    }

    protected void keyPressedMenu(int n) {
        if (n == 1) {
            this.nMenuIndex = this.nMenuIndex > (this.nFlagStored == 0 ? 1 : 0) ? --this.nMenuIndex : MENU_ITEMS.length - 1;
            this.repaint();
        } else if (n == 6) {
            this.nMenuIndex = this.nMenuIndex < MENU_ITEMS.length - 1 ? ++this.nMenuIndex : (this.nFlagStored == 0 ? 1 : 0);
            this.repaint();
        } else if (n == 8 || n == -6) {
            this.doJob(MENU_ITEMS[this.nMenuIndex]);
        } else if (n == -7 || n == -5) {
            this.initializeTitle();
        }
        this.nKeyCode = n;
        this.repaint();
    }

    private void paintMenu(Graphics graphics) {
        this.paintTitle(graphics);
        if (this.nFlagStored == 0) {
            this.drawItems(graphics, MENU_ITEMS, this.nMenuIndex, 1, MENU_ITEMS.length - 1, 0xCEFFFF, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF, -1);
        } else {
            this.drawItems(graphics, MENU_ITEMS, this.nMenuIndex, 0, MENU_ITEMS.length, 0xCEFFFF, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF, -1);
        }
    }

    protected void initializeMode() {
        this.nModeIndex = 0;
        this.setCurrentState(5);
    }

    protected void keyPressedMode(int n) {
        if (n == 1 || n == 6) {
            this.nModeIndex = this.nModeIndex != 0 ? 0 : 1;
            this.repaint();
        } else if (n == 8 || n == -6) {
            this.initializePlaying(this.nModeIndex == 0);
        } else if (n == -7 || n == -5) {
            this.goPreviousState();
        }
    }

    private void paintMode(Graphics graphics) {
        this.clearScreen(graphics, 0xCEFFFF);
        this.drawItems(graphics, Text.MODE_ITEMS, this.nModeIndex, 0, Text.MODE_ITEMS.length, 0xCEFFFF, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF, -1);
    }

    protected void initializePause() {
        if (this.nPauseIndex > PAUSE_ITEMS.length - 1) {
            this.nPauseIndex = PAUSE_ITEMS.length - 1;
        } else if (this.nLife == 0) {
            if (this.nPauseIndex < 1) {
                this.nPauseIndex = 1;
            }
        } else if (this.nPauseIndex < 0) {
            this.nPauseIndex = 0;
        }
        this.setCurrentState(12);
    }

    protected void keyPressedPause(int n) {
        if (n == 1) {
            this.nPauseIndex = this.nPauseIndex > (this.nLife != 0 ? 0 : 1) ? --this.nPauseIndex : PAUSE_ITEMS.length - 1;
            this.repaint();
        } else if (n == 6) {
            this.nPauseIndex = this.nPauseIndex < PAUSE_ITEMS.length - 1 ? ++this.nPauseIndex : (this.nLife != 0 ? 0 : 1);
            this.repaint();
        } else if (n == 8 || n == -6) {
            this.doJob(PAUSE_ITEMS[this.nPauseIndex]);
        } else if (n == -7 || n == -5) {
            this.setCurrentState(11);
        }
    }

    private void paintPause(Graphics graphics) {
        if (this.nLife != 0) {
            this.drawItems(graphics, PAUSE_ITEMS, this.nPauseIndex, 0, PAUSE_ITEMS.length, 0xCEFFFF, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF, -1);
        } else {
            this.drawItems(graphics, PAUSE_ITEMS, this.nPauseIndex, 1, PAUSE_ITEMS.length - 1, 0xCEFFFF, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF, -1);
        }
    }

    protected void initializeInstruction() {
        this.nInstructionIndex = 0;
        this.setCurrentState(6);
    }

    protected void keyPressedInstruction(int n) {
        int n2 = (this.VIEW_HEIGHT - 20) / (this.FONT_MEDIUM.getHeight() + 1);
        if (n == 1 && this.nInstructionIndex > 0) {
            --this.nInstructionIndex;
            this.repaint();
        } else if (n == 6 && this.nInstructionIndex < this.INSTRUCTION_TEXT.length - n2) {
            ++this.nInstructionIndex;
            this.repaint();
        } else if (n == -7 || n == -5 || n == 8) {
            this.goPreviousState();
        }
    }

    private void paintInstruction(Graphics graphics) {
        int n = this.nInstructionIndex * (this.FONT_MEDIUM.getHeight() + 1);
        int n2 = (this.VIEW_HEIGHT - 20) / this.FONT_MEDIUM.getHeight();
        this.clearScreen(graphics, 0xCEFFFF);
        graphics.setFont(this.FONT_MEDIUM);
        this.drawScrollBar(graphics, this.VIEW_HEIGHT, 8, this.nInstructionIndex, this.nInstructionIndex + n2, this.INSTRUCTION_TEXT.length, 0, 0xC0C0C0, 255);
        graphics.setColor(0xFF0000);
        graphics.drawString("Instructions", this.SCREEN_WIDTH / 2, 4 - n, 17);
        graphics.setColor(0);
        graphics.setClip(0, 0, this.SCREEN_WIDTH - 10, this.VIEW_HEIGHT);
        SeedCanvas.drawStringArray(graphics, 0, this.VIEW_HEIGHT, this.FONT_MEDIUM, this.INSTRUCTION_TEXT, 2, 20 - n, 20);
    }

    protected void initializeScore() {
        this.setCurrentState(8);
    }

    protected void keyPressedScore(int n) {
        if (n == -7 || n == -5 || n == 8) {
            this.goPreviousState();
        }
    }

    protected void paintScore(Graphics graphics) {
        int n = this.FONT_MEDIUM.getHeight() + this.FONT_SMALL.getHeight() + 1;
        this.clearScreen(graphics, 0xCEFFFF);
        graphics.setColor(0);
        graphics.drawLine(20, this.HEADER_HEIGHT, 20, this.VIEW_HEIGHT - 2);
        graphics.drawLine(20, this.VIEW_HEIGHT - 2, this.getWidth(), this.VIEW_HEIGHT - 2);
        int n2 = 0;
        while (n2 < 4) {
            if (this.HEADER_HEIGHT + (n2 + 1) * n < this.VIEW_HEIGHT) {
                graphics.setFont(this.FONT_MEDIUM);
                graphics.drawString(String.valueOf(n2 + 1), 16, this.HEADER_HEIGHT + 1 + n2 * n, 24);
                graphics.drawString("Player", 26, this.HEADER_HEIGHT + 1 + n2 * n, 20);
                graphics.setFont(this.FONT_SMALL);
                graphics.drawString(this.nHighScore[n2] + " " + "points", 30, this.HEADER_HEIGHT + n2 * n + this.FONT_MEDIUM.getHeight(), 20);
            }
            ++n2;
        }
        this.drawHeader(graphics, "Score");
    }

    protected void initializeGameOver() {
        this.setCurrentState(10);
    }

    protected void keyPressedGameOver(int n) {
        if (n == -6 || n == 8) {
            this.initializeTitle();
        } else if (n == -7 || n == -5) {
            this.initializePlaying(this.bEasyMode);
        }
    }

    protected void paintGameOver(Graphics graphics) {
        this.drawAlert(graphics, this.VIEW_HEIGHT, this.FONT_MEDIUM.getHeight() * 2 + 10, "High Score: " + this.nHighScore[0] + "&" + "Your Score" + ": " + this.nScore, 0xCEFFFF, 0xC0C0C0, 0, 0xFFFF00, 0);
    }

    protected void initializeSettings() {
        this.setCurrentState(7);
    }

    protected void changeSetting() {
        this.byGameSetting[this.nSettingIndex] = (byte)((this.byGameSetting[this.nSettingIndex] + 1) % 2);
        this.repaint();
    }

    protected void keyPressedSetup(int n) {
        if (n == -6 || n == 8) {
            this.changeSetting();
        }
        if (n == -7 || n == -5) {
            this.goPreviousState();
        } else {
            switch (n) {
                case 1: {
                    if (this.nSettingIndex <= 0) break;
                    --this.nSettingIndex;
                    this.repaint();
                    break;
                }
                case 6: {
                    if (this.nSettingIndex >= 1) break;
                    ++this.nSettingIndex;
                    this.repaint();
                }
            }
        }
    }

    protected void paintSettings(Graphics graphics) {
        int n = this.FONT_LARGE.getHeight() + this.FONT_MEDIUM.getHeight() + 7;
        this.clearScreen(graphics, 0xCEFFFF);
        graphics.setColor(0);
        graphics.drawLine(5, this.HEADER_HEIGHT, 5, this.HEADER_HEIGHT + n * 2);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(2, this.HEADER_HEIGHT + 2 + this.nSettingIndex * n, this.SCREEN_WIDTH - 3, n - 2);
        graphics.setColor(0x8080FF);
        graphics.fillRect(1, this.HEADER_HEIGHT + 1 + this.nSettingIndex * n, this.SCREEN_WIDTH - 3, n - 2);
        int n2 = 0;
        while (n2 < 2) {
            graphics.setColor(0);
            graphics.drawLine(5, this.HEADER_HEIGHT + n * (n2 + 1), this.SCREEN_WIDTH, this.HEADER_HEIGHT + n * (n2 + 1));
            graphics.setFont(this.FONT_LARGE);
            graphics.drawString(Text.SETTING_ITEMS[n2], 20, this.HEADER_HEIGHT + 2 + n * n2, 20);
            graphics.setColor(0x404040);
            graphics.fillRect(this.SCREEN_WIDTH / 3 - 4, this.HEADER_HEIGHT + 3 + this.FONT_LARGE.getHeight() + n * n2, this.SCREEN_WIDTH * 2 / 3, this.FONT_MEDIUM.getHeight());
            graphics.setFont(this.FONT_MEDIUM);
            graphics.setColor(0xC0C0C0);
            graphics.drawString(Text.SWITCH_ITEMS[this.byGameSetting[n2] % 2], this.SCREEN_WIDTH * 2 / 3 - 4, this.HEADER_HEIGHT + 4 + this.FONT_LARGE.getHeight() + n * n2, 17);
            ++n2;
        }
        this.drawHeader(graphics, "Settings");
    }

    protected void initializeAbout() {
        this.setCurrentState(9);
    }

    protected void keyPressedAbout(int n) {
        if (n == -7 || n == -5 || n == 8) {
            this.goPreviousState();
        }
    }

    protected void paintAbout(Graphics graphics) {
        int n = this.FONT_MEDIUM.getHeight() + this.FONT_SMALL.getHeight() + 1;
        this.clearScreen(graphics, 0xFFFFFF);
        this.drawImageCenter(graphics, this.IMAGES[2], 0, (this.VIEW_HEIGHT - this.SCREEN_HEIGHT) / 2);
        this.drawHeader(graphics, "About");
    }

    private void initializePlaying(boolean bl) {
        this.bEasyMode = bl;
        if (!this.bContinueGame || this.nStageStored < 0 || this.nScoreStored < 5 || this.nLifeStored < 0) {
            this.nScore = 0;
            this.nLife = 5;
            this.nStage = this.bEasyMode ? 0 : STAGE_DATA.length / 2;
        } else {
            this.nStage = 0 < this.nStageStored && this.nStageStored < STAGE_DATA.length ? this.nStageStored : 0;
            this.nScore = this.nScoreStored;
            this.nLife = this.nLifeStored;
        }
        this.initializeStage();
        this.setCurrentState(11);
    }

    private void initializeStage() {
        this.bUpdatingScreen = true;
        this.nKeyState = 0;
        this.nRunState = 0;
        this.nMonkeyFrozenTime = 0;
        this.nMonkeyCount = 0;
        this.nNormalSeedCount = 0;
        this.nDandelionState = 0;
        this.nDandelionPosition[3] = 0;
        int n = 0;
        while (n < 6) {
            this.nMonkeyState[n] = 0;
            this.nMonkeyPosition[n][3] = 0;
            ++n;
        }
        this.nAnimationIndex = 0;
        int n2 = 0;
        while (n2 < 11) {
            int n3 = 0;
            while (n3 < 12) {
                switch (STAGE_DATA[this.nStage].charAt(n3 + 12 * n2)) {
                    case '1': {
                        this.board[n3][n2] = 1;
                        break;
                    }
                    case '2': {
                        this.board[n3][n2] = 2;
                        break;
                    }
                    case '3': {
                        this.board[n3][n2] = 0;
                        this.nDandelionPosition[0] = n3;
                        this.nDandelionPosition[1] = n2;
                        this.nDandelionPreviousPosition[0] = n3;
                        this.nDandelionPreviousPosition[1] = n2;
                        break;
                    }
                    case '4': {
                        this.board[n3][n2] = 0;
                        if (this.nMonkeyCount >= 6) break;
                        this.nMonkeyPosition[this.nMonkeyCount][0] = n3;
                        this.nMonkeyPosition[this.nMonkeyCount][1] = n2;
                        this.nMonkeyPreviousPosition[this.nMonkeyCount][0] = n3;
                        this.nMonkeyPreviousPosition[this.nMonkeyCount][1] = n2;
                        ++this.nMonkeyCount;
                        break;
                    }
                    case '5': {
                        this.board[n3][n2] = 3;
                        ++this.nNormalSeedCount;
                        break;
                    }
                    case '6': {
                        this.board[n3][n2] = 4;
                        this.nGoldenSeedPosition[0] = n3;
                        this.nGoldenSeedPosition[1] = n2;
                        break;
                    }
                    case '7': {
                        this.board[n3][n2] = 0;
                        this.nFlowerPosition[0] = n3;
                        this.nFlowerPosition[1] = n2;
                        break;
                    }
                    default: {
                        this.board[n3][n2] = 0;
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    protected void keyPressedPlaying(int n) {
        if (n == -7 || n == -5) {
            this.setCurrentState(12);
        } else {
            this.nKeyCode = n;
            this.nKeyState = 1;
        }
    }

    private void runPlaying() {
        while (this.nState == 11) {
            if (this.nAnimationIndex != 0) {
                --this.nAnimationIndex;
            }
            this.lStopWatchStartTime = System.currentTimeMillis();
            if (this.nRunState == 1) {
                this.moveDandelion();
                if (!this.checkDead()) {
                    int n;
                    if (this.nMonkeyFrozenTime != 0) {
                        --this.nMonkeyFrozenTime;
                        n = 0;
                        while (n < this.nMonkeyCount) {
                            this.nMonkeyPosition[n][3] = 0;
                            this.move(this.nMonkeyPosition[n], this.nMonkeyPreviousPosition[n]);
                            ++n;
                        }
                    } else {
                        n = 0;
                        while (n < this.nMonkeyCount) {
                            this.moveMonkey(n);
                            ++n;
                        }
                    }
                    if (!this.checkDead()) {
                        this.checkClearStage();
                    }
                } else {
                    this.playSound(2);
                }
            } else if ((this.nKeyState == 1 || this.nKeyState == 2) && this.nKeyCode == 8) {
                this.bUpdatingScreen = true;
                if (this.nRunState == 0) {
                    this.nRunState = 1;
                } else if (this.nRunState == 4) {
                    this.retry();
                } else if (this.nRunState == 5) {
                    this.setCurrentState(3);
                } else if (this.nRunState == 2) {
                    this.goNextStage();
                } else if (this.nRunState == 3) {
                    this.setCurrentState(3);
                }
            }
            this.keyReset();
            this.repaint();
            this.lSleepingTime = 250L - (System.currentTimeMillis() - this.lStopWatchStartTime);
            if (this.lSleepingTime <= 0L) continue;
            this.sleep((int)this.lSleepingTime);
        }
    }

    protected void paintPlaying(Graphics graphics) {
        if (this.bUpdatingScreen) {
            this.bUpdatingScreen = false;
            this.showPlaying(graphics);
        }
        if (this.nRunState == 1) {
            if (this.nDandelionPosition[2] == 2) {
                this.drawTile(graphics, this.nDandelionPreviousPosition[0], this.nDandelionPreviousPosition[1] - 1);
            }
            if (this.nDandelionPreviousPosition[0] != this.nDandelionPosition[0] || this.nDandelionPreviousPosition[1] != this.nDandelionPosition[1]) {
                this.drawTile(graphics, this.nDandelionPreviousPosition[0], this.nDandelionPreviousPosition[1]);
            }
            int n = 0;
            while (n < this.nMonkeyCount) {
                if (this.nMonkeyPreviousPosition[0] != this.nMonkeyPosition[0] || this.nMonkeyPreviousPosition[1] != this.nMonkeyPosition[1]) {
                    this.drawTile(graphics, this.nMonkeyPreviousPosition[n][0], this.nMonkeyPreviousPosition[n][1]);
                }
                ++n;
            }
            this.drawFlower(graphics);
            this.drawDandelion(graphics);
            int n2 = 0;
            while (n2 < this.nMonkeyCount) {
                this.drawMonkey(graphics, n2);
                ++n2;
            }
            this.drawScore(graphics);
        } else if (this.nRunState == 0) {
            this.drawDandelion(graphics);
            this.drawReady(graphics);
        } else if (this.nRunState == 4) {
            int n = 0;
            while (n < this.nMonkeyCount) {
                this.drawMonkey(graphics, n);
                ++n;
            }
            this.drawDandelion(graphics);
        } else if (this.nRunState == 5) {
            this.drawGameOver(graphics);
        } else if (this.nRunState == 2) {
            this.drawStageClear(graphics);
        } else if (this.nRunState == 3) {
            this.drawAllStageClear(graphics);
        }
    }

    private void showPlaying(Graphics graphics) {
        int n;
        graphics.setColor(0xFFFFFF);
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        int n2 = 0;
        while (n2 < 11) {
            n = 0;
            while (n < 12) {
                this.drawTile(graphics, n, n2);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < this.nMonkeyCount) {
            this.drawMonkey(graphics, n);
            ++n;
        }
        this.drawScoreBoard(graphics);
    }

    private void retry() {
        --this.nLife;
        this.initializeStage();
    }

    private void goNextStage() {
        ++this.nStage;
        this.initializeStage();
    }

    private boolean checkDead() {
        int n = 0;
        while (n < this.nMonkeyCount) {
            if (this.nDandelionPosition[0] == this.nMonkeyPosition[n][0] && this.nDandelionPosition[1] == this.nMonkeyPosition[n][1]) {
                this.bUpdatingScreen = true;
                this.nDandelionState = 2;
                this.nRunState = this.nLife > 0 ? 4 : 5;
                this.nAnimationIndex = 3;
                this.vibrate(50, 100);
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean checkClearStage() {
        if (this.nNormalSeedCount == 0 && this.nDandelionPosition[0] == this.nFlowerPosition[0] && this.nDandelionPosition[1] == this.nFlowerPosition[1]) {
            this.bUpdatingScreen = true;
            this.nScore += 100;
            this.playSound(1);
            if (this.nScore / 100 % 5 == 0) {
                ++this.nLife;
            }
            this.nRunState = this.nStage < STAGE_DATA.length - 1 ? 2 : 3;
            this.nAnimationIndex = 3;
            return true;
        }
        return false;
    }

    private int getDir(int n) {
        if (n == 2) {
            return 2;
        }
        if (n == 5) {
            return 3;
        }
        if (n == 1) {
            return 1;
        }
        return 0;
    }

    private void glean() {
        this.nCurrentTile = this.board[this.nDandelionPosition[0]][this.nDandelionPosition[1]];
        if (this.nCurrentTile == 3) {
            this.playSound(3);
            this.board[this.nDandelionPosition[0]][this.nDandelionPosition[1]] = 0;
            --this.nNormalSeedCount;
            ++this.nScore;
            if (this.nNormalSeedCount == 0) {
                this.nAnimationIndex = this.IMAGES[6] != null ? 3 : 0;
            }
        } else if (this.nCurrentTile == 4) {
            this.vibrate(50, 100);
            this.board[this.nDandelionPosition[0]][this.nDandelionPosition[1]] = 0;
            this.nMonkeyFrozenTime = 35;
            this.nScore += 10;
        } else if (this.nCurrentTile == 5) {
            // empty if block
        }
    }

    private void move(int[] nArray, int[] nArray2) {
        if (nArray[2] != 0) {
            if (nArray[2] < 2) {
                this.nCurrentTile = this.board[nArray[0]][nArray[1] - 1];
                if (this.nCurrentTile != 2 && this.nCurrentTile != 1) {
                    nArray[1] = nArray[1] - 1;
                    nArray[2] = nArray[2] + 1;
                } else {
                    nArray[2] = 0;
                }
                nArray[3] = 1;
            } else {
                nArray[2] = 0;
                nArray[3] = 0;
            }
        } else {
            this.nCurrentTile = this.board[nArray[0]][nArray[1] + 1];
            if (this.nCurrentTile != 2 && this.nCurrentTile != 1) {
                nArray2[0] = nArray[0];
                nArray2[1] = nArray[1];
                nArray[3] = 0;
                nArray[1] = nArray[1] + 1;
            }
        }
    }

    private boolean control(int[] nArray, int[] nArray2, int n) {
        nArray[3] = n;
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        if (n == 2) {
            nArray[0] = nArray[0] - 1;
            nArray[2] = 0;
        } else if (n == 3) {
            nArray[0] = nArray[0] + 1;
            nArray[2] = 0;
        } else if (n == 1) {
            if (nArray[2] == 0) {
                this.nCurrentTile = this.board[nArray[0]][nArray[1] + 1];
                if (this.nCurrentTile == 2 || this.nCurrentTile == 1) {
                    if (this.board[nArray[0]][nArray[1] - 1] == 2) {
                        return false;
                    }
                    nArray[1] = nArray[1] - 1;
                    nArray[2] = 1;
                }
                return true;
            }
            return false;
        }
        this.nCurrentTile = this.board[nArray[0]][nArray[1]];
        if (this.nCurrentTile == 2 || this.nCurrentTile == 1 && n != 1) {
            nArray[0] = nArray2[0];
            nArray[1] = nArray2[1];
            return false;
        }
        return true;
    }

    private void moveDandelion() {
        if (this.nKeyCode != 0) {
            if (!this.control(this.nDandelionPosition, this.nDandelionPreviousPosition, this.getDir(this.nKeyCode))) {
                this.move(this.nDandelionPosition, this.nDandelionPreviousPosition);
            } else if (this.nKeyCode == 1 && !this.checkDead() && !this.checkClearStage()) {
                this.glean();
                this.move(this.nDandelionPosition, this.nDandelionPreviousPosition);
            }
        } else {
            this.move(this.nDandelionPosition, this.nDandelionPreviousPosition);
        }
        this.glean();
    }

    private void moveMonkey(int n) {
        this.nMaintainIndex = 0;
        this.nCurrentTile = this.board[this.nMonkeyPosition[n][0]][this.nMonkeyPosition[n][1] + 1];
        if (this.nCurrentTile == 1 || this.nCurrentTile == 2) {
            if (Math.abs(this.random.nextInt() % 100) < 50) {
                if (this.nMonkeyPosition[n][1] == this.nDandelionPosition[1]) {
                    if (this.nMonkeyPosition[n][0] > this.nDandelionPosition[0]) {
                        this.nCurrentTile = this.board[this.nMonkeyPosition[n][0] - 1][this.nMonkeyPosition[n][1]];
                        this.nMaintainIndex = this.nCurrentTile == 2 ? 3 : 2;
                    } else if (this.nMonkeyPosition[n][0] < this.nDandelionPosition[0]) {
                        this.nCurrentTile = this.board[this.nMonkeyPosition[n][0] + 1][this.nMonkeyPosition[n][1]];
                        this.nMaintainIndex = this.nCurrentTile == 2 ? 2 : 3;
                    }
                } else if (this.nMonkeyPosition[n][1] > this.nDandelionPosition[1]) {
                    this.nCurrentTile = this.board[this.nMonkeyPosition[n][0]][this.nMonkeyPosition[n][1] - 1];
                    if (this.nCurrentTile == 1) {
                        this.nMaintainIndex = 1;
                    } else {
                        this.nCurrentTile = this.board[this.nMonkeyPosition[n][0]][this.nMonkeyPosition[n][1] + 1];
                        if (this.nCurrentTile == 2 && this.nMonkeyState[n] != 1) {
                            if (this.nMonkeyPosition[n][0] < this.nDandelionPosition[0]) {
                                if (this.nMonkeyPosition[n][0] == 1) {
                                    this.nMonkeyState[n] = 1;
                                }
                                this.nMaintainIndex = 2;
                            } else if (this.nMonkeyPosition[n][0] > this.nDandelionPosition[0]) {
                                if (this.nMonkeyPosition[n][0] == 10) {
                                    this.nMonkeyState[n] = 1;
                                }
                                this.nMaintainIndex = 3;
                            } else {
                                this.nMaintainIndex = Math.abs(this.random.nextInt() % 100) < 50 ? 2 : 3;
                            }
                        } else {
                            this.nMaintainIndex = this.nMonkeyPosition[n][0] > this.nDandelionPosition[0] ? 2 : (this.nMonkeyPosition[n][0] < this.nDandelionPosition[0] ? 3 : (Math.abs(this.random.nextInt() % 100) < 50 ? 2 : 3));
                        }
                    }
                } else if (this.nMonkeyPosition[n][1] < this.nDandelionPosition[1]) {
                    if (this.nMonkeyPosition[n][3] == 2 || this.nMonkeyPosition[n][3] == 3) {
                        this.nMaintainIndex = this.nMonkeyPosition[n][3];
                    } else {
                        int n2 = this.nMaintainIndex = Math.abs(this.random.nextInt() % 100) < 50 ? 2 : 3;
                    }
                }
            }
            if (!this.control(this.nMonkeyPosition[n], this.nMonkeyPreviousPosition[n], this.nMaintainIndex)) {
                this.move(this.nMonkeyPosition[n], this.nMonkeyPreviousPosition[n]);
            } else if (this.nMaintainIndex == 1 && !this.checkDead()) {
                this.move(this.nMonkeyPosition[n], this.nMonkeyPreviousPosition[n]);
            }
        } else {
            this.move(this.nMonkeyPosition[n], this.nMonkeyPreviousPosition[n]);
        }
    }

    private void drawBlockBorder(Graphics graphics, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.drawTileWithType(graphics, 0, n3, 2);
            this.drawTileWithType(graphics, n - 1, n3, 2);
            ++n3;
        }
        int n4 = 1;
        while (n4 < n - 1) {
            this.drawTileWithType(graphics, n4, 0, 2);
            this.drawTileWithType(graphics, n4, n2 - 1, 2);
            ++n4;
        }
    }

    private void drawScoreBoard(Graphics graphics) {
        this.drawScore(graphics);
        if (this.IMAGES[14] != null) {
            int n = this.nStage;
            int n2 = 3;
            while (n > 10) {
                graphics.drawImage(this.IMAGES[31], n2, this.SCORE_Y - 2, 36);
                n2 += 16;
                n -= 10;
            }
            int n3 = 0;
            while (n3 < n) {
                graphics.drawImage(this.IMAGES[14], n2, this.SCORE_Y - 2, 36);
                n2 += 10;
                ++n3;
            }
        }
    }

    private void drawScore(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.fillRect(0, this.SCORE_Y, this.SCREEN_WIDTH, 2 + this.FONT_SMALL.getHeight());
        graphics.setColor(0x101010);
        graphics.setFont(this.FONT_SMALL);
        graphics.drawString("Lives:" + this.nLife, this.SCREEN_WIDTH - 2, this.SCORE_Y, 24);
        graphics.drawString("Score: " + String.valueOf(this.nScore), 2, this.SCORE_Y, 20);
    }

    private void drawReady(Graphics graphics) {
        graphics.setFont(this.FONT_LARGE);
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT - 10);
        SeedCanvas.drawOutlineString(graphics, "STAGE " + (this.nStage + 1), this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2, 17, 16753152, 0xFF0000);
    }

    private void drawTileWithType(Graphics graphics, int n, int n2, int n3) {
        graphics.drawImage(this.IMAGES[26], n * this.TILE_WIDTH + this.BOARD_X, n2 * this.TILE_WIDTH + this.BOARD_Y, 20);
        graphics.drawImage(this.IMAGES[26 + n3], n * this.TILE_WIDTH + this.BOARD_X, n2 * this.TILE_WIDTH + this.BOARD_Y, 20);
    }

    private void drawTile(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.IMAGES[26], n * this.TILE_WIDTH + this.BOARD_X, n2 * this.TILE_WIDTH + this.BOARD_Y, 20);
        graphics.drawImage(this.IMAGES[26 + this.board[n][n2]], n * this.TILE_WIDTH + this.BOARD_X, n2 * this.TILE_WIDTH + this.BOARD_Y, 20);
    }

    private void drawDandelion(Graphics graphics) {
        graphics.drawImage(this.IMAGES[21 + this.nDandelionPosition[3]], this.nDandelionPosition[0] * this.TILE_WIDTH + this.BOARD_X, this.nDandelionPosition[1] * this.TILE_HEIGHT + this.BOARD_Y, 20);
        if (this.nDandelionState == 2) {
            graphics.drawImage(this.IMAGES[5], this.nDandelionPosition[0] * this.TILE_WIDTH + this.BOARD_X + this.TILE_WIDTH, this.nDandelionPosition[1] * this.TILE_HEIGHT + this.BOARD_Y + 6 - this.nAnimationIndex * 2, 24);
        }
    }

    private void drawMonkey(Graphics graphics, int n) {
        graphics.drawImage(this.IMAGES[16 + this.nMonkeyPosition[n][3]], this.nMonkeyPosition[n][0] * this.TILE_WIDTH + this.BOARD_X, this.nMonkeyPosition[n][1] * this.TILE_HEIGHT + this.BOARD_Y, 20);
    }

    private void drawFlower(Graphics graphics) {
        if (this.nNormalSeedCount == 0) {
            if (this.nAnimationIndex == 0 || this.IMAGES[6] == null) {
                graphics.drawImage(this.IMAGES[31], this.nFlowerPosition[0] * this.TILE_WIDTH + this.BOARD_X, this.nFlowerPosition[1] * this.TILE_HEIGHT + this.BOARD_Y, 20);
            } else {
                graphics.drawImage(this.IMAGES[9 - this.nAnimationIndex], this.nFlowerPosition[0] * this.TILE_WIDTH + this.BOARD_X, this.nFlowerPosition[1] * this.TILE_HEIGHT + this.BOARD_Y, 20);
            }
        }
    }

    private void drawBigFlower(Graphics graphics) {
        graphics.drawImage(this.IMAGES[13 - this.nAnimationIndex], this.nFlowerPosition[0] * this.TILE_WIDTH + this.BOARD_X + this.TILE_WIDTH / 2, this.nFlowerPosition[1] * this.TILE_HEIGHT + this.BOARD_Y + this.TILE_HEIGHT, 33);
    }

    private void drawStageClear(Graphics graphics) {
        this.drawBigFlower(graphics);
        if (this.nAnimationIndex == 0) {
            graphics.setFont(this.FONT_LARGE);
            SeedCanvas.drawOutlineString(graphics, "STAGE CLEAR", this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2, 1 | 0x10, 0xFFFF00, 0xFF0000);
        }
    }

    private void drawAllStageClear(Graphics graphics) {
        this.drawBigFlower(graphics);
        if (this.nAnimationIndex == 0) {
            graphics.setFont(this.FONT_LARGE);
            SeedCanvas.drawOutlineString(graphics, "ALL STAGE", this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2 - this.FONT_LARGE.getHeight(), 1 | 0x10, 0xFFFF00, 0xFF0000);
            SeedCanvas.drawOutlineString(graphics, "CLEAR", this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2, 1 | 0x10, 0xFFFF00, 0xFF0000);
        }
    }

    private void drawGameOver(Graphics graphics) {
        int n = 0;
        while (n < this.nMonkeyCount) {
            this.drawMonkey(graphics, n);
            ++n;
        }
        this.drawDandelion(graphics);
        if (this.nAnimationIndex == 0) {
            graphics.setFont(this.FONT_LARGE);
            SeedCanvas.drawOutlineString(graphics, "GAME OVER", this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2, 1 | 0x10, 0xFFFF00, 0xFF0000);
        }
    }
}

