/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

class SnCanvas
extends Canvas
implements Runnable,
CommandListener {
    private SnApp app;
    private Thread MyThread = null;
    private Random MyRandom = null;
    private Font LFont = null;
    private Font SFont = null;
    public static final int _UP = 1;
    public static final int _RIGHT = 2;
    public static final int _DOWN = 4;
    public static final int _LEFT = 8;
    public static final int _STOP = 16;
    protected int nState;
    protected int nStatePre;
    protected static final int GAME_INIT = 0;
    protected static final int GAME_TITLE = 1;
    protected static final int GAME_MENU = 2;
    protected static final int GAME_PLAY = 11;
    protected static final int GAME_ABOUT = 12;
    protected static final int GAME_HELP = 13;
    protected static final int GAME_SCORE = 14;
    protected static final int GAME_EXIT = 15;
    protected static final int GAME_CLEAR = 21;
    protected static final int GAME_DIE = 22;
    protected static final int GAME_OVER = 23;
    protected static final int GAME_PAUSE = 31;
    protected static final int GAME_RESTART = 32;
    protected static final int GAME_STOP = 33;
    protected static final int GAME_WAIT = 34;
    protected static final int GAME_EXPIRED = 35;
    private int nSelect;
    private static final String[] STR_MENU = new String[]{"PLAY", "HELP", "SCORE", "EXIT"};
    private final int BOARD_X;
    private final int BOARD_Y;
    private final int BOARD_WIDTH;
    private final int BOARD_HEIGHT;
    private final int BOARD_TILE;
    private final int MAX_ROUTE;
    private boolean bSound = true;
    private int nScore;
    private int nSecond = 0;
    private int nMinute = 0;
    private int nHighScore;
    private int nLevel;
    private long nSTime;
    private long nLTime;
    private long nCTime;
    private int nTime;
    private int nCount;
    private int nHeadX;
    private int nHeadY;
    private int nTailX;
    private int nTailY;
    private int nHeadX2;
    private int nHeadY2;
    private int nTailX2;
    private int nTailY2;
    private int nTail;
    private int nDirection;
    private int nLength;
    private int nRouteIndex;
    private int[] nRouteX;
    private int[] nRouteY;
    private int nEatCnt;
    private boolean bEat;
    private int nBeanMax;
    private int nBeanCnt;
    private int nBeanTotal;
    private int[] nBeanX;
    private int[] nBeanY;
    private int nStoneMax;
    private int[] nStoneX;
    private int[] nStoneY;
    private Image imgLoading1;
    private Image imgLoading2;
    private Image imgCopyright;
    private Image imgArrow;
    private Image imgBlood;
    private Image imgEgg;
    private Image imgItem;
    private Image imgMessage;
    private Image imgPlay1;
    private Image imgPlay2;
    private Image imgScore;
    private Image imgSnake;
    private Image imgTitle1;
    private Image imgTitle2;
    private Image imgWindow;
    private Image imgKey;
    private Image imgSound;
    private static final int NUM_AD = 3;
    private int nKeyCode;
    private boolean bKeyUsed;
    private static final int NUM_ABOUT = 13;
    private static final String[] about = new String[]{"     SNAKE", " ", "  \uc8fc\uc2dd\ud68c\uc0ac \ucef4\ud22c\uc2a4", "  www.com2us.com", "\ubaa8\ubc14\uc77c\uc11c\ube44\uc2a4\uac1c\ubc1c1\ud300", " ", "   080-437-2399", " www.phonegame.net", " ", "\uc811\uc18d\uc744 \ub204\ub974\uba74 ez-i", "\uc5d0\uc11c \ub2e4\ub978 \uac8c\uc784\ub4e4\uc744", "\uc990\uae30\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4", "* \ud1b5\ud654\uc694\uae08 \uc720\ub8cc"};
    private int nAbout;
    private Display display;
    private Command cmdStart = new Command("Menu", 4, 1);
    private Command cmdExit = new Command("Exit", 4, 11);
    private Command cmdTitle = new Command("Title", 4, 10);
    private Command cmdPause = new Command("Pause", 4, 0);
    private Command cmdRestart = new Command("Resume", 4, 0);
    private Command cmdOk = new Command("YES", 4, 1);
    private Command cmdCancel = new Command("NO", 4, 9);
    private Command cmdPlay = new Command("Start", 4, 0);
    private Command cmdInvoke = new Command("Conn", 4, 4);
    private Command cmdNext = new Command("Next", 4, 1);
    private boolean bCommand = false;
    private RecordStore rcData1 = null;
    private RecordStore rcData2 = null;

    public SnCanvas(SnApp snApp) {
        this.BOARD_X = 7;
        this.BOARD_Y = 14;
        this.BOARD_WIDTH = 15;
        this.BOARD_HEIGHT = 14;
        this.BOARD_TILE = 7;
        this.MAX_ROUTE = 30;
        this.app = snApp;
    }

    protected void showNotify() {
        if (this.MyThread == null) {
            this.setCommandListener(this);
            this.MyRandom = new Random();
            this.LFont = Font.getFont((int)0, (int)0, (int)16);
            this.SFont = Font.getFont((int)0, (int)0, (int)8);
            this.nRouteX = new int[30];
            this.nRouteY = new int[30];
            this.nScore = 0;
            this.nCount = 3;
            this.nLevel = 1;
            this.nState = 0;
            this.nStatePre = 0;
            this.nSelect = -1;
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    protected void keyPressed(int n) {
        if (n == 42) {
            boolean bl = this.bSound = !this.bSound;
            if (this.bSound || this.nState == 1) {
                // empty if block
            }
        }
        this.nKeyCode = n;
        this.bKeyUsed = true;
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.nState == 11) {
                        this.repaint();
                        Thread.sleep(this.nTime);
                        continue;
                    }
                    if (this.nState == 12) {
                        this.repaint();
                        Thread.sleep(50L);
                        continue;
                    }
                    if (this.nState == 1 || this.nState == 13 || this.nState == 31) {
                        this.repaint();
                        Thread.sleep(500L);
                        continue;
                    }
                    if (this.nState == 0) {
                        this.repaint();
                        continue;
                    }
                    if (this.bKeyUsed) {
                        this.repaint();
                    }
                    Thread.sleep(200L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void paint(Graphics graphics) {
        graphics.translate((this.getWidth() - 120) / 2 - graphics.getTranslateX(), (this.getHeight() - 125) / 2 - graphics.getTranslateY());
        if (this.bCommand) {
            this.bCommand = false;
            this.bKeyUsed = false;
            this.setState(graphics, this.nState);
            return;
        }
        switch (this.nState) {
            case 1: {
                if (this.imgTitle1 != null) {
                    this.imgTitle1 = null;
                    this.imgTitle2 = null;
                }
                try {
                    this.imgTitle1 = Image.createImage((String)"/res/title1.png");
                    this.imgTitle2 = Image.createImage((String)"/res/title2.png");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.clearScreen(graphics);
                graphics.drawImage(this.imgTitle1, 0, 0, 0);
                graphics.drawImage(this.imgTitle2, 0, 30, 0);
                if (this.nSelect == 0) {
                    this.nSelect = 1;
                    graphics.setColor(255, 64, 0);
                    graphics.setFont(this.SFont);
                    graphics.drawString("PRESS ANY KEY", 60, 80, 17);
                } else {
                    this.nSelect = 0;
                }
                if (!this.bKeyUsed) return;
                System.gc();
                this.setState(graphics, 2);
                return;
            }
            case 2: {
                boolean bl = this.showMenu(graphics, true);
                if (!bl) return;
                System.gc();
                this.nSTime = System.currentTimeMillis();
                this.nTime = 0;
                switch (this.nSelect) {
                    case 0: {
                        this.setState(graphics, 11);
                        return;
                    }
                    case 1: {
                        this.setState(graphics, 13);
                        return;
                    }
                    case 2: {
                        this.setState(graphics, 14);
                        return;
                    }
                    case 3: {
                        this.setState(graphics, 15);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 12: {
                this.showAbout(graphics);
                if (!this.bKeyUsed || this.getDir(this.nKeyCode) != 16) return;
                this.setState(graphics, 1);
                return;
            }
            case 13: {
                graphics.setClip(100, 110 - this.nSelect % 2 * 82, 13, 9);
                graphics.drawImage(this.imgArrow, 100 - this.nSelect * 13, 110 - this.nSelect % 2 * 82, 0);
                graphics.setClip(0, 0, 119, 124);
                switch (this.nSelect) {
                    case 0: {
                        this.nSelect = 2;
                        break;
                    }
                    case 1: {
                        this.nSelect = 3;
                        break;
                    }
                    case 2: {
                        this.nSelect = 0;
                        break;
                    }
                    case 3: {
                        this.nSelect = 1;
                    }
                }
                if (!this.bKeyUsed || !this.showHelp(graphics)) return;
                this.setState(graphics, 1);
                return;
            }
            case 14: {
                this.setState(graphics, 1);
                return;
            }
            case 11: {
                this.moveSnake(graphics);
                return;
            }
            case 21: 
            case 22: {
                this.setState(graphics, 11);
                return;
            }
            case 0: {
                if (this.nSelect == -1) {
                    this.setState(graphics, 0);
                }
                if (!this.readResource(graphics)) return;
                this.nHighScore = 0;
                this.nSecond = 0;
                this.nMinute = 0;
                this.loadData();
                this.setState(graphics, 1);
                return;
            }
            case 23: {
                this.setState(graphics, 1);
                return;
            }
            case 15: {
                if (this.nSelect != 15) return;
                this.saveData();
                this.app.destroyApp(false);
                this.app.notifyDestroyed();
                return;
            }
            case 33: {
                if (this.nSelect != 33) return;
                this.setState(graphics, 1);
                return;
            }
            case 31: {
                graphics.setColor(255, 64, 0);
                graphics.setFont(this.LFont);
                graphics.drawString("PAUSE", 42, 55, 0);
            }
        }
    }

    private void setState(Graphics graphics, int n) {
        this.bKeyUsed = false;
        this.nState = n;
        this.removeAllCommands();
        switch (n) {
            case 1: {
                if (this.bSound) {
                    // empty if block
                }
                this.addCommand(this.cmdStart);
                this.addCommand(this.cmdExit);
                break;
            }
            case 2: {
                this.nSelect = 0;
                this.showMenu(graphics, false);
                this.addCommand(this.cmdPlay);
                this.addCommand(this.cmdExit);
                break;
            }
            case 12: {
                this.nSelect = 0;
                this.nKeyCode = 0;
                this.clearScreen(graphics);
                this.addCommand(this.cmdNext);
                break;
            }
            case 13: {
                this.nSelect = 0;
                this.nKeyCode = 0;
                this.showHelp(graphics);
                this.addCommand(this.cmdStart);
                this.addCommand(this.cmdPlay);
                break;
            }
            case 14: {
                this.clearScreen(graphics);
                graphics.drawImage(this.imgScore, 0, 0, 0);
                graphics.fillRect(32, 12, 58, 28);
                graphics.setClip(32, 9, 58, 13);
                graphics.drawImage(this.imgScore, 0, -3, 0);
                graphics.setClip(0, 0, 119, 124);
                graphics.setFont(this.LFont);
                graphics.setColor(0, 0, 0);
                graphics.drawString((this.nMinute > 9 ? "0" + String.valueOf(this.nMinute) : String.valueOf(this.nMinute)) + "min " + this.nSecond + "sec", 30, 43, 0);
                graphics.drawString("eggs : " + this.nHighScore, 30, 70, 0);
                this.addCommand(this.cmdTitle);
                this.addCommand(this.cmdExit);
                break;
            }
            case 11: {
                if (this.bSound) {
                    // empty if block
                }
                this.startLevel();
            }
            case 32: {
                this.nState = 11;
                this.showPlay(graphics);
                this.addCommand(this.cmdPause);
                this.addCommand(this.cmdTitle);
                break;
            }
            case 31: {
                this.showPlay(graphics);
                this.addCommand(this.cmdRestart);
                this.addCommand(this.cmdExit);
                break;
            }
            case 21: {
                if (this.bSound) {
                    // empty if block
                }
                this.drawMessage(graphics, 1);
                ++this.nLevel;
                break;
            }
            case 22: {
                if (this.bSound) {
                    // empty if block
                }
                --this.nCount;
                if (this.nCount == 0) {
                    this.setState(graphics, 23);
                    break;
                }
                this.drawMessage(graphics, 0);
                break;
            }
            case 23: {
                if (this.nHighScore < this.nScore) {
                    this.nHighScore = this.nScore;
                    this.nSecond = (int)((this.nCTime - this.nSTime) / 1000L);
                    this.nMinute = this.nSecond / 60;
                    this.nSecond %= 60;
                }
                this.drawMessage(graphics, 2);
                this.bKeyUsed = false;
                this.addCommand(this.cmdTitle);
                this.addCommand(this.cmdExit);
                break;
            }
            case 0: {
                this.nSelect = 0;
                graphics.setColor(255, 204, 0);
                graphics.fillRect(0, 0, 120, 55);
                graphics.setColor(153, 153, 153);
                graphics.drawLine(8, 58, 109, 58);
                graphics.drawLine(8, 63, 109, 63);
                graphics.drawLine(7, 59, 7, 62);
                graphics.drawLine(110, 59, 110, 62);
                graphics.setColor(0, 0, 0);
                graphics.drawRect(8, 59, 101, 3);
                break;
            }
            case 15: {
                this.nSelect = 0;
                this.removeAllCommands();
                this.addCommand(this.cmdCancel);
                this.addCommand(this.cmdOk);
                this.drawExit(graphics);
                break;
            }
            case 33: {
                this.nSelect = 0;
                this.removeAllCommands();
                this.addCommand(this.cmdCancel);
                this.addCommand(this.cmdOk);
                this.drawTitleQ(graphics);
            }
        }
    }

    protected void setPause() {
        this.removeAllCommands();
        this.addCommand(this.cmdRestart);
        this.addCommand(this.cmdExit);
        this.nState = 31;
    }

    private void drawSound(Graphics graphics, int n, int n2) {
        int n3 = this.bSound ? 0 : 10;
        graphics.setClip(0, 0, 119, 124);
    }

    private boolean showMenu(Graphics graphics, boolean bl) {
        int n;
        this.bKeyUsed = false;
        if (bl) {
            n = this.getDir(this.nKeyCode);
            switch (n) {
                case 1: {
                    if (this.nSelect == 0) break;
                    --this.nSelect;
                    break;
                }
                case 4: {
                    if (this.nSelect == 3) break;
                    ++this.nSelect;
                    break;
                }
                case 16: {
                    return true;
                }
            }
        }
        this.clearScreen(graphics);
        graphics.drawImage(this.imgScore, 0, 0, 0);
        graphics.fillRect(32, 12, 58, 28);
        graphics.setFont(this.LFont);
        graphics.setColor(0, 0, 0);
        n = 0;
        while (n < 4) {
            graphics.drawString(STR_MENU[n], 37, 27 + 18 * n, 0);
            ++n;
        }
        graphics.drawImage(this.imgEgg, 17, 27 + 18 * this.nSelect, 0);
        this.drawSound(graphics, 5, 101);
        return false;
    }

    private void showAbout(Graphics graphics) {
        if (this.nTime == 0) {
            System.gc();
            this.nAbout = 20;
        }
        if (this.nTime > this.getHeight() * -2 + 14) {
            this.nTime -= this.nAbout;
        }
        if (this.nAbout > 1) {
            this.nAbout = this.nAbout * 5 / 6;
        }
        int n = this.getHeight() + this.nTime;
        int n2 = 0;
        this.clearScreen(graphics);
        block1 : switch (this.nSelect) {
            case 0: {
                graphics.drawImage(this.imgScore, 0, 0, 0);
                graphics.fillRect(32, 12, 58, 28);
                graphics.setColor(0, 0, 0);
                graphics.setFont(this.LFont);
                while (n < this.getHeight() - 14) {
                    if (n > 0) {
                        graphics.drawString(about[n2], 3, n, 0);
                    }
                    n += 18;
                    if (++n2 == 13) break block1;
                    graphics.setFont(this.SFont);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.imgTitle1 != null) {
                    this.imgTitle1 = null;
                    this.imgTitle2 = null;
                }
                try {
                    this.imgTitle1 = Image.createImage((String)("/res/ad_" + this.nSelect + "1.png"));
                    this.imgTitle2 = Image.createImage((String)("/res/ad_" + this.nSelect + "2.png"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                graphics.drawImage(this.imgTitle1, 0, 0, 0);
                graphics.drawImage(this.imgTitle2, 0, 30, 0);
            }
        }
    }

    private boolean showHelp(Graphics graphics) {
        int n;
        this.bKeyUsed = false;
        int n2 = n = this.nKeyCode == 0 ? 1 : this.getDir(this.nKeyCode);
        if (n != 1 && n != 4 && n != 16) {
            return false;
        }
        this.clearScreen(graphics);
        graphics.drawImage(this.imgScore, 0, 0, 0);
        graphics.fillRect(32, 12, 58, 28);
        graphics.setClip(32, 9, 58, 13);
        graphics.drawImage(this.imgScore, 0, -16, 0);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.SFont);
        switch (n) {
            case 1: {
                graphics.setClip(0, 0, 119, 124);
                graphics.drawImage(this.imgKey, 6, 35, 0);
                graphics.drawString("Move", 55, 35, 0);
                graphics.drawString("Swallow all the", 4, 52, 0);
                graphics.drawString("eggs. Swallowing", 4, 66, 0);
                graphics.drawString("eggs will make the", 4, 80, 0);
                graphics.drawString("snake grow longer.", 4, 94, 0);
                graphics.drawString("Running into any", 4, 108, 0);
                this.nSelect = 0;
                return false;
            }
            case 4: {
                graphics.setClip(0, 0, 119, 124);
                graphics.drawString("other objects", 4, 40, 0);
                graphics.drawString("including the", 4, 54, 0);
                graphics.drawString("snakes' body will", 4, 68, 0);
                graphics.drawString("end the game and", 4, 82, 0);
                graphics.drawString("restart the level.", 4, 96, 0);
                this.nSelect = 1;
                return false;
            }
            case 16: {
                return true;
            }
        }
        return false;
    }

    private void showPlay(Graphics graphics) {
        this.clearScreen(graphics);
        graphics.setClip(0, 0, 120, 14);
        graphics.drawImage(this.imgPlay2, 0, 0, 0);
        graphics.setClip(0, 111, 120, 14);
        graphics.drawImage(this.imgPlay2, 0, 97, 0);
        graphics.setClip(0, 14, 7, 99);
        graphics.drawImage(this.imgPlay1, 0, 14, 0);
        graphics.setClip(113, 14, 7, 99);
        graphics.drawImage(this.imgPlay1, 106, 14, 0);
        int n = 0;
        while (n < this.nBeanMax) {
            if (this.nBeanX[n] != 0 && this.nBeanY[n] != 0) {
                graphics.setClip((this.nBeanX[n] - 1) * 7 + 7, (this.nBeanY[n] - 1) * 7 + 14, 7, 7);
                graphics.drawImage(this.imgItem, (this.nBeanX[n] - 1) * 7 + 7, (this.nBeanY[n] - 1) * 7 + 14, 0);
            }
            ++n;
        }
        n = 0;
        while (n < this.nStoneMax) {
            graphics.setClip((this.nStoneX[n] - 1) * 7 + 7, (this.nStoneY[n] - 1) * 7 + 14, 7, 7);
            graphics.drawImage(this.imgItem, (this.nStoneX[n] - 2) * 7 + 7, (this.nStoneY[n] - 1) * 7 + 14, 0);
            ++n;
        }
        graphics.setClip(0, 0, 119, 124);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.SFont);
        graphics.drawString(String.valueOf(this.nCount), 110, 114, 0);
        if (this.nLevel > 9) {
            graphics.drawString(String.valueOf(this.nLevel), 107, 1, 0);
        } else {
            graphics.drawString("0" + String.valueOf(this.nLevel), 107, 1, 0);
        }
        if (this.nScore > 999) {
            graphics.drawString(String.valueOf(this.nScore), 49, 1, 0);
        } else if (this.nScore > 99) {
            graphics.drawString("0" + String.valueOf(this.nScore), 49, 1, 0);
        } else if (this.nScore > 9) {
            graphics.drawString("00" + String.valueOf(this.nScore), 49, 1, 0);
        } else {
            graphics.drawString("000" + String.valueOf(this.nScore), 49, 1, 0);
        }
        this.drawSnake(graphics);
        graphics.setColor(255, 204, 51);
        graphics.fillRect((this.nHeadX - 1) * 7 + 7, (this.nHeadY + 2) * 7 + 14, 7, 7);
    }

    private int getDir(int n) {
        int n2 = this.getGameAction(n);
        if (n2 == 1 || n == 50) {
            return 1;
        }
        if (n2 == 5 || n == 54) {
            return 2;
        }
        if (n2 == 6 || n == 53) {
            return 4;
        }
        if (n2 == 2 || n == 52) {
            return 8;
        }
        if (n2 == 8 || n == 48) {
            return 16;
        }
        return 0;
    }

    private void moveSnake(Graphics graphics) {
        int n;
        int n2 = -1;
        this.nCTime = System.currentTimeMillis();
        if (this.bKeyUsed) {
            this.bKeyUsed = false;
            n = this.getDir(this.nKeyCode);
            switch (n) {
                case 1: {
                    if (this.nDirection == 21 || this.nDirection == 14) break;
                    n2 = this.nDirection == 0 ? 21 : 14;
                    this.nDirection = 14;
                    this.addRoute(this.nHeadX, this.nHeadY);
                    break;
                }
                case 4: {
                    if (this.nDirection == 21 || this.nDirection == 14) break;
                    n2 = this.nDirection == 0 ? 7 : 0;
                    this.nDirection = 21;
                    this.addRoute(this.nHeadX, this.nHeadY);
                    break;
                }
                case 8: {
                    if (this.nDirection == 0 || this.nDirection == 7) break;
                    n2 = this.nDirection == 14 ? 0 : 14;
                    this.nDirection = 0;
                    this.addRoute(this.nHeadX, this.nHeadY);
                    break;
                }
                case 2: {
                    if (this.nDirection == 0 || this.nDirection == 7) break;
                    n2 = this.nDirection == 14 ? 7 : 21;
                    this.nDirection = 7;
                    this.addRoute(this.nHeadX, this.nHeadY);
                }
            }
        }
        int n3 = this.nTailX;
        int n4 = this.nTailY;
        int n5 = this.nHeadX--;
        int n6 = this.nHeadY--;
        if (this.nDirection != 14) {
            if (this.nDirection == 21) {
                ++this.nHeadY;
            } else if (this.nDirection != 0 && this.nDirection == 7) {
                ++this.nHeadX;
            }
        }
        graphics.setClip(0, 0, 119, 124);
        if (!this.checkSnake()) {
            this.nHeadX = n5;
            this.nHeadY = n6;
            switch (this.nDirection) {
                case 0: {
                    --this.nHeadX;
                    break;
                }
                case 7: {
                    ++this.nHeadX;
                    break;
                }
                case 14: {
                    --this.nHeadY;
                    break;
                }
                case 21: {
                    ++this.nHeadY;
                }
            }
            graphics.drawImage(this.imgBlood, (this.nHeadX - 1) * 7 + 7 - 3, (this.nHeadY - 1) * 7 + 14 - 3, 0);
            this.bKeyUsed = true;
            this.bCommand = true;
            this.nState = 22;
        } else {
            graphics.setClip(0, 0, 119, 124);
            graphics.setColor(255, 204, 51);
            graphics.fillRect((n3 - 1) * 7 + 7, (n4 - 1) * 7 + 14, 7, 7);
            if (this.bEat) {
                graphics.setClip((this.nTailX - 1) * 7 + 7, (this.nTailY - 1) * 7 + 14, 7, 7);
                graphics.drawImage(this.imgSnake, (this.nTailX - 1) * 7 + 7 - this.nTail, (this.nTailY - 1) * 7 + 14 - 28, 0);
            } else {
                graphics.setClip((this.nTailX2 - 1) * 7 + 7, (this.nTailY2 - 1) * 7 + 14, 7, 7);
                graphics.drawImage(this.imgSnake, (this.nTailX2 - 1) * 7 + 7 - this.nTail, (this.nTailY2 - 1) * 7 + 14 - 28, 0);
            }
            graphics.setClip((this.nHeadX - 1) * 7 + 7, (this.nHeadY - 1) * 7 + 14, 7, 7);
            graphics.drawImage(this.imgSnake, (this.nHeadX - 1) * 7 + 7 - this.nDirection, (this.nHeadY - 1) * 7 + 14, 0);
            graphics.setClip((n5 - 1) * 7 + 7, (n6 - 1) * 7 + 14, 7, 7);
            if (n2 == -1) {
                if (this.bEat) {
                    graphics.drawImage(this.imgSnake, (n5 - 1) * 7 + 7 - this.nDirection, (n6 - 1) * 7 + 14 - 14, 0);
                    this.bEat = false;
                } else {
                    graphics.drawImage(this.imgSnake, (n5 - 1) * 7 + 7 - this.nDirection, (n6 - 1) * 7 + 14 - 7, 0);
                }
            } else {
                graphics.drawImage(this.imgSnake, (n5 - 1) * 7 + 7 - n2, (n6 - 1) * 7 + 14 - 21, 0);
            }
            n = 0;
            while (n < this.nBeanMax) {
                int n7;
                int n8;
                if (this.nHeadX == this.nBeanX[n] && this.nHeadY == this.nBeanY[n]) {
                    if (this.bSound) {
                        // empty if block
                    }
                    this.nBeanX[n] = 0;
                    this.nBeanY[n] = 0;
                    ++this.nLength;
                    ++this.nEatCnt;
                    ++this.nScore;
                    this.bEat = true;
                    graphics.setColor(255, 204, 51);
                    graphics.fillRect(49, 1, 25, 9);
                    graphics.setColor(0, 0, 0);
                    graphics.setFont(this.SFont);
                    if (this.nScore > 999) {
                        graphics.drawString(String.valueOf(this.nScore), 49, 1, 0);
                    } else if (this.nScore > 99) {
                        graphics.drawString("0" + String.valueOf(this.nScore), 49, 1, 0);
                    } else if (this.nScore > 9) {
                        graphics.drawString("00" + String.valueOf(this.nScore), 49, 1, 0);
                    } else {
                        graphics.drawString("000" + String.valueOf(this.nScore), 49, 1, 0);
                    }
                    if (this.nEatCnt != this.nBeanTotal) break;
                    this.bKeyUsed = true;
                    this.bCommand = true;
                    this.nState = 21;
                    break;
                }
                if (this.nBeanX[n] == 0 && this.nBeanY[n] == 0 && this.nBeanCnt > 0 && this.checkArea(n8 = 7 + this.MyRandom.nextInt() % 7, n7 = 7 + this.MyRandom.nextInt() % 7)) {
                    this.nBeanX[n] = n8;
                    this.nBeanY[n] = n7;
                    --this.nBeanCnt;
                    graphics.setClip((this.nBeanX[n] - 1) * 7 + 7, (this.nBeanY[n] - 1) * 7 + 14, 7, 7);
                    graphics.drawImage(this.imgItem, (this.nBeanX[n] - 1) * 7 + 7, (this.nBeanY[n] - 1) * 7 + 14, 0);
                    graphics.setClip(0, 0, 119, 124);
                }
                ++n;
            }
        }
    }

    private void getLength(int n, int n2, int n3, int n4, int[] nArray) {
        nArray[0] = 0;
        nArray[1] = -1;
        if (n == n3) {
            if (n2 > n4) {
                nArray[0] = n2 - n4;
                nArray[1] = 21;
            } else {
                nArray[0] = n4 - n2;
                nArray[1] = 14;
            }
        } else if (n2 == n4) {
            if (n > n3) {
                nArray[0] = n - n3;
                nArray[1] = 7;
            } else {
                nArray[0] = n3 - n;
                nArray[1] = 0;
            }
        }
    }

    private boolean checkOnLine(int n, int n2, int n3, int n4, int n5, int n6) {
        return n3 == n5 && n == n3 ? n2 >= n4 && n2 <= n6 || n2 >= n6 && n2 <= n4 : n4 == n6 && n2 == n4 && (n >= n3 && n <= n5 || n >= n5 && n <= n3);
    }

    private void drawSnake(Graphics graphics) {
        int n = this.nRouteIndex;
        int n2 = this.nHeadX;
        int n3 = this.nHeadY;
        int n4 = this.nRouteX[n];
        int n5 = this.nRouteY[n];
        int[] nArray = new int[2];
        int n6 = this.nDirection;
        graphics.setClip((this.nHeadX - 1) * 7 + 7, (this.nHeadY - 1) * 7 + 14, 7, 7);
        graphics.drawImage(this.imgSnake, (this.nHeadX - 1) * 7 + 7 - this.nDirection, (this.nHeadY - 1) * 7 + 14, 0);
        int n7 = this.nLength;
        while (n7 > 0) {
            this.getLength(n2, n3, n4, n5, nArray);
            switch (nArray[1]) {
                case 0: {
                    ++n2;
                    break;
                }
                case 7: {
                    --n2;
                    break;
                }
                case 14: {
                    ++n3;
                    break;
                }
                case 21: {
                    --n3;
                }
            }
            graphics.setClip((n2 - 1) * 7 + 7, (n3 - 1) * 7 + 14, 7, 7);
            if (n2 == n4 && n3 == n5) {
                if (n7 == 1 && this.bEat) {
                    return;
                }
                if (n == 0) {
                    n = 30;
                }
                n4 = this.nRouteX[--n];
                n5 = this.nRouteY[n];
                n6 = nArray[1];
                this.getLength(n2, n3, n4, n5, nArray);
                int n8 = 0;
                if (nArray[1] == 21 && n6 == 7 || nArray[1] == 0 && n6 == 14) {
                    n8 = 21;
                } else if (nArray[1] == 7 && n6 == 14 || nArray[1] == 21 && n6 == 0) {
                    n8 = 14;
                } else if (nArray[1] == 0 && n6 == 21 || nArray[1] == 14 && n6 == 7) {
                    n8 = 7;
                } else if (nArray[1] == 14 && n6 == 0 || nArray[1] == 7 && n6 == 21) {
                    n8 = 0;
                }
                graphics.drawImage(this.imgSnake, (n2 - 1) * 7 + 7 - n8, (n3 - 1) * 7 + 14 - 21, 0);
            } else if (n7 == 1 || n7 == 2 && this.bEat) {
                if (n7 == 1 && this.bEat) {
                    return;
                }
                graphics.drawImage(this.imgSnake, (n2 - 1) * 7 + 7 - nArray[1], (n3 - 1) * 7 + 14 - 28, 0);
            } else {
                graphics.drawImage(this.imgSnake, (n2 - 1) * 7 + 7 - nArray[1], (n3 - 1) * 7 + 14 - 7, 0);
            }
            --n7;
        }
    }

    private void addRoute(int n, int n2) {
        this.nRouteIndex = this.nRouteIndex < 29 ? ++this.nRouteIndex : 0;
        this.nRouteX[this.nRouteIndex] = this.nHeadX;
        this.nRouteY[this.nRouteIndex] = this.nHeadY;
    }

    private boolean checkSnake() {
        int[] nArray = new int[2];
        int n = 0;
        while (n < this.nStoneMax) {
            if (this.nHeadX == this.nStoneX[n] && this.nHeadY == this.nStoneY[n]) {
                return false;
            }
            ++n;
        }
        if (this.nHeadX <= 0 || this.nHeadX > 15 || this.nHeadY <= 0 || this.nHeadY > 14) {
            return false;
        }
        int n2 = this.nLength;
        int n3 = this.nRouteIndex;
        int n4 = this.nHeadX;
        int n5 = this.nHeadY;
        int n6 = this.nRouteX[n3];
        int n7 = this.nRouteY[n3];
        n = 0;
        do {
            this.getLength(n4, n5, n6, n7, nArray);
            int n8 = n2 > nArray[0] ? nArray[0] : n2;
            switch (nArray[1]) {
                case 7: {
                    n6 = n4 - n8;
                    n7 = n5;
                    this.nTail = 7;
                    break;
                }
                case 21: {
                    n6 = n4;
                    n7 = n5 - n8;
                    this.nTail = 21;
                    break;
                }
                case 0: {
                    n6 = n4 + n8;
                    n7 = n5;
                    this.nTail = 0;
                    break;
                }
                case 14: {
                    n6 = n4;
                    n7 = n5 + n8;
                    this.nTail = 14;
                }
            }
            if (n > 2 && this.checkOnLine(this.nHeadX, this.nHeadY, n4, n5, n6, n7)) {
                return false;
            }
            if ((n2 -= nArray[0]) <= 0) {
                this.nTailX2 = n6;
                this.nTailY2 = n7;
                this.nTailX = this.nTailX2;
                this.nTailY = this.nTailY2;
                break;
            }
            n3 = n3 == 0 ? 29 : --n3;
            n4 = n6;
            n5 = n7;
            n6 = this.nRouteX[n3];
            n7 = this.nRouteY[n3];
            ++n;
        } while (n2 > 0);
        return true;
    }

    private boolean checkArea(int n, int n2) {
        int[] nArray = new int[2];
        int n3 = 0;
        while (n3 < this.nBeanMax) {
            if (n == this.nBeanX[n3] && n2 == this.nBeanY[n3]) {
                return false;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.nStoneMax) {
            if (n == this.nStoneX[n3] && n2 == this.nStoneY[n3]) {
                return false;
            }
            ++n3;
        }
        if (n <= 0 || n > 15 || n2 <= 0 || n2 > 14) {
            return false;
        }
        int n4 = this.nLength;
        int n5 = this.nRouteIndex;
        int n6 = this.nHeadX;
        int n7 = this.nHeadY;
        int n8 = this.nRouteX[n5];
        int n9 = this.nRouteY[n5];
        do {
            this.getLength(n6, n7, n8, n9, nArray);
            if (this.checkOnLine(n, n2, n6, n7, n8, n9)) {
                return false;
            }
            n4 -= nArray[0];
            n5 = n5 == 0 ? 29 : --n5;
            n6 = n8;
            n7 = n9;
            n8 = this.nRouteX[n5];
            n9 = this.nRouteY[n5];
        } while (n4 >= 0);
        return n < n8 - 2 || n > n8 + 2 || n2 < n9 - 2 || n2 > n9 + 2;
    }

    private void startLevel() {
        this.nCTime = this.nLTime = System.currentTimeMillis();
        if (this.nCount <= 0) {
            this.nScore = 0;
            this.nLevel = 1;
            this.nCount = 3;
        }
        this.nKeyCode = 16;
        this.bKeyUsed = false;
        this.nTime = 320 - this.nLevel * 20;
        if (this.nTime < 20) {
            this.nTime = 20;
        }
        this.nBeanMax = this.nLevel + 3;
        if (this.nBeanMax > 10) {
            this.nBeanMax = 10;
        }
        this.nBeanCnt = this.nBeanTotal = 3 * this.nLevel + 4;
        this.nBeanX = new int[this.nBeanMax];
        this.nBeanY = new int[this.nBeanMax];
        int n = 0;
        while (n < this.nBeanMax) {
            this.nBeanX[n] = 0;
            this.nBeanY[n] = 0;
            ++n;
        }
        this.nHeadX = 7;
        this.nHeadY = 11;
        this.nLength = 3;
        this.nTailX = this.nHeadX;
        this.nTailY = this.nHeadY + this.nLength;
        this.nHeadX2 = -1;
        this.nHeadY2 = -1;
        this.nTailX2 = -1;
        this.nTailY2 = -1;
        this.nTail = 14;
        this.nDirection = 14;
        this.nEatCnt = 0;
        this.bEat = false;
        this.nRouteIndex = 0;
        n = 0;
        while (n < 30) {
            this.nRouteX[n] = this.nHeadX;
            this.nRouteY[n] = this.nHeadY + this.nLength;
            ++n;
        }
        this.nStoneMax = (this.nLevel - 1) * 2;
        this.nStoneX = new int[this.nStoneMax];
        this.nStoneY = new int[this.nStoneMax];
        n = 0;
        while (n < this.nStoneMax) {
            do {
                this.nStoneX[n] = 7 + this.MyRandom.nextInt() % 3 * 2;
                this.nStoneY[n] = 7 + this.MyRandom.nextInt() % 3 * 2;
            } while (this.nStoneX[n] == this.nHeadX);
            ++n;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        this.bCommand = true;
        if (command == this.cmdStart) {
            System.gc();
            this.nState = 2;
        }
        if (command == this.cmdPlay) {
            this.nState = 11;
        } else if (command == this.cmdExit) {
            this.nStatePre = this.nState;
            this.nState = 15;
        } else if (command == this.cmdTitle) {
            if (this.nState == 11 || this.nState == 21 || this.nState == 22) {
                this.nState = 33;
            } else {
                System.gc();
                this.nState = 1;
            }
        } else if (command == this.cmdPause) {
            this.nState = 31;
        } else if (command == this.cmdRestart) {
            this.nState = 32;
        } else if (command == this.cmdOk) {
            this.bCommand = false;
            this.nSelect = this.nState;
        } else if (command == this.cmdCancel) {
            if (this.nState == 15) {
                System.gc();
                this.nState = this.nStatePre == 31 ? 31 : (this.nStatePre == 2 ? 2 : 1);
            } else {
                this.nState = 32;
            }
        } else if (command != this.cmdInvoke && command == this.cmdNext && this.nSelect != 3) {
            this.bCommand = false;
            ++this.nSelect;
            if (this.nSelect == 3) {
                this.removeAllCommands();
                this.addCommand(this.cmdTitle);
                this.addCommand(this.cmdInvoke);
            }
        }
        this.repaint();
    }

    private void removeAllCommands() {
        this.removeCommand(this.cmdStart);
        this.removeCommand(this.cmdExit);
        this.removeCommand(this.cmdTitle);
        this.removeCommand(this.cmdPause);
        this.removeCommand(this.cmdRestart);
        this.removeCommand(this.cmdOk);
        this.removeCommand(this.cmdCancel);
        this.removeCommand(this.cmdPlay);
        this.removeCommand(this.cmdInvoke);
        this.removeCommand(this.cmdNext);
    }

    private void clearScreen(Graphics graphics) {
        graphics.setColor(255, 204, 51);
        graphics.fillRect(0, 0, 120, 125);
    }

    private boolean readResource(Graphics graphics) {
        block24: {
            try {
                switch (this.nSelect) {
                    case 0: {
                        this.imgLoading1 = Image.createImage((String)"/res/loading-1.png");
                        break;
                    }
                    case 1: {
                        this.imgLoading2 = Image.createImage((String)"/res/loading-2.png");
                        this.imgCopyright = Image.createImage((String)"/res/copyright.png");
                        break;
                    }
                    case 7: {
                        this.imgArrow = Image.createImage((String)"/res/arrow-u-d.png");
                        break;
                    }
                    case 8: {
                        this.imgEgg = Image.createImage((String)"/res/egg.png");
                        break;
                    }
                    case 9: {
                        this.imgMessage = Image.createImage((String)"/res/message.png");
                        break;
                    }
                    case 10: {
                        this.imgBlood = Image.createImage((String)"/res/blood.png");
                        break;
                    }
                    case 13: {
                        this.imgItem = Image.createImage((String)"/res/item.png");
                        break;
                    }
                    case 14: {
                        this.imgPlay1 = Image.createImage((String)"/res/play1.png");
                        break;
                    }
                    case 15: {
                        this.imgPlay2 = Image.createImage((String)"/res/play2.png");
                        break;
                    }
                    case 17: {
                        this.imgScore = Image.createImage((String)"/res/score.png");
                        break;
                    }
                    case 18: {
                        this.imgSnake = Image.createImage((String)"/res/snake.png");
                        break;
                    }
                    case 19: {
                        this.imgSound = Image.createImage((String)"/res/sound.png");
                        this.imgWindow = Image.createImage((String)"/res/window.png");
                        break;
                    }
                    case 20: {
                        this.imgKey = Image.createImage((String)"/res/key.png");
                        break;
                    }
                    default: {
                        if (this.imgLoading2 == null) break block24;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.imgLoading2 == null) break block24;
            if (this.nSelect / 2 % 3 == 1) {
                graphics.drawImage(this.imgLoading1, 27, 42, 0);
            } else if (this.nSelect / 2 % 3 == 2) {
                graphics.drawImage(this.imgLoading2, 27, 42, 0);
            } else {
                graphics.setColor(255, 204, 0);
                graphics.fillRect(0, 0, 120, 55);
            }
        }
        graphics.setColor(255, 102, 0);
        graphics.drawLine(9, 60, 9 + 100 * this.nSelect / 20, 60);
        graphics.setColor(255, 51, 0);
        graphics.drawLine(9, 61, 9 + 100 * this.nSelect / 20, 61);
        ++this.nSelect;
        if (this.imgKey != null) {
            this.imgLoading1 = null;
            this.imgLoading2 = null;
            this.imgCopyright = null;
            return true;
        }
        return false;
    }

    private boolean loadData() {
        try {
            this.rcData1 = RecordStore.openRecordStore((String)"Score", (boolean)false);
            this.rcData2 = RecordStore.openRecordStore((String)"Time", (boolean)false);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            try {
                this.rcData1 = RecordStore.openRecordStore((String)"Score", (boolean)true);
                this.rcData2 = RecordStore.openRecordStore((String)"Time", (boolean)true);
                byte[] byArray = "0".getBytes();
                int n = this.rcData1.addRecord(byArray, 0, byArray.length);
                n = this.rcData2.addRecord(byArray, 0, byArray.length);
            }
            catch (RecordStoreException recordStoreException) {
                return false;
            }
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
        try {
            this.nHighScore = Integer.parseInt(new String(this.rcData1.getRecord(1)));
            this.nSecond = Integer.parseInt(new String(this.rcData2.getRecord(1)));
            this.nMinute = this.nSecond / 60;
            this.nSecond %= 60;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean saveData() {
        byte[] byArray = String.valueOf(this.nHighScore).getBytes();
        byte[] byArray2 = String.valueOf(this.nMinute * 60 + this.nSecond).getBytes();
        try {
            this.rcData1.setRecord(1, byArray, 0, byArray.length);
            this.rcData2.setRecord(1, byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void drawMessage(Graphics graphics, int n) {
        graphics.setClip(0, 0, 119, 124);
        graphics.drawImage(this.imgWindow, 26, 29, 0);
        graphics.setClip(36, 47, 50, 17);
        graphics.drawImage(this.imgMessage, 36, 47 - n * 17, 0);
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
        }
        finally {
            this.bKeyUsed = false;
            graphics.setClip(0, 0, 119, 124);
        }
    }

    private void drawExit(Graphics graphics) {
        this.clearScreen(graphics);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.LFont);
        graphics.drawString("Would you", 17, 20, 0);
        graphics.drawString("like to quit?", 17, 33, 0);
    }

    private void drawTitleQ(Graphics graphics) {
        this.clearScreen(graphics);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.LFont);
        graphics.drawString("Return to  ", 17, 20, 0);
        graphics.drawString("the title  ", 17, 33, 0);
        graphics.drawString("page?", 17, 46, 0);
    }
}

