/*
 * Decompiled with CFR 0.152.
 */
package lib.http;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.io.HttpConnection;
import lib.http.HttpClient;
import lib.http.HttpListener;
import lib.http.Request;
import lib.http.Response;

public class HttpHandler
implements Runnable {
    private HttpListener listener = null;
    private HttpConnection http = null;
    private DataInputStream dis = null;
    private ByteArrayOutputStream baos = null;
    private Request request = null;
    private Response response = null;

    public HttpHandler(Request request, HttpListener listener) {
        this.request = request;
        this.listener = listener;
    }

    private Response conn() throws IOException {
        switch (this.request.getSchema()) {
            case 0: 
            case 1: 
            case 4: {
                this.http = HttpClient.ConnectServerWithHost(this.request);
                break;
            }
            case 5: {
                this.http = HttpClient.ConnectServerWithHostPro(this.request);
                break;
            }
            case 6: {
                this.http = HttpClient.ConnectServerWithHostPost(this.request);
                break;
            }
            case 2: {
                this.http = HttpClient.ConnectServerWidthAuthor(this.request);
                break;
            }
            case 7: {
                this.http = HttpClient.ConnectServerWithUrlPost(this.request);
            }
        }
        if (this.http == null) {
            return null;
        }
        Response response = new Response();
        response.schema = this.request.getSchema();
        response.responseCode = this.http.getResponseCode();
        if (this.request.getSchema() == 6) {
            return response;
        }
        if (this.request.getSchema() == 5 && this.http.getResponseCode() == 302) {
            String urlJump = this.http.getHeaderField("Location");
            if (urlJump != null && urlJump.trim().length() > 0) {
                response.content = urlJump.getBytes();
                return response;
            }
            response.content = "Error".getBytes();
            return response;
        }
        this.dis = this.http.openDataInputStream();
        this.baos = new ByteArrayOutputStream();
        byte[] temp = new byte[512];
        int ch = 0;
        while ((ch = this.dis.read(temp, 0, temp.length)) != -1) {
            this.baos.write(temp, 0, ch);
        }
        response.content = this.baos.toByteArray();
        if (response.content == null || response.content.length == 0) {
            return null;
        }
        return response;
    }

    public void close() {
        HttpClient.closeHttpConn(this.http, this.dis, this.baos);
    }

    public Response start() {
        Thread t = new Thread(this);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return this.response;
    }

    public void run() {
        try {
            try {
                this.response = this.conn();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                this.close();
            }
        }
        finally {
            this.close();
        }
    }
}

