/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SimpleGraphicsChip
extends GraphicsChip {
    boolean winEnabledThisFrame = true;
    boolean spritesEnabledThisFrame = true;
    private boolean screenFilled;
    private boolean windowStopped;
    private boolean winEnabledThisLine = false;
    private int windowStopLine = 144;
    private int windowStopX;
    private int windowStopY;
    boolean savedWindowDataSelect = false;
    private Image transparentImage;
    private Image[] tileImage;
    private boolean[] tileReadState;
    private int[][] imageBounds;
    private int[] tempPix;
    int tileWidth = 8;
    int tileHeight = 8;
    int imageHeight = 8;
    private Graphics graphics;

    public SimpleGraphicsChip(Dmgcpu d) {
        super(d);
        this.colors = new int[]{-1, -5592406, -11184811, -16777216};
        this.gbcMask = -16777216;
        this.transparentCutoff = this.cpu.gbcFeatures ? 32 : 0;
        this.tileImage = new Image[this.tileCount * this.colorCount];
        this.imageBounds = new int[this.tileCount][];
        this.tileReadState = new boolean[this.tileCount];
        this.cpu.memory[4] = this.videoRam;
        this.tempPix = new int[this.tileWidth * this.tileHeight * 2];
        this.transparentImage = Image.createRGBImage((int[])this.tempPix, (int)this.tileWidth, (int)this.tileHeight, (boolean)true);
        this.frameBufferImage = Image.createImage((int)this.scaledWidth, (int)this.scaledHeight);
        this.graphics = this.frameBufferImage.getGraphics();
    }

    public void UpdateLCDCFlags(int data) {
        if (this.doubledSprites != ((data & 4) != 0)) {
            this.invalidateAll(1);
            this.invalidateAll(2);
        }
        super.UpdateLCDCFlags(data);
        this.spritesEnabledThisFrame |= this.spritesEnabled;
    }

    public final void addressWrite(int addr, byte data) {
        int tileIndex;
        if (this.videoRam[addr] == data) {
            return;
        }
        if (addr < 6144 && this.tileReadState[tileIndex = (addr >> 4) + this.tileOffset]) {
            int r = this.tileImage.length - this.tileCount + tileIndex;
            do {
                this.tileImage[r] = null;
            } while ((r -= this.tileCount) >= 0);
            this.imageBounds[tileIndex] = null;
            this.tileReadState[tileIndex] = false;
        }
        this.videoRam[addr] = data;
    }

    public final void invalidateAll(int pal) {
        int start = pal * this.tileCount * 4;
        int stop = (pal + 1) * this.tileCount * 4;
        for (int r = start; r < stop; ++r) {
            this.tileImage[r] = null;
        }
    }

    private final void drawSprites(int priorityFlag) {
        if (!this.spritesEnabledThisFrame) {
            return;
        }
        int tileNumMask = 255;
        if (this.doubledSprites) {
            tileNumMask = 254;
            this.imageHeight = this.tileHeight * 2;
        }
        for (int i = 156; i >= 0; i -= 4) {
            int attributes = 0xFF & this.cpu.oam[i + 3];
            if ((attributes & 0x80) != priorityFlag) continue;
            int spriteX = (0xFF & this.cpu.oam[i + 1]) - 8;
            int spriteY = (0xFF & this.cpu.oam[i]) - 16;
            if (spriteX >= 160 || spriteY >= 144 || spriteY == -16) continue;
            int tileNum = tileNumMask & this.cpu.oam[i + 2];
            int spriteAttrib = attributes >> 5 & 3;
            if (this.cpu.gbcFeatures) {
                spriteAttrib += 32 + ((attributes & 7) << 2);
                tileNum += 48 * (attributes & 8);
            } else {
                spriteAttrib += 4 + ((attributes & 0x10) >> 2);
            }
            this.draw(tileNum, spriteX, spriteY, spriteAttrib);
        }
        this.imageHeight = this.tileHeight;
    }

    public final void notifyScanline(int line) {
        if (this.skipping) {
            return;
        }
        if (line == 0) {
            if (!this.cpu.gbcFeatures) {
                this.graphics.setColor(this.gbPalette[0]);
                this.graphics.fillRect(0, 0, this.scaledWidth, this.scaledHeight);
                this.drawSprites(128);
            }
            this.windowStopLine = 144;
            this.winEnabledThisFrame = this.winEnabled;
            this.winEnabledThisLine = this.winEnabled;
            this.screenFilled = false;
            this.windowStopped = false;
        }
        if (this.winEnabledThisLine && !this.winEnabled) {
            this.windowStopLine = line & 0xFF;
            this.winEnabledThisLine = false;
        }
        if (line == (this.cpu.registers[74] & 0xFF) + 1) {
            this.savedWindowDataSelect = this.bgWindowDataSelect;
        }
        if (!this.bgEnabled) {
            return;
        }
        if (this.winEnabledThisLine && !this.windowStopped && (this.cpu.registers[75] & 0xFF) - 7 == 0 && (this.cpu.registers[74] & 0xFF) <= line - 7) {
            int yPixelOfs = this.cpu.registers[66] & 7;
            int screenY = (line & 0xF8) - yPixelOfs;
            if (screenY >= 136) {
                this.screenFilled = true;
            }
        } else if ((this.cpu.registers[66] + line & 7) == 7 || line == 144) {
            int xPixelOfs = this.cpu.registers[67] & 7;
            int yPixelOfs = this.cpu.registers[66] & 7;
            int xTileOfs = (this.cpu.registers[67] & 0xFF) >> 3;
            int yTileOfs = (this.cpu.registers[66] & 0xFF) >> 3;
            int bgStartAddress = this.hiBgTileMapAddress ? 7168 : 6144;
            int screenY = (line & 0xF8) - yPixelOfs;
            int screenRight = 160;
            int tileY = (line >> 3) + yTileOfs;
            int tileX = xTileOfs;
            int memStart = bgStartAddress + ((tileY & 0x1F) << 5);
            for (int screenX = -xPixelOfs; screenX < screenRight; screenX += 8) {
                int tileNum = this.bgWindowDataSelect ? this.videoRamBanks[0][memStart + (tileX & 0x1F)] & 0xFF : 256 + this.videoRamBanks[0][memStart + (tileX & 0x1F)];
                int tileAttrib = 0;
                if (this.cpu.gbcFeatures) {
                    byte mapAttrib = this.videoRamBanks[1][memStart + (tileX & 0x1F)];
                    tileAttrib += (mapAttrib & 7) << 2;
                    tileAttrib += mapAttrib >> 5 & 3;
                    tileNum += 384 * (mapAttrib >> 3 & 1);
                }
                ++tileX;
                this.draw(tileNum, screenX, screenY, tileAttrib);
            }
            if (screenY >= 136) {
                this.screenFilled = true;
            }
        }
        if (line == 143) {
            if (!this.screenFilled) {
                this.notifyScanline(144);
            }
            this.updateFrameBufferImage();
        }
    }

    private final void updateFrameBufferImage() {
        if (this.lcdEnabled) {
            if (this.winEnabledThisFrame) {
                int wy;
                int wx;
                int windowStartAddress;
                int n = windowStartAddress = this.hiWinTileMapAddress ? 7168 : 6144;
                if (this.windowStopped) {
                    wx = this.windowStopX;
                    wy = this.windowStopY;
                } else {
                    wx = (this.cpu.registers[75] & 0xFF) - 7;
                    wy = this.cpu.registers[74] & 0xFF;
                }
                if (!this.cpu.gbcFeatures) {
                    this.graphics.setColor(this.gbPalette[0]);
                    int h = this.windowStopLine - wy;
                    int w = 160 - wx;
                    this.graphics.fillRect(wx * this.tileWidth >> 3, wy * this.tileHeight >> 3, w * this.tileWidth >> 3, h * this.tileHeight >> 3);
                }
                int screenY = wy;
                int maxy = 19 - (wy >> 3);
                for (int y = 0; y < maxy && wy + y * 8 < this.windowStopLine; ++y) {
                    int tileAddress = windowStartAddress + y * 32;
                    int screenX = wx;
                    while (screenX < 160) {
                        int tileNum = this.savedWindowDataSelect ? this.videoRamBanks[0][tileAddress] & 0xFF : 256 + this.videoRamBanks[0][tileAddress];
                        int tileAttrib = 0;
                        if (this.cpu.gbcFeatures) {
                            byte mapAttrib = this.videoRamBanks[1][tileAddress];
                            tileAttrib += (mapAttrib & 7) << 2;
                            tileAttrib += mapAttrib >> 5 & 3;
                            tileNum += 384 * (mapAttrib >> 3 & 1);
                        }
                        this.draw(tileNum, screenX, screenY, tileAttrib);
                        screenX += 8;
                        ++tileAddress;
                    }
                    screenY += 8;
                }
            }
            if (this.cpu.gbcFeatures) {
                this.drawSprites(128);
            }
            this.drawSprites(0);
        } else {
            this.graphics.setColor(this.cpu.gbcFeatures ? -1 : this.gbPalette[0]);
            this.graphics.fillRect(0, 0, this.scaledWidth, this.scaledHeight);
        }
        this.spritesEnabledThisFrame = this.spritesEnabled;
    }

    private final Image updateImage(int tileIndex, int attribs) {
        int x2c;
        int[] bounds;
        int y2c;
        int x2cstart;
        int croppedHeight;
        int croppedWidth;
        int index = tileIndex + this.tileCount * attribs;
        boolean otherBank = tileIndex >= 384;
        int offset = otherBank ? tileIndex - 384 << 4 : tileIndex << 4;
        int paletteStart = attribs & 0xFC;
        byte[] vram = otherBank ? this.videoRamBanks[1] : this.videoRamBanks[0];
        int[] palette = this.cpu.gbcFeatures ? this.gbcPalette : this.gbPalette;
        boolean transparentPossible = attribs >= this.transparentCutoff;
        int preshift = 0;
        if (!transparentPossible) {
            croppedWidth = this.tileWidth;
            croppedHeight = this.imageHeight;
            x2cstart = 4 - this.tileWidth;
            y2c = 4 - this.tileHeight;
        } else if (this.imageBounds[tileIndex] != null) {
            bounds = this.imageBounds[tileIndex];
            croppedWidth = bounds[4];
            croppedHeight = bounds[5];
            y2c = bounds[6];
            x2cstart = bounds[7];
            offset += bounds[8];
            preshift = bounds[9];
        } else {
            bounds = new int[10];
            bounds[0] = this.tileWidth;
            bounds[1] = this.imageHeight;
            int preoffset = offset;
            int mask = 0;
            y2c = 4 - this.tileHeight;
            for (int y = 0; y < this.imageHeight; ++y) {
                int num = vram[preoffset] | vram[preoffset + 1];
                if (num != 0) {
                    bounds[1] = Math.min(bounds[1], y);
                    bounds[3] = y + 1;
                }
                mask |= num;
                y2c += 8;
                while (y2c > 0) {
                    y2c -= this.tileHeight;
                    preoffset += 2;
                }
            }
            x2c = 4 - this.tileWidth;
            int x = this.tileWidth;
            while (--x >= 0) {
                if (mask & true) {
                    bounds[0] = x;
                    bounds[2] = Math.max(bounds[2], x + 1);
                }
                x2c += 8;
                while (x2c > 0) {
                    x2c -= this.tileWidth;
                    mask >>= 1;
                }
            }
            if (bounds[0] == this.tileWidth) {
                this.tileImage[index] = this.transparentImage;
                this.tileReadState[tileIndex] = true;
                return this.tileImage[index];
            }
            this.imageBounds[tileIndex] = bounds;
            bounds[2] = this.tileWidth - bounds[2];
            bounds[3] = this.imageHeight - bounds[3];
            bounds[4] = croppedWidth = this.tileWidth - bounds[2] - bounds[0];
            bounds[5] = croppedHeight = this.imageHeight - bounds[3] - bounds[1];
            x2cstart = 4 - this.tileWidth + (bounds[2] << 3);
            for (y2c = 4 - this.tileHeight + (bounds[1] << 3); y2c > 0; y2c -= this.tileHeight) {
                bounds[8] = bounds[8] + 2;
            }
            while (x2cstart > 0) {
                x2cstart -= this.tileWidth;
                preshift += 2;
            }
            bounds[6] = y2c;
            bounds[7] = x2cstart;
            offset += bounds[8];
            bounds[9] = preshift;
        }
        int pixix = 0;
        int pixixdx = 1;
        int pixixdy = 0;
        if ((attribs & 2) != 0) {
            pixixdy = -croppedWidth << 1;
            pixix = croppedWidth * (croppedHeight - 1);
        }
        if ((attribs & 1) == 0) {
            pixixdx = -1;
            pixix += croppedWidth - 1;
            pixixdy += croppedWidth << 1;
        }
        int holemask = 0;
        int y = croppedHeight;
        while (--y >= 0) {
            int num = weaveLookup[vram[offset] & 0xFF] + (weaveLookup[vram[offset + 1] & 0xFF] << 1) >> preshift;
            x2c = x2cstart;
            int x = croppedWidth;
            while (--x >= 0) {
                this.tempPix[pixix] = palette[paletteStart + (num & 3)];
                pixix += pixixdx;
                x2c += 8;
                while (x2c > 0) {
                    x2c -= this.tileWidth;
                    num >>= 2;
                }
            }
            pixix += pixixdy;
            y2c += 8;
            while (y2c > 0) {
                y2c -= this.tileHeight;
                holemask |= ~(vram[offset] | vram[offset + 1]);
                offset += 2;
            }
        }
        if (holemask >> (preshift >> 1) == 0) {
            transparentPossible = false;
        }
        this.tileImage[index] = Image.createRGBImage((int[])this.tempPix, (int)croppedWidth, (int)croppedHeight, (boolean)transparentPossible);
        this.tileReadState[tileIndex] = true;
        return this.tileImage[index];
    }

    private final void draw(int tileIndex, int x, int y, int attribs) {
        int ix = tileIndex + this.tileCount * attribs;
        Image im = this.tileImage[ix];
        if (im == null) {
            im = this.updateImage(tileIndex, attribs);
        }
        if (im == this.transparentImage) {
            return;
        }
        if (this.scale) {
            y = y * this.tileHeight >> 3;
            x = x * this.tileWidth >> 3;
        }
        if (attribs >= this.transparentCutoff) {
            int[] bounds = this.imageBounds[tileIndex];
            this.graphics.drawImage(im, x + bounds[(attribs & 1) << 1], y + bounds[1 + (attribs & 2)], 20);
        } else {
            this.graphics.drawImage(im, x, y, 20);
        }
    }

    public final void stopWindowFromLine() {
        this.windowStopped = true;
        this.windowStopLine = this.cpu.registers[68] & 0xFF;
        this.windowStopX = (this.cpu.registers[75] & 0xFF) - 7;
        this.windowStopY = this.cpu.registers[74] & 0xFF;
    }

    public void setScale(int screenWidth, int screenHeight) {
        int oldTW = this.tileWidth;
        int oldTH = this.tileHeight;
        this.tileWidth = screenWidth / 20;
        this.tileHeight = screenHeight / 18;
        if (MeBoy.keepProportions) {
            if (this.tileWidth < this.tileHeight) {
                this.tileHeight = this.tileWidth;
            } else {
                this.tileWidth = this.tileHeight;
            }
        }
        this.scale = this.tileWidth != 8 || this.tileHeight != 8;
        this.scaledWidth = this.tileWidth * 20;
        this.scaledHeight = this.tileHeight * 18;
        if (this.tileWidth != oldTW || this.tileHeight != oldTH) {
            int r;
            for (r = 0; r < this.tileImage.length; ++r) {
                this.tileImage[r] = null;
            }
            for (r = 0; r < this.tileReadState.length; ++r) {
                this.tileReadState[r] = false;
                this.imageBounds[r] = null;
            }
        }
        this.imageHeight = this.tileHeight;
        this.tempPix = new int[this.tileWidth * this.tileHeight * 2];
        this.frameBufferImage = Image.createImage((int)this.scaledWidth, (int)this.scaledHeight);
        this.graphics = this.frameBufferImage.getGraphics();
    }
}

