/*
 * Decompiled with CFR 0.152.
 */
package com.igame.j2me.card13;

import com.igame.j2me.card13.Card;
import com.igame.j2me.card13.Card13ServerGame;
import com.igame.j2me.card13.Constants;
import com.igame.j2me.card13.MyVector;

public class Card13Hand
implements Constants {
    protected int seat;
    protected MyVector cards;
    protected int group;
    protected Card[] played;
    protected Card[] selected;
    protected int selectedIndex = 0;
    protected int selectedGroup;
    protected MyVector[] combinations;
    protected MyVector[] combinationsAll;

    public static boolean isPair(Card[] cardArray) {
        if (cardArray == null || cardArray.length != 2) {
            return false;
        }
        return cardArray[0].isSameValue(cardArray[1]);
    }

    public static MyVector[] getCombinations(MyVector myVector, int n, Card[] cardArray) {
        return Card13Hand.getCombinations1(myVector, n, Card13Hand.getMax(n, cardArray));
    }

    private static void addAbility(Card[] cardArray, int n) {
        int n2 = 0;
        while (n2 < cardArray.length) {
            if (n != 8 || (n2 != 0 || cardArray[1].isSameValue(cardArray[0])) && (n2 != 4 || cardArray[1].isSameValue(cardArray[4]))) {
                cardArray[n2].ability[n] = true;
            }
            ++n2;
        }
    }

    public static Card[] sortForDisplay(int n, Card[] cardArray) {
        MyVector myVector = new MyVector();
        int n2 = 0;
        while (n2 < cardArray.length) {
            myVector.addElement(cardArray[n2]);
            ++n2;
        }
        Card13Hand.sort(myVector);
        Object[] objectArray = new Card[cardArray.length];
        myVector.copyInto(objectArray);
        switch (n) {
            case 5: 
            case 9: {
                if (((Card)objectArray[4]).getValue() != 13) break;
                Card13Hand.swap(myVector, 0, 4);
                if (((Card)objectArray[3]).getValue() != 12) break;
                Card13Hand.swap(myVector, 0, 4);
                break;
            }
            case 7: {
                if (!((Card)objectArray[2]).isSameValue((Card)objectArray[0])) break;
                Card13Hand.swap(myVector, 0, 4);
                Card13Hand.swap(myVector, 0, 4);
                break;
            }
            case 8: {
                if (!((Card)objectArray[2]).isSameValue((Card)objectArray[0])) break;
                Card13Hand.swap(myVector, 0, 4);
            }
        }
        objectArray = new Card[cardArray.length];
        myVector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean isFlush(Card[] cardArray) {
        if (cardArray == null || cardArray.length != 5) {
            return false;
        }
        int n = 1;
        do {
            if (cardArray[n].isSameSuit(cardArray[0])) continue;
            return false;
        } while (++n < 5);
        return true;
    }

    public static MyVector getCards(Card[] cardArray, int n) {
        MyVector myVector = new MyVector();
        int n2 = 0;
        while (n2 < cardArray.length) {
            if (cardArray[n2].getValue() == n) {
                myVector.addElement(cardArray[n2]);
            }
            ++n2;
        }
        return myVector;
    }

    public static void sort(MyVector myVector) {
        if (myVector == null || myVector.size() <= 1) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (!bl) {
            bl = true;
            int n2 = 0;
            while (n2 < myVector.size() - n - 1) {
                Card card;
                Card card2 = (Card)myVector.elementAt(n2);
                if (card2.isBigger(card = (Card)myVector.elementAt(n2 + 1))) {
                    myVector.setElementAt(card, n2);
                    myVector.setElementAt(card2, n2 + 1);
                    bl = false;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected Card lastCard() {
        return (Card)this.cards.lastElement();
    }

    private static MyVector[] getCombinations1(MyVector myVector, int n, Card card) {
        int n2;
        int n3 = myVector.size();
        Object[] objectArray = new Card[n3];
        myVector.copyInto(objectArray);
        MyVector[] myVectorArray = new MyVector[11];
        int n4 = 0;
        while (n4 < myVectorArray.length) {
            myVectorArray[n4] = new MyVector();
            ++n4;
        }
        n4 = 0;
        while (n4 < objectArray.length) {
            n2 = 0;
            do {
                ((Card)objectArray[n4]).ability[n2] = false;
            } while (++n2 < 11);
            ++n4;
        }
        if (n3 > 0) {
            Card[] cardArray;
            Object[] objectArray2;
            if (n <= 1) {
                n4 = 0;
                while (n4 < n3) {
                    if (((Card)objectArray[n4]).isBigger(card)) {
                        myVectorArray[1].addElement(new Card[]{objectArray[n4]});
                        ((Card)objectArray[n4]).ability[1] = true;
                    }
                    ++n4;
                }
            }
            if (n == 2 || n == 0) {
                n4 = 0;
                while (n4 < n3 - 1) {
                    n2 = n4 + 1;
                    while (n2 < n3) {
                        objectArray2 = new Card[]{objectArray[n4], objectArray[n2]};
                        if (!Card13Hand.isPair((Card[])objectArray2)) break;
                        if (((Card)objectArray[n2]).isBigger(card)) {
                            myVectorArray[2].addElement(objectArray2);
                            Card13Hand.addAbility((Card[])objectArray2, 2);
                        }
                        ++n2;
                    }
                    ++n4;
                }
            }
            if (n == 3 || n == 0) {
                n4 = 0;
                while (n4 < n3 - 1) {
                    n2 = n4 + 1;
                    while (n2 < n3) {
                        if (((Card)objectArray[n4]).getValue() == ((Card)objectArray[n2]).getValue()) {
                            int n5 = n4 + 1;
                            while (n5 < n3 - 1) {
                                int n6 = n5 + 1;
                                while (n6 < n3) {
                                    Card[] cardArray2 = new Card[]{objectArray[n5], objectArray[n6]};
                                    if (!Card13Hand.isPair(cardArray2)) break;
                                    if (((Card)objectArray[n4]).getValue() != ((Card)objectArray[n5]).getValue()) {
                                        cardArray = new Card[]{objectArray[n4], objectArray[n2], objectArray[n5], objectArray[n6]};
                                        myVectorArray[3].addElement(cardArray);
                                        Card13Hand.addAbility(cardArray, 3);
                                    }
                                    ++n6;
                                }
                                ++n5;
                            }
                        }
                        ++n2;
                    }
                    ++n4;
                }
            }
            if (n == 4 || n == 0) {
                n4 = 0;
                while (n4 < n3 - 2) {
                    n2 = n4 + 1;
                    while (n2 < n3 - 1) {
                        int n7 = n2 + 1;
                        while (n7 < n3) {
                            Card[] cardArray3 = new Card[]{objectArray[n4], objectArray[n2], objectArray[n7]};
                            if (!Card13Hand.isTriple(cardArray3)) break;
                            if (((Card)objectArray[n7]).isBigger(card)) {
                                myVectorArray[4].addElement(cardArray3);
                                Card13Hand.addAbility(cardArray3, 4);
                            }
                            ++n7;
                        }
                        ++n2;
                    }
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < n3 - 4) {
                n2 = n4 + 1;
                while (n2 < n3 - 3) {
                    int n8 = n2 + 1;
                    while (n8 < n3 - 2) {
                        int n9 = n8 + 1;
                        while (n9 < n3 - 1) {
                            int n10 = n9 + 1;
                            while (n10 < n3) {
                                cardArray = new Card[]{objectArray[n4], objectArray[n2], objectArray[n8], objectArray[n9], objectArray[n10]};
                                if ((n == 5 || n == 0) && Card13Hand.isBiggerStraight(cardArray, card)) {
                                    myVectorArray[5].addElement(cardArray);
                                    Card13Hand.addAbility(cardArray, 5);
                                }
                                if ((n == 7 || n == 0) && Card13Hand.isBiggerFullHouse(cardArray, card)) {
                                    myVectorArray[7].addElement(cardArray);
                                    Card13Hand.addAbility(cardArray, 7);
                                }
                                if (n <= 8 && Card13Hand.isBiggerFour(cardArray, n, card)) {
                                    myVectorArray[8].addElement(cardArray);
                                    Card13Hand.addAbility(cardArray, 8);
                                }
                                if (Card13Hand.isBiggerFullStraight(cardArray, n, card)) {
                                    myVectorArray[9].addElement(cardArray);
                                    Card13Hand.addAbility(cardArray, 9);
                                }
                                if ((n == 6 || n == 0) && ((Card)objectArray[n4]).getSuit() == ((Card)objectArray[n2]).getSuit() && ((Card)objectArray[n4]).getSuit() == ((Card)objectArray[n8]).getSuit() && ((Card)objectArray[n4]).getSuit() == ((Card)objectArray[n9]).getSuit() && ((Card)objectArray[n4]).getSuit() == ((Card)objectArray[n10]).getSuit()) {
                                    myVectorArray[6].addElement(cardArray);
                                    Card13Hand.addAbility(cardArray, 6);
                                }
                                ++n10;
                            }
                            ++n9;
                        }
                        ++n8;
                    }
                    ++n2;
                }
                ++n4;
            }
            if (n3 == 13 && (n == 10 || n == 0)) {
                n4 = 0;
                n2 = 1;
                while (n2 != 0) {
                    if (n4 < 13 && ((Card)objectArray[n4]).getValue() != n4 + 1) {
                        n2 = 0;
                        continue;
                    }
                    if (n4 == 13) {
                        objectArray2 = objectArray;
                        myVectorArray[10].addElement(objectArray2);
                        Card13Hand.addAbility((Card[])objectArray2, 10);
                        n2 = 0;
                    }
                    ++n4;
                }
            }
        }
        return myVectorArray;
    }

    public static boolean isFullStraight(Card[] cardArray) {
        if (cardArray == null || cardArray.length != 5) {
            return false;
        }
        return Card13Hand.isStraight(cardArray) && Card13Hand.isFlush(cardArray);
    }

    public static boolean isBiggerFullStraight(Card[] cardArray, int n, Card card) {
        if (!Card13Hand.isFullStraight(cardArray)) {
            return false;
        }
        if (card == null || n < 9) {
            return true;
        }
        return Card13Hand.isBiggerStraight(cardArray, card);
    }

    protected void removeCards(Card[] cardArray) {
        if (cardArray != null) {
            int n = 0;
            while (n < cardArray.length) {
                this.removeCard(cardArray[n]);
                ++n;
            }
        }
    }

    public static boolean isFullHouse(Card[] cardArray) {
        if (cardArray == null || cardArray.length != 5) {
            return false;
        }
        return cardArray[0].isSameValue(cardArray[1]) && cardArray[3].isSameValue(cardArray[4]) && (cardArray[2].isSameValue(cardArray[0]) || cardArray[2].isSameValue(cardArray[3]));
    }

    protected boolean evaluate(Card[] cardArray, int n, int n2) {
        int n3;
        int n4 = 100;
        if (n < 8) {
            n3 = 0;
            while (n3 < cardArray.length) {
                if (cardArray[n3].ability[8] || cardArray[n3].ability[9]) {
                    int[] nArray = new int[]{5, 50, 90};
                    n4 = nArray[n2];
                    return Math.abs(Card13ServerGame.r.nextInt() % 100) <= n4;
                }
                ++n3;
            }
        }
        if (n == 1) {
            n3 = 0;
            int n5 = 2;
            do {
                if (!cardArray[0].ability[n5] || n5 == 5 && this.cntCards(cardArray[0].getValue()) > 1) continue;
                n3 = 1;
                break;
            } while (++n5 <= 7);
            if (n3 != 0) {
                int[] nArray = new int[]{5, 60, 90};
                n4 = nArray[n2];
            }
        } else if (n == 2 && cardArray[0].ability[4]) {
            int[] nArray = new int[]{10, 60, 90};
            n4 = nArray[n2];
        }
        if (n4 > 80) {
            int n6 = 0;
            while (n6 < cardArray.length) {
                if (cardArray[n6].getValue() == 13) {
                    int[] nArray = new int[]{5, 30, 90};
                    n4 = nArray[n2];
                    break;
                }
                ++n6;
            }
        }
        return Math.abs(Card13ServerGame.r.nextInt() % 100) <= n4;
    }

    public static boolean isBiggerFullHouse(Card[] cardArray, Card card) {
        if (!Card13Hand.isFullHouse(cardArray)) {
            return false;
        }
        if (card == null) {
            return true;
        }
        if (cardArray[2].isSameValue(cardArray[0])) {
            return cardArray[2].isBigger(card);
        }
        return cardArray[4].isBigger(card);
    }

    public static void swap(MyVector myVector, int n, int n2) {
        Object e = myVector.elementAt(n2);
        myVector.removeElementAt(n2);
        myVector.insertElementAt(e, n);
    }

    public static Card getMax(int n, Card[] cardArray) {
        Object object;
        if (n == 0 || cardArray == null) {
            return null;
        }
        MyVector myVector = new MyVector();
        int n2 = 0;
        while (n2 < cardArray.length) {
            myVector.addElement(cardArray[n2]);
            ++n2;
        }
        Card13Hand.sort(myVector);
        Object[] objectArray = new Card[cardArray.length];
        myVector.copyInto(objectArray);
        switch (n) {
            case 5: 
            case 9: {
                if (((Card)objectArray[4]).getValue() == 13 && ((Card)objectArray[3]).getValue() == 12) {
                    object = objectArray[2];
                    break;
                }
                object = objectArray[4];
                break;
            }
            case 7: {
                object = ((Card)objectArray[2]).isSameValue((Card)objectArray[0]) ? objectArray[2] : objectArray[4];
                break;
            }
            case 8: {
                object = ((Card)objectArray[2]).isSameValue((Card)objectArray[0]) ? objectArray[3] : objectArray[4];
                break;
            }
            default: {
                object = objectArray[objectArray.length - 1];
            }
        }
        return object;
    }

    protected void removeCard(Card card) {
        this.cards.removeElement(card);
        Card13Hand.sort(this.cards);
    }

    public static boolean isFour(Card[] cardArray) {
        if (cardArray == null || cardArray.length != 5) {
            return false;
        }
        return cardArray[1].isSameValue(cardArray[2]) && cardArray[1].isSameValue(cardArray[3]) && (cardArray[1].isSameValue(cardArray[0]) || cardArray[1].isSameValue(cardArray[4]));
    }

    public static boolean isBiggerFour(Card[] cardArray, int n, Card card) {
        if (!Card13Hand.isFour(cardArray)) {
            return false;
        }
        if (card == null || n < 8) {
            return true;
        }
        return cardArray[2].isBigger(card);
    }

    protected int searchCombination(Card[] cardArray) {
        int n = 9;
        block0: do {
            int n2 = 0;
            while (n2 < this.combinations[n].size()) {
                Card[] cardArray2 = (Card[])this.combinations[n].elementAt(n2);
                if (cardArray2.length != cardArray.length) continue block0;
                boolean bl = true;
                int n3 = 0;
                while (n3 < cardArray.length) {
                    if (!cardArray[n3].equals(cardArray[n2])) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    return n;
                }
                ++n2;
            }
        } while (--n >= 0);
        return 0;
    }

    protected void autoPlay(boolean bl, int n) {
        block11: {
            this.selectedGroup = -1;
            this.selected = null;
            System.gc();
            if (bl && this.group == 1) {
                if (this.combinations[1].size() > 0) {
                    this.selected = (Card[])this.combinations[1].lastElement();
                    this.selectedIndex = this.combinations[1].size() - 1;
                    this.selectedGroup = 1;
                }
                return;
            }
            if (this.group == 0) {
                int[] nArray = new int[]{5, 7, 8, 9, 4, 2, 1};
                int n2 = 0;
                while (n2 < nArray.length) {
                    MyVector myVector = this.combinations[nArray[n2]];
                    int n3 = 0;
                    while (n3 < myVector.size()) {
                        Card[] cardArray = (Card[])myVector.elementAt(n3);
                        if (this.evaluate(cardArray, nArray[n2], n)) {
                            if (nArray[n2] == 1 && bl) {
                                this.selectedGroup = 1;
                                this.selected = (Card[])myVector.lastElement();
                                this.selectedIndex = myVector.size() - 1;
                                break;
                            }
                            this.selectedGroup = nArray[n2];
                            this.selected = cardArray;
                            this.selectedIndex = n3;
                            break;
                        }
                        ++n3;
                    }
                    if (this.selectedGroup == -1) {
                        ++n2;
                        continue;
                    }
                    break block11;
                }
                return;
            }
            int n4 = 1;
            block2: do {
                int n5 = 0;
                while (n5 < this.combinations[n4].size()) {
                    Card[] cardArray = (Card[])this.combinations[n4].elementAt(n5);
                    if (this.evaluate(cardArray, n4, n)) {
                        this.selectedGroup = n4;
                        this.selected = cardArray;
                        this.selectedIndex = n5;
                        continue block2;
                    }
                    ++n5;
                }
            } while (this.selectedGroup == -1 && ++n4 <= 9);
        }
    }

    public static boolean isStraight(Card[] cardArray) {
        if (cardArray == null || cardArray.length != 5) {
            return false;
        }
        int n = cardArray[0].getValue();
        return cardArray[1].getValue() == n + 1 && cardArray[2].getValue() == n + 2 && (cardArray[4].getValue() == 13 ? (n == 1 ? cardArray[3].getValue() == n + 3 : cardArray[3].getValue() == n + 3 && cardArray[4].getValue() == n + 4) : cardArray[3].getValue() == n + 3 && cardArray[4].getValue() == n + 4);
    }

    public static boolean isBiggerStraight(Card[] cardArray, Card card) {
        if (!Card13Hand.isStraight(cardArray)) {
            return false;
        }
        if (card == null) {
            return true;
        }
        MyVector myVector = Card13Hand.getCards(cardArray, 13);
        if (myVector.size() > 0) {
            MyVector myVector2 = Card13Hand.getCards(cardArray, 12);
            if (myVector2.size() > 0) {
                MyVector myVector3 = Card13Hand.getCards(cardArray, 3);
                Card card2 = (Card)myVector3.lastElement();
                return card2.isBigger(card);
            }
            Card card3 = (Card)myVector.lastElement();
            return card3.isBigger(card);
        }
        return cardArray[4].isBigger(card);
    }

    protected void addCards(Card[] cardArray) {
        if (cardArray != null) {
            int n = 0;
            while (n < cardArray.length) {
                this.addCard(cardArray[n]);
                ++n;
            }
        }
    }

    public MyVector getMyCards() {
        return this.cards;
    }

    private int cntCards(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cards.size()) {
            if (((Card)this.cards.elementAt(n3)).getValue() == n) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public static boolean isTriple(Card[] cardArray) {
        if (cardArray == null || cardArray.length != 3) {
            return false;
        }
        return cardArray[0].isSameValue(cardArray[1]) && cardArray[0].isSameValue(cardArray[2]);
    }

    protected void addCard(Card card) {
        this.cards.addElement(card);
        Card13Hand.sort(this.cards);
    }
}

