/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public abstract class GraphicsChip {
    protected final int MS_PER_FRAME;
    protected final int TILE_FLIPX;
    protected final int TILE_FLIPY;
    protected byte[] videoRam;
    protected byte[][] videoRamBanks;
    protected int[] colors;
    protected int[] gbPalette = new int[12];
    protected int[] gbcRawPalette = new int[128];
    protected int[] gbcPalette = new int[64];
    protected int gbcMask;
    protected int transparentCutoff;
    boolean bgEnabled = true;
    boolean winEnabled = true;
    boolean spritesEnabled = true;
    boolean lcdEnabled = true;
    boolean spritePriorityEnabled = true;
    public int timer;
    protected boolean skipping = true;
    protected int frameCount;
    protected int skipCount;
    int lastSkipCount;
    boolean bgWindowDataSelect = true;
    boolean doubledSprites = false;
    boolean hiBgTileMapAddress = false;
    boolean hiWinTileMapAddress = false;
    protected int tileOffset;
    protected int tileCount;
    protected int colorCount;
    protected boolean scale;
    public int scaledWidth = 160;
    public int scaledHeight = 144;
    private boolean frameDone = true;
    protected Dmgcpu cpu;
    public Image frameBufferImage;
    protected static int[] weaveLookup = new int[256];

    public GraphicsChip(Dmgcpu d) {
        int i;
        this.MS_PER_FRAME = 17;
        this.TILE_FLIPX = 1;
        this.TILE_FLIPY = 2;
        this.cpu = d;
        if (this.cpu.gbcFeatures) {
            this.videoRamBanks = new byte[2][8192];
            this.tileCount = 768;
            this.colorCount = 64;
        } else {
            this.videoRamBanks = new byte[1][8192];
            this.tileCount = 384;
            this.colorCount = 12;
        }
        this.videoRam = this.videoRamBanks[0];
        this.cpu.memory[4] = this.videoRam;
        this.scale = false;
        for (i = 0; i < this.gbcRawPalette.length; ++i) {
            this.gbcRawPalette[i] = -1000;
        }
        for (i = 0; i < this.gbcPalette.length >> 1; ++i) {
            this.gbcPalette[i] = -1;
        }
        for (i = this.gbcPalette.length >> 1; i < this.gbcPalette.length; ++i) {
            this.gbcPalette[i] = 0;
        }
    }

    public int unflatten(byte[] flatState, int offset) {
        int i;
        for (i = 0; i < this.videoRamBanks.length; ++i) {
            System.arraycopy(flatState, offset, this.videoRamBanks[i], 0, 8192);
            offset += 8192;
        }
        for (i = 0; i < 12; ++i) {
            this.gbPalette[i] = (i & 3) == 0 ? 0xFFFFFF & GBCanvas.getInt(flatState, offset) : 0xFF000000 | GBCanvas.getInt(flatState, offset);
            offset += 4;
        }
        this.UpdateLCDCFlags(this.cpu.registers[64]);
        if (this.cpu.gbcFeatures) {
            this.setVRamBank(flatState[offset++] & 0xFF);
            for (i = 0; i < 128; ++i) {
                this.setGBCPalette(i, flatState[offset++] & 0xFF);
            }
        } else {
            this.invalidateAll(0);
            this.invalidateAll(1);
            this.invalidateAll(2);
        }
        return offset;
    }

    public int flatten(byte[] flatState, int offset) {
        int i;
        for (i = 0; i < this.videoRamBanks.length; ++i) {
            System.arraycopy(this.videoRamBanks[i], 0, flatState, offset, 8192);
            offset += 8192;
        }
        for (int j = 0; j < 12; ++j) {
            GBCanvas.setInt(flatState, offset, this.gbPalette[j]);
            offset += 4;
        }
        if (this.cpu.gbcFeatures) {
            flatState[offset++] = (byte)(this.tileOffset != 0 ? 1 : 0);
            for (i = 0; i < 128; ++i) {
                flatState[offset++] = (byte)this.getGBCPalette(i);
            }
        }
        return offset;
    }

    public void UpdateLCDCFlags(int data) {
        Object var2_2 = null;
        if (Dmgcpu._a0()) {
            return;
        }
        this.bgEnabled = true;
        this.lcdEnabled = (data & 0x80) != 0;
        this.hiWinTileMapAddress = (data & 0x40) != 0;
        this.winEnabled = (data & 0x20) != 0;
        this.bgWindowDataSelect = (data & 0x10) != 0;
        this.hiBgTileMapAddress = (data & 8) != 0;
        this.doubledSprites = (data & 4) != 0;
        boolean bl = this.spritesEnabled = (data & 2) != 0;
        if (this.cpu.gbcFeatures) {
            this.spritePriorityEnabled = (data & 1) != 0;
        } else if ((data & 1) == 0) {
            this.bgEnabled = false;
            this.winEnabled = false;
        }
    }

    public final void vBlank() {
        this.timer += 17;
        ++this.frameCount;
        if (this.skipping) {
            ++this.skipCount;
            if (this.skipCount >= MeBoy.maxFrameSkip) {
                this.skipping = false;
                Object var3_1 = null;
                long l = 0L;
                Object var6_7 = null;
                l = Dmgcpu._n();
                int lag = (int)l - this.timer;
                if (lag > 17) {
                    this.timer += lag - 17;
                }
            } else {
                Object var3_2 = null;
                long l = 0L;
                Object var6_8 = null;
                l = Dmgcpu._n();
                this.skipping = this.timer - (int)l < 0;
            }
            return;
        }
        this.lastSkipCount = this.skipCount;
        this.frameDone = false;
        this.cpu.screen.redrawSmall();
        Object var3_3 = null;
        long l = 0L;
        Object var6_9 = null;
        l = Dmgcpu._n();
        int now = (int)l;
        this.skipping = MeBoy.maxFrameSkip == 0 ? false : this.timer - now < 0;
        try {
            while (this.timer > now + 17) {
                Thread.sleep(1L);
                var3_3 = null;
                l = 0L;
                var6_9 = null;
                l = Dmgcpu._n();
                now = (int)l;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (!this.frameDone && !this.cpu.terminate) {
            Thread.yield();
        }
        this.skipCount = 0;
    }

    public void decodePalette(int startIndex, int data) {
        for (int i = 0; i < 4; ++i) {
            this.gbPalette[startIndex + i] = this.colors[data >> 2 * i & 3];
        }
        int n = startIndex;
        this.gbPalette[n] = this.gbPalette[n] & 0xFFFFFF;
    }

    public void setGBCPalette(int index, int data) {
        if (this.gbcRawPalette[index] == data) {
            return;
        }
        this.gbcRawPalette[index] = data;
        if (index >= 64 && (index & 6) == 0) {
            return;
        }
        int value = (this.gbcRawPalette[index | 1] << 8) + this.gbcRawPalette[index & 0xFFFFFFFE];
        this.gbcPalette[index >> 1] = this.gbcMask + ((value & 0x1F) << 19) + ((value & 0x3E0) << 6) + ((value & 0x7C00) >> 7);
        this.invalidateAll(index >> 3);
    }

    public int getGBCPalette(int index) {
        return this.gbcRawPalette[index];
    }

    public void setVRamBank(int value) {
        this.tileOffset = value * 384;
        this.videoRam = this.videoRamBanks[value];
        this.cpu.memory[4] = this.videoRam;
    }

    public final void notifyRepainted() {
        this.frameDone = true;
    }

    public void stopWindowFromLine() {
    }

    public abstract void setScale(int var1, int var2);

    public abstract void addressWrite(int var1, byte var2);

    public abstract void invalidateAll(int var1);

    public abstract void notifyScanline(int var1);

    static {
        for (int i = 1; i < 256; ++i) {
            for (int d = 0; d < 8; ++d) {
                int n = i;
                weaveLookup[n] = weaveLookup[n] + ((i >> d & 1) << d * 2);
            }
        }
    }
}

