/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.midlet.MIDlet;

public class Dmgcpu
extends Canvas
implements Runnable {
    private final int F_ZERO;
    private final int F_SUBTRACT;
    private final int F_HALFCARRY;
    private final int F_CARRY;
    protected final int INSTRS_PER_DIV;
    protected final int BASE_INSTRS_IN_MODE_0;
    protected final int BASE_INSTRS_IN_MODE_2;
    protected final int BASE_INSTRS_IN_MODE_3;
    protected int INSTRS_IN_MODE_0;
    protected int INSTRS_IN_MODE_2;
    protected int INSTRS_IN_MODE_3;
    public final int INT_VBLANK;
    public final int INT_LCDC;
    public final int INT_TIMA;
    public final int INT_SER;
    public final int INT_P10;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int sp;
    private int hl;
    private byte[] decoderMemory;
    private int localPC;
    private int globalPC;
    private int decoderMaxCruise;
    private int instrCount;
    private int graphicsChipMode;
    private int nextModeTime;
    private int nextTimaOverflow;
    private int nextTimedInterrupt;
    public boolean interruptsEnabled;
    public boolean interruptsArmed;
    private boolean timaActive;
    private boolean interruptEnableRequested;
    protected boolean p10Requested;
    protected boolean gbcFeatures;
    protected int gbcRamBank;
    protected boolean hdmaRunning;
    public byte[][] memory;
    private byte[] mainRam;
    public byte[] oam;
    public byte[] registers;
    private int divReset;
    private int instrsPerTima;
    private int buttonState;
    public GraphicsChip graphicsChip;
    public GBCanvas screen;
    public boolean terminate;
    public String cartName;
    private int cartType;
    private byte[][] rom;
    public byte[][] cartRam;
    private int currentRomBank;
    int loadedRomBanks;
    private int[] romTouch;
    private int currentRamBank;
    private boolean mbc1LargeRamMode;
    private boolean cartRamEnabled;
    public byte[] rtcReg;
    private int lastRtcUpdate;
    private int[] incflags;
    private int[] decflags;
    private int[] soundLength;
    private int[] soundVolume;
    private int[] soundFrequency;
    private int[] soundStartVolume;
    private int[] soundVolumeDelta;
    private int[] soundVolumeDeltaPeriod;
    private int[] soundVolumeDeltaStep;
    private final int MASTER_VOLUME;
    private Player player;
    private MIDIControl synth;
    static int[] midiLookup;
    private static final int[] cyclesPerInstr;
    private static int[] cyclesPerInstrShift;
    private static String[] _BB;
    private static byte[] data;
    private int _CC = 0;
    private int _a;
    private long _b;
    private static long _c;
    private static MIDlet _d;
    private Image _e;
    private byte _f = (byte)2;
    private final byte[] _g = new byte[256];
    private int _h;
    private int _i;
    private int _j;
    private int _k;
    private int _l;
    private int _m;
    private int _n;
    private long _o;
    private int _p;
    private byte[] _q;
    private int[] _r;
    private static int _s;
    private static int _DD0;
    private static long _DD1;
    private static int _DD2;
    private static long _DD3;
    private static int _DD4;
    private static long _DD5;
    private static int _DD6;
    private static long _DD7;
    private static int _DD8;
    private static long _DD9;
    private static int _DD10;
    private static long _DD11;
    private static int _DD12;
    private static long _DD13;
    private static int _DD14;
    private static long _DD15;
    private static int _DD16;
    private static long _DD17;
    private static int _DD18;
    private static long _DD19;

    public Dmgcpu(String cart, GBCanvas gbc) {
        this.F_ZERO = 128;
        this.F_SUBTRACT = 64;
        this.F_HALFCARRY = 32;
        this.F_CARRY = 16;
        this.INSTRS_PER_DIV = 64;
        this.BASE_INSTRS_IN_MODE_0 = 51;
        this.BASE_INSTRS_IN_MODE_2 = 20;
        this.BASE_INSTRS_IN_MODE_3 = 43;
        this.INSTRS_IN_MODE_0 = 51;
        this.INSTRS_IN_MODE_2 = 20;
        this.INSTRS_IN_MODE_3 = 43;
        this.INT_VBLANK = 1;
        this.INT_LCDC = 2;
        this.INT_TIMA = 4;
        this.INT_SER = 8;
        this.INT_P10 = 16;
        this.interruptsEnabled = false;
        this.interruptsArmed = false;
        this.memory = new byte[8][];
        this.oam = new byte[256];
        this.registers = new byte[256];
        this.instrsPerTima = 256;
        this.currentRomBank = 1;
        this.rtcReg = new byte[5];
        this.incflags = new int[256];
        this.decflags = new int[256];
        this.soundLength = new int[3];
        this.soundVolume = new int[3];
        this.soundFrequency = new int[3];
        this.soundStartVolume = new int[2];
        this.soundVolumeDelta = new int[2];
        this.soundVolumeDeltaPeriod = new int[2];
        this.soundVolumeDeltaStep = new int[2];
        this.MASTER_VOLUME = 8;
        this.cartName = cart;
        this.initCartridge();
        this.screen = gbc;
        this.graphicsChip = MeBoy.advancedGraphics ? new AdvancedGraphicsChip(this) : new SimpleGraphicsChip(this);
        this.memory[6] = this.mainRam;
        this.memory[7] = this.mainRam;
        this.interruptsEnabled = false;
        this.a = this.gbcFeatures ? 17 : 1;
        this.b = 0;
        this.c = 19;
        this.d = 0;
        this.e = 216;
        this.f = 176;
        this.hl = 333;
        this.setPC(256);
        this.sp = 65534;
        this.graphicsChipMode = 0;
        this.nextModeTime = 0;
        this.timaActive = false;
        this.interruptEnableRequested = false;
        this.nextTimedInterrupt = 0;
        this.initIncDecFlags();
        this.ioHandlerReset();
        if (MeBoy.enableSound) {
            this.initSound();
        }
    }

    public Dmgcpu(String cart, GBCanvas gbc, byte[] flatState) {
        this.F_ZERO = 128;
        this.F_SUBTRACT = 64;
        this.F_HALFCARRY = 32;
        this.F_CARRY = 16;
        this.INSTRS_PER_DIV = 64;
        this.BASE_INSTRS_IN_MODE_0 = 51;
        this.BASE_INSTRS_IN_MODE_2 = 20;
        this.BASE_INSTRS_IN_MODE_3 = 43;
        this.INSTRS_IN_MODE_0 = 51;
        this.INSTRS_IN_MODE_2 = 20;
        this.INSTRS_IN_MODE_3 = 43;
        this.INT_VBLANK = 1;
        this.INT_LCDC = 2;
        this.INT_TIMA = 4;
        this.INT_SER = 8;
        this.INT_P10 = 16;
        this.interruptsEnabled = false;
        this.interruptsArmed = false;
        this.memory = new byte[8][];
        this.oam = new byte[256];
        this.registers = new byte[256];
        this.instrsPerTima = 256;
        this.currentRomBank = 1;
        this.rtcReg = new byte[5];
        this.incflags = new int[256];
        this.decflags = new int[256];
        this.soundLength = new int[3];
        this.soundVolume = new int[3];
        this.soundFrequency = new int[3];
        this.soundStartVolume = new int[2];
        this.soundVolumeDelta = new int[2];
        this.soundVolumeDeltaPeriod = new int[2];
        this.soundVolumeDeltaStep = new int[2];
        this.MASTER_VOLUME = 8;
        this.cartName = cart;
        this.initCartridge();
        this.screen = gbc;
        this.graphicsChip = MeBoy.advancedGraphics ? new AdvancedGraphicsChip(this) : new SimpleGraphicsChip(this);
        this.memory[6] = this.mainRam;
        this.memory[7] = this.mainRam;
        this.unflatten(flatState);
        this.initIncDecFlags();
        if (MeBoy.enableSound) {
            this.initSound();
        }
    }

    private void initSound() {
        try {
            this.player = Manager.createPlayer((String)"device://midi");
            this.player.realize();
            this.player.start();
            this.synth = (MIDIControl)this.player.getControl("MIDIControl");
            if (MeBoy.advancedSound) {
                this.synth.shortMidiEvent(192, 81, 0);
                this.synth.shortMidiEvent(193, 81, 0);
                this.synth.shortMidiEvent(194, 81, 0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initIncDecFlags() {
        int i;
        this.incflags[0] = 160;
        for (i = 16; i < 256; i += 16) {
            this.incflags[i] = 32;
        }
        this.decflags[0] = 192;
        for (i = 1; i < 256; ++i) {
            this.decflags[i] = 64 + ((i & 0xF) == 15 ? 32 : 0);
        }
    }

    public void unflatten(byte[] flatState) {
        boolean flatGbcFeatures;
        int offset = 0;
        byte version = flatState[offset++];
        boolean bl = flatGbcFeatures = flatState[offset++] != 0;
        if (version != 1 || flatGbcFeatures != this.gbcFeatures) {
            throw new RuntimeException(MeBoy.literal[48]);
        }
        this.a = flatState[offset++] & 0xFF;
        this.b = flatState[offset++] & 0xFF;
        this.c = flatState[offset++] & 0xFF;
        this.d = flatState[offset++] & 0xFF;
        this.e = flatState[offset++] & 0xFF;
        this.f = flatState[offset++] & 0xFF;
        this.sp = flatState[offset++] & 0xFF;
        this.sp = (this.sp << 8) + (flatState[offset++] & 0xFF);
        this.hl = flatState[offset++] & 0xFF;
        this.hl = (this.hl << 8) + (flatState[offset++] & 0xFF);
        int pc = flatState[offset++] & 0xFF;
        pc = (pc << 8) + (flatState[offset++] & 0xFF);
        this.instrCount = GBCanvas.getInt(flatState, offset);
        this.nextModeTime = GBCanvas.getInt(flatState, offset += 4);
        this.nextTimaOverflow = GBCanvas.getInt(flatState, offset += 4);
        this.nextTimedInterrupt = GBCanvas.getInt(flatState, offset += 4);
        offset += 4;
        this.timaActive = flatState[offset++] != 0;
        this.graphicsChipMode = flatState[offset++];
        this.interruptsEnabled = flatState[offset++] != 0;
        this.interruptsArmed = flatState[offset++] != 0;
        this.interruptEnableRequested = flatState[offset++] != 0;
        System.arraycopy(flatState, offset, this.mainRam, 0, this.mainRam.length);
        System.arraycopy(flatState, offset += this.mainRam.length, this.oam, 0, 160);
        System.arraycopy(flatState, offset += 160, this.registers, 0, 256);
        this.divReset = GBCanvas.getInt(flatState, offset += 256);
        this.instrsPerTima = GBCanvas.getInt(flatState, offset += 4);
        offset += 4;
        for (int i = 0; i < this.cartRam.length; ++i) {
            System.arraycopy(flatState, offset, this.cartRam[i], 0, 8192);
            offset += 8192;
        }
        this.currentRomBank = GBCanvas.getInt(flatState, offset);
        this.mapRom(this.currentRomBank);
        this.currentRamBank = GBCanvas.getInt(flatState, offset += 4);
        offset += 4;
        if (this.currentRamBank != 0) {
            this.mapRam(this.currentRamBank);
        }
        this.mbc1LargeRamMode = flatState[offset++] != 0;
        this.cartRamEnabled = flatState[offset++] != 0;
        System.arraycopy(flatState, offset, this.rtcReg, 0, this.rtcReg.length);
        offset += this.rtcReg.length;
        offset = this.graphicsChip.unflatten(flatState, offset);
        if (this.gbcFeatures) {
            this.gbcRamBank = flatState[offset++] & 0xFF;
            boolean bl2 = this.hdmaRunning = flatState[offset++] != 0;
            if ((this.registers[77] & 0x80) != 0) {
                this.INSTRS_IN_MODE_0 = 51;
                this.INSTRS_IN_MODE_2 = 20;
                this.INSTRS_IN_MODE_3 = 43;
            }
        }
        this.setPC(pc);
        if (offset != flatState.length) {
            throw new RuntimeException(MeBoy.literal[49] + ": " + offset + ", " + flatState.length);
        }
    }

    public byte[] flatten() {
        int size = 53 + this.mainRam.length + 416 + 8192 * this.cartRam.length + this.rtcReg.length + 8192 + 48;
        if (this.gbcFeatures) {
            size += 8323;
        }
        byte[] flatState = new byte[size];
        int offset = 0;
        flatState[offset++] = 1;
        flatState[offset++] = (byte)(this.gbcFeatures ? 1 : 0);
        flatState[offset++] = (byte)this.a;
        flatState[offset++] = (byte)this.b;
        flatState[offset++] = (byte)this.c;
        flatState[offset++] = (byte)this.d;
        flatState[offset++] = (byte)this.e;
        flatState[offset++] = (byte)this.f;
        flatState[offset++] = (byte)(this.sp >> 8);
        flatState[offset++] = (byte)this.sp;
        flatState[offset++] = (byte)(this.hl >> 8);
        flatState[offset++] = (byte)this.hl;
        int pc = this.localPC + this.globalPC;
        flatState[offset++] = (byte)(pc >> 8);
        flatState[offset++] = (byte)pc;
        GBCanvas.setInt(flatState, offset, this.instrCount);
        GBCanvas.setInt(flatState, offset += 4, this.nextModeTime);
        GBCanvas.setInt(flatState, offset += 4, this.nextTimaOverflow);
        GBCanvas.setInt(flatState, offset += 4, this.nextTimedInterrupt);
        offset += 4;
        flatState[offset++] = (byte)(this.timaActive ? 1 : 0);
        flatState[offset++] = (byte)this.graphicsChipMode;
        flatState[offset++] = (byte)(this.interruptsEnabled ? 1 : 0);
        flatState[offset++] = (byte)(this.interruptsArmed ? 1 : 0);
        flatState[offset++] = (byte)(this.interruptEnableRequested ? 1 : 0);
        System.arraycopy(this.mainRam, 0, flatState, offset, this.mainRam.length);
        System.arraycopy(this.oam, 0, flatState, offset += this.mainRam.length, 160);
        System.arraycopy(this.registers, 0, flatState, offset += 160, 256);
        GBCanvas.setInt(flatState, offset += 256, this.divReset);
        GBCanvas.setInt(flatState, offset += 4, this.instrsPerTima);
        offset += 4;
        for (int j = 0; j < this.cartRam.length; ++j) {
            System.arraycopy(this.cartRam[j], 0, flatState, offset, 8192);
            offset += 8192;
        }
        GBCanvas.setInt(flatState, offset, this.currentRomBank);
        GBCanvas.setInt(flatState, offset += 4, this.currentRamBank);
        offset += 4;
        flatState[offset++] = (byte)(this.mbc1LargeRamMode ? 1 : 0);
        flatState[offset++] = (byte)(this.cartRamEnabled ? 1 : 0);
        System.arraycopy(this.rtcReg, 0, flatState, offset, this.rtcReg.length);
        offset += this.rtcReg.length;
        offset = this.graphicsChip.flatten(flatState, offset);
        if (this.gbcFeatures) {
            flatState[offset++] = (byte)this.gbcRamBank;
            flatState[offset++] = (byte)(this.hdmaRunning ? 1 : 0);
        }
        if (offset != flatState.length) {
            throw new RuntimeException("error#21: " + offset + ", " + flatState.length);
        }
        return flatState;
    }

    public final int addressRead(int addr) {
        if (addr < 40960) {
            return this.memory[addr >> 13][addr & 0x1FFF];
        }
        if (addr < 49152) {
            if (this.currentRamBank >= 8) {
                this.rtcSync();
                return this.rtcReg[this.currentRamBank - 8];
            }
            return this.memory[addr >> 13][addr & 0x1FFF];
        }
        if ((addr & 0x1000) == 0) {
            return this.mainRam[addr & 0xFFF];
        }
        if (addr < 65024) {
            return this.mainRam[(addr & 0xFFF) + this.gbcRamBank * 4096];
        }
        if (addr < 65280) {
            if (addr > 65184) {
                return 255;
            }
            return this.oam[addr - 65024] & 0xFF;
        }
        return this.ioRead(addr - 65280);
    }

    public final void addressWrite(int addr, int data) {
        int bank = addr >> 12;
        switch (bank) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.cartridgeWrite(addr, data);
                break;
            }
            case 8: 
            case 9: {
                this.graphicsChip.addressWrite(addr - 32768, (byte)data);
                break;
            }
            case 10: 
            case 11: {
                this.cartridgeWrite(addr, data);
                break;
            }
            case 12: {
                this.mainRam[addr - 49152] = (byte)data;
                break;
            }
            case 13: {
                this.mainRam[addr - 53248 + this.gbcRamBank * 4096] = (byte)data;
                break;
            }
            case 14: {
                this.mainRam[addr - 57344] = (byte)data;
                break;
            }
            case 15: {
                if (addr < 65024) {
                    this.mainRam[addr - 61440 + this.gbcRamBank * 4096] = (byte)data;
                    break;
                }
                if (addr < 65280) {
                    this.oam[addr - 65024] = (byte)data;
                    break;
                }
                this.ioWrite(addr - 65280, data);
            }
        }
    }

    private final void pushPC() {
        int pc = this.globalPC + this.localPC;
        if (this.sp >> 13 == 6) {
            this.mainRam[--this.sp - 49152] = (byte)(pc >> 8);
            this.mainRam[--this.sp - 49152] = (byte)pc;
        } else {
            this.addressWrite(--this.sp, pc >> 8);
            this.addressWrite(--this.sp, pc & 0xFF);
        }
    }

    private final void popPC() {
        if (this.sp >> 13 == 6) {
            this.setPC((this.mainRam[this.sp++ - 49152] & 0xFF) + ((this.mainRam[this.sp++ - 49152] & 0xFF) << 8));
        } else {
            this.setPC((this.addressRead(this.sp++) & 0xFF) + ((this.addressRead(this.sp++) & 0xFF) << 8));
        }
    }

    private final int registerRead(int regNum) {
        switch (regNum) {
            case 0: {
                return this.b;
            }
            case 1: {
                return this.c;
            }
            case 2: {
                return this.d;
            }
            case 3: {
                return this.e;
            }
            case 4: {
                return this.hl >> 8;
            }
            case 5: {
                return this.hl & 0xFF;
            }
            case 6: {
                return this.addressRead(this.hl) & 0xFF;
            }
            case 7: {
                return this.a;
            }
        }
        return -1;
    }

    private final void registerWrite(int regNum, int data) {
        switch (regNum) {
            case 0: {
                this.b = data;
                return;
            }
            case 1: {
                this.c = data;
                return;
            }
            case 2: {
                this.d = data;
                return;
            }
            case 3: {
                this.e = data;
                return;
            }
            case 4: {
                this.hl = this.hl & 0xFF | data << 8;
                return;
            }
            case 5: {
                this.hl = this.hl & 0xFF00 | data;
                return;
            }
            case 6: {
                this.addressWrite(this.hl, data);
                return;
            }
            case 7: {
                this.a = data;
                return;
            }
        }
    }

    private void performHdma() {
        int dmaSrc = ((this.registers[81] & 0xFF) << 8) + (this.registers[82] & 0xFF & 0xF0);
        int dmaDst = ((this.registers[83] & 0x1F) << 8) + (this.registers[84] & 0xF0) + 32768;
        for (int r = 0; r < 16; ++r) {
            this.addressWrite(dmaDst + r, this.addressRead(dmaSrc + r));
        }
        this.registers[81] = (byte)(((dmaSrc += 16) & 0xFF00) >> 8);
        this.registers[82] = (byte)(dmaSrc & 0xF0);
        this.registers[83] = (byte)(((dmaDst += 16) & 0x1F00) >> 8);
        this.registers[84] = (byte)(dmaDst & 0xF0);
        if (this.registers[85] == 0) {
            this.hdmaRunning = false;
        }
        this.registers[85] = (byte)(this.registers[85] - 1);
    }

    public void playSound(int channel, int volume) {
        if (this.player == null) {
            return;
        }
        try {
            int basereg = 18 + channel * 5;
            int frequency = ((this.registers[basereg + 2] & 7) << 8) + (this.registers[basereg + 1] & 0xFF);
            int n = midiLookup[frequency];
            if ((this.registers[basereg + 2] & 0x40) == 0) {
                this.soundLength[channel] = Integer.MAX_VALUE;
            }
            if (channel < 2) {
                this.soundStartVolume[channel] = volume;
                this.soundVolumeDelta[channel] = (this.registers[basereg] & 8) != 0 ? 1 : -1;
                this.soundVolumeDeltaPeriod[channel] = this.registers[basereg] & 7;
                this.soundVolumeDeltaStep[channel] = 0;
                if (this.soundVolumeDeltaPeriod[channel] == 0) {
                    this.soundVolumeDelta[channel] = 0;
                }
            }
            if (channel == 2) {
                n -= 12;
            }
            if (MeBoy.advancedSound) {
                if (this.soundFrequency[channel] > 0) {
                    this.synth.shortMidiEvent(128 + channel, this.soundFrequency[channel], 127);
                }
                this.soundFrequency[channel] = n;
                this.synth.shortMidiEvent(176 + channel, 7, volume * 8);
                if (channel == 0) {
                    this.synth.shortMidiEvent(224, 0, 64);
                }
                this.synth.shortMidiEvent(144 + channel, n, 127);
            } else {
                if (this.soundFrequency[channel] > 0) {
                    this.synth.shortMidiEvent(128 + channel, this.soundFrequency[channel], this.soundVolume[channel] * 8);
                }
                this.soundFrequency[channel] = n;
                this.synth.shortMidiEvent(144 + channel, n, volume * 8);
            }
            this.soundVolume[channel] = volume;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateSoundFrequency() {
        if (this.player == null) {
            return;
        }
        if (this.soundFrequency[0] <= 0 || !MeBoy.advancedSound) {
            return;
        }
        int frequency = ((this.registers[20] & 7) << 8) + (this.registers[19] & 0xFF);
        int n = midiLookup[frequency];
        try {
            int wheel = 8192 + 1000 * (n - this.soundFrequency[0]);
            if (wheel < 0) {
                wheel = 0;
            }
            if (wheel > 16383) {
                wheel = 16383;
            }
            this.synth.shortMidiEvent(224, wheel & 0x7F, wheel >> 7);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateSound(int channel) {
        if (this.player == null) {
            return;
        }
        if (this.soundFrequency[channel] <= 0) {
            return;
        }
        try {
            int n = channel;
            this.soundLength[n] = this.soundLength[n] - 4;
            if (this.soundLength[channel] <= 0) {
                this.stopSound(channel);
            }
            if (channel < 2 && this.soundVolumeDelta[channel] != 0) {
                int n2 = channel;
                this.soundVolumeDeltaStep[n2] = this.soundVolumeDeltaStep[n2] + 1;
                if (this.soundVolumeDeltaStep[n2] >= this.soundVolumeDeltaPeriod[channel]) {
                    this.soundVolumeDeltaStep[channel] = 0;
                    this.soundVolume[channel] = this.soundVolume[channel] + this.soundVolumeDelta[channel] & 0xF;
                    if (this.soundVolume[channel] == 0) {
                        this.stopSound(channel);
                    } else if (MeBoy.advancedSound) {
                        this.synth.shortMidiEvent(176 + channel, 7, this.soundVolume[channel] * 8);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopSound(int channel) {
        if (this.player == null) {
            return;
        }
        try {
            if (this.soundFrequency[channel] > 0) {
                if (MeBoy.advancedSound) {
                    this.synth.shortMidiEvent(128 + channel, this.soundFrequency[channel], 127);
                } else {
                    this.synth.shortMidiEvent(128 + channel, this.soundFrequency[channel], this.soundVolume[channel] * 8);
                }
            }
            this.soundFrequency[channel] = -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private final void checkInterrupts() {
        this.pushPC();
        int mask = this.registers[255] & this.registers[15];
        if ((mask & 1) != 0) {
            this.setPC(64);
            this.registers[15] = (byte)(this.registers[15] - 1);
        } else if ((mask & 2) != 0) {
            this.setPC(72);
            this.registers[15] = (byte)(this.registers[15] - 2);
        } else if ((mask & 4) != 0) {
            this.setPC(80);
            this.registers[15] = (byte)(this.registers[15] - 4);
        } else if ((mask & 8) != 0) {
            this.setPC(88);
            this.registers[15] = (byte)(this.registers[15] - 8);
        } else if ((mask & 0x10) != 0) {
            this.setPC(96);
            this.registers[15] = (byte)(this.registers[15] - 16);
        }
        this.interruptsEnabled = false;
        this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
    }

    private final void initiateInterrupts() {
        if (this.instrCount - this.nextModeTime >= 0) {
            if (this.graphicsChipMode == 3) {
                this.graphicsChipMode = 0;
                this.nextModeTime += this.INSTRS_IN_MODE_0;
                int line = this.registers[68] & 0xFF;
                if (line < 144) {
                    if (this.gbcFeatures && this.hdmaRunning) {
                        this.performHdma();
                    }
                    if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 2) != 0 && (this.registers[65] & 8) != 0) {
                        this.interruptsArmed = true;
                        this.registers[15] = (byte)(this.registers[15] | 2);
                    }
                }
            } else if (this.graphicsChipMode == 0) {
                int line;
                this.graphicsChipMode = 2;
                this.nextModeTime += this.INSTRS_IN_MODE_2;
                this.registers[68] = (byte)(this.registers[68] + 1);
                if ((this.registers[68] & 0xFF) == 154) {
                    this.registers[68] = 0;
                }
                if ((line = this.registers[68] & 0xFF) < 144 && (this.registers[65] & 0x20) != 0) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 2);
                }
                if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 2) != 0 && (this.registers[65] & 0x40) != 0 && (this.registers[69] & 0xFF) == line) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 2);
                }
                if (line == 144) {
                    this.graphicsChip.vBlank();
                    if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 1) != 0) {
                        this.interruptsArmed = true;
                        this.registers[15] = (byte)(this.registers[15] | 1);
                        if ((this.registers[65] & 0x10) != 0 && (this.registers[255] & 2) != 0) {
                            this.registers[15] = (byte)(this.registers[15] | 2);
                        }
                    }
                    for (int i = 0; i < 3; ++i) {
                        this.updateSound(i);
                    }
                }
                if (line == 0 && this.p10Requested) {
                    this.p10Requested = false;
                    if ((this.registers[255] & 0x10) != 0) {
                        this.registers[15] = (byte)(this.registers[15] | 0x10);
                    }
                    this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                }
            } else {
                this.graphicsChipMode = 3;
                this.nextModeTime += this.INSTRS_IN_MODE_3;
                int line = this.registers[68] & 0xFF;
                if (line < 144) {
                    this.graphicsChip.notifyScanline(line);
                }
            }
        }
        if (this.timaActive && this.instrCount - this.nextTimaOverflow >= 0) {
            this.nextTimaOverflow += this.instrsPerTima * (256 - (this.registers[6] & 0xFF));
            if ((this.registers[255] & 4) != 0) {
                this.interruptsArmed = true;
                this.registers[15] = (byte)(this.registers[15] | 4);
            }
        }
        if (this.interruptEnableRequested) {
            this.interruptsEnabled = true;
            this.interruptEnableRequested = false;
        }
        this.nextTimedInterrupt = this.nextModeTime;
        if (this.timaActive && this.nextTimaOverflow < this.nextTimedInterrupt) {
            this.nextTimedInterrupt = this.nextTimaOverflow;
        }
    }

    public final void setPC(int pc) {
        if (pc < 65280) {
            this.decoderMemory = this.memory[pc >> 13];
            this.localPC = pc & 0x1FFF;
            this.globalPC = pc & 0xE000;
            int n = this.decoderMaxCruise = pc < 57344 ? 8189 : 7677;
            if (this.gbcFeatures && this.gbcRamBank > 1 && pc >= 49152) {
                this.decoderMaxCruise &= 0xFFF;
            }
        } else {
            this.decoderMemory = this.registers;
            this.localPC = pc & 0xFF;
            this.globalPC = 65280;
            this.decoderMaxCruise = 253;
        }
    }

    private final void executeShift(int b2) {
        int regNum = b2 & 7;
        int data = this.registerRead(regNum);
        this.instrCount += cyclesPerInstrShift[b2];
        if ((b2 & 0xC0) == 0) {
            switch (b2 & 0xF8) {
                case 0: {
                    this.f = 0;
                    if (data >= 128) {
                        this.f = 16;
                    }
                    data = data << 1 & 0xFF;
                    if ((this.f & 0x10) == 0) break;
                    data |= 1;
                    break;
                }
                case 8: {
                    this.f = 0;
                    if ((data & 1) != 0) {
                        this.f = 16;
                    }
                    data >>= 1;
                    if ((this.f & 0x10) == 0) break;
                    data |= 0x80;
                    break;
                }
                case 16: {
                    int newf = data >= 128 ? 16 : 0;
                    data = data << 1 & 0xFF;
                    if ((this.f & 0x10) != 0) {
                        data |= 1;
                    }
                    this.f = newf;
                    break;
                }
                case 24: {
                    int newf = (data & 1) != 0 ? 16 : 0;
                    data >>= 1;
                    if ((this.f & 0x10) != 0) {
                        data |= 0x80;
                    }
                    this.f = newf;
                    break;
                }
                case 32: {
                    this.f = 0;
                    if ((data & 0x80) != 0) {
                        this.f = 16;
                    }
                    data = data << 1 & 0xFF;
                    break;
                }
                case 40: {
                    this.f = 0;
                    if ((data & 1) != 0) {
                        this.f = 16;
                    }
                    data = (data & 0x80) + (data >> 1);
                    break;
                }
                case 48: {
                    data = (data & 0xF) << 4 | data >> 4;
                    this.f = 0;
                    break;
                }
                case 56: {
                    this.f = 0;
                    if ((data & 1) != 0) {
                        this.f = 16;
                    }
                    data >>= 1;
                }
            }
            if (data == 0) {
                this.f |= 0x80;
            }
            this.registerWrite(regNum, data);
        } else {
            int bitMask = 1 << ((b2 & 0x38) >> 3);
            if ((b2 & 0xC0) == 64) {
                this.f = this.f & 0x10 | 0x20;
                if ((data & bitMask) == 0) {
                    this.f |= 0x80;
                }
            } else if ((b2 & 0xC0) == 128) {
                this.registerWrite(regNum, data & 255 - bitMask);
            } else if ((b2 & 0xC0) == 192) {
                this.registerWrite(regNum, data | bitMask);
            }
        }
    }

    private final void executeDAA() {
        int upperNibble = this.a >> 4 & 0xF;
        int lowerNibble = this.a & 0xF;
        int newf = this.f & 0x50;
        if ((this.f & 0x40) == 0) {
            if ((this.f & 0x10) == 0) {
                if (upperNibble <= 8 && lowerNibble >= 10 && (this.f & 0x20) == 0) {
                    this.a += 6;
                }
                if (upperNibble <= 9 && lowerNibble <= 3 && (this.f & 0x20) != 0) {
                    this.a += 6;
                }
                if (upperNibble >= 10 && lowerNibble <= 9 && (this.f & 0x20) == 0) {
                    this.a += 96;
                    newf |= 0x10;
                }
                if (upperNibble >= 9 && lowerNibble >= 10 && (this.f & 0x20) == 0) {
                    this.a += 102;
                    newf |= 0x10;
                }
                if (upperNibble >= 10 && lowerNibble <= 3 && (this.f & 0x20) != 0) {
                    this.a += 102;
                    newf |= 0x10;
                }
            } else {
                if (upperNibble <= 2 && lowerNibble <= 9 && (this.f & 0x20) == 0) {
                    this.a += 96;
                }
                if (upperNibble <= 2 && lowerNibble >= 10 && (this.f & 0x20) == 0) {
                    this.a += 102;
                }
                if (upperNibble <= 3 && lowerNibble <= 3 && (this.f & 0x20) != 0) {
                    this.a += 102;
                }
            }
        } else if ((this.f & 0x10) == 0) {
            if (upperNibble <= 8 && lowerNibble >= 6 && (this.f & 0x20) != 0) {
                this.a += 250;
            }
        } else {
            if (upperNibble >= 7 && lowerNibble <= 9 && (this.f & 0x20) == 0) {
                this.a += 160;
            }
            if (upperNibble >= 6 && lowerNibble >= 6 && (this.f & 0x20) != 0) {
                this.a += 154;
            }
        }
        this.a &= 0xFF;
        if (this.a == 0) {
            newf |= 0x80;
        }
        this.f = newf;
    }

    private final void executeALU(int b1) {
        int operand = this.registerRead(b1 & 7);
        switch ((b1 & 0x38) >> 3) {
            case 1: {
                if ((this.f & 0x10) != 0) {
                    ++operand;
                }
            }
            case 0: {
                this.f = (this.a & 0xF) + (operand & 0xF) >= 16 ? 32 : 0;
                this.a += operand;
                if (this.a > 255) {
                    this.f |= 0x10;
                    this.a &= 0xFF;
                }
                if (this.a != 0) break;
                this.f |= 0x80;
                break;
            }
            case 3: {
                if ((this.f & 0x10) != 0) {
                    ++operand;
                }
            }
            case 2: {
                this.f = 64;
                if ((this.a & 0xF) < (operand & 0xF)) {
                    this.f |= 0x20;
                }
                this.a -= operand;
                if (this.a < 0) {
                    this.f |= 0x10;
                    this.a &= 0xFF;
                }
                if (this.a != 0) break;
                this.f |= 0x80;
                break;
            }
            case 4: {
                this.a &= operand;
                if (this.a == 0) {
                    this.f = 160;
                    break;
                }
                this.f = 32;
                break;
            }
            case 5: {
                this.a ^= operand;
                this.f = this.a == 0 ? 128 : 0;
                break;
            }
            case 6: {
                this.a |= operand;
                this.f = this.a == 0 ? 128 : 0;
                break;
            }
            case 7: {
                this.f = 64;
                if (this.a == operand) {
                    this.f |= 0x80;
                } else if (this.a < operand) {
                    this.f |= 0x10;
                }
                if ((this.a & 0xF) >= (operand & 0xF)) break;
                this.f |= 0x20;
            }
        }
    }

    public final void run() {
        if (_s < 1) {
            while (_c < this._b) {
                if (!this.isShown()) continue;
                long l = System.currentTimeMillis();
                this._h();
                this.repaint();
                this.serviceRepaints();
                int n = (int)(System.currentTimeMillis() - l);
                if (n < this._a) {
                    try {
                        Thread.sleep(this._a - n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    _c += (long)this._a;
                    continue;
                }
                _c += (long)this._a;
            }
            this._f();
            try {
                this._i();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            int startTime;
            this.terminate = false;
            int newf = 0;
            System.gc();
            this.graphicsChip.timer = startTime = (int)System.currentTimeMillis();
            while (!this.terminate) {
                int b3;
                int b2;
                int offset;
                int b1;
                if (this.localPC <= this.decoderMaxCruise) {
                    b1 = this.decoderMemory[this.localPC++] & 0xFF;
                    offset = this.decoderMemory[this.localPC];
                    b2 = offset & 0xFF;
                    b3 = this.decoderMemory[this.localPC + 1];
                } else {
                    int pc = this.localPC + this.globalPC;
                    b1 = this.addressRead(pc++) & 0xFF;
                    offset = this.addressRead(pc);
                    b2 = offset & 0xFF;
                    b3 = this.addressRead(pc + 1);
                    this.setPC(pc);
                }
                switch (b1) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.localPC += 2;
                        this.b = b3 & 0xFF;
                        this.c = b2;
                        break;
                    }
                    case 2: {
                        this.addressWrite(this.b << 8 | this.c, this.a);
                        break;
                    }
                    case 3: {
                        ++this.c;
                        if (this.c != 256) break;
                        this.c = 0;
                        this.b = this.b + 1 & 0xFF;
                        break;
                    }
                    case 4: {
                        this.b = this.b + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.b];
                        break;
                    }
                    case 5: {
                        this.b = this.b - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.b];
                        break;
                    }
                    case 6: {
                        ++this.localPC;
                        this.b = b2;
                        break;
                    }
                    case 7: {
                        if (this.a >= 128) {
                            this.f = 16;
                            this.a = (this.a << 1) + 1 & 0xFF;
                            break;
                        }
                        if (this.a == 0) {
                            this.f = 128;
                            break;
                        }
                        this.a <<= 1;
                        this.f = 0;
                        break;
                    }
                    case 8: {
                        this.localPC += 2;
                        newf = ((b3 & 0xFF) << 8) + b2;
                        this.addressWrite(newf, this.sp);
                        this.addressWrite(newf + 1, this.sp >> 8);
                        break;
                    }
                    case 9: {
                        this.hl += (this.b << 8) + this.c;
                        if ((this.hl & 0xFFFF0000) != 0) {
                            this.f = this.f & 0x80 | 0x10;
                            this.hl &= 0xFFFF;
                            break;
                        }
                        this.f &= 0x80;
                        break;
                    }
                    case 10: {
                        this.a = this.addressRead((this.b << 8) + this.c) & 0xFF;
                        break;
                    }
                    case 11: {
                        --this.c;
                        if (this.c >= 0) break;
                        this.c = 255;
                        this.b = this.b - 1 & 0xFF;
                        break;
                    }
                    case 12: {
                        this.c = this.c + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.c];
                        break;
                    }
                    case 13: {
                        this.c = this.c - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.c];
                        break;
                    }
                    case 14: {
                        ++this.localPC;
                        this.c = b2;
                        break;
                    }
                    case 15: {
                        this.f = (this.a & 1) == 1 ? 16 : 0;
                        this.a >>= 1;
                        if ((this.f & 0x10) != 0) {
                            this.a |= 0x80;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 16: {
                        ++this.localPC;
                        if (!this.gbcFeatures || (this.registers[77] & 1) == 0) break;
                        int newKey1Reg = this.registers[77] & 0xFE;
                        int multiplier = 1;
                        if ((newKey1Reg & 0x80) != 0) {
                            newKey1Reg &= 0x7F;
                        } else {
                            multiplier = 2;
                            newKey1Reg |= 0x80;
                        }
                        this.INSTRS_IN_MODE_0 = 51 * multiplier;
                        this.INSTRS_IN_MODE_2 = 20 * multiplier;
                        this.INSTRS_IN_MODE_3 = 43 * multiplier;
                        this.registers[77] = (byte)newKey1Reg;
                        break;
                    }
                    case 17: {
                        this.localPC += 2;
                        this.d = b3 & 0xFF;
                        this.e = b2;
                        break;
                    }
                    case 18: {
                        this.addressWrite((this.d << 8) + this.e, this.a);
                        break;
                    }
                    case 19: {
                        ++this.e;
                        if (this.e != 256) break;
                        this.e = 0;
                        this.d = this.d + 1 & 0xFF;
                        break;
                    }
                    case 20: {
                        this.d = this.d + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.d];
                        break;
                    }
                    case 21: {
                        this.d = this.d - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.d];
                        break;
                    }
                    case 22: {
                        ++this.localPC;
                        this.d = b2;
                        break;
                    }
                    case 23: {
                        newf = (this.a & 0x80) != 0 ? 16 : 0;
                        this.a <<= 1;
                        if ((this.f & 0x10) != 0) {
                            this.a |= 1;
                        }
                        this.a &= 0xFF;
                        if (this.a == 0) {
                            newf |= 0x80;
                        }
                        this.f = newf;
                        break;
                    }
                    case 24: {
                        this.localPC += 1 + offset;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    case 25: {
                        this.hl += (this.d << 8) + this.e;
                        if ((this.hl & 0xFFFF0000) != 0) {
                            this.f = this.f & 0x80 | 0x10;
                            this.hl &= 0xFFFF;
                            break;
                        }
                        this.f &= 0x80;
                        break;
                    }
                    case 26: {
                        this.a = this.addressRead((this.d << 8) + this.e) & 0xFF;
                        break;
                    }
                    case 27: {
                        --this.e;
                        if (this.e >= 0) break;
                        this.e = 255;
                        this.d = this.d - 1 & 0xFF;
                        break;
                    }
                    case 28: {
                        this.e = this.e + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.e];
                        break;
                    }
                    case 29: {
                        this.e = this.e - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.e];
                        break;
                    }
                    case 30: {
                        ++this.localPC;
                        this.e = b2;
                        break;
                    }
                    case 31: {
                        newf = (this.a & 1) != 0 ? 16 : 0;
                        this.a >>= 1;
                        if ((this.f & 0x10) != 0) {
                            this.a |= 0x80;
                        }
                        if (this.a == 0) {
                            newf |= 0x80;
                        }
                        this.f = newf;
                        break;
                    }
                    case 32: {
                        if (this.f < 128) {
                            this.localPC += 1 + offset;
                            if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                            this.setPC(this.localPC + this.globalPC);
                            break;
                        }
                        ++this.localPC;
                        break;
                    }
                    case 33: {
                        this.localPC += 2;
                        this.hl = ((b3 & 0xFF) << 8) + b2;
                        break;
                    }
                    case 34: {
                        this.addressWrite(this.hl++, this.a);
                        break;
                    }
                    case 35: {
                        this.hl = this.hl + 1 & 0xFFFF;
                        break;
                    }
                    case 36: {
                        b2 = (this.hl >> 8) + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[b2];
                        this.hl = (this.hl & 0xFF) + (b2 << 8);
                        break;
                    }
                    case 37: {
                        b2 = (this.hl >> 8) - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[b2];
                        this.hl = (this.hl & 0xFF) + (b2 << 8);
                        break;
                    }
                    case 38: {
                        ++this.localPC;
                        this.hl = this.hl & 0xFF | b2 << 8;
                        break;
                    }
                    case 39: {
                        this.executeDAA();
                        break;
                    }
                    case 40: {
                        if (this.f >= 128) {
                            this.localPC += 1 + offset;
                            if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                            this.setPC(this.localPC + this.globalPC);
                            break;
                        }
                        ++this.localPC;
                        break;
                    }
                    case 41: {
                        this.hl *= 2;
                        if ((this.hl & 0xFFFF0000) != 0) {
                            this.f = this.f & 0x80 | 0x10;
                            this.hl &= 0xFFFF;
                            break;
                        }
                        this.f &= 0x80;
                        break;
                    }
                    case 42: {
                        this.a = this.addressRead(this.hl++) & 0xFF;
                        break;
                    }
                    case 43: {
                        this.hl = this.hl - 1 & 0xFFFF;
                        break;
                    }
                    case 44: {
                        b2 = this.hl + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[b2];
                        this.hl = (this.hl & 0xFF00) + b2;
                        break;
                    }
                    case 45: {
                        b2 = this.hl - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[b2];
                        this.hl = (this.hl & 0xFF00) + b2;
                        break;
                    }
                    case 46: {
                        ++this.localPC;
                        this.hl = this.hl & 0xFF00 | b2;
                        break;
                    }
                    case 47: {
                        this.a = ~this.a & 0xFF;
                        this.f |= 0x60;
                        break;
                    }
                    case 48: {
                        if ((this.f & 0x10) == 0) {
                            this.localPC += 1 + offset;
                            if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                            this.setPC(this.localPC + this.globalPC);
                            break;
                        }
                        ++this.localPC;
                        break;
                    }
                    case 49: {
                        this.localPC += 2;
                        this.sp = ((b3 & 0xFF) << 8) + b2;
                        break;
                    }
                    case 50: {
                        this.addressWrite(this.hl--, this.a);
                        break;
                    }
                    case 51: {
                        this.sp = this.sp + 1 & 0xFFFF;
                        break;
                    }
                    case 52: {
                        b2 = this.addressRead(this.hl) + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[b2];
                        this.addressWrite(this.hl, b2);
                        break;
                    }
                    case 53: {
                        b2 = this.addressRead(this.hl) - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[b2];
                        this.addressWrite(this.hl, b2);
                        break;
                    }
                    case 54: {
                        ++this.localPC;
                        this.addressWrite(this.hl, b2);
                        break;
                    }
                    case 55: {
                        this.f = this.f & 0x80 | 0x10;
                        break;
                    }
                    case 56: {
                        if ((this.f & 0x10) != 0) {
                            this.localPC += 1 + offset;
                            if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                            this.setPC(this.localPC + this.globalPC);
                            break;
                        }
                        ++this.localPC;
                        break;
                    }
                    case 57: {
                        this.hl += this.sp;
                        if (this.hl > 65535) {
                            this.f = this.f & 0x80 | 0x10;
                            this.hl &= 0xFFFF;
                            break;
                        }
                        this.f &= 0x80;
                        break;
                    }
                    case 58: {
                        this.a = this.addressRead(this.hl--) & 0xFF;
                        break;
                    }
                    case 59: {
                        this.sp = this.sp - 1 & 0xFFFF;
                        break;
                    }
                    case 60: {
                        this.a = this.a + 1 & 0xFF;
                        this.f = this.f & 0x10 | this.incflags[this.a];
                        break;
                    }
                    case 61: {
                        this.a = this.a - 1 & 0xFF;
                        this.f = this.f & 0x10 | this.decflags[this.a];
                        break;
                    }
                    case 62: {
                        ++this.localPC;
                        this.a = b2;
                        break;
                    }
                    case 63: {
                        this.f = this.f & 0x90 ^ 0x10;
                        break;
                    }
                    case 64: {
                        break;
                    }
                    case 65: {
                        this.b = this.c;
                        break;
                    }
                    case 66: {
                        this.b = this.d;
                        break;
                    }
                    case 67: {
                        this.b = this.e;
                        break;
                    }
                    case 68: {
                        this.b = this.hl >> 8;
                        break;
                    }
                    case 69: {
                        this.b = this.hl & 0xFF;
                        break;
                    }
                    case 70: {
                        this.b = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 71: {
                        this.b = this.a;
                        break;
                    }
                    case 72: {
                        this.c = this.b;
                        break;
                    }
                    case 73: {
                        break;
                    }
                    case 74: {
                        this.c = this.d;
                        break;
                    }
                    case 75: {
                        this.c = this.e;
                        break;
                    }
                    case 76: {
                        this.c = this.hl >> 8;
                        break;
                    }
                    case 77: {
                        this.c = this.hl & 0xFF;
                        break;
                    }
                    case 78: {
                        this.c = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 79: {
                        this.c = this.a;
                        break;
                    }
                    case 80: {
                        this.d = this.b;
                        break;
                    }
                    case 81: {
                        this.d = this.c;
                        break;
                    }
                    case 82: {
                        break;
                    }
                    case 83: {
                        this.d = this.e;
                        break;
                    }
                    case 84: {
                        this.d = this.hl >> 8;
                        break;
                    }
                    case 85: {
                        this.d = this.hl & 0xFF;
                        break;
                    }
                    case 86: {
                        this.d = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 87: {
                        this.d = this.a;
                        break;
                    }
                    case 88: {
                        this.e = this.b;
                        break;
                    }
                    case 89: {
                        this.e = this.c;
                        break;
                    }
                    case 90: {
                        this.e = this.d;
                        break;
                    }
                    case 91: {
                        break;
                    }
                    case 92: {
                        this.e = this.hl >> 8;
                        break;
                    }
                    case 93: {
                        this.e = this.hl & 0xFF;
                        break;
                    }
                    case 94: {
                        this.e = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 95: {
                        this.e = this.a;
                        break;
                    }
                    case 96: {
                        this.hl = this.hl & 0xFF | this.b << 8;
                        break;
                    }
                    case 97: {
                        this.hl = this.hl & 0xFF | this.c << 8;
                        break;
                    }
                    case 98: {
                        this.hl = this.hl & 0xFF | this.d << 8;
                        break;
                    }
                    case 99: {
                        this.hl = this.hl & 0xFF | this.e << 8;
                        break;
                    }
                    case 100: {
                        break;
                    }
                    case 101: {
                        this.hl = (this.hl & 0xFF) * 257;
                        break;
                    }
                    case 102: {
                        this.hl = this.hl & 0xFF | (this.addressRead(this.hl) & 0xFF) << 8;
                        break;
                    }
                    case 103: {
                        this.hl = this.hl & 0xFF | this.a << 8;
                        break;
                    }
                    case 104: {
                        this.hl = this.hl & 0xFF00 | this.b;
                        break;
                    }
                    case 105: {
                        this.hl = this.hl & 0xFF00 | this.c;
                        break;
                    }
                    case 106: {
                        this.hl = this.hl & 0xFF00 | this.d;
                        break;
                    }
                    case 107: {
                        this.hl = this.hl & 0xFF00 | this.e;
                        break;
                    }
                    case 108: {
                        this.hl = (this.hl >> 8) * 257;
                        break;
                    }
                    case 109: {
                        break;
                    }
                    case 110: {
                        this.hl = this.hl & 0xFF00 | this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 111: {
                        this.hl = this.hl & 0xFF00 | this.a;
                        break;
                    }
                    case 112: {
                        this.addressWrite(this.hl, this.b);
                        break;
                    }
                    case 113: {
                        this.addressWrite(this.hl, this.c);
                        break;
                    }
                    case 114: {
                        this.addressWrite(this.hl, this.d);
                        break;
                    }
                    case 115: {
                        this.addressWrite(this.hl, this.e);
                        break;
                    }
                    case 116: {
                        this.addressWrite(this.hl, this.hl >> 8);
                        break;
                    }
                    case 117: {
                        this.addressWrite(this.hl, this.hl);
                        break;
                    }
                    case 118: {
                        this.interruptsEnabled = true;
                        if (this.interruptsArmed) {
                            this.nextTimedInterrupt = this.instrCount;
                            break;
                        }
                        while (!this.interruptsArmed) {
                            this.instrCount = this.nextTimedInterrupt;
                            this.initiateInterrupts();
                        }
                        this.nextTimedInterrupt = ++this.instrCount;
                        break;
                    }
                    case 119: {
                        this.addressWrite(this.hl, this.a);
                        break;
                    }
                    case 120: {
                        this.a = this.b;
                        break;
                    }
                    case 121: {
                        this.a = this.c;
                        break;
                    }
                    case 122: {
                        this.a = this.d;
                        break;
                    }
                    case 123: {
                        this.a = this.e;
                        break;
                    }
                    case 124: {
                        this.a = this.hl >> 8;
                        break;
                    }
                    case 125: {
                        this.a = this.hl & 0xFF;
                        break;
                    }
                    case 126: {
                        this.a = this.addressRead(this.hl) & 0xFF;
                        break;
                    }
                    case 127: {
                        break;
                    }
                    case 167: {
                        if (this.a == 0) {
                            this.f = 160;
                            break;
                        }
                        this.f = 32;
                        break;
                    }
                    case 175: {
                        this.a = 0;
                        this.f = 128;
                        break;
                    }
                    case 192: {
                        if (this.f >= 128) break;
                        this.popPC();
                        break;
                    }
                    case 193: {
                        this.c = this.addressRead(this.sp++) & 0xFF;
                        this.b = this.addressRead(this.sp++) & 0xFF;
                        break;
                    }
                    case 194: {
                        if (this.f < 128) {
                            this.setPC(((b3 & 0xFF) << 8) + b2);
                            break;
                        }
                        this.localPC += 2;
                        break;
                    }
                    case 195: {
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    case 196: {
                        this.localPC += 2;
                        if (this.f >= 128) break;
                        this.pushPC();
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    case 197: {
                        this.addressWrite(--this.sp, this.b);
                        this.addressWrite(--this.sp, this.c);
                        break;
                    }
                    case 198: {
                        ++this.localPC;
                        this.f = (this.a & 0xF) + (b2 & 0xF) >= 16 ? 32 : 0;
                        this.a += b2;
                        if (this.a > 255) {
                            this.f |= 0x10;
                            this.a &= 0xFF;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 199: {
                        this.pushPC();
                        this.setPC(0);
                        break;
                    }
                    case 200: {
                        if (this.f < 128) break;
                        this.popPC();
                        break;
                    }
                    case 201: {
                        this.popPC();
                        break;
                    }
                    case 202: {
                        if (this.f >= 128) {
                            this.setPC(((b3 & 0xFF) << 8) + b2);
                            break;
                        }
                        this.localPC += 2;
                        break;
                    }
                    case 203: {
                        ++this.localPC;
                        this.executeShift(b2);
                        break;
                    }
                    case 204: {
                        this.localPC += 2;
                        if (this.f < 128) break;
                        this.pushPC();
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    case 205: {
                        this.localPC += 2;
                        this.pushPC();
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    case 206: {
                        ++this.localPC;
                        if ((this.f & 0x10) != 0) {
                            ++b2;
                        }
                        this.f = (this.a & 0xF) + (b2 & 0xF) >= 16 ? 32 : 0;
                        this.a += b2;
                        if (this.a > 255) {
                            this.f |= 0x10;
                            this.a &= 0xFF;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 207: {
                        this.pushPC();
                        this.setPC(8);
                        break;
                    }
                    case 208: {
                        if ((this.f & 0x10) != 0) break;
                        this.popPC();
                        break;
                    }
                    case 209: {
                        this.e = this.addressRead(this.sp++) & 0xFF;
                        this.d = this.addressRead(this.sp++) & 0xFF;
                        break;
                    }
                    case 210: {
                        if ((this.f & 0x10) == 0) {
                            this.setPC(((b3 & 0xFF) << 8) + b2);
                            break;
                        }
                        this.localPC += 2;
                        break;
                    }
                    case 212: {
                        this.localPC += 2;
                        if ((this.f & 0x10) != 0) break;
                        this.pushPC();
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    case 213: {
                        this.addressWrite(--this.sp, this.d);
                        this.addressWrite(--this.sp, this.e);
                        break;
                    }
                    case 214: {
                        ++this.localPC;
                        this.f = 64;
                        if ((this.a & 0xF) < (b2 & 0xF)) {
                            this.f |= 0x20;
                        }
                        this.a -= b2;
                        if (this.a < 0) {
                            this.f |= 0x10;
                            this.a &= 0xFF;
                            break;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 215: {
                        this.pushPC();
                        this.setPC(16);
                        break;
                    }
                    case 216: {
                        if ((this.f & 0x10) == 0) break;
                        this.popPC();
                        break;
                    }
                    case 217: {
                        this.interruptsEnabled = true;
                        if (this.interruptsArmed) {
                            this.nextTimedInterrupt = this.instrCount;
                        }
                        this.popPC();
                        break;
                    }
                    case 218: {
                        if ((this.f & 0x10) != 0) {
                            this.setPC(((b3 & 0xFF) << 8) + b2);
                            break;
                        }
                        this.localPC += 2;
                        break;
                    }
                    case 220: {
                        this.localPC += 2;
                        if ((this.f & 0x10) == 0) break;
                        this.pushPC();
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    case 222: {
                        ++this.localPC;
                        if ((this.f & 0x10) != 0) {
                            ++b2;
                        }
                        this.f = 64;
                        if ((this.a & 0xF) < (b2 & 0xF)) {
                            this.f |= 0x20;
                        }
                        this.a -= b2;
                        if (this.a < 0) {
                            this.f |= 0x10;
                            this.a &= 0xFF;
                            break;
                        }
                        if (this.a != 0) break;
                        this.f |= 0x80;
                        break;
                    }
                    case 223: {
                        this.pushPC();
                        this.setPC(24);
                        break;
                    }
                    case 224: {
                        ++this.localPC;
                        this.ioWrite(b2, this.a);
                        break;
                    }
                    case 225: {
                        this.hl = ((this.addressRead(this.sp + 1) & 0xFF) << 8) + (this.addressRead(this.sp) & 0xFF);
                        this.sp += 2;
                        break;
                    }
                    case 226: {
                        this.ioWrite(this.c, this.a);
                        break;
                    }
                    case 229: {
                        this.addressWrite(--this.sp, this.hl >> 8);
                        this.addressWrite(--this.sp, this.hl);
                        break;
                    }
                    case 230: {
                        ++this.localPC;
                        this.a &= b2;
                        if (this.a == 0) {
                            this.f = 128;
                            break;
                        }
                        this.f = 0;
                        break;
                    }
                    case 231: {
                        this.pushPC();
                        this.setPC(32);
                        break;
                    }
                    case 232: {
                        ++this.localPC;
                        this.sp += offset;
                        this.f = 0;
                        if (this.sp <= 65535 && this.sp >= 0) break;
                        this.sp &= 0xFFFF;
                        this.f = 16;
                        break;
                    }
                    case 233: {
                        this.setPC(this.hl);
                        break;
                    }
                    case 234: {
                        this.localPC += 2;
                        this.addressWrite(((b3 & 0xFF) << 8) + b2, this.a);
                        break;
                    }
                    case 238: {
                        ++this.localPC;
                        this.a ^= b2;
                        this.f = 0;
                        if (this.a != 0) break;
                        this.f = 128;
                        break;
                    }
                    case 239: {
                        this.pushPC();
                        this.setPC(40);
                        break;
                    }
                    case 240: {
                        ++this.localPC;
                        this.a = this.ioRead(b2) & 0xFF;
                        break;
                    }
                    case 241: {
                        this.f = this.addressRead(this.sp++) & 0xFF;
                        this.a = this.addressRead(this.sp++) & 0xFF;
                        break;
                    }
                    case 242: {
                        this.a = this.ioRead(this.c) & 0xFF;
                        break;
                    }
                    case 243: {
                        this.interruptsEnabled = false;
                        break;
                    }
                    case 245: {
                        this.addressWrite(--this.sp, this.a);
                        this.addressWrite(--this.sp, this.f);
                        break;
                    }
                    case 246: {
                        ++this.localPC;
                        this.a |= b2;
                        this.f = 0;
                        if (this.a != 0) break;
                        this.f = 128;
                        break;
                    }
                    case 247: {
                        this.pushPC();
                        this.setPC(48);
                        break;
                    }
                    case 248: {
                        ++this.localPC;
                        this.hl = this.sp + offset;
                        this.f = 0;
                        if ((this.hl & 0xFFFF0000) == 0) break;
                        this.f = 16;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    case 249: {
                        this.sp = this.hl;
                        break;
                    }
                    case 250: {
                        this.localPC += 2;
                        this.a = this.addressRead(((b3 & 0xFF) << 8) + b2) & 0xFF;
                        break;
                    }
                    case 251: {
                        this.interruptEnableRequested = true;
                        this.nextTimedInterrupt = this.instrCount + cyclesPerInstr[b1] + 1;
                        break;
                    }
                    case 254: {
                        ++this.localPC;
                        int n = this.f = (this.a & 0xF) < (b2 & 0xF) ? 96 : 64;
                        if (this.a == b2) {
                            this.f |= 0x80;
                            break;
                        }
                        if (this.a >= b2) break;
                        this.f |= 0x10;
                        break;
                    }
                    case 255: {
                        this.pushPC();
                        this.setPC(56);
                        break;
                    }
                    default: {
                        if ((b1 & 0xC0) == 128) {
                            this.executeALU(b1);
                            break;
                        }
                        throw new RuntimeException(Integer.toHexString(b1));
                    }
                }
                this.instrCount += cyclesPerInstr[b1];
                if (this.instrCount - this.nextTimedInterrupt < 0) continue;
                this.initiateInterrupts();
                if (!this.interruptsArmed || !this.interruptsEnabled) continue;
                this.checkInterrupts();
            }
        }
        catch (Exception ex) {
            this.terminate();
            ex.printStackTrace();
            MeBoy.showError(null, "error#20", ex);
        }
    }

    private final void ioHandlerReset() {
        this.ioWrite(15, 1);
        this.ioWrite(38, 241);
        this.ioWrite(64, 145);
        this.ioWrite(71, 252);
        this.ioWrite(72, 255);
        this.ioWrite(73, 255);
        this.registers[85] = -128;
        this.hdmaRunning = false;
    }

    private final int ioRead(int num) {
        if (num == 65) {
            int output = this.registers[65];
            if (this.registers[68] == this.registers[69]) {
                output |= 4;
            }
            output = (this.registers[68] & 0xFF) >= 144 ? (output |= 1) : (output |= this.graphicsChipMode);
            return output;
        }
        if (num == 4) {
            return (byte)((this.instrCount - this.divReset - 1) / 64);
        }
        if (num == 5) {
            if (!this.timaActive) {
                return this.registers[num];
            }
            return (this.instrCount + this.instrsPerTima * 256 - this.nextTimaOverflow) / this.instrsPerTima;
        }
        return this.registers[num];
    }

    public void ioWrite(int num, int data) {
        switch (num) {
            case 0: {
                int output = 0;
                if ((data & 0x10) == 0) {
                    output |= this.buttonState & 0xF;
                }
                if ((data & 0x20) == 0) {
                    output |= this.buttonState >> 4;
                }
                this.registers[0] = (byte)(0xF0 | ~output & 0xF);
                break;
            }
            case 2: {
                this.registers[2] = (byte)data;
                if ((this.registers[2] & 1) != 1) break;
                this.registers[1] = -1;
                if ((this.registers[255] & 8) != 0) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 8);
                    if (this.interruptsEnabled) {
                        this.nextTimedInterrupt = this.instrCount;
                    }
                }
                this.registers[2] = (byte)(this.registers[2] & 0x7F);
                break;
            }
            case 4: {
                this.divReset = this.instrCount;
                break;
            }
            case 5: {
                if (!this.timaActive) break;
                this.nextTimaOverflow = this.instrCount + this.instrsPerTima * (256 - (data & 0xFF));
                break;
            }
            case 7: {
                if ((data & 4) != 0) {
                    if (!this.timaActive) {
                        this.timaActive = true;
                        this.nextTimaOverflow = this.instrCount + this.instrsPerTima * (256 - (this.registers[5] & 0xFF));
                    }
                    this.instrsPerTima = 4 << 2 * (data - 1 & 3);
                } else if (this.timaActive) {
                    this.timaActive = false;
                    this.registers[5] = (byte)((this.instrCount + this.instrsPerTima * 256 - this.nextTimaOverflow) / this.instrsPerTima);
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 15: {
                this.registers[num] = (byte)data;
                boolean bl = this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                if (!this.interruptsArmed || !this.interruptsEnabled) break;
                this.nextTimedInterrupt = this.instrCount;
                break;
            }
            case 18: {
                this.registers[num] = (byte)data;
                if ((data & 0xF0) != 0) break;
                this.stopSound(0);
                break;
            }
            case 20: {
                this.registers[num] = (byte)data;
                if ((data & 0x80) != 0) {
                    this.soundLength[0] = 64 - (this.registers[17] & 0x3F);
                    this.playSound(0, this.registers[18] >> 4 & 0xF);
                    break;
                }
                this.updateSoundFrequency();
                break;
            }
            case 23: {
                this.registers[num] = (byte)data;
                if ((data & 0xF0) != 0) break;
                this.stopSound(1);
                break;
            }
            case 25: {
                this.registers[num] = (byte)data;
                if ((data & 0x80) == 0) break;
                this.soundLength[1] = 64 - (this.registers[22] & 0x3F);
                this.playSound(1, this.registers[23] >> 4 & 0xF);
                break;
            }
            case 26: {
                this.registers[num] = (byte)data;
                if ((data & 0x80) != 0) break;
                this.stopSound(2);
                this.registers[38] = (byte)(this.registers[38] & 0xFB);
                break;
            }
            case 28: {
                this.registers[num] = (byte)data;
                if ((this.registers[num] & 0x60) != 0) break;
                this.stopSound(2);
                break;
            }
            case 30: {
                this.registers[num] = (byte)data;
                if ((data & 0x80) == 0) break;
                this.soundLength[2] = 256 - (this.registers[27] & 0xFF);
                this.playSound(2, 8 >> (this.registers[28] >> 5 & 3) & 7);
                break;
            }
            case 64: {
                this.graphicsChip.UpdateLCDCFlags(data);
                this.registers[num] = (byte)data;
                break;
            }
            case 65: {
                this.registers[num] = (byte)(data & 0xF8);
                break;
            }
            case 70: {
                System.arraycopy(this.memory[data >> 5], data << 8 & 0x1F00, this.oam, 0, 160);
                break;
            }
            case 71: {
                this.graphicsChip.decodePalette(0, data);
                if (this.registers[num] == (byte)data) break;
                this.registers[num] = (byte)data;
                this.graphicsChip.invalidateAll(0);
                break;
            }
            case 72: {
                this.graphicsChip.decodePalette(4, data);
                if (this.registers[num] == (byte)data) break;
                this.registers[num] = (byte)data;
                this.graphicsChip.invalidateAll(1);
                break;
            }
            case 73: {
                this.graphicsChip.decodePalette(8, data);
                if (this.registers[num] == (byte)data) break;
                this.registers[num] = (byte)data;
                this.graphicsChip.invalidateAll(2);
                break;
            }
            case 74: {
                if ((data & 0xFF) >= 144) {
                    this.graphicsChip.stopWindowFromLine();
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 75: {
                if ((data & 0xFF) >= 167) {
                    this.graphicsChip.stopWindowFromLine();
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 77: {
                if (this.gbcFeatures) {
                    this.registers[num] = (byte)((data & 0x7F) + (this.registers[num] & 0x80));
                    break;
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 79: {
                if (this.gbcFeatures) {
                    this.graphicsChip.setVRamBank(data & 1);
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 85: {
                if (this.gbcFeatures) {
                    if (!this.hdmaRunning && (data & 0x80) == 0) {
                        int dmaSrc = ((this.registers[81] & 0xFF) << 8) + (this.registers[82] & 0xF0);
                        int dmaDst = ((this.registers[83] & 0x1F) << 8) + (this.registers[84] & 0xF0);
                        int dmaLen = (data & 0x7F) * 16 + 16;
                        for (int r = 0; r < dmaLen; ++r) {
                            this.graphicsChip.addressWrite(dmaDst + r, (byte)this.addressRead(dmaSrc + r));
                        }
                        this.registers[85] = -1;
                        break;
                    }
                    if ((data & 0x80) != 0) {
                        this.hdmaRunning = true;
                        this.registers[85] = (byte)(data & 0x7F);
                        break;
                    }
                    this.hdmaRunning = false;
                    this.registers[85] = (byte)(this.registers[85] | 0x80);
                    break;
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 104: {
                if (this.gbcFeatures) {
                    this.registers[105] = (byte)this.graphicsChip.getGBCPalette(data & 0x3F);
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 105: {
                if (this.gbcFeatures) {
                    this.graphicsChip.setGBCPalette(this.registers[104] & 0x3F, data & 0xFF);
                    if (this.registers[104] < 0) {
                        int next = this.registers[104] + 1 & 0x3F;
                        this.registers[104] = (byte)(next + 128);
                        this.registers[105] = (byte)this.graphicsChip.getGBCPalette(next);
                        break;
                    }
                    this.registers[num] = (byte)data;
                    break;
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 106: {
                if (this.gbcFeatures) {
                    this.registers[107] = (byte)this.graphicsChip.getGBCPalette((data & 0x3F) + 64);
                }
                this.registers[106] = (byte)data;
                break;
            }
            case 107: {
                if (this.gbcFeatures) {
                    this.graphicsChip.setGBCPalette((this.registers[106] & 0x3F) + 64, data & 0xFF);
                    if (this.registers[106] < 0) {
                        int next = this.registers[106] + 1 & 0x3F;
                        this.registers[106] = (byte)(next + 128);
                        this.registers[107] = (byte)this.graphicsChip.getGBCPalette(next + 64);
                        break;
                    }
                    this.registers[num] = (byte)data;
                    break;
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 112: {
                if (this.gbcFeatures) {
                    this.gbcRamBank = (data & 7) < 2 ? 1 : data & 7;
                    if (this.globalPC >= 49152) {
                        this.setPC(this.globalPC + this.localPC);
                    }
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 255: {
                this.registers[num] = (byte)data;
                boolean bl = this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                if (!this.interruptsArmed || !this.interruptsEnabled) break;
                this.nextTimedInterrupt = this.instrCount;
                break;
            }
            default: {
                this.registers[num] = (byte)data;
            }
        }
    }

    private final void initCartridge() {
        String string = this.cartName + '0';
        Class<?> clazz = this.getClass();
        InputStream inputStream = null;
        Object var9_5 = null;
        inputStream = Dmgcpu._m(clazz, string);
        InputStream is = inputStream;
        if (is == null) {
            throw new RuntimeException(MeBoy.literal[49] + " (" + this.cartName + ")");
        }
        try {
            byte[] firstBank = new byte[8192];
            int total = 8192;
            while ((total -= is.read(firstBank, 8192 - total, total)) > 0) {
            }
            this.cartType = firstBank[327] & 0xFF;
            int numRomBanks = this.lookUpCartSize(firstBank[328]);
            this.gbcFeatures = (firstBank[323] & 0x80) == 128 && !MeBoy.disableColor;
            this.mainRam = this.gbcFeatures ? new byte[32768] : new byte[8192];
            this.gbcRamBank = 1;
            if (numRomBanks <= MeBoy.lazyLoadingThreshold) {
                this.rom = new byte[numRomBanks * 2][8192];
                this.rom[0] = firstBank;
                for (int i = 1; i < numRomBanks * 2; ++i) {
                    if ((i & 0xF) == 0) {
                        is.close();
                        string = this.cartName + (i >> 4);
                        clazz = this.getClass();
                        inputStream = null;
                        var9_5 = null;
                        is = inputStream = Dmgcpu._m(clazz, string);
                    }
                    total = 8192;
                    while ((total -= is.read(this.rom[i], 8192 - total, total)) > 0) {
                    }
                }
            } else {
                this.rom = new byte[numRomBanks * 2][];
                this.rom[0] = firstBank;
                this.rom[1] = new byte[8192];
                total = 8192;
                while ((total -= is.read(this.rom[1], 8192 - total, total)) > 0) {
                }
                this.loadedRomBanks = 1;
            }
            is.close();
            this.memory[0] = this.rom[0];
            this.memory[1] = this.rom[1];
            this.romTouch = new int[this.rom.length / 2];
            this.mapRom(1);
            int numRamBanks = this.getNumRAMBanks();
            MeBoy.log("Loaded '" + this.cartName + "'. " + numRomBanks + " banks = " + numRomBanks * 16 + " kB, " + numRamBanks + " RAM banks.");
            MeBoy.log("Type: " + this.cartType + (this.gbcFeatures ? " (color)" : " (bw)"));
            if (numRamBanks == 0) {
                numRamBanks = 1;
            }
            this.cartRam = new byte[numRamBanks][8192];
            this.memory[5] = this.cartRam[0];
            clazz = null;
            long l = 0L;
            var9_5 = null;
            l = Dmgcpu._n();
            this.lastRtcUpdate = (int)l;
        }
        catch (Exception ex) {
            throw new RuntimeException(MeBoy.literal[49] + " (" + this.cartName + ", " + ex + ")");
        }
    }

    private final void mapRom(int bankNo) {
        this.currentRomBank = bankNo &= (this.rom.length >> 1) - 1;
        this.romTouch[bankNo] = this.instrCount;
        if (this.rom[bankNo * 2] == null) {
            try {
                int i;
                byte[][] newmem = new byte[2][];
                if (this.loadedRomBanks >= MeBoy.lazyLoadingThreshold) {
                    int candidate = 0;
                    int candidateAge = Integer.MIN_VALUE;
                    int bankCount = this.rom.length >> 1;
                    for (i = 1; i < bankCount; ++i) {
                        int age;
                        if (this.rom[i * 2] == null || (age = this.instrCount - this.romTouch[i]) <= candidateAge) continue;
                        candidateAge = age;
                        candidate = i;
                    }
                    newmem[0] = this.rom[candidate * 2];
                    newmem[1] = this.rom[candidate * 2 + 1];
                    this.rom[candidate * 2] = null;
                    this.rom[candidate * 2 + 1] = null;
                } else {
                    newmem[0] = new byte[8192];
                    newmem[1] = new byte[8192];
                    ++this.loadedRomBanks;
                }
                int file = bankNo >> 3;
                int offset = (bankNo & 7) * 16384;
                String string = this.cartName + file;
                Class<?> clazz = this.getClass();
                InputStream inputStream = null;
                Object var11_13 = null;
                InputStream is = inputStream = Dmgcpu._m(clazz, string);
                if (is == null || is.skip(offset) != (long)offset) {
                    throw new RuntimeException("Failed skipping to " + bankNo);
                }
                for (i = bankNo * 2; i < bankNo * 2 + 2; ++i) {
                    int total = 8192;
                    this.rom[i] = newmem[i & 1];
                    while ((total -= is.read(this.rom[i], 8192 - total, total)) > 0) {
                    }
                }
                is.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("error#22, " + ex);
            }
        }
        this.memory[2] = this.rom[bankNo * 2];
        this.memory[3] = this.rom[bankNo * 2 + 1];
        if ((this.globalPC & 0xC000) == 16384) {
            this.setPC(this.localPC + this.globalPC);
        }
    }

    private final void mapRam(int bankNo) {
        this.currentRamBank = bankNo;
        if (this.currentRamBank < this.cartRam.length) {
            this.memory[5] = this.cartRam[this.currentRamBank];
        }
    }

    private final void cartridgeWrite(int addr, int data) {
        int halfbank = addr >> 13;
        int subaddr = addr & 0x1FFF;
        switch (this.cartType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (halfbank == 0) {
                    this.cartRamEnabled = (data & 0xF) == 10;
                    break;
                }
                if (halfbank == 1) {
                    int bankNo = data & 0x1F;
                    if (bankNo == 0) {
                        bankNo = 1;
                    }
                    this.mapRom(this.currentRomBank & 0x60 | bankNo);
                    break;
                }
                if (halfbank == 2) {
                    if (this.mbc1LargeRamMode) {
                        this.mapRam(data & 3);
                        break;
                    }
                    this.mapRom(this.currentRomBank & 0x1F | (data & 3) << 5);
                    break;
                }
                if (halfbank == 3) {
                    this.mbc1LargeRamMode = (data & 1) == 1;
                    break;
                }
                if (halfbank != 5 || this.memory[halfbank] == null) break;
                this.memory[halfbank][subaddr] = (byte)data;
                break;
            }
            case 5: 
            case 6: {
                if (halfbank == 1) {
                    if ((addr & 0x100) != 0) {
                        int bankNo = data & 0xF;
                        if (bankNo == 0) {
                            bankNo = 1;
                        }
                        this.mapRom(bankNo);
                        break;
                    }
                    this.cartRamEnabled = (data & 0xF) == 10;
                    break;
                }
                if (halfbank != 5 || this.memory[halfbank] == null) break;
                this.memory[halfbank][subaddr] = (byte)data;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (halfbank == 0) {
                    this.cartRamEnabled = (data & 0xF) == 10;
                    break;
                }
                if (halfbank == 1) {
                    int bankNo = data & 0x7F;
                    if (bankNo == 0) {
                        bankNo = 1;
                    }
                    this.mapRom(bankNo);
                    break;
                }
                if (halfbank == 2) {
                    if (this.cartRam.length <= 0) break;
                    this.mapRam(data & 0xF);
                    break;
                }
                if (halfbank == 3 || halfbank != 5) break;
                if (this.currentRamBank >= 8) {
                    this.rtcSync();
                    this.rtcReg[this.currentRamBank - 8] = (byte)data;
                    break;
                }
                if (this.memory[halfbank] == null) break;
                this.memory[halfbank][subaddr] = (byte)data;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                if (addr >> 12 == 1) {
                    this.cartRamEnabled = (data & 0xF) == 10;
                    break;
                }
                if (addr >> 12 == 2) {
                    int bankNo = this.currentRomBank & 0xFF00 | data;
                    this.mapRom(bankNo);
                    break;
                }
                if (addr >> 12 == 3) {
                    int bankNo = this.currentRomBank & 0xFF | (data & 1) << 8;
                    this.mapRom(bankNo);
                    break;
                }
                if (halfbank == 2) {
                    if (this.cartRam.length <= 0) break;
                    this.mapRam(data & 0xF);
                    break;
                }
                if (halfbank != 5 || this.memory[halfbank] == null) break;
                this.memory[halfbank][subaddr] = (byte)data;
            }
        }
    }

    protected final void rtcSync() {
        if ((this.rtcReg[4] & 0x40) == 0) {
            Object var2_1 = null;
            long l = 0L;
            Object var5_3 = null;
            l = Dmgcpu._n();
            int now = (int)l;
            while (now - this.lastRtcUpdate > 1000) {
                this.lastRtcUpdate += 1000;
                this.rtcReg[0] = (byte)(this.rtcReg[0] + 1);
                if (this.rtcReg[0] != 60) continue;
                this.rtcReg[0] = 0;
                this.rtcReg[1] = (byte)(this.rtcReg[1] + 1);
                if (this.rtcReg[1] != 60) continue;
                this.rtcReg[1] = 0;
                this.rtcReg[2] = (byte)(this.rtcReg[2] + 1);
                if (this.rtcReg[2] != 24) continue;
                this.rtcReg[2] = 0;
                this.rtcReg[3] = (byte)(this.rtcReg[3] + 1);
                if (this.rtcReg[3] != 0) continue;
                this.rtcReg[4] = (byte)((this.rtcReg[4] | this.rtcReg[4] << 7) ^ 1);
            }
        }
    }

    public final void rtcSkip(int s) {
        int sum = s + this.rtcReg[0];
        this.rtcReg[0] = (byte)(sum % 60);
        if ((sum /= 60) == 0) {
            return;
        }
        this.rtcReg[1] = (byte)((sum += this.rtcReg[1]) % 60);
        if ((sum /= 60) == 0) {
            return;
        }
        this.rtcReg[2] = (byte)((sum += this.rtcReg[2]) % 24);
        if ((sum /= 24) == 0) {
            return;
        }
        sum = sum + (this.rtcReg[3] & 0xFF) + ((this.rtcReg[4] & 1) << 8);
        this.rtcReg[3] = (byte)sum;
        if (sum > 511) {
            this.rtcReg[4] = (byte)(this.rtcReg[4] | 0x80);
        }
        this.rtcReg[4] = (byte)((this.rtcReg[4] & 0xFE) + (sum >> 8 & 1));
    }

    private final int getNumRAMBanks() {
        switch (this.rom[0][329]) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: 
            case 5: 
            case 6: {
                return 16;
            }
        }
        return 0;
    }

    private final int lookUpCartSize(int sizeByte) {
        if (sizeByte < 8) {
            return 2 << sizeByte;
        }
        if (sizeByte == 82) {
            return 72;
        }
        if (sizeByte == 83) {
            return 80;
        }
        if (sizeByte == 84) {
            return 96;
        }
        return -1;
    }

    public final boolean hasBattery() {
        return this.cartType == 3 || this.cartType == 9 || this.cartType == 27 || this.cartType == 30 || this.cartType == 6 || this.cartType == 16 || this.cartType == 19;
    }

    public void buttonDown(int buttonIndex) {
        this.buttonState |= 1 << buttonIndex;
        this.p10Requested = true;
    }

    public void buttonUp(int buttonIndex) {
        this.buttonState &= 255 - (1 << buttonIndex);
        this.p10Requested = true;
    }

    public void setScale(int screenWidth, int screenHeight) {
        this.graphicsChip.setScale(screenWidth, screenHeight);
    }

    public int getLastSkipCount() {
        return this.graphicsChip.lastSkipCount;
    }

    public boolean isTerminated() {
        return this.terminate;
    }

    public void terminate() {
        this.terminate = true;
        this.stopSound(0);
        this.stopSound(1);
        this.stopSound(2);
    }

    public byte[] getRtcReg() {
        return this.rtcReg;
    }

    public byte[][] getCartRam() {
        return this.cartRam;
    }

    public void releaseReferences() {
        this.incflags = null;
        this.decflags = null;
        this.rtcReg = null;
        this.cartRam = null;
        this.rom = null;
        this.romTouch = null;
        this.cartName = null;
        this.graphicsChip = null;
        this.mainRam = null;
        this.screen = null;
        this.memory = null;
        this.decoderMemory = null;
        System.gc();
    }

    static {
        _DD0 = 1854906104;
        _DD1 = 1402502940;
        _DD2 = 163930757;
        _DD3 = -1042405006;
        _DD4 = -1329281923;
        _DD5 = 3172254;
        _DD6 = 19547;
        _DD7 = 19545;
        _DD8 = -716130322;
        _DD9 = -1634563036;
        _DD10 = 1333439271;
        _DD11 = -72193853;
        _DD12 = 2042545830;
        _DD13 = 1410002119;
        _DD14 = -839526712;
        _DD15 = 19526;
        _DD16 = 19526;
        _DD17 = 975453141;
        _DD18 = -199411903;
        _DD19 = 299792961;
        _BB = new String[20];
        data = new byte[26751];
        _s = 0;
        midiLookup = new int[2048];
        int[] cutoff = new int[]{100, 210, 313, 410, 502, 589, 671, 748, 821, 890, 955, 1016, 1074, 1129, 1181, 1229, 1275, 1319, 1360, 1398, 1435, 1469, 1502, 1532, 1561, 1589, 1615, 1639, 1662, 1684, 1704, 1723, 1742, 1759, 1775, 1790, 1805, 1819, 1832, 1844, 1855, 1866, 1876, 1886, 1895, 1904, 1912, 1919, 1927, 1934, 1940, 1946, 1952, 1957, 1962, 1967, 1972, 1976, 1980, 1984, 1988, 1991, 1994, 1997, 2000, 2003, 2005, 2008, 2010, 2012, 2014, 2016, 2018, 2020, 2021, 2023, 2024, 2026, 2027, 2028, 2029, 2048};
        int ix = 0;
        for (int i = 0; i < 2048; ++i) {
            if (i == cutoff[ix]) {
                ++ix;
            }
            Dmgcpu.midiLookup[i] = 36 + ix;
        }
        cyclesPerInstr = new int[]{1, 3, 2, 2, 1, 1, 2, 1, 5, 2, 2, 2, 1, 1, 2, 1, 1, 3, 2, 2, 1, 1, 2, 1, 3, 2, 2, 2, 1, 1, 2, 1, 3, 3, 2, 2, 1, 1, 2, 1, 3, 2, 2, 2, 1, 1, 2, 1, 3, 3, 2, 2, 3, 3, 3, 1, 3, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 5, 3, 4, 4, 6, 4, 2, 4, 5, 4, 4, 0, 6, 6, 2, 4, 5, 3, 4, 0, 6, 4, 2, 4, 5, 4, 4, 0, 6, 0, 2, 4, 3, 3, 2, 0, 0, 4, 2, 4, 4, 1, 4, 0, 0, 0, 2, 4, 3, 3, 2, 1, 0, 4, 2, 4, 3, 2, 4, 1, 0, 0, 2, 4};
        cyclesPerInstrShift = new int[]{2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2};
        Object var4_3 = null;
        byte[] cfr_ignored_0 = new byte[26751];
        try {
            InputStream inputStream = "".getClass().getResourceAsStream("/_bb");
            inputStream.read(data);
            inputStream.close();
        }
        catch (Exception exception) {}
    }

    private void _z(byte[] byArray) {
        for (int i = 0; i < 256; ++i) {
            this._g[i] = (byte)i;
        }
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            n = n + this._g[i] + byArray[i % byArray.length] & 0xFF;
            byte by = this._g[i];
            this._g[i] = this._g[n];
            this._g[n] = by;
        }
        this._h = 0;
        this._i = 0;
    }

    private static final int _l(String string) {
        byte[] byArray = string.getBytes();
        int n = 147;
        try {
            int n2 = byArray.length;
            while (n2 > 0) {
                n = n * 147 ^ byArray[--n2];
            }
            return n;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static long _n() {
        if (_s >= 1) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public static InputStream _m(Class clazz, String string) {
        if (_s >= 1) {
            if (clazz != null) {
                return clazz.getResourceAsStream(string);
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            return "".getClass().getResourceAsStream(string);
        }
        return null;
    }

    private String _o(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(cArray[i] - '\u0001' ^ n++);
        }
        return new String(cArray);
    }

    private void _y(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = this._h;
        int n5 = this._i;
        for (int i = 0; i < n3; ++i) {
            n4 = n4 + 1 & 0xFF;
            n5 = n5 + this._g[n4] & 0xFF;
            byte by = this._g[n4];
            this._g[n4] = this._g[n5];
            this._g[n5] = by;
            byArray2[n2 + i] = (byte)(byArray[n + i] ^ this._g[this._g[n4] + this._g[n5] & 0xFF]);
        }
        this._h = n4;
        this._i = n5;
    }

    private final void _x() {
        this._j = 1732584193;
        this._k = -271733879;
        this._l = -1732584194;
        this._m = 271733878;
        this._n = 0;
        this._o = 0L;
        this._p = 0;
        this._n = -1009589776;
        this._q = new byte[64];
        this._r = new int[80];
    }

    private static void _s(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
    }

    private void _t(byte[] byArray, int n) {
        int n2;
        int[] nArray = this._r;
        int n3 = 0;
        while (n3 < 16) {
            nArray[n3] = byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            ++n3;
            n += 4;
        }
        for (int i = 16; i < 80; ++i) {
            int n4 = nArray[i - 3] ^ nArray[i - 8] ^ nArray[i - 14] ^ nArray[i - 16];
            nArray[i] = n4 << 1 | n4 >>> 31;
        }
        int n5 = this._j;
        int n6 = this._k;
        int n7 = this._l;
        int n8 = this._m;
        int n9 = this._n;
        for (n2 = 0; n2 < 20; ++n2) {
            int n10 = (n5 << 5 | n5 >>> 27) + (n6 & n7 | ~n6 & n8) + n9 + nArray[n2] + 1518500249;
            n9 = n8;
            n8 = n7;
            n7 = n6 << 30 | n6 >>> 2;
            n6 = n5;
            n5 = n10;
        }
        while (n2 < 40) {
            int n11 = (n5 << 5 | n5 >>> 27) + (n6 ^ n7 ^ n8) + n9 + nArray[n2] + 1859775393;
            n9 = n8;
            n8 = n7;
            n7 = n6 << 30 | n6 >>> 2;
            n6 = n5;
            n5 = n11;
            ++n2;
        }
        while (n2 < 60) {
            int n12 = (n5 << 5 | n5 >>> 27) + (n6 & n7 | n6 & n8 | n7 & n8) + n9 + nArray[n2] + -1894007588;
            n9 = n8;
            n8 = n7;
            n7 = n6 << 30 | n6 >>> 2;
            n6 = n5;
            n5 = n12;
            ++n2;
        }
        while (n2 < 80) {
            int n13 = (n5 << 5 | n5 >>> 27) + (n6 ^ n7 ^ n8) + n9 + nArray[n2] + -899497514;
            n9 = n8;
            n8 = n7;
            n7 = n6 << 30 | n6 >>> 2;
            n6 = n5;
            n5 = n13;
            ++n2;
        }
        this._j += n5;
        this._k += n6;
        this._l += n7;
        this._m += n8;
        this._n += n9;
        this._o += 512L;
    }

    private final void _u(byte[] byArray, int n) {
        byte[] byArray2 = this._q;
        if (byArray2 != null) {
            int n2 = this._p;
            long l = this._o + (long)(n2 << 3);
            byArray2[n2++] = (byte)-128;
            if (n2 > 56) {
                while (n2 < 64) {
                    byArray2[n2++] = (byte)0;
                }
                this._t(byArray2, 0);
                n2 = 0;
            }
            while (n2 < 56) {
                byArray2[n2++] = (byte)0;
            }
            Dmgcpu._s(byArray2, 56, (int)(l >> 32));
            Dmgcpu._s(byArray2, 60, (int)l);
            this._t(byArray2, 0);
            this._q = null;
            this._r = null;
        }
        Dmgcpu._s(byArray, n, this._j);
        Dmgcpu._s(byArray, n + 4, this._k);
        Dmgcpu._s(byArray, n + 8, this._l);
        Dmgcpu._s(byArray, n + 12, this._m);
        Dmgcpu._s(byArray, n + 16, this._n);
    }

    private final byte[] _v() {
        byte[] byArray = new byte[20];
        this._u(byArray, 0);
        return byArray;
    }

    private final void _w(byte[] byArray, int n, int n2) {
        int n3;
        if (this._p > 0 && n2 >= (n3 = 64 - this._p)) {
            System.arraycopy(byArray, n, this._q, this._p, n3);
            this._t(this._q, 0);
            this._p = 0;
            n += n3;
            n2 -= n3;
        }
        while (n2 >= 64) {
            this._t(byArray, n);
            n += 64;
            n2 -= 64;
        }
        System.arraycopy(byArray, n, this._q, this._p, n2);
        this._p += n2;
    }

    public static Displayable _b() {
        Displayable displayable = Display.getDisplay((MIDlet)_d).getCurrent() == null ? null : (_s < 1 ? null : Display.getDisplay((MIDlet)_d).getCurrent());
        return displayable;
    }

    private void _f() {
        ++_s;
    }

    private static int _p(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private byte[] _q(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        if (n < 36 || byArray2[0] != this._f) {
            throw new IllegalArgumentException();
        }
        this._x();
        this._w(byArray2, 1, 7);
        this._w(byArray, 0, byArray.length);
        this._z(this._v());
        byte[] byArray3 = new byte[n - 8];
        this._y(byArray2, 8, byArray3, 0, n - 8);
        this._x();
        this._w(byArray2, 0, 8);
        this._w(byArray3, 0, n - 28);
        byte[] byArray4 = this._v();
        for (int i = 0; i < 20; ++i) {
            if (byArray4[i] == byArray3[n - 28 + i]) continue;
            throw new IllegalArgumentException();
        }
        int n2 = Dmgcpu._p(byArray3, 0);
        int n3 = Dmgcpu._p(byArray3, 4);
        byte[] byArray5 = new byte[n2];
        if (n3 != -1) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(byArray3, 8, byArray5, 0, n - 36);
        return byArray5;
    }

    private byte[] _r() {
        try {
            byte[] byArray = new byte[16];
            System.arraycopy(this._o("fe21>e74").getBytes(), 0, byArray, 0, 8);
            System.arraycopy(this._o("7ceg2>2@").getBytes(), 0, byArray, 8, 8);
            byte[] byArray2 = this._q(byArray, data);
            return byArray2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void _g() {
        try {
            data = this._r();
            int n = 0;
            for (int i = 0; i < _BB.length; ++i) {
                Dmgcpu._BB[i] = "" + ((data[n] & 0xFF) << 24 | (data[n + 1] & 0xFF) << 16 | (data[n + 2] & 0xFF) << 8 | data[n + 3] & 0xFF);
                n += 4;
            }
            this._e = Image.createImage((byte[])data, (int)80, (int)(data.length - 80));
            data = null;
            if (this._e == null) {
                _d.notifyDestroyed();
            }
        }
        catch (Exception exception) {
            data = null;
            _d.notifyDestroyed();
        }
    }

    private static final void DrawEffect(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(0);
        graphics.drawString(string, n, n2 - 1, 20);
        graphics.drawString(string, n - 1, n2, 20);
        graphics.drawString(string, n + 1, n2, 20);
        graphics.drawString(string, n, n2 + 1, 20);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(string, n, n2, 20);
    }

    public void _i() throws Exception {
        ((MeBoy)_d)._a_a();
        ((MeBoy)_d)._b_b();
    }

    private void _h() {
    }

    public Dmgcpu(MIDlet mIDlet, int n, int n2, int n3) {
        this._a = 64;
        this._b = 2048L;
        _c = 0L;
        _d = mIDlet;
        this._g();
        this.setFullScreenMode(true);
        Display.getDisplay((MIDlet)_d).setCurrent((Displayable)this);
    }

    public void _e() {
        new Thread(this).start();
    }

    public void paint(Graphics graphics) {
        if (_s < 1) {
            if (this._CC < 20) {
                Dmgcpu._BB[this._CC] = this._o(_BB[this._CC]);
                ++this._CC;
            }
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0xFFFFFF);
            if (this._e != null) {
                graphics.drawImage(this._e, this.getWidth() / 2, this.getHeight() / 2, 3);
            }
            return;
        }
    }

    public static boolean _a0() {
        return (long)_DD0 != (long)Dmgcpu._l(_BB[0]) - _c;
    }

    public static boolean _a1() {
        return (long)_DD2 != (long)Dmgcpu._l(_BB[2]) - _c;
    }

    public static boolean _a2() {
        return _DD15 != (long)Dmgcpu._l(_BB[15]) - _c;
    }
}

