/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordStore;

public class Bluetooth
implements DiscoveryListener,
CommandListener,
Runnable {
    private static final UUID MeBoyUUID = new UUID("ceb15f4a19eb4db28d1c40eb0f091607", false);
    private MeBoy parent;
    private String connectionURL;
    private String savegameDisplayName;
    private String savegameFilename;
    private String savegameCartID;
    private String sendgameMode = "s";
    private byte[] savegameData;
    private Vector remoteDevices = new Vector();
    private DiscoveryAgent discoveryAgent;
    private boolean discoveryAgentIsInquiring;
    private boolean discoveryAgentIsScanning;
    private int discoveryAgentId;
    private UUID[] uuidSet = new UUID[]{new UUID(4353L)};
    private int[] attrSet = new int[]{256};
    private Form waitForm;
    private List mainList;
    private Form receiveForm;
    private List savegameList;
    private List suspendgameList;
    private List deviceList;
    private Gauge gauge;
    private Vector savegameCartIDs;
    private Vector savegameFilenames;
    private boolean iAmSender;
    private StreamConnectionNotifier notifier;
    private StreamConnection connection;
    private DataInputStream is;
    private DataOutputStream os;
    private boolean poisoned;

    public Bluetooth(MeBoy parent) {
        this.parent = parent;
        this.showMain();
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass cod) {
        this.remoteDevices.addElement(remoteDevice);
    }

    public void inquiryCompleted(int discType) {
        if (this.poisoned) {
            return;
        }
        this.discoveryAgentIsInquiring = false;
        if (discType != 0) {
            MeBoy.log("disctype = " + discType);
            return;
        }
        if (this.remoteDevices.size() == 0) {
            this.parent.cancelBluetooth(MeBoy.literal[60]);
            return;
        }
        this.showDevice();
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        Object var3_3 = null;
        if (Dmgcpu._a0()) {
            return;
        }
        if (this.poisoned) {
            return;
        }
        block0: for (int i = 0; i < servRecord.length; ++i) {
            DataElement serviceElement = servRecord[i].getAttributeValue(1);
            Enumeration serviceIDs = (Enumeration)(serviceElement == null ? null : serviceElement.getValue());
            if (serviceIDs == null) continue;
            while (serviceIDs.hasMoreElements()) {
                UUID serviceID = (UUID)((DataElement)serviceIDs.nextElement()).getValue();
                if (!serviceID.equals((Object)MeBoyUUID)) continue;
                this.connectionURL = servRecord[i].getConnectionURL(0, false);
                if (this.connectionURL != null && this.connectionURL.length() > 0) {
                    return;
                }
                long channel = Bluetooth.getChannel(servRecord[i].getAttributeValue(4));
                if (channel <= 0L) continue block0;
                this.connectionURL = "btspp://" + servRecord[i].getHostDevice().getBluetoothAddress() + ":" + channel + ";authenticate=false;encrypt=false";
                return;
            }
        }
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        Object var3_3 = null;
        if (Dmgcpu._a1()) {
            return;
        }
        if (this.poisoned) {
            return;
        }
        this.discoveryAgentIsScanning = false;
        if (this.connectionURL != null && respCode == 1) {
            this.iAmSender = true;
            new Thread(this).start();
            this.showWait(MeBoy.literal[61], true);
        } else {
            this.parent.cancelBluetooth(MeBoy.literal[62]);
        }
    }

    public void showWait(String message) {
        this.showWait(message, false);
    }

    public void showWait(String message, boolean progressBar) {
        this.waitForm = new Form(MeBoy.literal[4]);
        this.waitForm.append(message);
        if (progressBar) {
            this.gauge = new Gauge("", false, 100, 5);
            this.waitForm.append((Item)this.gauge);
        }
        this.waitForm.setCommandListener((CommandListener)this);
        this.waitForm.addCommand(new Command(MeBoy.literal[57], 3, 0));
        MeBoy.display.setCurrent((Displayable)this.waitForm);
    }

    private void waitCommand() {
        Object var1_1 = null;
        if (Dmgcpu._a1()) {
            return;
        }
        this.parent.cancelBluetooth();
    }

    private void showMain() {
        this.mainList = new List(MeBoy.literal[4], 3);
        this.mainList.append(MeBoy.literal[52], null);
        if (MeBoy.suspendName20.length > 0) {
            this.mainList.append(MeBoy.literal[54], null);
        }
        this.mainList.append(MeBoy.literal[56], null);
        this.mainList.addCommand(new Command(MeBoy.literal[10], 2, 1));
        this.mainList.setCommandListener((CommandListener)this);
        MeBoy.display.setCurrent((Displayable)this.mainList);
    }

    private void mainCommand(Command com) {
        Object var2_2 = null;
        if (Dmgcpu._a1()) {
            return;
        }
        if (com.getCommandType() == 2) {
            this.parent.cancelBluetooth();
        } else {
            String item = this.mainList.getString(this.mainList.getSelectedIndex());
            if (item == MeBoy.literal[52]) {
                this.showSavegameSelect();
            } else if (item == MeBoy.literal[54]) {
                this.showSuspendGameSelect();
            } else if (item.equals(MeBoy.literal[56])) {
                this.showReceive(false);
            }
        }
        this.mainList = null;
    }

    private void showSavegameSelect() {
        this.savegameList = new List(MeBoy.literal[53], 3);
        this.savegameCartIDs = new Vector();
        this.savegameFilenames = new Vector();
        this.parent.addSavegamesToList(this.savegameList, this.savegameCartIDs, this.savegameFilenames);
        if (this.savegameList.size() == 0) {
            this.parent.cancelBluetooth(MeBoy.literal[65]);
            return;
        }
        this.savegameList.addCommand(new Command(MeBoy.literal[10], 2, 1));
        this.savegameList.setCommandListener((CommandListener)this);
        MeBoy.display.setCurrent((Displayable)this.savegameList);
    }

    private void startInquiry() throws BluetoothStateException, InterruptedException {
        LocalDevice localDevice = LocalDevice.getLocalDevice();
        this.discoveryAgent = localDevice.getDiscoveryAgent();
        for (int i = 0; i < 10; ++i) {
            try {
                this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                this.discoveryAgentIsInquiring = true;
                break;
            }
            catch (BluetoothStateException bse) {
                this.showWait(MeBoy.literal[66]);
                Thread.sleep(500L);
                continue;
            }
        }
        if (!this.discoveryAgentIsInquiring) {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
            this.discoveryAgentIsInquiring = true;
        }
        this.showWait(MeBoy.literal[66]);
    }

    private void savegameSelectCommand(Command com) {
        if (com.getCommandType() == 2) {
            this.showMain();
            this.savegameList = null;
            return;
        }
        this.savegameDisplayName = this.savegameList.getString(this.savegameList.getSelectedIndex());
        this.savegameCartID = (String)this.savegameCartIDs.elementAt(this.savegameList.getSelectedIndex());
        this.savegameFilename = (String)this.savegameFilenames.elementAt(this.savegameList.getSelectedIndex());
        this.sendgameMode = "r";
        this.savegameList = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)("20R_" + this.savegameCartID), (boolean)false);
            this.savegameData = rs.getRecord(1);
            rs.closeRecordStore();
            this.startInquiry();
        }
        catch (Exception e) {
            this.parent.cancelBluetooth(e);
            return;
        }
    }

    private void showSuspendGameSelect() {
        this.suspendgameList = new List(MeBoy.literal[55], 3);
        int i = 0;
        while (true) {
            if (i >= MeBoy.suspendName20.length) break;
            this.suspendgameList.append(MeBoy.suspendName20[i], null);
            ++i;
        }
        this.suspendgameList.addCommand(new Command(MeBoy.literal[10], 2, 1));
        this.suspendgameList.setCommandListener((CommandListener)this);
        MeBoy.display.setCurrent((Displayable)this.suspendgameList);
    }

    private void suspendGameSelectCommand(Command com) {
        if (com.getCommandType() == 2) {
            this.showMain();
            this.suspendgameList = null;
            return;
        }
        this.savegameDisplayName = this.suspendgameList.getString(this.suspendgameList.getSelectedIndex());
        this.savegameFilename = "";
        this.sendgameMode = "s";
        this.suspendgameList = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)("20S_" + this.savegameDisplayName), (boolean)false);
            this.savegameCartID = new String(rs.getRecord(1));
            this.savegameData = rs.getRecord(2);
            rs.closeRecordStore();
            int ix = this.savegameDisplayName.indexOf(58);
            if (ix > 0) {
                this.savegameDisplayName = this.savegameDisplayName.substring(ix + 2);
            }
            this.startInquiry();
        }
        catch (Exception e) {
            this.parent.cancelBluetooth(e);
            return;
        }
    }

    private void showDevice() {
        try {
            this.deviceList = new List(MeBoy.literal[70], 3);
            for (int i = 0; i < this.remoteDevices.size(); ++i) {
                String device;
                try {
                    device = ((RemoteDevice)this.remoteDevices.elementAt(i)).getFriendlyName(true);
                }
                catch (Exception ex) {
                    device = ((RemoteDevice)this.remoteDevices.elementAt(i)).getBluetoothAddress();
                }
                this.deviceList.append(device, null);
            }
            this.deviceList.addCommand(new Command(MeBoy.literal[57], 3, 1));
            this.deviceList.setCommandListener((CommandListener)this);
            MeBoy.display.setCurrent((Displayable)this.deviceList);
        }
        catch (Exception e) {
            this.parent.cancelBluetooth(e);
        }
    }

    private void deviceCommand(Command com) {
        if (com.getCommandType() == 3) {
            this.parent.cancelBluetooth();
            return;
        }
        int selectedDevice = this.deviceList.getSelectedIndex();
        try {
            RemoteDevice remoteDevice = (RemoteDevice)this.remoteDevices.elementAt(selectedDevice);
            this.discoveryAgentId = this.discoveryAgent.searchServices(this.attrSet, this.uuidSet, remoteDevice, (DiscoveryListener)this);
            this.discoveryAgentIsScanning = true;
        }
        catch (Exception e) {
            this.parent.cancelBluetooth(e);
            return;
        }
        this.showWait(MeBoy.literal[67]);
    }

    private void showReceive(boolean gotConnection) {
        this.receiveForm = new Form(MeBoy.literal[56]);
        this.receiveForm.addCommand(new Command(MeBoy.literal[57], 3, 1));
        this.receiveForm.setCommandListener((CommandListener)this);
        if (gotConnection) {
            this.receiveForm.append(MeBoy.literal[71]);
            this.gauge = new Gauge("", false, 100, 0);
            this.receiveForm.append((Item)this.gauge);
        } else {
            this.receiveForm.append(MeBoy.literal[68]);
            this.iAmSender = false;
            new Thread(this).start();
        }
        MeBoy.display.setCurrent((Displayable)this.receiveForm);
    }

    private void receiveCommand(Command com) {
        if (com.getCommandType() == 3) {
            this.parent.cancelBluetooth();
        }
    }

    public void tearDown() {
        if (this.poisoned) {
            return;
        }
        this.poisoned = true;
        if (this.discoveryAgent != null) {
            if (this.discoveryAgentIsScanning) {
                this.discoveryAgent.cancelServiceSearch(this.discoveryAgentId);
            } else if (this.discoveryAgentIsInquiring) {
                this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
            }
            this.discoveryAgent = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.connection = null;
        }
        if (this.notifier != null) {
            try {
                this.notifier.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.notifier = null;
        }
        this.mainList = null;
        this.receiveForm = null;
        this.savegameList = null;
        this.deviceList = null;
        System.gc();
    }

    public void commandAction(Command com, Displayable s) {
        if (s == this.waitForm) {
            this.waitCommand();
        } else if (s == this.mainList) {
            this.mainCommand(com);
        } else if (s == this.savegameList) {
            this.savegameSelectCommand(com);
        } else if (s == this.suspendgameList) {
            this.suspendGameSelectCommand(com);
        } else if (s == this.deviceList) {
            this.deviceCommand(com);
        } else if (s == this.receiveForm) {
            this.receiveCommand(com);
        }
    }

    private void send() throws Exception {
        this.connection = (StreamConnection)Connector.open((String)this.connectionURL);
        this.is = this.connection.openDataInputStream();
        this.os = this.connection.openDataOutputStream();
        this.os.writeUTF("MeBoy20");
        this.os.flush();
        String ack = this.is.readUTF();
        if (ack.equals("version")) {
            throw new IOException(MeBoy.literal[69]);
        }
        if (!ack.equals("go")) {
            throw new IOException("read " + ack);
        }
        this.os.writeUTF(this.sendgameMode);
        this.os.writeUTF(this.savegameDisplayName);
        this.os.writeUTF(this.savegameFilename);
        this.os.writeUTF(this.savegameCartID);
        this.os.writeInt(this.savegameData.length);
        int lastPercent = 0;
        for (int i = 0; i < this.savegameData.length; i += 512) {
            int length = Math.min(this.savegameData.length - i, 512);
            this.os.write(this.savegameData, i, length);
            this.os.flush();
            int percent = 100 * i / this.savegameData.length;
            if (percent <= lastPercent + 10) continue;
            this.gauge.setValue(percent);
            Thread.sleep(50L);
            lastPercent = percent;
        }
        this.gauge.setValue(100);
        ack = this.is.readUTF();
        if (!ack.equals("ok")) {
            throw new IOException("read " + ack);
        }
        this.parent.finishBluetooth();
    }

    private void receive() throws Exception {
        int a;
        String serviceURL = "btspp://localhost:" + MeBoyUUID + ";authenticate=false;encrypt=false;name=MeBoy";
        this.notifier = (StreamConnectionNotifier)Connector.open((String)serviceURL);
        this.connection = this.notifier.acceptAndOpen();
        this.showReceive(true);
        this.is = this.connection.openDataInputStream();
        this.os = this.connection.openDataOutputStream();
        String protocol = this.is.readUTF();
        if (!protocol.equals("MeBoy20")) {
            this.os.writeUTF("version");
            this.os.flush();
            throw new IOException("read " + protocol);
        }
        this.os.writeUTF("go");
        this.os.flush();
        String mode = this.is.readUTF();
        if (!mode.equals("r") && !mode.equals("s")) {
            throw new IOException("invalid mode: " + mode);
        }
        String gameDisplayName = this.is.readUTF();
        String gameFileName = this.is.readUTF();
        String gameCartID = this.is.readUTF();
        int length = this.is.readInt();
        byte[] savegame = new byte[length];
        this.gauge.setMaxValue(100);
        this.gauge.setValue(0);
        int offset = 0;
        int lastPercent = 0;
        while (offset < length && (a = this.is.read(savegame, offset, length - offset)) != -1) {
            int percent = 100 * (offset += a) / length;
            if (percent <= lastPercent + 10) continue;
            this.gauge.setValue(percent);
            Thread.sleep(50L);
            lastPercent = percent;
        }
        if (offset != length) {
            throw new IOException("read " + offset + "/" + length);
        }
        this.os.writeUTF("ok");
        this.os.flush();
        this.parent.finishBluetoothReceive(mode, gameDisplayName, gameFileName, gameCartID, savegame);
    }

    public void run() {
        try {
            if (this.iAmSender) {
                this.send();
            } else {
                this.receive();
            }
        }
        catch (InterruptedIOException e) {
            this.parent.cancelBluetooth();
        }
        catch (Exception e) {
            this.parent.cancelBluetooth(e);
        }
    }

    static long getChannel(DataElement list) {
        try {
            Enumeration e = (Enumeration)list.getValue();
            while (e.hasMoreElements()) {
                DataElement d = (DataElement)e.nextElement();
                if (48 == d.getDataType() || 56 == d.getDataType()) {
                    long r = Bluetooth.getChannel(d);
                    if (r <= 0L) continue;
                    return r;
                }
                if (24 != d.getDataType() || !d.getValue().equals(new UUID(3L))) continue;
                DataElement channelRFCOMM = (DataElement)e.nextElement();
                if (11 == channelRFCOMM.getDataType() || 12 == channelRFCOMM.getDataType() || 20 == channelRFCOMM.getDataType()) {
                    byte[] bytes = (byte[])channelRFCOMM.getValue();
                    return bytes[0];
                }
                return channelRFCOMM.getLong();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    static boolean available() {
        return true;
    }
}

