/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Actions.CActExtension;
import Application.CRunApp;
import Banks.CImage;
import Banks.CImageBank;
import Conditions.CCndExtension;
import Expressions.CValue;
import Extensions.CRunExtension;
import Movements.CMoveExtension;
import OI.CObjectCommon;
import Objects.CObject;
import RunLoop.CBackDrawPaste;
import RunLoop.CBkd2;
import RunLoop.CCreateObjectInfo;
import RunLoop.CRun;
import Services.CBinaryFile;
import Services.CFile;
import Services.CRect;
import Sprites.CMask;
import Sprites.CSprite;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CExtension
extends CObject {
    public CRunExtension ext;
    boolean noHandle = false;
    public int privateData = 0;
    public int objectCount;
    public int objectNumber;

    public CExtension(int n, CRun cRun) {
        this.ext = cRun.rhApp.extLoader.loadRunObject(n);
    }

    public void init(CObjectCommon cObjectCommon, CCreateObjectInfo cCreateObjectInfo) {
        this.ext.init(this);
        CBinaryFile cBinaryFile = null;
        if (cObjectCommon.ocExtension != null) {
            cBinaryFile = new CBinaryFile(cObjectCommon.ocExtension, this.hoAdRunHeader.rhApp.bUnicode);
        }
        this.privateData = cObjectCommon.ocPrivate;
        this.ext.createRunObject(cBinaryFile, cCreateObjectInfo, cObjectCommon.ocVersion);
    }

    public void handle() {
        if ((this.hoOEFlags & 0x200) != 0) {
            this.ros.handle();
        } else if ((this.hoOEFlags & 0x30) == 16 || (this.hoOEFlags & 0x30) == 48) {
            this.rom.move();
        } else if ((this.hoOEFlags & 0x30) == 32) {
            this.roa.animate();
        }
        int n = 0;
        if (!this.noHandle) {
            n = this.ext.handleRunObject();
        }
        if ((n & 2) != 0) {
            this.noHandle = true;
        }
        if (this.roc != null && this.roc.rcChanged) {
            n |= 1;
            this.roc.rcChanged = false;
        }
        if ((n & 1) != 0) {
            this.modif();
        }
    }

    public void modif() {
        if (this.ros != null) {
            this.ros.modifRoutine();
        } else if ((this.hoOEFlags & 2) != 0) {
            this.hoAdRunHeader.modif_RedrawLevel(this);
        } else {
            this.ext.displayRunObject(null);
        }
    }

    public void display() {
    }

    public void kill(boolean bl) {
        this.ext.destroyRunObject(bl);
    }

    public void killBack() {
        this.ext.killBackground();
    }

    public void getZoneInfos() {
        this.ext.getZoneInfos();
        this.hoRect.left = this.hoX - this.hoAdRunHeader.rhWindowX - this.hoImgXSpot;
        this.hoRect.right = this.hoRect.left + this.hoImgWidth;
        this.hoRect.top = this.hoY - this.hoAdRunHeader.rhWindowY - this.hoImgYSpot;
        this.hoRect.bottom = this.hoRect.top + this.hoImgHeight;
    }

    public void saveBack(Image image) {
        this.ext.saveBackground(image);
    }

    public void restoreBack(Graphics graphics) {
        this.ext.restoreBackground(graphics);
    }

    public CMask getCollisionMask(int n) {
        return this.ext.getRunObjectCollisionMask(n);
    }

    public void draw(Graphics graphics) {
        Image image = this.ext.getRunObjectSurface();
        if (image != null) {
            graphics.drawImage(image, this.hoRect.top, this.hoRect.left, 20);
        } else {
            this.ext.displayRunObject(graphics);
        }
    }

    public void spriteDraw(Graphics graphics, CSprite cSprite, CImageBank cImageBank, int n, int n2) {
        Image image = this.ext.getRunObjectSurface();
        if (image != null) {
            graphics.drawImage(image, n, n2, 20);
        } else {
            this.ext.displayRunObject(graphics);
        }
    }

    public void spriteSave(Graphics graphics, Image image, CSprite cSprite, int n, int n2) {
        this.ext.saveBackground(image);
    }

    public void spriteKill(CSprite cSprite) {
        this.ext.killBackground();
    }

    public void spriteRestore(Graphics graphics, Image image, CSprite cSprite, int n, int n2) {
        this.ext.restoreBackground(graphics);
    }

    public CMask spriteGetMask() {
        return this.ext.getRunObjectCollisionMask(CMask.GCMF_OBSTACLE);
    }

    public boolean condition(int n, CCndExtension cCndExtension) {
        return this.ext.condition(n, cCndExtension);
    }

    public void action(int n, CActExtension cActExtension) {
        this.ext.action(n, cActExtension);
    }

    public CValue expression(int n) {
        return this.ext.expression(n);
    }

    public int getFixedValue() {
        return (this.hoCreationId << 16) + (this.hoNumber & 0xFFFF);
    }

    public CRunApp getApplication() {
        return this.hoAdRunHeader.rhApp;
    }

    public void loadImageList(short[] sArray) {
        this.hoAdRunHeader.rhApp.imageBank.loadImageList(sArray);
    }

    public CImage getImage(short s) {
        return this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(s);
    }

    public int getX() {
        return this.hoX;
    }

    public int getY() {
        return this.hoY;
    }

    public int getWidth() {
        return this.hoImgWidth;
    }

    public int getHeight() {
        return this.hoImgHeight;
    }

    public void setX(int n) {
        if (this.rom != null) {
            this.rom.rmMovement.setXPosition(n);
        } else {
            this.hoX = n;
            if (this.roc != null) {
                this.roc.rcChanged = true;
                this.roc.rcCheckCollides = true;
            }
        }
    }

    public void setY(int n) {
        if (this.rom != null) {
            this.rom.rmMovement.setYPosition(n);
        } else {
            this.hoY = n;
            if (this.roc != null) {
                this.roc.rcChanged = true;
                this.roc.rcCheckCollides = true;
            }
        }
    }

    public void setWidth(int n) {
        this.hoImgWidth = n;
        this.hoRect.right = this.hoRect.left + n;
    }

    public void setHeight(int n) {
        this.hoImgHeight = n;
        this.hoRect.bottom = this.hoRect.top + n;
    }

    public int scaleX(int n) {
        return this.hoAdRunHeader.scaleX(n);
    }

    public int scaleY(int n) {
        return this.hoAdRunHeader.scaleY(n);
    }

    public void reHandle() {
        this.noHandle = false;
    }

    public void generateEvent(int n, int n2) {
        if (this.hoAdRunHeader.rh2PauseCompteur == 0) {
            int n3 = this.hoAdRunHeader.rhEvtProg.rhCurParam0;
            this.hoAdRunHeader.rhEvtProg.rhCurParam0 = n2;
            n = -(n + 80 + 1) << 16;
            this.hoAdRunHeader.rhEvtProg.handle_Event(this, n |= this.hoType & 0xFFFF);
            this.hoAdRunHeader.rhEvtProg.rhCurParam0 = n3;
        }
    }

    public void pushEvent(int n, int n2) {
        if (this.hoAdRunHeader.rh2PauseCompteur == 0) {
            n = -(n + 80 + 1) << 16;
            this.hoAdRunHeader.rhEvtProg.push_Event(1, n |= this.hoType & 0xFFFF, n2, this, this.hoOi);
        }
    }

    public void pause() {
        this.hoAdRunHeader.pause();
    }

    public void resume() {
        this.hoAdRunHeader.resume();
    }

    public void redisplay() {
        this.hoAdRunHeader.ohRedrawLevel(true);
    }

    public void redraw() {
        this.modif();
        if ((this.hoOEFlags & 0x230) != 0) {
            this.roc.rcChanged = true;
        }
    }

    public void destroy() {
        this.hoAdRunHeader.destroy_Add(this.hoNumber);
    }

    public void setPosition(int n, int n2) {
        if (this.rom != null) {
            this.rom.rmMovement.setXPosition(n);
            this.rom.rmMovement.setYPosition(n2);
        } else {
            this.hoX = n;
            this.hoY = n2;
            if (this.roc != null) {
                this.roc.rcChanged = true;
                this.roc.rcCheckCollides = true;
            }
        }
    }

    public int getExtUserData() {
        return this.privateData;
    }

    public void setExtUserData(int n) {
        this.privateData = n;
    }

    public void addBackdrop(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = image.getWidth();
        int n8 = image.getHeight();
        Image image2 = Image.createImage((Image)image, (int)0, (int)0, (int)n7, (int)n8, (int)0);
        short s = this.hoAdRunHeader.rhApp.imageBank.addImageCompare(image2, (short)0, (short)0, (short)0, (short)0);
        CBkd2 cBkd2 = new CBkd2();
        cBkd2.img = s;
        cBkd2.loHnd = 0;
        cBkd2.oiHnd = 0;
        cBkd2.x = n;
        cBkd2.y = n2;
        cBkd2.nLayer = (short)n6;
        cBkd2.inkEffect = n3;
        cBkd2.inkEffectParam = n4;
        cBkd2.colMode = 1;
        cBkd2.obstacleType = (short)n5;
        for (int i = 0; i < 4; ++i) {
            cBkd2.pSpr[i] = null;
        }
        this.hoAdRunHeader.addBackdrop2(cBkd2);
        if (n6 == 0 && (this.hoAdRunHeader.rhFrame.layers[0].dwOptions & 0x20010) == 16) {
            CBackDrawPaste cBackDrawPaste = new CBackDrawPaste();
            cBackDrawPaste.img = s;
            cBackDrawPaste.x = n;
            cBackDrawPaste.y = n2;
            cBackDrawPaste.typeObst = (short)n5;
            cBackDrawPaste.inkEffect = n3;
            cBackDrawPaste.inkEffectParam = n4;
            this.hoAdRunHeader.addBackDrawRoutine(cBackDrawPaste);
            CRect cRect = new CRect();
            cRect.left = n - this.hoAdRunHeader.rhWindowX;
            cRect.top = n2 - this.hoAdRunHeader.rhWindowY;
            cRect.right = cRect.left + n7;
            cRect.bottom = cRect.top + n8;
            this.hoAdRunHeader.spriteGen.activeSprite(null, 32, cRect);
        }
    }

    public int getEventCount() {
        return this.hoAdRunHeader.rh4EventCount;
    }

    public CValue getExpParam() {
        ++this.hoAdRunHeader.rh4CurToken;
        return this.hoAdRunHeader.getExpression();
    }

    public int getEventParam() {
        return this.hoAdRunHeader.rhEvtProg.rhCurParam0;
    }

    public double callMovement(CObject cObject, int n, double d) {
        if ((cObject.hoOEFlags & 0x10) != 0 && cObject.roc.rcMovementType == 14) {
            CMoveExtension cMoveExtension = (CMoveExtension)cObject.rom.rmMovement;
            return cMoveExtension.callMovement(n, d);
        }
        return 0.0;
    }

    public CValue callExpression(CObject cObject, int n, int n2) {
        CExtension cExtension = (CExtension)cObject;
        cExtension.privateData = n2;
        return cExtension.expression(n);
    }

    public int getExpressionParam() {
        return this.privateData;
    }

    public CObject getFirstObject() {
        this.objectCount = 0;
        this.objectNumber = 0;
        return this.getNextObject();
    }

    public CObject getNextObject() {
        if (this.objectNumber < this.hoAdRunHeader.rhNObjects) {
            while (this.hoAdRunHeader.rhObjectList[this.objectCount] == null) {
                ++this.objectCount;
            }
            CObject cObject = this.hoAdRunHeader.rhObjectList[this.objectCount];
            ++this.objectCount;
            return cObject;
        }
        return null;
    }

    public CObject getObjectFromFixed(int n) {
        int n2 = 0;
        for (int i = 0; i < this.hoAdRunHeader.rhNObjects; ++i) {
            while (this.hoAdRunHeader.rhObjectList[n2] == null) {
                ++n2;
            }
            CObject cObject = this.hoAdRunHeader.rhObjectList[n2];
            ++n2;
            int n3 = cObject.hoCreationId << 16 | cObject.hoNumber & 0xFFFF;
            if (n3 != n) continue;
            return cObject;
        }
        return null;
    }

    public CFile openHFile(String string) {
        return this.hoAdRunHeader.rhApp.openHFile(string);
    }

    public void closeHFile(CFile cFile) {
        this.hoAdRunHeader.rhApp.closeHFile(cFile);
    }
}

