/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.types;

import com.antonioaltieri.telegram.botapi.types.ReplyMarkup;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReplyKeyboardMarkup
implements ReplyMarkup {
    @SerializedName(value="keyboard")
    private List<List<String>> keyboard;
    @SerializedName(value="resize_keyboard")
    private boolean resizeKeyboard;
    @SerializedName(value="one_time_keyboard")
    private boolean oneTimeKeyboard;
    @SerializedName(value="selective")
    private boolean selective;

    private ReplyKeyboardMarkup(Builder builder) {
        this.keyboard = builder.keyboard;
        this.resizeKeyboard = builder.resizeKeyboard;
        this.oneTimeKeyboard = builder.oneTimeKeyboard;
        this.selective = builder.selective;
    }

    @Override
    public String serialize() {
        return new Gson().toJson((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplyKeyboardMarkup{");
        sb.append("keyboard=").append(this.keyboard);
        sb.append(", resizeKeyboard=").append(this.resizeKeyboard);
        sb.append(", oneTimeKeyboard=").append(this.oneTimeKeyboard);
        sb.append(", selective=").append(this.selective);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private List<List<String>> keyboard = new ArrayList<List<String>>();
        private boolean resizeKeyboard;
        private boolean oneTimeKeyboard;
        private boolean selective;

        public Builder row(String ... buttons) {
            this.keyboard.add(Arrays.asList(buttons));
            return this;
        }

        public Builder add(int width, String ... buttons) {
            ArrayList<String> row = new ArrayList<String>(width);
            for (int i = 0; i < buttons.length; ++i) {
                row.add(buttons[i]);
                if ((i + 1) % width != 0) continue;
                this.keyboard.add(row);
                row.clear();
            }
            if (row.size() > 0) {
                this.keyboard.add(row);
            }
            return this;
        }

        public Builder setResizeKeyboard() {
            this.resizeKeyboard = true;
            return this;
        }

        public Builder setOneTimeKeyboard() {
            this.oneTimeKeyboard = true;
            return this;
        }

        public Builder setSelective() {
            this.selective = true;
            return this;
        }

        public ReplyKeyboardMarkup build() {
            return new ReplyKeyboardMarkup(this);
        }
    }
}

