/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.types;

import com.antonioaltieri.telegram.botapi.types.Audio;
import com.antonioaltieri.telegram.botapi.types.Chat;
import com.antonioaltieri.telegram.botapi.types.Contact;
import com.antonioaltieri.telegram.botapi.types.Document;
import com.antonioaltieri.telegram.botapi.types.Location;
import com.antonioaltieri.telegram.botapi.types.PhotoSize;
import com.antonioaltieri.telegram.botapi.types.Sticker;
import com.antonioaltieri.telegram.botapi.types.User;
import com.antonioaltieri.telegram.botapi.types.Video;
import com.antonioaltieri.telegram.botapi.types.Voice;
import com.google.gson.annotations.SerializedName;
import java.util.List;

public class Message {
    @SerializedName(value="message_id")
    private int messageId;
    @SerializedName(value="from")
    private User from;
    @SerializedName(value="date")
    private int date;
    @SerializedName(value="chat")
    private Chat chat;
    @SerializedName(value="forward_from")
    private User forwardFrom;
    @SerializedName(value="forward_date")
    private int forwardDate;
    @SerializedName(value="reply_to_message")
    private Message replyToMessage;
    @SerializedName(value="text")
    private String text;
    @SerializedName(value="audio")
    private Audio audio;
    @SerializedName(value="voice")
    private Voice voice;
    @SerializedName(value="document")
    private Document document;
    @SerializedName(value="photo")
    private List<PhotoSize> photo;
    @SerializedName(value="sticker")
    private Sticker sticker;
    @SerializedName(value="video")
    private Video video;
    @SerializedName(value="contact")
    private Contact contact;
    @SerializedName(value="location")
    private Location location;
    @SerializedName(value="new_chat_participant")
    private User newChatParticipant;
    @SerializedName(value="left_chat_participant")
    private User leftChatParticipant;
    @SerializedName(value="new_chat_title")
    private String newChatTitle;
    @SerializedName(value="new_chat_photo")
    private List<PhotoSize> newChatPhoto;
    @SerializedName(value="delete_chat_photo")
    private boolean deleteChatPhoto;
    @SerializedName(value="group_chat_created")
    private boolean groupChatCreated;
    @SerializedName(value="super_group_chat_created")
    private boolean superGroupChatCreated;
    @SerializedName(value="channel_chat_created")
    private boolean channelChatCreated;
    @SerializedName(value="migrate_to_chat_id")
    private boolean migrateToChatID;
    @SerializedName(value="migrate_from_chat_id")
    private boolean migrateFromChatID;
    @SerializedName(value="caption")
    private String caption;
    private Type type;

    public int getMessageId() {
        return this.messageId;
    }

    public User getFrom() {
        return this.from;
    }

    public int getDate() {
        return this.date;
    }

    public Chat getChat() {
        return this.chat;
    }

    public User getForwardFrom() {
        return this.forwardFrom;
    }

    public int getForwardDate() {
        return this.forwardDate;
    }

    public Message getReplyToMessage() {
        return this.replyToMessage;
    }

    public String getText() {
        return this.text;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<PhotoSize> getPhoto() {
        return this.photo;
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    public Video getVideo() {
        return this.video;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Location getLocation() {
        return this.location;
    }

    public User getNewChatParticipant() {
        return this.newChatParticipant;
    }

    public User getLeftChatParticipant() {
        return this.leftChatParticipant;
    }

    public String getNewChatTitle() {
        return this.newChatTitle;
    }

    public List<PhotoSize> getNewChatPhoto() {
        return this.newChatPhoto;
    }

    public boolean isDeleteChatPhoto() {
        return this.deleteChatPhoto;
    }

    public boolean isGroupChatCreated() {
        return this.groupChatCreated;
    }

    public String getCaption() {
        return this.caption;
    }

    public Type getType() {
        if (this.type == null) {
            this.determineType();
        }
        return this.type;
    }

    private void determineType() {
        this.type = this.text != null ? Type.TEXT : (this.audio != null ? Type.AUDIO : (this.voice != null ? Type.VOICE : (this.document != null ? Type.DOCUMENT : (this.photo != null ? Type.PHOTO : (this.sticker != null ? Type.STICKER : (this.video != null ? Type.VIDEO : (this.contact != null ? Type.CONTACT : (this.location != null ? Type.LOCATION : (this.newChatParticipant != null ? Type.NEW_CHAT_PARTICIPANT : (this.leftChatParticipant != null ? Type.LEFT_CHAT_PARTICIPANT : (this.newChatPhoto != null ? Type.NEW_CHAT_PHOTO : (this.deleteChatPhoto ? Type.DELETE_CHAT_PHOTO : (this.groupChatCreated ? Type.GROUP_CHAT_CREATED : Type.UNKNOWN)))))))))))));
    }

    public String toString() {
        String sb = "Message{";
        sb = sb + "type=" + (Object)((Object)this.type);
        sb = sb + ", messageId=" + this.messageId;
        sb = sb + ", from=" + this.from;
        sb = sb + ", date=" + this.date;
        sb = sb + ", chat=" + this.chat;
        sb = sb + '}';
        return sb;
    }

    public static enum Type {
        TEXT,
        DOCUMENT,
        AUDIO,
        VOICE,
        PHOTO,
        STICKER,
        VIDEO,
        CONTACT,
        LOCATION,
        NEW_CHAT_PARTICIPANT,
        LEFT_CHAT_PARTICIPANT,
        NEW_CHAT_PHOTO,
        DELETE_CHAT_PHOTO,
        GROUP_CHAT_CREATED,
        UNKNOWN;

    }
}

