/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.requests.ApiRequest;
import com.antonioaltieri.telegram.botapi.requests.OptionalArgs;
import com.antonioaltieri.telegram.botapi.types.Message;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SendVoiceRequest
implements ApiRequest<Message> {
    private Map<String, String> args = new HashMap<String, String>();
    private ApiRequest.RequestStrategy requestStrategy;

    public SendVoiceRequest(long chatId, File voiceFile) {
        this(chatId, voiceFile, null);
    }

    public SendVoiceRequest(long chatId, File voiceFile, OptionalArgs optionalArgs) {
        this.args.put("chat_id", String.valueOf(chatId));
        if (optionalArgs != null) {
            this.args.putAll(optionalArgs.options());
        }
        this.requestStrategy = new ApiRequest.MultipartStrategy(voiceFile, "voice");
    }

    public SendVoiceRequest(long chatId, String voiceString) {
        this(chatId, voiceString, null);
    }

    public SendVoiceRequest(long chatId, String voiceString, OptionalArgs optionalArgs) {
        this.args.put("chat_id", String.valueOf(chatId));
        this.args.put("voice", voiceString);
        if (optionalArgs != null) {
            this.args.putAll(optionalArgs.options());
        }
        this.requestStrategy = new ApiRequest.PostStrategy();
    }

    @Override
    public String getMethodName() {
        return "sendVoice";
    }

    @Override
    public ApiRequest.ResultTypes getResultType() {
        return ApiRequest.ResultTypes.MESSAGE;
    }

    @Override
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Override
    public ApiRequest.RequestStrategy getRequestStrategy() {
        return this.requestStrategy;
    }

    public String toString() {
        return "SendVoiceRequest{args=" + this.args + ", requestStrategy=" + this.requestStrategy + '}';
    }
}

