/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.requests.ApiRequest;
import com.antonioaltieri.telegram.botapi.requests.OptionalArgs;
import com.antonioaltieri.telegram.botapi.types.Message;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SendVideoRequest
implements ApiRequest<Message> {
    private Map<String, String> args = new HashMap<String, String>();
    private ApiRequest.RequestStrategy requestStrategy;

    public SendVideoRequest(long chatId, File video) {
        this(chatId, video, null);
    }

    public SendVideoRequest(long chatId, File video, OptionalArgs optionalArgs) {
        this.args.put("chat_id", String.valueOf(chatId));
        if (optionalArgs != null) {
            this.args.putAll(optionalArgs.options());
        }
        this.requestStrategy = new ApiRequest.MultipartStrategy(video, "video");
    }

    public SendVideoRequest(long chatId, String video) {
        this(chatId, video, null);
    }

    public SendVideoRequest(long chatId, String video, OptionalArgs optionalArgs) {
        this.args.put("chat_id", String.valueOf(chatId));
        this.args.put("video", video);
        if (optionalArgs != null) {
            this.args.putAll(optionalArgs.options());
        }
        this.requestStrategy = new ApiRequest.PostStrategy();
    }

    @Override
    public String getMethodName() {
        return "sendVideo";
    }

    @Override
    public ApiRequest.ResultTypes getResultType() {
        return ApiRequest.ResultTypes.MESSAGE;
    }

    @Override
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Override
    public ApiRequest.RequestStrategy getRequestStrategy() {
        return this.requestStrategy;
    }

    public String toString() {
        return "SendVideoRequest{args=" + this.args + ", requestStrategy=" + this.requestStrategy + '}';
    }
}

