/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.requests.ApiRequest;
import com.antonioaltieri.telegram.botapi.requests.OptionalArgs;
import com.antonioaltieri.telegram.botapi.types.Message;
import java.util.HashMap;
import java.util.Map;

public final class SendMessageRequest
implements ApiRequest<Message> {
    private Map<String, String> args = new HashMap<String, String>();

    public SendMessageRequest(long chatId, String text) {
        this(chatId, text, null);
    }

    public SendMessageRequest(String chatId, String text) {
        this(chatId, text, null);
    }

    public SendMessageRequest(long chatId, String text, OptionalArgs optionalArgs) {
        this(String.valueOf(chatId), text, optionalArgs);
    }

    public SendMessageRequest(String chatId, String text, OptionalArgs optionalArgs) {
        this.args.put("chat_id", chatId);
        this.args.put("text", text);
        if (optionalArgs != null) {
            this.args.putAll(optionalArgs.options());
        }
    }

    @Override
    public String getMethodName() {
        return "sendMessage";
    }

    @Override
    public ApiRequest.ResultTypes getResultType() {
        return ApiRequest.ResultTypes.MESSAGE;
    }

    @Override
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Override
    public ApiRequest.RequestStrategy getRequestStrategy() {
        return new ApiRequest.PostStrategy();
    }

    public String toString() {
        return "SendMessageRequest{args=" + this.args + '}';
    }
}

