/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.types.ParseModes;
import com.antonioaltieri.telegram.botapi.types.ReplyMarkup;
import java.util.HashMap;
import java.util.Map;

public class OptionalArgs {
    private boolean disableWebPagePreview = false;
    private int replyToMessageId = -1;
    private ReplyMarkup replyMarkup = null;
    private int offset = -1;
    private int limit = -1;
    private int timeout = -1;
    private int duration = -1;
    private String performer = null;
    private String title = null;
    private String caption = null;
    private String parse_mode = null;
    private Map<String, String> options;

    public Map<String, String> options() {
        this.options = new HashMap<String, String>();
        if (this.disableWebPagePreview) {
            this.putBoolean("disable_web_page_preview", true);
        }
        if (this.replyToMessageId != -1) {
            this.putInt("reply_to_message_id", this.replyToMessageId);
        }
        if (this.offset != -1) {
            this.putInt("offset", this.offset);
        }
        if (this.limit != -1) {
            this.putInt("limit", this.limit);
        }
        if (this.timeout != -1) {
            this.putInt("timeout", this.timeout);
        }
        if (this.duration != -1) {
            this.putInt("duration", this.duration);
        }
        if (this.replyMarkup != null) {
            this.options.put("reply_markup", this.replyMarkup.serialize());
        }
        if (this.caption != null) {
            this.options.put("caption", this.caption);
        }
        if (this.performer != null) {
            this.options.put("performer", this.performer);
        }
        if (this.title != null) {
            this.options.put("title", this.title);
        }
        if (this.parse_mode != null) {
            this.options.put("parse_mode", this.parse_mode);
        }
        return this.options;
    }

    private void putBoolean(String key, boolean b) {
        this.options.put(key, String.valueOf(b));
    }

    private void putInt(String key, int i) {
        this.options.put(key, String.valueOf(i));
    }

    public OptionalArgs disableWebPagePreview() {
        this.disableWebPagePreview = true;
        return this;
    }

    public OptionalArgs replyToMessageId(int messageId) {
        this.replyToMessageId = messageId;
        return this;
    }

    public OptionalArgs replyMarkup(ReplyMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public OptionalArgs offset(int offset) {
        this.offset = offset;
        return this;
    }

    public OptionalArgs limit(int limit) {
        this.limit = limit;
        return this;
    }

    public OptionalArgs timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public OptionalArgs duration(int duration) {
        this.duration = duration;
        return this;
    }

    public OptionalArgs parsMode(ParseModes parse_mode) {
        switch (parse_mode) {
            case MARKDOWN: {
                this.parse_mode = "Markdown";
                break;
            }
            case HTML: {
                this.parse_mode = "HTML";
            }
        }
        return this;
    }

    public OptionalArgs caption(String caption) {
        this.caption = caption;
        return this;
    }

    public OptionalArgs title(String title) {
        this.title = title;
        return this;
    }

    public OptionalArgs performer(String performer) {
        this.performer = performer;
        return this;
    }
}

