/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.requests.ApiResult;
import com.antonioaltieri.telegram.botapi.requests.TelegramApi;
import com.antonioaltieri.telegram.botapi.types.Message;
import com.antonioaltieri.telegram.botapi.types.Update;
import com.antonioaltieri.telegram.botapi.types.User;
import com.antonioaltieri.telegram.botapi.types.UserProfilePhotos;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

interface ApiRequest<T> {
    public String getMethodName();

    public ResultTypes getResultType();

    public Map<String, String> getArgs();

    public RequestStrategy getRequestStrategy();

    public static final class MultipartStrategy
    implements RequestStrategy {
        private File file;
        private String fieldName;

        public MultipartStrategy(File file, String fieldName) {
            this.file = file;
            this.fieldName = fieldName;
        }

        @Override
        public String makeRequest(ApiRequest<?> request, TelegramApi api) {
            return api.makeMultipartRequest(request.getMethodName(), request.getArgs(), this.fieldName, this.file);
        }

        public String toString() {
            return "MULTIPART";
        }
    }

    public static final class GetStrategy
    implements RequestStrategy {
        @Override
        public String makeRequest(ApiRequest<?> request, TelegramApi api) {
            return api.makeGetRequest(request.getMethodName());
        }

        public String toString() {
            return "GET";
        }
    }

    public static final class PostStrategy
    implements RequestStrategy {
        @Override
        public String makeRequest(ApiRequest<?> request, TelegramApi api) {
            return api.makePostRequest(request.getMethodName(), request.getArgs());
        }

        public String toString() {
            return "POST";
        }
    }

    public static interface RequestStrategy {
        public String makeRequest(ApiRequest<?> var1, TelegramApi var2);
    }

    public static enum ResultTypes {
        USER(new TypeToken<ApiResult<User>>(){}.getType()),
        MESSAGE(new TypeToken<ApiResult<Message>>(){}.getType()),
        BOOLEAN(new TypeToken<ApiResult<Boolean>>(){}.getType()),
        USER_PROFILE_PHOTOS(new TypeToken<ApiResult<UserProfilePhotos>>(){}.getType()),
        LIST_OF_UPDATES(new TypeToken<ApiResult<List<Update>>>(){}.getType());

        private Type type;

        private ResultTypes(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }
}

