/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi;

import com.antonioaltieri.telegram.botapi.CommandHandler;
import com.antonioaltieri.telegram.botapi.DefaultHandler;
import com.antonioaltieri.telegram.botapi.MessageHandler;
import com.antonioaltieri.telegram.botapi.Properties;
import com.antonioaltieri.telegram.botapi.types.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HandlerNotifier {
    private static final Logger logger = Logger.getLogger(HandlerNotifier.class.getName());
    private Object objectWithHandlers;
    private Method defaultHandler;
    private List<MessageFilter> messageHandlers = new ArrayList<MessageFilter>();

    public HandlerNotifier(Object objectWithHandlers) {
        this.objectWithHandlers = objectWithHandlers;
        try {
            this.defaultHandler = this.getClass().getDeclaredMethod("defaultHandler", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.warning("defaultHandler not setted. It can cause Unexpected exceptions and behavior. Please set a defaultHandler ");
            this.defaultHandler = null;
        }
        this.indexHandlers();
    }

    private void indexHandlers() {
        Method[] declaredMethods;
        for (Method method : declaredMethods = this.objectWithHandlers.getClass().getDeclaredMethods()) {
            if (method.isAnnotationPresent(MessageHandler.class)) {
                logger.info("Found MessageHandler: " + method.getName());
                MessageHandler messageHandlerAnnotation = method.getAnnotation(MessageHandler.class);
                this.messageHandlers.add(new MessageHandlerFilter(messageHandlerAnnotation.contentTypes(), method));
                continue;
            }
            if (method.isAnnotationPresent(CommandHandler.class)) {
                logger.info("Found CommandHandler: " + method.getName());
                CommandHandler commandHandlerAnnotation = method.getAnnotation(CommandHandler.class);
                this.messageHandlers.add(0, new CommandHandlerFilter(commandHandlerAnnotation.value(), method));
                continue;
            }
            if (!method.isAnnotationPresent(DefaultHandler.class)) continue;
            logger.info("Found DefaultHandler: " + method.getName());
            this.defaultHandler = method;
        }
    }

    public void defaultHandler() {
    }

    public void notifyHandlers(Message message) {
        Method handler = null;
        for (MessageFilter filter : this.messageHandlers) {
            boolean isValid = filter.valid(message);
            if (!isValid) continue;
            logger.info("Handler " + filter.toString() + "will handle the message " + message.getText());
            handler = filter.getHandler();
            break;
        }
        if (handler == null) {
            handler = this.defaultHandler;
        }
        Method handlerToExecute = handler;
        this.notifyMessageHandler(handlerToExecute, message);
    }

    private void notifyMessageHandler(Method handler, Message message) {
        try {
            handler.invoke(this.objectWithHandlers, message);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "An exception occurred while trying to invoke handler '" + handler.getName() + "'", e);
        }
    }

    private static class CommandHandlerFilter
    implements MessageFilter {
        private Method handler;
        private List<String> commands;

        public CommandHandlerFilter(String[] commands, Method handler) {
            this.handler = handler;
            this.commands = Arrays.asList(commands);
        }

        @Override
        public boolean valid(Message message) {
            boolean valid = this.isCommand(message) && this.commands.contains(this.extractCommand(message));
            logger.info(this.toString() + " can handle " + message.getText() + "? " + valid);
            return valid;
        }

        private String extractCommand(Message message) {
            if (this.isCommand(message)) {
                String text = message.getText();
                String[] cmdTrg = text.split(" ")[0].split("@");
                String cmd = cmdTrg[0].substring(1);
                String target = null;
                if (cmdTrg.length >= 2) {
                    target = cmdTrg[1];
                }
                if (target == null || target.equalsIgnoreCase(Properties.BotUser.getUsername())) {
                    return cmd;
                }
            }
            return null;
        }

        private boolean isCommand(Message message) {
            return message.getType() == Message.Type.TEXT && message.getText().startsWith("/");
        }

        @Override
        public Method getHandler() {
            return this.handler;
        }
    }

    private static class MessageHandlerFilter
    implements MessageFilter {
        private Method handler;
        private List<Message.Type> contentTypes;

        public MessageHandlerFilter(Message.Type[] contentTypes, Method handler) {
            this.contentTypes = Arrays.asList(contentTypes);
            this.handler = handler;
        }

        @Override
        public boolean valid(Message message) {
            logger.info(this.toString() + " can handle " + message.getText() + " ?" + this.contentTypes.contains((Object)message.getType()));
            return this.contentTypes.contains((Object)message.getType());
        }

        @Override
        public Method getHandler() {
            return this.handler;
        }
    }

    private static interface MessageFilter {
        public boolean valid(Message var1);

        public Method getHandler();
    }
}

