/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.requests.ApiException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;

public final class TelegramApi {
    public static final String API_URL = "https://api.telegram.org/bot%s/%s";
    private final String token;

    public TelegramApi(String token) {
        this.token = token;
    }

    private static String createQueryString(Map<String, String> arguments) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            stringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
        }
        return stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString();
    }

    private static String readAll(InputStream input) {
        Scanner scanner = new Scanner(input);
        scanner.useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : null;
    }

    public String makeGetRequest(String method) {
        try {
            HttpURLConnection connection = this.buildConnection(method);
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            return TelegramApi.readAll(connection.getInputStream());
        }
        catch (IOException exception) {
            throw new ApiException(method, exception);
        }
    }

    public String makePostRequest(String method, Map<String, String> arguments) {
        try {
            String query = TelegramApi.createQueryString(arguments);
            HttpURLConnection connection = this.buildConnection(method);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-length", String.valueOf(query.length()));
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("User-Agent", "TelegramBots4Java API Agent");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            DataOutputStream output = new DataOutputStream(connection.getOutputStream());
            output.write(query.getBytes());
            output.close();
            return TelegramApi.readAll(connection.getInputStream());
        }
        catch (IOException exception) {
            throw new ApiException(method, exception);
        }
    }

    public String makeMultipartRequest(String method, Map<String, String> args, String fieldName, File uploadFile) {
        try {
            MultipartUtility multipartUtility = new MultipartUtility(this.buildConnection(method), "UTF-8");
            for (Map.Entry<String, String> entry : args.entrySet()) {
                multipartUtility.addFormField(entry.getKey(), entry.getValue());
            }
            multipartUtility.addFilePart(fieldName, uploadFile);
            return multipartUtility.finish();
        }
        catch (IOException e) {
            throw new ApiException(method, e);
        }
    }

    private HttpURLConnection buildConnection(String methodName) {
        try {
            HttpURLConnection httpconnection = (HttpURLConnection)new URL(String.format(API_URL, this.token, methodName)).openConnection();
            httpconnection.setConnectTimeout(Integer.MAX_VALUE);
            return httpconnection;
        }
        catch (IOException e) {
            throw new ApiException(methodName, e);
        }
    }

    private static class MultipartUtility {
        private static final String LINE_FEED = "\r\n";
        private final String boundary;
        private HttpURLConnection httpConn;
        private String charset;
        private OutputStream outputStream;
        private PrintWriter writer;

        public MultipartUtility(HttpURLConnection httpURLConnection, String charset) throws IOException {
            this.charset = charset;
            this.boundary = "===" + System.currentTimeMillis() + "===";
            this.httpConn = httpURLConnection;
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            httpURLConnection.setRequestProperty("User-Agent", "TelegramBots4Java API Agent");
            httpURLConnection.setRequestProperty("Test", "Bonjour");
            this.outputStream = httpURLConnection.getOutputStream();
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
        }

        public void addFormField(String name, String value) {
            this.writer.append("--" + this.boundary).append(LINE_FEED);
            this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
            this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.append(value).append(LINE_FEED);
            this.writer.flush();
        }

        public void addFilePart(String fieldName, File uploadFile) throws IOException {
            String fileName = uploadFile.getName();
            this.writer.append("--" + this.boundary).append(LINE_FEED);
            this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
            this.writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
            this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.flush();
            FileInputStream inputStream = new FileInputStream(uploadFile);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
            }
            this.outputStream.flush();
            inputStream.close();
            this.writer.append(LINE_FEED);
            this.writer.flush();
        }

        public void addHeaderField(String name, String value) {
            this.writer.append(name + ": " + value).append(LINE_FEED);
            this.writer.flush();
        }

        public String finish() throws IOException {
            ArrayList response = new ArrayList();
            this.writer.append(LINE_FEED).flush();
            this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
            this.writer.close();
            this.outputStream.close();
            return TelegramApi.readAll(this.httpConn.getInputStream());
        }
    }
}

