/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.requests.ApiRequest;
import com.antonioaltieri.telegram.botapi.requests.OptionalArgs;
import com.antonioaltieri.telegram.botapi.types.Message;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SendPhotoRequest
implements ApiRequest<Message> {
    private Map<String, String> args = new HashMap<String, String>();
    private ApiRequest.RequestStrategy requestStrategy;

    public SendPhotoRequest(long chatId, File photo) {
        this(chatId, photo, null);
    }

    public SendPhotoRequest(long chatId, File photo, OptionalArgs optionalArgs) {
        this.args.put("chat_id", String.valueOf(chatId));
        if (optionalArgs != null) {
            this.args.putAll(optionalArgs.options());
        }
        this.requestStrategy = new ApiRequest.MultipartStrategy(photo, "photo");
    }

    public SendPhotoRequest(long chatId, String photo) {
        this(chatId, photo, null);
    }

    public SendPhotoRequest(long chatId, String photo, OptionalArgs optionalArgs) {
        this.args.put("chat_id", String.valueOf(chatId));
        this.args.put("photo", photo);
        if (optionalArgs != null) {
            this.args.putAll(optionalArgs.options());
        }
        this.requestStrategy = new ApiRequest.PostStrategy();
    }

    @Override
    public String getMethodName() {
        return "sendPhoto";
    }

    @Override
    public ApiRequest.ResultTypes getResultType() {
        return ApiRequest.ResultTypes.MESSAGE;
    }

    @Override
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Override
    public ApiRequest.RequestStrategy getRequestStrategy() {
        return this.requestStrategy;
    }

    public String toString() {
        return "SendPhotoRequest{args=" + this.args + ", requestStrategy=" + this.requestStrategy + '}';
    }
}

