/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.requests.ApiException;
import com.antonioaltieri.telegram.botapi.requests.ApiRequest;
import com.antonioaltieri.telegram.botapi.requests.ApiResult;
import com.antonioaltieri.telegram.botapi.requests.TelegramApi;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.logging.Logger;

public class ApiRequestExecutor {
    private static final Logger log = Logger.getLogger(ApiRequestExecutor.class.getName());
    private static final Gson gson = new Gson();
    private static ApiRequestExecutor requestExecutor;

    private ApiRequestExecutor() {
    }

    public static ApiRequestExecutor getInstance() {
        if (requestExecutor == null) {
            requestExecutor = new ApiRequestExecutor();
        }
        return requestExecutor;
    }

    protected <T> ApiResult<T> deserialize(String json, ApiRequest.ResultTypes resultType) {
        System.out.println(json);
        return (ApiResult)gson.fromJson(json, resultType.getType());
    }

    public <T> T execute(TelegramApi api, ApiRequest<T> request) {
        log.info(request.toString());
        String response = request.getRequestStrategy().makeRequest(request, api);
        try {
            ApiResult<T> result = this.deserialize(response, request.getResultType());
            if (!result.isOk()) {
                throw new ApiException(request.getMethodName(), result);
            }
            return result.getResult();
        }
        catch (JsonSyntaxException e) {
            System.out.println("The response is not a " + (Object)((Object)request.getResultType()) + ". Is your Token valid?");
            System.out.println("Response: " + response);
            return null;
        }
    }
}

