/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi.requests;

import com.antonioaltieri.telegram.botapi.requests.ApiResult;

public class ApiException
extends RuntimeException {
    private String methodName;

    public ApiException(String methodName) {
        super(String.format("An exception occurred while accessing %s.", methodName));
        this.methodName = methodName;
    }

    public ApiException(String methodName, Throwable cause) {
        super(String.format("An exception occurred while accessing %s.", methodName), cause);
        this.methodName = methodName;
    }

    public ApiException(String methodName, ApiResult<?> unexpectedResult) {
        super(String.format("Unexpected result received from Telegram while accessing %s: %s.", methodName, unexpectedResult));
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String toString() {
        if (this.getCause() == null) {
            return super.toString();
        }
        return super.toString() + " Caused by: " + this.getCause().toString();
    }
}

