/*
 * Decompiled with CFR 0.152.
 */
package com.antonioaltieri.telegram.botapi;

import com.antonioaltieri.telegram.botapi.HandlerNotifier;
import com.antonioaltieri.telegram.botapi.Properties;
import com.antonioaltieri.telegram.botapi.requests.ApiException;
import com.antonioaltieri.telegram.botapi.requests.ApiRequestExecutor;
import com.antonioaltieri.telegram.botapi.requests.ChatAction;
import com.antonioaltieri.telegram.botapi.requests.ForwardMessageRequest;
import com.antonioaltieri.telegram.botapi.requests.GetMeRequest;
import com.antonioaltieri.telegram.botapi.requests.GetUserProfilePhotosRequest;
import com.antonioaltieri.telegram.botapi.requests.OptionalArgs;
import com.antonioaltieri.telegram.botapi.requests.SendAudioRequest;
import com.antonioaltieri.telegram.botapi.requests.SendChatActionRequest;
import com.antonioaltieri.telegram.botapi.requests.SendDocumentRequest;
import com.antonioaltieri.telegram.botapi.requests.SendLocationRequest;
import com.antonioaltieri.telegram.botapi.requests.SendMessageRequest;
import com.antonioaltieri.telegram.botapi.requests.SendPhotoRequest;
import com.antonioaltieri.telegram.botapi.requests.SendStickerRequest;
import com.antonioaltieri.telegram.botapi.requests.SendVideoRequest;
import com.antonioaltieri.telegram.botapi.requests.SetWebHookRequest;
import com.antonioaltieri.telegram.botapi.requests.TelegramApi;
import com.antonioaltieri.telegram.botapi.types.Message;
import com.antonioaltieri.telegram.botapi.types.Update;
import com.antonioaltieri.telegram.botapi.types.User;
import com.antonioaltieri.telegram.botapi.types.UserProfilePhotos;
import java.io.File;
import java.util.logging.Logger;

public abstract class TelegramBot {
    private static final Logger logger = Logger.getLogger(TelegramBot.class.getName());
    private TelegramApi api;
    private long lastUpdateId = 0L;
    private ApiRequestExecutor requestExecutor;
    private HandlerNotifier handlerNotifier;

    public TelegramBot(String botToken) {
        this.api = new TelegramApi(botToken);
        this.handlerNotifier = new HandlerNotifier(this);
        Properties.Token = botToken;
    }

    public final void start() {
        logger.info("Starting");
        this.requestExecutor = ApiRequestExecutor.getInstance();
        User bot = this.getMe();
        if (bot == null) {
            throw new ApiException("Telegram is not responding. Please check that you have passed the correct botToken");
        }
        Properties.BotUser = this.getMe();
        logger.info("My name is: " + Properties.BotUser);
        this.onStart();
    }

    protected void onStart() {
    }

    public final void stop() {
        this.onStop();
    }

    protected void onStop() {
    }

    public final Message forwardMessage(long chatId, long fromChatId, long messageId) {
        return this.requestExecutor.execute(this.api, new ForwardMessageRequest(chatId, fromChatId, messageId));
    }

    public final User getMe() {
        return this.requestExecutor.execute(this.api, new GetMeRequest());
    }

    public final UserProfilePhotos getUserProfilePhotos(long userId) {
        return this.requestExecutor.execute(this.api, new GetUserProfilePhotosRequest(userId));
    }

    public final UserProfilePhotos getUserProfilePhotos(long userId, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new GetUserProfilePhotosRequest(userId, optionalArgs));
    }

    public final Message sendAudio(long chatId, File audioFile) {
        return this.requestExecutor.execute(this.api, new SendAudioRequest(chatId, audioFile));
    }

    public final Message sendAudio(long chatId, File audioFile, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendAudioRequest(chatId, audioFile, optionalArgs));
    }

    public final Message sendAudio(long chatId, String audioFileId) {
        return this.requestExecutor.execute(this.api, new SendAudioRequest(chatId, audioFileId));
    }

    public final Message sendAudio(long chatId, String audioFileId, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendAudioRequest(chatId, audioFileId, optionalArgs));
    }

    public final Boolean sendChatAction(long chatId, ChatAction chatAction) {
        return this.requestExecutor.execute(this.api, new SendChatActionRequest(chatId, chatAction));
    }

    public final Message sendDocument(long chatId, File documentFile) {
        return this.requestExecutor.execute(this.api, new SendDocumentRequest(chatId, documentFile));
    }

    public final Message sendDocument(long chatId, File documentFile, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendDocumentRequest(chatId, documentFile, optionalArgs));
    }

    public final Message sendDocument(long chatId, String documentFileId) {
        return this.requestExecutor.execute(this.api, new SendDocumentRequest(chatId, documentFileId));
    }

    public final Message sendDocument(long chatId, String documentFileId, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendDocumentRequest(chatId, documentFileId, optionalArgs));
    }

    public final Message sendLocation(long chatId, float latitude, float longitude) {
        return this.requestExecutor.execute(this.api, new SendLocationRequest(chatId, latitude, longitude));
    }

    public final Message sendLocation(long chatId, float latitude, float longitude, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendLocationRequest(chatId, latitude, longitude, optionalArgs));
    }

    public final Message sendMessage(long chatId, String text) {
        return this.requestExecutor.execute(this.api, new SendMessageRequest(chatId, text));
    }

    public final Message sendMessage(String channelUsername, String text) {
        return this.requestExecutor.execute(this.api, new SendMessageRequest(channelUsername, text));
    }

    public final Message sendMessage(long chatId, String text, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendMessageRequest(chatId, text, optionalArgs));
    }

    public final Message sendMessage(String chatId, String text, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendMessageRequest(chatId, text, optionalArgs));
    }

    public final Message sendPhoto(long chatId, File photoFile) {
        return this.requestExecutor.execute(this.api, new SendPhotoRequest(chatId, photoFile));
    }

    public final Message sendPhoto(long chatId, File photoFile, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendPhotoRequest(chatId, photoFile, optionalArgs));
    }

    public final Message sendPhoto(long chatId, String photoFileId) {
        return this.requestExecutor.execute(this.api, new SendPhotoRequest(chatId, photoFileId));
    }

    public final Message sendPhoto(long chatId, String photoFileId, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendPhotoRequest(chatId, photoFileId, optionalArgs));
    }

    public final Message sendSticker(long chatId, File stickerFile) {
        return this.requestExecutor.execute(this.api, new SendStickerRequest(chatId, stickerFile));
    }

    public final Message sendSticker(long chatId, File stickerFile, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendStickerRequest(chatId, stickerFile, optionalArgs));
    }

    public final Message sendSticker(long chatId, String stickerFileId) {
        return this.requestExecutor.execute(this.api, new SendStickerRequest(chatId, stickerFileId));
    }

    public final Message sendSticker(long chatId, String stickerFileId, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendStickerRequest(chatId, stickerFileId, optionalArgs));
    }

    public final Message sendVideo(long chatId, File videoFile) {
        return this.requestExecutor.execute(this.api, new SendVideoRequest(chatId, videoFile));
    }

    public final Message sendVideo(long chatId, File videoFile, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendVideoRequest(chatId, videoFile, optionalArgs));
    }

    public final Message sendVideo(long chatId, String videoFileId) {
        return this.requestExecutor.execute(this.api, new SendVideoRequest(chatId, videoFileId));
    }

    public final Message sendVideo(long chatId, String videoFileId, OptionalArgs optionalArgs) {
        return this.requestExecutor.execute(this.api, new SendVideoRequest(chatId, videoFileId, optionalArgs));
    }

    public final Message replyTo(Message message, String text) {
        OptionalArgs optionalArgs = new OptionalArgs().replyToMessageId(message.getMessageId());
        return this.sendMessage(message.getChat().getId(), text, optionalArgs);
    }

    public final boolean setWebHook(String servletAddress) {
        SetWebHookRequest request = new SetWebHookRequest(servletAddress);
        return this.requestExecutor.execute(this.api, request);
    }

    protected void onMessage(Message message) {
    }

    protected void notifyNewMessage(Message message) {
        this.onMessage(message);
        this.handlerNotifier.notifyHandlers(message);
    }

    public void notifyNewUpdate(Update update) {
        Message message = this.processUpdate(update);
        if (message != null) {
            this.notifyNewMessage(message);
        }
    }

    private Message processUpdate(Update update) {
        Message msg = null;
        if (update.getUpdateId() > this.lastUpdateId) {
            this.lastUpdateId = update.getUpdateId();
            msg = update.getMessage();
        }
        return msg;
    }
}

