/*
 * Decompiled with CFR 0.152.
 */
package game2048.scene;

import game2048.Board;
import game2048.BoardChangeListener;
import game2048.Movement;
import game2048.scene.ActionsPane;
import game2048.scene.Animable;
import game2048.scene.Dialog;
import game2048.scene.Drawable;
import game2048.scene.Grid;
import game2048.scene.Logo;
import game2048.scene.Message;
import game2048.scene.Number;
import game2048.scene.Score;
import game2048.scene.UserActivityListener;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public final class Scene
extends GameCanvas
implements Runnable {
    public static final int COMMAND_LEFT = -6;
    public static final int COMMAND_MIDDLE = -5;
    public static final int COMMAND_RIGHT = -7;
    public static final int KEYPAD_UP = -1;
    public static final int KEYPAD_DOWN = -2;
    public static final int KEYPAD_LEFT = -3;
    public static final int KEYPAD_RIGHT = -4;
    public static final int NUMPAD_0 = 48;
    public static final int NUMPAD_1 = 49;
    public static final int NUMPAD_2 = 50;
    public static final int NUMPAD_3 = 51;
    public static final int NUMPAD_4 = 52;
    public static final int NUMPAD_5 = 53;
    public static final int NUMPAD_6 = 54;
    public static final int NUMPAD_7 = 55;
    public static final int NUMPAD_8 = 56;
    public static final int NUMPAD_9 = 57;
    public static final int NUMPAD_ASTERISK = 42;
    public static final int NUMPAD_POUND = 35;
    private static final int BACKGROUND = 16447727;
    private static final int NUMBER_MARGIN = 3;
    private static final int ROUNDNESS = 4;
    private final Vector listeners = new Vector(2);
    private final Vector sceneElements;
    private final Number[][] numbers;
    private final Grid grid;
    private final Score score;
    private final Score best;
    private Dialog dialog;
    private final int spacing;
    private volatile boolean paused;
    private volatile boolean stopped;
    private volatile boolean animating;
    private long lastTime;
    private boolean sceneChanged = true;

    public Scene(int n, int n2) throws IOException {
        super(false);
        this.sceneElements = new Vector(n * n2 + 1);
        this.numbers = new Number[n][];
        for (int i = 0; i < n; ++i) {
            this.numbers[i] = new Number[n2];
        }
        this.grid = new Grid(0, 0, n, n2, 50, 50, 3, 4);
        this.grid.setX((this.getWidth() - this.grid.getWidth()) / 2);
        this.spacing = 5;
        this.best = new Score(this.grid.getX() + this.grid.getWidth(), this.spacing, 4, true);
        this.score = new Score(0, this.spacing, 4, false);
        this.updateScorePosition();
        Logo logo = new Logo(this.grid.getX(), this.spacing);
        this.grid.setY(this.score.getY() + this.score.getHeight() + this.spacing);
        this.addToScene(logo);
        this.addToScene(this.best);
        this.addToScene(this.score);
        this.addToScene(this.grid);
        this.addToScene(new ActionsPane((Canvas)this, this.spacing));
    }

    private void addToScene(Object object) {
        if (!this.sceneElements.isEmpty() && this.sceneElements.lastElement() instanceof Message) {
            this.sceneElements.insertElementAt(object, this.sceneElements.size() - 1);
        } else {
            this.sceneElements.addElement(object);
        }
        this.sceneChanged = true;
    }

    private void removeFromScene(Object object) {
        this.sceneElements.removeElement(object);
        this.sceneChanged = true;
    }

    public final void start() {
        this.lastTime = System.currentTimeMillis();
        if (this.paused && !this.stopped) {
            this.paused = false;
        } else {
            this.paused = false;
            this.stopped = false;
            new Thread(this).start();
        }
    }

    public final void pause() {
        this.paused = true;
    }

    public final void stop() {
        this.stopped = true;
    }

    public final void run() {
        while (!this.stopped) {
            if (this.paused) {
                this.sleep();
                continue;
            }
            if (!this.animating && !this.sceneChanged) {
                Thread.yield();
            }
            this.animating = this.animate() > 0;
            this.sceneChanged |= this.animating;
            if (!this.sceneChanged) continue;
            this.draw();
            this.sceneChanged = false;
        }
    }

    protected final void keyPressed(int n) {
        super.keyPressed(n);
        int n2 = this.getGameAction(n);
        this.notifyKeyPressed(n2 == 0 ? n : n2);
    }

    private void sleep() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createNumber(int n, int n2, int n3, final Runnable runnable) {
        Number number = new Number(n, this.grid.colToX(n3), this.grid.rowToY(n2), 4);
        final Number number2 = this.numbers[n2][n3];
        this.numbers[n2][n3] = number;
        Vector vector = this.sceneElements;
        synchronized (vector) {
            this.addToScene(number);
        }
        if (number2 == null) {
            number.appear(runnable);
        } else {
            number.appear(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Vector vector = Scene.this.sceneElements;
                    synchronized (vector) {
                        Scene.this.removeFromScene(number2);
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSceneOrder(Object object, Object object2) {
        int n = -1;
        Vector vector = this.sceneElements;
        synchronized (vector) {
            for (int i = 0; i < this.sceneElements.size(); ++i) {
                if (this.sceneElements.elementAt(i) == object) {
                    n = i;
                }
                if (this.sceneElements.elementAt(i) != object2) continue;
                if (n != -1) {
                    this.sceneElements.setElementAt(object, i);
                    this.sceneElements.setElementAt(object2, n);
                    this.sceneChanged = true;
                }
                return;
            }
        }
    }

    public final void move(Board board, Movement movement, final Runnable runnable) {
        Number number;
        final Number number2 = this.numbers[movement.destinationRow][movement.destinationCol];
        this.numbers[movement.destinationRow][movement.destinationCol] = number = this.numbers[movement.sourceRow][movement.sourceCol];
        this.numbers[movement.sourceRow][movement.sourceCol] = null;
        this.ensureSceneOrder(number2, number);
        number.move(this.getMovementPixelDistance(movement), movement.direction, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                if (number2 != null) {
                    Vector vector = Scene.this.sceneElements;
                    synchronized (vector) {
                        Scene.this.removeFromScene(number2);
                    }
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    private int getMovementPixelDistance(Movement movement) {
        switch (movement.direction) {
            case 1: {
                return this.grid.colToX(movement.sourceCol) - this.grid.colToX(movement.destinationCol);
            }
            case 2: {
                return this.grid.rowToY(movement.sourceRow) - this.grid.rowToY(movement.destinationRow);
            }
            case 4: {
                return this.grid.colToX(movement.destinationCol) - this.grid.colToX(movement.sourceCol);
            }
            case 8: {
                return this.grid.rowToY(movement.destinationRow) - this.grid.rowToY(movement.sourceRow);
            }
        }
        return 0;
    }

    private void notifyKeyPressed(int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.elementAt(i);
            if (!(e instanceof BoardChangeListener)) continue;
            ((UserActivityListener)e).onKeyPressed(n);
        }
    }

    public final void addListener(UserActivityListener userActivityListener) {
        this.listeners.addElement(userActivityListener);
    }

    public final void removeListener(UserActivityListener userActivityListener) {
        this.listeners.removeElement(userActivityListener);
    }

    public final void updateScore(int n) {
        this.score.setScore(n);
        this.sceneChanged = true;
    }

    public final boolean isAnimating() {
        return this.animating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw() {
        Graphics graphics = this.getGraphics();
        graphics.setColor(16447727);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Vector vector = this.sceneElements;
        synchronized (vector) {
            for (int i = 0; i < this.sceneElements.size(); ++i) {
                Object e = this.sceneElements.elementAt(i);
                if (!(e instanceof Drawable)) continue;
                ((Drawable)e).draw(graphics);
            }
        }
        this.flushGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int animate() {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTime;
        int n = 0;
        Vector vector = this.sceneElements;
        synchronized (vector) {
            for (int i = 0; i < this.sceneElements.size(); ++i) {
                Animable animable;
                Object e = this.sceneElements.elementAt(i);
                if (!(e instanceof Animable) || !(animable = (Animable)e).animate(l2)) continue;
                ++n;
            }
        }
        this.lastTime = l;
        return n;
    }

    public final void updateBest(int n) {
        this.best.setScore(n);
        this.updateScorePosition();
    }

    private void updateScorePosition() {
        this.score.setX(this.grid.getX() + this.grid.getWidth() - this.spacing - this.best.getWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDialog(final int n, final Runnable runnable) {
        if (this.dialog != null) {
            this.hideDialog(new Runnable(){

                public final void run() {
                    Scene.this.showDialog(n, runnable);
                }
            });
            return;
        }
        try {
            this.dialog = new Dialog((Canvas)this, n);
            Vector vector = this.sceneElements;
            synchronized (vector) {
                this.sceneElements.addElement(this.dialog);
            }
            this.dialog.appear(runnable);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void hideDialog(final Runnable runnable) {
        if (this.dialog == null) {
            return;
        }
        if (this.dialog.isVisible() && !this.dialog.isAppearing() && !this.dialog.isDisappearing()) {
            this.dialog.disappear(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Scene.this.dialog = null;
                    Vector vector = Scene.this.sceneElements;
                    synchronized (vector) {
                        Scene.this.removeFromScene(Scene.this.dialog);
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
            return;
        }
        Vector vector = this.sceneElements;
        synchronized (vector) {
            this.removeFromScene(this.dialog);
        }
        this.dialog = null;
        if (runnable != null) {
            runnable.run();
        }
    }

    public final boolean isGameOverDialogDisplayed() {
        return this.dialog != null && this.dialog.getType() == 0;
    }

    public final boolean isAnyDialogVisible() {
        return this.dialog != null;
    }

    private void setDialogVisible(final int n, final boolean bl, final Runnable runnable) {
        if (bl) {
            if (this.dialog != null) {
                if (this.dialog.getType() == n) {
                    if (runnable != null) {
                        runnable.run();
                    }
                    return;
                }
                this.hideDialog(new Runnable(){

                    public final void run() {
                        Scene.this.setDialogVisible(n, bl, runnable);
                    }
                });
                return;
            }
            this.showDialog(n, runnable);
            return;
        }
        if (this.dialog != null && this.dialog.getType() == n) {
            this.hideDialog(runnable);
            return;
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    public final void setGameOverDialogDisplayed(boolean bl, Runnable runnable) {
        this.setDialogVisible(0, bl, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNumber(int n, int n2) {
        Number number = this.numbers[n][n2];
        if (number != null) {
            Vector vector = this.sceneElements;
            synchronized (vector) {
                this.removeFromScene(number);
            }
        }
    }

    public final void setNewGameDialogDisplayed(boolean bl, Runnable runnable) {
        this.setDialogVisible(2, bl, runnable);
    }

    public final boolean isNewGameDialogDisplayed() {
        return this.dialog != null && this.dialog.getType() == 2;
    }

    public final void setCongratulationsDialogDisplayed(boolean bl, Runnable runnable) {
        this.setDialogVisible(1, bl, runnable);
    }

    public final boolean isCongratulationsDialogDisplayed() {
        return this.dialog != null && this.dialog.getType() == 1;
    }
}

