/*
 * Decompiled with CFR 0.152.
 */
package game2048.scene;

import game2048.scene.Message;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Dialog
extends Message {
    public static final int GAME_OVER = 0;
    public static final int CONGRATULATIONS = 1;
    public static final int START_NEW_GAME = 2;
    private final Image messageImage;
    private final Image yesImage;
    private final Image noImage;
    private final int type;

    public Dialog(Canvas canvas, int n) throws IOException {
        super(canvas);
        String string;
        this.type = n;
        switch (n) {
            case 0: {
                string = "game-over";
                break;
            }
            case 1: {
                string = "congratulations";
                break;
            }
            case 2: {
                string = "start-new-game";
                break;
            }
            default: {
                throw new IllegalArgumentException("type");
            }
        }
        this.messageImage = Image.createImage((InputStream)this.getClass().getResourceAsStream("images/text/" + string + ".png"));
        this.yesImage = Image.createImage((InputStream)this.getClass().getResourceAsStream("images/text/yes.png"));
        this.noImage = Image.createImage((InputStream)this.getClass().getResourceAsStream("images/text/no.png"));
    }

    protected final void drawContent(Graphics graphics) {
        graphics.drawImage(this.messageImage, 0, 0, 20);
    }

    protected final int getContentHeight() {
        return this.messageImage.getHeight();
    }

    protected final void drawOptionPane(Graphics graphics) {
        graphics.drawImage(this.yesImage, 0, 0, 20);
        graphics.drawImage(this.noImage, this.getContentWidth() - this.noImage.getWidth(), 0, 20);
    }

    protected final int getOptionPaneHeight() {
        return Math.max(this.yesImage.getHeight(), this.noImage.getHeight());
    }

    public final int getType() {
        return this.type;
    }
}

