/*
 * Decompiled with CFR 0.152.
 */
package game2048;

import game2048.BoardChangeListener;
import game2048.Movement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public final class Board {
    public static final int BOARD_WIDTH = 4;
    public static final int BOARD_HEIGHT = 4;
    private static final int FIELDS_COUNT = 16;
    private static final int BASE = 2;
    private static final Random random = new Random(System.currentTimeMillis());
    private final int[][] board;
    private final Vector listeners = new Vector(2);
    private int fieldsOccupied = 0;
    private boolean boardClean = true;

    public Board() {
        this.board = new int[4][];
        for (int i = 0; i < 4; ++i) {
            this.board[i] = new int[4];
        }
    }

    public final void init() {
        if (this.boardClean) {
            this.boardClean = false;
        } else {
            this.fieldsOccupied = 0;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.removeNumber(i, j);
                }
            }
        }
        this.createNumber();
        this.createNumber();
    }

    public final boolean createNumber() {
        if (this.fieldsOccupied == 16) {
            return false;
        }
        int n = random.nextInt(16 - this.fieldsOccupied);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.board[i][j] > 0) continue;
                if (n == 0) {
                    boolean bl = random.nextInt(10) == 0;
                    this.createNumber(i, j, bl ? 4 : 2);
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    private void createNumber(int n, int n2, int n3) {
        this.removeNumber(n, n2);
        this.board[n][n2] = n3;
        this.notifyNumberCreated(n, n2);
    }

    public final boolean move(int n) {
        switch (n) {
            case 1: {
                return this.move(n, 0, 3, 4);
            }
            case 2: {
                return this.move(n, 0, 3, 4);
            }
            case 4: {
                return this.move(n, 3, 0, 4);
            }
            case 8: {
                return this.move(n, 3, 0, 4);
            }
        }
        throw new IllegalArgumentException("direction");
    }

    private boolean move(int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = n3 > n2 ? 1 : -1;
        boolean bl2 = (n & 5) != 0;
        for (int i = 0; i != n4; ++i) {
            int n6 = n2;
            int n7 = n2 - n5;
            while (n6 != n3) {
                int n8;
                int n9 = n8 = bl2 ? this.board[i][n6] : this.board[n6 += n5][i];
                if (n8 == 0) continue;
                int n10 = n6;
                boolean bl3 = false;
                for (int j = n10 - n5; j != n7; j -= n5) {
                    int n11;
                    int n12 = n11 = bl2 ? this.board[i][j] : this.board[j][i];
                    if (n11 != 0) {
                        if (n11 != n8) break;
                        n10 = j;
                        bl3 = true;
                        break;
                    }
                    n10 = j;
                }
                if (n10 == n6) continue;
                if (bl3) {
                    if (bl2) {
                        this.board[i][n10] = 2 * n8;
                        this.notifyNumbersJoined(i, n6, (n6 - n10) * n5, n);
                    } else {
                        this.board[n10][i] = 2 * n8;
                        this.notifyNumbersJoined(n6, i, (n6 - n10) * n5, n);
                    }
                    n7 = n10;
                } else if (bl2) {
                    this.board[i][n10] = n8;
                    this.notifyNumberMoved(i, n6, (n6 - n10) * n5, n);
                } else {
                    this.board[n10][i] = n8;
                    this.notifyNumberMoved(n6, i, (n6 - n10) * n5, n);
                }
                if (bl2) {
                    this.board[i][n6] = 0;
                } else {
                    this.board[n6][i] = 0;
                }
                bl = true;
            }
        }
        return bl;
    }

    private void notifyNumberCreated(int n, int n2) {
        ++this.fieldsOccupied;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.elementAt(i);
            if (!(e instanceof BoardChangeListener)) continue;
            ((BoardChangeListener)e).onNumberCreated(this, n, n2, this.fieldsOccupied == 16);
        }
    }

    private void notifyNumbersJoined(int n, int n2, int n3, int n4) {
        --this.fieldsOccupied;
        Movement movement = new Movement(n, n2, n3, n4);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.elementAt(i);
            if (!(e instanceof BoardChangeListener)) continue;
            ((BoardChangeListener)e).onNumbersJoined(this, movement);
        }
    }

    private void notifyNumberMoved(int n, int n2, int n3, int n4) {
        Movement movement = new Movement(n, n2, n3, n4);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.elementAt(i);
            if (!(e instanceof BoardChangeListener)) continue;
            ((BoardChangeListener)e).onNumberMoved(this, movement);
        }
    }

    private void notifyNumberRemoved(int n, int n2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object e = this.listeners.elementAt(i);
            if (!(e instanceof BoardChangeListener)) continue;
            ((BoardChangeListener)e).onNumberRemoved(this, n, n2);
        }
    }

    public final int getNumber(int n, int n2) {
        return this.board[n][n2];
    }

    public final void addListener(BoardChangeListener boardChangeListener) {
        this.listeners.addElement(boardChangeListener);
    }

    public final void removeListener(BoardChangeListener boardChangeListener) {
        this.listeners.removeElement(boardChangeListener);
    }

    public final int getRows() {
        return 4;
    }

    public final int getCols() {
        return 4;
    }

    public final boolean canMove() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n;
                int n2 = this.board[i][j];
                if (i > 0 && ((n = this.board[i - 1][j]) == 0 || n == n2)) {
                    return true;
                }
                if (i < 3 && ((n = this.board[i + 1][j]) == 0 || n == n2)) {
                    return true;
                }
                if (j > 0 && ((n = this.board[i][j - 1]) == 0 || n == n2)) {
                    return true;
                }
                if (j >= 3 || (n = this.board[i][j + 1]) != 0 && n != n2) continue;
                return true;
            }
        }
        return false;
    }

    public final void loadState(DataInputStream dataInputStream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = dataInputStream.readInt();
                if (!this.isPositivePowerOfTwo(n)) continue;
                this.boardClean = false;
                this.createNumber(i, j, n);
            }
        }
    }

    private boolean isPositivePowerOfTwo(int n) {
        if (n < 2) {
            return false;
        }
        char[] cArray = Integer.toBinaryString(n).toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '0') continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return true;
    }

    public final void saveState(DataOutputStream dataOutputStream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dataOutputStream.writeInt(this.board[i][j]);
            }
        }
    }

    private void removeNumber(int n, int n2) {
        if (this.board[n][n2] > 0) {
            this.notifyNumberRemoved(n, n2);
        }
        this.board[n][n2] = 0;
    }

    public final boolean isEmpty() {
        return this.fieldsOccupied == 0;
    }

    public final boolean has2048() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.board[i][j] < 2048) continue;
                return true;
            }
        }
        return false;
    }
}

