/*
 * Decompiled with CFR 0.152.
 */
package game2048.scene;

import game2048.scene.Animable;
import game2048.scene.Drawable;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public abstract class Message
implements Drawable,
Animable {
    private static final int BACKGROUND = 0xFFFFFF;
    private static final int FOREGROUND = 0;
    private static final int PADDING = 10;
    private static final float ANIMATION_DURATION = 100.0f;
    private static final int MIN_CONTENT_HEIGHT = 0;
    private final Canvas canvas;
    private int currentY;
    private long animationTime;
    private int height;
    private int contentWidth;
    private int contentHeight;
    private int optionPaneWidth;
    private int optionPaneHeight;
    private boolean visible = false;
    private boolean appearing = false;
    private boolean disappearing = false;
    private Runnable runOnAppear;
    private Runnable runOnDisappear;

    public Message(Canvas canvas) {
        this.canvas = canvas;
    }

    public final void draw(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = this.canvas.getWidth();
        int n2 = this.canvas.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, this.currentY, n, n2 - this.currentY);
        graphics.setColor(0);
        graphics.drawLine(0, this.currentY, n, this.currentY);
        int n3 = this.currentY + 10 + 1;
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.setClip(10, n3, this.contentWidth, this.contentHeight);
        graphics.translate(10, n3);
        this.drawContent(graphics);
        graphics.translate(-10, -n3);
        n3 += this.contentHeight;
        n3 += 10;
        graphics.setClip(10, n3 += 10, this.optionPaneWidth, this.optionPaneHeight);
        graphics.translate(10, n3);
        this.drawOptionPane(graphics);
        graphics.translate(-10, -n3);
        graphics.clipRect(n4, n5, n6, n7);
    }

    public final boolean animate(long l) {
        float f;
        if (!this.appearing && !this.disappearing) {
            return false;
        }
        this.animationTime += l;
        if (this.appearing) {
            f = (float)((long)this.height * this.animationTime) / 100.0f;
            if (f >= (float)this.height) {
                this.currentY = this.canvas.getHeight() - this.height;
                this.appearing = false;
                if (this.runOnAppear != null) {
                    new Thread(this.runOnAppear).start();
                }
                return true;
            }
        } else {
            f = (float)this.height * (100.0f - (float)this.animationTime) / 100.0f;
            if (f <= 0.0f) {
                this.currentY = this.canvas.getHeight();
                this.disappearing = false;
                this.visible = false;
                if (this.runOnDisappear != null) {
                    new Thread(this.runOnDisappear).start();
                }
                return true;
            }
        }
        this.currentY = (int)((float)this.canvas.getHeight() - f);
        return true;
    }

    public final void appear(Runnable runnable) {
        if (this.appearing || this.disappearing) {
            return;
        }
        this.visible = true;
        this.appearing = true;
        this.runOnAppear = runnable;
        this.currentY = this.canvas.getHeight();
        this.animationTime = 0L;
        this.contentHeight = Math.max(this.getContentHeight() + 1, 0);
        this.contentWidth = this.canvas.getWidth() - 20;
        this.optionPaneHeight = this.getOptionPaneHeight() + 1;
        this.optionPaneWidth = this.contentWidth;
        this.height = 40 + this.contentHeight + this.optionPaneHeight + 1;
    }

    public final void disappear(Runnable runnable) {
        if (this.appearing || this.disappearing) {
            return;
        }
        this.disappearing = true;
        this.runOnDisappear = runnable;
        this.animationTime = 0L;
    }

    protected final int getContentWidth() {
        return this.contentWidth - 1;
    }

    protected final int getOptionPaneWidth() {
        return this.optionPaneWidth - 1;
    }

    protected final Canvas getCanvas() {
        return this.canvas;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final boolean isAppearing() {
        return this.appearing;
    }

    public final boolean isDisappearing() {
        return this.disappearing;
    }

    protected abstract void drawContent(Graphics var1);

    protected abstract void drawOptionPane(Graphics var1);

    protected abstract int getOptionPaneHeight();

    protected abstract int getContentHeight();
}

