/*
 * Decompiled with CFR 0.152.
 */
package game2048;

import game2048.Board;
import game2048.BoardChangeListener;
import game2048.EmptyCanvas;
import game2048.Movement;
import game2048.VservManager;
import game2048.scene.Scene;
import game2048.scene.UserActivityListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class Game2048
extends MIDlet
implements BoardChangeListener,
UserActivityListener {
    private RecordStore store;
    private Display display;
    private Board board;
    private Scene scene;
    private int score;
    private int best;
    private boolean improvedBest;
    private volatile boolean canCreateNumber;
    private boolean alreadyGot2048;
    static Hashtable configHashTable;
    static MIDlet vservMidlet;
    static boolean isStartInstanceRunning;
    static boolean isEndInstanceRunning;

    public final void startMainApp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.prepareBoard();
        this.prepareScene();
        this.displayScene();
        this.loadSettings();
        this.scene.start();
    }

    private void prepareBoard() {
        this.board = new Board();
        this.board.addListener(this);
    }

    private void prepareScene() {
        try {
            this.scene = new Scene(this.board.getRows(), this.board.getCols());
            this.scene.addListener(this);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void displayScene() {
        this.display.setCurrent((Displayable)this.scene);
        this.scene.setFullScreenMode(true);
    }

    private boolean openStore() {
        try {
            this.store = RecordStore.openRecordStore((String)"2048", (boolean)true);
            return true;
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            return false;
        }
    }

    private void closeStore() {
        try {
            this.store.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    private void loadSettings() {
        boolean bl = false;
        if (this.openStore()) {
            try {
                if (this.store.getNumRecords() > 0) {
                    RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordEnumeration.nextRecord());
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    this.setBest(dataInputStream.readInt());
                    this.setScore(dataInputStream.readInt());
                    this.board.loadState(dataInputStream);
                    this.alreadyGot2048 = this.board.has2048();
                    bl = true;
                    dataInputStream.close();
                    byteArrayInputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.closeStore();
        }
        if (!bl) {
            this.setBest(0);
            this.resetGame();
            return;
        }
        if (this.board.isEmpty()) {
            this.resetGame();
        }
    }

    private void saveSettings() {
        if (this.openStore()) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(this.best);
                dataOutputStream.writeInt(this.score);
                this.board.saveState(dataOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                byteArrayOutputStream.close();
                if (this.store.getNumRecords() > 0) {
                    RecordEnumeration recordEnumeration = this.store.enumerateRecords(null, null, false);
                    int n = recordEnumeration.nextRecordId();
                    this.store.setRecord(n, byArray, 0, byArray.length);
                } else {
                    this.store.addRecord(byArray, 0, byArray.length);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.closeStore();
        }
    }

    public final void pauseMainApp() {
        this.destroyApp(false);
    }

    public final void destroyApp(boolean bl) {
        if (this.scene != null) {
            this.saveSettings();
            this.display.setCurrent((Displayable)new EmptyCanvas());
            this.scene.stop();
            this.board = null;
            this.scene = null;
        }
    }

    private void resetGame() {
        this.improvedBest = false;
        this.alreadyGot2048 = false;
        this.setScore(0);
        this.board.init();
    }

    public final void onNumberCreated(Board board, int n, int n2, boolean bl) {
        this.canCreateNumber = false;
        if (bl && !board.canMove()) {
            this.scene.createNumber(board.getNumber(n, n2), n, n2, new Runnable(){

                public final void run() {
                    Game2048.this.scene.setGameOverDialogDisplayed(true, null);
                }
            });
        } else {
            this.scene.createNumber(board.getNumber(n, n2), n, n2, null);
        }
    }

    public final void onNumbersJoined(final Board board, final Movement movement) {
        final int n = board.getNumber(movement.destinationRow, movement.destinationCol);
        this.setScore(this.score + n);
        this.scene.move(board, movement, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Board board2 = board;
                synchronized (board2) {
                    if (n == 2048 && !Game2048.this.alreadyGot2048) {
                        Game2048.this.alreadyGot2048 = true;
                        Game2048.this.scene.createNumber(n, movement.destinationRow, movement.destinationCol, new Runnable(){

                            public final void run() {
                                Game2048.this.scene.setCongratulationsDialogDisplayed(true, null);
                            }
                        });
                    } else {
                        Game2048.this.scene.createNumber(n, movement.destinationRow, movement.destinationCol, null);
                    }
                    if (Game2048.this.canCreateNumber) {
                        board.createNumber();
                    }
                }
            }
        });
    }

    public final void onNumberMoved(final Board board, Movement movement) {
        this.scene.move(board, movement, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Board board2 = board;
                synchronized (board2) {
                    if (Game2048.this.canCreateNumber) {
                        board.createNumber();
                    }
                }
            }
        });
    }

    public final void onKeyPressed(int n) {
        if (this.scene.isAnimating()) {
            return;
        }
        if (this.scene.isGameOverDialogDisplayed() || this.scene.isNewGameDialogDisplayed()) {
            switch (n) {
                case -6: 
                case 42: {
                    this.scene.hideDialog(new Runnable(){

                        public void run() {
                            Game2048.this.resetGame();
                        }
                    });
                    break;
                }
                case -7: 
                case 35: {
                    this.scene.hideDialog(null);
                }
            }
            return;
        }
        if (this.scene.isCongratulationsDialogDisplayed()) {
            switch (n) {
                case -6: 
                case 42: {
                    this.scene.hideDialog(null);
                    break;
                }
                case -7: 
                case 35: {
                    this.scene.setNewGameDialogDisplayed(true, null);
                }
            }
            return;
        }
        switch (n) {
            case -6: 
            case 42: {
                this.exit();
                break;
            }
            case -7: 
            case 35: {
                this.scene.setNewGameDialogDisplayed(true, null);
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                this.canCreateNumber = this.board.move(1);
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                this.canCreateNumber = this.board.move(8);
                break;
            }
            case -1: 
            case 1: 
            case 50: {
                this.canCreateNumber = this.board.move(2);
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                this.canCreateNumber = this.board.move(4);
            }
        }
    }

    public final void onNumberRemoved(Board board, int n, int n2) {
        this.scene.removeNumber(n, n2);
    }

    private void setScore(int n) {
        this.score = n;
        this.scene.updateScore(n);
        if (n > this.best) {
            this.improvedBest = true;
            this.setBest(n);
        }
    }

    private void setBest(int n) {
        this.best = n;
        this.scene.updateBest(n);
    }

    private void exit() {
        this.destroyApp(true);
        vservMidlet = this;
        if (isEndInstanceRunning) {
            return;
        }
        isEndInstanceRunning = true;
        configHashTable = new Hashtable();
        configHashTable.put("cache", "c757216f");
        configHashTable.put("staticAdOnlyOnFailure", "false");
        configHashTable.put("viewMandatory", "true");
        configHashTable.put("zoneId", "c757216f");
        configHashTable.put("showAt", "both");
        configHashTable.put("supportedScreens", "352x288|300x250|216x162|168x126|120x90");
        configHashTable.put("staticAdPosition", "0");
        configHashTable.put("showAds", "true");
        new VservManager(vservMidlet, configHashTable).showAtEnd();
    }

    public final void pauseApp() {
        if (!VservManager.startMainApp) {
            return;
        }
        this.pauseMainApp();
    }

    public void constructorMainApp() {
        this.canCreateNumber = false;
        this.alreadyGot2048 = false;
    }

    protected void startApp() {
        if (VservManager.startMainApp) {
            this.startMainApp();
            return;
        }
        if (isStartInstanceRunning) {
            return;
        }
        isStartInstanceRunning = true;
        configHashTable = new Hashtable();
        configHashTable.put("cache", "c757216f");
        configHashTable.put("staticAdOnlyOnFailure", "false");
        configHashTable.put("zoneId", "c757216f");
        configHashTable.put("viewMandatory", "true");
        configHashTable.put("staticAdPosition", "0");
        configHashTable.put("showAt", "both");
        configHashTable.put("supportedScreens", "352x288|300x250|216x162|168x126|120x90");
        configHashTable.put("showAds", "true");
        new VservManager(this, configHashTable).showAtStart();
    }
}

