/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.bluetooth;

import com.lemonquest.bluetooth.BluetoothSettings;
import com.lemonquest.bluetooth.ClientThread;
import com.lemonquest.bluetooth.Log;
import com.lemonquest.bluetooth.Processor;
import com.lemonquest.bluetooth.ServerThread;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.StreamConnection;

public class BlueToothProtocol {
    public Hashtable btAddress2processor = new Hashtable();
    public EventHandler ui;
    public String userName;
    public Vector foundDevices = new Vector();
    public Hashtable foundServices = new Hashtable();
    public Vector foundServicesName = new Vector();
    public byte mode;
    private byte f = (byte)-1;
    public int searchDeviceIndex;
    private ClientThread g;
    private ServerThread h;
    public static String url = "btspp://localhost:" + BluetoothSettings.UUID + ";authenticate=false" + ";authorize=false" + ";encrypt=false" + ";name=BluetoothApplication";
    public ByteArrayOutputStream a = null;
    public DataOutputStream b = null;
    public byte[] c;
    public byte[] d;
    public int e = 0;

    public BlueToothProtocol(EventHandler eventHandler) {
        try {
            this.ui = eventHandler;
            this.setUserName(LocalDevice.getLocalDevice().getFriendlyName());
            return;
        }
        catch (BluetoothStateException bluetoothStateException) {
            this.setUserName("unkownUser");
            eventHandler.error(bluetoothStateException.getMessage(), (byte)1, "BlueToothProtocol");
            bluetoothStateException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            eventHandler.error(exception.getMessage(), (byte)1, "Not support bluetooth");
            exception.printStackTrace();
            return;
        }
    }

    public void handleServerConnection(StreamConnection streamConnection) {
        new Thread(this, streamConnection){
            private final StreamConnection a;
            private final BlueToothProtocol b;
            {
                this.b = blueToothProtocol;
                this.a = streamConnection;
            }

            public void run() {
                try {
                    DataInputStream dataInputStream = this.a.openDataInputStream();
                    Log.log("Read bt address.");
                    String string = this.b.readString(dataInputStream);
                    Log.log("connect client bt addres is: " + string);
                    this.b.handleConnection(this.a, string, dataInputStream, this.a.openDataOutputStream());
                    return;
                }
                catch (Exception exception) {
                    this.b.ui.error(exception.getMessage(), (byte)5, "BlueToothProtocol-handleserverconnection");
                    exception.printStackTrace();
                    return;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killClientThread() {
        BlueToothProtocol blueToothProtocol = this;
        synchronized (blueToothProtocol) {
            if (this.g != null) {
                this.g.cancelSearch();
                this.g.b = false;
                this.f = (byte)3;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                this.g = null;
                this.clearClientRecords();
                Log.log("kill current client thread");
                System.gc();
            } else {
                Log.log("can not kill current client thread,is null now");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killServerThread() {
        BlueToothProtocol blueToothProtocol = this;
        synchronized (blueToothProtocol) {
            if (this.h != null) {
                this.h.isRunning = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
                this.h.closeServer();
                this.h = null;
                Log.log("kill current server thread");
                System.gc();
            } else {
                Log.log("can not kill current server thread,is null now");
            }
            return;
        }
    }

    public void handleClientConnection(StreamConnection streamConnection, String string) {
        try {
            DataOutputStream dataOutputStream = streamConnection.openDataOutputStream();
            Log.log("Write bt address.");
            this.writeString(dataOutputStream, LocalDevice.getLocalDevice().getBluetoothAddress());
            this.handleConnection(streamConnection, string, streamConnection.openDataInputStream(), dataOutputStream);
            return;
        }
        catch (Exception exception) {
            this.ui.error(exception.getMessage(), (byte)5, "BlueToothProtocol-handleclientconnection");
            try {
                streamConnection.close();
                return;
            }
            catch (IOException iOException) {
                this.ui.error(iOException.getMessage(), (byte)5, "BlueToothProtocol-close_Clientconnection");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(StreamConnection streamConnection, String string, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws Exception {
        string = string.toLowerCase();
        Hashtable hashtable = this.btAddress2processor;
        synchronized (hashtable) {
            if (!this.btAddress2processor.containsKey(string)) {
                Log.log("Write user name.");
                this.writeString(dataOutputStream, this.userName);
                Log.log("Read user name.");
                String string2 = this.readString(dataInputStream);
                Log.log("userName: " + string2);
                Processor processor = new Processor(this, string, streamConnection, dataInputStream, dataOutputStream, string2);
                processor.start();
                this.btAddress2processor.put(string, processor);
                Log.log("Start message read thread");
            } else {
                streamConnection.close();
            }
            return;
        }
    }

    public boolean hasConnection(String string) {
        try {
            return this.btAddress2processor.containsKey(string.toLowerCase()) || string.toUpperCase().equals(LocalDevice.getLocalDevice().getBluetoothAddress().toUpperCase());
        }
        catch (BluetoothStateException bluetoothStateException) {
            this.ui.error(bluetoothStateException.getMessage(), (byte)5, "clientConnection is exit");
            return true;
        }
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastMessage(byte[] byArray) {
        Enumeration enumeration = this.btAddress2processor.elements();
        while (enumeration.hasMoreElements()) {
            Processor processor = (Processor)enumeration.nextElement();
            Vector vector = processor.sendMessages;
            synchronized (vector) {
                processor.sendMessages.addElement(byArray);
                processor.sendMessages.notify();
            }
        }
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setState(byte by) {
        this.f = by;
    }

    public byte getState() {
        return this.f;
    }

    public void startUpService() {
        this.setMode((byte)1);
        this.h = null;
        this.h = new ServerThread(this);
        this.h.start();
        Log.log("create new server thread");
        this.btAddress2processor.clear();
    }

    public void findDevices() {
        if (this.f != 0 && this.f != 2) {
            this.setMode((byte)0);
            this.f = 0;
            if (this.g == null) {
                this.g = new ClientThread(this);
                this.g.b = true;
                this.g.start();
                Log.log("create new find thread");
            }
            this.clearClientRecords();
            this.btAddress2processor.clear();
        }
    }

    public void clearClientRecords() {
        this.foundDevices.removeAllElements();
        Enumeration enumeration = this.foundServices.keys();
        while (enumeration.hasMoreElements()) {
            this.foundServices.remove(enumeration.nextElement());
        }
        this.foundServicesName.removeAllElements();
    }

    public void makeConnect(int n) {
        if (this.getState() != 2) {
            this.g.ServiceConnIndex = n;
            this.f = (byte)2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void CloseConnection() {
        try {
            Enumeration enumeration = this.btAddress2processor.elements();
            while (true) {
                Processor processor;
                if (!enumeration.hasMoreElements()) {
                    this.killServerThread();
                    this.killClientThread();
                    this.clearClientRecords();
                    return;
                }
                Processor processor2 = processor = (Processor)enumeration.nextElement();
                // MONITORENTER : processor
                Log.log("Close bluetooth connection.--" + processor.a);
                processor.close();
                this.btAddress2processor.remove(processor);
                System.gc();
                // MONITOREXIT : processor2
            }
        }
        catch (Exception exception) {
            Log.log("close connection error");
            exception.printStackTrace();
            return;
        }
    }

    public int getFindServiceSize() {
        return this.foundServicesName.size();
    }

    public String getFindServiceName(int n) {
        String string = (String)this.foundServicesName.elementAt(n);
        return string;
    }

    public void sendMessange() {
        this.broadcastMessage(this.c);
    }

    public void CycleSegment(byte[] byArray) {
        if (this.d != null) {
            this.d = null;
        }
        this.d = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.d, 0, byArray.length);
        this.ui.CycleSegment(this.d);
    }

    public void newSegment() {
        if (this.a != null) {
            this.a = null;
        }
        if (this.b != null) {
            this.b = null;
        }
        this.a = new ByteArrayOutputStream(10);
        this.b = new DataOutputStream(this.a);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.b.writeByte(1);
        this.b.writeByte(bl ? 1 : 0);
    }

    public void writeByte(byte by) throws IOException {
        this.b.writeByte(2);
        this.b.writeByte(by);
    }

    public void writeChar(char c) throws IOException {
        this.b.writeByte(3);
        this.b.writeByte((byte)(c >> 8));
        this.b.writeByte((byte)c);
    }

    public void writeInt(int n) throws IOException {
        this.b.writeByte(4);
        this.b.writeByte((byte)(n >> 24));
        this.b.writeByte((byte)(n >> 16));
        this.b.writeByte((byte)(n >> 8));
        this.b.writeByte((byte)n);
    }

    public void writeShort(short s) throws IOException {
        this.b.writeByte(6);
        this.b.writeByte((byte)(s >> 8));
        this.b.writeByte((byte)s);
    }

    public void writeString(String string) throws IOException {
        this.b.writeByte(7);
        this.b.writeUTF(string == null ? "" : string);
    }

    public void flush() {
        try {
            this.b.flush();
        }
        catch (Exception exception) {}
        this.c = this.a.toByteArray();
        this.sendMessange();
    }

    public boolean readBoolean() {
        this.e += 2;
        return (this.d[this.e - 1] & 1) == 1;
    }

    public byte readByte() {
        this.e += 2;
        return this.d[this.e - 1];
    }

    public char readChar() {
        this.e += 3;
        return (char)BlueToothProtocol.getNumber(this.d, this.e - 2, 2);
    }

    public int readInt() {
        this.e += 5;
        return (int)BlueToothProtocol.getNumber(this.d, this.e - 4, 4);
    }

    public long readLong() {
        this.e += 9;
        return BlueToothProtocol.getNumber(this.d, this.e - 8, 8);
    }

    public short readShort() {
        this.e += 3;
        return (short)BlueToothProtocol.getNumber(this.d, this.e - 2, 2);
    }

    public String readString() {
        byte by = this.d[this.e];
        ++this.e;
        return this.readUTFString(by);
    }

    public void reset() {
        this.e = 0;
    }

    public static long getNumber(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l <<= 8;
            l |= (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    public String readUTFString(byte by) {
        try {
            int n = (int)BlueToothProtocol.getNumber(this.d, this.e, 2) + 2;
            int n2 = this.e;
            this.e += n;
            if (by == 7) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.d, n2, n));
                return dataInputStream.readUTF();
            }
            this.e += 2;
            int n3 = (n - 4) / 2;
            if (n3 == 0) {
                return "";
            }
            char[] cArray = new char[n3];
            int n4 = 0;
            int n5 = n2 + 4;
            while (n4 < n3) {
                cArray[n4] = (char)((this.d[n5] & 0xFF) + ((this.d[n5 + 1] & 0xFF) << 8));
                ++n4;
                n5 += 2;
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeUTF(string);
        dataOutputStream.flush();
    }

    public String readString(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readUTF();
    }

    public static interface EventHandler {
        public void connectReady();

        public void error(String var1, byte var2, String var3);

        public void CycleSegment(byte[] var1);
    }
}

