/*
 * Decompiled with CFR 0.152.
 */
package com.pip.util;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import java.util.Enumeration;
import java.util.Hashtable;

public class VMCounter {
    private static Hashtable counters = new Hashtable();
    private static Tool keyMaker = new Tool();
    private int counterTime;
    private long startTime;
    public static final byte COUNTER_TYPE_SERVER_TIME_BASED = 0;
    public static final byte COUNTER_TYPE_CLIENT_TIME_BASED = 1;
    private byte type = 0;

    private VMCounter(int counterTime) {
        this.counterTime = counterTime;
    }

    public static int createVMCounter(int counterTime) {
        VMCounter vc = new VMCounter(Math.abs(counterTime));
        if (counterTime > 0) {
            vc.type = 0;
            vc.startTime = Utilities.getServerTime();
        } else {
            vc.type = 1;
            vc.startTime = Tool.getSystemTime();
        }
        int key = keyMaker.nextKey();
        counters.put(new Integer(key), vc);
        return key;
    }

    public static int createVMCounter(int startTime, int counterTime) {
        int key = VMCounter.createVMCounter(counterTime);
        VMCounter.setCounter(key, startTime, counterTime);
        return key;
    }

    public static void removeVMCounter(int key) {
        counters.remove(new Integer(key));
    }

    public static void removeAllVMCounters() {
        counters.clear();
    }

    public static void cycle() {
        Enumeration enum2 = counters.keys();
        Hashtable newCounters = new Hashtable();
        while (enum2.hasMoreElements()) {
            Object key = enum2.nextElement();
            VMCounter counter = (VMCounter)counters.get(key);
            if (counter.type == 0) {
                if ((long)Utilities.getServerTime() - counter.startTime >= (long)counter.counterTime) continue;
                newCounters.put(key, counter);
                continue;
            }
            if (Tool.getSystemTime() - counter.startTime >= (long)counter.counterTime) continue;
            newCounters.put(key, counter);
        }
        counters = newCounters;
    }

    public static int getProcess(int key) {
        VMCounter vc = (VMCounter)counters.get(new Integer(key));
        if (vc != null) {
            if (vc.type == 0) {
                return (int)((long)Utilities.getServerTime() - vc.startTime) * 100 / vc.counterTime;
            }
            return (int)(Tool.getSystemTime() - vc.startTime) * 100 / vc.counterTime;
        }
        return -1;
    }

    public static int getElapseTime(int key) {
        VMCounter vc = (VMCounter)counters.get(new Integer(key));
        if (vc != null) {
            if (vc.type == 0) {
                return (int)((long)Utilities.getServerTime() - vc.startTime);
            }
            return (int)(Tool.getSystemTime() - vc.startTime);
        }
        return -1;
    }

    public static int getSaveTimeSec(int key) {
        VMCounter vc = (VMCounter)counters.get(new Integer(key));
        if (vc != null) {
            if (vc.type == 0) {
                return (vc.counterTime - (int)((long)Utilities.getServerTime() - vc.startTime)) / 1000;
            }
            return (vc.counterTime - (int)(Tool.getSystemTime() - vc.startTime)) / 1000;
        }
        return -1;
    }

    public static int getSaveTimeMillis(int key) {
        VMCounter vc = (VMCounter)counters.get(new Integer(key));
        if (vc != null) {
            if (vc.type == 0) {
                return vc.counterTime - (int)((long)Utilities.getServerTime() - vc.startTime);
            }
            return vc.counterTime - (int)(Tool.getSystemTime() - vc.startTime);
        }
        return -1;
    }

    public static void setCounter(int key, int startTime, int counterTime) {
        VMCounter vc = (VMCounter)counters.get(new Integer(key));
        if (vc != null) {
            vc.startTime = startTime;
            vc.counterTime = counterTime;
        }
    }
}

