/*
 * Decompiled with CFR 0.152.
 */
package com.pip.ui;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.engine.AnimateCache;
import com.pip.engine.AnimatePlayer;
import com.pip.engine.IAnimateCallback;
import com.pip.engine.IVMGameProcessor;
import com.pip.engine.Weather;
import com.pip.gui.GContainer;
import com.pip.gui.GGameIcon;
import com.pip.gui.GIcon;
import com.pip.gui.GImageNumer;
import com.pip.gui.GLabel;
import com.pip.gui.GLinePanel;
import com.pip.gui.GScrollBar;
import com.pip.gui.GTextArea;
import com.pip.gui.GWidget;
import com.pip.gui.GWindow;
import com.pip.gui.IGCycle;
import com.pip.gui.IGPaint;
import com.pip.image.ImageSet;
import com.pip.image.PipAnimateSet;
import com.pip.io.UASegment;
import com.pip.sanguo.GameIcon;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameNetPlayer;
import com.pip.sanguo.GameNpc;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameWorld;
import com.pip.sanguo.SanguoMIDlet;
import com.pip.ui.Quest;
import com.pip.ui.VMGame;
import com.pip.util.SortHashtable;
import com.pip.util.VMCounter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class VM
implements CommandListener {
    public static final byte ADD = 1;
    public static final byte SUB = 2;
    public static final byte MUL = 3;
    public static final byte DIV = 4;
    public static final byte MOD = 5;
    public static final byte AND = 6;
    public static final byte OR = 7;
    public static final byte ANDB = 8;
    public static final byte ORB = 9;
    public static final byte LSHIFT = 10;
    public static final byte RSHIFT = 11;
    public static final byte INCV = 12;
    public static final byte ADDV8 = 13;
    public static final byte SUBV8 = 14;
    public static final byte EQ = 17;
    public static final byte GT = 18;
    public static final byte LT = 19;
    public static final byte EQ8 = 20;
    public static final byte GT8 = 21;
    public static final byte LT8 = 22;
    public static final byte NE8 = 23;
    public static final byte INCVS = 24;
    public static final byte ADDV8S = 25;
    public static final byte SUBV8S = 26;
    public static final byte LOADVS = 27;
    public static final byte SAVEVS = 28;
    public static final byte DUP = 29;
    public static final byte JMP = 33;
    public static final byte JEQ = 34;
    public static final byte JNE = 35;
    public static final byte CALL = 36;
    public static final byte RET = 37;
    public static final byte VRET = 38;
    public static final byte SYSCALL = 39;
    public static final byte ALOAD8 = 40;
    public static final byte ASAVE8 = 41;
    public static final byte STLOAD8 = 42;
    public static final byte STSAVE8 = 43;
    public static final byte TSWITCH = 44;
    public static final byte LSWITCH = 45;
    public static final byte CALLPTR = 46;
    public static final byte LOAD = 49;
    public static final byte SAVE = 50;
    public static final byte LOAD32 = 51;
    public static final byte LOAD16 = 52;
    public static final byte LOAD8 = 53;
    public static final byte ALOAD = 54;
    public static final byte ASAVE = 55;
    public static final byte ALLOC = 56;
    public static final byte FREE = 57;
    public static final byte STALLOC = 58;
    public static final byte STLOAD = 59;
    public static final byte STSAVE = 60;
    public static final byte LOADV = 61;
    public static final byte SAVEV = 62;
    public static final byte LOADFUNC = 63;
    public static final byte LOADVS3 = 65;
    public static final byte LOADVS2 = 66;
    public static final byte LOAD88 = 67;
    public static final byte LOAD8VS = 68;
    public static final byte LOADVS8 = 69;
    public static final byte SYSCALLSAVEVS = 70;
    public static final byte LOADVSSTLOAD8 = 71;
    public static final byte LOAD8VSSTLOAD8 = 72;
    public static final byte LOADVSADDALOAD = 73;
    public static final byte LOADVSALOAD = 74;
    public static final int INSTRUCTION_MAX = 74;
    public static final byte[] INSTRUCTION_LENGTH = new byte[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 6, 6, 0, 0, 1, 1, 1, 2, 2, 2, 2, 5, 6, 6, 5, 5, 2, 0, 0, 0, 3, 3, 3, 4, 1, 1, 5, 2, 2, 2, 2, 0, 0, 2, 0, 0, 1, 1, 5, 3, 2, 1, 1, 2, 1, 3, 1, 1, 5, 5, 3, 0, 13, 9, 3, 6, 6, 9, 6, 7, 5, 5};
    public static final byte[] STACK_EFFECT = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 1, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, -1, 1, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, -2, 0, -2, -1, -1, 0, 0, 0, 0, -2, 1, 1, 1, -1, -3, 0, -1, 1, -1, -3, 1, -1, 1, 0, 3, 2, 2, 2, 2, 0, 1, 2, -1, 0};
    public static final Hashtable globalVMData = new Hashtable();
    private static int globalVMDataCurrentKey = 1;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int INIT = 0;
    public static final int CYCLE = 1;
    public static final int PROCESSPACKET = 2;
    public static final int CYCLEUI = 3;
    public static final int PAINT = 4;
    public static final int DESTROY = 5;
    public byte languageVersion = 0;
    protected short fileVersion;
    protected short libraryID;
    protected int[] staticHeap;
    protected int[] stack;
    protected int esp;
    protected int stackBase;
    protected int currentVM;
    protected int callCount;
    protected int eip;
    protected int currentFunc;
    protected Object[] dynamicHeap;
    protected short[] freeSpaceList;
    protected int freeHead;
    protected static final int TEMP_OBJECT_COUNT = 32;
    protected int nextTemp;
    protected int tempSpace;
    protected String[] stringTable;
    protected byte[] codeData;
    protected int[] functions;
    protected Hashtable callbacks;
    protected String[] libNames;
    protected VM[] libraries;
    protected int javaCallFunctionEnd = 5;
    protected boolean blocked;
    protected int[] blockPosition;
    protected int funcBase;
    protected boolean resumeFlag;
    protected boolean running;
    protected Object owner;
    protected byte ownerType;
    protected static final byte OWNER_TYPE_UI = 0;
    protected static final byte OWNER_TYPE_PROCESSOR = 1;
    protected static final byte OWNER_TYPE_QUEST = 2;
    private int[] syscallParams = new int[20];
    private String lastFormSelection;

    public VM(Object owner) {
        this.owner = owner;
        this.ownerType = owner instanceof IVMGameProcessor ? (byte)1 : (owner instanceof Quest ? (byte)2 : (byte)0);
    }

    public boolean isBlock() {
        return this.blocked;
    }

    public void pauseProcess() {
        this.blocked = true;
    }

    public void continueProcess(int returnValue) {
        this.resumeFlag = true;
        if (this.blockPosition != null) {
            this.blockPosition[this.blockPosition.length - 1] = returnValue;
        }
    }

    protected int[] saveStack() {
        int[] ret = new int[this.esp + 6];
        ret[0] = this.stackBase;
        ret[1] = this.currentVM;
        ret[2] = this.eip;
        ret[3] = this.currentFunc;
        ret[4] = this.callCount;
        if (this.esp >= 0) {
            System.arraycopy(this.stack, 0, ret, 5, this.esp + 1);
        }
        return ret;
    }

    protected void restoreStack(int[] bp) {
        this.stackBase = bp[0];
        this.currentVM = bp[1];
        this.eip = bp[2];
        this.currentFunc = bp[3];
        this.callCount = bp[4];
        this.funcBase = this.currentFunc * 3;
        this.esp = bp.length - 6;
        if (this.esp >= 0) {
            System.arraycopy(bp, 5, this.stack, 0, this.esp + 1);
        }
    }

    protected void resume() {
        this.blocked = false;
        if (this.blockPosition != null) {
            int[] bp = this.blockPosition;
            this.blockPosition = null;
            this.restoreStack(bp);
            try {
                this.processInst(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init(byte[] data) throws IOException {
        this.loadETF(data);
        this.esp = -1;
        this.stackBase = -1;
        this.eip = 0;
        this.currentFunc = 0;
        if (this.fileVersion == 0) {
            int initHeapSize = 128;
            this.tempSpace = 32;
            if (this.owner != null && this.owner instanceof Quest) {
                initHeapSize = 10;
                this.tempSpace = 8;
            }
            this.dynamicHeap = new Object[initHeapSize];
            this.freeSpaceList = new short[initHeapSize];
            for (int i = this.tempSpace - 1; i < initHeapSize - 1; ++i) {
                this.freeSpaceList[i] = (short)(i + 1);
            }
            this.freeSpaceList[initHeapSize - 1] = (short)(this.tempSpace - 1);
            this.freeHead = this.tempSpace - 1;
        }
    }

    public void link() {
        this.libraries = new VM[this.libNames.length + 1];
        this.libraries[0] = this;
        for (int i = 0; i < this.libNames.length; ++i) {
            this.libraries[i + 1] = VMGame.getVMGame(this.libNames[i]).getVM();
        }
    }

    public void loadETF(byte[] data) throws IOException {
        byte[] etfCode;
        int len;
        int[] etfFunctions;
        int count;
        String[] etfStringTable;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        int head = is.readInt();
        if (head != 1162300416 && head != 1162300417) {
            throw new IOException("Invalid ETF file!");
        }
        this.languageVersion = (byte)(head & 0xFF);
        this.fileVersion = is.readShort();
        this.libraryID = is.readShort();
        is.skip(4L);
        short heapSize = is.readShort();
        short taskAttr = is.readShort();
        Tool.readUTF16(is);
        Tool.readUTF16(is);
        is.readInt();
        short tk = is.readShort();
        if (tk == 21332) {
            short count2 = is.readShort();
            if (count2 <= 0) {
                throw new IOException("Invalid ETF file!");
            }
            etfStringTable = new String[count2];
            short len2 = is.readShort();
            count2 = 0;
            while (len2 > 0) {
                String s = Tool.readUTF16(is);
                len2 = s.length() < 128 ? (short)(len2 - (1 + 2 * s.length())) : (short)(len2 - (2 + 2 * s.length()));
                short s2 = count2;
                count2 = (short)(count2 + 1);
                etfStringTable[s2] = s;
            }
            if (len2 != 0 || count2 != etfStringTable.length) {
                throw new IOException("Invalid ETF file!");
            }
            tk = is.readShort();
        } else {
            etfStringTable = new String[]{};
        }
        if (tk == 17236) {
            count = is.readShort();
            if (count <= 0) {
                throw new IOException("Invalid ETF file!");
            }
            etfFunctions = new int[count * 3];
            len = is.readInt();
            etfCode = new byte[len];
            int codePos = 0;
            int base = 0;
            for (int i = 0; i < count; ++i) {
                int paramCount = is.readByte() & 0xFF;
                --len;
                is.skip(paramCount);
                len -= paramCount;
                int localVariables = is.readShort() & 0xFFFF;
                len -= 2;
                int funcLen = is.readInt();
                len -= 4;
                etfFunctions[base] = paramCount << 16 | localVariables;
                etfFunctions[base + 1] = codePos;
                is.read(etfCode, codePos, funcLen);
                etfFunctions[base + 2] = codePos + funcLen;
                codePos += funcLen;
                len -= funcLen;
                base += 3;
            }
            if (len != 0) {
                throw new IOException("Invalid ETF file!");
            }
        } else {
            throw new IOException("Invalid ETF file!");
        }
        if (this.languageVersion == 1) {
            int i;
            tk = is.readShort();
            if (tk == 17218) {
                count = is.readShort();
                if (count < 0) {
                    throw new IOException("Invalid ETF file!");
                }
                this.callbacks = new Hashtable();
                len = is.readShort();
                for (i = 0; i < count; ++i) {
                    String s = Tool.readUTF16(is);
                    len = s.length() < 128 ? (int)((short)(len - (1 + 2 * s.length()))) : (int)((short)(len - (2 + 2 * s.length())));
                    short id = is.readShort();
                    len = (short)(len - 2);
                    this.callbacks.put(s, new Short(id));
                }
                if (len != 0) {
                    throw new IOException("Invalid ETF file!");
                }
            } else {
                throw new IOException("Invalid ETF file!");
            }
            this.javaCallFunctionEnd = this.fileVersion == 0 ? (this.javaCallFunctionEnd += this.callbacks.size()) : this.callbacks.size();
            tk = is.readShort();
            if (tk == 19522) {
                count = is.readShort();
                if (count < 0) {
                    throw new IOException("Invalid ETF file!");
                }
                this.libNames = new String[count];
                len = is.readShort();
                for (i = 0; i < count; ++i) {
                    this.libNames[i] = Tool.readUTF16(is);
                    len = this.libNames[i].length() < 128 ? (int)((short)(len - (1 + 2 * this.libNames[i].length()))) : (int)((short)(len - (2 + 2 * this.libNames[i].length())));
                }
                if (len != 0) {
                    throw new IOException("Invalid ETF file!");
                }
            } else {
                throw new IOException("Invalid ETF file!");
            }
        }
        if (this.fileVersion == 0) {
            this.staticHeap = new int[heapSize & 0xFFFF];
            this.stack = new int[taskAttr & 0xFFFF];
        }
        this.stringTable = etfStringTable;
        this.functions = etfFunctions;
        this.codeData = etfCode;
    }

    public void destroy() {
        this.staticHeap = null;
        this.stack = null;
        this.dynamicHeap = null;
        this.freeSpaceList = null;
        this.stringTable = null;
        this.functions = null;
    }

    protected int heapAlloc() {
        if (this.freeSpaceList[this.freeHead] == this.freeHead) {
            int expandSize = this.dynamicHeap.length / 2;
            Object[] newarr = new Object[this.dynamicHeap.length + expandSize];
            short[] newarr2 = new short[this.dynamicHeap.length + expandSize];
            System.arraycopy(this.dynamicHeap, 0, newarr, 0, this.dynamicHeap.length);
            System.arraycopy(this.freeSpaceList, 0, newarr2, 0, this.dynamicHeap.length);
            for (int i = this.dynamicHeap.length; i < newarr2.length; ++i) {
                newarr2[i] = (short)(i + 1);
            }
            newarr2[newarr2.length - 1] = this.freeSpaceList[this.freeHead];
            newarr2[this.freeHead] = (short)this.dynamicHeap.length;
            this.dynamicHeap = newarr;
            this.freeSpaceList = newarr2;
        }
        int next = this.freeSpaceList[this.freeHead] & 0xFFFF;
        this.freeSpaceList[this.freeHead] = this.freeSpaceList[next];
        return next;
    }

    protected void heapFree(int addr) {
        if ((addr & 0xFFF) < this.tempSpace) {
            return;
        }
        this.dynamicHeap[addr] = null;
        short tmp = this.freeSpaceList[this.freeHead];
        this.freeSpaceList[this.freeHead] = (short)addr;
        this.freeSpaceList[addr] = tmp;
    }

    protected int memLoad(int addr) {
        if ((addr & Integer.MIN_VALUE) == 0) {
            return this.staticHeap[addr & 0x3FFFFFFF];
        }
        return this.stack[this.stackBase + (addr & 0x3FFFFFFF)];
    }

    protected void memSave(int addr, int value) {
        if ((addr & Integer.MIN_VALUE) == 0) {
            this.staticHeap[addr & 0x3FFFFFFF] = value;
            if (this.ownerType == 2) {
                Tool.sendSyncVMVarialbe(((Quest)this.owner).id, addr, value);
            }
        } else {
            this.stack[this.stackBase + (addr & 0x3FFFFFFF)] = value;
        }
    }

    protected int arrLoad(int addr, int offset) {
        int pointer = addr;
        int dataType = pointer >> 26 & 0xF;
        if (dataType > 3) {
            return pointer | offset << 12 | 0x2000000;
        }
        Object obj = this.dynamicHeap[pointer & 0xFFF];
        switch (dataType) {
            case 0: {
                return ((boolean[])obj)[offset] ? 1 : 0;
            }
            case 1: {
                return ((byte[])obj)[offset];
            }
            case 2: {
                return ((short[])obj)[offset];
            }
            case 3: {
                return ((int[])obj)[offset];
            }
        }
        return 0;
    }

    protected void arrSave(int addr, int offset, int value) {
        int pointer = addr;
        int dataType = pointer >> 26 & 0xF;
        Object obj = this.dynamicHeap[pointer & 0xFFF];
        if (dataType > 3) {
            ((Object[])obj)[offset] = this.followPointer(value);
            return;
        }
        switch (dataType) {
            case 0: {
                ((boolean[])obj)[offset] = value != 0;
                break;
            }
            case 1: {
                ((byte[])obj)[offset] = (byte)value;
                break;
            }
            case 2: {
                ((short[])obj)[offset] = (short)value;
                break;
            }
            case 3: {
                ((int[])obj)[offset] = value;
            }
        }
    }

    public Object followPointer(int pointer) {
        if (pointer == 0) {
            return null;
        }
        if ((pointer & Integer.MIN_VALUE) != 0) {
            short libID = (short)(pointer >> 16 & Short.MAX_VALUE);
            if (libID == 0) {
                return this.stringTable[pointer & 0xFFFF];
            }
            for (int i = 1; i < this.libraries.length; ++i) {
                if (libID != this.libraries[i].libraryID) continue;
                return this.libraries[i].stringTable[pointer & 0xFFFF];
            }
            return null;
        }
        int dataType = pointer >> 26 & 0x1F;
        if (dataType >= 4 && dataType <= 19) {
            int t = pointer & 0xFFF;
            return this.dynamicHeap[t & 0xFFF];
        }
        if (dataType >= 20) {
            Object[] arr = (Object[])this.dynamicHeap[pointer & 0xFFF];
            if ((pointer & 0x2000000) != 0) {
                return arr[pointer >> 12 & 0x1FFF];
            }
            return arr;
        }
        return null;
    }

    protected String[] getStringArrayFromParams(int pointer) {
        String[] strs = null;
        Object[] obs = (Object[])this.followPointer(pointer);
        if (obs != null) {
            strs = new String[obs.length];
            for (int i = 0; i < strs.length; ++i) {
                strs[i] = (String)obs[i];
            }
        }
        return strs;
    }

    protected int alloc(byte dataType, int length) {
        int ret = this.heapAlloc();
        switch (dataType) {
            case 0: {
                this.dynamicHeap[ret] = new boolean[length];
                break;
            }
            case 1: {
                this.dynamicHeap[ret] = new byte[length];
                break;
            }
            case 2: {
                this.dynamicHeap[ret] = new short[length];
                break;
            }
            case 3: {
                this.dynamicHeap[ret] = new int[length];
                break;
            }
            case 11: {
                this.dynamicHeap[ret] = new String[length];
                break;
            }
            default: {
                this.dynamicHeap[ret] = new Object[length];
            }
        }
        return ret | dataType + 16 << 26;
    }

    public void free(int addr) {
        if ((addr & 0x82000000) == 0) {
            this.heapFree(addr & 0xFFF);
        }
    }

    public synchronized int makeTempObject(Object obj) {
        if (obj == null) {
            return 0;
        }
        this.dynamicHeap[this.nextTemp] = obj;
        int addr = this.nextTemp;
        this.nextTemp = this.nextTemp + 1 & this.tempSpace - 1;
        if (obj instanceof boolean[]) {
            return 0x40000000 | addr;
        }
        if (obj instanceof byte[]) {
            return 0x44000000 | addr;
        }
        if (obj instanceof short[]) {
            return 0x48000000 | addr;
        }
        if (obj instanceof int[]) {
            return 0x4C000000 | addr;
        }
        if (obj instanceof Object[]) {
            return 0x50000000 | addr;
        }
        return 0x10000000 | addr;
    }

    protected int searchTable(byte[] data, int pos, int count, int byteLen, int compare) {
        int start = 0;
        int end = count - 1;
        while (start <= end) {
            int mid = start + end >> 1;
            int pos2 = pos + mid * (byteLen + 2);
            int cmp = byteLen == 1 ? data[pos2] : (byteLen == 2 ? Tool.getShort(data, pos2) : Tool.getInt(data, pos2));
            if (cmp == compare) {
                return Tool.getShort(data, pos2 + byteLen);
            }
            if (cmp < compare) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return -1;
    }

    public void processInst(boolean ignoreBlock) throws Exception {
        int[] functions = this.libraries[this.currentVM].functions;
        byte[] codeData = this.libraries[this.currentVM].codeData;
        int eipmax = functions[this.funcBase + 2];
        block68: while (this.eip < eipmax) {
            if (!ignoreBlock && this.blocked) {
                this.blockPosition = this.saveStack();
                break;
            }
            byte inst = codeData[this.eip];
            switch (inst) {
                case 1: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] + this.stack[this.esp];
                    break;
                }
                case 2: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] - this.stack[this.esp];
                    break;
                }
                case 3: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] * this.stack[this.esp];
                    break;
                }
                case 4: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] / this.stack[this.esp];
                    break;
                }
                case 5: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] % this.stack[this.esp];
                    break;
                }
                case 6: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] != 0 && this.stack[this.esp] != 0 ? 1 : 0;
                    break;
                }
                case 7: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] != 0 || this.stack[this.esp] != 0 ? 1 : 0;
                    break;
                }
                case 8: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] & this.stack[this.esp];
                    break;
                }
                case 9: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] | this.stack[this.esp];
                    break;
                }
                case 10: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] << this.stack[this.esp];
                    break;
                }
                case 11: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] >> this.stack[this.esp];
                    break;
                }
                case 12: {
                    int n = Tool.getInt(codeData, this.eip + 1);
                    this.staticHeap[n] = this.staticHeap[n] + 1;
                    if (this.ownerType != 2) break;
                    Tool.sendSyncVMVarialbe(((Quest)this.owner).id, Tool.getInt(codeData, this.eip + 1), this.staticHeap[Tool.getInt(codeData, this.eip + 1)]);
                    break;
                }
                case 13: {
                    this.stack[this.esp + 1] = this.staticHeap[Tool.getInt(codeData, this.eip + 1)] + codeData[this.eip + 5];
                    break;
                }
                case 14: {
                    this.stack[this.esp + 1] = this.staticHeap[Tool.getInt(codeData, this.eip + 1)] - codeData[this.eip + 5];
                    break;
                }
                case 24: {
                    int n = this.stackBase + Tool.getInt(codeData, this.eip + 1);
                    this.stack[n] = this.stack[n] + 1;
                    break;
                }
                case 25: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)] + codeData[this.eip + 5];
                    break;
                }
                case 26: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)] - codeData[this.eip + 5];
                    break;
                }
                case 17: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] == this.stack[this.esp] ? 1 : 0;
                    break;
                }
                case 18: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] > this.stack[this.esp] ? 1 : 0;
                    break;
                }
                case 19: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] < this.stack[this.esp] ? 1 : 0;
                    break;
                }
                case 20: {
                    this.stack[this.esp] = this.stack[this.esp] == codeData[this.eip + 1] ? 1 : 0;
                    break;
                }
                case 21: {
                    this.stack[this.esp] = this.stack[this.esp] > codeData[this.eip + 1] ? 1 : 0;
                    break;
                }
                case 22: {
                    this.stack[this.esp] = this.stack[this.esp] < codeData[this.eip + 1] ? 1 : 0;
                    break;
                }
                case 23: {
                    this.stack[this.esp] = this.stack[this.esp] == codeData[this.eip + 1] ? 0 : 1;
                    break;
                }
                case 33: {
                    this.eip = functions[this.funcBase + 1] + (Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    continue block68;
                }
                case 34: {
                    if (this.stack[this.esp] == 0) break;
                    this.eip = functions[this.funcBase + 1] + (Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    --this.esp;
                    continue block68;
                }
                case 35: {
                    if (this.stack[this.esp] != 0) break;
                    this.eip = functions[this.funcBase + 1] + (Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    --this.esp;
                    continue block68;
                }
                case 36: 
                case 46: {
                    int callFunc;
                    int parCount = codeData[this.eip + 1] & 0xFF;
                    if (inst == 36) {
                        callFunc = Tool.getShort(codeData, this.eip + 2) & 0xFFFF;
                    } else {
                        callFunc = this.stack[this.esp] & 0xFFFF;
                        --this.esp;
                    }
                    int callVM = 0;
                    if ((callFunc & 0xF000) != 0) {
                        callVM = (callFunc & 0xF000) >> 12;
                        if (this.currentVM != 0 && inst == 36) {
                            VM nextVM = this.libraries[this.currentVM].libraries[callVM];
                            for (int i = 0; i < this.libraries.length; ++i) {
                                if (nextVM != this.libraries[i]) continue;
                                callVM = i;
                                break;
                            }
                        }
                        functions = this.libraries[callVM].functions;
                        codeData = this.libraries[callVM].codeData;
                        callFunc &= 0xFFF;
                    } else if (inst == 36) {
                        callVM = this.currentVM;
                    } else {
                        callVM = 0;
                        functions = this.libraries[callVM].functions;
                        codeData = this.libraries[callVM].codeData;
                    }
                    int newStackBase = this.esp - parCount + 1;
                    int localParamCount = functions[callFunc * 3] & 0xFFFF;
                    for (int ii = this.esp + 1; ii <= this.esp + localParamCount; ++ii) {
                        this.stack[ii] = 0;
                    }
                    this.esp += localParamCount;
                    this.stack[this.esp + 1] = this.stackBase;
                    this.stack[this.esp + 2] = this.currentVM;
                    this.stack[this.esp + 3] = this.currentFunc;
                    this.stack[this.esp + 4] = inst == 36 ? this.eip + 4 : this.eip + 2;
                    this.esp += 4;
                    this.stackBase = newStackBase;
                    this.currentVM = callVM;
                    ++this.callCount;
                    this.currentFunc = callFunc;
                    this.funcBase = this.currentFunc * 3;
                    this.eip = functions[this.funcBase + 1];
                    eipmax = functions[this.funcBase + 2];
                    continue block68;
                }
                case 37: {
                    if (this.callCount == 0) {
                        return;
                    }
                    this.eip = this.stack[this.esp];
                    this.currentFunc = this.stack[this.esp - 1];
                    this.currentVM = this.stack[this.esp - 2];
                    functions = this.libraries[this.currentVM].functions;
                    codeData = this.libraries[this.currentVM].codeData;
                    int newStackBase = this.stackBase;
                    this.stackBase = this.stack[this.esp - 3];
                    --this.callCount;
                    this.esp = newStackBase - 1;
                    this.funcBase = this.currentFunc * 3;
                    eipmax = functions[this.funcBase + 2];
                    continue block68;
                }
                case 38: {
                    if (this.callCount == 0) {
                        return;
                    }
                    int retValue = this.stack[this.esp];
                    this.eip = this.stack[this.esp - 1];
                    this.currentFunc = this.stack[this.esp - 2];
                    this.currentVM = this.stack[this.esp - 3];
                    functions = this.libraries[this.currentVM].functions;
                    codeData = this.libraries[this.currentVM].codeData;
                    int newStackBase = this.stackBase;
                    this.stackBase = this.stack[this.esp - 4];
                    --this.callCount;
                    this.esp = newStackBase;
                    this.stack[this.esp] = retValue;
                    this.funcBase = this.currentFunc * 3;
                    eipmax = functions[this.funcBase + 2];
                    continue block68;
                }
                case 39: 
                case 70: {
                    int ret;
                    boolean hasRet;
                    short callFunc = Tool.getShort(codeData, this.eip + 1);
                    int parCount = codeData[this.eip + 3] & 0xFF;
                    boolean bl = hasRet = codeData[this.eip + 4] == 1;
                    if (this.syscallParams.length < parCount) {
                        this.syscallParams = new int[parCount];
                    }
                    System.arraycopy(this.stack, this.esp - parCount + 1, this.syscallParams, 0, parCount);
                    this.esp -= parCount;
                    try {
                        ret = this.syscall(callFunc, this.syscallParams);
                    }
                    catch (Throwable e) {
                        ret = 0;
                    }
                    if (!hasRet) break;
                    if (inst == 70) {
                        this.stack[this.stackBase + Tool.getInt((byte[])codeData, (int)(this.eip + 5))] = ret;
                        break;
                    }
                    this.stack[this.esp + 1] = ret;
                    ++this.esp;
                    break;
                }
                case 44: {
                    int off;
                    int first = Tool.getInt(codeData, this.eip + 3);
                    int last = Tool.getInt(codeData, this.eip + 7);
                    int cond = this.stack[this.esp];
                    int instLen = 11 + 2 * (last - first + 1);
                    this.eip = cond >= first && cond <= last ? ((off = Tool.getShort(codeData, this.eip + 11 + (cond - first) * 2) & 0xFFFF) == 65535 ? (this.eip += Tool.getShort(codeData, this.eip + 1) & 0xFFFF) : (this.eip += off)) : (this.eip += Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    this.eip += instLen;
                    break;
                }
                case 45: {
                    short switchCount = Tool.getShort(codeData, this.eip + 3);
                    byte condBytes = codeData[this.eip + 5];
                    int cond = this.stack[this.esp];
                    int instLen = 6 + switchCount * (condBytes + 2);
                    int addr = this.searchTable(codeData, this.eip + 6, switchCount, condBytes, cond);
                    this.eip = addr >= 0 ? (this.eip += addr) : (this.eip += Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    this.eip += instLen;
                    break;
                }
                case 49: {
                    this.stack[this.esp] = this.memLoad(this.stack[this.esp]);
                    break;
                }
                case 50: {
                    this.memSave(this.stack[this.esp], this.stack[this.esp - 1]);
                    break;
                }
                case 61: {
                    this.stack[this.esp + 1] = this.staticHeap[Tool.getInt(codeData, this.eip + 1)];
                    break;
                }
                case 62: {
                    this.staticHeap[Tool.getInt((byte[])codeData, (int)(this.eip + 1))] = this.stack[this.esp];
                    if (this.ownerType != 2) break;
                    Tool.sendSyncVMVarialbe(((Quest)this.owner).id, Tool.getInt(codeData, this.eip + 1), this.stack[this.esp]);
                    break;
                }
                case 27: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    break;
                }
                case 28: {
                    this.stack[this.stackBase + Tool.getInt((byte[])codeData, (int)(this.eip + 1))] = this.stack[this.esp];
                    break;
                }
                case 29: {
                    this.stack[this.esp + 1] = this.stack[this.esp - codeData[this.eip + 1]];
                    break;
                }
                case 53: {
                    this.stack[this.esp + 1] = codeData[this.eip + 1];
                    break;
                }
                case 52: {
                    this.stack[this.esp + 1] = Tool.getShort(codeData, this.eip + 1);
                    break;
                }
                case 51: {
                    this.stack[this.esp + 1] = Tool.getInt(codeData, this.eip + 1);
                    break;
                }
                case 54: {
                    this.stack[this.esp - 1] = this.arrLoad(this.stack[this.esp - 1], this.stack[this.esp]);
                    break;
                }
                case 55: {
                    this.arrSave(this.stack[this.esp - 1], this.stack[this.esp], this.stack[this.esp - 2]);
                    break;
                }
                case 40: {
                    this.stack[this.esp] = this.arrLoad(this.stack[this.esp], codeData[this.eip + 1]);
                    break;
                }
                case 41: {
                    this.arrSave(this.stack[this.esp], codeData[this.eip + 1], this.stack[this.esp - 1]);
                    break;
                }
                case 56: {
                    this.stack[this.esp] = this.alloc(codeData[this.eip + 1], this.stack[this.esp]);
                    break;
                }
                case 57: {
                    this.free(this.stack[this.esp]);
                    break;
                }
                case 58: {
                    this.stack[this.esp + 1] = this.makeTempObject(new int[Tool.getShort(codeData, this.eip + 1)]);
                    break;
                }
                case 59: {
                    int[] arr = (int[])this.followPointer(this.stack[this.esp - 1]);
                    this.stack[this.esp - 1] = arr[this.stack[this.esp] & 0x3FFFFFFF];
                    break;
                }
                case 60: {
                    int saveValue;
                    int[] arr = (int[])this.followPointer(this.stack[this.esp - 1]);
                    int memberAddr = this.stack[this.esp];
                    arr[memberAddr & 0x3FFFFFFF] = saveValue = this.stack[this.esp - 2];
                    break;
                }
                case 42: {
                    int[] arr = (int[])this.followPointer(this.stack[this.esp]);
                    this.stack[this.esp] = arr[codeData[this.eip + 1]];
                    break;
                }
                case 43: {
                    int saveValue;
                    int[] arr = (int[])this.followPointer(this.stack[this.esp]);
                    byte memberAddr = codeData[this.eip + 1];
                    arr[memberAddr & 0x3FFFFFFF] = saveValue = this.stack[this.esp - 1];
                    break;
                }
                case 63: {
                    short funcID = Tool.getShort(codeData, this.eip + 1);
                    if (this.currentVM != 0) {
                        int callVM = (funcID & 0xF000) >> 12;
                        VM nextVM = this.libraries[this.currentVM].libraries[callVM];
                        for (int i = 0; i < this.libraries.length; ++i) {
                            if (nextVM != this.libraries[i]) continue;
                            callVM = i;
                            break;
                        }
                        funcID = (short)(funcID & 0xFFF | callVM << 12);
                    }
                    this.stack[this.esp + 1] = funcID;
                    break;
                }
                case 65: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp + 2] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 5)];
                    this.stack[this.esp + 3] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 9)];
                    break;
                }
                case 66: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp + 2] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 5)];
                    break;
                }
                case 67: {
                    this.stack[this.esp + 1] = codeData[this.eip + 1];
                    this.stack[this.esp + 2] = codeData[this.eip + 2];
                    break;
                }
                case 68: {
                    this.stack[this.esp + 1] = codeData[this.eip + 1];
                    this.stack[this.esp + 2] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 2)];
                    break;
                }
                case 69: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp + 2] = codeData[this.eip + 5];
                    break;
                }
                case 71: {
                    int ptr = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    int[] arr = (int[])this.followPointer(ptr);
                    this.stack[this.esp + 1] = arr[codeData[this.eip + 5]];
                    break;
                }
                case 72: {
                    this.stack[this.esp + 1] = codeData[this.eip + 1];
                    int ptr = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 2)];
                    int[] arr = (int[])this.followPointer(ptr);
                    this.stack[this.esp + 2] = arr[codeData[this.eip + 6]];
                    break;
                }
                case 73: {
                    int value = this.stack[this.esp] + this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp - 1] = this.arrLoad(this.stack[this.esp - 1], value);
                    break;
                }
                case 74: {
                    int value = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp] = this.arrLoad(this.stack[this.esp], value);
                    break;
                }
            }
            this.esp += STACK_EFFECT[inst & 0xFF];
            this.eip += INSTRUCTION_LENGTH[inst & 0xFF];
        }
    }

    public synchronized void execute(int funcID) {
        this.execute(funcID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(int funcID, int[] params) {
        if (this.running) {
            return;
        }
        try {
            this.running = true;
            if (this.resumeFlag && funcID == 3) {
                this.resumeFlag = false;
                this.resume();
            } else if (!this.blocked || funcID != 3) {
                this.currentVM = funcID >> 12 & 0xF;
                this.currentFunc = funcID & 0xFFF;
                this.funcBase = this.currentFunc * 3;
                int paramCount = 0;
                if (params != null) {
                    System.arraycopy(params, 0, this.stack, 0, params.length);
                    paramCount += params.length;
                }
                int lcount = this.libraries[this.currentVM].functions[this.funcBase] & 0xFFFF;
                this.esp = -1 + lcount + paramCount;
                this.stackBase = 0;
                this.callCount = 0;
                for (int i = 0; i < lcount; ++i) {
                    this.stack[i + paramCount] = 0;
                }
                this.eip = this.libraries[this.currentVM].functions[this.funcBase + 1];
                this.processInst(this.blocked);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.running = false;
        }
    }

    public synchronized int callback(String funcName, int[] params) {
        int funcId = -1;
        for (int i = 0; i < this.libraries.length; ++i) {
            Short obj = (Short)this.libraries[i].callbacks.get(funcName);
            if (obj == null) continue;
            funcId = (i << 12) + obj;
        }
        if (funcId != -1) {
            return this.callback(funcId, params);
        }
        return 0;
    }

    public synchronized int callback(int funcId, int[] params) {
        try {
            if (!this.running) {
                this.execute(funcId, params);
                if (this.esp < 0) {
                    return 0;
                }
                return this.stack[this.esp];
            }
            int[] oldStack = this.saveStack();
            this.running = false;
            this.execute(funcId, params);
            int ret = 0;
            if (this.esp >= 0) {
                ret = this.stack[this.esp];
            }
            this.restoreStack(oldStack);
            this.running = true;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getRealizeAdrr(int objAdrr) {
        int ret = 0;
        try {
            boolean isTemp;
            Object obj = this.followPointer(objAdrr);
            if (obj == null) {
                return 0;
            }
            boolean bl = isTemp = (objAdrr & Integer.MIN_VALUE) == 0 && (objAdrr & 0xFFF) < this.tempSpace;
            if (isTemp) {
                this.dynamicHeap[objAdrr & 0xFFF] = null;
            }
            int newaddr = this.heapAlloc();
            this.dynamicHeap[newaddr] = obj;
            return objAdrr & 0xFFFFF000 | newaddr;
        }
        catch (Exception exception) {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int syscall2(short funcID, int[] params) throws Exception {
        switch (funcID) {
            case 1: {
                return this.KeyPressed((byte)params[0], (byte)params[1]) ? 1 : 0;
            }
            case 2: {
                return this.NoKeyPressed() ? 1 : 0;
            }
            case 3: {
                return VM.getNextRnd(0, 10000);
            }
            case 4: {
                return Utilities.getTimeStamp();
            }
            case 5: {
                try {
                    String str = (String)this.followPointer(params[0]);
                    if (str.startsWith("u")) {
                        return Integer.parseInt(str.substring(1), 16);
                    }
                    return Integer.parseInt(str);
                }
                catch (Exception e) {
                    return 0;
                }
            }
            case 14: {
                return this.followPointer(params[0]) == null ? 1 : 0;
            }
            case 15: {
                return this.makeTempObject(String.valueOf(params[0]));
            }
            case 16: {
                boolean isTemp;
                Object obj = this.followPointer(params[0]);
                if (obj == null) {
                    return 0;
                }
                boolean bl = isTemp = (params[0] & Integer.MIN_VALUE) == 0 && (params[0] & 0xFFF) < this.tempSpace;
                if (isTemp) {
                    this.dynamicHeap[params[0] & 0xFFF] = null;
                }
                int newaddr = this.heapAlloc();
                this.dynamicHeap[newaddr] = obj;
                return params[0] & 0xFFFFF000 | newaddr;
            }
            case 17: {
                Object g = this.followPointer(params[0]);
                ((Graphics)g).fillRect(params[1], params[2], params[3], params[4]);
                break;
            }
            case 18: {
                VM.DrawString((Graphics)this.followPointer(params[0]), (String)this.followPointer(params[1]), params[2], params[3], params[4]);
                break;
            }
            case 19: {
                Object g = this.followPointer(params[0]);
                ((Graphics)g).setColor(params[1]);
                break;
            }
            case 20: {
                this.DrawRect((Graphics)this.followPointer(params[0]), params[1], params[2], params[3], params[4]);
                break;
            }
            case 21: {
                Object obj = this.followPointer(params[0]);
                if (!(obj instanceof Graphics)) break;
                this.SetClip((Graphics)obj, params[1], params[2], params[3], params[4]);
                break;
            }
            case 22: {
                return this.GetScreenWidth();
            }
            case 23: {
                return this.GetScreenHeight();
            }
            case 24: {
                ((Graphics)this.followPointer(params[0])).drawRoundRect(params[1], params[2], params[3], params[4], params[5], params[6]);
                break;
            }
            case 25: {
                return this.makeTempObject(Utilities.graphics);
            }
            case 26: {
                Image ret = Image.createImage((int)params[0], (int)params[1]);
                return this.makeTempObject(ret);
            }
            case 27: {
                Object img = this.followPointer(params[0]);
                return this.makeTempObject(((Image)img).getGraphics());
            }
            case 28: {
                return Utilities.CHAR_HEIGHT;
            }
            case 29: {
                return Utilities.font.stringWidth((String)this.followPointer(params[0]));
            }
            case 30: {
                Object img = this.followPointer(params[1]);
                ((Graphics)this.followPointer(params[0])).drawImage((Image)img, params[2], params[3], params[4]);
                break;
            }
            case 31: {
                String str = (String)this.followPointer(params[0]);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeUTF(str);
                dos.flush();
                byte[] buf = bos.toByteArray();
                byte[] ret = new byte[buf.length - 2];
                System.arraycopy(buf, 2, ret, 0, buf.length - 2);
                return this.makeTempObject(ret);
            }
            case 32: {
                return Utilities.LINE_HEIGHT;
            }
            case 33: {
                return this.makeTempObject(this.followPointer(params[0]));
            }
            case 34: {
                return this.makeTempObject((String)this.followPointer(params[0]) + (String)this.followPointer(params[1]));
            }
            case 35: {
                return ((String)this.followPointer(params[0])).length();
            }
            case 36: {
                return this.makeTempObject(((String)this.followPointer(params[0])).substring(params[1], params[1] + params[2]));
            }
            case 37: {
                return ((String)this.followPointer(params[0])).indexOf((String)this.followPointer(params[1]), params[2]);
            }
            case 38: {
                return this.makeTempObject((String)this.followPointer(params[0]) + params[1]);
            }
            case 39: {
                return ((String)this.followPointer(params[0])).equals(this.followPointer(params[1])) ? 1 : 0;
            }
            case 40: {
                return ((String)this.followPointer(params[0])).charAt(params[1]);
            }
            case 41: {
                return this.makeTempObject(((String)this.followPointer(params[0])).trim());
            }
            case 42: {
                return this.makeTempObject(new String((byte[])this.followPointer(params[0]), (String)this.followPointer(params[1])));
            }
            case 43: {
                String str = (String)this.followPointer(params[0]);
                char src = ((String)this.followPointer(params[1])).charAt(0);
                char dest = ((String)this.followPointer(params[2])).charAt(0);
                return this.makeTempObject(str.replace(src, dest));
            }
            case 44: {
                String str = (String)this.followPointer(params[0]);
                return this.makeTempObject(str + (char)params[1]);
            }
            case 45: {
                String str = (String)this.followPointer(params[0]);
                return this.makeTempObject(str.substring(0, params[1]) + (String)this.followPointer(params[2]) + str.substring(params[1], str.length()));
            }
            case 46: {
                String str = (String)this.followPointer(params[0]);
                return str.startsWith((String)this.followPointer(params[1])) ? 1 : 0;
            }
            case 47: {
                return this.makeTempObject(Tool.mergeString((Vector)this.followPointer(params[0])));
            }
            case 48: {
                String str = (String)this.followPointer(params[0]);
                return str.endsWith((String)this.followPointer(params[1])) ? 1 : 0;
            }
            case 49: {
                Object[] objs = (Object[])this.followPointer(params[0]);
                ImageSet[] imgs = new ImageSet[objs.length];
                System.arraycopy(objs, 0, imgs, 0, objs.length);
                String ctnFile = (String)this.followPointer(params[1]);
                PipAnimateSet ani = new PipAnimateSet(imgs, GameMain.resourceManager.findResource(ctnFile));
                ani.fileName = ctnFile;
                return this.makeTempObject(ani);
            }
            case 50: {
                ((PipAnimateSet)this.followPointer(params[0])).drawFrame((Graphics)this.followPointer(params[1]), params[2], params[3], params[4]);
                break;
            }
            case 51: {
                ((PipAnimateSet)this.followPointer(params[0])).drawAnimateFrame((Graphics)this.followPointer(params[1]), params[2], params[3], params[4], params[5]);
                break;
            }
            case 52: {
                return ((PipAnimateSet)this.followPointer(params[0])).getAnimateLength(params[1]);
            }
            case 53: {
                Object[] objs = (Object[])this.followPointer(params[0]);
                ImageSet[] imgs = new ImageSet[objs.length];
                System.arraycopy(objs, 0, imgs, 0, objs.length);
                byte[] datas = (byte[])this.followPointer(params[1]);
                return this.makeTempObject(new PipAnimateSet(imgs, datas));
            }
            case 54: {
                int[] tmp = new int[4];
                return this.makeTempObject(((PipAnimateSet)this.followPointer(params[0])).getAnimateBox(tmp, params[1]));
            }
            case 65: {
                try {
                    String fileName = (String)this.followPointer(params[0]);
                    ImageSet ret = new ImageSet(fileName);
                    ret.fileName = fileName;
                    if (ret.pipImg != null) {
                        ret.pipImg.fileName = fileName;
                    }
                    return this.makeTempObject(ret);
                }
                catch (Exception e) {
                    return 0;
                }
            }
            case 66: {
                try {
                    return this.makeTempObject(new ImageSet((String)this.followPointer(params[0]), params[1], params[2]));
                }
                catch (Exception e) {
                    return 0;
                }
            }
            case 67: {
                try {
                    String fileName = (String)this.followPointer(params[0]);
                    ImageSet ret = new ImageSet(fileName);
                    ret.fileName = fileName;
                    return this.makeTempObject(ret);
                }
                catch (Exception e) {
                    return 0;
                }
            }
            case 68: {
                try {
                    ImageSet ret = new ImageSet((byte[])this.followPointer(params[0]));
                    return this.makeTempObject(ret);
                }
                catch (Exception e) {
                    return 0;
                }
            }
            case 69: {
                Object img = this.followPointer(params[0]);
                ((ImageSet)img).drawFrame((Graphics)this.followPointer(params[1]), params[2], params[3], params[4], 0, params[5]);
                break;
            }
            case 70: {
                Object img = this.followPointer(params[0]);
                return ((ImageSet)img).getFrameWidth(params[1]);
            }
            case 71: {
                Object img = this.followPointer(params[0]);
                return ((ImageSet)img).getFrameHeight(params[1]);
            }
            case 72: {
                ImageSet img = (ImageSet)this.followPointer(params[0]);
                if (img.pipImg == null) break;
                img.pipImg.gray();
                break;
            }
            case 73: {
                ImageSet img = (ImageSet)this.followPointer(params[0]);
                if (img.pipImg == null) break;
                img.pipImg.lighter(params[1]);
                break;
            }
            case 74: {
                ImageSet img = (ImageSet)this.followPointer(params[0]);
                if (img.pipImg == null) break;
                img.pipImg.darker(params[1]);
                break;
            }
            case 75: {
                ImageSet img = (ImageSet)this.followPointer(params[0]);
                if (img.pipImg == null) break;
                img.pipImg.mask(params[1]);
                break;
            }
            case 76: {
                ((ImageSet)this.followPointer(params[0])).drawFrame((Graphics)this.followPointer(params[1]), params[2], params[3], params[4], params[5], params[6]);
                break;
            }
            case 79: {
                return ((DataInputStream)this.followPointer(params[0])).readUnsignedByte();
            }
            case 80: {
                return ((DataInputStream)this.followPointer(params[0])).readUnsignedShort();
            }
            case 81: {
                return this.makeTempObject(new DataInputStream(new ByteArrayInputStream((byte[])this.followPointer(params[0]))));
            }
            case 82: {
                return this.makeTempObject(new ByteArrayOutputStream());
            }
            case 83: {
                return ((DataInputStream)this.followPointer(params[0])).readInt();
            }
            case 84: {
                return ((DataInputStream)this.followPointer(params[0])).readShort();
            }
            case 85: {
                return ((DataInputStream)this.followPointer(params[0])).readByte();
            }
            case 86: {
                return ((DataInputStream)this.followPointer(params[0])).readBoolean() ? 1 : 0;
            }
            case 87: {
                return this.makeTempObject(((DataInputStream)this.followPointer(params[0])).readUTF());
            }
            case 88: {
                new DataOutputStream((ByteArrayOutputStream)this.followPointer(params[0])).writeInt(params[1]);
                break;
            }
            case 89: {
                new DataOutputStream((ByteArrayOutputStream)this.followPointer(params[0])).writeShort((short)params[1]);
                break;
            }
            case 90: {
                new DataOutputStream((ByteArrayOutputStream)this.followPointer(params[0])).writeUTF((String)this.followPointer(params[1]));
                break;
            }
            case 91: {
                new DataOutputStream((ByteArrayOutputStream)this.followPointer(params[0])).writeByte((byte)params[1]);
                break;
            }
            case 92: {
                new DataOutputStream((ByteArrayOutputStream)this.followPointer(params[0])).writeBoolean(params[1] != 0);
                break;
            }
            case 93: {
                return ((ByteArrayOutputStream)this.followPointer(params[0])).size();
            }
            case 94: {
                return this.makeTempObject(((ByteArrayOutputStream)this.followPointer(params[0])).toByteArray());
            }
            case 95: {
                ((DataInputStream)this.followPointer(params[0])).readFully((byte[])this.followPointer(params[1]));
                break;
            }
            case 96: {
                new DataOutputStream((ByteArrayOutputStream)this.followPointer(params[0])).write((byte[])this.followPointer(params[1]));
                break;
            }
            case 97: {
                Form form = new Form((String)this.followPointer(params[0]));
                form.setCommandListener((CommandListener)this);
                return this.makeTempObject(form);
            }
            case 98: {
                Form form = (Form)this.followPointer(params[0]);
                String name = (String)this.followPointer(params[1]);
                String value = (String)this.followPointer(params[2]);
                form.append((Item)new TextField(name, value, params[3], params[4]));
                break;
            }
            case 99: {
                Form form = (Form)this.followPointer(params[0]);
                String text = (String)this.followPointer(params[1]);
                Command cmd = new Command(text, params[2], params[3]);
                form.addCommand(cmd);
                break;
            }
            case 100: {
                Form form = (Form)this.followPointer(params[0]);
                GameMain.display.setCurrent((Displayable)form);
                break;
            }
            case 101: {
                Form form = (Form)this.followPointer(params[0]);
                String txt = ((TextField)form.get(params[1])).getString();
                if (txt == null) {
                    txt = "";
                }
                return this.makeTempObject(txt);
            }
            case 102: {
                Form form = (Form)this.followPointer(params[0]);
                TextField tf = (TextField)form.get(params[1]);
                String txt = (String)this.followPointer(params[2]);
                if (txt == null) break;
                tf.setString(txt);
                break;
            }
            case 103: {
                return this.makeTempObject(this.lastFormSelection);
            }
            case 104: {
                Form form = (Form)this.followPointer(params[0]);
                String label = (String)this.followPointer(params[1]);
                String[] choices = (String[])this.followPointer(params[3]);
                ChoiceGroup cg = new ChoiceGroup(label, params[2], choices, null);
                form.append((Item)cg);
                break;
            }
            case 105: {
                Form form = (Form)this.followPointer(params[0]);
                ChoiceGroup cg = (ChoiceGroup)form.get(params[1]);
                boolean[] flags = (boolean[])this.followPointer(params[2]);
                cg.setSelectedFlags(flags);
                break;
            }
            case 106: {
                Form form = (Form)this.followPointer(params[0]);
                ChoiceGroup cg = (ChoiceGroup)form.get(params[1]);
                boolean[] flags = new boolean[cg.size()];
                cg.getSelectedFlags(flags);
                return this.makeTempObject(flags);
            }
            case 107: {
                Form form = (Form)this.followPointer(params[0]);
                String label = (String)this.followPointer(params[2]);
                String text = (String)this.followPointer(params[3]);
                form.insert(params[1], (Item)new StringItem(label, text));
                break;
            }
            case 108: {
                Alert alert = new Alert((String)this.followPointer(params[0]), (String)this.followPointer(params[1]), null, AlertType.INFO);
                alert.setTimeout(params[2]);
                alert.setCommandListener((CommandListener)this);
                alert.addCommand(new Command("\u786e\u8ba4", 4, 0));
                GameMain.display.setCurrent((Displayable)alert);
                break;
            }
            case 112: {
                Form form = (Form)this.followPointer(params[0]);
                TextField tf = (TextField)form.get(params[1]);
                return tf.getCaretPosition();
            }
            case 113: {
                return this.makeTempObject(new UASegment((short)params[0], params[1] == 1));
            }
            case 114: {
                return ((UASegment)this.followPointer((int)params[0])).type;
            }
            case 115: {
                ((UASegment)this.followPointer(params[0])).reset();
                break;
            }
            case 116: {
                return ((UASegment)this.followPointer(params[0])).readInt();
            }
            case 117: {
                return ((UASegment)this.followPointer(params[0])).readShort();
            }
            case 118: {
                return ((UASegment)this.followPointer(params[0])).readByte();
            }
            case 119: {
                return ((UASegment)this.followPointer(params[0])).readBoolean() ? 1 : 0;
            }
            case 120: {
                return this.makeTempObject(((UASegment)this.followPointer(params[0])).readString());
            }
            case 121: {
                ((UASegment)this.followPointer(params[0])).writeInt(params[1]);
                break;
            }
            case 122: {
                ((UASegment)this.followPointer(params[0])).writeShort((short)params[1]);
                break;
            }
            case 123: {
                ((UASegment)this.followPointer(params[0])).writeString((String)this.followPointer(params[1]));
                break;
            }
            case 124: {
                ((UASegment)this.followPointer(params[0])).writeByte((byte)params[1]);
                break;
            }
            case 125: {
                ((UASegment)this.followPointer(params[0])).writeBoolean(params[1] != 0);
                break;
            }
            case 126: {
                return this.makeTempObject(((UASegment)this.followPointer(params[0])).readInts());
            }
            case 127: {
                return this.makeTempObject(((UASegment)this.followPointer(params[0])).readShorts());
            }
            case 128: {
                return this.makeTempObject(((UASegment)this.followPointer(params[0])).readBytes());
            }
            case 129: {
                return this.makeTempObject(((UASegment)this.followPointer(params[0])).readBooleans());
            }
            case 130: {
                return this.makeTempObject(((UASegment)this.followPointer(params[0])).readStrings());
            }
            case 131: {
                ((UASegment)this.followPointer(params[0])).writeInts((int[])this.followPointer(params[1]));
                break;
            }
            case 132: {
                ((UASegment)this.followPointer(params[0])).writeShorts((short[])this.followPointer(params[1]));
                break;
            }
            case 133: {
                Object[] tmp1 = (Object[])this.followPointer(params[1]);
                String[] tmp2 = new String[tmp1.length];
                System.arraycopy(tmp1, 0, tmp2, 0, tmp1.length);
                ((UASegment)this.followPointer(params[0])).writeStrings(tmp2);
                break;
            }
            case 134: {
                ((UASegment)this.followPointer(params[0])).writeBooleans((boolean[])this.followPointer(params[1]));
                break;
            }
            case 135: {
                ((UASegment)this.followPointer(params[0])).writeBytes((byte[])this.followPointer(params[1]));
                break;
            }
            case 136: {
                UASegment seg = (UASegment)this.followPointer(params[0]);
                seg.flush();
                return Utilities.sendRequest(seg);
            }
            case 137: {
                return this.makeTempObject(GameMain.instance.nextPacket);
            }
            case 138: {
                ((UASegment)this.followPointer((int)params[0])).handled = params[1] == 1;
                break;
            }
            case 139: {
                UASegment segment = (UASegment)this.followPointer(params[0]);
                segment.flush();
                Utilities.segments.addElement(segment);
                break;
            }
            case 140: {
                return ((UASegment)this.followPointer((int)params[0])).serial;
            }
            case 141: {
                ((UASegment)this.followPointer((int)params[0])).needResponse = params[1] == 1;
                break;
            }
            case 142: {
                return ((UASegment)this.followPointer(params[0])).readUnsignedByte();
            }
            case 143: {
                return ((UASegment)this.followPointer(params[0])).readUnsignedShort();
            }
            case 145: {
                return this.makeTempObject(new Vector());
            }
            case 146: {
                return ((Vector)this.followPointer(params[0])).size();
            }
            case 147: {
                ((Vector)this.followPointer(params[0])).addElement(this.followPointer(params[1]));
                break;
            }
            case 148: {
                ((Vector)this.followPointer(params[0])).removeElementAt(params[1]);
                break;
            }
            case 149: {
                return this.makeTempObject(((Vector)this.followPointer(params[0])).elementAt(params[1]));
            }
            case 150: {
                Vector v = (Vector)this.followPointer(params[0]);
                if (v == null) break;
                ((Vector)this.followPointer(params[0])).removeAllElements();
                break;
            }
            case 151: {
                ((Vector)this.followPointer(params[0])).insertElementAt(this.followPointer(params[1]), params[2]);
                break;
            }
            case 152: {
                Vector vec = (Vector)this.followPointer(params[0]);
                if (vec != null) {
                    Object[] objs2 = new Object[vec.size()];
                    for (int i = 0; i < objs2.length; ++i) {
                        objs2[i] = vec.elementAt(i);
                    }
                    return this.makeTempObject(objs2);
                }
                return this.makeTempObject(null);
            }
            case 160: {
                ((SortHashtable)this.followPointer(params[0])).clear();
                break;
            }
            case 161: {
                return this.makeTempObject(new SortHashtable());
            }
            case 162: {
                ((SortHashtable)this.followPointer(params[0])).put(this.followPointer(params[1]), this.followPointer(params[2]));
                break;
            }
            case 163: {
                return this.makeTempObject(((SortHashtable)this.followPointer(params[0])).get(this.followPointer(params[1])));
            }
            case 164: {
                ((SortHashtable)this.followPointer(params[0])).remove(this.followPointer(params[1]));
                break;
            }
            case 165: {
                SortHashtable tbl = (SortHashtable)this.followPointer(params[0]);
                return this.makeTempObject(tbl.keys());
            }
            case 166: {
                SortHashtable tbl = (SortHashtable)this.followPointer(params[0]);
                return this.makeTempObject(tbl.values());
            }
            case 167: {
                return ((SortHashtable)this.followPointer(params[0])).size();
            }
            case 168: {
                return this.makeTempObject(((SortHashtable)this.followPointer(params[0])).getKey(params[1]));
            }
            case 169: {
                return this.makeTempObject(((SortHashtable)this.followPointer(params[0])).getValue(params[1]));
            }
            case 177: {
                System.out.println(params[0]);
                break;
            }
            case 178: {
                System.out.println(this.followPointer(params[0]).toString());
                break;
            }
            case 179: {
                return this.makeTempObject(new Integer(params[0]));
            }
            case 180: {
                return GameWorld.player.getId();
            }
            case 181: {
                return this.makeTempObject(GameWorld.player.getName());
            }
            case 182: {
                return GameWorld.player.level;
            }
            case 183: {
                for (int i = this.tempSpace - 1; i >= 0; --i) {
                    this.dynamicHeap[i] = null;
                }
                System.gc();
                break;
            }
            case 184: {
                return this.makeTempObject(GameWorld.player);
            }
            case 185: {
                return this.makeTempObject(GameWorld.instance.readGameData("game_role_infor"));
            }
            case 194: {
                return this.Length(this.followPointer(params[0]));
            }
            case 195: {
                return (Integer)this.followPointer(params[0]);
            }
            case 197: {
                return this.makeTempObject(this.LoadFile((String)this.followPointer(params[0])));
            }
            case 199: {
                return this.makeTempObject(Tool.formatText((String)this.followPointer(params[0]), params[1], Utilities.font));
            }
            case 206: {
                Tool.fillAlphaRect((Graphics)this.followPointer(params[0]), params[1], params[2], params[3], params[4], params[5]);
                break;
            }
            case 207: {
                Utilities.clearKeyStates();
                break;
            }
            case 208: {
                return this.makeTempObject(VM.loadRMSFile((String)this.followPointer(params[0])));
            }
            case 209: {
                return VM.saveRMSFile((String)this.followPointer(params[0]), (byte[])this.followPointer(params[1])) ? 1 : 0;
            }
            case 210: {
                this.deleteRMSFile((String)this.followPointer(params[0]));
                break;
            }
            case 224: {
                return Utilities.multiKeyCheck((int[])this.followPointer(params[0]), params[1] == 1);
            }
            case 4096: {
                Tool.deleteGlobalVar((String)this.followPointer(params[0]));
                break;
            }
            case 4097: {
                Tool.setGlobalValue((String)this.followPointer(params[0]), params[1]);
                break;
            }
            case 4098: {
                Tool.setGlobalValue((String)this.followPointer(params[0]), (String)this.followPointer(params[1]));
                break;
            }
            case 4099: {
                return Tool.getGlobalInt((String)this.followPointer(params[0]));
            }
            case 4100: {
                return this.makeTempObject(Tool.getGlobalString((String)this.followPointer(params[0])));
            }
            case 4101: {
                return this.makeTempObject(Tool.getGlobalObject((String)this.followPointer(params[0])));
            }
            case 4102: {
                Tool.setGlobalValue((String)this.followPointer(params[0]), this.followPointer(params[1]));
                break;
            }
            case 4104: {
                return this.makeTempObject(System.getProperty((String)this.followPointer(params[0])));
            }
            case 4105: {
                return this.makeTempObject(SanguoMIDlet.instance.getAppProperty((String)this.followPointer(params[0])));
            }
            case 4352: {
                ((VMGame)this.owner).setCatchInput(params[0] == 1);
                break;
            }
            case 4353: {
                ((VMGame)this.owner).setTransparent(params[0] == 1);
                break;
            }
            case 4354: {
                ((VMGame)this.owner).close();
                break;
            }
            case 4355: {
                return this.makeTempObject(((VMGame)this.followPointer(params[0])).getVMId());
            }
            case 4356: {
                ((VMGame)this.owner).setSingleton(params[0] == 1);
                break;
            }
            case 4360: {
                return ((VMGame)this.followPointer(params[0])).getSingleton() ? 1 : 0;
            }
            case 4357: {
                return this.makeTempObject(VMGame.getVMGameByVMKey(params[0]));
            }
            case 4358: {
                return this.makeTempObject(VMGame.getVMGame((String)this.followPointer(params[0])));
            }
            case 4359: {
                int gameEventKey = 0;
                VMGame gvm = VMGame.getVMGameByVMKey(VMGame.gameWorldVMGameKey);
                if (gvm != null) {
                    VM vm;
                    VM vM = vm = gvm.getVM();
                    synchronized (vM) {
                        gameEventKey = vm.callback("GameWorldAddGameEvent", new int[]{vm.makeTempObject((String)this.followPointer(params[0])), params[1], vm.makeTempObject(this.followPointer(params[2]))});
                    }
                }
                return gameEventKey;
            }
            case 4103: {
                int vmGameKey = 0;
                VMGame gvm2 = VMGame.getVMGameByVMKey(VMGame.gameWorldVMGameKey);
                if (gvm2 != null) {
                    VM vm;
                    VM vM = vm = gvm2.getVM();
                    synchronized (vM) {
                        vmGameKey = vm.callback("GameWorldGetVMGame", new int[]{params[0]});
                    }
                }
                return vmGameKey;
            }
            case 4361: {
                return VMGame.getCommonKey();
            }
            case 4362: {
                return VMGame.loadVMGame((String)this.followPointer(params[0]), (byte)1, params[1] == 1);
            }
            case 4363: {
                VMGame.closeAllUI((VMGame)this.owner, params[0]);
                break;
            }
            case 4364: {
                return Tool.distance(params[0], params[1], params[2], params[3]);
            }
            case 4365: {
                return this.makeTempObject(Quest.findQuest(params[0], true));
            }
            case 4608: {
                VMGame.loadVMGame((String)this.followPointer(params[0]), (byte)0, true);
                break;
            }
            case 4609: {
                VMGame.removeVMGame((String)this.followPointer(params[0]));
                break;
            }
            case 4610: {
                return this.makeTempObject(GameWorld.instance);
            }
            case 4611: {
                switch (params[0]) {
                    case -2: {
                        return this.makeTempObject(GameWorld.panel);
                    }
                    case -1: {
                        return this.makeTempObject(GameWorld.instance);
                    }
                    case 0: {
                        return this.makeTempObject(GameWorld.player);
                    }
                    case 100: {
                        return this.makeTempObject(GameWorld.gameIcons.get(new Integer(params[1])));
                    }
                    case -100: {
                        return this.makeTempObject(GameWorld.getSprite(params[1]));
                    }
                }
                return this.makeTempObject(GameWorld.getSprite(params[0], params[1]));
            }
            case 4613: {
                Object data = ((IVMGameProcessor)this.followPointer(params[0])).readGameData((String)this.followPointer(params[1]));
                if (data instanceof UASegment) {
                    UASegment segment = (UASegment)data;
                    segment.flush();
                    segment.reset();
                }
                return this.makeTempObject(data);
            }
            case 4614: {
                Object data = this.followPointer(params[2]);
                if (data instanceof UASegment) {
                    UASegment segment = (UASegment)data;
                    segment.flush();
                    segment.reset();
                }
                ((IVMGameProcessor)this.followPointer(params[0])).saveGameData((String)this.followPointer(params[1]), data);
                break;
            }
            case 4615: {
                ((IVMGameProcessor)this.followPointer(params[0])).removeGameData((String)this.followPointer(params[1]));
                break;
            }
            case 4616: {
                Hashtable data = globalVMData;
                synchronized (data) {
                    globalVMData.put(new Integer(globalVMDataCurrentKey), this.followPointer(params[0]));
                    return globalVMDataCurrentKey++;
                }
            }
            case 4617: {
                Hashtable data = globalVMData;
                synchronized (data) {
                    return this.makeTempObject(globalVMData.get(new Integer(params[0])));
                }
            }
            case 4618: {
                Hashtable data = globalVMData;
                synchronized (data) {
                    globalVMData.remove(new Integer(params[0]));
                    break;
                }
            }
            case 4619: {
                ((GameIcon)this.followPointer(params[0])).draw((Graphics)this.followPointer(params[1]), 0, 0);
                break;
            }
            case 4620: {
                Object worldData = GameWorld.instance.readGameData((String)this.followPointer(params[0]));
                if (worldData instanceof UASegment) {
                    UASegment segment = (UASegment)worldData;
                    segment.flush();
                    segment.reset();
                }
                return this.makeTempObject(worldData);
            }
            case 4622: {
                Tool.drawMixedText((Graphics)this.followPointer(params[0]), (String)this.followPointer(params[1]), params[2], params[3], params[4], 0, params[5] == 1, params[6]);
                break;
            }
            case 4623: {
                Tool.drawMixedText((Graphics)this.followPointer(params[0]), (String)this.followPointer(params[1]), params[2], params[3], params[4], params[5], true, params[6]);
                break;
            }
            case 4624: {
                return Tool.drawMixedText(null, (String)this.followPointer(params[0]), 0, 0, 0, 0, true, 0);
            }
            case 4625: {
                return this.makeTempObject(VMGame.getVMParam((String)this.followPointer(params[0])));
            }
            case 4626: {
                return VMGame.openUI((String)this.followPointer(params[0]), this.followPointer(params[1]));
            }
            case 4627: {
                ((VMGame)this.owner).addCommonCallback(1, (GWindow)this.getGW(params[0]), (String)this.followPointer(params[1]));
                break;
            }
            case 4628: {
                ((VMGame)this.owner).addCommonCallback(3, (GWindow)this.getGW(params[0]), (String)this.followPointer(params[1]));
                break;
            }
            case 4629: {
                ((VMGame)this.owner).addCommonCallback(4, (GWindow)this.getGW(params[0]), (String)this.followPointer(params[1]));
                break;
            }
            case 4630: {
                ((VMGame)this.owner).addCommonCallback(2, (GWindow)this.getGW(params[0]), (String)this.followPointer(params[1]));
                break;
            }
            case 4631: {
                ((VMGame)this.owner).removeCommonCallback(1, (GWindow)this.getGW(params[0]));
                break;
            }
            case 4632: {
                ((VMGame)this.owner).removeCommonCallback(3, (GWindow)this.getGW(params[0]));
                break;
            }
            case 4633: {
                ((VMGame)this.owner).removeCommonCallback(4, (GWindow)this.getGW(params[0]));
                break;
            }
            case 4640: {
                ((VMGame)this.owner).removeCommonCallback(2, (GWindow)this.getGW(params[0]));
                break;
            }
            case 4656: {
                return ((VMGame)this.owner).createWindow((int)params[0], (int[])((int[])this.followPointer((int)params[0])), (boolean)(params[1] == 1 ? true : false), (String)((String)this.followPointer((int)params[2]))).vmData[33];
            }
            case 4657: {
                ((VMGame)this.owner).vmDestroyWindow((GWindow)this.getGW(params[0]));
                break;
            }
            case 4658: {
                ((VMGame)this.owner).vmShowWindow((GWindow)this.getGW(params[0]));
                break;
            }
            case 4659: {
                return new GContainer((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4660: {
                ((VMGame)this.owner).vmContainerAdd((GContainer)this.getGW(params[0]), this.getGW(params[1]));
                break;
            }
            case 4661: {
                ((VMGame)this.owner).vmContainerDel((GContainer)this.getGW(params[0]), this.getGW(params[1]));
                break;
            }
            case 4662: {
                ((VMGame)this.owner).vmCloseWindow((GWindow)this.getGW(params[0]));
                break;
            }
            case 4663: {
                return new GWidget((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4664: {
                ((VMGame)this.owner).vmContainerInsert((GContainer)this.getGW(params[0]), this.getGW(params[1]), params[2]);
                break;
            }
            case 4665: {
                this.getGW(params[0]).setBounds(params[1], params[2], params[3], params[4]);
                break;
            }
            case 4666: {
                this.getGW(params[0]).setBorder(params[1], params[2], params[3], params[4]);
                break;
            }
            case 4667: {
                ((GContainer)this.getGW(params[0])).setLayoutMode(params[1], params[2], params[3], params[4], params[5], params[6]);
                break;
            }
            case 4668: {
                ((GContainer)this.getGW(params[0])).layout();
                break;
            }
            case 4669: {
                this.getGW(params[0]).setScale(params[1] == 1);
                break;
            }
            case 4670: {
                return new GLinePanel((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4671: {
                ((GLinePanel)this.getGW(params[0])).setData((int[])this.followPointer(params[1]), (String)this.followPointer(params[2]), params[3]);
                break;
            }
            case 4672: {
                GWidget gWidget = (GWidget)this.followPointer(params[0]);
                if (gWidget instanceof GContainer && ((GContainer)gWidget).isJavaPaint) {
                    ((GContainer)gWidget).paintContainer();
                    break;
                }
                if (!(gWidget instanceof IGPaint)) break;
                ((IGPaint)((Object)gWidget)).paint();
                break;
            }
            case 4673: {
                return new GIcon((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4674: {
                ((GIcon)this.getGW(params[0])).setData((int[])this.followPointer(params[1]), (String)this.followPointer(params[2]), params[3], params[4], params[5]);
                break;
            }
            case 4675: {
                return new GLabel((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4676: {
                ((GLabel)this.getGW(params[0])).setData((String)this.followPointer(params[1]), params[2] == 1, params[3], params[4], params[5]);
                break;
            }
            case 4677: {
                ((IGCycle)this.followPointer(params[0])).cycle();
                break;
            }
            case 4678: {
                ((GContainer)this.getGW(params[0])).clear();
                break;
            }
            case 4679: {
                GWidget gWidget3 = (GWidget)this.followPointer(params[0]);
                if (gWidget3 != null) {
                    return this.makeTempObject(gWidget3.vmData);
                }
                return 0;
            }
            case 4680: {
                ((GLabel)this.getGW(params[0])).setBack((int[])this.followPointer(params[1]), (String)this.followPointer(params[2]), params[3]);
                break;
            }
            case 4681: {
                return this.followPointer(params[0]) == this.followPointer(params[1]) ? 1 : 0;
            }
            case 4682: {
                this.getGW(params[0]).SetNeedLayout(params[1] == 1);
                break;
            }
            case 4683: {
                ((GWindow)this.getGW(params[0])).setFocus(this.getGW(params[1]));
                break;
            }
            case 4684: {
                GWindow _gParent = this.getGW(params[0]).getParentWindow();
                if (_gParent != null) {
                    return _gParent.vmData[33];
                }
                return 0;
            }
            case 4685: {
                return this.getGW(params[0]).isFocus() ? 1 : 0;
            }
            case 4686: {
                this.getGW(params[0]).setEnableFocus(params[1] == 1);
                break;
            }
            case 4687: {
                return this.makeTempObject(((GLabel)this.getGW(params[0])).getText());
            }
            case 4688: {
                ((GLabel)this.getGW(params[0])).setText((String)this.followPointer(params[1]));
                break;
            }
            case 4689: {
                ((IGCycle)((Object)this.getGW(params[0]))).setNeedExecuteCycle(params[1] == 1);
                break;
            }
            case 4690: {
                ((IGCycle)((Object)this.getGW(params[0]))).setSpeed(params[1]);
                break;
            }
            case 4691: {
                ((GLabel)this.getGW(params[0])).setIsMixStr(params[1] == 1);
                break;
            }
            case 4692: {
                ((GContainer)this.getGW(params[0])).addScrollBar((GScrollBar)this.getGW(params[1]));
                break;
            }
            case 4693: {
                this.getGW(params[0]).setPos(params[1], params[2]);
                break;
            }
            case 4694: {
                return new GScrollBar((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4695: {
                return ((GScrollBar)this.getGW(params[0])).getMaxScrollDis();
            }
            case 4696: {
                return ((GScrollBar)this.getGW(params[0])).getScrollPos();
            }
            case 4697: {
                return ((GScrollBar)this.getGW(params[0])).getTick();
            }
            case 4698: {
                GContainer parent = this.getGW((int)params[0]).parent;
                if (parent != null) {
                    return parent.vmData[33];
                }
                return 0;
            }
            case 4699: {
                ((GScrollBar)this.getGW(params[0])).setAlign(params[1]);
                break;
            }
            case 4700: {
                ((GContainer)this.getGW(params[0])).moveUp();
                break;
            }
            case 4701: {
                ((GContainer)this.getGW(params[0])).moveDown();
                break;
            }
            case 4702: {
                ((GContainer)this.getGW(params[0])).moveUpPage();
                break;
            }
            case 4703: {
                ((GTextArea)this.getGW(params[0])).setData((String)this.followPointer(params[1]), params[2], params[3] == 1);
                break;
            }
            case 4704: {
                ((GTextArea)this.getGW(params[0])).setText((String)this.followPointer(params[1]));
                break;
            }
            case 4705: {
                return this.makeTempObject(((GTextArea)this.getGW(params[0])).getText());
            }
            case 4706: {
                return new GTextArea((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4707: {
                return ((GTextArea)this.getGW(params[0])).testWidth();
            }
            case 4708: {
                return ((GTextArea)this.getGW(params[0])).testHeight(params[1]);
            }
            case 4709: {
                GContainer con = (GContainer)this.getGW(params[0]);
                if (con != null) {
                    return con.needScrollBar ? 1 : 0;
                }
                return 0;
            }
            case 4710: {
                ((GScrollBar)this.getGW(params[0])).setMaxScrollDis(params[1]);
                break;
            }
            case 4711: {
                ((GScrollBar)this.getGW(params[0])).setScrollPos(params[1]);
                break;
            }
            case 4712: {
                ((GContainer)this.getGW(params[0])).setIsJavaPaint(params[1] == 1);
                break;
            }
            case 4713: {
                ((GIcon)this.getGW(params[0])).setIconIndex(params[1]);
                break;
            }
            case 4714: {
                ((GIcon)this.getGW(params[0])).setNumberData((String)this.followPointer(params[1]), params[2], params[3], params[4], params[5]);
                break;
            }
            case 4715: {
                ((GIcon)this.getGW(params[0])).setNumber(params[1]);
                break;
            }
            case 4716: {
                ((GContainer)this.getGW(params[0])).setChildrenOffset(params[1], params[2]);
                break;
            }
            case 4717: {
                return ((GTextArea)this.getGW((int)params[0])).lineSpace;
            }
            case 4718: {
                this.getGW(params[0]).setGrid3Data(params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8]);
                break;
            }
            case 4719: {
                ((GContainer)this.getGW(params[0])).grid3Layout();
                break;
            }
            case 4720: {
                ((GContainer)this.getGW(params[0])).borderLayout();
                break;
            }
            case 4721: {
                ((GContainer)this.getGW(params[0])).toTop(params[1]);
                break;
            }
            case 4722: {
                if (GWindow.pressWidget != null) {
                    return this.makeTempObject(GWindow.pressWidget.vmData);
                }
                return 0;
            }
            case 4723: {
                return new GImageNumer((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4724: {
                ((GImageNumer)this.getGW(params[0])).setData((String)this.followPointer(params[1]), params[2] == 1, params[3], params[4], params[5], params[6]);
                break;
            }
            case 4725: {
                ((GImageNumer)this.getGW(params[0])).setNumer((String)this.followPointer(params[1]));
                break;
            }
            case 4726: {
                ((GIcon)this.getGW(params[0])).setMask(params[1] == 1, params[2]);
                break;
            }
            case 4727: {
                ((GIcon)this.getGW(params[0])).setBackColors((int[])this.followPointer(params[1]));
                break;
            }
            case 4728: {
                GWindow topWindow = VMGame.getTopGWindow();
                if (topWindow != null) {
                    return this.makeTempObject(topWindow.vmData);
                }
                return 0;
            }
            case 4729: {
                GWidget selWidget = VMGame.getPointerWidget((GWindow)this.getGW(params[0]), params[1], params[2]);
                if (selWidget != null) {
                    return this.makeTempObject(selWidget.vmData);
                }
                return 0;
            }
            case 4730: {
                GWidget selWidget2 = VMGame.getPointerWidget(params[0], params[1]);
                if (selWidget2 != null) {
                    return this.makeTempObject(selWidget2.vmData);
                }
                return 0;
            }
            case 4731: {
                GWindow.pressWidget = this.getGW(params[0]);
                break;
            }
            case 4732: {
                GWindow gwin = (GWindow)this.getGW(params[0]);
                if (gwin != null) {
                    return this.makeTempObject(gwin.getVMGame());
                }
                return 0;
            }
            case 4733: {
                VM gtvm = ((VMGame)this.followPointer(params[0])).getVM();
                GWidget _gWidget = this.getGW(params[1]);
                if (_gWidget == null || _gWidget.vmData[23] <= 0) break;
                VM vM = gtvm;
                synchronized (vM) {
                    gtvm.execute(_gWidget.vmData[23], new int[]{_gWidget.vmData[33], params[2], params[3], gtvm.makeTempObject(this.followPointer(params[4])), gtvm.makeTempObject(this.followPointer(params[5])), gtvm.makeTempObject(this.followPointer(params[6]))});
                    break;
                }
            }
            case 4734: {
                if (GWindow.pressWidget != null) {
                    return this.makeTempObject(GWindow.pressWidget);
                }
                return 0;
            }
            case 4735: {
                return Tool.rectIn(params[0], params[1], params[2], params[3], params[4], params[5]) ? 1 : 0;
            }
            case 4736: {
                return this.makeTempObject(((VMGame)this.followPointer(params[0])).getGWindows());
            }
            case 4737: {
                return ((GWindow)this.getGW((int)params[0])).isShow ? 0 : 1;
            }
            case 4738: {
                ((GTextArea)this.getGW(params[0])).setBack((int[])this.followPointer(params[1]), (String)this.followPointer(params[2]), params[3]);
                break;
            }
            case 4739: {
                ((GContainer)this.getGW(params[0])).setAbs();
                break;
            }
            case 4740: {
                return this.getGW(params[0]).getAbsX();
            }
            case 4741: {
                return this.getGW(params[0]).getAbsY();
            }
            case 4742: {
                ((GTextArea)this.getGW(params[0])).setLineSpace(params[1]);
                break;
            }
            case 4743: {
                ((GContainer)this.getGW((int)params[0])).isIntersectView = params[1] == 1;
                break;
            }
            case 4744: {
                this.getGW(params[0]).setPressXY(params[1], params[2]);
                break;
            }
            case 4745: {
                return this.getGW(params[0]).getPressX();
            }
            case 4746: {
                return this.getGW(params[0]).getPressY();
            }
            case 4747: {
                this.getGW(params[0]).move(params[1], params[2]);
                break;
            }
            case 4748: {
                return new GGameIcon((VMGame)((VMGame)this.owner), (int)params[0], (int[])((int[])this.followPointer((int)params[0])), (String)((String)this.followPointer((int)params[1]))).vmData[33];
            }
            case 4749: {
                ((GGameIcon)this.getGW(params[0])).setData1(params[1], params[2], params[3]);
                break;
            }
            case 4750: {
                ((GGameIcon)this.getGW(params[0])).setData2((GameSprite)this.followPointer(params[1]), params[2]);
                break;
            }
            case 4751: {
                return this.makeTempObject(((GGameIcon)this.getGW(params[0])).getGameIcon());
            }
            case 4752: {
                ((GGameIcon)this.getGW(params[0])).setShow(params[1] == 1);
                break;
            }
            case 4753: {
                return this.makeTempObject(((VMGame)this.followPointer(params[0])).getVM().followPointer(params[1]));
            }
            case 4754: {
                ((GWindow)this.getGW(params[0])).setReCreateStack();
                break;
            }
            case 4755: {
                ((GWindow)this.getGW((int)params[0])).isTransparent = params[1] == 1;
                break;
            }
            case 4756: {
                return GWindow.isDragging ? 1 : 0;
            }
            case 4757: {
                GWindow.isDragging = params[0] == 1;
                break;
            }
            case 4758: {
                return Tool.rectIntersect(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]) ? 1 : 0;
            }
            case 4759: {
                return Tool.rectContain(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]) ? 1 : 0;
            }
            case 4760: {
                if (GWindow.dropTargetWidget != null) {
                    return GWindow.dropTargetWidget.vmData[33];
                }
                return 0;
            }
            case 4761: {
                if (GWindow.dropTargetWidget != null) {
                    return this.makeTempObject(GWindow.dropTargetWidget);
                }
                return 0;
            }
            case 4762: {
                GWindow.dropTargetWidget = this.getGW(params[0]);
                break;
            }
            case 4763: {
                return this.getGW((int)params[0]).getClone((VMGame)((VMGame)this.owner)).vmData[33];
            }
            case 4764: {
                return this.makeTempObject(((GContainer)this.getGW(params[0])).getChildren());
            }
            case 4765: {
                return this.makeTempObject(((GContainer)this.getGW(params[0])).getChild(params[1]));
            }
            case 4766: {
                return ((GContainer)this.getGW((int)params[0])).children.size();
            }
            case 4767: {
                ((GContainer)this.getGW(params[0])).batchAdd(this.getGW(params[1]), params[2]);
                break;
            }
            case 4768: {
                return this.makeTempObject(((GContainer)this.getGW((int)params[0])).children);
            }
            case 4769: {
                return this.makeTempObject(GWidget.getCloneArray((VMGame)this.owner, this.getGW(params[0]), params[1]));
            }
            case 4770: {
                return this.makeTempObject(((GContainer)this.getGW(params[0])).getJavaChildren());
            }
            case 4771: {
                return this.makeTempObject(((GContainer)this.getGW(params[0])).getJavaChild(params[1]));
            }
            case 4772: {
                GWindow gWindow = (GWindow)this.getGW(params[0]);
                if (gWindow.focusWidget != null) {
                    return this.makeTempObject(gWindow.focusWidget.vmData);
                }
                return 0;
            }
            case 4773: {
                return this.makeTempObject(((GWindow)this.getGW((int)params[0])).focusWidget);
            }
            case 4774: {
                return ((GWindow)this.getGW(params[0])).canHandleCycleUI(this.getGW(params[1])) ? 1 : 0;
            }
            case 4775: {
                return this.makeTempObject(VMGame.getTopUIVMId());
            }
            case 4776: {
                return this.getGW(params[0]).getShow() ? 1 : 0;
            }
            case 4777: {
                this.getGW(params[0]).setShow(params[1] == 1);
                break;
            }
            case 4778: {
                Utilities.sendKeyPressed(params[0]);
                break;
            }
            case 4779: {
                Utilities.sendKeyDown(params[0]);
                break;
            }
            case 4780: {
                Utilities.sendKeyUp(params[0]);
                break;
            }
            case 4781: {
                GWidget destoryGWidget = this.getGW(params[0]);
                if (destoryGWidget == null) break;
                if (destoryGWidget.vmData[22] > 0) {
                    VM vM = this;
                    synchronized (vM) {
                        this.callback(destoryGWidget.vmData[22], new int[]{destoryGWidget.vmData[33]});
                    }
                }
                destoryGWidget.freeVMObj();
                ((VMGame)this.owner).removeGWidget(destoryGWidget);
                break;
            }
            case 4782: {
                return this.makeTempObject(this.getGW(params[0]));
            }
            case 4783: {
                ((GWindow)this.getGW((int)params[0])).catchInput = params[1] == 1;
                break;
            }
            case 4784: {
                ((GLabel)this.getGW(params[0])).setOffsetScale(params[1]);
                break;
            }
            case 4785: {
                ((GLabel)this.getGW(params[0])).setScrollOffset(params[1]);
                break;
            }
            case 4786: {
                return ((GLabel)this.getGW(params[0])).getScrollOffset();
            }
            case 4787: {
                GWindow mouseTopWindow = VMGame.getMouseTopGWindow(params[0], params[1]);
                if (mouseTopWindow != null) {
                    return this.makeTempObject(mouseTopWindow.vmData);
                }
                return 0;
            }
            case 4788: {
                ((GContainer)this.getGW(params[0])).add(this.getGW(params[1]), params[2]);
                break;
            }
            case 4789: {
                ((GContainer)this.getGW(params[0])).setHLayout(params[1], params[2]);
                break;
            }
            case 4790: {
                ((GContainer)this.getGW(params[0])).setVLayout(params[1], params[2]);
                break;
            }
            case 4791: {
                ((GContainer)this.getGW(params[0])).setGridLayout(params[1], params[2]);
                break;
            }
            case 4792: {
                ((GContainer)this.getGW(params[0])).setGrid2Layout(params[1], params[2], params[3], params[4]);
                break;
            }
            case 4793: {
                ((GContainer)this.getGW(params[0])).setGrid3Layout(params[1], params[2]);
                break;
            }
            case 4794: {
                ((GContainer)this.getGW(params[0])).setBorderLayout(params[1], params[2], params[3], params[4]);
                break;
            }
            case 4795: {
                ((GLabel)this.getGW((int)params[0])).is3d = params[1] == 1;
                break;
            }
            case 4796: {
                ((GLabel)this.getGW((int)params[0])).color = params[1];
                break;
            }
            case 4797: {
                ((GLabel)this.getGW((int)params[0])).bgColor = params[1];
                break;
            }
            case 4798: {
                ((GLabel)this.getGW((int)params[0])).anchor = params[1];
                break;
            }
            case 4799: {
                ((GLabel)this.getGW((int)params[0])).colors = (int[])this.followPointer(params[1]);
                break;
            }
            case 4800: {
                ((GLabel)this.getGW((int)params[0])).index = params[1];
                break;
            }
            case 4801: {
                ((GTextArea)this.getGW((int)params[0])).color = params[1];
                break;
            }
            case 4802: {
                ((GTextArea)this.getGW((int)params[0])).is3d = params[1] == 1;
                break;
            }
            case 4803: {
                return ((GTextArea)this.getGW((int)params[0])).showLines;
            }
            case 4804: {
                return ((GTextArea)this.getGW((int)params[0])).totalLines;
            }
            case 4805: {
                return ((GTextArea)this.getGW((int)params[0])).lastPageLine;
            }
            case 4806: {
                return ((GTextArea)this.getGW((int)params[0])).currentLine;
            }
            case 4807: {
                return ((GTextArea)this.getGW((int)params[0])).curPage;
            }
            case 4808: {
                return ((GTextArea)this.getGW((int)params[0])).totalPage;
            }
            case 4809: {
                ((GTextArea)this.getGW((int)params[0])).colors = (int[])this.followPointer(params[1]);
                break;
            }
            case 4810: {
                ((GTextArea)this.getGW((int)params[0])).index = params[1];
                break;
            }
            case 4811: {
                return this.makeTempObject(this.getGW((int)params[0]).vmGame);
            }
            case 4812: {
                return this.makeTempObject(this.getGW((int)params[0]).name);
            }
            case 4813: {
                ((GIcon)this.getGW((int)params[0])).trans = params[1];
                break;
            }
            case 4814: {
                ((GIcon)this.getGW((int)params[0])).anchor = params[1];
                break;
            }
            case 4815: {
                ((GContainer)this.getGW(params[0])).toBottom(params[1]);
                break;
            }
            case 4816: {
                GWidget gWidget4 = this.getGW(params[1]);
                if (gWidget4 != null) {
                    return ((GContainer)this.getGW(params[0])).getIndex(gWidget4);
                }
                return -1;
            }
            case 4817: {
                return this.makeTempObject(this.owner);
            }
            case 4818: {
                return ((VMGame)this.followPointer((int)params[0])).gtvm.isBlock() ? 1 : 0;
            }
            case 4819: {
                ((GWindow)this.getGW((int)params[0])).ignorePauseUICycle = params[1] == 1;
                break;
            }
            case 4820: {
                return ((GWindow)this.getGW((int)params[0])).ignorePauseUICycle ? 1 : 0;
            }
            case 4821: {
                return ((GIcon)this.getGW((int)params[0])).numberIndex;
            }
            case 4822: {
                return ((GIcon)this.getGW((int)params[0])).numberSpace;
            }
            case 4823: {
                return ((GIcon)this.getGW((int)params[0])).numberX;
            }
            case 4824: {
                return ((GIcon)this.getGW((int)params[0])).numberY;
            }
            case 4825: {
                return ((GIcon)this.getGW((int)params[0])).number;
            }
            case 4826: {
                return ((GIcon)this.getGW((int)params[0])).iconIndex;
            }
            case 4827: {
                return ((GIcon)this.getGW((int)params[0])).isShow ? 1 : 0;
            }
            case 4828: {
                return ((GContainer)this.getGW((int)params[0])).firstInViewIndex;
            }
            case 4829: {
                return ((GContainer)this.getGW((int)params[0])).lastInViewIndex;
            }
        }
        return 0;
    }

    protected int syscall(short funcID, int[] params) throws Exception {
        if (funcID >= 16384 && funcID < 20480) {
            return ((Quest)this.owner).syscall(funcID, params);
        }
        if (funcID < 4865) {
            return this.syscall2(funcID, params);
        }
        switch (funcID) {
            case 4865: {
                GameMain.numberImage = (ImageSet)this.followPointer(params[0]);
                Object[] cacheVm = (Object[])this.followPointer(params[1]);
                GameMain.needCacheVm.clear();
                for (int i = 0; i < cacheVm.length; ++i) {
                    GameMain.needCacheVm.put(cacheVm[i], cacheVm[i]);
                }
                GameMain.battleRemind = (int[])this.followPointer(params[2]);
                GameMain.javaWorldPacket.clear();
                int[] javaWorldPacket = (int[])this.followPointer(params[3]);
                for (int i = 0; i < javaWorldPacket.length; ++i) {
                    GameMain.javaWorldPacket.put(new Integer(javaWorldPacket[i]), new Integer(javaWorldPacket[i]));
                }
                int[] intConst = (int[])this.followPointer(params[4]);
                GameMain.numberImageIndex = intConst[0];
                GameMain.flyNumberIndex = intConst[1];
                GameMain.flyNumberBlockCount = intConst[2];
                GameMain.humanAnimateIndex = intConst[3];
                GameMain.autoSelectDistance = intConst[4];
                GameMain.forceSelectDistance = intConst[5];
                GameMain.lostSelectDistance = intConst[6];
                GameMain.positionDistance = intConst[7];
                GameMain.positionTime = intConst[8];
                GameMain.positionLimit = intConst[9];
                GameMain.dropNetplayerTime = intConst[10];
                GameMain.dropflyingStringTime = intConst[11];
                GameMain.spriteFlyingStringDelay = intConst[12];
                GameMain.spritePlayAnimateDelay = intConst[13];
                GameMain.followingNotifyServerTime = intConst[14];
                GameMain.battleModePositionTime = intConst[15];
                GameMain.keepGoingDistance = intConst[16];
                GameMain.followMaxDis = intConst[17];
                GameMain.animatePendingTick = intConst[18];
                GameMain.spriteLeavingSpeed = intConst[19];
                GameMain.netplayerShowNameDistance = intConst[20];
                GameMain.imageScalePercent = intConst[21];
                break;
            }
            case 4866: {
                return this.makeTempObject(new PipAnimateSet((ImageSet[])this.followPointer(params[0]), (byte[])this.followPointer(params[1])));
            }
            case 4867: {
                AnimatePlayer animatePlayer = new AnimatePlayer((String)this.followPointer(params[0]));
                animatePlayer.init((PipAnimateSet)this.followPointer(params[1]));
                return this.makeTempObject(animatePlayer);
            }
            case 4868: {
                AnimatePlayer animatePlayer = (AnimatePlayer)this.followPointer(params[0]);
                animatePlayer.setAnimate(params[1], 0, -1, Tool.NO_CALL_BACK_SPRITE);
                animatePlayer.setShown(true);
                break;
            }
            case 4869: {
                Object[] data = (Object[])this.followPointer(params[0]);
                GameMain.clientAnimates = new AnimatePlayer[data.length];
                System.arraycopy(data, 0, GameMain.clientAnimates, 0, data.length);
                break;
            }
            case 4870: {
                return GameMain.resourceAsynLoader.addLoad((byte)params[0], (String)this.followPointer(params[1]), null);
            }
            case 4871: {
                return GameMain.resourceAsynLoader.checkLoad(params[0]) ? 1 : 0;
            }
            case 4872: {
                return this.makeTempObject(GameMain.resourceAsynLoader.getLoad(params[0]));
            }
            case 4873: {
                GameMain.initializing = params[0] == 1;
                break;
            }
            case 4880: {
                return this.makeTempObject(GameMain.clientAnimates[params[0]].getRelateCopy());
            }
            case 4881: {
                return GameWorld.currentAreaId;
            }
            case 4882: {
                return GameWorld.playerNextMap;
            }
            case 4889: {
                return GameWorld.playerNextMapInstanceId;
            }
            case 4883: {
                GameMain.resourceManager.requestResource((String)this.followPointer(params[0]));
                break;
            }
            case 4884: {
                GameMain.specialAnimates = new AnimatePlayer[params[0]];
                break;
            }
            case 4885: {
                GameMain.specialAnimates[params[0]] = (AnimatePlayer)this.followPointer(params[1]);
                break;
            }
            case 4886: {
                AnimatePlayer animatePlayer = GameMain.specialAnimates[params[0]].getCopy();
                animatePlayer.setAnimate(params[1], params[2], params[3], (IAnimateCallback)this.followPointer(params[4]));
                return this.makeTempObject(animatePlayer);
            }
            case 4887: {
                ((AnimatePlayer)this.followPointer(params[0])).setAnchor(params[1]);
                ((AnimatePlayer)this.followPointer(params[0])).setOrder(params[2]);
                break;
            }
            case 4888: {
                return this.makeTempObject(((AnimatePlayer)this.followPointer(params[0])).getAnimateBox(params[1]));
            }
            case 4897: {
                Tool.drawFrameBox((Graphics)this.followPointer(params[0]), params[1], params[2], params[3], params[4], (int[])this.followPointer(params[5]));
                break;
            }
            case 4898: {
                Tool.drawBoxCorner((Graphics)this.followPointer(params[0]), params[1], params[2], params[3], params[4], (ImageSet)this.followPointer(params[5]), params[6]);
                break;
            }
            case 4899: {
                Tool.drawSpellRow((Graphics)this.followPointer(params[0]), params[1], params[2], params[3], (ImageSet)this.followPointer(params[4]), params[5], params[6]);
                break;
            }
            case 4900: {
                Tool.drawSpellCol((Graphics)this.followPointer(params[0]), params[1], params[2], params[3], (ImageSet)this.followPointer(params[4]), params[5], params[6]);
                break;
            }
            case 4901: {
                Tool.drawSpellArea((Graphics)this.followPointer(params[0]), params[1], params[2], params[3], params[4], (ImageSet)this.followPointer(params[5]), params[6], params[7]);
                break;
            }
            case 4902: {
                AnimatePlayer ap = (AnimatePlayer)this.followPointer(params[0]);
                ap.draw((Graphics)this.followPointer(params[1]), params[2], params[3]);
                break;
            }
            case 4912: {
                break;
            }
            case 4913: {
                GameMain.fadeEffect = false;
                GameMain.fadeData = null;
                break;
            }
            case 4914: {
                GameMain.vibraData = (int[])this.followPointer(params[0]);
                GameMain.vibraTick = params[1];
                GameMain.vibraMaxCount = params[2];
                GameMain.vibraCurrentIndex = 0;
                GameMain.vibraCurrentCount = 0;
                GameMain.vibraEffect = true;
                break;
            }
            case 4915: {
                GameMain.vibraEffect = false;
                GameMain.vibraData = null;
                break;
            }
            case 4916: {
                GameMain.weather = new Weather(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8], params[9]);
                break;
            }
            case 4917: {
                GameMain.weather = null;
                break;
            }
            case 4918: {
                if (GameMain.weather == null) break;
                GameMain.weather.adjustPara(params[0], params[1]);
                break;
            }
            case 4919: {
                GameWorld.teamInfo = (SortHashtable)this.followPointer(params[0]);
                break;
            }
            case 4920: {
                GameMain.battleRemind[5] = 1;
                break;
            }
            case 4921: {
                AnimateCache.clearPendingReleaseAnimate();
                break;
            }
            case 8192: {
                return this.makeTempObject(Tool.splitString((String)this.followPointer(params[0])));
            }
            case 8193: {
                this.pauseProcess();
                break;
            }
            case 8194: {
                this.continueProcess(params[0]);
                break;
            }
            case 8195: {
                return this.makeTempObject(Integer.toHexString(params[0]));
            }
            case 8196: {
                return (int)(Tool.getSystemTime() / 1000L);
            }
            case 8208: {
                String str = (String)this.followPointer(params[0]);
                String delimiter = (String)this.followPointer(params[1]);
                return this.makeTempObject(Tool.splitString(str, delimiter.charAt(0)));
            }
            case 8210: {
                Utilities.isExitGame = true;
                break;
            }
            case 8211: {
                Utilities.closeConnection();
                break;
            }
            case 8212: {
                ((Utilities)this.followPointer((int)params[0])).listenVM = null;
                break;
            }
            case 8215: {
                SanguoMIDlet.instance.platformRequest((String)this.followPointer(params[0]));
                break;
            }
            case 8216: {
                new Thread(new Utilities((String)this.followPointer(params[0]), 1, this, false)).start();
                break;
            }
            case 8217: {
                String url = (String)this.followPointer(params[0]);
                if (params[1] == 1) {
                    url = "p" + url;
                }
                Utilities newObj = new Utilities(url, 0, this, false);
                newObj.requestProperties = (SortHashtable)this.followPointer(params[2]);
                newObj.postData = (byte[])this.followPointer(params[3]);
                new Thread(newObj).start();
                return this.makeTempObject(newObj);
            }
            case 8218: {
                return this.makeTempObject(((Utilities)this.followPointer((int)params[0])).lastDownloadData);
            }
            case 8219: {
                String url = (String)this.followPointer(params[0]);
                if (params[1] == 1) {
                    url = "p" + url;
                }
                Utilities newObj = new Utilities(url, 0, this, true);
                newObj.requestProperties = (SortHashtable)this.followPointer(params[2]);
                newObj.postData = (byte[])this.followPointer(params[3]);
                new Thread(newObj).start();
                return this.makeTempObject(newObj);
            }
            case 8220: {
                return GameMain.tick;
            }
            case 8221: {
                return ~params[0];
            }
            case 8222: {
                ((Graphics)this.followPointer(params[0])).drawLine(params[1], params[2], params[3], params[4]);
                break;
            }
            case 8223: {
                ((Graphics)this.followPointer(params[0])).fillRoundRect(params[1], params[2], params[3], params[4], params[5], params[6]);
                break;
            }
            case 8224: {
                Tool.draw3DString((Graphics)this.followPointer(params[0]), (String)this.followPointer(params[1]), params[2], params[3], params[4], params[5], params[6]);
                break;
            }
            case 8225: {
                Tool.draw3DString2((Graphics)this.followPointer(params[0]), (String)this.followPointer(params[1]), params[2], params[3], params[4], params[5], params[6]);
                break;
            }
            case 8226: {
                new Thread(new Utilities((String)this.followPointer(params[0]) + "\n" + (String)this.followPointer(params[1]), 2, this, false)).start();
                break;
            }
            case 8227: {
                return ((Utilities)this.followPointer((int)params[0])).state;
            }
            case 8233: {
                return (GameMain.viewHeight - params[0]) / Utilities.LINE_HEIGHT;
            }
            case 8249: {
                int dotted = params[1] != 0 ? 1 : 0;
                ((Graphics)this.followPointer(params[0])).setStrokeStyle(dotted);
                break;
            }
            case 8251: {
                Tool.drawBack((Graphics)this.followPointer(params[0]), params[1], params[2], params[3], params[4]);
                break;
            }
            case 8265: {
                String[] strSplit = Tool.splitString((String)this.followPointer(params[1]), params[3], Utilities.font);
                for (int i = 0; i < strSplit.length; ++i) {
                    ((Graphics)this.followPointer(params[0])).drawString(strSplit[i], params[2], params[3] + Utilities.LINE_HEIGHT * i, 20);
                }
                break;
            }
            case 8267: {
                return this.makeTempObject(GameWorld.player.getName());
            }
            case 12288: {
                break;
            }
            case 12289: {
                UASegment segment = (UASegment)this.followPointer(params[0]);
                segment.flush();
                segment.reset();
                GameMain.resourceManager.initManager(segment);
                break;
            }
            case 12290: {
                return this.makeTempObject(GameMain.resourceManager.getRemainUpdateList());
            }
            case 12291: {
                GameMain.setUpdating(params[0] == 1);
                break;
            }
            case 12292: {
                String name = (String)this.followPointer(params[0]);
                Tool.sendGetFile(name);
                break;
            }
            case 12293: {
                GameMain.resetClient(params[0]);
                break;
            }
            case 12294: {
                return GameMain.resourceManager.getUpdateMode();
            }
            case 12295: {
                GameMain.resourceManager.syncVersion(params[0] == 1);
                break;
            }
            case 12296: {
                return GameMain.resetType;
            }
            case 12297: {
                GameMain.resourceManager.clearClientFileDb();
                break;
            }
            case 12298: {
                Tool.unitViewCache.put(Tool.getSpriteKey(params[0], params[1]), this.followPointer(params[2]));
                break;
            }
            case 12299: {
                Tool.removeUnitViewCacheByType(params[0]);
                break;
            }
            case 12300: {
                Tool.unitViewCache.remove(Tool.getSpriteKey(params[0], params[1]));
                break;
            }
            case 12301: {
                Tool.unitViewCache.clear();
                break;
            }
            case 12302: {
                GameMain.resourceManager.clearWholeData();
                break;
            }
            case 12316: {
                String msg1 = (String)this.followPointer(params[0]);
                return this.makeTempObject(Tool.formatString(msg1, params[1], Utilities.font, false));
            }
            case 12336: {
                Tool.drawImageNumber((Graphics)this.followPointer(params[0]), (ImageSet)this.followPointer(params[1]), params[2], (String)this.followPointer(params[3]), params[4], params[5], params[6], params[7]);
                break;
            }
            case 12352: {
                return this.makeTempObject(new String[params[0]]);
            }
            case 12353: {
                return this.makeTempObject(new ImageSet[params[0]]);
            }
            case 12357: {
                return Tool.getStringsMaxWidth((String[])this.followPointer(params[0]), false);
            }
            case 12358: {
                return Tool.getStringsMaxWidth((String[])this.followPointer(params[0]), true);
            }
            case 12369: {
                return this.makeTempObject(Tool.inflate((byte[])this.followPointer(params[0])));
            }
            case 12370: {
                return Utilities.getServerTime();
            }
            case 12384: {
                return VMCounter.createVMCounter(params[0]);
            }
            case 12385: {
                return VMCounter.getSaveTimeSec(params[0]);
            }
            case 12386: {
                return VMCounter.getSaveTimeMillis(params[0]);
            }
            case 12387: {
                VMCounter.removeVMCounter(params[0]);
                break;
            }
            case 12388: {
                VMCounter.removeAllVMCounters();
                break;
            }
            case 12400: {
                if (params[4] <= 0) break;
                System.arraycopy((int[])this.followPointer(params[0]), params[1], this.followPointer(params[2]), params[3], params[4]);
                break;
            }
            case 12416: {
                return ((VMGame)this.owner).callback((String)this.followPointer(params[0]), new Object[]{new Integer(params[1]), this.followPointer(params[2])});
            }
            case 12418: {
                VMGame.closeVM((String)this.followPointer(params[0]));
                break;
            }
            case 12419: {
                VMGame.closeVM(params[0]);
                break;
            }
            case 12420: {
                return this.makeTempObject(GameNetPlayer.createGameNetPlayer(params[0], 0));
            }
            case 12421: {
                return this.makeTempObject(VMGame.getVMGames());
            }
            case 12432: {
                Quest quest = Quest.findQuest(params[0], false);
                if (quest != null) {
                    return quest.getTargetStatus(params[1]) ? 1 : 0;
                }
                return 0;
            }
            case 12433: {
                return this.makeTempObject(new StringBuffer());
            }
            case 12434: {
                ((StringBuffer)this.followPointer(params[0])).append((String)this.followPointer(params[1]));
                break;
            }
            case 12435: {
                ((StringBuffer)this.followPointer(params[0])).setLength(params[1]);
                break;
            }
            case 12436: {
                return this.makeTempObject(((StringBuffer)this.followPointer(params[0])).toString());
            }
            case 20481: {
                ((GameSprite)this.followPointer(params[0])).vm_request_animates((String[])this.followPointer(params[1]));
                break;
            }
            case 20482: {
                ((GameSprite)this.followPointer(params[0])).vm_set_sprite_show(params[1] == 1);
                break;
            }
            case 20483: {
                ((GameSprite)this.followPointer(params[0])).vm_add_animate((String)this.followPointer(params[1]));
                break;
            }
            case 20484: {
                ((GameSprite)this.followPointer(params[0])).vm_set_animate_show((String)this.followPointer(params[1]), params[2] == 1);
                break;
            }
            case 20485: {
                ((GameSprite)this.followPointer(params[0])).vm_add_animate_replace_images((String)this.followPointer(params[1]), (String[])this.followPointer(params[2]));
                break;
            }
            case 20486: {
                return ((GameSprite)this.followPointer(params[0])).vm_test_animate_ok((String[])this.followPointer(params[1])) ? 1 : 0;
            }
            case 20487: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_has_animate((String)this.followPointer(params[1])) ? 1 : 0;
            }
            case 20488: {
                return this.makeTempObject(((GameSprite)this.followPointer(params[0])).vm_sprite_get_animate_box());
            }
            case 20489: {
                return this.makeTempObject(((GameSprite)this.followPointer(params[0])).vm_sprite_get_name());
            }
            case 20496: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_name((String)this.followPointer(params[1]));
                break;
            }
            case 20497: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_faction();
            }
            case 20498: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_faction(params[1]);
                break;
            }
            case 20499: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_level();
            }
            case 20500: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_level(params[1]);
                break;
            }
            case 20501: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_hp();
            }
            case 20502: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_hp_max();
            }
            case 20503: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_mp();
            }
            case 20504: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_mp_max();
            }
            case 20505: {
                return this.makeTempObject(((GameSprite)this.followPointer(params[0])).vm_sprite_get_pos());
            }
            case 20512: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_pos(params[1], params[2]);
                break;
            }
            case 20513: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_map_id();
            }
            case 20514: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_map_instance_id();
            }
            case 20515: {
                ((GameSprite)this.followPointer(params[0])).vm_game_set_animate_index((String)this.followPointer(params[1]), params[2], params[3], params[4]);
                break;
            }
            case 20516: {
                return ((GameSprite)this.followPointer(params[0])).vm_game_sprite_play_animate((AnimatePlayer)this.followPointer(params[1]), params[2], params[3]);
            }
            case 20517: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_can_attack(params[1] == 1);
                break;
            }
            case 20518: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_can_attack() ? 1 : 0;
            }
            case 20519: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_can_select(params[1] == 1);
                break;
            }
            case 20520: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_can_select() ? 1 : 0;
            }
            case 20521: {
                return this.makeTempObject(((GameSprite)this.followPointer(params[0])).vm_sprite_get_animate_para());
            }
            case 20528: {
                ((GameSprite)this.followPointer(params[0])).vm_game_sprite_stop_animate(params[1]);
                break;
            }
            case 20529: {
                ((GameSprite)this.followPointer(params[0])).vm_game_sprite_add_fly_string(params[1], (String)this.followPointer(params[2]), params[3], params[4], params[5], params[6], params[7], params[8]);
                break;
            }
            case 20530: {
                ((GameSprite)this.followPointer(params[0])).vm_game_sprite_add_across_fly_string(params[1], (String)this.followPointer(params[2]), params[3], params[4], params[5], params[6], params[7], params[8], params[9], params[10], params[11], params[12]);
                break;
            }
            case 20531: {
                ((GameSprite)this.followPointer(params[0])).vm_game_sprite_add_vibar(params[1], params[2]);
                break;
            }
            case 20532: {
                ((GameSprite)this.followPointer(params[0])).vm_game_sprite_set_die(params[1] == 1);
                break;
            }
            case 20533: {
                ((GameSprite)this.followPointer(params[0])).vm_game_sprite_set_waypoint_animate(params[1], params[2], params[3], params[4], params[5], params[6]);
                break;
            }
            case 20534: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_head_string_config(params[1], params[2], params[3], params[4], params[5], params[6]);
                break;
            }
            case 20535: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_add_head_string((String)this.followPointer(params[1]), params[2], this.followPointer(params[3]), (int[])this.followPointer(params[4]));
                break;
            }
            case 20536: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_clear_head_string();
                break;
            }
            case 20537: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_head_string_show(params[1] == 1);
                break;
            }
            case 20544: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_collision(params[1] == 1);
                break;
            }
            case 20545: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_type();
            }
            case 20546: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_id();
            }
            case 20547: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_instanceid();
            }
            case 20548: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_dir();
            }
            case 20549: {
                return this.makeTempObject(((GameSprite)this.followPointer(params[0])).vm_sprite_get_animate_player((String)this.followPointer(params[1])));
            }
            case 20550: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_send_command(params[1], this.followPointer(params[2]));
                break;
            }
            case 20551: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_start_chase_position(params[1], params[2], params[3], params[4], (int[])this.followPointer(params[5]), params[6] == 1) ? 1 : 0;
            }
            case 20552: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_start_chase_sprite(params[1], params[2], (GameSprite)this.followPointer(params[3]), (int[])this.followPointer(params[4]), params[5] == 1) ? 1 : 0;
            }
            case 20553: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_clear_chase();
                break;
            }
            case 20560: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_dir(params[1]);
                break;
            }
            case 20561: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_adjust_animate_dir(params[1], params[2] == 1);
                break;
            }
            case 20562: {
                return this.makeTempObject(((GameSprite)this.followPointer(params[0])).vm_sprite_get_extra_name());
            }
            case 20563: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_speed();
            }
            case 20564: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_speed(params[1]);
                break;
            }
            case 20565: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_animate_sub_dir();
            }
            case 20566: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_animate_sub_dir(params[1]);
                break;
            }
            case 20567: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_attacking(params[1] == 1);
                break;
            }
            case 20568: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_weapon_type();
            }
            case 20569: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_weapon_type(params[1]);
                break;
            }
            case 20576: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_animate_dir();
            }
            case 20577: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_animate_dir(params[1]);
                break;
            }
            case 20578: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_move() ? 1 : 0;
            }
            case 20579: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_following(params[1] == 1);
                break;
            }
            case 20580: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_following() ? 1 : 0;
            }
            case 20581: {
                return this.makeTempObject(((GameSprite)this.followPointer(params[0])).vm_sprite_get_follow_owner());
            }
            case 20582: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_leaving_pos();
                break;
            }
            case 20583: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_test_status(params[1]) ? 1 : 0;
            }
            case 20584: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_add_status(params[1]);
                break;
            }
            case 20585: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_remove_status(params[1]);
                break;
            }
            case 20592: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_clear_status();
                break;
            }
            case 20593: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_force_way_point(params[1] == 1, params[2], params[3], params[4], (int[])this.followPointer(params[5]));
                break;
            }
            case 20594: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_clear_force_way_point();
                break;
            }
            case 20595: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_speed_addon();
            }
            case 20596: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_speed_addon(params[1]);
                break;
            }
            case 20597: {
                ((GameSprite)this.followPointer(params[0])).vm_set_animate_not_icon((String)this.followPointer(params[1]));
                break;
            }
            case 20598: {
                ((GameSprite)this.followPointer(params[0])).vm_game_sprite_set_animate_layer((String)this.followPointer(params[1]), params[2]);
                break;
            }
            case 20599: {
                ((GameSprite)this.followPointer(params[0])).vm_game_sprite_regroup_animate();
                break;
            }
            case 20600: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_is_out_view() ? 1 : 0;
            }
            case 20601: {
                ((GameSprite)this.followPointer(params[0])).vm_set_game_sprite_horse(params[1] == 1);
                break;
            }
            case 20608: {
                ((GameSprite)this.followPointer(params[0])).vm_set_game_sprite_hold(params[1] == 1);
                break;
            }
            case 20609: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_is_team_state() ? 1 : 0;
            }
            case 20610: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_team_state(params[1] == 1);
                break;
            }
            case 20611: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_animate_draw_replace_data((String)this.followPointer(params[1]), params[2], (int[])this.followPointer(params[3]), params[4], (int[])this.followPointer(params[5]));
                break;
            }
            case 20612: {
                ((GameSprite)this.followPointer(params[0])).vm_remove_animate((String)this.followPointer(params[1]));
                break;
            }
            case 20613: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_mini_map_color((int[])this.followPointer(params[1]));
                break;
            }
            case 20614: {
                ((GameSprite)this.followPointer(params[0])).vm_sprite_set_mini_map_show(params[1] == 1);
                break;
            }
            case 20615: {
                return ((GameSprite)this.followPointer(params[0])).vm_sprite_get_mini_map_show();
            }
            case 20616: {
                ((GameSprite)this.followPointer(params[0])).forceMiniMapShow(params[1]);
                break;
            }
            case 20617: {
                return ((GameSprite)this.followPointer(params[0])).getForceMiniMapShow();
            }
            case 20737: {
                GameWorld.player.vm_role_change_target();
                break;
            }
            case 20738: {
                GameWorld.player.vm_role_set_auto_select(params[0] == 1);
                break;
            }
            case 20739: {
                return GameWorld.player.vm_role_get_target_type();
            }
            case 20740: {
                return GameWorld.player.vm_role_get_target_id();
            }
            case 20741: {
                return this.makeTempObject(GameWorld.player.vm_role_get_target_name());
            }
            case 20742: {
                return this.makeTempObject(GameWorld.player.vm_role_get_target());
            }
            case 20743: {
                return GameWorld.player.vm_role_get_target_instanceid();
            }
            case 20744: {
                GameWorld.player.vm_set_game_role_change_2468_mode(params[0] == 1);
                break;
            }
            case 20745: {
                return GameWorld.player.vm_sprite_get_dir_key_valid() ? 1 : 0;
            }
            case 20746: {
                return GameWorld.player.target == null ? -1 : (int)GameWorld.player.target.faction;
            }
            case 20747: {
                return GameWorld.player.die ? 1 : 0;
            }
            case 20748: {
                return GameWorld.player.target == null ? -1 : (GameWorld.player.target.die ? 1 : 0);
            }
            case 20752: {
                GameWorld.player.vm_sprite_set_dir_key_valid(params[0] == 1);
            }
            case 20753: {
                return GameWorld.player.vm_sprite_get_fire_key_valid() ? 1 : 0;
            }
            case 20754: {
                GameWorld.player.vm_sprite_set_fire_key_valid(params[0] == 1);
                break;
            }
            case 20755: {
                GameWorld.player.vm_game_role_set_battle_mode(params[0] == 1);
                break;
            }
            case 20756: {
                GameWorld.player.vm_role_clear_target();
                break;
            }
            case 20757: {
                GameWorld.player.vm_game_role_set_target(params[0]);
                break;
            }
            case 20758: {
                GameWorld.player.vm_game_role_set_select_const(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8], params[9]);
                break;
            }
            case 20759: {
                GameWorld.player.vm_role_test_and_change_target(params[0]);
                break;
            }
            case 20760: {
                GameWorld.player.vm_game_role_point_move(params[0]);
                break;
            }
            case 20993: {
                return this.makeTempObject(((GameNpc)this.followPointer(params[0])).vm_game_npc_get_animate_name());
            }
            case 20994: {
                ((GameNpc)this.followPointer(params[0])).vm_game_set_npc_image_id(params[1]);
                break;
            }
            case 20995: {
                ((GameNpc)this.followPointer(params[0])).vm_game_set_npc_quest_id(params[1]);
                break;
            }
            case 20996: {
                return ((GameNpc)this.followPointer(params[0])).vm_game_get_npc_quest_id();
            }
            case 20997: {
                return ((GameNpc)this.followPointer(params[0])).vm_game_npc_is_human() ? 1 : 0;
            }
            case 20998: {
                return ((GameNpc)this.followPointer(params[0])).vm_game_npc_get_animate_count();
            }
            case 20999: {
                ((GameNpc)this.followPointer(params[0])).vm_game_npc_set_need_collision(params[1] == 1);
                break;
            }
            case 21249: {
                ((GameIcon)this.followPointer(params[0])).vm_free_icon();
                break;
            }
            case 21250: {
                ((GameIcon)this.followPointer(params[0])).vm_set_icon_position(params[1], params[2]);
                break;
            }
            case 21251: {
                ((GameIcon)this.followPointer(params[0])).vm_set_icon_clip(params[1], params[2], params[3], params[4]);
                break;
            }
            case 21252: {
                ((GameIcon)this.followPointer(params[0])).vm_set_icon_show(params[1] == 1);
                break;
            }
            case 21253: {
                ((GameIcon)this.followPointer(params[0])).vm_set_icon_index(params[1]);
                break;
            }
            case 21254: {
                ((GameIcon)this.followPointer(params[0])).vm_set_icon_play_animate(params[1] == 1);
                break;
            }
            case 21255: {
                return ((GameIcon)this.followPointer(params[0])).vm_get_icon_id();
            }
            case 21256: {
                return this.makeTempObject(((GameIcon)this.followPointer(params[0])).vm_get_icon_father());
            }
            case 21505: {
                ((GameNetPlayer)this.followPointer(params[0])).vm_player_set_no_need_remove(params[1] == 1);
                break;
            }
            case 21506: {
                return ((GameNetPlayer)this.followPointer(params[0])).vm_player_get_no_need_remove() ? 1 : 0;
            }
            case 21507: {
                return ((GameNetPlayer)this.followPointer(params[0])).vm_player_get_be_skiped() ? 1 : 0;
            }
            case 21761: {
                return this.makeTempObject(GameWorld.instance.vm_create_icon(params[0], params[1], params[2]));
            }
            case 21762: {
                GameWorld.instance.vm_close_event((Quest)this.followPointer(params[0]), (int[])this.followPointer(params[1]));
                break;
            }
            case 21763: {
                return this.makeTempObject(GameWorld.instance.vm_create_icon2((GameSprite)this.followPointer(params[0]), params[1]));
            }
            case 21766: {
                GameWorld.instance.vm_world_set_mini_map_config((UASegment)this.followPointer(params[0]));
                break;
            }
            case 21767: {
                GameWorld.instance.vm_game_set_mini_map_show(params[0] == 1);
                break;
            }
            case 21768: {
                return this.makeTempObject(GameWorld.instance.vm_game_get_netplayer_list());
            }
            case 21769: {
                return GameWorld.instance.vm_world_get_target_distance();
            }
            case 21776: {
                GameWorld.instance.vm_game_to_map(params[0], params[1], params[2], params[3]);
                break;
            }
            case 21777: {
                GameWorld.instance.vm_game_add_follower(params[0], params[1]);
                break;
            }
            case 21778: {
                GameWorld.instance.vm_game_del_follower();
                break;
            }
            case 21779: {
                return GameWorld.instance.vm_world_get_target_can_attack() ? 1 : 0;
            }
            case 21780: {
                return this.makeTempObject(GameWorld.instance.vm_game_get_gamesprite_list());
            }
            case 21781: {
                return GameWorld.instance.vm_game_get_map_id();
            }
            case 21782: {
                GameWorld.instance.vm_game_do_touch_npc((GameSprite)this.followPointer(params[0]));
                break;
            }
            case 21783: {
                GameWorld.instance.vm_request_destroy_sprite((GameSprite)this.followPointer(params[0]));
                break;
            }
            case 21784: {
                return this.makeTempObject(GameWorld.instance.vm_game_current_landmark_name());
            }
            case 21785: {
                return GameWorld.instance.vm_game_get_hmsg_count();
            }
            case 21792: {
                return GameWorld.instance.vm_game_get_vmsg_count();
            }
            case 21793: {
                return GameWorld.instance.vm_game_get_dis((GameSprite)this.followPointer(params[0]), (GameSprite)this.followPointer(params[1]));
            }
            case 21794: {
                GameWorld.instance.vm_game_do_destroy_sprite(params[0], params[1], params[2] == 1);
                break;
            }
            case 21795: {
                GameWorld.instance.vm_world_set_in_loading(params[0] == 1);
                break;
            }
            case 21796: {
                GameWorld.instance.vm_world_set_netplayer_name_near_show(params[0] == 1);
                break;
            }
            case 21797: {
                return this.makeTempObject(GameWorld.instance.vm_game_get_mini_map_size());
            }
            case 21798: {
                return GameWorld.instance.vm_world_get_is_team_member(params[0]) ? 1 : 0;
            }
            case 21799: {
                return GameWorld.instance.vm_game_add_quest_etf(params[0], params[1], params[2], params[3], (byte[])this.followPointer(params[4]));
            }
            case 21800: {
                GameWorld.instance.vm_game_add_quest(params[0], params[1], params[2], params[3]);
                break;
            }
            case 21801: {
                GameWorld.instance.vm_game_remove_quest(params[0], params[1], params[2]);
                break;
            }
            case 21808: {
                return GameWorld.instance.vm_game_update_quest_etf(params[0], (byte[])this.followPointer(params[1]));
            }
            case 21809: {
                GameWorld.instance.vm_game_set_quest_var(params[0], params[1], params[2]);
                break;
            }
            case 21810: {
                return this.makeTempObject(GameWorld.instance.vm_game_translate_text(params[0], (String)this.followPointer(params[1])));
            }
            case 21811: {
                GameWorld.instance.vm_game_set_quest_state(params[0], params[1]);
                break;
            }
            case 21812: {
                return GameWorld.instance.vm_game_get_quest_state(params[0]);
            }
            case 21813: {
                GameWorld.instance.vm_game_clear_scene_quests();
                break;
            }
            case 21814: {
                return this.makeTempObject(GameWorld.vm_game_vm_callback(params[0], this.followPointer(params[1]), (String)this.followPointer(params[2]), (String)this.followPointer(params[3])));
            }
            case 21815: {
                return this.makeTempObject(GameWorld.vm_game_vm_callback2(params[0], this.followPointer(params[1]), (String[])this.followPointer(params[2]), (String)this.followPointer(params[3])));
            }
            case 21816: {
                return this.makeTempObject(GameWorld.instance.vm_game_build_random_pos_list(params[0], params[1], params[2], params[3], params[4]));
            }
            case 21817: {
                GameMain.netplayerShowMaxCount = params[0];
                break;
            }
            case 21824: {
                return GameWorld.instance.vm_world_in_game_screen() ? 1 : 0;
            }
            case 21825: {
                GameWorld.instance.vm_world_show_map_npc_animate(params[0] == 1);
                break;
            }
            case 21826: {
                GameWorld.instance.vm_world_set_3dstring_level(params[0]);
                break;
            }
            case 21827: {
                GameWorld.instance.vm_game_set_mini_map_alpha(params[0]);
                break;
            }
            case 21828: {
                Tool.sendPosition(GameWorld.player.sprite.getDir(), GameWorld.player.sprite.getX(), GameWorld.player.sprite.getY(), GameWorld.player.state);
                break;
            }
            case 21829: {
                GameMain.COLLISION_MAX_STEP = params[0];
                GameMain.COLLISION_STEP_ADD = params[1];
                break;
            }
            case 21830: {
                if (GameWorld.gameView == null) break;
                GameWorld.gameView.releaseMapDataBuffer();
                break;
            }
            case 21831: {
                if (GameWorld.gameView == null) break;
                GameWorld.gameView.rebuildMapDataBuffer();
                break;
            }
            case 21832: {
                GameMain.MAP_DATA_BUFFER_OPTIMIZE = params[0] == 1;
                break;
            }
            case 22017: {
                GameWorld.panel.game_panel_set_state(params[0]);
                break;
            }
            case 22018: {
                return GameWorld.panel.game_panel_reg_image((ImageSet)this.followPointer(params[0]));
            }
            case 22019: {
                GameWorld.panel.game_panel_release_image(params[0]);
                break;
            }
            case 22020: {
                return GameWorld.panel.game_panel_add_item_animate_icon(params[0], params[1]);
            }
            case 22021: {
                return GameWorld.panel.game_panel_add_item_image_icon(params[0], params[1], params[2], params[3], params[4], params[5]);
            }
            case 22022: {
                return GameWorld.panel.game_panel_add_item_image(params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
            }
            case 22023: {
                GameWorld.panel.game_panel_change_item_image(params[0], params[1], params[2], params[3], params[4]);
                break;
            }
            case 22024: {
                return GameWorld.panel.game_panel_add_item_box(params[0], params[1], params[2], params[3], params[4], params[5]);
            }
            case 22025: {
                return GameWorld.panel.game_panel_add_item_fill_box(params[0], params[1], params[2], params[3], params[4], params[5]);
            }
            case 22032: {
                return GameWorld.panel.game_panel_add_item_line(params[0], params[1], params[2], params[3], params[4], params[5]);
            }
            case 22033: {
                return GameWorld.panel.game_panel_add_item_status_bar(params[0], params[1], params[2], params[3], params[4], params[5]);
            }
            case 22034: {
                GameWorld.panel.game_panel_change_item_status_bar(params[0], params[1], params[2]);
                break;
            }
            case 22035: {
                GameWorld.panel.game_panel_remove_item(params[0]);
                break;
            }
            case 22036: {
                GameWorld.panel.game_panel_clear_item();
                break;
            }
            case 22037: {
                return GameWorld.panel.game_panel_add_item_num(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
            }
            case 22038: {
                GameWorld.panel.game_panel_change_item_num(params[0], params[1]);
                break;
            }
            case 22039: {
                return GameWorld.panel.game_panel_add_item_mini_animate(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8], params[9]);
            }
            case 22040: {
                return GameWorld.panel.game_panel_add_item_animate(params[0], params[1], params[2], params[3], params[4], params[5], params[6], (int[])this.followPointer(params[7]));
            }
            case 22041: {
                return GameWorld.panel.game_panel_add_item_icon(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
            }
            case 22048: {
                GameWorld.panel.game_panel_action_state_change(params[0]);
                break;
            }
            case 22049: {
                return GameWorld.panel.game_panel_add_skill_animate(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8], params[9]);
            }
            case 22050: {
                GameWorld.panel.game_panel_change_skill_cold_group(params[0], params[1], params[2]);
                break;
            }
            case 22051: {
                return GameWorld.panel.game_panel_add_item_countdown(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
            }
            case 22052: {
                GameWorld.panel.game_panel_add_obtain_item(params[0], params[1], params[2], (String)this.followPointer(params[3]), params[4]);
                break;
            }
            case 22053: {
                GameWorld.panel.game_panel_add_obtain_value(params[0], params[1], params[2], params[3], params[4], params[5]);
                break;
            }
            case 22054: {
                return GameWorld.panel.game_panel_add_item_hmessage_bar(params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
            }
            case 22056: {
                return GameWorld.panel.game_panel_add_item_vmessage_bar(params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
            }
            case 22064: {
                GameWorld.panel.game_panel_post_hmessage(params[0], (String)this.followPointer(params[1]), params[2], params[3]);
                break;
            }
            case 22065: {
                GameWorld.panel.game_panel_post_vmessage(params[0], (String)this.followPointer(params[1]), params[2], params[3]);
                break;
            }
            case 22066: {
                GameWorld.panel.game_panel_set_landmark_config(params[0], params[1], params[2], params[3], params[4], params[5]);
                break;
            }
            case 22067: {
                return GameWorld.panel.game_panel_add_string((String)this.followPointer(params[0]), params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8], params[9]);
            }
            case 22068: {
                GameWorld.panel.game_panel_remove_skill_cold_group(params[0]);
                break;
            }
            case 22069: {
                return GameWorld.panel.game_panel_add_item_alpha_fill_box(params[0], params[1], params[2], params[3], params[4], params[5]);
            }
            case 22070: {
                return GameWorld.panel.createTemplate();
            }
            case 22071: {
                GameWorld.panel.addTemplateItem(params[0], (byte)params[1], params[2], (byte)params[3], (byte)params[4], (short)params[5], (short)params[6], (short)params[7], (short)params[8], params[9], params[10], this.followPointer(params[11]), this.followPointer(params[12]), params[13], params[14]);
                break;
            }
            case 22072: {
                return GameWorld.panel.createWithTemplate(params[0], (short)params[1], (short)params[2], (int[])this.followPointer(params[3]), (Object[])this.followPointer(params[4]));
            }
            case 22073: {
                GameWorld.panel.reconfigTemplateItems(params[0], params[1], (short)params[2], (short)params[3], (int[])this.followPointer(params[4]), (Object[])this.followPointer(params[5]));
                break;
            }
            case 22074: {
                GameWorld.panel.removeTemplateItems(params[0], params[1]);
                break;
            }
            case 22075: {
                GameWorld.panel.game_panel_change_item_pos(params[0], (short)params[1], (short)params[2]);
                break;
            }
            case 22076: {
                GameWorld.panel.game_panel_clear_array((int[])this.followPointer(params[0]), params[1]);
                break;
            }
            case 22077: {
                VMGame.setToTop((String)this.followPointer(params[0]));
                break;
            }
            case 22078: {
                GameWorld.panel.game_panel_change_hmessage_alpha(params[0]);
                break;
            }
            case 22079: {
                GameWorld.panel.game_panel_change_vmessage_alpha(params[0]);
                break;
            }
            case 22080: {
                ((GLabel)this.getGW(params[0])).setSingleDirScroll(params[1] == 1);
                break;
            }
            case 22081: {
                return GameWorld.panel.game_panel_add_item_opposite_image(params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
            }
            case 22082: {
                return this.makeTempObject(GameWorld.panel.game_panel_get_opposite_image_box(params[0]));
            }
            case 22083: {
                return GameWorld.panel.game_panel_point_in_box(params[0], params[1], (int[])this.followPointer(params[2])) ? 1 : 0;
            }
            case 22084: {
                if (GameWorld.panel == null) break;
                GameWorld.panel.game_panel_reg_point_item(params[0], params[1], params[2], params[3], params[4], params[5] == 1, params[6], params[7]);
                break;
            }
            case 22085: {
                if (GameWorld.panel == null) break;
                GameWorld.panel.game_panel_remove_point_item(params[0]);
                break;
            }
            case 22086: {
                GameWorld.panel.game_panel_set_point_item_effect(params[0], params[1] == 1);
                break;
            }
            case 22087: {
                GameWorld.panel.game_panel_clear_point_item();
                break;
            }
            case 22088: {
                return GameWorld.viewX;
            }
            case 22089: {
                return GameWorld.viewY;
            }
            case 22096: {
                if (GameWorld.gameView != null) {
                    return GameWorld.gameView.map.width;
                }
                return -1;
            }
            case 22097: {
                if (GameWorld.gameView != null) {
                    return GameWorld.gameView.map.height;
                }
                return -1;
            }
            case 22272: {
                return this.makeTempObject(Tool.mergeString2((Vector)this.followPointer(params[0])));
            }
            case 22295: {
                GContainer con = (GContainer)this.getGW(params[0]);
                if (con != null) {
                    GScrollBar sb = con.getScrollBar();
                    if (sb != null) {
                        return this.makeTempObject(sb.vmData);
                    }
                    return 0;
                }
                return 0;
            }
            case 22296: {
                GWidget gWidget = this.getGW(params[0]);
                if (gWidget != null && gWidget instanceof GContainer) {
                    return 1;
                }
                return 0;
            }
            case 22297: {
                GWidget gWidget = this.getGW(params[0]);
                if (gWidget != null && gWidget instanceof GWindow) {
                    return 1;
                }
                return 0;
            }
            case 22298: {
                GWidget gWidget = this.getGW(params[0]);
                if (gWidget != null) {
                    gWidget.getIntersect(gWidget.rect);
                    return this.makeTempObject(gWidget.rect);
                }
                return 0;
            }
            case 22299: {
                return (int)Tool.sqrt(params[0]);
            }
            case 22300: {
                return Math.abs(params[0]);
            }
            case 22301: {
                ((Graphics)this.followPointer(params[0])).fillTriangle(params[1], params[2], params[3], params[4], params[5], params[6]);
            }
            case 22302: {
                Graphics g = (Graphics)this.followPointer(params[0]);
                if (g != null) {
                    int[] clipRect = new int[]{g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight()};
                    return this.makeTempObject(clipRect);
                }
                return 0;
            }
            case 22303: {
                ((GContainer)this.getGW((int)params[0])).needScrollBar = params[1] == 1;
                break;
            }
            case 28672: {
                return VM.getApiVersion();
            }
            case 22304: {
                ImageSet _img = (ImageSet)this.followPointer(params[0]);
                Vector _frame = (Vector)this.followPointer(params[1]);
                Vector _transit = (Vector)this.followPointer(params[2]);
                Tool.drawWorldMap(_img, _frame, _transit, params[3], params[4], (Graphics)this.followPointer(params[5]));
                break;
            }
            case 22305: {
                ImageSet _img = (ImageSet)this.followPointer(params[0]);
                Vector _frame = (Vector)this.followPointer(params[1]);
                Vector _transit = (Vector)this.followPointer(params[2]);
                Tool.drawWorldMap(_img, _frame, _transit, params[3], params[4], params[5], params[6], params[7], params[8], (Graphics)this.followPointer(params[9]));
                break;
            }
            case 22307: {
                return this.makeTempObject(GameMain.resourceManager.findResource((String)this.followPointer(params[0])));
            }
            case 22352: {
                return ((Font)this.followPointer(params[0])).getHeight();
            }
            case 22353: {
                return ((Font)this.followPointer(params[1])).stringWidth((String)this.followPointer(params[0]));
            }
            case 22354: {
                String[] strSplit = Tool.splitString((String)this.followPointer(params[1]), params[3], (Font)this.followPointer(params[5]));
                for (int i = 0; i < strSplit.length; ++i) {
                    ((Graphics)this.followPointer(params[0])).drawString(strSplit[i], params[2], params[3] + ((Font)this.followPointer(params[5])).getHeight() * i, 20);
                }
                break;
            }
            case 22355: {
                return this.makeTempObject(Tool.formatText((String)this.followPointer(params[0]), params[1], (Font)this.followPointer(params[2])));
            }
            case 22356: {
                ((Graphics)this.followPointer(params[0])).setFont((Font)this.followPointer(params[1]));
                break;
            }
            case 22357: {
                return this.makeTempObject(Font.getFont((int)params[0], (int)params[1], (int)params[2]));
            }
            case 22358: {
                ((Graphics)this.followPointer(params[0])).setFont(Utilities.font);
                break;
            }
            case 22359: {
                this.getGW(params[0]).setFont((Font)this.followPointer(params[1]));
                break;
            }
            case 22360: {
                return this.makeTempObject(this.getGW(params[0]).getFont());
            }
            case 22361: {
                return this.makeTempObject(((Graphics)this.followPointer(params[1])).getFont());
            }
            case 22362: {
                return GameWorld.panel.game_panel_add_stringEx((String)this.followPointer(params[0]), params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8], params[9], (Font)this.followPointer(params[1]));
            }
            case 22372: {
                GameNpc sprite = GameWorld.findNpcById((byte)3, params[0]);
                if (sprite == null) break;
                sprite.vm_sprite_set_mini_map_image((String)this.followPointer(params[1]), params[2]);
                break;
            }
            case 22404: {
                Form f = (Form)this.followPointer(params[0]);
                f.append((String)this.followPointer(params[1]));
                break;
            }
            case 22405: {
                Form f = (Form)this.followPointer(params[0]);
                Item it = f.get(params[1]);
                if (it instanceof StringItem) {
                    StringItem si = (StringItem)it;
                    si.setText((String)this.followPointer(params[2]));
                    break;
                }
                if (it instanceof TextField) {
                    TextField tf = (TextField)it;
                    tf.setString((String)this.followPointer(params[2]));
                    break;
                }
                it.setLabel((String)this.followPointer(params[2]));
                break;
            }
            case 22406: {
                Form f = (Form)this.followPointer(params[0]);
                f.delete(params[1]);
                break;
            }
            case 22407: {
                Form form = (Form)this.followPointer(params[0]);
                Item it = form.get(params[1]);
                form.delete(params[1]);
                form.insert(params[2], it);
                break;
            }
            case 22386: {
                GameWorld.panel.game_panel_add_obtain_item2(params[0], params[1], params[2], (String)this.followPointer(params[3]), params[4], params[5], params[6], params[7]);
                break;
            }
            case 22388: {
                return this.makeTempObject(Tool.getIMEI());
            }
            case 24645: {
                break;
            }
            case 24647: {
                break;
            }
            case 24677: {
                GameNpc npc = GameNpc.createGameNpc((byte)params[0], params[1], params[2], params[3]);
                npc.setName((String)this.followPointer(params[4]));
                npc.sendCommand(10005, new Integer(npc.getInstanceId()));
                npc.sendCommand(10010, new Integer(npc.getInstanceId()));
                npc.sprite.setShow(true);
                int ret = this.makeTempObject(npc);
                return ret;
            }
            case 24678: {
                GameSprite gs = (GameSprite)this.followPointer(params[0]);
                gs.sprite.addBubble((String)this.followPointer(params[1]), params[2]);
                break;
            }
            case 24679: {
                if (GameWorld.player == null) break;
                GameWorld.player.searchNearestNpc();
                break;
            }
            case 24691: {
                return this.makeTempObject("");
            }
            case 24692: {
                return GameWorld.gameView.addDrawItem((PipAnimateSet)this.followPointer(params[0]), (ImageSet)this.followPointer(params[1]), params[2], params[3], params[4], params[5], params[6]);
            }
            case 24693: {
                GameWorld.gameView.removeDrawItem(params[0]);
                break;
            }
            case 24694: {
                GameWorld.gameView.clearDrawItem();
                break;
            }
            case 24704: {
                GameSprite gs = null;
                if (GameWorld.player != null) {
                    gs = GameWorld.player.selectNearestCreature();
                }
                return this.makeTempObject(gs);
            }
            case 24705: {
                GameMain.npcDownloadMode = params[0];
                break;
            }
            case 24876: {
                return GameWorld.panel.game_panel_add_item_hmessage_bar(params[0], params[1], params[2], params[3], params[4], params[5], params[6], (byte)params[7]);
            }
            case 24877: {
                GameIcon icon = (GameIcon)this.followPointer(params[0]);
                if (icon == null) break;
                icon.drawImageIcon((Graphics)this.followPointer(params[1]), params[2], params[3]);
                break;
            }
            case 24878: {
                return GameWorld.panel.getMessageCount(params[0]);
            }
            case 24879: {
                return this.makeTempObject(this.LoadFile((String)this.followPointer(params[0])));
            }
            case 24888: {
                Image image = Tool.processAlphaImage((Image)this.followPointer(params[0]), params[1]);
                return this.makeTempObject(image);
            }
            case 24889: {
                return GameMain.resourceManager.getCurUpdate();
            }
            case 24903: {
                break;
            }
            case 24904: {
                break;
            }
            case 24905: 
            case 24912: {
                break;
            }
            case 24914: {
                break;
            }
            case 25105: {
                break;
            }
        }
        return 0;
    }

    public static int getApiVersion() {
        return 31;
    }

    public static int getNextRnd(int min, int max) {
        if (max <= min) {
            return min;
        }
        return min + Math.abs(Tool.rnd.nextInt()) % (max - min);
    }

    protected boolean KeyPressed(byte keyCode, byte clear) {
        return Utilities.isKeyPressed(keyCode, clear != 0);
    }

    protected boolean NoKeyPressed() {
        return !Utilities.isAnyKeyPressed();
    }

    protected void FillRect(Graphics g, int x, int y, int width, int height) {
        g.fillRect(x, y, width, height);
    }

    protected void DrawCircle(Graphics g, int x, int y, int r) {
        g.drawArc(x - r, y - r, r * 2, r * 2, 0, 360);
    }

    public static void DrawString(Graphics g, String text, int x, int y, int anchor) {
        g.drawString(text, x, y, anchor);
    }

    protected void SetColor(Graphics g, int color) {
        g.setColor(color);
    }

    protected void DrawRect(Graphics g, int x, int y, int width, int height) {
        g.drawRect(x, y, width, height);
    }

    protected void SetClip(Graphics g, int x, int y, int width, int height) {
        g.setClip(x, y, width, height);
    }

    protected void FillArc(Graphics g, int x, int y, int width, int height, int sa, int ea) {
        g.fillArc(x, y, width, height, sa, ea);
    }

    protected int GetScreenWidth() {
        return GameMain.viewWidth;
    }

    protected int GetScreenHeight() {
        return GameMain.viewHeight;
    }

    protected int Length(Object o) {
        if (o instanceof boolean[]) {
            return ((boolean[])o).length;
        }
        if (o instanceof byte[]) {
            return ((byte[])o).length;
        }
        if (o instanceof short[]) {
            return ((short[])o).length;
        }
        if (o instanceof int[]) {
            return ((int[])o).length;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length;
        }
        if (o == null) {
            return 0;
        }
        return 1;
    }

    protected byte[] LoadFile(String name) {
        return Tool.loadLocalResource(name);
    }

    public void commandAction(Command cmd, Displayable d) {
        this.lastFormSelection = cmd.getLabel();
        GameMain.display.setCurrent((Displayable)GameMain.instance);
        if (this.isBlock()) {
            this.continueProcess(1);
        }
    }

    public static byte[] loadRMSFile(String dbName) {
        return Tool.getData(dbName, (byte)0);
    }

    public static boolean saveRMSFile(String dbName, byte[] data) {
        return Tool.saveData(dbName, data, (byte)0);
    }

    private void deleteRMSFile(String dbName) {
        Tool.deleteRMSFile(dbName);
    }

    private GWidget getGW(int gWidgetAdrr) {
        int[] gWidget = (int[])this.followPointer(gWidgetAdrr);
        if (gWidget != null) {
            return VMGame.getGWidget(gWidget[29]);
        }
        return null;
    }
}

