/*
 * Decompiled with CFR 0.152.
 */
package com.pip.ui;

import com.pip.common.Tool;
import com.pip.sanguo.GameMain;
import com.pip.ui.Quest;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import com.pip.util.SortHashtable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;

public class DebugVM
extends VM
implements Runnable {
    public static final int COMMAND_INTERRUPT = 0;
    public static final int COMMAND_INFO = 1;
    public static final int COMMAND_QUERY = 2;
    public static final int COMMAND_MODECHANGE = 3;
    public static final int COMMAND_ADDBREAKPOINT = 4;
    public static final int COMMAND_DELBREAKPOINT = 5;
    public static final int COMMAND_REQUESTTRACE = 6;
    public static final int COMMAND_TRACE = 7;
    public static final int COMMAND_HEAP = 8;
    public static final int COMMAND_ALLOCTRACE = 9;
    public static final int COMMAND_SYNCSTATE = 10;
    public static final int COMMAND_STATE = 11;
    public static final int COMMAND_FUNC_REPORT = 15;
    public static final int COMMAND_MODIFY = 16;
    private int execCounter = 0;
    public static final int TOKEN = 305419896;
    public static final int MODE_RUN = 0;
    public static final int MODE_STEP = 1;
    public static final int MODE_STEPOVER = 2;
    public static final int MODE_STEPOUT = 3;
    private int debugMode = 1;
    private int stepStartVM;
    private int stepStartFunc;
    private int stepStartStackBase;
    private static int execFuncCount = 0;
    private static int execFuncMaxCountSecond = 0;
    private static long execFuncMaxCountUpdateTime = Tool.getSystemTime();
    private static int statMillis = 3000;
    private static boolean printInstructionTable = false;
    private static Hashtable instructionTable = new Hashtable();
    private static Hashtable instructionMillTable = new Hashtable();
    private static long instructionMillTime = Tool.getSystemTime();
    private static long startTime = Tool.getSystemTime();
    private static Vector instructionList = new Vector();
    private static int instructionTick = -1;
    private static boolean printInstructionList = false;
    private static Hashtable instructionConst = new Hashtable();
    private static int dynamicHeapSize;
    private Vector breakPoints = new Vector();
    private Hashtable allocTrace = new Hashtable();
    SocketConnection connection;
    DataOutputStream dos;
    DataInputStream dis;
    private int procCounter;
    private int syscallCounter;
    private int[] syscallParams = new int[20];

    public DebugVM(VMGame vmGame) {
        super(vmGame);
    }

    public void init(byte[] etfContent, byte[] etdContent) throws Exception {
        this.init(etfContent);
        this.allocTrace = new Hashtable();
        try {
            this.connection = (SocketConnection)Connector.open((String)"socket://127.0.0.1:32167");
            this.dos = this.connection.openDataOutputStream();
            this.dis = this.connection.openDataInputStream();
            this.dos.writeInt(etfContent.length);
            this.dos.write(etfContent);
            this.dos.writeInt(etdContent.length);
            this.dos.write(etdContent);
            this.dis.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread(this).start();
    }

    protected int heapAlloc() {
        int ret = super.heapAlloc();
        this.allocTrace.put(new Integer(ret), this.getCurrentTrace());
        ++dynamicHeapSize;
        return ret;
    }

    protected void heapFree(int addr) {
        this.allocTrace.remove(new Integer(addr));
        if ((addr & 0xFFF) < this.tempSpace) {
            return;
        }
        int head = this.freeHead;
        do {
            if (head != addr) continue;
            throw new RuntimeException("\u9519\u8bef\uff1a\u8bd5\u56fe\u91cd\u590dfree\u4e00\u4e2a\u5185\u5b58\u5355\u5143\u3002");
        } while ((head = this.freeSpaceList[head]) != this.freeHead);
        this.dynamicHeap[addr] = null;
        short tmp = this.freeSpaceList[this.freeHead];
        this.freeSpaceList[this.freeHead] = (short)addr;
        this.freeSpaceList[addr] = tmp;
        --dynamicHeapSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.connection != null) {
            try {
                int i;
                int li;
                int token = this.dis.readInt();
                if (token != 305419896) continue;
                int cmdType = this.dis.readInt();
                if (cmdType == 0) {
                    int result = this.dis.readInt();
                    DebugVM debugVM = this;
                    synchronized (debugVM) {
                        this.notifyAll();
                        continue;
                    }
                }
                if (cmdType == 2) {
                    int address = this.dis.readInt();
                    int value = this.memLoad(address);
                    String info = String.valueOf(value);
                    if ((address & 0x40000000) != 0) {
                        Object obj = this.followPointer(value);
                        info = this.printObject(obj);
                    }
                    DebugVM debugVM = this;
                    synchronized (debugVM) {
                        this.dos.writeInt(305419896);
                        this.dos.writeInt(1);
                        this.dos.writeUTF(info);
                        continue;
                    }
                }
                if (cmdType == 3) {
                    this.debugMode = this.dis.readInt();
                    if (this.debugMode != 2 && this.debugMode != 3) continue;
                    this.stepStartVM = this.currentVM;
                    this.stepStartFunc = this.currentFunc;
                    this.stepStartStackBase = this.stackBase;
                    continue;
                }
                if (cmdType == 4) {
                    BreakPoint p = new BreakPoint();
                    p.funcID = this.dis.readInt();
                    int ff = p.funcID & 0xFFF;
                    li = p.funcID >> 12 & 0xF;
                    p.start = this.dis.readInt() + this.libraries[li].functions[ff * 3 + 1];
                    p.end = this.dis.readInt() + this.libraries[li].functions[ff * 3 + 1];
                    if (this.breakPoints.indexOf(p) != -1) continue;
                    this.breakPoints.addElement(p);
                    continue;
                }
                if (cmdType == 5) {
                    BreakPoint p = new BreakPoint();
                    p.funcID = this.dis.readInt();
                    int ff = p.funcID & 0xFFF;
                    li = p.funcID >> 12 & 0xF;
                    p.start = this.dis.readInt() + this.libraries[li].functions[ff * 3 + 1];
                    p.end = this.dis.readInt() + this.libraries[li].functions[ff * 3 + 1];
                    this.breakPoints.removeElement(p);
                    continue;
                }
                if (cmdType == 6) {
                    if (this.currentFunc == -1) continue;
                    int[][] trace = this.getCurrentTrace();
                    DebugVM ff = this;
                    synchronized (ff) {
                        this.dos.writeInt(305419896);
                        this.dos.writeInt(7);
                        this.dos.writeInt(trace.length);
                        for (i = 0; i < trace.length; ++i) {
                            this.dos.writeInt(trace[i][0]);
                            this.dos.writeInt(trace[i][1]);
                        }
                        continue;
                    }
                }
                if (cmdType == 8) {
                    boolean[] flag = new boolean[this.dynamicHeap.length];
                    for (int i2 = 0; i2 < flag.length; ++i2) {
                        flag[i2] = true;
                    }
                    int head = this.freeHead;
                    while (this.freeSpaceList[head] != this.freeHead) {
                        head = this.freeSpaceList[head];
                        flag[head] = false;
                    }
                    this.dos.writeInt(305419896);
                    this.dos.writeInt(8);
                    this.dos.writeInt(this.dynamicHeap.length);
                    for (i = 0; i < this.dynamicHeap.length; ++i) {
                        this.dos.writeBoolean(flag[i]);
                        this.dos.writeUTF(this.printObject(this.dynamicHeap[i]));
                    }
                    continue;
                }
                if (cmdType == 9) {
                    int addr = this.dis.readInt();
                    int[][] trace = (int[][])this.allocTrace.get(new Integer(addr));
                    if (trace == null) continue;
                    this.dos.writeInt(305419896);
                    this.dos.writeInt(9);
                    this.dos.writeInt(trace.length);
                    for (i = 0; i < trace.length; ++i) {
                        this.dos.writeInt(trace[i][0]);
                        this.dos.writeInt(trace[i][1]);
                    }
                    continue;
                }
                if (cmdType == 10) {
                    this.dos.writeInt(305419896);
                    this.dos.writeInt(11);
                    this.writeState(this.dos);
                    continue;
                }
                if (cmdType != 16) continue;
                int op = this.dis.readInt();
                switch (op) {
                    case 0: {
                        this.modifyInt(this.dis.readInt(), this.dis.readInt());
                        break;
                    }
                    case 1: {
                        this.modifyIntMember(this.dis.readInt(), this.dis.readInt(), this.dis.readInt());
                        break;
                    }
                    case 2: {
                        this.modifyString(this.dis.readInt(), this.dis.readUTF());
                    }
                }
            }
            catch (IOException e) {
                this.closeConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void writeState(DataOutputStream dos) throws IOException {
        int i;
        dos.writeInt(this.staticHeap.length);
        for (i = 0; i < this.staticHeap.length; ++i) {
            dos.writeInt(this.staticHeap[i]);
        }
        dos.writeInt(this.stack.length);
        for (i = 0; i < this.stack.length; ++i) {
            dos.writeInt(this.stack[i]);
        }
        dos.writeInt(this.esp);
        dos.writeInt(this.stackBase);
        boolean[] flag = new boolean[this.dynamicHeap.length];
        for (int i2 = 0; i2 < flag.length; ++i2) {
            flag[i2] = true;
        }
        int head = this.freeHead;
        while (this.freeSpaceList[head] != this.freeHead) {
            head = this.freeSpaceList[head];
            flag[head] = false;
        }
        dos.writeInt(this.dynamicHeap.length);
        for (int i3 = 0; i3 < this.dynamicHeap.length; ++i3) {
            dos.writeBoolean(flag[i3]);
            this.dumpObject(dos, this.dynamicHeap[i3]);
        }
    }

    private void dumpObject(DataOutputStream dos, Object obj) throws IOException {
        if (obj == null) {
            dos.writeByte(255);
        } else if (obj instanceof boolean[]) {
            boolean[] arr = (boolean[])obj;
            dos.writeByte(1);
            dos.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                dos.writeBoolean(arr[i]);
            }
        } else if (obj instanceof byte[]) {
            byte[] arr = (byte[])obj;
            dos.writeByte(2);
            dos.writeInt(arr.length);
            dos.write(arr);
        } else if (obj instanceof short[]) {
            short[] arr = (short[])obj;
            dos.writeByte(3);
            dos.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                dos.writeShort(arr[i]);
            }
        } else if (obj instanceof int[]) {
            int[] arr = (int[])obj;
            dos.writeByte(4);
            dos.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                dos.writeInt(arr[i]);
            }
        } else if (obj instanceof String) {
            dos.writeByte(5);
            dos.writeUTF((String)obj);
        } else if (obj instanceof String[]) {
            String[] arr = (String[])obj;
            dos.writeByte(6);
            dos.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                this.dumpObject(dos, arr[i]);
            }
        } else if (obj instanceof Hashtable) {
            Hashtable table = (Hashtable)obj;
            dos.writeByte(7);
            dos.writeInt(table.size());
            Enumeration ee = ((Hashtable)obj).keys();
            while (ee.hasMoreElements()) {
                Object key = ee.nextElement();
                Object value = ((Hashtable)obj).get(key);
                this.dumpObject(dos, key);
                this.dumpObject(dos, value);
            }
        } else if (obj instanceof SortHashtable) {
            SortHashtable table = (SortHashtable)obj;
            dos.writeByte(7);
            dos.writeInt(table.size());
            Object[] keys = ((SortHashtable)obj).keys();
            Object[] values = ((SortHashtable)obj).values();
            int _count = keys.length;
            for (int i = 0; i < _count; ++i) {
                this.dumpObject(dos, keys[i]);
                this.dumpObject(dos, values[i]);
            }
        } else if (obj instanceof Vector) {
            Vector v = (Vector)obj;
            dos.writeByte(8);
            dos.writeInt(v.size());
            for (int i = 0; i < v.size(); ++i) {
                this.dumpObject(dos, v.elementAt(i));
            }
        } else if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            dos.writeByte(9);
            dos.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                this.dumpObject(dos, arr[i]);
            }
        } else {
            dos.writeByte(10);
            dos.writeUTF(String.valueOf(obj));
        }
    }

    private int[][] getCurrentTrace() {
        Vector<int[]> ret = new Vector<int[]>();
        int thisVM = this.currentVM;
        int thisFunc = this.currentFunc;
        int thisEip = this.eip - this.libraries[thisVM].functions[thisFunc * 3 + 1];
        int thisStackBase = this.stackBase;
        ret.addElement(new int[]{(thisVM << 12) + thisFunc, thisEip});
        for (int i = 0; i < this.callCount; ++i) {
            int parCount = this.libraries[thisVM].functions[thisFunc * 3] >> 16;
            int localParamCount = this.libraries[thisVM].functions[thisFunc * 3] & 0xFFFF;
            int pos = thisStackBase + parCount + localParamCount;
            thisStackBase = this.stack[pos];
            thisVM = this.stack[pos + 1];
            thisFunc = this.stack[pos + 2];
            thisEip = this.stack[pos + 3] - 4 - this.libraries[thisVM].functions[thisFunc * 3 + 1];
            ret.addElement(new int[]{(thisVM << 12) + thisFunc, thisEip});
        }
        int[][] ret1 = new int[ret.size()][];
        for (int i = 0; i < ret1.length; ++i) {
            ret1[i] = (int[])ret.elementAt(i);
        }
        return ret1;
    }

    private String printObject(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof boolean[]) {
            return this.printBooleans((boolean[])o);
        }
        if (o instanceof byte[]) {
            return this.printBytes((byte[])o);
        }
        if (o instanceof short[]) {
            return this.printShorts((short[])o);
        }
        if (o instanceof int[]) {
            return this.printInts((int[])o);
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Integer) {
            return o.toString();
        }
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            Object[] arr = new Object[v.size()];
            v.copyInto(arr);
            return this.printObjects(arr);
        }
        if (o instanceof Object[]) {
            return this.printObjects((Object[])o);
        }
        if (o instanceof Hashtable) {
            return this.printHashtable((Hashtable)o);
        }
        return o.getClass().getName() + ": " + o.toString();
    }

    private String printBooleans(boolean[] arr) {
        StringBuffer buf = new StringBuffer();
        buf.append("boolean[] {");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(arr[i]);
        }
        buf.append(" }");
        return buf.toString();
    }

    private String printBytes(byte[] arr) {
        StringBuffer buf = new StringBuffer();
        buf.append("byte[] {");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("0x");
            buf.append(Integer.toHexString(arr[i] & 0xFF));
        }
        buf.append(" }");
        return buf.toString();
    }

    private String printShorts(short[] arr) {
        StringBuffer buf = new StringBuffer();
        buf.append("short[] {");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(arr[i]);
        }
        buf.append(" }");
        return buf.toString();
    }

    private String printInts(int[] arr) {
        StringBuffer buf = new StringBuffer();
        buf.append("int[] {");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(arr[i]);
        }
        buf.append(" }");
        return buf.toString();
    }

    private String printObjects(Object[] arr) {
        StringBuffer buf = new StringBuffer();
        buf.append("Object[] {");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(this.printObject(arr[i]));
        }
        buf.append("\n}");
        return buf.toString();
    }

    private String printHashtable(Hashtable t) {
        Enumeration enum1 = t.keys();
        StringBuffer buf = new StringBuffer();
        buf.append("Hashtable[] {");
        int i = 0;
        while (enum1.hasMoreElements()) {
            Object key = enum1.nextElement();
            Object value = t.get(key);
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(this.printObject(key));
            buf.append(" = ");
            buf.append(this.printObject(value));
            ++i;
        }
        buf.append("\n}");
        return buf.toString();
    }

    private void closeConnection() {
        try {
            this.dis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.dis = null;
        try {
            this.dos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.dos = null;
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = null;
    }

    public void destroy() {
        dynamicHeapSize -= this.allocTrace.size();
        super.destroy();
        this.breakPoints.removeAllElements();
        this.debugMode = 1;
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateInterrupt(int code) throws Exception {
        if (this.dos != null) {
            DebugVM debugVM = this;
            synchronized (debugVM) {
                this.dos.writeInt(305419896);
                this.dos.writeInt(0);
                this.dos.writeInt(code);
                this.dos.writeInt(this.eip - this.libraries[this.currentVM].functions[this.currentFunc * 3 + 1]);
                this.dos.writeInt((this.currentVM << 12) + this.currentFunc);
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportEnterFunc(int funcID) throws Exception {
        if (this.dos != null) {
            DebugVM debugVM = this;
            synchronized (debugVM) {
                this.dos.writeInt(305419896);
                this.dos.writeInt(15);
                this.dos.writeBoolean(true);
                this.dos.writeInt(funcID);
                this.dos.writeInt(this.execCounter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportExitFunc(int funcID) throws Exception {
        if (this.dos != null) {
            DebugVM debugVM = this;
            synchronized (debugVM) {
                this.dos.writeInt(305419896);
                this.dos.writeInt(15);
                this.dos.writeBoolean(false);
                this.dos.writeInt(funcID);
                this.dos.writeInt(this.execCounter);
            }
        }
    }

    private boolean isBreakPoint(int funcID, int ip) {
        for (int i = 0; i < this.breakPoints.size(); ++i) {
            BreakPoint p = (BreakPoint)this.breakPoints.elementAt(i);
            if (p.funcID != funcID || ip < p.start || ip >= p.end) continue;
            return true;
        }
        return false;
    }

    private int getHeapFree() {
        int heapFreeCount = 0;
        int temp = this.freeHead;
        while (this.freeSpaceList[temp] != this.freeHead) {
            temp = this.freeSpaceList[temp];
            ++heapFreeCount;
        }
        return heapFreeCount;
    }

    protected void resume() {
        this.blocked = false;
        if (this.blockPosition != null) {
            int[] bp = this.blockPosition;
            this.blockPosition = null;
            this.restoreStack(bp);
            try {
                this.processInst(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.generateInterrupt(7);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.eip = this.libraries[this.currentVM].functions[this.funcBase + 1];
                int parCount = this.libraries[this.currentVM].functions[this.funcBase] >> 16;
                int localParamCount = this.libraries[this.currentVM].functions[this.funcBase] & 0xFFFF;
                this.esp = this.stackBase + parCount + localParamCount + 3 - 1;
                for (int ii = 0; ii < localParamCount; ++ii) {
                    this.stack[this.esp - 3 - ii] = 0;
                }
            }
        }
    }

    public void processInst(boolean ignoreBlock) throws Exception {
        int[] functions = this.libraries[this.currentVM].functions;
        byte[] codeData = this.libraries[this.currentVM].codeData;
        int eipmax = functions[this.funcBase + 2];
        block66: while (this.eip < eipmax) {
            if (!ignoreBlock && this.blocked) {
                this.blockPosition = this.saveStack();
                break;
            }
            boolean inted = false;
            if (!inted && (this.debugMode == 1 || this.isBreakPoint((this.currentVM << 12) + this.currentFunc, this.eip))) {
                this.generateInterrupt(3);
                inted = true;
            }
            if (!inted && this.debugMode == 2) {
                boolean needBreak = false;
                if (this.currentVM == this.stepStartVM && this.currentFunc == this.stepStartFunc && this.stackBase == this.stepStartStackBase) {
                    needBreak = true;
                } else if (this.stackBase < this.stepStartStackBase) {
                    needBreak = true;
                }
                if (needBreak) {
                    this.generateInterrupt(4);
                    inted = true;
                }
            }
            if (!inted && this.debugMode == 3 && this.stackBase < this.stepStartStackBase) {
                this.generateInterrupt(4);
                inted = true;
            }
            byte inst = codeData[this.eip];
            DebugVM.statInstruction(inst);
            ++this.procCounter;
            ++this.execCounter;
            switch (inst) {
                case 1: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] + this.stack[this.esp];
                    break;
                }
                case 2: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] - this.stack[this.esp];
                    break;
                }
                case 3: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] * this.stack[this.esp];
                    break;
                }
                case 4: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] / this.stack[this.esp];
                    break;
                }
                case 5: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] % this.stack[this.esp];
                    break;
                }
                case 6: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] != 0 && this.stack[this.esp] != 0 ? 1 : 0;
                    break;
                }
                case 7: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] != 0 || this.stack[this.esp] != 0 ? 1 : 0;
                    break;
                }
                case 8: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] & this.stack[this.esp];
                    break;
                }
                case 9: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] | this.stack[this.esp];
                    break;
                }
                case 10: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] << this.stack[this.esp];
                    break;
                }
                case 11: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] >> this.stack[this.esp];
                    break;
                }
                case 12: {
                    int n = Tool.getInt(codeData, this.eip + 1);
                    this.staticHeap[n] = this.staticHeap[n] + 1;
                    if (this.ownerType != 2) break;
                    Tool.sendSyncVMVarialbe(((Quest)this.owner).id, Tool.getInt(codeData, this.eip + 1), this.staticHeap[Tool.getInt(codeData, this.eip + 1)]);
                    break;
                }
                case 13: {
                    this.stack[this.esp + 1] = this.staticHeap[Tool.getInt(codeData, this.eip + 1)] + codeData[this.eip + 5];
                    break;
                }
                case 14: {
                    this.stack[this.esp + 1] = this.staticHeap[Tool.getInt(codeData, this.eip + 1)] - codeData[this.eip + 5];
                    break;
                }
                case 24: {
                    int n = this.stackBase + Tool.getInt(codeData, this.eip + 1);
                    this.stack[n] = this.stack[n] + 1;
                    break;
                }
                case 25: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)] + codeData[this.eip + 5];
                    break;
                }
                case 26: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)] - codeData[this.eip + 5];
                    break;
                }
                case 17: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] == this.stack[this.esp] ? 1 : 0;
                    break;
                }
                case 18: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] > this.stack[this.esp] ? 1 : 0;
                    break;
                }
                case 19: {
                    this.stack[this.esp - 1] = this.stack[this.esp - 1] < this.stack[this.esp] ? 1 : 0;
                    break;
                }
                case 20: {
                    this.stack[this.esp] = this.stack[this.esp] == codeData[this.eip + 1] ? 1 : 0;
                    break;
                }
                case 21: {
                    this.stack[this.esp] = this.stack[this.esp] > codeData[this.eip + 1] ? 1 : 0;
                    break;
                }
                case 22: {
                    this.stack[this.esp] = this.stack[this.esp] < codeData[this.eip + 1] ? 1 : 0;
                    break;
                }
                case 23: {
                    this.stack[this.esp] = this.stack[this.esp] == codeData[this.eip + 1] ? 0 : 1;
                    break;
                }
                case 33: {
                    this.eip = functions[this.funcBase + 1] + (Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    continue block66;
                }
                case 34: {
                    if (this.stack[this.esp] == 0) break;
                    this.eip = functions[this.funcBase + 1] + (Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    --this.esp;
                    continue block66;
                }
                case 35: {
                    if (this.stack[this.esp] != 0) break;
                    this.eip = functions[this.funcBase + 1] + (Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    --this.esp;
                    continue block66;
                }
                case 36: 
                case 46: {
                    int callFunc;
                    int parCount = codeData[this.eip + 1] & 0xFF;
                    if (inst == 36) {
                        callFunc = Tool.getShort(codeData, this.eip + 2) & 0xFFFF;
                    } else {
                        callFunc = this.stack[this.esp] & 0xFFFF;
                        --this.esp;
                    }
                    int callVM = 0;
                    if ((callFunc & 0xF000) != 0) {
                        callVM = (callFunc & 0xF000) >> 12;
                        if (this.currentVM != 0 && inst == 36) {
                            VM nextVM = this.libraries[this.currentVM].libraries[callVM];
                            for (int i = 0; i < this.libraries.length; ++i) {
                                if (nextVM != this.libraries[i]) continue;
                                callVM = i;
                                break;
                            }
                        }
                        functions = this.libraries[callVM].functions;
                        codeData = this.libraries[callVM].codeData;
                        callFunc &= 0xFFF;
                    } else if (inst == 36) {
                        callVM = this.currentVM;
                    } else {
                        callVM = 0;
                        functions = this.libraries[callVM].functions;
                        codeData = this.libraries[callVM].codeData;
                    }
                    int newStackBase = this.esp - parCount + 1;
                    int localParamCount = functions[callFunc * 3] & 0xFFFF;
                    for (int ii = this.esp + 1; ii <= this.esp + localParamCount; ++ii) {
                        this.stack[ii] = 0;
                    }
                    this.esp += localParamCount;
                    this.stack[this.esp + 1] = this.stackBase;
                    this.stack[this.esp + 2] = this.currentVM;
                    this.stack[this.esp + 3] = this.currentFunc;
                    this.stack[this.esp + 4] = inst == 36 ? this.eip + 4 : this.eip + 2;
                    this.esp += 4;
                    this.stackBase = newStackBase;
                    this.currentVM = callVM;
                    ++this.callCount;
                    this.currentFunc = callFunc;
                    this.funcBase = this.currentFunc * 3;
                    this.eip = functions[this.funcBase + 1];
                    eipmax = functions[this.funcBase + 2];
                    this.reportEnterFunc(this.currentFunc | this.currentVM << 12);
                    continue block66;
                }
                case 37: {
                    this.reportExitFunc(this.currentFunc | this.currentVM << 12);
                    if (this.callCount == 0) {
                        return;
                    }
                    int parCount = functions[this.funcBase] >> 16;
                    int localParamCount = functions[this.funcBase] & 0xFFFF;
                    int rightesp = this.stackBase + parCount + localParamCount + 4 - 1;
                    if (this.esp != rightesp) {
                        throw new Exception("\u4ece\u51fd\u6570\u8fd4\u56de\u65f6\u6808\u4e0d\u4e3a\u7a7a\uff0c\u51fd\u6570ID\uff1a" + this.currentFunc);
                    }
                    this.eip = this.stack[this.esp];
                    this.currentFunc = this.stack[this.esp - 1];
                    this.currentVM = this.stack[this.esp - 2];
                    functions = this.libraries[this.currentVM].functions;
                    codeData = this.libraries[this.currentVM].codeData;
                    int newStackBase = this.stackBase;
                    this.stackBase = this.stack[this.esp - 3];
                    --this.callCount;
                    this.esp = newStackBase - 1;
                    this.funcBase = this.currentFunc * 3;
                    eipmax = functions[this.funcBase + 2];
                    continue block66;
                }
                case 38: {
                    this.reportExitFunc(this.currentFunc | this.currentVM << 12);
                    if (this.callCount == 0) {
                        return;
                    }
                    int parCount = functions[this.funcBase] >> 16;
                    int localParamCount = functions[this.funcBase] & 0xFFFF;
                    int rightesp = this.stackBase + parCount + localParamCount + 4;
                    if (this.esp != rightesp) {
                        throw new Exception("\u4ece\u51fd\u6570\u8fd4\u56de\u65f6\u6808\u4e0d\u4e3a\u7a7a\uff0c\u51fd\u6570ID\uff1a" + this.currentFunc);
                    }
                    int retValue = this.stack[this.esp];
                    this.eip = this.stack[this.esp - 1];
                    this.currentFunc = this.stack[this.esp - 2];
                    this.currentVM = this.stack[this.esp - 3];
                    functions = this.libraries[this.currentVM].functions;
                    codeData = this.libraries[this.currentVM].codeData;
                    int newStackBase = this.stackBase;
                    this.stackBase = this.stack[this.esp - 4];
                    --this.callCount;
                    this.esp = newStackBase;
                    this.stack[this.esp] = retValue;
                    this.funcBase = this.currentFunc * 3;
                    eipmax = functions[this.funcBase + 2];
                    continue block66;
                }
                case 39: 
                case 70: {
                    boolean hasRet;
                    ++this.syscallCounter;
                    short callFunc = Tool.getShort(codeData, this.eip + 1);
                    int parCount = codeData[this.eip + 3] & 0xFF;
                    boolean bl = hasRet = codeData[this.eip + 4] == 1;
                    if (this.syscallParams.length < parCount) {
                        this.syscallParams = new int[parCount];
                    }
                    System.arraycopy(this.stack, this.esp - parCount + 1, this.syscallParams, 0, parCount);
                    this.esp -= parCount;
                    int ret = this.syscall(callFunc, this.syscallParams);
                    if (!hasRet) break;
                    if (inst == 70) {
                        this.stack[this.stackBase + Tool.getInt((byte[])codeData, (int)(this.eip + 5))] = ret;
                        break;
                    }
                    this.stack[this.esp + 1] = ret;
                    ++this.esp;
                    break;
                }
                case 44: {
                    int off;
                    int first = Tool.getInt(codeData, this.eip + 3);
                    int last = Tool.getInt(codeData, this.eip + 7);
                    int cond = this.stack[this.esp];
                    int instLen = 11 + 2 * (last - first + 1);
                    this.eip = cond >= first && cond <= last ? ((off = Tool.getShort(codeData, this.eip + 11 + (cond - first) * 2) & 0xFFFF) == 65535 ? (this.eip += Tool.getShort(codeData, this.eip + 1) & 0xFFFF) : (this.eip += off)) : (this.eip += Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    this.eip += instLen;
                    break;
                }
                case 45: {
                    short switchCount = Tool.getShort(codeData, this.eip + 3);
                    byte condBytes = codeData[this.eip + 5];
                    int cond = this.stack[this.esp];
                    int instLen = 6 + switchCount * (condBytes + 2);
                    int addr = this.searchTable(codeData, this.eip + 6, switchCount, condBytes, cond);
                    this.eip = addr >= 0 ? (this.eip += addr) : (this.eip += Tool.getShort(codeData, this.eip + 1) & 0xFFFF);
                    this.eip += instLen;
                    break;
                }
                case 49: {
                    this.stack[this.esp] = this.memLoad(this.stack[this.esp]);
                    break;
                }
                case 50: {
                    this.memSave(this.stack[this.esp], this.stack[this.esp - 1]);
                    break;
                }
                case 61: {
                    this.stack[this.esp + 1] = this.staticHeap[Tool.getInt(codeData, this.eip + 1)];
                    break;
                }
                case 62: {
                    this.staticHeap[Tool.getInt((byte[])codeData, (int)(this.eip + 1))] = this.stack[this.esp];
                    if (this.ownerType != 2) break;
                    Tool.sendSyncVMVarialbe(((Quest)this.owner).id, Tool.getInt(codeData, this.eip + 1), this.stack[this.esp]);
                    break;
                }
                case 27: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    break;
                }
                case 28: {
                    this.stack[this.stackBase + Tool.getInt((byte[])codeData, (int)(this.eip + 1))] = this.stack[this.esp];
                    break;
                }
                case 29: {
                    this.stack[this.esp + 1] = this.stack[this.esp - codeData[this.eip + 1]];
                    break;
                }
                case 53: {
                    this.stack[this.esp + 1] = codeData[this.eip + 1];
                    break;
                }
                case 52: {
                    this.stack[this.esp + 1] = Tool.getShort(codeData, this.eip + 1);
                    break;
                }
                case 51: {
                    this.stack[this.esp + 1] = Tool.getInt(codeData, this.eip + 1);
                    break;
                }
                case 54: {
                    this.stack[this.esp - 1] = this.arrLoad(this.stack[this.esp - 1], this.stack[this.esp]);
                    break;
                }
                case 55: {
                    this.arrSave(this.stack[this.esp - 1], this.stack[this.esp], this.stack[this.esp - 2]);
                    break;
                }
                case 40: {
                    this.stack[this.esp] = this.arrLoad(this.stack[this.esp], codeData[this.eip + 1]);
                    break;
                }
                case 41: {
                    this.arrSave(this.stack[this.esp], codeData[this.eip + 1], this.stack[this.esp - 1]);
                    break;
                }
                case 56: {
                    this.stack[this.esp] = this.alloc(codeData[this.eip + 1], this.stack[this.esp]);
                    break;
                }
                case 57: {
                    this.free(this.stack[this.esp]);
                    break;
                }
                case 58: {
                    this.stack[this.esp + 1] = this.makeTempObject(new int[Tool.getShort(codeData, this.eip + 1)]);
                    break;
                }
                case 59: {
                    int[] arr = (int[])this.followPointer(this.stack[this.esp - 1]);
                    this.stack[this.esp - 1] = arr[this.stack[this.esp] & 0x3FFFFFFF];
                    break;
                }
                case 60: {
                    int saveValue;
                    int[] arr = (int[])this.followPointer(this.stack[this.esp - 1]);
                    int memberAddr = this.stack[this.esp];
                    arr[memberAddr & 0x3FFFFFFF] = saveValue = this.stack[this.esp - 2];
                    break;
                }
                case 42: {
                    int[] arr = (int[])this.followPointer(this.stack[this.esp]);
                    this.stack[this.esp] = arr[codeData[this.eip + 1]];
                    break;
                }
                case 43: {
                    int saveValue;
                    int[] arr = (int[])this.followPointer(this.stack[this.esp]);
                    byte memberAddr = codeData[this.eip + 1];
                    arr[memberAddr & 0x3FFFFFFF] = saveValue = this.stack[this.esp - 1];
                    break;
                }
                case 63: {
                    short funcID = Tool.getShort(codeData, this.eip + 1);
                    if (this.currentVM != 0) {
                        int callVM = (funcID & 0xF000) >> 12;
                        VM nextVM = this.libraries[this.currentVM].libraries[callVM];
                        for (int i = 0; i < this.libraries.length; ++i) {
                            if (nextVM != this.libraries[i]) continue;
                            callVM = i;
                            break;
                        }
                        funcID = (short)(funcID & 0xFFF | callVM << 12);
                    }
                    this.stack[this.esp + 1] = funcID;
                    break;
                }
                case 65: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp + 2] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 5)];
                    this.stack[this.esp + 3] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 9)];
                    break;
                }
                case 66: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp + 2] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 5)];
                    break;
                }
                case 67: {
                    this.stack[this.esp + 1] = codeData[this.eip + 1];
                    this.stack[this.esp + 2] = codeData[this.eip + 2];
                    break;
                }
                case 68: {
                    this.stack[this.esp + 1] = codeData[this.eip + 1];
                    this.stack[this.esp + 2] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 2)];
                    break;
                }
                case 69: {
                    this.stack[this.esp + 1] = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp + 2] = codeData[this.eip + 5];
                    break;
                }
                case 71: {
                    int ptr = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    int[] arr = (int[])this.followPointer(ptr);
                    this.stack[this.esp + 1] = arr[codeData[this.eip + 5]];
                    break;
                }
                case 72: {
                    this.stack[this.esp + 1] = codeData[this.eip + 1];
                    int ptr = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 2)];
                    int[] arr = (int[])this.followPointer(ptr);
                    this.stack[this.esp + 2] = arr[codeData[this.eip + 6]];
                    break;
                }
                case 73: {
                    int value = this.stack[this.esp] + this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp - 1] = this.arrLoad(this.stack[this.esp - 1], value);
                    break;
                }
                case 74: {
                    int value = this.stack[this.stackBase + Tool.getInt(codeData, this.eip + 1)];
                    this.stack[this.esp] = this.arrLoad(this.stack[this.esp], value);
                    break;
                }
            }
            this.esp += STACK_EFFECT[inst & 0xFF];
            this.eip += INSTRUCTION_LENGTH[inst & 0xFF];
        }
    }

    public synchronized void execute(int funcID) {
        this.execute(funcID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(int funcID, int[] params) {
        if (this.running) {
            return;
        }
        try {
            this.running = true;
            long startTime = Tool.getSystemTime();
            int oldCounter = this.procCounter;
            int oldCounter2 = this.syscallCounter;
            this.reportEnterFunc(funcID);
            if (this.resumeFlag && funcID == 3) {
                this.resumeFlag = false;
                this.resume();
            } else if (!this.blocked || funcID != 3) {
                this.currentVM = funcID >> 12 & 0xF;
                this.currentFunc = funcID & 0xFFF;
                this.funcBase = this.currentFunc * 3;
                int paramCount = 0;
                if (params != null) {
                    System.arraycopy(params, 0, this.stack, 0, params.length);
                    paramCount += params.length;
                }
                int lcount = this.libraries[this.currentVM].functions[this.funcBase] & 0xFFFF;
                this.esp = -1 + lcount + paramCount;
                this.stackBase = 0;
                this.callCount = 0;
                for (int i = 0; i < lcount; ++i) {
                    this.stack[i + paramCount] = 0;
                }
                this.eip = this.libraries[this.currentVM].functions[this.funcBase + 1];
                this.processInst(this.blocked);
            }
            this.reportExitFunc(funcID);
            execFuncCount += this.procCounter - oldCounter;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.generateInterrupt(7);
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.eip = this.libraries[this.currentVM].functions[this.funcBase + 1];
            int parCount = this.libraries[this.currentVM].functions[this.funcBase] >> 16;
            int localParamCount = this.libraries[this.currentVM].functions[this.funcBase] & 0xFFFF;
            this.esp = this.stackBase + parCount + localParamCount + 3 - 1;
            for (int ii = 0; ii < localParamCount; ++ii) {
                this.stack[this.esp - 3 - ii] = 0;
            }
        }
        finally {
            this.running = false;
        }
    }

    public static String getExecCount() {
        int result = execFuncCount;
        execFuncCount = 0;
        if (execFuncMaxCountSecond < result) {
            execFuncMaxCountSecond = result;
            execFuncMaxCountUpdateTime = Tool.getSystemTime();
        } else if (Tool.getSystemTime() - execFuncMaxCountUpdateTime > (long)statMillis) {
            execFuncMaxCountSecond = result;
            execFuncMaxCountUpdateTime = Tool.getSystemTime();
        }
        return result + " (" + execFuncMaxCountSecond + ")";
    }

    private static void statInstruction(int inst) {
        if (printInstructionList) {
            instructionList.addElement(new Integer(inst));
            if (instructionTick != GameMain.tick) {
                instructionTick = GameMain.tick;
                DebugVM.printInstList();
            }
        }
        if (printInstructionTable) {
            long now = Tool.getSystemTime();
            DebugVM.tableIncCount(instructionTable, inst);
            DebugVM.tableIncCount(instructionMillTable, inst);
            if (now - instructionMillTime > (long)statMillis) {
                DebugVM.printInstTable(instructionTable, "Whole Instruction Stat.", now - startTime);
                DebugVM.printInstTable(instructionMillTable, "Last" + statMillis + " mills Instruction Stat.", statMillis);
                instructionMillTime = now;
                instructionMillTable.clear();
            }
        }
    }

    private static void tableIncCount(Hashtable table, int inst) {
        Integer key = new Integer(inst);
        Integer count = (Integer)table.get(new Integer(inst));
        if (count == null) {
            table.put(key, new Integer(1));
        } else {
            table.put(key, new Integer(count + 1));
        }
    }

    private static void printInstTable(Hashtable table, String title, long totalMills) {
        System.out.println("###########");
        Enumeration enu = table.keys();
        int wholeCount = 0;
        while (enu.hasMoreElements()) {
            Integer key = (Integer)enu.nextElement();
            Integer count = (Integer)table.get(key);
            wholeCount += count.intValue();
            System.out.println(instructionConst.get(key) + " : " + count);
        }
        System.out.println(title + " : " + wholeCount + "/" + totalMills + " , " + (long)wholeCount * 80L / totalMills);
        System.out.println("###########");
    }

    private static void printInstList() {
        int i;
        int count = instructionList.size();
        Hashtable<String[], Integer> statTable = new Hashtable<String[], Integer>();
        String[][] often = new String[8][];
        for (i = 0; i < often.length; ++i) {
            often[i] = new String[i + 1];
        }
        if (count > 3000) {
            for (i = 0; i < count; ++i) {
                Object tmp;
                int j;
                String inst;
                often[0][0] = inst = (String)instructionConst.get(instructionList.elementAt(i));
                for (j = 1; j < often.length; ++j) {
                    tmp = new String[often[j].length];
                    System.arraycopy(often[j], 0, tmp, 1, ((String[])tmp).length - 1);
                    tmp[0] = inst;
                    often[j] = tmp;
                }
                for (j = 1; j < often.length; ++j) {
                    tmp = "";
                    boolean valued = true;
                    for (int k = 0; k < often[j].length; ++k) {
                        if (often[j][k] == null) {
                            valued = false;
                            break;
                        }
                        tmp = (String)tmp + often[j][k] + ":";
                    }
                    if (!valued) continue;
                    Integer oftenCount = (Integer)statTable.get(tmp);
                    if (oftenCount == null) {
                        statTable.put((String[])tmp, new Integer(1));
                        continue;
                    }
                    statTable.put((String[])tmp, new Integer(oftenCount + 1));
                }
            }
            Enumeration enu = statTable.keys();
            Vector<Object[]> printList = new Vector<Object[]>();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                Integer oftenCount = (Integer)statTable.get(key);
                boolean inserted = false;
                Object[] p = new Object[]{key, oftenCount};
                for (int i2 = 0; i2 < printList.size(); ++i2) {
                    Object[] tmp = (Object[])printList.elementAt(i2);
                    if ((Integer)tmp[1] >= oftenCount) continue;
                    printList.insertElementAt(p, i2);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                printList.addElement(p);
            }
            System.out.println("###########");
            for (int i3 = 0; i3 < printList.size(); ++i3) {
                Object[] p = (Object[])printList.elementAt(i3);
                if ((Integer)p[1] <= 100) continue;
                System.out.println("Often Stat : " + p[0] + " " + p[1]);
            }
            System.out.println("###########");
        }
        instructionList.removeAllElements();
    }

    public static int getDynamicHeapSize() {
        return dynamicHeapSize;
    }

    private void modifyInt(int address, int value) {
        this.memSave(address, value);
    }

    private void modifyIntMember(int ptr, int index, int value) {
        Object obj = this.followPointer(ptr);
        if (obj != null && obj instanceof int[]) {
            ((int[])obj)[index] = value;
        }
    }

    private void modifyString(int pointer, String value) {
        if (pointer == 0) {
            return;
        }
        if ((pointer & Integer.MIN_VALUE) != 0) {
            short libID = (short)(pointer >> 16 & Short.MAX_VALUE);
            if (libID == 0) {
                this.stringTable[pointer & 0xFFFF] = value;
            } else {
                for (int i = 1; i < this.libraries.length; ++i) {
                    if (libID != this.libraries[i].libraryID) continue;
                    this.libraries[i].stringTable[pointer & 0xFFFF] = value;
                }
            }
        } else {
            int dataType = pointer >> 26 & 0x1F;
            if (dataType >= 4 && dataType <= 19) {
                int t = pointer & 0xFFF;
                this.dynamicHeap[t & 0xFFF] = value;
            } else if (dataType >= 20) {
                Object[] arr = (Object[])this.dynamicHeap[pointer & 0xFFF];
                if ((pointer & 0x2000000) != 0) {
                    arr[pointer >> 12 & 0x1FFF] = value;
                }
            }
        }
    }

    static {
        instructionConst.put(new Integer(1), "ADD");
        instructionConst.put(new Integer(2), "SUB");
        instructionConst.put(new Integer(3), "MUL");
        instructionConst.put(new Integer(4), "DIV");
        instructionConst.put(new Integer(5), "MOD");
        instructionConst.put(new Integer(6), "AND");
        instructionConst.put(new Integer(7), "OR");
        instructionConst.put(new Integer(8), "ANDB");
        instructionConst.put(new Integer(9), "ORB");
        instructionConst.put(new Integer(10), "LSHIFT");
        instructionConst.put(new Integer(11), "RSHIFT");
        instructionConst.put(new Integer(12), "INCV");
        instructionConst.put(new Integer(13), "ADDV8");
        instructionConst.put(new Integer(14), "SUBV8");
        instructionConst.put(new Integer(17), "EQ");
        instructionConst.put(new Integer(18), "GT");
        instructionConst.put(new Integer(19), "LT");
        instructionConst.put(new Integer(20), "EQ8");
        instructionConst.put(new Integer(21), "GT8");
        instructionConst.put(new Integer(22), "LT8");
        instructionConst.put(new Integer(23), "NE8");
        instructionConst.put(new Integer(24), "INCVS");
        instructionConst.put(new Integer(25), "ADDV8S");
        instructionConst.put(new Integer(26), "SUBV8S");
        instructionConst.put(new Integer(27), "LOADVS");
        instructionConst.put(new Integer(28), "SAVEVS");
        instructionConst.put(new Integer(29), "DUP");
        instructionConst.put(new Integer(33), "JMP");
        instructionConst.put(new Integer(34), "JEQ");
        instructionConst.put(new Integer(35), "JNE");
        instructionConst.put(new Integer(36), "CALL");
        instructionConst.put(new Integer(37), "RET");
        instructionConst.put(new Integer(38), "VRET");
        instructionConst.put(new Integer(39), "SYSCALL");
        instructionConst.put(new Integer(40), "ALOAD8");
        instructionConst.put(new Integer(41), "ASAVE8");
        instructionConst.put(new Integer(42), "STLOAD8");
        instructionConst.put(new Integer(43), "STSAVE8");
        instructionConst.put(new Integer(44), "TSWITCH");
        instructionConst.put(new Integer(45), "LSWITCH");
        instructionConst.put(new Integer(46), "CALLPTR");
        instructionConst.put(new Integer(49), "LOAD");
        instructionConst.put(new Integer(50), "SAVE");
        instructionConst.put(new Integer(51), "LOAD32");
        instructionConst.put(new Integer(52), "LOAD16");
        instructionConst.put(new Integer(53), "LOAD8");
        instructionConst.put(new Integer(54), "ALOAD");
        instructionConst.put(new Integer(55), "ASAVE");
        instructionConst.put(new Integer(56), "ALLOC");
        instructionConst.put(new Integer(57), "FREE");
        instructionConst.put(new Integer(58), "STALLOC");
        instructionConst.put(new Integer(59), "STLOAD");
        instructionConst.put(new Integer(60), "STSAVE");
        instructionConst.put(new Integer(61), "LOADV");
        instructionConst.put(new Integer(62), "SAVEV");
        instructionConst.put(new Integer(63), "LOADFUNC");
        dynamicHeapSize = 0;
    }

    private static class BreakPoint {
        int funcID;
        int start;
        int end;

        private BreakPoint() {
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof BreakPoint)) {
                return false;
            }
            BreakPoint p = (BreakPoint)o;
            return this.funcID == p.funcID && this.start == p.start && this.end == p.end;
        }
    }
}

