/*
 * Decompiled with CFR 0.152.
 */
package com.pip.sanguo;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.engine.IVMGameProcessor;
import com.pip.image.ImageSet;
import com.pip.sanguo.GameIcon;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GamePanelItem;
import com.pip.sanguo.GamePanelPointItem;
import com.pip.sanguo.GamePanelTemplate;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameView;
import com.pip.sanguo.GameWorld;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import com.pip.util.SortHashtable;
import com.pip.util.VMCounter;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GamePanel
implements IVMGameProcessor {
    private VM vm;
    private Hashtable gameData = new Hashtable();
    public byte state;
    private ImageSet[] images;
    private Hashtable templateTable;
    private Hashtable itemTable;
    private Vector itemList;
    private Vector itemQueue;
    private GamePanelItem obtainItem;
    private Vector valueQueue;
    private GamePanelItem obtainValue;
    private Vector pointItems;
    public GamePanelItem hMessageItem;
    public GamePanelItem vMessageItem;
    private GamePanelItem landmark;
    private int tick;
    private boolean needSort = true;
    private Hashtable cdKeyMap;
    private Tool idKey = new Tool();
    private Tool templateIDKey = new Tool();
    public static final byte GAME_PANEL_STATE_NOT_READY = 0;
    public static final byte GAME_PANEL_STATE_INIT = 1;
    public static final byte GAME_PANEL_STATE_SHOWING = 2;
    public static final byte GAME_PANEL_STATE_SHOW = 3;
    public static final byte GAME_PANEL_STATE_HIDING = 4;
    public static final byte GAME_PANEL_STATE_HIDE = 5;
    public static final byte GAME_PANEL_ITEM_TYPE_ANIMATE_ICON = 0;
    public static final byte GAME_PANEL_ITEM_TYPE_IMAGE_ICON = 1;
    public static final byte GAME_PANEL_ITEM_TYPE_IMAGE = 2;
    public static final byte GAME_PANEL_ITEM_TYPE_BOX = 3;
    public static final byte GAME_PANEL_ITEM_TYPE_FILL_BOX = 4;
    public static final byte GAME_PANEL_ITEM_TYPE_LINE = 5;
    public static final byte GAME_PANEL_ITEM_TYPE_STATUS_BAR = 6;
    public static final byte GAME_PANEL_ITEM_TYPE_NUM = 7;
    public static final byte GAME_PANEL_ITEM_TYPE_MINI_ANIMATE = 8;
    public static final byte GAME_PANEL_ITEM_TYPE_ANIMATE = 9;
    public static final byte GAME_PANEL_ICON = 10;
    public static final byte GAME_PANEL_SKILL_ANIMATE = 11;
    public static final byte GAME_PANEL_HMSG_BAR = 12;
    public static final byte GAME_PANEL_VMSG_BAR = 13;
    public static final byte GAME_PANEL_ITEM_COUNTDOWN = 14;
    public static final byte GAME_PANEL_ITEM_OBTAIN = 15;
    public static final byte GAME_PANEL_VALUE_OBTAIN = 16;
    public static final byte GAME_PANEL_LANDMARK = 17;
    public static final byte GAME_PANEL_STRING = 18;
    public static final byte GAME_PANEL_ITEM_TYPE_ALPHA_BOX = 19;
    public static final byte GAME_PANEL_ITEM_TYPE_OPPOSITE_IMAGE = 20;
    public static final byte ICON_TICKER_TIME = 7;
    public static final byte HMSG_STEP = 4;
    public static final byte VMSG_STEP = 2;
    public static final byte VMSG_STOP_TIME = 20;
    public static final byte VMSG_STATE_STOP = 0;
    public static final byte VMSG_STATE_MOVE = 1;
    public static final byte GAME_PANEL_ACTION_STATE_NON_ACTIVE = 0;
    public static final byte GAME_PANEL_ACTION_STATE_ACTIVE = 1;
    public static final byte GAME_PANEL_SKILL_COLD = 0;
    public static final byte GAME_PANEL_SKILL_NEED_COLD = 1;
    public static final byte GAME_PANEL_SKILL_READY_COLD = 2;
    private static final int STATUS_BAR_PRECISION = 10000;
    private int offset = 3;
    private int vMessageId;
    private int hMessageId;
    private int msgOldY;
    private static Tool keyMaker = new Tool();
    public static int SELECT_SPRITE_FRESHHOLD = 20;
    private static final Vector candidates = new Vector();
    private static final Hashtable sprite2dis = new Hashtable();

    public GamePanel() {
        this.templateTable = new Hashtable();
        this.images = new ImageSet[0];
        this.itemTable = new Hashtable();
        this.itemList = new Vector();
        this.itemQueue = new Vector();
        this.valueQueue = new Vector();
        this.cdKeyMap = new Hashtable();
        this.pointItems = new Vector();
        this.landmark = new GamePanelItem(this.idKey.nextKey(), 17);
    }

    public void init() {
        VMGame.loadVMGame("game_panel", (byte)0, true);
        this.vm = VMGame.getVMGame("game_panel").getVM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendCommand(int command, Object commandData) {
        VM vM = this.vm;
        synchronized (vM) {
            int[] params = new int[]{this.vm.makeTempObject(this), command, this.vm.makeTempObject(commandData)};
            this.vm.callback("GameCommand", params);
        }
    }

    public void game_panel_set_state(int state) {
        this.state = (byte)state;
    }

    public int game_panel_reg_image(ImageSet image) {
        ImageSet[] temp = new ImageSet[this.images.length + 1];
        System.arraycopy(this.images, 0, temp, 0, this.images.length);
        temp[this.images.length] = image;
        this.images = temp;
        return this.images.length - 1;
    }

    public void game_panel_release_image(int imageIndex) {
        this.images[imageIndex] = null;
    }

    public int game_panel_add_item_animate_icon(int layer, int iconIndex) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 0);
        item.layer = layer;
        item.intData1 = iconIndex;
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_item_image_icon(int layer, int iconIndex, int x, int y, int w, int h) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 1);
        item.layer = layer;
        item.intData1 = iconIndex;
        item.x = (short)x;
        item.y = (short)y;
        item.w = (short)w;
        item.h = (short)h;
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_item_image(int layer, int imageIndex, int frameIndex, int x, int y, int trans, int anchor) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 2);
        item.layer = layer;
        item.intData1 = imageIndex;
        item.intData2 = frameIndex;
        item.x = (short)x;
        item.y = (short)y;
        item.trans = (byte)trans;
        item.anchor = (byte)anchor;
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_item_opposite_image(int layer, int imageIndex, int frameIndex, int x, int y, int trans, int anchor) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 20);
        item.layer = layer;
        item.intData1 = imageIndex;
        item.intData2 = frameIndex;
        item.x = (short)x;
        item.y = (short)y;
        item.trans = (byte)trans;
        item.anchor = (byte)anchor;
        this.addItem(item);
        return item.id;
    }

    public int[] game_panel_get_opposite_image_box(int itemId) {
        GamePanelItem item = (GamePanelItem)this.itemTable.get(new Integer(itemId));
        int[] result = new int[]{-1, -1, -1, -1};
        if (item != null && item.intData1 < this.images.length && item.intData2 < this.images[item.intData1].getFrameCount()) {
            result[0] = item.x;
            result[1] = item.y;
            result[2] = this.images[item.intData1].getFrameWidth(item.intData2);
            result[3] = this.images[item.intData1].getFrameHeight(item.intData2);
            GamePanelItem hMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.hMessageId));
            GamePanelItem vMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.vMessageId));
            if (hMsgItem != null && ((Vector)hMsgItem.objData).size() > 0) {
                result[1] = result[1] - hMsgItem.h;
            }
            if (vMsgItem != null && ((Vector)vMsgItem.objData).size() > 0) {
                result[1] = result[1] - vMsgItem.h;
            }
        }
        return result;
    }

    public boolean game_panel_point_in_box(int pointX, int pointY, int[] box) {
        return Tool.rectIn(box[0], box[1], box[2], box[3], pointX, pointY);
    }

    public void game_panel_change_item_image(int id, int imageIndex, int startIndex, int offsetX, int offsetY) {
        GamePanelItem item = (GamePanelItem)this.itemTable.get(new Integer(id));
        if (item != null) {
            item.intData1 = imageIndex;
            item.intData2 = startIndex;
            item.x = (short)(item.x + offsetX);
            item.y = (short)(item.y + offsetY);
        }
    }

    public int game_panel_add_item_box(int layer, int color, int x, int y, int w, int h) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 3);
        item.layer = layer;
        item.intData1 = color;
        item.x = (short)x;
        item.y = (short)y;
        item.w = (short)w;
        item.h = (short)h;
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_item_fill_box(int layer, int color, int x, int y, int w, int h) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 4);
        item.layer = layer;
        item.intData1 = color;
        item.x = (short)x;
        item.y = (short)y;
        item.w = (short)w;
        item.h = (short)h;
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_item_line(int layer, int color, int x1, int y1, int x2, int y2) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 5);
        item.layer = layer;
        item.intData1 = color;
        item.x = (short)x1;
        item.y = (short)y1;
        item.w = (short)(x2 - x1);
        item.h = (short)(y2 - y1);
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_item_status_bar(int layer, int color, int x, int y, int w, int h) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 6);
        item.layer = layer;
        item.intData1 = color;
        item.intData2 = 10000;
        item.x = (short)x;
        item.y = (short)y;
        item.w = (short)w;
        item.h = (short)h;
        this.addItem(item);
        return item.id;
    }

    public void game_panel_change_item_status_bar(int id, int curValue, int maxValue) {
        GamePanelItem item = (GamePanelItem)this.itemTable.get(new Integer(id));
        if (item != null && maxValue > 0 && curValue <= maxValue) {
            item.intData2 = (int)((long)curValue * 10000L / (long)maxValue);
        }
    }

    public void game_panel_remove_item(int id) {
        this.removeItem(id);
    }

    public void game_panel_clear_item() {
        this.itemList.removeAllElements();
        this.itemTable.clear();
    }

    public int game_panel_add_item_num(int layer, int imageIndex, int startIndex, int x, int y, int space, int anchor, int num) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 7);
        item.layer = layer;
        item.intData1 = imageIndex;
        item.intData2 = startIndex;
        item.x = (short)x;
        item.y = (short)y;
        item.trans = (byte)space;
        item.anchor = (byte)anchor;
        item.objData = String.valueOf(num);
        this.addItem(item);
        return item.id;
    }

    public void game_panel_change_item_num(int id, int num) {
        GamePanelItem item = (GamePanelItem)this.itemTable.get(new Integer(id));
        if (item != null) {
            item.objData = String.valueOf(num);
        }
    }

    public int game_panel_add_item_mini_animate(int layer, int imageIndex, int startIndex, int x, int y, int trans, int anchor, int moveType, int totalDistance, int totalTicks) {
        int[] tmp;
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 8);
        item.layer = layer;
        item.intData1 = imageIndex;
        item.intData2 = startIndex;
        item.x = (short)x;
        item.y = (short)y;
        item.trans = (byte)trans;
        item.anchor = (byte)anchor;
        int gcd = Tool.gcd(totalDistance, totalTicks);
        tmp = new int[]{moveType, totalDistance / gcd, totalTicks / gcd, totalDistance, tmp[0] == 0 ? item.x + tmp[3] : item.y + tmp[3], this.tick};
        item.objData = tmp;
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_item_animate(int layer, int imageIndex, int x, int y, int trans, int anchor, int ticks, int[] startIndex) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 9);
        item.layer = layer;
        item.intData1 = imageIndex;
        item.x = (short)x;
        item.y = (short)y;
        item.trans = (byte)trans;
        item.anchor = (byte)anchor;
        item.intData2 = ticks;
        int[] sequences = new int[startIndex.length];
        System.arraycopy(startIndex, 0, sequences, 0, startIndex.length);
        item.objData = sequences;
        item.ready = true;
        item.tick = this.tick;
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_item_icon(int state, int x, int y, int imageIndex, int frameIndex, int numImageIndex, int numStart, int key) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 10);
        item.intData1 = state;
        item.x = (short)x;
        item.y = (short)y;
        int[] tmp = new int[]{imageIndex, frameIndex, numImageIndex, numStart, key};
        item.objData = tmp;
        item.tick = this.tick;
        item.anchor = (byte)24;
        this.addItem(item);
        return item.id;
    }

    public void game_panel_action_state_change(int _state) {
        int count = this.itemList.size();
        for (int i = 0; i < count; ++i) {
            GamePanelItem item = (GamePanelItem)this.itemList.elementAt(i);
            if (item.type != 10) continue;
            item.intData1 = _state;
        }
    }

    public int game_panel_add_skill_animate(int layer, int imageIndex, int startIndex, int x, int y, int anchor, int coldGroup, int coldState, int coldHeight, int color) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 11);
        item.layer = layer;
        item.intData1 = imageIndex;
        item.intData2 = startIndex;
        item.x = (short)x;
        item.y = (short)y;
        item.anchor = (byte)anchor;
        item.w = (short)this.images[item.intData1].getFrameWidth(item.intData2);
        item.h = (short)this.images[item.intData1].getFrameHeight(item.intData2);
        if ((item.anchor & 1) > 0) {
            item.x = (short)(item.x - item.w / 2);
        } else if ((item.anchor & 8) > 0) {
            item.x = (short)(item.x - item.w);
        }
        if ((item.anchor & 2) > 0) {
            item.y = (short)(item.y - item.h / 2);
        } else if ((item.anchor & 0x20) > 0) {
            item.y = (short)(item.y - item.h);
        }
        int[] arr = new int[]{coldGroup, coldState, coldHeight, color};
        item.objData = arr;
        this.addItem(item);
        return item.id;
    }

    public void game_panel_change_skill_cold_group(int coldDownId, int coldStartTime, int duration) {
        this.addCdKey(coldDownId, coldStartTime, duration);
    }

    public int game_panel_add_item_countdown(int layer, int imageIndex, int frameIndex, int x, int y, int anchor, int countId, int rollId) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 14);
        item.layer = layer;
        item.intData1 = imageIndex;
        item.intData2 = frameIndex;
        item.x = (short)x;
        item.y = (short)y;
        item.anchor = (byte)anchor;
        item.objData = new Integer(countId);
        int[] rollData = new int[]{rollId};
        item.objData2 = rollData;
        this.addItem(item);
        return item.id;
    }

    public void game_panel_add_obtain_item(int _imageIndex, int _frameIndex, int _color, String _name, int _layer) {
        this.game_panel_add_obtain_item2(_imageIndex, _frameIndex, _color, _name, _layer, -1, -1, -1);
    }

    public void game_panel_add_obtain_item2(int _imageIndex, int _frameIndex, int _color, String _name, int _layer, int numImageIndex, int numIndex, int count) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 15);
        item.intData1 = _imageIndex;
        item.intData2 = _frameIndex;
        item.objData2 = new Integer(_color);
        item.objData = _name;
        item.layer = _layer;
        if (numImageIndex != -1) {
            item.objData3 = new int[]{numImageIndex, numIndex, count};
        }
        this.addObtainItem(item);
    }

    public void game_panel_add_obtain_value(int imageIndex, int frameIndex, int numImageIndex, int numIndex, int value, int layer) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 16);
        item.intData1 = imageIndex;
        item.intData2 = frameIndex;
        int[] dataArr = new int[]{numImageIndex, numIndex, value};
        item.objData = dataArr;
        item.layer = layer;
        this.addObtainValue(item);
    }

    public int game_panel_add_item_hmessage_bar(int x, int y, int w, int h, int layer, int edge, int alpha, byte type) {
        this.hMessageItem = new GamePanelItem(this.idKey.nextKey(), type);
        this.hMessageItem.layer = layer;
        this.hMessageItem.x = (short)x;
        this.hMessageItem.y = (short)y;
        this.hMessageItem.w = (short)w;
        this.hMessageItem.h = (short)h;
        this.hMessageItem.frame = edge;
        this.hMessageItem.intData1 = alpha;
        this.hMessageItem.objData = new Vector();
        this.hMessageItem.objData2 = new Vector();
        this.addItem(this.hMessageItem);
        this.hMessageId = this.hMessageItem.id;
        return this.hMessageItem.id;
    }

    public int game_panel_add_item_hmessage_bar(int x, int y, int w, int h, int layer, int edge, int alpha) {
        return this.game_panel_add_item_hmessage_bar(x, y, w, h, layer, edge, alpha, (byte)12);
    }

    public int game_panel_add_item_vmessage_bar(int x, int y, int w, int h, int layer, int edge, int alpha) {
        this.vMessageItem = new GamePanelItem(this.idKey.nextKey(), 13);
        this.vMessageItem.layer = layer;
        this.vMessageItem.x = (short)x;
        this.vMessageItem.y = (short)y;
        this.vMessageItem.w = (short)w;
        this.vMessageItem.h = (short)h;
        this.vMessageItem.frame = edge;
        this.vMessageItem.intData1 = alpha;
        this.vMessageItem.objData = new Vector();
        this.vMessageItem.objData2 = new Vector();
        this.addItem(this.vMessageItem);
        this.vMessageId = this.vMessageItem.id;
        this.msgOldY = this.vMessageItem.y;
        return this.vMessageItem.id;
    }

    public void game_panel_change_hmessage_alpha(int alpha) {
        this.hMessageItem.intData1 = alpha;
    }

    public void game_panel_change_vmessage_alpha(int alpha) {
        this.vMessageItem.intData1 = alpha;
    }

    public void game_panel_post_hmessage(int id, String msg, int color, int maxRecord) {
        int _count = GameWorld.instance.vm_game_get_hmsg_count();
        if (_count < maxRecord) {
            this.hMessageItem = (GamePanelItem)this.itemTable.get(new Integer(id));
            String hmsgStr = msg;
            Vector hmsgs = (Vector)this.hMessageItem.objData;
            int count = hmsgs.size();
            for (int i = 0; i < count; ++i) {
                if (!hmsgStr.equals(hmsgs.elementAt(i))) continue;
                return;
            }
            if (this.hMessageItem.type == 12) {
                if (((Vector)this.hMessageItem.objData).size() == 0) {
                    this.hMessageItem.tick = this.tick;
                }
                ((Vector)this.hMessageItem.objData).addElement(hmsgStr);
                ((Vector)this.hMessageItem.objData2).addElement(new Integer(color));
            } else {
                int i;
                String srcString = msg;
                String[] destStrings = Tool.formatText(srcString, this.vMessageItem.w, Utilities.font);
                Vector[] destVecs = new Vector[destStrings.length];
                for (i = 0; i < destVecs.length; ++i) {
                    destVecs[i] = Tool.formatString(destStrings[i], 100000, Utilities.font, true);
                }
                for (i = 0; i < destStrings.length; ++i) {
                    ((Vector)this.vMessageItem.objData).addElement(destVecs[i]);
                    ((Vector)this.vMessageItem.objData2).addElement(new Integer(color));
                }
                this.vMessageItem.tick = this.tick;
            }
            this.hMessageItem.y = ((Vector)this.vMessageItem.objData).size() > 0 ? (short)(this.vMessageItem.y - this.hMessageItem.h) : (short)(this.vMessageItem.y + this.vMessageItem.h - this.hMessageItem.h);
        }
    }

    public void game_panel_post_vmessage(int id, String msg, int color, int maxRecord) {
        int _count = GameWorld.instance.vm_game_get_vmsg_count();
        if (_count < maxRecord) {
            int i;
            this.vMessageItem = (GamePanelItem)this.itemTable.get(new Integer(id));
            String srcString = msg;
            String[] destStrings = Tool.formatText(srcString, this.vMessageItem.w, Utilities.font);
            Vector[] destVecs = new Vector[destStrings.length];
            for (i = 0; i < destVecs.length; ++i) {
                destVecs[i] = Tool.formatString(destStrings[i], 100000, Utilities.font, true);
            }
            for (i = 0; i < destStrings.length; ++i) {
                ((Vector)this.vMessageItem.objData).addElement(destVecs[i]);
                ((Vector)this.vMessageItem.objData2).addElement(new Integer(color));
            }
            this.vMessageItem.tick = this.tick;
            this.hMessageItem.y = (short)(this.vMessageItem.y - this.hMessageItem.h);
        }
    }

    public void game_panel_set_landmark_config(int _x, int _y, int _color, int _bgColor, int _archor, int _layer) {
        this.landmark.x = (short)_x;
        this.landmark.y = (short)_y;
        this.landmark.objData = this.getCurrentLandStr();
        this.landmark.intData1 = _color;
        this.landmark.intData2 = _bgColor;
        this.landmark.anchor = (byte)_archor;
        this.landmark.layer = _layer;
    }

    public int game_panel_add_stringEx(String str, int x, int y, int offset, int anchor, int is3d, int isTopOfMsg, int forColor, int bgColor, int layer, Font font) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 18);
        item.objData = str;
        item.x = (short)x;
        item.y = (short)y;
        item.anchor = (byte)anchor;
        int[] strData = new int[]{is3d, isTopOfMsg, forColor, bgColor, offset};
        item.objData2 = strData;
        item.layer = layer;
        this.addItem(item);
        return item.id;
    }

    public int game_panel_add_string(String str, int x, int y, int offset, int anchor, int is3d, int isTopOfMsg, int forColor, int bgColor, int layer) {
        return this.game_panel_add_stringEx(str, x, y, offset, anchor, is3d, isTopOfMsg, forColor, bgColor, layer, Utilities.font);
    }

    public void game_panel_remove_skill_cold_group(int coldDownId) {
        this.removeCdKey(coldDownId);
    }

    public int game_panel_add_item_alpha_fill_box(int layer, int color, int x, int y, int w, int h) {
        GamePanelItem item = new GamePanelItem(this.idKey.nextKey(), 19);
        item.layer = layer;
        item.intData1 = color;
        item.x = (short)x;
        item.y = (short)y;
        item.w = (short)w;
        item.h = (short)h;
        this.addItem(item);
        return item.id;
    }

    public void game_panel_change_item_pos(int id, short x, short y) {
        GamePanelItem item = (GamePanelItem)this.itemTable.get(new Integer(id));
        item.x = x;
        item.y = y;
    }

    public void game_panel_clear_array(int[] arr, int padding) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = padding;
        }
    }

    public void game_panel_reg_point_item(int notifyId, int x, int y, int w, int h, boolean opposite, int notifyData, int anchor) {
        GamePanelPointItem pointItem = new GamePanelPointItem();
        pointItem.notifyId = notifyId;
        pointItem.opposite = opposite;
        pointItem.effect = true;
        pointItem.notifyData = notifyData;
        switch (anchor) {
            case 32: {
                y -= h;
                break;
            }
            case 1: {
                x -= w / 2;
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                x -= w;
                break;
            }
            case 16: {
                break;
            }
            case 2: {
                y -= h / 2;
                break;
            }
            case 20: {
                break;
            }
            case 3: {
                x -= w / 2;
                y -= h / 2;
                break;
            }
            case 17: {
                x -= w / 2;
                break;
            }
            case 24: {
                x -= w;
                break;
            }
            case 36: {
                y -= h;
                break;
            }
            case 40: {
                x -= w;
                y -= h;
                break;
            }
            case 33: {
                x -= w / 2;
                y -= h;
                break;
            }
            case 6: {
                y -= h / 2;
                break;
            }
            case 10: {
                x -= w;
                y -= h / 2;
            }
        }
        pointItem.x = x;
        pointItem.y = y;
        pointItem.w = w;
        pointItem.h = h;
        this.pointItems.addElement(pointItem);
    }

    public void game_panel_remove_point_item(int notifyId) {
        int count = this.pointItems.size();
        Vector<GamePanelPointItem> restItems = new Vector<GamePanelPointItem>();
        for (int i = 0; i < count; ++i) {
            GamePanelPointItem pointItem = (GamePanelPointItem)this.pointItems.elementAt(i);
            if (pointItem.notifyId == notifyId) continue;
            restItems.addElement(pointItem);
        }
        this.pointItems = restItems;
    }

    public void game_panel_set_point_item_effect(int notifyId, boolean effect) {
        int count = this.pointItems.size();
        for (int i = 0; i < count; ++i) {
            GamePanelPointItem pointItem = (GamePanelPointItem)this.pointItems.elementAt(i);
            if (pointItem.notifyId != notifyId) continue;
            pointItem.effect = effect;
        }
    }

    public void game_panel_clear_point_item() {
        this.pointItems.removeAllElements();
    }

    public static void binaryAdd(Vector v, GameSprite p, int x, int y) {
        int end;
        int disP = Tool.distance(p.sprite.getX(), p.sprite.getY(), x, y);
        int start = -1;
        int mid = end = v.size();
        while (end - start > 1) {
            mid = start + end >> 1;
            GameSprite g = (GameSprite)v.elementAt(mid);
            int disG = Tool.distance(g.sprite.getX(), g.sprite.getY(), x, y);
            if (disP < disG) {
                end = mid;
                continue;
            }
            start = mid;
        }
        v.insertElementAt(p, end);
        sprite2dis.put(p, new Integer(disP));
    }

    public static int[] getPointItem(int pointX0, int pointY0) {
        int pointX = pointX0;
        int pointY = pointY0;
        if (GameWorld.panel != null) {
            GamePanel panelInstance = GameWorld.panel;
            int count = panelInstance.pointItems.size();
            for (int i = count - 1; i >= 0; --i) {
                GamePanelPointItem pointItem = (GamePanelPointItem)panelInstance.pointItems.elementAt(i);
                if (!pointItem.effect) continue;
                if (pointItem.opposite) {
                    int my = pointItem.y;
                    GamePanelItem hMsgItem = (GamePanelItem)panelInstance.itemTable.get(new Integer(panelInstance.hMessageId));
                    GamePanelItem vMsgItem = (GamePanelItem)panelInstance.itemTable.get(new Integer(panelInstance.vMessageId));
                    if (hMsgItem != null && ((Vector)hMsgItem.objData).size() > 0) {
                        my -= hMsgItem.h;
                    }
                    if (vMsgItem != null && ((Vector)vMsgItem.objData).size() > 0) {
                        my -= vMsgItem.h;
                    }
                    if (!Tool.rectIn(pointItem.x, my, pointItem.w, pointItem.h, pointX, pointY)) continue;
                    return new int[]{-1, pointItem.notifyId, pointItem.x, my, pointItem.w, pointItem.h, pointItem.notifyData};
                }
                if (!Tool.rectIn(pointItem.x, pointItem.y, pointItem.w, pointItem.h, pointX, pointY)) continue;
                return new int[]{-1, pointItem.notifyId, pointItem.x, pointItem.y, pointItem.w, pointItem.h, pointItem.notifyData};
            }
        }
        boolean selectSelf = false;
        if (GameWorld.gameView != null) {
            int[] box2;
            int freshHold = Tool.getGlobalInt("SELECT_SPRITE_FRESHHOLD");
            if (freshHold != SELECT_SPRITE_FRESHHOLD) {
                SELECT_SPRITE_FRESHHOLD = freshHold;
            }
            int spriteCount = GameWorld.gameSprites.size();
            int realX = pointX + GameWorld.viewX;
            int realY = pointY + GameWorld.viewY;
            candidates.removeAllElements();
            sprite2dis.clear();
            for (int i = 0; i < spriteCount; ++i) {
                Object hintKey;
                GameSprite gameSprite = (GameSprite)GameWorld.gameSprites.elementAt(i);
                if (GameWorld.gameView.checkTarget(gameSprite) == null) continue;
                int[] box = gameSprite.vm_sprite_get_animate_box();
                int questMarkH = 0;
                if (gameSprite.getType() == 3 && gameSprite.faction == GameWorld.player.faction && gameSprite.canSelect && !gameSprite.canAttack && (hintKey = gameSprite.readGameData("AnimateKey_Hint")) != null) {
                    questMarkH = 47 + Utilities.CHAR_HEIGHT;
                }
                if (!Tool.rectIn(box[0], box[1] - questMarkH, box[2], box[3] + questMarkH, realX, realY)) continue;
                GamePanel.binaryAdd(candidates, gameSprite, realX, realY);
            }
            spriteCount = candidates.size();
            if (spriteCount > 1) {
                GameSprite top = (GameSprite)candidates.elementAt(0);
                Integer disTopObj = (Integer)sprite2dis.get(top);
                int disTop = disTopObj;
                int maxIndex = 0;
                for (int i = 1; i < spriteCount; ++i) {
                    GameSprite gameSprite = (GameSprite)candidates.elementAt(i);
                    Integer disObj = (Integer)sprite2dis.get(gameSprite);
                    int dis = disObj;
                    if (Math.abs(dis - disTop) <= SELECT_SPRITE_FRESHHOLD) continue;
                    maxIndex = i - 1;
                    break;
                }
                if (maxIndex == 0) {
                    return new int[]{top.getInstanceId(), 0, 0, 0, 0, 0, 0};
                }
                int enemyIndex = -1;
                int npcIndex = -1;
                int creatureIndex = -1;
                int teammateIndex = -1;
                block3: for (int i = 0; i <= maxIndex; ++i) {
                    GameSprite gameSprite = (GameSprite)candidates.elementAt(i);
                    if (gameSprite.getType() == 1) {
                        int[] roleInfo;
                        SortHashtable teamlist;
                        if (GameWorld.player.faction != gameSprite.faction) {
                            if (enemyIndex != -1) continue;
                            enemyIndex = i;
                            continue;
                        }
                        if (!GameWorld.player.isTeamState() || !gameSprite.isTeamState() || (teamlist = (SortHashtable)VM.globalVMData.get(new Integer((roleInfo = (int[])GameWorld.instance.readGameData("game_role_infor"))[59]))) == null) continue;
                        int teamSize = teamlist.size();
                        for (int j = 0; j < teamSize; ++j) {
                            int[] memberInfo = (int[])teamlist.getValue(j);
                            if (memberInfo[0] != gameSprite.getInstanceId()) continue;
                            if (teammateIndex != -1) continue block3;
                            teammateIndex = i;
                            continue block3;
                        }
                        continue;
                    }
                    if (gameSprite.getType() != 3) continue;
                    int[] npcData = (int[])gameSprite.readGameData("npc_data");
                    if (npcData[1] == 1) {
                        if (gameSprite.canAttack || npcIndex != -1) continue;
                        npcIndex = i;
                        continue;
                    }
                    if (!gameSprite.canAttack || creatureIndex != -1) continue;
                    creatureIndex = i;
                }
                GameSprite candidate = null;
                if (enemyIndex != -1) {
                    candidate = (GameSprite)candidates.elementAt(enemyIndex);
                } else if (npcIndex != -1) {
                    candidate = (GameSprite)candidates.elementAt(npcIndex);
                } else if (creatureIndex != -1) {
                    candidate = (GameSprite)candidates.elementAt(creatureIndex);
                } else if (teammateIndex != -1) {
                    candidate = (GameSprite)candidates.elementAt(teammateIndex);
                } else {
                    selectSelf = true;
                }
                if (candidate != null) {
                    return new int[]{candidate.getInstanceId(), 0, 0, 0, 0, 0, 0};
                }
            } else {
                if (spriteCount == 1) {
                    GameSprite candidate = (GameSprite)candidates.elementAt(0);
                    return new int[]{candidate.getInstanceId(), 0, 0, 0, 0, 0, 0};
                }
                selectSelf = true;
            }
            if (selectSelf && GameWorld.player != null && Tool.rectIn((box2 = GameWorld.player.vm_sprite_get_animate_box())[0], box2[1], box2[2], box2[3], realX, realY)) {
                return new int[]{GameWorld.player.getInstanceId(), 0, 0, 0, 0, 0, 0};
            }
        }
        return new int[]{-1, -1, 0, 0, 0, 0, 0};
    }

    public String getCurrentLandStr() {
        if (GameWorld.currentMap == null) {
            return "";
        }
        String landName = GameWorld.currentMap.name;
        int extraIdx = landName.indexOf(124);
        if (extraIdx >= 0) {
            landName = landName.substring(0, extraIdx);
        }
        int playerX = 0;
        int playerY = 0;
        playerX = GameWorld.player.sprite.getX() / 8;
        playerY = GameWorld.player.sprite.getY() / 8;
        StringBuffer sb = new StringBuffer(landName);
        sb.append("(");
        sb.append(playerX);
        sb.append(",");
        sb.append(playerY);
        sb.append(")");
        String str = sb.toString();
        sb = null;
        return str;
    }

    public Object readGameData(String dataName) {
        return this.gameData.get(dataName);
    }

    public void removeGameData(String dataName) {
        this.gameData.remove(dataName);
    }

    public void saveGameData(String dataName, Object data) {
        this.gameData.put(dataName, data);
    }

    private int getCdKey(int cdId) {
        Integer cdKey = (Integer)this.cdKeyMap.get(new Integer(cdId));
        if (cdKey == null) {
            return -1;
        }
        return cdKey;
    }

    private void addCdKey(int cdId, int startTime, int counterTime) {
        Integer groupId = new Integer(cdId);
        if (this.cdKeyMap.containsKey(groupId)) {
            int key = (Integer)this.cdKeyMap.get(groupId);
            VMCounter.setCounter(key, startTime, counterTime);
        } else {
            int key = VMCounter.createVMCounter(startTime, counterTime);
            this.cdKeyMap.put(groupId, new Integer(key));
        }
    }

    private void removeCdKey(int cdId) {
        Integer groupId = new Integer(cdId);
        if (this.cdKeyMap.containsKey(groupId)) {
            int key = (Integer)this.cdKeyMap.get(groupId);
            VMCounter.removeVMCounter(key);
            this.cdKeyMap.remove(groupId);
            this.sendCommand(15030, new int[]{cdId});
        }
    }

    private void addItem(GamePanelItem item) {
        this.itemTable.put(new Integer(item.id), item);
        this.itemList.addElement(item);
        this.needSort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObtainItem(GamePanelItem item) {
        Vector vector = this.itemQueue;
        synchronized (vector) {
            this.itemQueue.addElement(item);
        }
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObtainValue(GamePanelItem value) {
        Vector vector = this.valueQueue;
        synchronized (vector) {
            this.valueQueue.addElement(value);
        }
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void removeItem(int itemId) {
        this.itemTable.remove(new Integer(itemId));
        for (int i = 0; i < this.itemList.size(); ++i) {
            GamePanelItem item = (GamePanelItem)this.itemList.elementAt(i);
            if (item.id != itemId) continue;
            this.itemList.removeElementAt(i);
            break;
        }
        this.needSort = true;
    }

    public void cycle() {
        ++this.tick;
        if (this.needSort) {
            this.sort();
            this.needSort = false;
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                this.sendCommand(15010, null);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.updateColdDown();
                this.updateObtains();
                this.updateLandmark();
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private void updateLandmark() {
        this.landmark.objData = this.getCurrentLandStr();
    }

    public void draw(Graphics g, int low, int high) {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.drawPanel(g, 0, low, high);
                if (this.obtainItem != null) {
                    this.drawItem(g, this.obtainItem, low, high);
                }
                if (this.obtainValue != null) {
                    this.drawItem(g, this.obtainValue, low, high);
                }
                if (this.landmark == null) break;
                this.drawItem(g, this.landmark, low, high);
                break;
            }
            case 4: {
                break;
            }
        }
        this.drawMsgPanel(g, low, high);
    }

    public void drawMsgPanel(Graphics g, int low, int high) {
        this.drawItem(g, this.hMessageItem, low, high);
        this.drawItem(g, this.vMessageItem, low, high);
    }

    public void setMsgPanelY(int y) {
        this.vMessageItem.y = (short)(y - this.vMessageItem.h);
        this.hMessageItem.y = ((Vector)this.vMessageItem.objData).size() > 0 ? (short)(this.vMessageItem.y - this.hMessageItem.h) : (short)(this.vMessageItem.y + this.vMessageItem.h - this.hMessageItem.h);
    }

    public int getMsgPanelY() {
        if (this.vMessageItem == null) {
            return this.msgOldY;
        }
        return this.msgOldY + this.vMessageItem.h;
    }

    private void updateColdDown() {
        int size = this.itemList.size();
        block8: for (int i = 0; i < size; ++i) {
            GamePanelItem item = (GamePanelItem)this.itemList.elementAt(i);
            switch (item.type) {
                case 11: {
                    int[] arr = (int[])item.objData;
                    switch (arr[1]) {
                        case 0: {
                            int cdKey = this.getCdKey(arr[0]);
                            if (cdKey == -1) break;
                            int rate = VMCounter.getProcess(cdKey);
                            if (rate >= 0) {
                                arr[1] = 1;
                                break;
                            }
                            this.removeCdKey(arr[0]);
                            break;
                        }
                        case 1: {
                            int rate;
                            int cdKey = this.getCdKey(arr[0]);
                            if (cdKey != -1) {
                                rate = VMCounter.getProcess(cdKey);
                                if (rate >= 0) {
                                    arr[2] = item.h * (100 - rate) / 100;
                                    break;
                                }
                                item.frame = 0;
                                arr[1] = 2;
                                this.removeCdKey(arr[0]);
                                break;
                            }
                            item.frame = 0;
                            arr[1] = 2;
                            break;
                        }
                        case 2: {
                            if (item.frame > 6) {
                                arr[1] = 0;
                            }
                            ++item.frame;
                        }
                    }
                    continue block8;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObtains() {
        if (this.obtainItem == null) {
            Vector vector = this.itemQueue;
            synchronized (vector) {
                if (this.itemQueue.size() > 0) {
                    this.obtainItem = (GamePanelItem)this.itemQueue.elementAt(0);
                    this.itemQueue.removeElementAt(0);
                }
            }
            if (this.obtainItem != null) {
                int itemWidth = this.images[this.obtainItem.intData1].getFrameWidth(this.obtainItem.intData2);
                this.obtainItem.x = (short)(GameMain.viewWidth - (itemWidth += Utilities.font.stringWidth((String)this.obtainItem.objData)));
                this.obtainItem.w = (short)itemWidth;
                this.obtainItem.h = (short)(Utilities.CHAR_HEIGHT + 2);
                this.obtainItem.frame = 0;
            }
        } else {
            ++this.obtainItem.frame;
            if (this.obtainItem.frame > 30) {
                if (this.obtainItem.x < GameMain.viewWidth) {
                    this.obtainItem.x = (short)(this.obtainItem.x + this.offset);
                } else {
                    this.obtainItem = null;
                }
            }
        }
        if (this.obtainValue == null) {
            Vector itemWidth = this.valueQueue;
            synchronized (itemWidth) {
                if (this.valueQueue.size() > 0) {
                    this.obtainValue = (GamePanelItem)this.valueQueue.elementAt(0);
                    this.valueQueue.removeElementAt(0);
                }
            }
            if (this.obtainValue != null) {
                int[] dataArr = (int[])this.obtainValue.objData;
                int frameWidth = this.images[dataArr[0]].getFrameWidth(dataArr[1]);
                int itemWidth2 = String.valueOf(dataArr[2]).length() * frameWidth;
                itemWidth2 += this.images[dataArr[0]].getFrameWidth(dataArr[1] + 10);
                this.obtainValue.x = (short)(GameMain.viewWidth - (itemWidth2 += this.images[this.obtainValue.intData1].getFrameWidth(this.obtainValue.intData2)));
                this.obtainValue.w = (short)itemWidth2;
                this.obtainValue.h = (short)(Utilities.CHAR_HEIGHT + 2);
                this.obtainValue.frame = 0;
            }
        } else {
            ++this.obtainValue.frame;
            if (this.obtainValue.frame > 30) {
                this.obtainValue = null;
            }
        }
    }

    public void drawPanel(Graphics g, int offset, int low, int high) {
        if (this.itemList != null) {
            int size = this.itemList.size();
            for (int i = 0; i < size; ++i) {
                this.drawItem(g, (GamePanelItem)this.itemList.elementAt(i), low, high);
            }
        }
    }

    private void drawItem(Graphics g, GamePanelItem item, int low, int high) {
        if (item == null) {
            return;
        }
        if (item.layer > high || item.layer < low) {
            return;
        }
        switch (item.type) {
            case 0: {
                GameIcon icon = (GameIcon)GameWorld.gameIcons.get(new Integer(item.intData1));
                icon.draw(g, 0, 0);
                break;
            }
            case 1: {
                GameIcon icon = (GameIcon)GameWorld.gameIcons.get(new Integer(item.intData1));
                icon.drawImageIcon(g, item.x + (item.w >> 1), item.y + (item.h >> 1));
                break;
            }
            case 2: {
                if (item.intData1 >= this.images.length || item.intData2 >= this.images[item.intData1].getFrameCount()) break;
                this.images[item.intData1].drawFrame(g, item.intData2, item.x, item.y, item.trans, item.anchor);
                break;
            }
            case 20: {
                if (item.intData1 >= this.images.length || item.intData2 >= this.images[item.intData1].getFrameCount()) break;
                int my = item.y;
                GamePanelItem hMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.hMessageId));
                GamePanelItem vMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.vMessageId));
                if (hMsgItem != null && ((Vector)hMsgItem.objData).size() > 0) {
                    my -= hMsgItem.h;
                }
                if (vMsgItem != null && ((Vector)vMsgItem.objData).size() > 0) {
                    my -= vMsgItem.h;
                }
                this.images[item.intData1].drawFrame(g, item.intData2, item.x, my, item.trans, item.anchor);
                break;
            }
            case 3: {
                g.setColor(item.intData1);
                g.drawRect((int)item.x, (int)item.y, (int)item.w, (int)item.h);
                break;
            }
            case 4: {
                g.setColor(item.intData1);
                g.fillRect((int)item.x, (int)item.y, (int)item.w, (int)item.h);
                break;
            }
            case 19: {
                Tool.fillAlphaRect(g, item.intData1, item.x, item.y, item.w, item.h);
                break;
            }
            case 5: {
                g.setColor(item.intData1);
                g.drawLine((int)item.x, (int)item.y, item.x + item.w, item.y + item.h);
                break;
            }
            case 6: {
                g.setColor(item.intData1);
                g.fillRect((int)item.x, (int)item.y, item.w * item.intData2 / 10000, (int)item.h);
                break;
            }
            case 7: {
                Tool.drawImageNumber(g, this.images[item.intData1], item.intData2, (String)item.objData, item.x, item.y, item.trans, item.anchor);
                break;
            }
            case 8: {
                this.images[item.intData1].drawFrame(g, item.intData2, item.x, item.y, item.trans, item.anchor);
                int[] animatePara = (int[])item.objData;
                if (this.tick < animatePara[5]) break;
                animatePara[5] = this.tick + animatePara[2];
                if (animatePara[0] == 0) {
                    item.x = (short)(item.x + animatePara[1]);
                    if ((animatePara[1] <= 0 || item.x < animatePara[4]) && (animatePara[1] >= 0 || item.x > animatePara[4])) break;
                    item.x = (short)animatePara[4];
                    animatePara[1] = -animatePara[1];
                    animatePara[4] = animatePara[4] - animatePara[3];
                    animatePara[3] = -animatePara[3];
                    break;
                }
                item.y = (short)(item.y + animatePara[1]);
                if ((animatePara[1] <= 0 || item.y < animatePara[4]) && (animatePara[1] >= 0 || item.y > animatePara[4])) break;
                item.y = (short)animatePara[4];
                animatePara[1] = -animatePara[1];
                animatePara[4] = animatePara[4] - animatePara[3];
                animatePara[3] = -animatePara[3];
                break;
            }
            case 9: {
                int[] sequences = (int[])item.objData;
                if (this.tick > item.tick + item.intData2) {
                    item.frame = item.frame < sequences.length - 1 ? ++item.frame : 0;
                    item.tick = this.tick;
                }
                if (!item.ready || item.intData1 < 0 || sequences[item.frame] < 0) break;
                this.images[item.intData1].drawFrame(g, sequences[item.frame], item.x, item.y, item.trans, item.anchor);
                break;
            }
            case 10: {
                int[] sequences = (int[])item.objData;
                if (this.tick - item.tick > 7) {
                    item.tick = this.tick;
                    item.frame = item.frame > 21 ? 0 : ++item.frame;
                }
                if (item.intData1 == 0) {
                    if (item.frame >= 0 && item.frame <= 6 || sequences[1] == -1) {
                        int frameWidth = this.images[sequences[2]].getFrameWidth(sequences[3] + sequences[4]);
                        this.images[sequences[2]].drawFrame(g, sequences[3] + 10, item.x - frameWidth, item.y + item.h, item.trans, item.anchor);
                        this.images[sequences[2]].drawFrame(g, sequences[3] + sequences[4], item.x, item.y + item.h, item.trans, item.anchor);
                        break;
                    }
                    if (item.frame < 7 || item.frame > 13) break;
                    this.images[sequences[0]].drawFrame(g, sequences[1], item.x, item.y, item.trans, item.anchor);
                    break;
                }
                int frameWidth = 0;
                if (sequences[1] != -1) {
                    this.images[sequences[0]].drawFrame(g, sequences[1], item.x, item.y + item.h, item.trans, item.anchor);
                    frameWidth = this.images[sequences[0]].getFrameWidth(sequences[1]);
                }
                if (item.frame % 2 != 0) break;
                this.images[sequences[2]].drawFrame(g, sequences[3] + sequences[4], item.x - frameWidth, item.y + item.h + 1, item.trans, item.anchor);
                break;
            }
            case 11: {
                this.images[item.intData1].drawFrame(g, item.intData2, item.x, item.y, item.trans, 20);
                int[] arr = (int[])item.objData;
                switch (arr[1]) {
                    case 2: {
                        if (item.frame < 2) {
                            g.setColor(0xFFFFFF);
                            g.drawRect((int)item.x, (int)item.y, item.w - 1, item.h - 1);
                            g.drawRect(item.x + 1, item.y + 1, item.w - 3, item.h - 3);
                            break;
                        }
                        if (item.frame < 4) {
                            g.setColor(0xFFFFFF);
                            g.drawRect(item.x - 1, item.y - 1, item.w + 1, item.h + 1);
                            g.drawRect((int)item.x, (int)item.y, item.w - 1, item.h - 1);
                            break;
                        }
                        if (item.frame >= 6) break;
                        g.setColor(0xFFFFFF);
                        g.drawRect(item.x - 1, item.y - 1, item.w + 1, item.h + 1);
                        break;
                    }
                    case 1: {
                        Tool.fillAlphaRect(g, arr[3], item.x, item.y + item.h - arr[2], item.w, arr[2]);
                    }
                }
                break;
            }
            case 12: {
                Vector vec;
                Vector msgs = (Vector)item.objData;
                Vector colors = (Vector)item.objData2;
                if (msgs.size() <= 0) break;
                int clipx = g.getClipX();
                int clipy = g.getClipY();
                int clipw = g.getClipWidth();
                int cliph = g.getClipHeight();
                g.setClip((int)item.x, (int)item.y, (int)item.w, (int)item.h);
                Tool.fillAlphaRect(g, item.intData1, item.x, item.y, item.w, item.h);
                Object ii = msgs.elementAt(0);
                if (ii instanceof String) {
                    vec = Tool.formatString((String)ii, 100000, Utilities.font, true);
                    msgs.setElementAt(vec, 0);
                } else {
                    vec = (Vector)ii;
                }
                int color = (Integer)colors.elementAt(0);
                int strWidth = 0;
                g.setClip((int)item.x, (int)item.y, (int)item.w, (int)item.h);
                strWidth = Tool.drawMixedText(g, vec, item.x + item.w - (this.tick - item.tick) * 4, item.y + (item.h >> 1) - (Utilities.font.getHeight() >> 1), color, 0, false, 20);
                if ((this.tick - item.tick) * 4 > strWidth + item.w - 20) {
                    msgs.removeElementAt(0);
                    colors.removeElementAt(0);
                    item.tick = this.tick;
                }
                g.setClip(clipx, clipy, clipw, cliph);
                break;
            }
            case 13: {
                Vector msgs = (Vector)item.objData;
                Vector colors = (Vector)item.objData2;
                if (msgs.size() <= 0) break;
                Tool.fillAlphaRect(g, item.intData1, item.x, item.y, item.w, item.h);
                int clipx = g.getClipX();
                int clipy = g.getClipY();
                int clipw = g.getClipWidth();
                int cliph = g.getClipHeight();
                g.setClip((int)item.x, (int)item.y, (int)item.w, (int)item.h);
                Vector str = (Vector)msgs.elementAt(0);
                int color = (Integer)colors.elementAt(0);
                if (item.intData2 == 0) {
                    Tool.drawMixedText(g, str, (int)item.x, item.y + (item.h >> 2) - (Utilities.font.getHeight() >> 1) + 2, color, 0, false, 20);
                    if (msgs.size() > 1) {
                        str = (Vector)msgs.elementAt(1);
                        color = (Integer)colors.elementAt(1);
                        Tool.drawMixedText(g, str, (int)item.x, item.y + item.h / 2 + (item.h >> 2) - (Utilities.font.getHeight() >> 1) + 2, color, 0, false, 20);
                    }
                    if (this.tick - item.tick > 20) {
                        item.intData2 = 1;
                        item.tick = this.tick;
                    }
                } else {
                    Tool.drawMixedText(g, str, (int)item.x, item.y - (this.tick - item.tick) * 2 + (item.h >> 2) - (Utilities.font.getHeight() >> 1) + 2, color, 0, false, 20);
                    if (msgs.size() > 1) {
                        str = (Vector)msgs.elementAt(1);
                        color = (Integer)colors.elementAt(1);
                        Tool.drawMixedText(g, str, (int)item.x, item.y + item.h / 2 - (this.tick - item.tick) * 2 + (item.h >> 2) - (Utilities.font.getHeight() >> 1) + 2, color, 0, false, 20);
                    }
                    if (msgs.size() > 2) {
                        str = (Vector)msgs.elementAt(2);
                        color = (Integer)colors.elementAt(2);
                        Tool.drawMixedText(g, str, (int)item.x, item.y + item.h - (this.tick - item.tick) * 2 + (item.h >> 2) - (Utilities.font.getHeight() >> 1) + 2, color, 0, false, 20);
                    }
                    if ((this.tick - item.tick) * 2 > Utilities.font.getHeight()) {
                        item.intData2 = 0;
                        msgs.removeElementAt(0);
                        colors.removeElementAt(0);
                        if (msgs.size() == 0) {
                            this.hMessageItem.y = (short)(this.vMessageItem.y + this.vMessageItem.h - this.hMessageItem.h);
                        }
                    }
                }
                g.setClip(clipx, clipy, clipw, cliph);
                break;
            }
            case 14: {
                int overTime = VMCounter.getSaveTimeSec((Integer)item.objData);
                if (overTime < 0) {
                    overTime = 0;
                }
                Tool.drawImageNumber(g, this.images[item.intData1], item.intData2, String.valueOf(overTime), item.x, item.y, item.trans, item.anchor);
                int offestX = String.valueOf(overTime).length() * this.images[item.intData1].getFrameWidth(item.intData2);
                Tool.draw3DString(g, "'", item.x + offestX, item.y, 0xFFFFFF, 0, item.anchor);
                if (overTime != 0) break;
                this.removeItem(item.id);
                this.sendCommand(15060, item.objData2);
                break;
            }
            case 15: {
                int my = 0;
                GamePanelItem hMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.hMessageId));
                GamePanelItem vMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.vMessageId));
                my = hMsgItem != null && ((Vector)hMsgItem.objData).size() > 0 ? hMsgItem.y - item.h : (vMsgItem != null && ((Vector)vMsgItem.objData).size() > 0 ? vMsgItem.y - item.h : vMsgItem.y + vMsgItem.h - item.h);
                if (item.frame > 1) {
                    int w = this.images[item.intData1].getFrameWidth(item.intData2);
                    this.images[item.intData1].drawFrame(g, item.intData2, item.x, my, 0, 36);
                    Tool.draw3DString(g, (String)item.objData, item.x + w, my, (Integer)item.objData2, 0, 36);
                    if (VM.getApiVersion() <= 3 || item.objData3 == null) break;
                    int[] dataArr = (int[])item.objData3;
                    short ix = item.x;
                    int iy = my + 1;
                    if (dataArr[2] > 0) {
                        this.images[dataArr[0]].drawFrame(g, dataArr[1] + 10, ix + w - (String.valueOf(dataArr[2]).length() * this.images[dataArr[0]].getFrameWidth(dataArr[1]) + this.images[dataArr[0]].getFrameWidth(dataArr[1] + 10)), iy, 0, 36);
                    }
                    Tool.drawImageNumber(g, this.images[dataArr[0]], dataArr[1], String.valueOf(dataArr[2]), ix + w, iy, 0, 40);
                    break;
                }
                if (item.frame < 0) break;
                g.setColor(0xFFFFFF);
                g.fillRect((int)item.x, my - item.h, (int)item.w, (int)item.h);
                break;
            }
            case 16: {
                int my = 0;
                GamePanelItem hMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.hMessageId));
                GamePanelItem vMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.vMessageId));
                my = hMsgItem != null && ((Vector)hMsgItem.objData).size() > 0 ? hMsgItem.y : (vMsgItem != null && ((Vector)vMsgItem.objData).size() > 0 ? (int)vMsgItem.y : vMsgItem.y + vMsgItem.h);
                if (item.frame > 1) {
                    int[] dataArr = (int[])this.obtainValue.objData;
                    int ix = item.x;
                    this.images[item.intData1].drawFrame(g, item.intData2, ix, my, 0, 36);
                    ix += this.images[item.intData1].getFrameWidth(item.intData2);
                    if (dataArr[2] >= 0) {
                        this.images[dataArr[0]].drawFrame(g, dataArr[1] + 10, ix, my, 0, 36);
                        ix += this.images[dataArr[0]].getFrameWidth(dataArr[1] + 10);
                    }
                    Tool.drawImageNumber(g, this.images[dataArr[0]], dataArr[1], String.valueOf(dataArr[2]), ix, my, 0, 36);
                    break;
                }
                if (item.frame < 0) break;
                g.setColor(0xFFFFFF);
                g.fillRect((int)item.x, my - item.h, (int)item.w, (int)item.h);
                break;
            }
            case 17: {
                int my = item.y;
                GamePanelItem hMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.hMessageId));
                GamePanelItem vMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.vMessageId));
                my = hMsgItem != null && ((Vector)hMsgItem.objData).size() > 0 ? hMsgItem.y - item.h : (vMsgItem != null && ((Vector)vMsgItem.objData).size() > 0 ? vMsgItem.y - item.h : vMsgItem.y + vMsgItem.h - item.h);
                g.setColor(item.intData1);
                if (item.objData == null) break;
                Tool.draw3DString(g, (String)item.objData, item.x, my, item.intData1, item.intData2, item.anchor);
                break;
            }
            case 18: {
                int my = item.y;
                int[] strData = (int[])item.objData2;
                if (strData[1] == 1) {
                    GamePanelItem hMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.hMessageId));
                    GamePanelItem vMsgItem = (GamePanelItem)this.itemTable.get(new Integer(this.vMessageId));
                    my = hMsgItem != null && ((Vector)hMsgItem.objData).size() > 0 ? hMsgItem.y - item.h - strData[4] : (vMsgItem != null && ((Vector)vMsgItem.objData).size() > 0 ? vMsgItem.y - item.h - strData[4] : vMsgItem.y + vMsgItem.h - item.h - strData[4]);
                }
                Font f = item.objData3 != null ? (Font)item.objData3 : Utilities.font;
                Vector v = Tool.formatString((String)item.objData, GameMain.viewWidth, f, true);
                if (strData[0] == 1) {
                    Tool.drawMixedText(g, v, (int)item.x, my, strData[2], strData[3], true, (int)item.anchor, f);
                } else {
                    Tool.drawMixedText(g, v, (int)item.x, my, strData[2], strData[3], false, (int)item.anchor, f);
                }
                v = null;
                if (VM.getApiVersion() < 2) break;
                g.setFont(Utilities.font);
            }
        }
    }

    private void sort() {
        int i;
        int t;
        Object temp = null;
        int n = this.itemList.size();
        Object[] items = new GamePanelItem[n];
        this.itemList.copyInto(items);
        for (t = 7; t < 17 && GameView.sortTable[t] <= n / 9; ++t) {
        }
        while (t >= 0) {
            int h;
            for (i = h = GameView.sortTable[t]; i < n; ++i) {
                temp = items[i];
                for (int j = i - h; j >= 0 && ((GamePanelItem)items[j]).layer > ((GamePanelItem)temp).layer; j -= h) {
                    items[j + h] = items[j];
                }
                items[j + h] = temp;
            }
            --t;
        }
        this.itemList.removeAllElements();
        for (i = 0; i < n; ++i) {
            this.itemList.addElement(items[i]);
        }
    }

    public int createTemplate() {
        GamePanelTemplate t = new GamePanelTemplate();
        t.id = this.templateIDKey.nextKey();
        this.templateTable.put(new Integer(t.id), t);
        return t.id;
    }

    public void addTemplateItem(int tid, byte type, int layer, byte trans, byte anchor, short x, short y, short w, short h, int intData1, int intData2, Object objData, Object objData2, int frame, int tick) {
        GamePanelTemplate t = (GamePanelTemplate)this.templateTable.get(new Integer(tid));
        GamePanelItem newItem = new GamePanelItem(-1, type);
        newItem.layer = layer;
        newItem.trans = trans;
        newItem.anchor = anchor;
        newItem.x = x;
        newItem.y = y;
        newItem.w = w;
        newItem.h = h;
        newItem.intData1 = intData1;
        newItem.intData2 = intData2;
        newItem.objData = objData;
        newItem.objData2 = objData2;
        newItem.frame = frame;
        newItem.tick = tick;
        GamePanelItem[] arr = new GamePanelItem[t.items.length + 1];
        System.arraycopy(t.items, 0, arr, 0, t.items.length);
        arr[t.items.length] = newItem;
        t.items = arr;
    }

    public int createWithTemplate(int tid, short x, short y, int[] iparam, Object[] oparam) {
        GamePanelTemplate t = (GamePanelTemplate)this.templateTable.get(new Integer(tid));
        int len = t.items.length;
        int ret = -1;
        for (int i = 0; i < len; ++i) {
            GamePanelItem titem = t.items[i];
            GamePanelItem nitem = new GamePanelItem(this.idKey.nextKey(), titem.type);
            nitem.templateID = t.id;
            nitem.templateItem = titem;
            this.configItem(nitem, x, y, iparam, oparam);
            this.addItem(nitem);
            if (ret != -1) continue;
            ret = nitem.id;
        }
        return ret;
    }

    public void reconfigTemplateItems(int tid, int firstID, short x, short y, int[] iparam, Object[] oparam) {
        GamePanelTemplate t = (GamePanelTemplate)this.templateTable.get(new Integer(tid));
        int minID = firstID;
        int maxID = firstID + t.items.length;
        int size = this.itemList.size();
        for (int i = 0; i < size; ++i) {
            GamePanelItem item = (GamePanelItem)this.itemList.elementAt(i);
            if (item.id < minID || item.id >= maxID) continue;
            this.configItem(item, x, y, iparam, oparam);
        }
    }

    public void removeTemplateItems(int tid, int firstID) {
        GamePanelTemplate t = (GamePanelTemplate)this.templateTable.get(new Integer(tid));
        int minID = firstID;
        int maxID = firstID + t.items.length;
        int size = this.itemList.size();
        for (int i = size - 1; i >= 0; --i) {
            GamePanelItem item = (GamePanelItem)this.itemList.elementAt(i);
            if (item.id < minID || item.id >= maxID) continue;
            this.itemTable.remove(new Integer(item.id));
            this.itemList.removeElementAt(i);
        }
        this.needSort = true;
    }

    private void configItem(GamePanelItem nitem, short x, short y, int[] iparam, Object[] oparam) {
        int index;
        GamePanelItem titem = nitem.templateItem;
        nitem.layer = titem.layer;
        nitem.trans = titem.trans < 0 ? (byte)iparam[-1 - titem.trans] : titem.trans;
        nitem.anchor = titem.anchor < 0 ? (byte)iparam[-1 - titem.anchor] : titem.anchor;
        nitem.x = (short)(titem.x + x);
        nitem.y = (short)(titem.y + y);
        nitem.w = titem.w < 0 ? (short)iparam[-1 - titem.w] : titem.w;
        nitem.h = titem.h < 0 ? (short)iparam[-1 - titem.h] : titem.h;
        nitem.intData1 = titem.intData1 < 0 ? iparam[-1 - titem.intData1] : titem.intData1;
        nitem.intData2 = titem.intData2 < 0 ? iparam[-1 - titem.intData2] : titem.intData2;
        nitem.objData = titem.objData != null && titem.objData instanceof Integer ? ((index = ((Integer)titem.objData).intValue()) < 0 ? oparam[-1 - index] : titem.objData) : titem.objData;
        nitem.objData2 = titem.objData2 != null && titem.objData2 instanceof Integer ? ((index = ((Integer)titem.objData2).intValue()) < 0 ? oparam[-1 - index] : titem.objData2) : titem.objData2;
        nitem.frame = titem.frame < 0 ? iparam[-1 - titem.frame] : titem.frame;
        nitem.tick = titem.tick + this.tick;
        nitem.ready = true;
    }

    public int getMessageCount(int type) {
        if (type == 0) {
            Vector vmsgs = (Vector)this.vMessageItem.objData;
            int count = vmsgs.size();
            return count;
        }
        Vector hmsgs = (Vector)this.hMessageItem.objData;
        int count = hmsgs.size();
        return count;
    }
}

