/*
 * Decompiled with CFR 0.152.
 */
package com.pip.sanguo;

import com.pip.common.Tool;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameWorld;
import com.pip.ui.VMGame;
import javax.microedition.lcdui.Graphics;

public class GameNetPlayer
extends GameSprite {
    public long lastSyncMoveTime;
    public boolean noNeedRemove;
    public boolean beSkiped;

    public GameNetPlayer(int type, int id, int instanceId) {
        super(type, id, instanceId);
    }

    public static GameNetPlayer createGameNetPlayer(int id, int instanceId) {
        GameNetPlayer gameNetPlayer = new GameNetPlayer(1, id, instanceId);
        gameNetPlayer.vm = VMGame.getVMGame("game_netplayer").getVM();
        gameNetPlayer.sendCommand(10005, new Integer(instanceId));
        gameNetPlayer.sendCommand(10010, null);
        gameNetPlayer.lastSyncMoveTime = Tool.getSystemTime();
        return gameNetPlayer;
    }

    public void vm_sprite_set_can_attack(boolean _canAttact) {
        super.vm_sprite_set_can_attack(_canAttact);
        if (GameWorld.player.target == this) {
            this.sendCommand(10100, new Integer(1));
        }
    }

    public void vm_player_set_no_need_remove(boolean _need) {
        this.noNeedRemove = _need;
        if (!this.noNeedRemove && this.isOutView) {
            GameWorld.doDestorySprite(this, false, false);
        }
    }

    public boolean vm_player_get_no_need_remove() {
        return this.noNeedRemove;
    }

    public boolean vm_player_get_be_skiped() {
        return this.beSkiped;
    }

    public void draw(Graphics g, int viewX, int viewY) {
        this.drawAnimate(g, viewX, viewY, true);
        this.sprite.draw(g, viewX, viewY);
        this.drawAnimate(g, viewX, viewY, false);
    }

    public void cycle() {
        super.cycle();
        this.sprite.cycle();
        this.setFollowersPosition();
        if (!this.noNeedRemove && Tool.getSystemTime() - this.lastSyncMoveTime > (long)GameMain.dropNetplayerTime) {
            GameWorld.requestDestorySprite(this);
        }
    }

    public boolean isHumanAnimate() {
        return true;
    }
}

