/*
 * Decompiled with CFR 0.152.
 */
package com.pip.resource;

import com.pip.common.Tool;
import com.pip.engine.AnimateCache;
import com.pip.engine.GamePackage;
import com.pip.image.ImageSet;
import com.pip.io.UASegment;
import com.pip.resource.ResourceDatabase;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameRole;
import com.pip.sanguo.GameView;
import com.pip.sanguo.GameWorld;
import com.pip.sanguo.SanguoMIDlet;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceAsynLoader
implements Runnable {
    private Tool keyMaker = new Tool();
    private Vector waitingList = new Vector();
    private Vector queue = new Vector();
    private Hashtable table = new Hashtable();
    private Vector resourceQueue = new Vector();
    private Hashtable resourceTable = new Hashtable();
    public static final byte AYSN_LOAD_TYPE_BYTES = 0;
    public static final byte AYSN_LOAD_TYPE_IMAGE = 1;
    public static final byte AYSN_LOAD_TYPE_IMAGE_CACHE = 2;
    public static final byte AYSN_LOAD_TYPE_VMGAME = 3;
    public static final byte AYSN_LOAD_TYPE_WORLD = 4;
    public static final byte AYSN_LOAD_TYPE_ROLE = 5;
    public static final byte AYSN_LOAD_TYPE_PKG = 6;
    public static final byte AYSN_LOAD_TYPE_MAP = 7;
    public static final byte AYSN_LOAD_TYPE_IMAGE_BYTES = 100;
    public static final byte AYSN_LOAD_TYPE_FIND_RESOURCE = 101;
    public static final byte AYSN_LOAD_TYPE_SAVE_DATABASE_FILE = 110;
    public static final byte AYSN_LOAD_TYPE_SAVE_DATABASE_INFOMATION = 111;
    public static Vector segments = new Vector();
    boolean loadingPkg = false;

    public ResourceAsynLoader() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Vector vector = this.queue;
        synchronized (vector) {
            this.saveAllResource();
            this.queue.removeAllElements();
            this.resourceQueue.removeAllElements();
            this.resourceTable.clear();
            this.table.clear();
        }
    }

    public byte[] getResource(String name) {
        Integer rkey = (Integer)this.resourceTable.get(name);
        if (rkey != null) {
            AyncLoadItem item = (AyncLoadItem)this.table.get(rkey);
            return item.data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatabaseAction(byte type, ResourceDatabase database, String name, byte[] data, int version) {
        Vector vector = this.waitingList;
        synchronized (vector) {
            AyncLoadItem item = new AyncLoadItem();
            item.key = this.keyMaker.nextKey();
            item.type = type;
            item.ready = false;
            item.name = name;
            item.data = data;
            item.objData = database;
            item.intData = version;
            this.waitingList.addElement(item);
            if (item.type == 110) {
                this.resourceTable.put(item.name, new Integer(item.key));
                this.table.put(new Integer(item.key), item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addLoad(byte type, String name, byte[] data) {
        Vector vector = this.waitingList;
        synchronized (vector) {
            AyncLoadItem item = new AyncLoadItem();
            item.key = this.keyMaker.nextKey();
            item.type = type;
            item.ready = false;
            item.name = name;
            item.data = null;
            item.imgData = null;
            item.objData = null;
            switch (type) {
                case 100: {
                    item.data = data;
                }
            }
            this.waitingList.addElement(item);
            return item.key;
        }
    }

    public boolean checkLoad(int key) {
        if (key >= 0) {
            AyncLoadItem item = (AyncLoadItem)this.table.get(new Integer(key));
            if (item != null) {
                return item.ready;
            }
            return false;
        }
        if (key == -2) {
            return this.resourceQueue.size() <= 0;
        }
        return false;
    }

    public Object getLoad(int key) {
        AyncLoadItem item = (AyncLoadItem)this.table.get(new Integer(key));
        if (item != null) {
            this.table.remove(new Integer(key));
            switch (item.type) {
                case 0: {
                    return item.data;
                }
                case 1: 
                case 2: {
                    return item.imgData;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transWaitingToQueue() {
        Vector vector = this.waitingList;
        synchronized (vector) {
            int count = this.waitingList.size();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    AyncLoadItem item = (AyncLoadItem)this.waitingList.elementAt(i);
                    switch (item.type) {
                        case 110: 
                        case 111: {
                            this.resourceQueue.addElement(new Integer(item.key));
                            if (item.type != 110) break;
                            this.resourceTable.put(item.name, new Integer(item.key));
                            break;
                        }
                        default: {
                            this.queue.addElement(new Integer(item.key));
                        }
                    }
                    this.table.put(new Integer(item.key), item);
                }
                this.waitingList.removeAllElements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int breakTimes = 0;
        while (SanguoMIDlet.isRun) {
            if (GameMain.inCycle) {
                if (breakTimes < 2) {
                    ++breakTimes;
                    try {
                        Thread.sleep(80L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                breakTimes = 0;
            }
            long startTime = System.currentTimeMillis();
            try {
                Object segment;
                if (segments.size() > 0) {
                    segment = (UASegment)segments.elementAt(0);
                    segments.removeElementAt(0);
                    switch (((UASegment)segment).type) {
                        case 2382: {
                            Tool.recvGetFile((UASegment)segment);
                        }
                    }
                }
                segment = this.queue;
                synchronized (segment) {
                    this.transWaitingToQueue();
                    if (this.queue.size() > 0) {
                        Integer itemKey = (Integer)this.queue.firstElement();
                        boolean succ = true;
                        AyncLoadItem item = (AyncLoadItem)this.table.get(itemKey);
                        if (item != null) {
                            switch (item.type) {
                                case 0: {
                                    item.data = GameMain.resourceManager.findResource(item.name);
                                    item.ready = true;
                                    break;
                                }
                                case 1: {
                                    item.imgData = GameMain.resourceManager.findImageSet(item.name, false);
                                    item.ready = true;
                                    break;
                                }
                                case 2: {
                                    item.imgData = GameMain.resourceManager.findImageSet(item.name, true);
                                    item.ready = true;
                                    break;
                                }
                                case 3: {
                                    int vmKey = VMGame.loadVMGame(item.name, (byte)0, true);
                                    VMGame gameWorld = VMGame.getVMGame("game_world");
                                    if (gameWorld != null) {
                                        VM vm;
                                        VM vM = vm = gameWorld.getVM();
                                        synchronized (vM) {
                                            vm.callback("LoadEtfEnd1", new int[]{vm.makeTempObject(item.name), vmKey});
                                        }
                                    }
                                    item.ready = true;
                                    break;
                                }
                                case 4: {
                                    GameMain.world = new GameWorld();
                                    item.ready = true;
                                    break;
                                }
                                case 5: {
                                    UASegment segment2 = (UASegment)GameWorld.instance.readGameData("game_role_create");
                                    GameWorld.instance.removeGameData("game_role_create");
                                    segment2.reset();
                                    int id = segment2.readInt();
                                    String name = segment2.readString();
                                    GameRole role = GameRole.createRole(id, name);
                                    role.faction = segment2.readByte();
                                    role.sprite.setPosition(segment2.readInt(), segment2.readInt());
                                    role.sprite.setDir(segment2.readInt());
                                    role.sprite.setAnimateDir(role.sprite.getDir());
                                    role.state = segment2.readInt();
                                    GameWorld.player = role;
                                    GameWorld.addSprite(GameWorld.player);
                                    item.ready = true;
                                    break;
                                }
                                case 6: {
                                    try {
                                        if (GameWorld.pkgData == null) {
                                            succ = false;
                                            break;
                                        }
                                        if (this.loadingPkg) break;
                                        this.loadingPkg = true;
                                        GameWorld.gamePackage = new GamePackage(GameWorld.pkgData);
                                        GameWorld.currentAreaId = GameWorld.gamePackage.areaID;
                                        GameView.mapNpcAnimateNeedLoad = true;
                                        GameWorld.pkgData = null;
                                        item.ready = true;
                                        this.loadingPkg = false;
                                    }
                                    catch (Exception e) {
                                        succ = false;
                                    }
                                    break;
                                }
                                case 7: {
                                    if (GameWorld.gamePackage == null || this.loadingPkg) break;
                                    GameWorld.loadMap();
                                    if (GameWorld.gameView == null || GameWorld.gameView.pathTileWidth == 0) break;
                                    item.ready = true;
                                    break;
                                }
                                case 100: {
                                    item.imgData = new ImageSet(item.data);
                                    item.imgData.fileName = item.name;
                                    AnimateCache.recvImage(item.name, item.imgData);
                                    this.table.remove(itemKey);
                                    item.ready = true;
                                    break;
                                }
                                case 101: {
                                    GameMain.resourceManager.requestResourceImpl(item.name);
                                    this.table.remove(itemKey);
                                    item.ready = true;
                                }
                            }
                        }
                        if (succ) {
                            this.queue.removeElementAt(0);
                        }
                    }
                }
                if (this.resourceQueue.size() <= 0 || !GameWorld.inLoading) continue;
                this.saveAllResource();
            }
            catch (Exception e) {}
            continue;
            finally {
                try {
                    if (this.queue.size() > 0) {
                        Thread.sleep(20L);
                        continue;
                    }
                    Thread.sleep(80L);
                }
                catch (Exception e) {}
            }
        }
    }

    private void saveAllResource() {
        int rsize = this.resourceQueue.size();
        block4: for (int i = 0; i < rsize; ++i) {
            Integer itemKey = (Integer)this.resourceQueue.elementAt(i);
            AyncLoadItem item = (AyncLoadItem)this.table.get(itemKey);
            switch (item.type) {
                case 110: {
                    ResourceDatabase database = (ResourceDatabase)item.objData;
                    database.saveFile(item.name, item.data, item.intData);
                    this.table.remove(itemKey);
                    item.ready = true;
                    continue block4;
                }
                case 111: {
                    ResourceDatabase database = (ResourceDatabase)item.objData;
                    database.saveInformation(item.intData == 1);
                    this.table.remove(itemKey);
                    item.ready = true;
                }
            }
        }
        GameMain.resourceManager.saveResourceInfo(true);
        this.resourceQueue.removeAllElements();
        this.resourceTable.clear();
    }

    private class AyncLoadItem {
        public byte type;
        public boolean ready;
        public int key;
        public String name;
        public byte[] data;
        public ImageSet imgData;
        public Object objData;
        public int intData;

        private AyncLoadItem() {
        }
    }
}

