/*
 * Decompiled with CFR 0.152.
 */
package com.pip.image;

import com.pip.image.RGBGraphics;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RGBImage {
    private int[] data;
    private Object[] immData;
    private boolean immMode;
    private int width;
    private int height;
    private int foreGround = -1;
    private int alpha = 255;
    private int[] clearLine;

    private RGBImage() {
    }

    public static RGBImage createImage(int width, int height) {
        RGBImage image = new RGBImage();
        image.clearLine = new int[width];
        image.width = width;
        image.height = height;
        image.data = new int[width * height];
        image.immMode = false;
        return image;
    }

    public static RGBImage createImage(String fname) throws IOException {
        Image img = Image.createImage((String)fname);
        return new RGBImage(img);
    }

    public static RGBImage createImage(byte[] in, int offset, int length) throws IOException {
        Image img = Image.createImage((byte[])in, (int)offset, (int)length);
        return new RGBImage(img);
    }

    public static RGBImage createRGBImage(int[] in, int width, int height, boolean alpha) {
        RGBImage result = RGBImage.createImage(width, height);
        System.arraycopy(in, 0, result.data, 0, Math.min(in.length, result.data.length));
        if (!alpha) {
            int i;
            for (i = 0; i < result.clearLine.length; ++i) {
                result.clearLine[i] = 0;
            }
            i = 0;
            while (i < result.data.length) {
                int n = i++;
                result.data[n] = result.data[n] | 0xFF000000;
            }
        }
        return result;
    }

    public RGBImage(Image image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.clearLine = new int[this.width];
        this.data = new int[this.width * this.height];
        image.getRGB(this.data, 0, this.width, 0, 0, this.width, this.height);
        this.immMode = true;
        this.makeImmData(this.data);
        this.data = null;
    }

    private RGBImage(Image image, int alpha) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.clearLine = new int[this.width];
        this.data = new int[this.width * this.height];
        image.getRGB(this.data, 0, this.width, 0, 0, this.width, this.height);
        this.immMode = true;
        this.makeImmData(this.data, alpha);
        this.data = null;
    }

    public RGBImage(int[] tmp, int w, int h) {
        this.width = w;
        this.height = h;
        this.clearLine = new int[this.width];
        this.immMode = true;
        this.makeImmData(tmp, this.alpha);
        this.data = null;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    private void makeImmData(int[] array, int alpha) {
        int[] singleLine = new int[this.width];
        this.immData = new Object[this.height];
        for (int i = 0; i < this.height; ++i) {
            System.arraycopy(array, i * this.width, singleLine, 0, this.width);
            Vector<int[]> line = new Vector<int[]>();
            int j = 0;
            while (j < this.width) {
                int k;
                if ((singleLine[j] & 0xFF000000) == 0) {
                    ++j;
                    continue;
                }
                for (k = j; k < this.width && (singleLine[k] & 0xFF000000) != 0; ++k) {
                }
                int size = k - j;
                int[] subData = new int[size + 2];
                subData[0] = j;
                subData[1] = size;
                System.arraycopy(singleLine, j, subData, 2, size);
                line.addElement(subData);
                j = k + 1;
            }
            if (line.size() > 0) {
                Object[] tmp = new Object[line.size()];
                line.copyInto(tmp);
                this.immData[i] = tmp;
                continue;
            }
            this.immData[i] = null;
        }
    }

    private void makeImmData(int[] array) {
        int[] singleLine = new int[this.width];
        this.immData = new Object[this.height];
        for (int i = 0; i < this.height; ++i) {
            System.arraycopy(array, i * this.width, singleLine, 0, this.width);
            Vector<int[]> line = new Vector<int[]>();
            int j = 0;
            while (j < this.width) {
                int k;
                if (singleLine[j] == -1 || singleLine[j] == 0xFFFFFF || singleLine[j] == 0) {
                    ++j;
                    continue;
                }
                for (k = j; k < this.width && singleLine[k] != -1 && singleLine[k] != 0xFFFFFF && singleLine[k] != 0; ++k) {
                }
                int size = k - j;
                int[] subData = new int[size + 2];
                subData[0] = j;
                subData[1] = size;
                System.arraycopy(singleLine, j, subData, 2, size);
                line.addElement(subData);
                j = k + 1;
            }
            if (line.size() > 0) {
                Object[] tmp = new Object[line.size()];
                line.copyInto(tmp);
                this.immData[i] = tmp;
                continue;
            }
            this.immData[i] = null;
        }
    }

    private void drawImmData(ImageRGBGraphics g, int x, int y, int src_x, int src_y, int src_w, int src_h) {
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        if (x > cx + cw || y > cy + ch) {
            return;
        }
        int rx = x;
        int ry = y;
        int rw = Math.min(src_w, this.getWidth());
        int rh = Math.min(src_h, this.getHeight());
        if (rx < cx) {
            rw += rx - cx;
            src_x -= rx - cx;
            rx = cx;
        }
        if (ry < cy) {
            rh += ry - cy;
            src_y -= ry - cy;
            ry = cy;
        }
        if (rx + rw > cx + cw) {
            rw = cx + cw - rx;
        }
        if (ry + rh > cy + ch) {
            rh = cy + ch - ry;
        }
        int tx = src_x;
        int ty = src_y;
        for (int i = 0; i < rh; ++i) {
            if (i + ty < 0 || i + ty >= this.immData.length || this.immData[i + ty] == null) continue;
            Object[] data = (Object[])this.immData[i + ty];
            for (int j = 0; j < data.length; ++j) {
                int[] subData = (int[])data[j];
                int subx = subData[0];
                int subw = subData[1];
                if (subx < tx) {
                    subw -= tx - subx;
                    subx = tx;
                }
                if (subx + subw > tx + rw) {
                    subw -= subx + subw - (tx + rw);
                }
                if (subw < 0) continue;
                if (this.alpha < 255) {
                    for (int k = 0; k < subw; ++k) {
                        int tmp = (i + ry) * ((ImageRGBGraphics)g).rgbImage.width + rx + subx - src_x + k;
                        ((ImageRGBGraphics)g).rgbImage.data[tmp] = this.alphaColor(((ImageRGBGraphics)g).rgbImage.data[tmp], subData[2 + (subx - subData[0]) + k], this.alpha);
                    }
                    continue;
                }
                System.arraycopy(subData, 2 + (subx - subData[0]), ((ImageRGBGraphics)g).rgbImage.data, (i + ry) * ((ImageRGBGraphics)g).rgbImage.width + rx + subx - src_x, subw);
            }
        }
    }

    private int alphaColor(int color1, int color2, int alpha) {
        if (alpha == 128) {
            int mc = color1 + color2;
            return (mc & 0xFEFEFE) + ((color1 ^ color2 ^ mc) & 0x1010100) >>> 1;
        }
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int nr = (r1 * (255 - alpha) + r2 * alpha) / 255;
        int ng = (g1 * (255 - alpha) + g2 * alpha) / 255;
        int nb = (b1 * (255 - alpha) + b2 * alpha) / 255;
        nr = r1 + r2 >> 1;
        ng = g1 + g2 >> 1;
        nb = b1 + b2 >> 1;
        return nr << 16 | ng << 8 | nb | 0xFF000000;
    }

    private void setForeground(int value) {
        this.foreGround = value;
    }

    private int getForeground() {
        return this.foreGround;
    }

    public void clear() {
        for (int i = 0; i < this.height; ++i) {
            System.arraycopy(this.clearLine, 0, this.data, i * this.width, this.width);
        }
    }

    protected int[] getLine(int x, int y, int width) {
        int tmp = y * this.width + x;
        if (tmp < 0 || width <= 0) {
            return new int[0];
        }
        int[] result = new int[width];
        System.arraycopy(this.data, tmp, result, 0, width);
        return result;
    }

    private void setPoint(int x, int y) {
        this.data[y * this.width + x] = this.foreGround;
    }

    protected void setLine(int[] inData, int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        System.arraycopy(inData, 0, this.data, y * this.width + x, inData.length);
    }

    public RGBGraphics getGraphics() {
        if (this.immMode) {
            return null;
        }
        return new ImageRGBGraphics(this);
    }

    public void draw(Graphics g, int x, int y) {
        g.drawRGB(this.data, 0, this.width, x, y, this.width, this.height, false);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    class ImageRGBGraphics
    extends RGBGraphics {
        private RGBImage rgbImage;
        private Font font;
        private Image fontImage;

        public ImageRGBGraphics(RGBImage image) {
            this.rgbImage = image;
            this.drawWidth = this.rgbImage.getWidth();
            this.drawHeight = this.rgbImage.getHeight();
            this.setClip(0, 0, this.drawWidth, this.drawHeight);
            this.font = Font.getFont((int)0, (int)0, (int)8);
        }

        public void copyArea(int x_src, int y_src, int width, int height, int x_dest, int y_dest, int anchor) {
            for (int i = 0; i < height; ++i) {
                int[] subLine = this.rgbImage.getLine(x_src, y_src, width);
                this.rgbImage.setLine(subLine, this.correctX(x_dest, width, anchor), this.correctY(y_dest, height, anchor));
            }
        }

        public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            System.out.println("not support drawArc");
        }

        public void drawChar(char character, int x, int y, int anchor) {
            System.out.println("not support drawChare");
        }

        public void drawChars(char[] data, int offset, int length, int x, int y, int anchor) {
            System.out.println("not support drawChars");
        }

        public void drawImage(RGBImage image, int x, int y, int anchor) {
            int cx = this.correctX(x, image.getWidth(), anchor);
            int cy = this.correctY(y, image.getHeight(), anchor);
            this.saveClip();
            this.clipRect(cx, cy, image.getWidth(), image.getHeight());
            if (image.immMode) {
                image.drawImmData(this, cx, cy, 0, 0, image.getWidth(), image.getHeight());
            } else {
                for (int i = this.deCorrectY(this.clipY, image.getHeight(), anchor) - y; i < this.clipY - cy + this.clipHeight; ++i) {
                    int[] subLine = null;
                    subLine = image.getLine(this.deCorrectX(this.clipX, image.getWidth(), anchor) - x, i, this.clipWidth);
                    this.rgbImage.setLine(subLine, cx, cy + i);
                }
            }
            this.restoreClip();
        }

        public void drawCircle(int x0, int y0, int radius) {
            int f = 1 - radius;
            int ddF_x = 0;
            int ddF_y = -2 * radius;
            int x = 0;
            int y = radius;
            this.rgbImage.setPoint(x0, y0 + radius);
            this.rgbImage.setPoint(x0, y0 - radius);
            this.rgbImage.setPoint(x0 + radius, y0);
            this.rgbImage.setPoint(x0 - radius, y0);
            while (x < y) {
                if (f >= 0) {
                    --y;
                    f += (ddF_y += 2);
                }
                f += (ddF_x += 2) + 1;
                this.rgbImage.setPoint(x0 + ++x, y0 + y);
                this.rgbImage.setPoint(x0 - x, y0 + y);
                this.rgbImage.setPoint(x0 + x, y0 - y);
                this.rgbImage.setPoint(x0 - x, y0 - y);
                this.rgbImage.setPoint(x0 + y, y0 + x);
                this.rgbImage.setPoint(x0 - y, y0 + x);
                this.rgbImage.setPoint(x0 + y, y0 - x);
                this.rgbImage.setPoint(x0 - y, y0 - x);
            }
        }

        public void drawLine(int x0, int y0, int x1, int y1) {
            int tmp;
            boolean steep;
            boolean bl = steep = Math.abs(y1 - y0) > Math.abs(x1 - x0);
            if (steep) {
                tmp = x0;
                x0 = y0;
                y0 = tmp;
                tmp = x1;
                x1 = y1;
                y1 = tmp;
            }
            if (x0 > x1) {
                tmp = x0;
                x0 = x1;
                x1 = tmp;
                tmp = y0;
                y0 = y1;
                y1 = tmp;
            }
            int deltax = x1 - x0;
            int deltay = Math.abs(y1 - y0);
            int error = -deltax / 2;
            int y = y0;
            int ystep = y0 < y1 ? 1 : -1;
            for (int x = x0; x <= x1; ++x) {
                if (steep) {
                    this.rgbImage.setPoint(y, x);
                } else {
                    this.rgbImage.setPoint(x, y);
                }
                if ((error += deltay) <= 0) continue;
                y += ystep;
                error -= deltax;
            }
        }

        public void drawRect(int x, int y, int width, int height) {
            this.drawLine(x, y, x + --width, y);
            this.drawLine(x, y, x, y + --height);
            this.drawLine(x + width, y, x + width, y + height);
            this.drawLine(x, y + height, x + width, y + height);
        }

        public void drawRegion(RGBImage image, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
            int cx = this.correctX(x_dest, width, anchor);
            int cy = this.correctY(y_dest, height, anchor);
            this.saveClip();
            this.clipRect(cx, cy, width, height);
            if (image.immMode) {
                image.drawImmData(this, cx, cy, x_src, y_src, width, height);
            } else {
                for (int i = this.deCorrectY(this.clipY, height, anchor) - y_dest + y_src; i < y_src + (this.clipY - cy) + this.clipHeight; ++i) {
                    int[] subLine = image.getLine(this.deCorrectX(this.clipX, width, anchor) - x_dest + x_src, i, this.clipWidth);
                    this.rgbImage.setLine(subLine, cx, cy + i - y_src);
                }
            }
            this.restoreClip();
        }

        public void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
            System.out.println("not support drawRGB");
        }

        public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            System.out.println("not support drawRoundRect");
        }

        public void drawString(String str, int x, int y, int anchor) {
            if (str == null || str.length() == 0) {
                return;
            }
            this.fontImage = Image.createImage((int)this.font.stringWidth(str), (int)this.font.getHeight());
            Graphics g = this.fontImage.getGraphics();
            g.setColor(-2);
            g.fillRect(0, 0, this.fontImage.getWidth(), this.fontImage.getHeight());
            g.setFont(this.font);
            g.setColor(this.rgbImage.getForeground());
            g.drawString(str, 0, 0, 20);
            RGBImage img = new RGBImage(this.fontImage, -2);
            this.drawImage(img, x, y, anchor);
        }

        public void drawSubstring(String str, int offset, int len, int x, int y, int anchor) {
            String subString = str.substring(offset, offset + len);
            this.drawString(subString, x, y, anchor);
        }

        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            System.out.println("not support fillArc");
        }

        public void fillRect(int x, int y, int width, int height) {
            int i;
            int[] tmp = new int[width];
            for (i = 0; i < tmp.length; ++i) {
                tmp[i] = RGBImage.this.foreGround;
            }
            for (i = 0; i < height; ++i) {
                this.rgbImage.setLine(tmp, x, y + i);
            }
        }

        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            System.out.println("not support fillRoundRect");
        }

        public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
            this.drawLine(x1, y1, x2, y2);
            this.drawLine(x1, y1, x3, y3);
            this.drawLine(x2, y2, x3, y3);
        }

        public int getBlueComponent() {
            System.out.println("not support getBlueComponent");
            return 0;
        }

        public int getColor() {
            return this.rgbImage.getForeground();
        }

        public int getDisplayColor(int arg0) {
            return this.rgbImage.getForeground();
        }

        public Font getFont() {
            return this.font;
        }

        public int getGrayScale() {
            System.out.println("not support getGrayScale");
            return 0;
        }

        public int getGreenComponent() {
            System.out.println("not support getGreenComponent");
            return 0;
        }

        public int getRedComponent() {
            System.out.println("not support getRedComponent");
            return 0;
        }

        public int getStrokeStyle() {
            System.out.println("not support getStrokeStyle");
            return 0;
        }

        public int getTranslateX() {
            System.out.println("not support getTranslateX");
            return 0;
        }

        public int getTranslateY() {
            System.out.println("not support getTranslateY");
            return 0;
        }

        public void setColor(int color) {
            this.rgbImage.setForeground(color);
        }

        public void setFont(Font font) {
            this.font = font;
            this.fontImage = Image.createImage((int)this.rgbImage.getWidth(), (int)font.getHeight());
        }

        public void setGrayScale(int value) {
            System.out.println("not support setGrayScale");
        }

        public void setStrokeStyle(int style) {
            System.out.println("not support setStrokeStyle");
        }

        public void translate(int x, int y) {
            System.out.println("not support translate");
        }
    }
}

