/*
 * Decompiled with CFR 0.152.
 */
package com.pip.gui;

import com.pip.common.Tool;
import com.pip.gui.GGameIcon;
import com.pip.gui.GScrollBar;
import com.pip.gui.GWidget;
import com.pip.gui.GWindow;
import com.pip.gui.IGCycle;
import com.pip.gui.IGPaint;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import java.util.Vector;

public class GContainer
extends GWidget {
    public Vector children = new Vector();
    public boolean needScrollBar;
    GScrollBar gsb;
    public int firstInViewIndex = -1;
    public int lastInViewIndex = -1;
    public boolean isJavaPaint;
    public boolean isIntersectView;
    public static final int GW_LAYOUT_TYPE_NONE = 0;
    public static final int GW_LAYOUT_TYPE_H = 1;
    public static final int GW_LAYOUT_TYPE_V = 2;
    public static final int GW_LAYOUT_TYPE_GRID = 4;
    public static final int GW_LAYOUT_TYPE_GRID2 = 8;
    public static final int GW_LAYOUT_TYPE_GRID3 = 16;
    public static final int GW_LAYOUT_TYPE_BORDER = 17;
    public static final int GW_LAYOUT_ALIGN_NONE = 0;
    public static final int GW_LAYOUT_ALIGN_FILL = 256;
    public static final int GW_LAYOUT_ALIGN_HCENTER = 512;
    public static final int GW_LAYOUT_ALIGN_VCENTER = 1024;
    public static final int GW_BORDER_LAYOUT_NORTH = 0;
    public static final int GW_BORDER_LAYOUT_SOUTH = 1;
    public static final int GW_BORDER_LAYOUT_WEST = 2;
    public static final int GW_BORDER_LAYOUT_EAST = 3;
    public static final int GW_BORDER_LAYOUT_CENTER = 4;
    public int[] layoutData = new int[6];
    public static final int L_MODE = 0;
    public static final int L_HGAP = 1;
    public static final int L_VGAP = 2;
    public static final int L_ALIGN = 3;
    public static final int L_ROWS = 4;
    public static final int L_COLS = 5;
    public static final int L_GRID_W = 4;
    public static final int L_GRID_H = 5;
    public static final int L_UP_GAP = 1;
    public static final int L_DOWN_GAP = 2;
    public static final int L_LEFT_GAP = 3;
    public static final int L_RIGHT_GAP = 4;
    static Object lock = new Object();

    public GContainer(VMGame _vmGame, int self, int[] vmData, String name) {
        super(_vmGame, self, vmData, name);
        this.isScale = true;
    }

    void setCloneData(VMGame _vmGame, GContainer gContainer) {
        super.setCloneData(gContainer);
        System.arraycopy(this.layoutData, 0, gContainer.layoutData, 0, this.layoutData.length);
        gContainer.needScrollBar = this.needScrollBar;
        if (this.gsb != null) {
            gContainer.gsb = (GScrollBar)this.gsb.getClone(_vmGame);
        }
        gContainer.firstInViewIndex = this.firstInViewIndex;
        gContainer.lastInViewIndex = this.lastInViewIndex;
        gContainer.isJavaPaint = this.isJavaPaint;
        gContainer.isIntersectView = this.isIntersectView;
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            gContainer.add(((GWidget)this.children.elementAt(i)).getClone(_vmGame));
        }
    }

    public GWidget getClone(VMGame _vmGame) {
        GContainer gContainer = new GContainer(_vmGame, 0, this.getVMDataCopy(), null);
        this.setCloneData(gContainer);
        return gContainer;
    }

    public Object[] getChildren() {
        int count = this.children.size();
        Object[] _children = new Object[count];
        for (int i = 0; i < count; ++i) {
            _children[i] = ((GWidget)this.children.elementAt((int)i)).vmData;
        }
        return _children;
    }

    public Object[] getJavaChildren() {
        int count = this.children.size();
        Object[] _children = new Object[count];
        this.children.copyInto(_children);
        return _children;
    }

    public Object getChild(int index) {
        return ((GWidget)this.children.elementAt((int)index)).vmData;
    }

    public Object getJavaChild(int index) {
        return this.children.elementAt(index);
    }

    public void batchAdd(GWidget gWidget, int count) {
        int i = 0;
        while (i < count) {
            GWidget cloneWidget = gWidget.getClone(this.vmGame);
            this.add(cloneWidget);
            cloneWidget.vmData[30] = i++;
        }
    }

    public void toTop(int index) {
        GWidget gWidget = (GWidget)this.children.elementAt(index);
        this.children.removeElementAt(index);
        this.add(gWidget);
    }

    public void toBottom(int index) {
        GWidget gWidget = (GWidget)this.children.elementAt(index);
        this.children.removeElementAt(index);
        this.insert(gWidget, 0);
    }

    public void addScrollBar(GScrollBar gsb) {
        this.gsb = gsb;
        gsb.parent = this;
    }

    public GScrollBar getScrollBar() {
        return this.gsb;
    }

    public void add(GWidget child, int borderLayoutType) {
        this.add(child);
        child.borderLayoutType = borderLayoutType;
    }

    public void add(GWidget child) {
        this.children.addElement(child);
        this.initChild(child);
    }

    public void insert(GWidget child, int index) {
        this.children.insertElementAt(child, index);
        this.initChild(child);
    }

    public int getIndex(GWidget gWidget) {
        int _count = this.children.size();
        for (int i = 0; i < _count; ++i) {
            if (gWidget != this.children.elementAt(i)) continue;
            return i;
        }
        return -1;
    }

    private void initChild(GWidget child) {
        child.parent = this;
        child.vmData[17] = this.vmData[17] + 1;
        this.reCreateStack();
    }

    public void move(int offsetX, int offsetY) {
        super.move(offsetX, offsetY);
        this.setAbs();
    }

    public void setSrollBar(GWidget oldFocusWidget, GWidget newFocusWidget) {
        if (oldFocusWidget == newFocusWidget) {
            return;
        }
        boolean needScrollToo = false;
        if (this.isIntersectView && (newFocusWidget.vmData[4] < 0 && newFocusWidget.vmData[4] + newFocusWidget.vmData[6] > 0 || newFocusWidget.vmData[4] < this.vmData[6] && newFocusWidget.vmData[4] + newFocusWidget.vmData[6] > this.vmData[6])) {
            needScrollToo = true;
        }
        if (newFocusWidget.isOutView() || needScrollToo) {
            int offsetY = 0;
            GWidget firstWidget = (GWidget)this.children.elementAt(this.firstInViewIndex);
            GWidget lastWidget = (GWidget)this.children.elementAt(this.lastInViewIndex);
            if (this.children.elementAt(0) == newFocusWidget) {
                if (this.gsb != null) {
                    offsetY = this.gsb.scrollPos;
                }
            } else if (newFocusWidget == this.children.elementAt(this.children.size() - 1)) {
                int h = lastWidget.vmData[4] + lastWidget.vmData[6] - firstWidget.vmData[4];
                offsetY = h - newFocusWidget.vmData[4] - newFocusWidget.vmData[6] + ((GWidget)this.children.elementAt((int)this.firstInViewIndex)).vmData[4];
            } else if (newFocusWidget.vmData[4] < oldFocusWidget.vmData[4]) {
                offsetY = oldFocusWidget.isOutView() ? (newFocusWidget.vmData[4] < oldFocusWidget.vmData[4] ? -newFocusWidget.vmData[4] + firstWidget.vmData[4] + firstWidget.vmData[6] : -oldFocusWidget.vmData[4] + lastWidget.vmData[4]) : (needScrollToo ? -newFocusWidget.vmData[4] : -newFocusWidget.vmData[4] + firstWidget.vmData[4]);
            } else if (oldFocusWidget.isOutView()) {
                offsetY = newFocusWidget.vmData[4] > oldFocusWidget.vmData[4] ? -oldFocusWidget.vmData[4] + firstWidget.vmData[4] : -oldFocusWidget.vmData[4] + lastWidget.vmData[4] + lastWidget.vmData[6];
            } else if (needScrollToo) {
                offsetY = -newFocusWidget.vmData[4] - newFocusWidget.vmData[6] + this.vmData[6];
            } else {
                int h = lastWidget.vmData[4] + lastWidget.vmData[6];
                offsetY = -newFocusWidget.vmData[4] - newFocusWidget.vmData[6] + h;
            }
            this.setChildrenOffset(0, offsetY);
        }
    }

    public void moveUp() {
        if (this.lastInViewIndex > -1 && this.lastInViewIndex + 1 < this.children.size()) {
            GWidget _gWidget1 = (GWidget)this.children.elementAt(this.lastInViewIndex);
            GWidget _gWidget2 = (GWidget)this.children.elementAt(this.lastInViewIndex + 1);
            this.setChildrenOffset(0, _gWidget1.vmData[4] - _gWidget2.vmData[4]);
        }
    }

    public void moveDown() {
        if (this.firstInViewIndex > -1 && this.firstInViewIndex > 0) {
            GWidget _gWidget1 = (GWidget)this.children.elementAt(this.firstInViewIndex - 1);
            GWidget _gWidget2 = (GWidget)this.children.elementAt(this.firstInViewIndex);
            this.setChildrenOffset(0, _gWidget2.vmData[4] - _gWidget1.vmData[4]);
        }
    }

    public void moveUpPage() {
    }

    public void moveDownPage() {
    }

    public void setChildrenOffset(int offsetX, int offsetY) {
        this.firstInViewIndex = -1;
        this.lastInViewIndex = -1;
        if (this.gsb != null) {
            if (this.gsb.scrollPos - offsetY > this.gsb.maxScrollDis) {
                offsetY = this.gsb.scrollPos - this.gsb.maxScrollDis;
                this.gsb.scrollPos = this.gsb.maxScrollDis;
            } else {
                int oldScrollPos = this.gsb.scrollPos;
                this.gsb.scrollPos -= offsetY;
                if (this.gsb.scrollPos < 0) {
                    this.gsb.scrollPos = 0;
                    offsetY = oldScrollPos;
                }
            }
        }
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            GWidget gWidget = (GWidget)this.children.elementAt(i);
            gWidget.setPos(gWidget.vmData[3] + offsetX, gWidget.vmData[4] + offsetY);
            boolean _isInView = false;
            _isInView = this.isIntersectView ? Tool.rectIntersect(0, 0, this.vmData[5], this.vmData[6], gWidget.vmData[3], gWidget.vmData[4], gWidget.vmData[5], gWidget.vmData[6]) : Tool.rectContain(0, 0, this.vmData[5], this.vmData[6], gWidget.vmData[3], gWidget.vmData[4], gWidget.vmData[5], gWidget.vmData[6]);
            if (_isInView) {
                gWidget.setOutView(false);
                if (this.firstInViewIndex == -1) {
                    this.firstInViewIndex = i;
                }
                if (i != count - 1 || this.lastInViewIndex != -1) continue;
                this.lastInViewIndex = i - 1;
                continue;
            }
            gWidget.setOutView(true);
            if (this.lastInViewIndex != -1 || this.firstInViewIndex == -1) continue;
            this.lastInViewIndex = i - 1;
        }
        this.setAbs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(GWidget child) {
        this.children.removeElement(child);
        if (child instanceof GContainer) {
            ((GContainer)child).destroy();
        } else {
            GWindow parentWindow;
            if (child.vmData[22] > 0) {
                VM vM = this.vmGame.gtvm;
                synchronized (vM) {
                    this.vmGame.gtvm.callback(child.vmData[22], new int[]{child.vmData[33]});
                }
            }
            if ((parentWindow = child.getParentWindow()) != null && parentWindow.focusWidget == child) {
                parentWindow.focusWidget = null;
            }
        }
        this.reCreateStack();
        child.freeVMObj();
        this.vmGame.removeGWidget(child);
    }

    public void clear() {
        this.destroyChild(this.getParentWindow());
        if (this.gsb != null) {
            this.gsb.reset();
        }
        this.reCreateStack();
    }

    public void setBounds(int _x, int _y, int _w, int _h) {
        super.setBounds(_x, _y, _w, _h);
        this.setAbs();
        if (this.gsb != null) {
            switch (this.gsb.align) {
                case 1: {
                    this.gsb.setBounds((this.vmData[5] - this.gsb.vmData[14]) / 2, 0, this.gsb.vmData[14], this.vmData[6]);
                    break;
                }
                case 2: {
                    this.gsb.setBounds(this.vmData[5] - this.gsb.vmData[14], 0, this.gsb.vmData[14], this.vmData[6]);
                }
            }
        }
    }

    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.setAbs();
        if (this.gsb != null) {
            switch (this.gsb.align) {
                case 1: {
                    this.gsb.setPos((this.vmData[5] - this.gsb.vmData[14]) / 2, 0);
                    break;
                }
                case 2: {
                    this.gsb.setPos(this.vmData[5] - this.gsb.vmData[14], 0);
                }
            }
        }
    }

    public void setAbs() {
        int _count = this.children.size();
        for (int i = 0; i < _count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            _gWidget.vmData[7] = _gWidget.getAbsX();
            _gWidget.vmData[8] = _gWidget.getAbsY();
            if (!(_gWidget instanceof GContainer)) continue;
            GContainer gContainer = (GContainer)_gWidget;
            gContainer.setAbs();
            if (gContainer.gsb == null) continue;
            gContainer.gsb.vmData[7] = gContainer.gsb.getAbsX();
            gContainer.gsb.vmData[8] = gContainer.gsb.getAbsY();
        }
    }

    public void setCallStack(int type, Vector vmObjStack, Vector vmFuncStack, Vector paintTypeStack) {
        int count = this.children.size();
        if (count > 0) {
            block5: for (int i = 0; i < count; ++i) {
                GWidget gWidget = (GWidget)this.children.elementAt(i);
                switch (type) {
                    case 1: {
                        this.addCycleObj(gWidget, vmObjStack, vmFuncStack);
                        continue block5;
                    }
                    case 4: {
                        this.addPaintObj(gWidget, vmObjStack, vmFuncStack, paintTypeStack);
                        continue block5;
                    }
                    case 2: {
                        this.addPacketObj(gWidget, vmObjStack, vmFuncStack);
                    }
                }
            }
        }
    }

    private void addPaintObj(GWidget _gWidget, Vector vmObjStack, Vector vmFuncStack, Vector paintTypeStack) {
        if (_gWidget.isShow && !_gWidget.isOutView()) {
            if (_gWidget.vmData[34] > 0) {
                vmObjStack.addElement(_gWidget);
                vmFuncStack.addElement(new Integer(_gWidget.vmData[34]));
                paintTypeStack.addElement(new Integer(0));
            }
            if (_gWidget instanceof IGPaint) {
                vmObjStack.addElement(_gWidget);
                vmFuncStack.addElement(new Integer(0));
                paintTypeStack.addElement(new Integer(3));
            }
            if (_gWidget.vmData[20] > 0) {
                vmObjStack.addElement(_gWidget);
                vmFuncStack.addElement(new Integer(_gWidget.vmData[20]));
                paintTypeStack.addElement(new Integer(0));
            }
            if (_gWidget instanceof GContainer) {
                GContainer _gContiner = (GContainer)_gWidget;
                if (_gContiner.isJavaPaint) {
                    vmObjStack.addElement(_gWidget);
                    vmFuncStack.addElement(new Integer(0));
                    paintTypeStack.addElement(new Integer(1));
                } else {
                    _gContiner.paintChild(vmObjStack, vmFuncStack, paintTypeStack);
                }
                if (_gContiner.needScrollBar && _gContiner.gsb != null && _gContiner.gsb.vmData[20] > 0) {
                    vmObjStack.addElement(_gContiner.gsb);
                    vmFuncStack.addElement(new Integer(_gContiner.gsb.vmData[20]));
                    paintTypeStack.addElement(new Integer(0));
                }
            }
            if (_gWidget.vmData[35] > 0) {
                vmObjStack.addElement(_gWidget);
                vmFuncStack.addElement(new Integer(_gWidget.vmData[35]));
                paintTypeStack.addElement(new Integer(2));
            }
        }
    }

    private void paintChild(Vector vmObjStack, Vector vmFuncStack, Vector paintTypeStack) {
        int _count = this.children.size();
        for (int i = 0; i < _count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            this.addPaintObj(_gWidget, vmObjStack, vmFuncStack, paintTypeStack);
        }
    }

    private void addCycleObj(GWidget _gWidget, Vector vmObjStack, Vector vmFuncStack) {
        if (_gWidget.isShow && !_gWidget.isOutView()) {
            if (_gWidget instanceof IGCycle && ((IGCycle)((Object)_gWidget)).needExecuteCycle()) {
                ((IGCycle)((Object)_gWidget)).cycle();
            }
            if (_gWidget.vmData[18] > 0) {
                vmObjStack.addElement(_gWidget);
                vmFuncStack.addElement(new Integer(_gWidget.vmData[18]));
            }
            if (_gWidget instanceof GContainer) {
                GContainer _gContiner = (GContainer)_gWidget;
                _gContiner.cycleChild(vmObjStack, vmFuncStack);
                if (_gContiner.needScrollBar && _gContiner.gsb != null) {
                    _gContiner.gsb.cycle();
                }
            }
        }
    }

    private void cycleChild(Vector vmObjStack, Vector vmFuncStack) {
        int _count = this.children.size();
        for (int i = 0; i < _count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            this.addCycleObj(_gWidget, vmObjStack, vmFuncStack);
        }
    }

    private void addPacketObj(GWidget _gWidget, Vector vmObjStack, Vector vmFuncStack) {
        if (_gWidget.vmData[21] > 0) {
            vmObjStack.addElement(_gWidget);
            vmFuncStack.addElement(new Integer(_gWidget.vmData[21]));
        }
        if (_gWidget instanceof GContainer) {
            ((GContainer)_gWidget).handlePacket(vmObjStack, vmFuncStack);
        }
    }

    private void handlePacket(Vector vmObjStack, Vector vmFuncStack) {
        int _count = this.children.size();
        for (int i = 0; i < _count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            this.addPacketObj(_gWidget, vmObjStack, vmFuncStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        GWindow parentWindow = this.getParentWindow();
        this.destroyChild(parentWindow);
        if (this.vmData[22] > 0) {
            VM vM = this.vmGame.gtvm;
            synchronized (vM) {
                this.vmGame.gtvm.callback(this.vmData[22], new int[]{this.vmData[33]});
            }
        }
        if (parentWindow != null && parentWindow.focusWidget == this) {
            parentWindow.focusWidget = null;
        }
        this.freeVMObj();
        this.vmGame.removeGWidget(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyChild(GWindow parentWindow) {
        int _count = this.children.size();
        for (int i = 0; i < _count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            if (_gWidget instanceof GContainer) {
                GContainer gContainer = (GContainer)_gWidget;
                gContainer.destroyChild(parentWindow);
                if (gContainer.gsb != null) {
                    if (gContainer.gsb.vmData[22] > 0) {
                        VM vM = this.vmGame.gtvm;
                        synchronized (vM) {
                            this.vmGame.gtvm.callback(gContainer.gsb.vmData[22], new int[]{gContainer.gsb.vmData[33]});
                        }
                    }
                    if (parentWindow != null && parentWindow.focusWidget == this.gsb) {
                        parentWindow.focusWidget = null;
                    }
                    gContainer.gsb.freeVMObj();
                    this.vmGame.removeGWidget(gContainer.gsb);
                }
            }
            if (_gWidget.vmData[22] > 0) {
                VM vM = this.vmGame.gtvm;
                synchronized (vM) {
                    this.vmGame.gtvm.callback(_gWidget.vmData[22], new int[]{_gWidget.vmData[33]});
                }
            }
            if (_gWidget instanceof GGameIcon && ((GGameIcon)_gWidget).gi != null) {
                ((GGameIcon)_gWidget).gi.vm_free_icon();
            }
            if (parentWindow != null && parentWindow.focusWidget == _gWidget) {
                parentWindow.focusWidget = null;
            }
            _gWidget.freeVMObj();
            this.vmGame.removeGWidget(_gWidget);
        }
        this.children.removeAllElements();
    }

    public void setIsJavaPaint(boolean isJavaPaint) {
        this.isJavaPaint = isJavaPaint;
    }

    public void paintContainer() {
        if (this instanceof IGPaint) {
            ((IGPaint)((Object)this)).paint();
        }
        this.paintChildren();
    }

    private void paintChildren() {
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            if (_gWidget.isOutView()) continue;
            if (_gWidget instanceof IGPaint) {
                ((IGPaint)((Object)_gWidget)).paint();
            }
            if (!(_gWidget instanceof GContainer)) continue;
            GContainer gContainer = (GContainer)_gWidget;
            gContainer.paintChildren();
        }
    }

    public GWidget serchWdiget(int x, int y) {
        GWidget sWidget = null;
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            GContainer gContainer;
            GWidget gWidget = (GWidget)this.children.elementAt(i);
            if (gWidget instanceof GContainer && gWidget.isShow && (sWidget = (gContainer = (GContainer)gWidget).serchWdiget(x, y)) == null && gContainer.needScrollBar && gContainer.gsb != null && (gContainer.gsb.vmData[27] == 1 || gContainer.gsb.vmData[28] == 1) && Tool.rectIn(gContainer.gsb.vmData[7], gContainer.gsb.vmData[8], gContainer.gsb.vmData[5], gContainer.gsb.vmData[6], x, y)) {
                return gContainer.gsb;
            }
            if (sWidget == null) {
                if (gWidget.vmData[27] != 1 && gWidget.vmData[28] != 1 || gWidget.isOutView() || !Tool.rectIn(gWidget.vmData[7], gWidget.vmData[8], gWidget.vmData[5], gWidget.vmData[6], x, y)) continue;
                return gWidget;
            }
            return sWidget;
        }
        return null;
    }

    public GWidget serchWdiget2(int x, int y) {
        GWidget sWidget = null;
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            GContainer gContainer;
            GWidget gWidget = (GWidget)this.children.elementAt(i);
            if (gWidget instanceof GContainer && gWidget.isShow && (sWidget = (gContainer = (GContainer)gWidget).serchWdiget2(x, y)) == null && gContainer.needScrollBar && gContainer.gsb != null && Tool.rectIn(gContainer.gsb.vmData[7], gContainer.gsb.vmData[8], gContainer.gsb.vmData[5], gContainer.gsb.vmData[6], x, y)) {
                return gContainer.gsb;
            }
            if (sWidget == null) {
                if (gWidget.isOutView() || !Tool.rectIn(gWidget.vmData[7], gWidget.vmData[8], gWidget.vmData[5], gWidget.vmData[6], x, y)) continue;
                if (gWidget instanceof GContainer) {
                    sWidget = ((GContainer)gWidget).serchWdiget2(x, y);
                    if (sWidget != null || !((GContainer)gWidget).needScrollBar) continue;
                    return gWidget;
                }
                return gWidget;
            }
            return sWidget;
        }
        return null;
    }

    public void setLayoutMode(int layoutMode, int data1, int data2, int data3, int data4, int data5) {
        this.layoutData[0] = layoutMode;
        this.layoutData[1] = data1;
        this.layoutData[2] = data2;
        this.layoutData[3] = data3;
        this.layoutData[4] = data4;
        this.layoutData[5] = data5;
    }

    public void setHLayout(int hgap, int align) {
        this.layoutData[0] = 1;
        this.layoutData[1] = hgap;
        this.layoutData[3] = align;
    }

    public void setVLayout(int vgap, int align) {
        this.layoutData[0] = 2;
        this.layoutData[2] = vgap;
        this.layoutData[3] = align;
    }

    public void setGridLayout(int rows, int cols) {
        this.layoutData[0] = 4;
        this.layoutData[4] = rows;
        this.layoutData[5] = cols;
    }

    public void setGrid2Layout(int hgap, int vgap, int gridW, int gridH) {
        this.layoutData[0] = 8;
        this.layoutData[1] = hgap;
        this.layoutData[2] = vgap;
        this.layoutData[4] = gridW;
        this.layoutData[5] = gridH;
        this.layoutData[3] = 256;
    }

    public void setGrid3Layout(int rows, int cols) {
        this.layoutData[0] = 16;
        this.layoutData[4] = rows;
        this.layoutData[5] = cols;
    }

    public void setBorderLayout(int upGap, int downGap, int leftGap, int rightGap) {
        this.layoutData[0] = 17;
        this.layoutData[1] = upGap;
        this.layoutData[2] = downGap;
        this.layoutData[3] = leftGap;
        this.layoutData[4] = rightGap;
    }

    private GWidget getBorderLayoutGWidget(int borderLayoutType) {
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            GWidget gWidget = (GWidget)this.children.elementAt(i);
            if (gWidget.borderLayoutType != borderLayoutType) continue;
            return gWidget;
        }
        return null;
    }

    public void layout() {
        this.layout2();
        this.align();
    }

    public void align() {
        int _count = this.children.size();
        switch (this.layoutData[3]) {
            case 0: {
                for (int i = 0; i < _count; ++i) {
                    GWidget _gWidget = (GWidget)this.children.elementAt(i);
                    if (_gWidget.noNeedLayout || !(_gWidget instanceof GContainer)) continue;
                    ((GContainer)_gWidget).align();
                }
                break;
            }
            case 1024: {
                for (int i = 0; i < _count; ++i) {
                    GWidget _gWidget = (GWidget)this.children.elementAt(i);
                    if (_gWidget.noNeedLayout) continue;
                    _gWidget.setPos(_gWidget.vmData[3], _gWidget.vmData[4] + (this.vmData[6] - this.vmData[10] - this.vmData[12] - _gWidget.vmData[6]) / 2);
                    if (!(_gWidget instanceof GContainer)) continue;
                    ((GContainer)_gWidget).align();
                }
                break;
            }
            case 512: {
                for (int i = 0; i < _count; ++i) {
                    GWidget _gWidget = (GWidget)this.children.elementAt(i);
                    if (_gWidget.noNeedLayout) continue;
                    _gWidget.setPos(_gWidget.vmData[3] + (this.vmData[5] - this.vmData[9] - this.vmData[11] - _gWidget.vmData[5]) / 2, _gWidget.vmData[4]);
                    if (!(_gWidget instanceof GContainer)) continue;
                    ((GContainer)_gWidget).align();
                }
                break;
            }
            case 256: {
                int perWidth = 0;
                if (this.layoutData[0] == 1) {
                    perWidth = (this.vmData[5] - this.vmData[9] - this.vmData[11] - (_count - 1) * this.layoutData[1]) / _count;
                }
                for (int i = 0; i < _count; ++i) {
                    GWidget _gWidget = (GWidget)this.children.elementAt(i);
                    if (_gWidget.noNeedLayout) continue;
                    if (this.layoutData[0] == 2) {
                        _gWidget.setBounds(_gWidget.vmData[3], _gWidget.vmData[4], this.vmData[5] - this.vmData[9] - this.vmData[11], _gWidget.vmData[6]);
                    } else if (this.layoutData[0] == 1) {
                        int perX = this.vmData[9] + (perWidth + this.layoutData[1]) * i + (perWidth - _gWidget.vmData[5]) / 2;
                        int realWidth = _gWidget.vmData[5];
                        if (this.isScale) {
                            perX = this.vmData[9] + (perWidth + this.layoutData[1]) * i;
                            realWidth = perWidth;
                        }
                        _gWidget.setBounds(perX, _gWidget.vmData[4], realWidth, _gWidget.vmData[6]);
                    }
                    if (!(_gWidget instanceof GContainer)) continue;
                    ((GContainer)_gWidget).align();
                }
                break;
            }
        }
        if (this.gsb != null) {
            switch (this.gsb.align) {
                case 1: {
                    this.gsb.setBounds((this.vmData[5] - this.gsb.vmData[14]) / 2, 0, this.gsb.vmData[14], this.vmData[6]);
                    break;
                }
                case 2: {
                    this.gsb.setBounds(this.vmData[5] - this.gsb.vmData[14], 0, this.gsb.vmData[14], this.vmData[6]);
                }
            }
        }
    }

    private void layout2() {
        switch (this.layoutData[0]) {
            case 0: {
                int _count = this.children.size();
                for (int i = 0; i < _count; ++i) {
                    GWidget _gWidget = (GWidget)this.children.elementAt(i);
                    if (_gWidget.noNeedLayout || !(_gWidget instanceof GContainer)) continue;
                    ((GContainer)_gWidget).layout2();
                }
                break;
            }
            case 1: {
                this.layoutH();
                break;
            }
            case 2: {
                this.layoutV();
                break;
            }
            case 4: {
                this.layoutG();
                break;
            }
            case 8: {
                this.layoutG2();
                break;
            }
            case 17: {
                this.borderLayout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPerfectWidth(GWidget _gWidget, int _layoutW) {
        int _perfectWidth = 0;
        if (_gWidget.vmData[24] != 0) {
            VM vM = this.vmGame.gtvm;
            synchronized (vM) {
                _perfectWidth = this.vmGame.gtvm.callback(_gWidget.vmData[24], new int[]{_gWidget.vmData[33], _gWidget.vmData[13]});
            }
        } else {
            _perfectWidth = _gWidget.vmData[14] + _gWidget.vmData[9] + _gWidget.vmData[11];
        }
        if (_perfectWidth > _layoutW && _layoutW > 0) {
            _perfectWidth = _layoutW;
        }
        return _perfectWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPerfectHeight(GWidget _gWidget, int width, int _layoutHeight) {
        int _perfectHeight = 0;
        if (_gWidget.vmData[25] != 0) {
            VM vM = this.vmGame.gtvm;
            synchronized (vM) {
                _perfectHeight = this.vmGame.gtvm.callback(_gWidget.vmData[25], new int[]{_gWidget.vmData[33], width, _gWidget.vmData[15]});
            }
        } else {
            _perfectHeight = _gWidget.vmData[16] + _gWidget.vmData[10] + _gWidget.vmData[12];
        }
        if (_perfectHeight > _layoutHeight && _layoutHeight > 0) {
            _perfectHeight = _layoutHeight;
        }
        return _perfectHeight;
    }

    private void layoutH() {
        int _count = this.children.size();
        int _nextX = this.vmData[9];
        int _nextY = this.vmData[10];
        int _perfectWidth = 0;
        int _perfectHeight = 0;
        int _maxH = 0;
        for (int i = 0; i < _count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            if (_gWidget.noNeedLayout) continue;
            if (_gWidget instanceof GContainer) {
                ((GContainer)_gWidget).layout2();
            }
            _perfectWidth = this.getPerfectWidth(_gWidget, 0);
            _perfectHeight = this.getPerfectHeight(_gWidget, _perfectWidth, 0);
            _gWidget.setBounds(_nextX, _nextY, _perfectWidth, _perfectHeight);
            _nextX += _perfectWidth + this.layoutData[1];
            _maxH = Math.max(_maxH, _perfectHeight);
        }
        if (this.isScale) {
            this.setSize((_nextX -= this.layoutData[1]) + this.vmData[11], _maxH + this.vmData[10] + this.vmData[12]);
            this.setMinSize(_nextX - this.vmData[9], _maxH - this.vmData[10]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutV() {
        int _count = this.children.size();
        int _nextX = this.vmData[9];
        int _nextY = this.vmData[10];
        int _perfectWidth = 0;
        int _perfectHeight = 0;
        int _maxW = 0;
        int _stopNextY = 0;
        this.firstInViewIndex = -1;
        this.lastInViewIndex = -1;
        boolean isOutOfContainer = false;
        for (int i = 0; i < _count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            _gWidget.setOutView(false);
            if (_gWidget.noNeedLayout) continue;
            if (_gWidget instanceof GContainer) {
                ((GContainer)_gWidget).layout2();
            }
            _perfectWidth = this.getPerfectWidth(_gWidget, 0);
            _perfectHeight = this.getPerfectHeight(_gWidget, _perfectWidth, 0);
            _gWidget.setBounds(_nextX, _nextY, _perfectWidth, _perfectHeight);
            if (_stopNextY == 0) {
                if (!this.isIntersectView) {
                    if (_nextY + _perfectHeight + this.vmData[12] > this.vmData[15]) {
                        isOutOfContainer = true;
                    }
                } else if (_nextY + _gWidget.vmData[16] > this.vmData[15]) {
                    isOutOfContainer = true;
                }
            }
            if (isOutOfContainer) {
                GWidget _gWidget2 = (GWidget)this.children.elementAt(i);
                _gWidget2.setOutView(true);
            }
            if (isOutOfContainer && _stopNextY == 0) {
                if (this.firstInViewIndex == -1) {
                    this.firstInViewIndex = 0;
                }
                if (this.lastInViewIndex == -1) {
                    this.lastInViewIndex = i - 1;
                }
                _stopNextY = _nextY;
            }
            _nextY += _perfectHeight + this.layoutData[2];
            _maxW = Math.max(_maxW, _perfectWidth);
        }
        if (this.firstInViewIndex == -1) {
            this.firstInViewIndex = 0;
        }
        if (this.lastInViewIndex == -1) {
            this.lastInViewIndex = _count - 1;
        }
        this.realHeight = _nextY - this.layoutData[2] + this.vmData[12];
        if (_stopNextY > 0) {
            this.needScrollBar = true;
            this.outHeight = _nextY - _stopNextY;
            if (this.gsb != null) {
                this.gsb.maxScrollDis = this.outHeight;
            }
            _nextY = _stopNextY;
        } else {
            this.needScrollBar = false;
        }
        if (this.isScale) {
            _nextY -= this.layoutData[2];
            int _width = _maxW + this.vmData[9] + this.vmData[11];
            if (_width < this.vmData[14]) {
                _width = this.vmData[14];
            } else if (_width > this.vmData[13]) {
                _width = this.vmData[13];
            }
            if (_nextY + this.vmData[12] > this.vmData[15]) {
                _nextY = this.vmData[15] - this.vmData[12];
            }
            Object object = lock;
            synchronized (object) {
                this.setSize(_width, _nextY + this.vmData[12]);
            }
            this.setMinSize(_maxW - this.vmData[9], _nextY - this.vmData[11]);
        }
    }

    private void layoutG() {
        if (this.layoutData[4] > 0 && this.layoutData[5] > 0) {
            int _layoutX = this.vmData[9];
            int _layoutY = this.vmData[10];
            int _layoutW = this.vmData[5] - this.vmData[9] - this.vmData[11];
            int _layoutH = this.vmData[6] - this.vmData[10] - this.vmData[12];
            int _gridW = (_layoutW + this.layoutData[1]) / this.layoutData[5] - this.layoutData[1];
            int _gridH = (_layoutH + this.layoutData[2]) / this.layoutData[4] - this.layoutData[2];
            this.layoutGrid(_layoutX, _layoutY, _layoutW, _layoutH, _gridW, _gridH, this.layoutData[4], this.layoutData[5]);
        }
    }

    private void layoutG2() {
        int _layoutX = this.vmData[9];
        int _layoutY = this.vmData[10];
        int _layoutW = this.vmData[5] - this.vmData[9] - this.vmData[11];
        int _layoutH = this.vmData[6] - this.vmData[10] - this.vmData[12];
        int _cols = (_layoutW + this.layoutData[1]) / (this.layoutData[4] + this.layoutData[1]);
        int _rows = (_layoutH + this.layoutData[2]) / (this.layoutData[5] + this.layoutData[2]);
        this.layoutGrid(_layoutX, _layoutY, _layoutW, _layoutH, this.layoutData[4], this.layoutData[5], _rows, _cols);
    }

    private void layoutGrid(int _layoutX, int _layoutY, int _layoutW, int _layoutH, int _gridW, int _gridH, int _rows, int _cols) {
        int i;
        int _hRightGap = _layoutW - (_gridW + this.layoutData[1]) * _cols;
        _layoutX += _hRightGap / 2;
        _layoutW -= _hRightGap;
        int _vBottomGap = _layoutH - (_gridH + this.layoutData[2]) * _rows;
        _layoutY += _vBottomGap / 2;
        _layoutH -= _vBottomGap;
        int _count = this.children.size();
        int realRows = _count / _cols;
        if (_count % _cols > 0) {
            ++realRows;
        }
        for (int i2 = 0; i2 < realRows; ++i2) {
            int _widgetIndex;
            for (int j = 0; j < _cols && (_widgetIndex = i2 * _cols + j) <= _count - 1; ++j) {
                int _startX = _layoutX + j * (_gridW + this.layoutData[1]) + this.layoutData[1] / 2;
                int _startY = _layoutY + i2 * (_gridH + this.layoutData[2]) + this.layoutData[2] / 2;
                GWidget _gWidget = (GWidget)this.children.elementAt(_widgetIndex);
                if (_gWidget.isScale) {
                    _gWidget.setBounds(_startX, _startY, _gridW, _gridH);
                    continue;
                }
                _gWidget.setBounds(_startX + (_gridW - _gWidget.vmData[5]) / 2, _startY + (_gridH - _gWidget.vmData[6]) / 2, _gWidget.vmData[5], _gWidget.vmData[6]);
            }
        }
        int sum = _cols * _rows;
        int count = this.children.size();
        if (sum < count) {
            this.needScrollBar = true;
            this.outHeight = (realRows - _rows) * (_gridH + this.layoutData[2]);
            if (this.gsb != null) {
                this.gsb.maxScrollDis = this.outHeight;
            }
            this.firstInViewIndex = 0;
            this.lastInViewIndex = sum - 1;
            for (i = sum; i < count; ++i) {
                GWidget _gWidget = (GWidget)this.children.elementAt(i);
                _gWidget.setOutView(true);
            }
        } else {
            this.needScrollBar = false;
            if (this.gsb != null) {
                this.gsb.maxScrollDis = 0;
            }
            this.firstInViewIndex = 0;
            this.lastInViewIndex = count - 1;
            for (i = 0; i < count; ++i) {
                GWidget _gWidget = (GWidget)this.children.elementAt(i);
                _gWidget.setOutView(false);
            }
        }
    }

    public void grid3Layout() {
        int _layoutX = this.vmData[9];
        int _layoutY = this.vmData[10];
        int _layoutW = this.vmData[5] - this.vmData[9] - this.vmData[11];
        int _layoutH = this.vmData[6] - this.vmData[10] - this.vmData[12];
        int gridW = _layoutW / this.layoutData[5];
        int gridH = _layoutH / this.layoutData[4];
        int realW = gridW * this.layoutData[5];
        int fixW = _layoutW % gridW + 1;
        int _count = this.children.size();
        for (int i = 0; i < _count; ++i) {
            GWidget _gWidget = (GWidget)this.children.elementAt(i);
            if (_gWidget.grid3Data == null) continue;
            int _w = _gWidget.grid3Data[2] * gridW - _gWidget.grid3Data[6] - _gWidget.grid3Data[7];
            int _h = _gWidget.grid3Data[3] * gridH - _gWidget.grid3Data[4] - _gWidget.grid3Data[5];
            int _x = _layoutX + _gWidget.grid3Data[0] * gridW + _gWidget.grid3Data[6];
            int _y = _layoutY + _gWidget.grid3Data[1] * gridH + _gWidget.grid3Data[4];
            if ((_gWidget.grid3Data[0] + _gWidget.grid3Data[2]) * gridW == realW) {
                _w += fixW;
            }
            if (_gWidget.isScale) {
                _gWidget.setBounds(_x, _y, _w, _h);
                continue;
            }
            _gWidget.setBounds(_x + (_w - _gWidget.vmData[5]) / 2, _y + (_h - _gWidget.vmData[6]) / 2, _gWidget.vmData[5], _gWidget.vmData[6]);
        }
    }

    public void borderLayout() {
        int _layoutX = this.vmData[9];
        int _layoutY = this.vmData[10];
        int _layoutW = this.vmData[5] - this.vmData[9] - this.vmData[11];
        int _layoutH = this.vmData[6] - this.vmData[10] - this.vmData[12];
        GWidget northGWidget = this.getBorderLayoutGWidget(0);
        GWidget southGWidget = this.getBorderLayoutGWidget(1);
        GWidget westGWidget = this.getBorderLayoutGWidget(2);
        GWidget eastGWidget = this.getBorderLayoutGWidget(3);
        GWidget centerGWidget = this.getBorderLayoutGWidget(4);
        int _perfectWidth = _layoutW;
        int _perfectHeight = _layoutH;
        if (northGWidget != null) {
            northGWidget.vmData[5] = _layoutW;
            if (northGWidget instanceof GContainer) {
                ((GContainer)northGWidget).layout2();
            }
            _perfectHeight = this.getPerfectHeight(northGWidget, _layoutW, _layoutH);
            northGWidget.setBounds(_layoutX, _layoutY, _layoutW, _perfectHeight);
            _layoutY += northGWidget.vmData[6] + this.layoutData[1];
            _perfectHeight = _layoutH = _layoutH - northGWidget.vmData[6] - this.layoutData[1];
        }
        if (southGWidget != null) {
            southGWidget.vmData[5] = _layoutW;
            if (southGWidget instanceof GContainer) {
                ((GContainer)southGWidget).layout2();
            }
            _perfectHeight = this.getPerfectHeight(southGWidget, _layoutW, _layoutH);
            southGWidget.setBounds(_layoutX, this.vmData[6] - _perfectHeight - this.vmData[12], _layoutW, _perfectHeight);
            _perfectHeight = _layoutH = _layoutH - southGWidget.vmData[6] - this.layoutData[2];
        }
        if (westGWidget != null) {
            if (westGWidget instanceof GContainer) {
                ((GContainer)westGWidget).layout2();
            }
            _perfectWidth = this.getPerfectWidth(westGWidget, _layoutW);
            if (_perfectHeight == 0) {
                _perfectHeight = this.getPerfectHeight(westGWidget, _perfectWidth, _layoutH);
            }
            westGWidget.setBounds(_layoutX, _layoutY, _perfectWidth, _perfectHeight);
            _layoutX = westGWidget.vmData[5] + this.layoutData[3];
            _perfectWidth = _layoutW -= _layoutX;
            _perfectHeight = _layoutH;
        }
        if (eastGWidget != null) {
            if (eastGWidget instanceof GContainer) {
                ((GContainer)eastGWidget).layout2();
            }
            _perfectWidth = this.getPerfectWidth(eastGWidget, _layoutW);
            if (_perfectHeight == 0) {
                _perfectHeight = this.getPerfectHeight(eastGWidget, _perfectWidth, _layoutH);
            }
            eastGWidget.setBounds(this.vmData[5] - _perfectWidth - this.vmData[11], _layoutY, _perfectWidth, _perfectHeight);
            _layoutW = _layoutW - eastGWidget.vmData[5] - this.layoutData[4];
        }
        if (centerGWidget != null) {
            centerGWidget.setBounds(_layoutX, _layoutY, _layoutW, _layoutH);
            if (centerGWidget instanceof GContainer) {
                ((GContainer)centerGWidget).layout2();
            }
            centerGWidget.setBounds(_layoutX, _layoutY, _layoutW, _layoutH);
        }
        if (_layoutW == 0) {
            int _width = 0;
            if (northGWidget != null) {
                _width = northGWidget.vmData[5];
            }
            if (southGWidget != null && _width < southGWidget.vmData[5]) {
                _width = southGWidget.vmData[5];
            }
            int _width2 = this.layoutData[3] + this.layoutData[4];
            if (westGWidget != null) {
                _width2 += westGWidget.vmData[5];
            }
            if (eastGWidget != null) {
                _width2 += eastGWidget.vmData[5];
            }
            if (centerGWidget != null) {
                _width2 += centerGWidget.vmData[5];
            }
            if (_width < _width2) {
                _width = _width2;
            }
            this.vmData[14] = _width;
        }
        if (_layoutH == 0) {
            int _height = 0;
            if (westGWidget != null) {
                _height = westGWidget.vmData[6];
            }
            if (eastGWidget != null && _height < eastGWidget.vmData[6]) {
                _height = eastGWidget.vmData[6];
            }
            if (centerGWidget != null && _height < centerGWidget.vmData[6]) {
                _height = centerGWidget.vmData[6];
            }
            _height += this.layoutData[1] + this.layoutData[2];
            if (northGWidget != null) {
                _height += northGWidget.vmData[6];
            }
            if (southGWidget != null) {
                _height += southGWidget.vmData[6];
            }
            this.vmData[16] = _height;
        }
    }
}

