/*
 * Decompiled with CFR 0.152.
 */
package com.pip.engine;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.engine.Random;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameWorld;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Weather {
    private int type;
    private int speed;
    private int speedDiff;
    private int wind;
    private int color;
    private int size;
    private int count;
    private int dieCount;
    private int die;
    private int endTime;
    private short[][] data;
    private Vector dieData = new Vector();
    private static final Random rand = new Random(Tool.getSystemTime());
    public static final int WEATHER_TYPE_RAIN = 0;
    public static final int WEATHER_TYPE_SNOW = 1;
    public static final int WEATHER_PARA_SIZE = 0;
    public static final int WEATHER_PARA_COUNT = 1;
    public static final int WEATHER_PARA_SPEED = 2;
    public static final int WEATHER_PARA_SPEED_DIFF = 3;
    public static final int WEATHER_PARA_WIND = 4;
    public static final int WEATHER_PARA_COLOR = 5;
    public static final int WEATHER_PARA_DIE = 6;
    public static final int WEATHER_PARA_DIE_COUNT = 7;
    public static final int WEATHER_PARA_END_TIME = 8;

    public Weather(int type, int size, int count, int speed, int speedDiff, int wind, int color, int die, int dieCount, int endTime) {
        this.type = type;
        this.speed = speed;
        this.speedDiff = speedDiff;
        this.wind = wind;
        this.color = color;
        this.size = size;
        this.count = count;
        this.dieCount = dieCount;
        this.die = die;
        this.endTime = endTime;
        this.data = new short[7][count];
        this.init(0, count);
    }

    public void adjustPara(int subType, int value) {
        switch (subType) {
            case 0: {
                this.setSize(value);
                break;
            }
            case 1: {
                this.setCount(value);
                break;
            }
            case 2: {
                this.setSpeed(value);
                break;
            }
            case 3: {
                this.setSpeedDiff(value);
                break;
            }
            case 4: {
                this.setWind(value);
                break;
            }
            case 5: {
                this.setColor(value);
                break;
            }
            case 6: {
                this.setDie(value);
                break;
            }
            case 7: {
                this.setDie(value);
                break;
            }
            case 8: {
                this.setEndTime(value);
            }
        }
    }

    public int getDieCount() {
        return this.dieCount;
    }

    public void setDieCount(int dieCount) {
        this.dieCount = dieCount;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getEndtime() {
        return this.endTime;
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }

    public int getDie() {
        return this.die;
    }

    public void setDie(int die) {
        if (die < 0) {
            die = 0;
        }
        this.die = die;
        this.rebuildDiePara();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size < 0) {
            size = 0;
        }
        this.size = size;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        if (speed < 0) {
            speed = 0;
        }
        this.speed = speed;
        this.rebuildSpeed();
    }

    public int getSpeedDiff() {
        return this.speedDiff;
    }

    public void setSpeedDiff(int speedDiff) {
        if (speedDiff < 0) {
            speedDiff = 0;
        }
        this.speedDiff = speedDiff;
        this.rebuildSpeed();
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        if (count < 0) {
            count = 0;
        }
        if (count > this.count) {
            for (int i = 0; i < this.data.length; ++i) {
                short[] tmp = new short[count];
                System.arraycopy(this.data[i], 0, tmp, 0, this.data[i].length);
                this.data[i] = tmp;
            }
            int oldCount = this.count;
            this.count = count;
            this.init(oldCount, count);
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                short[] tmp = new short[count];
                System.arraycopy(this.data[i], 0, tmp, 0, count);
                this.data[i] = tmp;
            }
            this.count = count;
        }
    }

    public int getWind() {
        return this.wind;
    }

    public void setWind(int wind) {
        this.wind = wind;
    }

    public void draw(Graphics g) {
        switch (this.type) {
            case 0: {
                g.setColor(this.color);
                for (int i = 0; i < this.count; ++i) {
                    if (this.data[6][i] != 1) continue;
                    g.drawLine((int)this.data[0][i], (int)this.data[1][i], (int)this.data[2][i], (int)this.data[3][i]);
                }
                int dieCount = this.dieData.size();
                Vector<short[]> restDieData = new Vector<short[]>();
                for (int i = 0; i < dieCount; ++i) {
                    short[] dieInfo = (short[])this.dieData.elementAt(i);
                    dieInfo[5] = (short)(dieInfo[5] + 1);
                    if (dieInfo[5] >= dieInfo[4]) continue;
                    restDieData.addElement(dieInfo);
                    if (dieInfo[5] < 2) continue;
                    int x = dieInfo[0] + dieInfo[2] - GameWorld.viewX;
                    int y = dieInfo[1] + dieInfo[3] - GameWorld.viewY;
                    g.drawArc(x, y, (int)dieInfo[5], dieInfo[5] / 2, 0, 360);
                }
                this.dieData = restDieData;
                break;
            }
            case 1: {
                g.setColor(this.color);
                for (int i = 0; i < this.count; ++i) {
                    g.fillRect((int)this.data[0][i], (int)this.data[1][i], (int)this.data[2][i], (int)this.data[2][i]);
                }
                break;
            }
        }
    }

    public void cycle() {
        if (this.endTime != -1 && Utilities.getServerTime() > this.endTime) {
            GameMain.weather = null;
            return;
        }
        switch (this.type) {
            case 0: {
                for (int i = 0; i < this.count; ++i) {
                    boolean reborn = false;
                    short[] sArray = this.data[0];
                    int n = i;
                    sArray[n] = (short)(sArray[n] + this.wind);
                    short[] sArray2 = this.data[1];
                    int n2 = i;
                    sArray2[n2] = (short)(sArray2[n2] + this.data[4][i]);
                    short[] sArray3 = this.data[2];
                    int n3 = i;
                    sArray3[n3] = (short)(sArray3[n3] + this.wind);
                    short[] sArray4 = this.data[3];
                    int n4 = i;
                    sArray4[n4] = (short)(sArray4[n4] + this.data[4][i]);
                    short[] sArray5 = this.data[5];
                    int n5 = i;
                    sArray5[n5] = (short)(sArray5[n5] - this.data[4][i]);
                    if (this.data[5][i] <= 0 && this.dieData.size() < this.dieCount) {
                        this.data[6][i] = 0;
                        short[] dieInfo = new short[]{this.data[2][i], this.data[3][i], (short)GameWorld.viewX, (short)GameWorld.viewY, (short)this.die, 0};
                        this.dieData.addElement(dieInfo);
                        reborn = true;
                    }
                    if (this.data[1][i] > GameMain.viewHeight) {
                        short[] sArray6 = this.data[1];
                        int n6 = i;
                        sArray6[n6] = (short)(sArray6[n6] - GameMain.viewHeight);
                        this.data[6][i] = 1;
                        reborn = true;
                    } else if (this.wind >= 0 && this.data[0][i] > GameMain.viewWidth) {
                        short[] sArray7 = this.data[0];
                        int n7 = i;
                        sArray7[n7] = (short)(sArray7[n7] - GameMain.viewWidth);
                        this.data[6][i] = 1;
                        reborn = true;
                    } else if (this.wind < 0 && this.data[0][i] < 0) {
                        short[] sArray8 = this.data[0];
                        int n8 = i;
                        sArray8[n8] = (short)(sArray8[n8] + GameMain.viewWidth);
                        this.data[6][i] = 1;
                        reborn = true;
                    }
                    if (!reborn) continue;
                    this.data[2][i] = (short)(this.data[0][i] + this.wind);
                    this.data[3][i] = (short)(this.data[1][i] + this.size);
                    this.data[5][i] = GameMain.viewHeight - this.data[3][i] > 0 ? (int)rand.nextInt(GameMain.viewHeight - this.data[3][i]) : Short.MAX_VALUE;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.count; ++i) {
                    boolean reborn = false;
                    short[] sArray = this.data[5];
                    int n = i;
                    sArray[n] = (short)(sArray[n] + 1);
                    if (this.data[5][i] > this.size * this.speed) {
                        this.rebuildSnowPara1(i);
                    }
                    short[] sArray9 = this.data[0];
                    int n9 = i;
                    sArray9[n9] = (short)(sArray9[n9] + this.data[6][i]);
                    short[] sArray10 = this.data[1];
                    int n10 = i;
                    sArray10[n10] = (short)(sArray10[n10] + this.data[4][i]);
                    if (this.data[1][i] > GameMain.viewHeight) {
                        short[] sArray11 = this.data[1];
                        int n11 = i;
                        sArray11[n11] = (short)(sArray11[n11] - GameMain.viewHeight);
                        reborn = true;
                    } else if (this.data[6][i] >= 0 && this.data[0][i] > GameMain.viewWidth) {
                        short[] sArray12 = this.data[0];
                        int n12 = i;
                        sArray12[n12] = (short)(sArray12[n12] - GameMain.viewWidth);
                        reborn = true;
                    } else if (this.data[6][i] < 0 && this.data[0][i] < 0) {
                        short[] sArray13 = this.data[0];
                        int n13 = i;
                        sArray13[n13] = (short)(sArray13[n13] + GameMain.viewWidth);
                        reborn = true;
                    }
                    if (!reborn) continue;
                    this.rebuildSnowPara(i);
                }
                break;
            }
        }
    }

    private void init(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.born(i);
        }
        this.rebuildSpeed();
    }

    private void born(int index) {
        switch (this.type) {
            case 0: {
                this.data[0][index] = (short)rand.nextInt(GameMain.viewWidth);
                this.data[1][index] = (short)rand.nextInt(GameMain.viewHeight);
                this.data[2][index] = (short)(this.data[0][index] + this.wind);
                this.data[3][index] = (short)(this.data[1][index] + this.size);
                this.data[6][index] = 1;
                break;
            }
            case 1: {
                this.data[0][index] = (short)rand.nextInt(GameMain.viewWidth);
                this.data[1][index] = (short)rand.nextInt(GameMain.viewHeight);
            }
        }
    }

    private void rebuildSnowPara(int index) {
        this.data[2][index] = rand.nextInt(2) == 0 ? (short)this.size : (short)(this.size / 2);
        this.rebuildSnowPara1(index);
    }

    private void rebuildSnowPara1(int index) {
        this.data[3][index] = (short)rand.nextInt(3);
        this.data[5][index] = 0;
        switch (this.data[3][index]) {
            case 0: {
                this.data[6][index] = (short)this.wind;
                break;
            }
            case 1: {
                this.data[6][index] = (short)(this.wind >= 0 ? this.wind + 1 : this.wind - 1);
                break;
            }
            case 2: {
                this.data[6][index] = (short)(this.wind >= 0 ? this.wind - 1 : this.wind + 1);
            }
        }
    }

    private void rebuildSpeed() {
        switch (this.type) {
            case 0: {
                for (int i = 0; i < this.count; ++i) {
                    this.data[4][i] = (short)(this.speed + rand.nextInt(this.speed * this.speedDiff / 100 + 1));
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.count; ++i) {
                    this.data[4][i] = (short)(this.speed + rand.nextInt(this.speed * this.speedDiff / 100 + 1));
                    this.rebuildSnowPara(i);
                }
                break;
            }
        }
        this.rebuildDiePara();
    }

    private void rebuildDiePara() {
        switch (this.type) {
            case 0: {
                for (int i = 0; i < this.count; ++i) {
                    this.data[5][i] = GameMain.viewHeight - this.data[3][i] > 0 ? (int)rand.nextInt(GameMain.viewHeight - this.data[3][i]) : Short.MAX_VALUE;
                }
                this.dieData.removeAllElements();
                break;
            }
            case 1: {
                this.dieData.removeAllElements();
            }
        }
    }
}

