/*
 * Decompiled with CFR 0.152.
 */
package com.pip.engine;

import com.pip.common.Tool;
import com.pip.engine.GamePackage;
import com.pip.engine.LandformImage;
import com.pip.engine.Random;
import java.io.DataInputStream;

public class GameMap {
    public GamePackage owner;
    public int id;
    public String name;
    public int width;
    public int height;
    public short[] exitIDs;
    public short[] exitX;
    public short[] exitY;
    public int[] exitTargetMaps;
    public String[] exitTargetMapNames;
    public short[] exitTargetX;
    public short[] exitTargetY;
    public int backgroundType;
    public byte[][] mapData;
    public int randomSeed;
    public int baseLandform;
    public short[][] groundNPCs;
    public short[][] roleNPCs;
    public short[][] skyNPCs;

    public GameMap(GamePackage pkg) {
        this.owner = pkg;
    }

    public void load(DataInputStream dis) throws Exception {
        int i;
        int ch;
        int cw;
        this.id = dis.readByte();
        this.name = Tool.readUTF(dis);
        this.width = dis.readShort();
        this.height = dis.readShort();
        int exitCount = dis.readByte() & 0xFF;
        this.exitIDs = new short[exitCount];
        this.exitX = new short[exitCount];
        this.exitY = new short[exitCount];
        this.exitTargetMaps = new int[exitCount];
        this.exitTargetMapNames = new String[exitCount];
        this.exitTargetX = new short[exitCount];
        this.exitTargetY = new short[exitCount];
        for (int i2 = 0; i2 < exitCount; ++i2) {
            this.exitIDs[i2] = dis.readShort();
            this.exitX[i2] = dis.readShort();
            this.exitY[i2] = dis.readShort();
            this.exitTargetMaps[i2] = dis.readInt();
            this.exitTargetMapNames[i2] = Tool.readUTF(dis);
            this.exitTargetX[i2] = dis.readShort();
            this.exitTargetY[i2] = dis.readShort();
        }
        byte layerCount = dis.readByte();
        if (layerCount != 4) {
            throw new IllegalArgumentException();
        }
        byte layerType = dis.readByte();
        if (layerType == 0) {
            this.backgroundType = 0;
            cw = this.width / this.owner.tileWidth;
            ch = this.height / this.owner.tileHeight;
            this.mapData = new byte[ch][cw];
            for (i = 0; i < ch; ++i) {
                dis.readFully(this.mapData[i]);
            }
        } else if (layerType == 1) {
            this.backgroundType = 1;
            this.randomSeed = dis.readInt();
            this.baseLandform = dis.readByte();
            cw = this.width / this.owner.blurTileWidth;
            ch = this.height / this.owner.blurTileHeight;
            this.mapData = new byte[ch][cw];
            for (i = 0; i < ch; ++i) {
                dis.readFully(this.mapData[i]);
            }
        } else {
            throw new IllegalArgumentException();
        }
        for (int i3 = 0; i3 < 3; ++i3) {
            layerType = dis.readByte();
            dis.skipBytes(1);
            if (layerType != 2) {
                throw new IllegalArgumentException();
            }
            short[][] npcs = this.loadNPCList(dis);
            if (i3 == 0) {
                this.groundNPCs = npcs;
                continue;
            }
            if (i3 == 1) {
                this.roleNPCs = npcs;
                continue;
            }
            this.skyNPCs = npcs;
        }
    }

    private short[][] loadNPCList(DataInputStream dis) throws Exception {
        int i;
        int count = dis.readShort();
        short[][] data = new short[count][3];
        for (i = 0; i < count; ++i) {
            data[i][0] = dis.readShort();
            data[i][1] = dis.readShort();
            data[i][2] = dis.readShort();
        }
        for (i = 0; i < count - 1; ++i) {
            for (int j = i + 1; j < count; ++j) {
                if (data[i][2] <= data[j][2] && (data[i][2] != data[j][2] || data[i][1] <= data[j][1])) continue;
                short[] tmp = data[i];
                data[i] = data[j];
                data[j] = tmp;
            }
        }
        short[][] ret = new short[4][count];
        for (int i2 = 0; i2 < count; ++i2) {
            ret[0][i2] = data[i2][0];
            ret[1][i2] = data[i2][1];
            ret[2][i2] = data[i2][2];
            ret[3][i2] = 0;
        }
        return ret;
    }

    public int[][] createBlurMapBuffer(LandformImage[] landforms) {
        int rows = this.mapData.length;
        int cols = this.mapData[0].length;
        int[][] mapDataBuffer = new int[rows][cols];
        if (this.baseLandform != -1) {
            Random rand = new Random(this.randomSeed);
            LandformImage image = landforms[this.baseLandform];
            image.generateSearchTable();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    int[] tile = image.getTile(rand, 15);
                    if (tile[0] == -1) continue;
                    mapDataBuffer[i][j] = this.makeLayerBits(this.baseLandform, tile[0], tile[1]) << 22;
                }
            }
        }
        for (int lf = 0; lf < landforms.length; ++lf) {
            if (lf == this.baseLandform) continue;
            Random rand = new Random(this.randomSeed);
            byte[][] tmpData = GameMap.makeLayer(this.mapData, lf);
            LandformImage image = landforms[lf];
            image.generateSearchTable();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    int[] tile = image.getTile(rand, tmpData[i + 1][j + 1]);
                    if (tile[0] == -1) continue;
                    mapDataBuffer[i][j] = tmpData[i + 1][j + 1] == 15 ? this.makeLayerBits(lf, tile[0], tile[1]) << 22 : this.mergeGridData(mapDataBuffer[i][j], this.makeLayerBits(lf, tile[0], tile[1]));
                }
            }
            image.frameSearchTable = null;
        }
        return mapDataBuffer;
    }

    private int makeLayerBits(int lfid, int tileid, int transit) {
        return lfid << 7 | transit << 5 | tileid + 1;
    }

    private int mergeGridData(int cell, int newLayer) {
        int layer1 = cell >> 22 & 0x3FF;
        if (layer1 == 0) {
            return newLayer << 22;
        }
        int layer2 = cell >> 11 & 0x7FF;
        if (layer2 == 0) {
            return layer1 << 22 | newLayer << 11;
        }
        return layer1 << 22 | layer2 << 11 | newLayer;
    }

    public static byte[][] makeRectangle(int w, int h) {
        byte[][] ret = new byte[h][w];
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if (i == 0) {
                    if (j == 0) {
                        ret[i][j] = 1;
                        continue;
                    }
                    if (j == w - 1) {
                        ret[i][j] = 2;
                        continue;
                    }
                    ret[i][j] = 3;
                    continue;
                }
                if (i == h - 1) {
                    if (j == 0) {
                        ret[i][j] = 4;
                        continue;
                    }
                    if (j == w - 1) {
                        ret[i][j] = 8;
                        continue;
                    }
                    ret[i][j] = 12;
                    continue;
                }
                ret[i][j] = j == 0 ? 5 : (j == w - 1 ? 10 : 15);
            }
        }
        return ret;
    }

    public static byte[][] makeLayer(byte[][] data, int lfid) {
        int rows = data.length;
        int cols = data[0].length;
        byte[][] ret = new byte[rows + 2][cols + 2];
        byte[][] sg = GameMap.makeRectangle(3, 3);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (data[i][j] != lfid) continue;
                byte[] byArray = ret[i];
                int n = j;
                byArray[n] = (byte)(byArray[n] | sg[0][0]);
                byte[] byArray2 = ret[i];
                int n2 = j + 1;
                byArray2[n2] = (byte)(byArray2[n2] | sg[0][1]);
                byte[] byArray3 = ret[i];
                int n3 = j + 2;
                byArray3[n3] = (byte)(byArray3[n3] | sg[0][2]);
                byte[] byArray4 = ret[i + 1];
                int n4 = j;
                byArray4[n4] = (byte)(byArray4[n4] | sg[1][0]);
                byte[] byArray5 = ret[i + 1];
                int n5 = j + 1;
                byArray5[n5] = (byte)(byArray5[n5] | sg[1][1]);
                byte[] byArray6 = ret[i + 1];
                int n6 = j + 2;
                byArray6[n6] = (byte)(byArray6[n6] | sg[1][2]);
                byte[] byArray7 = ret[i + 2];
                int n7 = j;
                byArray7[n7] = (byte)(byArray7[n7] | sg[2][0]);
                byte[] byArray8 = ret[i + 2];
                int n8 = j + 1;
                byArray8[n8] = (byte)(byArray8[n8] | sg[2][1]);
                byte[] byArray9 = ret[i + 2];
                int n9 = j + 2;
                byArray9[n9] = (byte)(byArray9[n9] | sg[2][2]);
            }
        }
        return ret;
    }
}

