/*
 * Decompiled with CFR 0.152.
 */
package com.pip.common;

import com.pip.common.Tool;
import com.pip.io.UASegment;
import com.pip.io.UASocketConnection;
import com.pip.sanguo.GameMain;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import com.pip.util.SortHashtable;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class Utilities
implements Runnable {
    public static UASocketConnection connection = null;
    public static Vector segments = new Vector();
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    public static final byte KEY_UP = 1;
    public static final byte KEY_DOWN = 2;
    public static final byte KEY_LEFT = 3;
    public static final byte KEY_RIGHT = 4;
    public static final byte KEY_FIRE = 5;
    public static final byte KEY_LEFT_SOFT = 6;
    public static final byte KEY_RIGHT_SOFT = 7;
    public static final byte UP_PRESSED = 0;
    public static final byte DOWN_PRESSED = 1;
    public static final byte LEFT_PRESSED = 2;
    public static final byte RIGHT_PRESSED = 3;
    public static final byte FIRE_PRESSED = 4;
    public static final byte GAME_A_PRESSED = 5;
    public static final byte GAME_B_PRESSED = 6;
    public static final byte GAME_C_PRESSED = 7;
    public static final byte GAME_D_PRESSED = 8;
    public static final byte SOFT_FIRST_PRESSED = 9;
    public static final byte SOFT_LAST_PRESSED = 10;
    public static final byte KEY_NUM0_PRESSED = 11;
    public static final byte KEY_NUM1_PRESSED = 12;
    public static final byte KEY_NUM2_PRESSED = 13;
    public static final byte KEY_NUM3_PRESSED = 14;
    public static final byte KEY_NUM4_PRESSED = 15;
    public static final byte KEY_NUM5_PRESSED = 16;
    public static final byte KEY_NUM6_PRESSED = 17;
    public static final byte KEY_NUM7_PRESSED = 18;
    public static final byte KEY_NUM8_PRESSED = 19;
    public static final byte KEY_NUM9_PRESSED = 20;
    public static final byte KEY_POUND_PRESSED = 21;
    public static final byte KEY_STAR_PRESSED = 22;
    public static final byte BUTTON_MENU_PRESSED = 9;
    public static final byte BUTTON_OK_PRESSED = 9;
    public static final byte BUTTON_BACK_PRESSED = 10;
    public static long keyFlag;
    public static long keyFlag2;
    public static Font font;
    public static int CHAR_HEIGHT;
    public static int CHAR_OFFSET;
    public static int LINE_HEIGHT;
    public static int CHAR_WIDTH;
    public static Display display;
    public static Displayable canvas;
    public static Graphics graphics;
    public static boolean isExitGame;
    public static long appStartTime;
    public static long lastSyncServerTime;
    public static int serverTime;
    public static long firstSyncServerTime;
    public static long firstSyncClientTime;
    public static boolean emulatorDetected;
    private String requestURL;
    public static final int THREAD_HTTP = 0;
    public static final int THREAD_UWAP = 1;
    public static final int THREAD_SMS = 2;
    private int threadMode;
    public VM listenVM;
    public byte[] lastDownloadData;
    public byte[] postData;
    public SortHashtable requestProperties;
    private boolean async;
    public int state;
    public static final int DOWNLOAD_STATE_ERROR = 0;
    public static final int DOWNLOAD_STATE_RUNNING = 1;
    public static final int DOWNLOAD_STATE_OK = 2;
    private static final String punctation = ",.?:\"!;\uff0c\u3002\uff1f\uff1a\u201c\u201d\uff01\uff1b";

    public static int getTimeStamp() {
        long now = Tool.getSystemTime();
        if (now < appStartTime) {
            appStartTime = now;
        }
        return (int)(now - appStartTime);
    }

    public static void setServerTime(int time) {
        if (firstSyncServerTime == 0L) {
            firstSyncServerTime = time;
            firstSyncClientTime = System.currentTimeMillis();
        } else {
            long serverChange;
            long localChange = System.currentTimeMillis() - firstSyncClientTime;
            if (localChange - (serverChange = (long)time - firstSyncServerTime) > 40000L && System.currentTimeMillis() - lastSyncServerTime < 40000L) {
                emulatorDetected = true;
            } else if (localChange - serverChange < 40000L) {
                emulatorDetected = false;
            }
        }
        lastSyncServerTime = Utilities.getSafeTime();
        serverTime = time;
    }

    public static int getServerTime() {
        return serverTime + (int)(Utilities.getSafeTime() - lastSyncServerTime);
    }

    public static long getSafeTime() {
        if (emulatorDetected) {
            return new Date().getTime();
        }
        return System.currentTimeMillis();
    }

    public static boolean isButtonMenuOnLeft() {
        return true;
    }

    public static boolean isButtonOkOnLeft() {
        return true;
    }

    public static boolean isButtonBackOnLeft() {
        return false;
    }

    public static void setDisplay(Display dp, Canvas cn) {
        display = dp;
        canvas = cn;
    }

    public Utilities(String uu, int tm, VM lvm, boolean async) {
        this.requestURL = uu;
        this.threadMode = tm;
        this.listenVM = lvm;
        this.async = async;
        this.state = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean result;
        block37: {
            try {
                block36: {
                    if (this.threadMode == 0) {
                        while (true) {
                            HttpConnection httpConnection = null;
                            try {
                                int code;
                                boolean useProxy;
                                if (this.requestURL.startsWith("p")) {
                                    useProxy = true;
                                    httpConnection = UASegment.getConnection(this.requestURL.substring(1), true);
                                } else {
                                    useProxy = false;
                                    httpConnection = UASegment.getConnection(this.requestURL, false);
                                }
                                if (this.postData != null) {
                                    httpConnection.setRequestMethod("POST");
                                } else {
                                    httpConnection.setRequestMethod("GET");
                                }
                                if (this.requestProperties != null) {
                                    Object[] keys = this.requestProperties.keys();
                                    for (int i = 0; i < keys.length; ++i) {
                                        String key = (String)keys[i];
                                        String value = (String)this.requestProperties.get(key);
                                        httpConnection.setRequestProperty(key, value);
                                    }
                                }
                                if (this.postData != null) {
                                    OutputStream os = httpConnection.openOutputStream();
                                    os.write(this.postData);
                                    os.close();
                                }
                                if ((code = httpConnection.getResponseCode()) < 200 || code >= 300) {
                                    if (code == 302) {
                                        this.requestURL = httpConnection.getHeaderField("Location");
                                        if (!useProxy) continue;
                                        this.requestURL = "p" + this.requestURL;
                                        continue;
                                    }
                                    throw new IOException();
                                }
                                DataInputStream in = httpConnection.openDataInputStream();
                                this.lastDownloadData = Utilities.getBytesFromInput(in);
                                in.close();
                                break block36;
                            }
                            catch (Throwable ex2) {
                                throw ex2;
                            }
                            finally {
                                if (httpConnection == null) continue;
                                try {
                                    httpConnection.close();
                                }
                                catch (IOException ex3) {}
                                continue;
                            }
                            break;
                        }
                    }
                    if (this.threadMode == 1) {
                        Utilities.createConnection(this.requestURL);
                    } else if (this.threadMode == 2) {
                        int pos = this.requestURL.indexOf(10);
                        String number = this.requestURL.substring(0, pos);
                        String content = this.requestURL.substring(pos + 1);
                        MessageConnection connection = null;
                        connection = (MessageConnection)Connector.open((String)("sms://" + number));
                        TextMessage message = (TextMessage)connection.newMessage("text");
                        message.setPayloadText(content);
                        connection.send((Message)message);
                    }
                }
                this.state = 2;
                result = true;
            }
            catch (Throwable e) {
                VM vM;
                VM vm;
                result = false;
                this.state = 0;
                if (this.threadMode != 1) break block37;
                VMGame vmg = VMGame.getVMGameByVMKey(VMGame.gameWorldVMGameKey);
                if (vmg != null) {
                    vM = vm = vmg.getVM();
                    synchronized (vM) {
                        vm.callback("DisConnected", null);
                    }
                }
                if ((vmg = VMGame.getVMGame("game_init_once")) == null) break block37;
                vM = vm = vmg.gtvm;
                synchronized (vM) {
                    vm.callback("DisConnected", null);
                }
            }
        }
        if (this.listenVM != null && !this.async) {
            this.listenVM.continueProcess(result ? 1 : 0);
        }
    }

    public static void createConnection(String url) throws Exception {
        if (connection == null) {
            connection = new UASocketConnection(url);
            connection.start();
        }
    }

    public static void tryReconnect() {
        Utilities.closeConnection();
    }

    public static void closeConnection() {
        if (connection != null) {
            try {
                UASocketConnection temp = connection;
                connection = null;
                temp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.gc();
    }

    public static int sendRequest(UASegment segment) {
        if (connection != null) {
            UASocketConnection.writeSegment(segment);
        } else {
            System.out.println("==============warning: connection is null. request not sent");
        }
        return segment.serial;
    }

    public static void addSegment(UASegment segment) {
        segments.addElement(segment);
    }

    public static void keyPressed(int keyCode) {
        keyCode = Math.abs(keyCode);
        try {
            int id = Utilities.keyToGame(keyCode);
            if (id >= 0) {
                keyFlag |= 3L << (id << 1);
            }
            if ((id = Utilities.keyToNum(keyCode)) >= 0) {
                keyFlag |= 3L << (id << 1);
            }
            if (keyCode == GameMain.debugKeyOrder[GameMain.debugTestIndex]) {
                if (++GameMain.debugTestIndex >= GameMain.debugKeyOrder.length - 1) {
                    GameMain.debugMode = !GameMain.debugMode;
                    Tool.setGlobalValue("varDebugModel", new Integer(GameMain.debugMode ? 1 : 0));
                }
                if (GameMain.debugTestIndex >= GameMain.debugKeyOrder.length) {
                    GameMain.debugTestIndex = 0;
                    UASocketConnection.offlineMode = !UASocketConnection.offlineMode;
                }
            } else {
                GameMain.debugTestIndex = 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void keyReleased(int keyCode) {
        keyCode = Math.abs(keyCode);
        try {
            int id = Utilities.keyToGame(keyCode);
            if (id >= 0) {
                keyFlag &= 2L << (id << 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((id = Utilities.keyToNum(keyCode)) >= 0) {
                keyFlag &= 2L << (id << 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void sendKeyPressed(int keyId) {
        if (keyId >= 0) {
            keyFlag |= 3L << (keyId << 1);
        }
        if (keyId >= 0) {
            keyFlag &= 2L << (keyId << 1) ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static void sendKeyDown(int keyId) {
        if (keyId >= 0) {
            keyFlag |= 3L << (keyId << 1);
        }
    }

    public static void sendKeyUp(int keyId) {
        if (keyId >= 0) {
            keyFlag &= 2L << (keyId << 1) ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static int keyToGame(int keyCode) {
        switch (keyCode) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
        }
        return -1;
    }

    public static int keyToNum(int keyCode) {
        switch (keyCode) {
            case 35: {
                return 21;
            }
            case 42: {
                return 22;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 10;
            }
        }
        if (keyCode >= 48 && keyCode <= 57) {
            return 11 + (keyCode - 48);
        }
        return -1;
    }

    public static final boolean isAnyKeyPressed() {
        return keyFlag2 != 0L;
    }

    public static final boolean isKeyPressed(int key, boolean clear) {
        boolean ret;
        long k = 3L << (key << 1);
        boolean bl = ret = (keyFlag2 & k) != 0L;
        if (clear && ret) {
            keyFlag &= k ^ 0xFFFFFFFFFFFFFFFFL;
            keyFlag2 &= k ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return ret;
    }

    public static void clearKeyStates() {
        keyFlag2 = 0L;
        keyFlag = 0L;
    }

    public static int multiKeyCheck(int[] keys, boolean clear) {
        int count = keys.length;
        for (int i = 0; i < count; ++i) {
            if (!Utilities.isKeyPressed(keys[i], clear)) continue;
            return keys[i];
        }
        return -1;
    }

    public static byte[] getBytesFromInput(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int rd = 0;
        int len = 0;
        byte[] buf = new byte[64];
        while ((rd = in.read(buf)) != -1) {
            len += rd;
            out.write(buf, 0, rd);
        }
        byte[] rt = out.toByteArray();
        out.close();
        return rt;
    }

    public static String[] formatText(String text, int width, Font font) {
        Vector<String> vec = new Vector<String>();
        int lineStart = 0;
        int lineWid = 0;
        int charCount = text.length();
        for (int i = 0; i < charCount; ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                if (i > 0 && text.charAt(i - 1) == '\r') {
                    vec.addElement(text.substring(lineStart, i - 1));
                } else {
                    vec.addElement(text.substring(lineStart, i));
                }
                lineStart = i + 1;
                lineWid = 0;
                continue;
            }
            int charWid = font.charWidth(ch);
            if (lineWid == 0 || lineWid + charWid <= width) {
                lineWid += charWid;
                continue;
            }
            if (punctation.indexOf(ch) >= 0) {
                charWid += font.charWidth(text.charAt(--i));
            }
            vec.addElement(text.substring(lineStart, i));
            lineStart = i;
            lineWid = charWid;
        }
        if (lineWid > 0) {
            vec.addElement(text.substring(lineStart));
        }
        Object[] ret = new String[vec.size()];
        vec.copyInto(ret);
        return ret;
    }

    static {
        font = Font.getFont((int)0, (int)0, (int)8);
        if (font.getHeight() < 12 && (font = Font.getFont((int)0, (int)0, (int)0)).getHeight() < 12) {
            font = Font.getFont((int)0, (int)0, (int)16);
        }
        CHAR_HEIGHT = font.getHeight();
        CHAR_OFFSET = 0;
        LINE_HEIGHT = CHAR_HEIGHT;
        CHAR_WIDTH = font.stringWidth("\u56fd");
        isExitGame = false;
        appStartTime = Tool.getSystemTime();
        emulatorDetected = false;
    }
}

