/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private String delimiters;
    private char[] inputChars;
    private String inputText;
    private int startPosition;
    private boolean hasMoreTokens;

    public StringTokenizer(String input, char delimiter) {
        this.reset(input, String.valueOf(delimiter));
    }

    public StringTokenizer(String input, String delimiters) {
        this.reset(input, delimiters);
    }

    public void reset(String input, char delim) {
        this.reset(input, String.valueOf(delim));
    }

    public void reset(String input, String delimiters) {
        this.inputText = input;
        this.delimiters = delimiters;
        this.inputChars = input.toCharArray();
        this.updateTokenStartPosition(input, this.inputChars, this.delimiters);
    }

    protected void updateTokenStartPosition(String input, char[] chars, String delimiters) {
        while (this.startPosition < chars.length) {
            char c = chars[this.startPosition];
            if (delimiters.indexOf(c) == -1) {
                this.hasMoreTokens = true;
                return;
            }
            ++this.startPosition;
        }
        this.hasMoreTokens = false;
    }

    public boolean hasMoreTokens() {
        return this.hasMoreTokens;
    }

    public String nextToken() {
        int position;
        if (!this.hasMoreTokens) {
            throw new NoSuchElementException();
        }
        int length = this.inputChars.length;
        for (position = this.startPosition + 1; position < length && this.delimiters.indexOf(this.inputChars[position]) == -1; ++position) {
        }
        if (position >= length) {
            String value = this.inputText.substring(this.startPosition);
            this.startPosition = position++;
            this.updateTokenStartPosition(this.inputText, this.inputChars, this.delimiters);
            return value;
        }
        String value = this.inputText.substring(this.startPosition, position);
        this.startPosition = position++;
        this.updateTokenStartPosition(this.inputText, this.inputChars, this.delimiters);
        return value;
    }

    public int countTokens() {
        int position;
        int length = this.inputChars.length;
        int number = 0;
        int lastPosition = position - 1;
        char c = this.delimiters.charAt(0);
        for (position = this.startPosition; position < length; ++position) {
            c = this.inputChars[position];
            if (this.delimiters.indexOf(c) <= -1) continue;
            if (position > lastPosition + 1) {
                ++number;
            }
            lastPosition = position;
        }
        if (this.delimiters.indexOf(c) == -1) {
            ++number;
        }
        return number;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }
}

