/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.math;

import java.util.Random;
import java.util.Stack;

public class BigInteger {
    private static final int[][] primeLists = new int[][]{{3, 5, 7, 11, 13, 17, 19, 23}, {29, 31, 37, 41, 43}, {47, 53, 59, 61, 67}, {71, 73, 79, 83}, {89, 97, 101, 103}, {107, 109, 113, 127}, {131, 137, 139, 149}, {151, 157, 163, 167}, {173, 179, 181, 191}, {193, 197, 199, 211}, {223, 227, 229}, {233, 239, 241}, {251, 257, 263}, {269, 271, 277}, {281, 283, 293}, {307, 311, 313}, {317, 331, 337}, {347, 349, 353}, {359, 367, 373}, {379, 383, 389}, {397, 401, 409}, {419, 421, 431}, {433, 439, 443}, {449, 457, 461}, {463, 467, 479}, {487, 491, 499}, {503, 509, 521}, {523, 541, 547}, {557, 563, 569}, {571, 577, 587}, {593, 599, 601}, {607, 613, 617}, {619, 631, 641}, {643, 647, 653}, {659, 661, 673}, {677, 683, 691}, {701, 709, 719}, {727, 733, 739}, {743, 751, 757}, {761, 769, 773}, {787, 797, 809}, {811, 821, 823}, {827, 829, 839}, {853, 857, 859}, {863, 877, 881}, {883, 887, 907}, {911, 919, 929}, {937, 941, 947}, {953, 967, 971}, {977, 983, 991}, {997, 1009, 1013}, {1019, 1021, 1031}};
    private static int[] primeProducts;
    private static final long IMASK = 0xFFFFFFFFL;
    private static final int[] ZERO_MAGNITUDE;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger TWO;
    private static final BigInteger THREE;
    private int sign;
    private int[] magnitude;
    private int nBits = -1;
    private int nBitLength = -1;
    private long mQuote = -1L;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_INT = 4;
    private static final byte[] rndMask;
    private static final byte[] bitCounts;

    private BigInteger() {
    }

    private BigInteger(int signum, int[] mag) {
        if (mag.length > 0) {
            int i;
            this.sign = signum;
            for (i = 0; i < mag.length && mag[i] == 0; ++i) {
            }
            if (i == 0) {
                this.magnitude = mag;
            } else {
                int[] newMag = new int[mag.length - i];
                System.arraycopy(mag, i, newMag, 0, newMag.length);
                this.magnitude = newMag;
                if (newMag.length == 0) {
                    this.sign = 0;
                }
            }
        } else {
            this.magnitude = mag;
            this.sign = 0;
        }
    }

    public BigInteger(String sval) throws NumberFormatException {
        this(sval, 10);
    }

    public BigInteger(String sval, int rdx) throws NumberFormatException {
        if (sval.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (rdx < 2 || rdx > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        int index = 0;
        this.sign = 1;
        if (sval.charAt(0) == '-') {
            if (sval.length() == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.sign = -1;
            index = 1;
        }
        while (index < sval.length() && Character.digit(sval.charAt(index), rdx) == 0) {
            ++index;
        }
        if (index >= sval.length()) {
            this.sign = 0;
            this.magnitude = new int[0];
            return;
        }
        BigInteger b = ZERO;
        BigInteger r = BigInteger.valueOf(rdx);
        while (index < sval.length()) {
            b = b.multiply(r).add(BigInteger.valueOf(Character.digit(sval.charAt(index), rdx)));
            ++index;
        }
        this.magnitude = b.magnitude;
    }

    public BigInteger(byte[] bval) throws NumberFormatException {
        if (bval.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.sign = 1;
        if (bval[0] < 0) {
            this.sign = -1;
        }
        this.magnitude = this.makeMagnitude(bval, this.sign);
        if (this.magnitude.length == 0) {
            this.sign = 0;
        }
    }

    private int[] makeMagnitude(byte[] bval, int sign) {
        int i;
        int firstSignificant;
        if (sign >= 0) {
            int firstSignificant2;
            for (firstSignificant2 = 0; firstSignificant2 < bval.length && bval[firstSignificant2] == 0; ++firstSignificant2) {
            }
            if (firstSignificant2 >= bval.length) {
                return new int[0];
            }
            int nInts = (bval.length - firstSignificant2 + 3) / 4;
            int bCount = (bval.length - firstSignificant2) % 4;
            if (bCount == 0) {
                bCount = 4;
            }
            int[] mag = new int[nInts];
            int v = 0;
            int magnitudeIndex = 0;
            for (int i2 = firstSignificant2; i2 < bval.length; ++i2) {
                v <<= 8;
                v |= bval[i2] & 0xFF;
                if (--bCount > 0) continue;
                mag[magnitudeIndex] = v;
                ++magnitudeIndex;
                bCount = 4;
                v = 0;
            }
            return mag;
        }
        for (firstSignificant = 0; firstSignificant < bval.length - 1 && bval[firstSignificant] == 255; ++firstSignificant) {
        }
        int nBytes = bval.length;
        boolean leadingByte = false;
        if (bval[firstSignificant] == 128) {
            for (i = firstSignificant + 1; i < bval.length && bval[i] == 0; ++i) {
            }
            if (i == bval.length) {
                ++nBytes;
                leadingByte = true;
            }
        }
        int nInts = (nBytes - firstSignificant + 3) / 4;
        int bCount = (nBytes - firstSignificant) % 4;
        if (bCount == 0) {
            bCount = 4;
        }
        int[] mag = new int[nInts];
        int v = 0;
        int magnitudeIndex = 0;
        if (leadingByte && --bCount <= 0) {
            ++magnitudeIndex;
            bCount = 4;
        }
        for (i = firstSignificant; i < bval.length; ++i) {
            v <<= 8;
            v |= ~bval[i] & 0xFF;
            if (--bCount > 0) continue;
            mag[magnitudeIndex] = v;
            ++magnitudeIndex;
            bCount = 4;
            v = 0;
        }
        if ((mag = this.inc(mag))[0] == 0) {
            int[] tmp = new int[mag.length - 1];
            System.arraycopy(mag, 1, tmp, 0, tmp.length);
            mag = tmp;
        }
        return mag;
    }

    public BigInteger(int sign, byte[] mag) throws NumberFormatException {
        if (sign < -1 || sign > 1) {
            throw new NumberFormatException("Invalid sign value");
        }
        if (sign == 0) {
            this.sign = 0;
            this.magnitude = new int[0];
            return;
        }
        this.magnitude = this.makeMagnitude(mag, 1);
        this.sign = sign;
    }

    public BigInteger(int numBits, Random rnd) throws IllegalArgumentException {
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        this.nBits = -1;
        this.nBitLength = -1;
        if (numBits == 0) {
            this.magnitude = ZERO_MAGNITUDE;
            return;
        }
        int nBytes = (numBits + 7) / 8;
        byte[] b = new byte[nBytes];
        this.nextRndBytes(rnd, b);
        b[0] = (byte)(b[0] & rndMask[8 * nBytes - numBits]);
        this.magnitude = this.makeMagnitude(b, 1);
        this.sign = this.magnitude.length < 1 ? 0 : 1;
    }

    private void nextRndBytes(Random rnd, byte[] bytes) {
        int numRequested = bytes.length;
        int numGot = 0;
        int r = 0;
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i >= 4) continue block0;
                if (numGot == numRequested) {
                    return;
                }
                r = i == 0 ? rnd.nextInt() : r >> 8;
                bytes[numGot++] = (byte)r;
                ++i;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger(int bitLength, int certainty, Random rnd) throws ArithmeticException {
        super();
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        this.sign = 1;
        this.nBitLength = bitLength;
        if (bitLength == 2) {
            this.magnitude = rnd.nextInt() < 0 ? BigInteger.TWO.magnitude : BigInteger.THREE.magnitude;
            return;
        }
        nBytes = (bitLength + 7) / 8;
        xBits = 8 * nBytes - bitLength;
        mask = BigInteger.rndMask[xBits];
        b = new byte[nBytes];
        block0: while (true) {
            this.nextRndBytes(rnd, b);
            b[0] = (byte)(b[0] & mask);
            b[0] = (byte)(b[0] | (byte)(1 << 7 - xBits));
            v0 = nBytes - 1;
            b[v0] = (byte)(b[v0] | 1);
            this.magnitude = this.makeMagnitude(b, 1);
            this.nBits = -1;
            this.mQuote = -1L;
            if (certainty < 1 || this.isProbablePrime(certainty)) break;
            if (bitLength <= 32) continue;
            rep = 0;
            while (true) {
                if (rep < 10000) ** break;
                continue block0;
                n = 33 + (rnd.nextInt() >>> 1) % (bitLength - 2);
                v1 = this.magnitude.length - (n >>> 5);
                this.magnitude[v1] = this.magnitude[v1] ^ 1 << (n & 31);
                v2 = this.magnitude.length - 1;
                this.magnitude[v2] = this.magnitude[v2] ^ rnd.nextInt() << 1;
                this.mQuote = -1L;
                if (this.isProbablePrime(certainty)) {
                    return;
                }
                ++rep;
            }
            break;
        }
    }

    public BigInteger abs() {
        return this.sign >= 0 ? this : this.negate();
    }

    private int[] add(int[] a, int[] b) {
        int tI = a.length - 1;
        int vI = b.length - 1;
        long m = 0L;
        while (vI >= 0) {
            a[tI--] = (int)(m += ((long)a[tI] & 0xFFFFFFFFL) + ((long)b[vI--] & 0xFFFFFFFFL));
            m >>>= 32;
        }
        while (tI >= 0 && m != 0L) {
            a[tI--] = (int)(m += (long)a[tI] & 0xFFFFFFFFL);
            m >>>= 32;
        }
        return a;
    }

    private int[] inc(int[] a) {
        int tI = a.length - 1;
        long m = 0L;
        m = ((long)a[tI] & 0xFFFFFFFFL) + 1L;
        a[tI--] = (int)m;
        m >>>= 32;
        while (tI >= 0 && m != 0L) {
            a[tI--] = (int)(m += (long)a[tI] & 0xFFFFFFFFL);
            m >>>= 32;
        }
        return a;
    }

    public BigInteger add(BigInteger val) throws ArithmeticException {
        if (val.sign == 0 || val.magnitude.length == 0) {
            return this;
        }
        if (this.sign == 0 || this.magnitude.length == 0) {
            return val;
        }
        if (val.sign < 0) {
            if (this.sign > 0) {
                return this.subtract(val.negate());
            }
        } else if (this.sign < 0) {
            return val.subtract(this.negate());
        }
        return this.addToMagnitude(val.magnitude);
    }

    private BigInteger addToMagnitude(int[] magToAdd) {
        int[] small;
        int[] big;
        if (this.magnitude.length < magToAdd.length) {
            big = magToAdd;
            small = this.magnitude;
        } else {
            big = this.magnitude;
            small = magToAdd;
        }
        int limit = Integer.MAX_VALUE;
        if (big.length == small.length) {
            limit -= small[0];
        }
        boolean possibleOverflow = (big[0] ^ Integer.MIN_VALUE) >= limit;
        int extra = possibleOverflow ? 1 : 0;
        int[] bigCopy = new int[big.length + extra];
        System.arraycopy(big, 0, bigCopy, extra, big.length);
        bigCopy = this.add(bigCopy, small);
        return new BigInteger(this.sign, bigCopy);
    }

    public BigInteger and(BigInteger value) {
        if (this.sign == 0 || value.sign == 0) {
            return ZERO;
        }
        int[] aMag = this.sign > 0 ? this.magnitude : this.add((BigInteger)BigInteger.ONE).magnitude;
        int[] bMag = value.sign > 0 ? value.magnitude : value.add((BigInteger)BigInteger.ONE).magnitude;
        boolean resultNeg = this.sign < 0 && value.sign < 0;
        int resultLength = Math.max(aMag.length, bMag.length);
        int[] resultMag = new int[resultLength];
        int aStart = resultMag.length - aMag.length;
        int bStart = resultMag.length - bMag.length;
        for (int i = 0; i < resultMag.length; ++i) {
            int bWord;
            int aWord = i >= aStart ? aMag[i - aStart] : 0;
            int n = bWord = i >= bStart ? bMag[i - bStart] : 0;
            if (this.sign < 0) {
                aWord ^= 0xFFFFFFFF;
            }
            if (value.sign < 0) {
                bWord ^= 0xFFFFFFFF;
            }
            resultMag[i] = aWord & bWord;
            if (!resultNeg) continue;
            resultMag[i] = ~resultMag[i];
        }
        BigInteger result = new BigInteger(1, resultMag);
        if (resultNeg) {
            result = result.not();
        }
        return result;
    }

    public BigInteger andNot(BigInteger value) {
        return this.and(value.not());
    }

    public int bitCount() {
        if (this.nBits == -1) {
            if (this.sign < 0) {
                this.nBits = this.not().bitCount();
            } else {
                int sum = 0;
                for (int i = 0; i < this.magnitude.length; ++i) {
                    sum += bitCounts[this.magnitude[i] & 0xFF];
                    sum += bitCounts[this.magnitude[i] >> 8 & 0xFF];
                    sum += bitCounts[this.magnitude[i] >> 16 & 0xFF];
                    sum += bitCounts[this.magnitude[i] >> 24 & 0xFF];
                }
                this.nBits = sum;
            }
        }
        return this.nBits;
    }

    private int bitLength(int indx, int[] mag) {
        if (mag.length == 0) {
            return 0;
        }
        while (indx != mag.length && mag[indx] == 0) {
            ++indx;
        }
        if (indx == mag.length) {
            return 0;
        }
        int bitLength = 32 * (mag.length - indx - 1);
        bitLength += BigInteger.bitLen(mag[indx]);
        if (this.sign < 0) {
            boolean pow2 = bitCounts[mag[indx] & 0xFF] + bitCounts[mag[indx] >> 8 & 0xFF] + bitCounts[mag[indx] >> 16 & 0xFF] + bitCounts[mag[indx] >> 24 & 0xFF] == 1;
            for (int i = indx + 1; i < mag.length && pow2; ++i) {
                pow2 = mag[i] == 0;
            }
            bitLength -= pow2 ? 1 : 0;
        }
        return bitLength;
    }

    public int bitLength() {
        if (this.nBitLength == -1) {
            this.nBitLength = this.sign == 0 ? 0 : this.bitLength(0, this.magnitude);
        }
        return this.nBitLength;
    }

    static int bitLen(int w) {
        return w < 32768 ? (w < 128 ? (w < 8 ? (w < 2 ? (w < 1 ? (w < 0 ? 32 : 0) : 1) : (w < 4 ? 2 : 3)) : (w < 32 ? (w < 16 ? 4 : 5) : (w < 64 ? 6 : 7))) : (w < 2048 ? (w < 512 ? (w < 256 ? 8 : 9) : (w < 1024 ? 10 : 11)) : (w < 8192 ? (w < 4096 ? 12 : 13) : (w < 16384 ? 14 : 15)))) : (w < 0x800000 ? (w < 524288 ? (w < 131072 ? (w < 65536 ? 16 : 17) : (w < 262144 ? 18 : 19)) : (w < 0x200000 ? (w < 0x100000 ? 20 : 21) : (w < 0x400000 ? 22 : 23))) : (w < 0x8000000 ? (w < 0x2000000 ? (w < 0x1000000 ? 24 : 25) : (w < 0x4000000 ? 26 : 27)) : (w < 0x20000000 ? (w < 0x10000000 ? 28 : 29) : (w < 0x40000000 ? 30 : 31))));
    }

    private boolean quickPow2Check() {
        return this.sign > 0 && this.nBits == 1;
    }

    public int compareTo(Object o) {
        return this.compareTo((BigInteger)o);
    }

    private int compareTo(int xIndx, int[] x, int yIndx, int[] y) {
        while (xIndx != x.length && x[xIndx] == 0) {
            ++xIndx;
        }
        while (yIndx != y.length && y[yIndx] == 0) {
            ++yIndx;
        }
        return this.compareNoLeadingZeroes(xIndx, x, yIndx, y);
    }

    private int compareNoLeadingZeroes(int xIndx, int[] x, int yIndx, int[] y) {
        int diff = x.length - y.length - (xIndx - yIndx);
        if (diff != 0) {
            return diff < 0 ? -1 : 1;
        }
        while (xIndx < x.length) {
            int v2;
            int v1;
            if ((v1 = x[xIndx++]) == (v2 = y[yIndx++])) continue;
            return (v1 ^ Integer.MIN_VALUE) < (v2 ^ Integer.MIN_VALUE) ? -1 : 1;
        }
        return 0;
    }

    public int compareTo(BigInteger val) {
        if (this.sign < val.sign) {
            return -1;
        }
        if (this.sign > val.sign) {
            return 1;
        }
        if (this.sign == 0) {
            return 0;
        }
        return this.sign * this.compareTo(0, this.magnitude, 0, val.magnitude);
    }

    private int[] divide(int[] x, int[] y) {
        int[] count;
        int xyCmp = this.compareTo(0, x, 0, y);
        if (xyCmp > 0) {
            int[] c;
            int shift = this.bitLength(0, x) - this.bitLength(0, y);
            if (shift > 1) {
                c = this.shiftLeft(y, shift - 1);
                count = this.shiftLeft(BigInteger.ONE.magnitude, shift - 1);
                if (shift % 32 == 0) {
                    int[] countSpecial = new int[shift / 32 + 1];
                    System.arraycopy(count, 0, countSpecial, 1, countSpecial.length - 1);
                    countSpecial[0] = 0;
                    count = countSpecial;
                }
            } else {
                c = new int[x.length];
                count = new int[1];
                System.arraycopy(y, 0, c, c.length - y.length, y.length);
                count[0] = 1;
            }
            int[] iCount = new int[count.length];
            this.subtract(0, x, 0, c);
            System.arraycopy(count, 0, iCount, 0, count.length);
            int xStart = 0;
            int cStart = 0;
            int iCountStart = 0;
            while (true) {
                int cmp = this.compareTo(xStart, x, cStart, c);
                while (cmp >= 0) {
                    this.subtract(xStart, x, cStart, c);
                    this.add(count, iCount);
                    cmp = this.compareTo(xStart, x, cStart, c);
                }
                xyCmp = this.compareTo(xStart, x, 0, y);
                if (xyCmp <= 0) break;
                if (x[xStart] == 0) {
                    ++xStart;
                }
                if ((shift = this.bitLength(cStart, c) - this.bitLength(xStart, x)) == 0) {
                    c = this.shiftRightOneInPlace(cStart, c);
                    iCount = this.shiftRightOneInPlace(iCountStart, iCount);
                } else {
                    c = this.shiftRightInPlace(cStart, c, shift);
                    iCount = this.shiftRightInPlace(iCountStart, iCount, shift);
                }
                if (c[cStart] == 0) {
                    ++cStart;
                }
                if (iCount[iCountStart] != 0) continue;
                ++iCountStart;
            }
            if (xyCmp == 0) {
                this.add(count, BigInteger.ONE.magnitude);
                for (int i = xStart; i != x.length; ++i) {
                    x[i] = 0;
                }
            }
        } else {
            count = xyCmp == 0 ? new int[]{1} : new int[]{0};
        }
        return count;
    }

    public BigInteger divide(BigInteger val) throws ArithmeticException {
        if (val.sign == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.sign == 0) {
            return ZERO;
        }
        if (val.compareTo(ONE) == 0) {
            return this;
        }
        int[] mag = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, mag, 0, mag.length);
        return new BigInteger(this.sign * val.sign, this.divide(mag, val.magnitude));
    }

    public BigInteger[] divideAndRemainder(BigInteger val) throws ArithmeticException {
        if (val.sign == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        BigInteger[] biggies = new BigInteger[2];
        if (this.sign == 0) {
            biggies[0] = biggies[1] = ZERO;
            return biggies;
        }
        if (val.compareTo(ONE) == 0) {
            biggies[0] = this;
            biggies[1] = ZERO;
            return biggies;
        }
        int[] remainder = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, remainder, 0, remainder.length);
        int[] quotient = this.divide(remainder, val.magnitude);
        biggies[0] = new BigInteger(this.sign * val.sign, quotient);
        biggies[1] = new BigInteger(this.sign, remainder);
        return biggies;
    }

    public boolean equals(Object val) {
        if (val == this) {
            return true;
        }
        if (!(val instanceof BigInteger)) {
            return false;
        }
        BigInteger biggie = (BigInteger)val;
        if (biggie.sign != this.sign || biggie.magnitude.length != this.magnitude.length) {
            return false;
        }
        for (int i = 0; i < this.magnitude.length; ++i) {
            if (biggie.magnitude[i] == this.magnitude[i]) continue;
            return false;
        }
        return true;
    }

    public BigInteger gcd(BigInteger val) {
        if (val.sign == 0) {
            return this.abs();
        }
        if (this.sign == 0) {
            return val.abs();
        }
        BigInteger u = this;
        BigInteger v = val;
        while (v.sign != 0) {
            BigInteger r = u.mod(v);
            u = v;
            v = r;
        }
        return u;
    }

    public int hashCode() {
        int hc = this.magnitude.length;
        if (this.magnitude.length > 0) {
            hc ^= this.magnitude[0];
            if (this.magnitude.length > 1) {
                hc ^= this.magnitude[this.magnitude.length - 1];
            }
        }
        return this.sign < 0 ? ~hc : hc;
    }

    public int intValue() {
        if (this.magnitude.length == 0) {
            return 0;
        }
        if (this.sign < 0) {
            return -this.magnitude[this.magnitude.length - 1];
        }
        return this.magnitude[this.magnitude.length - 1];
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public boolean isProbablePrime(int certainty) {
        if (certainty <= 0) {
            return true;
        }
        if (this.sign == 0) {
            return false;
        }
        BigInteger n = this.abs();
        if (!n.testBit(0)) {
            return n.equals(TWO);
        }
        if (n.equals(ONE)) {
            return false;
        }
        int numLists = Math.min(n.bitLength() - 1, primeLists.length);
        for (int i = 0; i < numLists; ++i) {
            int test = n.remainder(primeProducts[i]);
            int[] primeList = primeLists[i];
            for (int j = 0; j < primeList.length; ++j) {
                int prime = primeList[j];
                int qRem = test % prime;
                if (qRem != 0) continue;
                return n.bitLength() < 16 && n.intValue() == prime;
            }
        }
        BigInteger nMinusOne = n.subtract(ONE);
        int s = nMinusOne.getLowestSetBit();
        BigInteger r = nMinusOne.shiftRight(s);
        Random random = new Random();
        while (true) {
            BigInteger a;
            if ((a = new BigInteger(n.bitLength(), random)).compareTo(ONE) <= 0 || a.compareTo(nMinusOne) >= 0) {
                continue;
            }
            BigInteger y = a.modPow(r, n);
            if (!y.equals(ONE)) {
                int j = 0;
                while (!y.equals(nMinusOne)) {
                    if (++j == s) {
                        return false;
                    }
                    if (!(y = y.modPow(TWO, n)).equals(ONE)) continue;
                    return false;
                }
            }
            if ((certainty -= 2) <= 0) break;
        }
        return true;
    }

    public long longValue() {
        long val = 0L;
        if (this.magnitude.length == 0) {
            return 0L;
        }
        val = this.magnitude.length > 1 ? (long)this.magnitude[this.magnitude.length - 2] << 32 | (long)this.magnitude[this.magnitude.length - 1] & 0xFFFFFFFFL : (long)this.magnitude[this.magnitude.length - 1] & 0xFFFFFFFFL;
        if (this.sign < 0) {
            return -val;
        }
        return val;
    }

    public BigInteger max(BigInteger val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public BigInteger min(BigInteger val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    public BigInteger mod(BigInteger m) throws ArithmeticException {
        if (m.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus is not positive");
        }
        BigInteger biggie = this.remainder(m);
        return biggie.sign >= 0 ? biggie : biggie.add(m);
    }

    public BigInteger modInverse(BigInteger m) throws ArithmeticException {
        if (m.sign != 1) {
            throw new ArithmeticException("Modulus must be positive");
        }
        BigInteger x = new BigInteger();
        BigInteger gcd = BigInteger.extEuclid(this, m, x, null);
        if (!gcd.equals(ONE)) {
            throw new ArithmeticException("Numbers not relatively prime.");
        }
        if (x.compareTo(ZERO) < 0) {
            x = x.add(m);
        }
        return x;
    }

    private static BigInteger extEuclid(BigInteger a, BigInteger b, BigInteger u1Out, BigInteger u2Out) {
        BigInteger u1 = ONE;
        BigInteger u3 = a;
        BigInteger v1 = ZERO;
        BigInteger v3 = b;
        while (v3.sign > 0) {
            BigInteger[] q = u3.divideAndRemainder(v3);
            BigInteger tn = u1.subtract(v1.multiply(q[0]));
            u1 = v1;
            v1 = tn;
            u3 = v3;
            v3 = q[1];
        }
        if (u1Out != null) {
            u1Out.sign = u1.sign;
            u1Out.magnitude = u1.magnitude;
        }
        if (u2Out != null) {
            BigInteger res = u3.subtract(u1.multiply(a)).divide(b);
            u2Out.sign = res.sign;
            u2Out.magnitude = res.magnitude;
        }
        return u3;
    }

    private void zero(int[] x) {
        for (int i = 0; i != x.length; ++i) {
            x[i] = 0;
        }
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m) throws ArithmeticException {
        BigInteger tmp;
        if (m.sign < 1) {
            throw new ArithmeticException("Modulus must be positive");
        }
        if (m.equals(ONE)) {
            return ZERO;
        }
        if (exponent.sign == 0) {
            return ONE;
        }
        if (this.sign == 0) {
            return ZERO;
        }
        int[] zVal = null;
        int[] yAccum = null;
        boolean useMonty = (m.magnitude[m.magnitude.length - 1] & 1) == 1;
        long mQ = 0L;
        if (useMonty) {
            mQ = m.getMQuote();
            tmp = this.shiftLeft(32 * m.magnitude.length).mod(m);
            zVal = tmp.magnitude;
            boolean bl = useMonty = zVal.length <= m.magnitude.length;
            if (useMonty) {
                yAccum = new int[m.magnitude.length + 1];
                if (zVal.length < m.magnitude.length) {
                    int[] longZ = new int[m.magnitude.length];
                    System.arraycopy(zVal, 0, longZ, longZ.length - zVal.length, zVal.length);
                    zVal = longZ;
                }
            }
        }
        if (!useMonty) {
            if (this.magnitude.length <= m.magnitude.length) {
                zVal = new int[m.magnitude.length];
                System.arraycopy(this.magnitude, 0, zVal, zVal.length - this.magnitude.length, this.magnitude.length);
            } else {
                tmp = this.remainder(m);
                zVal = new int[m.magnitude.length];
                System.arraycopy(tmp.magnitude, 0, zVal, zVal.length - tmp.magnitude.length, tmp.magnitude.length);
            }
            yAccum = new int[m.magnitude.length * 2];
        }
        int[] yVal = new int[m.magnitude.length];
        for (int i = 0; i < exponent.magnitude.length; ++i) {
            int v = exponent.magnitude[i];
            int bits = 0;
            if (i == 0) {
                while (v > 0) {
                    v <<= 1;
                    ++bits;
                }
                System.arraycopy(zVal, 0, yVal, 0, zVal.length);
                v <<= 1;
                ++bits;
            }
            while (v != 0) {
                if (useMonty) {
                    this.multiplyMonty(yAccum, yVal, yVal, m.magnitude, mQ);
                } else {
                    this.square(yAccum, yVal);
                    this.remainder(yAccum, m.magnitude);
                    System.arraycopy(yAccum, yAccum.length - yVal.length, yVal, 0, yVal.length);
                    this.zero(yAccum);
                }
                ++bits;
                if (v < 0) {
                    if (useMonty) {
                        this.multiplyMonty(yAccum, yVal, zVal, m.magnitude, mQ);
                    } else {
                        this.multiply(yAccum, yVal, zVal);
                        this.remainder(yAccum, m.magnitude);
                        System.arraycopy(yAccum, yAccum.length - yVal.length, yVal, 0, yVal.length);
                        this.zero(yAccum);
                    }
                }
                v <<= 1;
            }
            while (bits < 32) {
                if (useMonty) {
                    this.multiplyMonty(yAccum, yVal, yVal, m.magnitude, mQ);
                } else {
                    this.square(yAccum, yVal);
                    this.remainder(yAccum, m.magnitude);
                    System.arraycopy(yAccum, yAccum.length - yVal.length, yVal, 0, yVal.length);
                    this.zero(yAccum);
                }
                ++bits;
            }
        }
        if (useMonty) {
            this.zero(zVal);
            zVal[zVal.length - 1] = 1;
            this.multiplyMonty(yAccum, yVal, zVal, m.magnitude, mQ);
        }
        BigInteger result = new BigInteger(1, yVal);
        return exponent.sign > 0 ? result : result.modInverse(m);
    }

    private int[] square(int[] w, int[] x) {
        long u2;
        long u1;
        int wBase = w.length - 1;
        for (int i = x.length - 1; i != 0; --i) {
            long v = (long)x[i] & 0xFFFFFFFFL;
            u1 = v * v;
            u2 = u1 >>> 32;
            u1 &= 0xFFFFFFFFL;
            w[wBase] = (int)(u1 += (long)w[wBase] & 0xFFFFFFFFL);
            long c = u2 + (u1 >> 32);
            for (int j = i - 1; j >= 0; --j) {
                u1 = ((long)x[j] & 0xFFFFFFFFL) * v;
                u2 = u1 >>> 31;
                u1 = (u1 & Integer.MAX_VALUE) << 1;
                w[wBase] = (int)(u1 += ((long)w[--wBase] & 0xFFFFFFFFL) + c);
                c = u2 + (u1 >>> 32);
            }
            w[wBase] = (int)(c += (long)w[--wBase] & 0xFFFFFFFFL);
            if (--wBase >= 0) {
                w[wBase] = (int)(c >> 32);
            }
            wBase += i;
        }
        u1 = (long)x[0] & 0xFFFFFFFFL;
        u1 *= u1;
        u2 = u1 >>> 32;
        u1 &= 0xFFFFFFFFL;
        w[wBase] = (int)(u1 += (long)w[wBase] & 0xFFFFFFFFL);
        if (--wBase >= 0) {
            w[wBase] = (int)(u2 + (u1 >> 32) + (long)w[wBase]);
        }
        return w;
    }

    private int[] multiply(int[] x, int[] y, int[] z) {
        int i = z.length;
        if (i < 1) {
            return x;
        }
        int xBase = x.length - y.length;
        while (true) {
            long a = (long)z[--i] & 0xFFFFFFFFL;
            long val = 0L;
            for (int j = y.length - 1; j >= 0; --j) {
                x[xBase + j] = (int)(val += a * ((long)y[j] & 0xFFFFFFFFL) + ((long)x[xBase + j] & 0xFFFFFFFFL));
                val >>>= 32;
            }
            --xBase;
            if (i < 1) {
                if (xBase < 0) break;
                x[xBase] = (int)val;
                break;
            }
            x[xBase] = (int)val;
        }
        return x;
    }

    private long _extEuclid(long a, long b, long[] uOut) {
        long res;
        long u1 = 1L;
        long u3 = a;
        long v1 = 0L;
        long v3 = b;
        while (v3 > 0L) {
            long q = u3 / v3;
            long tn = u1 - v1 * q;
            u1 = v1;
            v1 = tn;
            tn = u3 - v3 * q;
            u3 = v3;
            v3 = tn;
        }
        uOut[0] = u1;
        uOut[1] = res = (u3 - u1 * a) / b;
        return u3;
    }

    private long _modInverse(long v, long m) throws ArithmeticException {
        if (m < 0L) {
            throw new ArithmeticException("Modulus must be positive");
        }
        long[] x = new long[2];
        long gcd = this._extEuclid(v, m, x);
        if (gcd != 1L) {
            throw new ArithmeticException("Numbers not relatively prime.");
        }
        if (x[0] < 0L) {
            x[0] = x[0] + m;
        }
        return x[0];
    }

    private long getMQuote() {
        if (this.mQuote != -1L) {
            return this.mQuote;
        }
        if ((this.magnitude[this.magnitude.length - 1] & 1) == 0) {
            return -1L;
        }
        long v = (long)(~this.magnitude[this.magnitude.length - 1] | 1) & 0xFFFFFFFFL;
        this.mQuote = this._modInverse(v, 0x100000000L);
        return this.mQuote;
    }

    private void multiplyMonty(int[] a, int[] x, int[] y, int[] m, long mQuote) {
        int i;
        int n = m.length;
        int nMinus1 = n - 1;
        long y_0 = (long)y[n - 1] & 0xFFFFFFFFL;
        for (i = 0; i <= n; ++i) {
            a[i] = 0;
        }
        for (i = n; i > 0; --i) {
            long x_i = (long)x[i - 1] & 0xFFFFFFFFL;
            long u = (((long)a[n] & 0xFFFFFFFFL) + (x_i * y_0 & 0xFFFFFFFFL) & 0xFFFFFFFFL) * mQuote & 0xFFFFFFFFL;
            long prod1 = x_i * y_0;
            long prod2 = u * ((long)m[n - 1] & 0xFFFFFFFFL);
            long tmp = ((long)a[n] & 0xFFFFFFFFL) + (prod1 & 0xFFFFFFFFL) + (prod2 & 0xFFFFFFFFL);
            long carry = (prod1 >>> 32) + (prod2 >>> 32) + (tmp >>> 32);
            for (int j = nMinus1; j > 0; --j) {
                prod1 = x_i * ((long)y[j - 1] & 0xFFFFFFFFL);
                prod2 = u * ((long)m[j - 1] & 0xFFFFFFFFL);
                tmp = ((long)a[j] & 0xFFFFFFFFL) + (prod1 & 0xFFFFFFFFL) + (prod2 & 0xFFFFFFFFL) + (carry & 0xFFFFFFFFL);
                carry = (carry >>> 32) + (prod1 >>> 32) + (prod2 >>> 32) + (tmp >>> 32);
                a[j + 1] = (int)tmp;
            }
            a[1] = (int)(carry += (long)a[0] & 0xFFFFFFFFL);
            a[0] = (int)(carry >>> 32);
        }
        if (this.compareTo(0, a, 0, m) >= 0) {
            this.subtract(0, a, 0, m);
        }
        System.arraycopy(a, 1, x, 0, n);
    }

    public BigInteger multiply(BigInteger val) {
        if (this.sign == 0 || val.sign == 0) {
            return ZERO;
        }
        int maxBitLength = this.bitLength() + val.bitLength();
        int resLength = (maxBitLength + 31) / 32;
        int[] res = new int[resLength];
        if (val == this) {
            this.square(res, this.magnitude);
        } else {
            this.multiply(res, this.magnitude, val.magnitude);
        }
        return new BigInteger(this.sign * val.sign, res);
    }

    public BigInteger negate() {
        if (this.sign == 0) {
            return this;
        }
        return new BigInteger(-this.sign, this.magnitude);
    }

    public BigInteger not() {
        return this.add(ONE).negate();
    }

    public BigInteger pow(int exp) throws ArithmeticException {
        if (exp < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.sign == 0) {
            return exp == 0 ? ONE : this;
        }
        BigInteger y = ONE;
        BigInteger z = this;
        while (exp != 0) {
            if ((exp & 1) == 1) {
                y = y.multiply(z);
            }
            if ((exp >>= 1) == 0) continue;
            z = z.multiply(z);
        }
        return y;
    }

    public static BigInteger probablePrime(int bitLength, Random random) {
        return new BigInteger(bitLength, 100, random);
    }

    private int remainder(int m) {
        long acc = 0L;
        for (int pos = 0; pos < this.magnitude.length; ++pos) {
            acc = (acc << 32 | (long)this.magnitude[pos] & 0xFFFFFFFFL) % (long)m;
        }
        return (int)acc;
    }

    private int[] remainder(int[] x, int[] y) {
        int yStart;
        int xStart;
        for (xStart = 0; xStart < x.length && x[xStart] == 0; ++xStart) {
        }
        for (yStart = 0; yStart < y.length && y[yStart] == 0; ++yStart) {
        }
        int xyCmp = this.compareNoLeadingZeroes(xStart, x, yStart, y);
        if (xyCmp > 0) {
            int[] c;
            int yBitLength = this.bitLength(yStart, y);
            int xBitLength = this.bitLength(xStart, x);
            int shift = xBitLength - yBitLength;
            int cStart = 0;
            int cBitLength = yBitLength;
            if (shift > 0) {
                c = this.shiftLeft(y, shift);
                cBitLength += shift;
            } else {
                int len = y.length - yStart;
                c = new int[len];
                System.arraycopy(y, yStart, c, 0, len);
            }
            block2: while (true) {
                if (cBitLength < xBitLength || this.compareNoLeadingZeroes(xStart, x, cStart, c) >= 0) {
                    this.subtract(xStart, x, cStart, c);
                    while (x[xStart] == 0) {
                        if (++xStart != x.length) continue;
                        return x;
                    }
                    xyCmp = this.compareNoLeadingZeroes(xStart, x, yStart, y);
                    if (xyCmp <= 0) break;
                    xBitLength = 32 * (x.length - xStart - 1) + BigInteger.bitLen(x[xStart]);
                }
                if ((shift = cBitLength - xBitLength) < 2) {
                    c = this.shiftRightOneInPlace(cStart, c);
                    --cBitLength;
                } else {
                    c = this.shiftRightInPlace(cStart, c, shift);
                    cBitLength -= shift;
                }
                while (true) {
                    if (c[cStart] != 0) continue block2;
                    ++cStart;
                }
                break;
            }
        }
        if (xyCmp == 0) {
            for (int i = xStart; i < x.length; ++i) {
                x[i] = 0;
            }
        }
        return x;
    }

    public BigInteger remainder(BigInteger n) throws ArithmeticException {
        int[] res;
        int val;
        if (n.sign == 0) {
            throw new ArithmeticException("BigInteger: Divide by zero");
        }
        if (this.sign == 0) {
            return ZERO;
        }
        if (n.magnitude.length == 1 && (val = n.magnitude[0]) > 0) {
            if (val == 1) {
                return ZERO;
            }
            int rem = this.remainder(val);
            return rem == 0 ? ZERO : new BigInteger(this.sign, new int[]{rem});
        }
        if (this.compareTo(0, this.magnitude, 0, n.magnitude) < 0) {
            return this;
        }
        if (n.quickPow2Check()) {
            res = this.lastNBits(n.abs().bitLength() - 1);
        } else {
            res = new int[this.magnitude.length];
            System.arraycopy(this.magnitude, 0, res, 0, res.length);
            res = this.remainder(res, n.magnitude);
        }
        return new BigInteger(this.sign, res);
    }

    private int[] lastNBits(int n) {
        if (n < 1) {
            return ZERO_MAGNITUDE;
        }
        int numWords = (n + 31) / 32;
        numWords = Math.min(numWords, this.magnitude.length);
        int[] result = new int[numWords];
        System.arraycopy(this.magnitude, this.magnitude.length - numWords, result, 0, numWords);
        int hiBits = n % 32;
        if (hiBits != 0) {
            result[0] = result[0] & ~(-1 << hiBits);
        }
        return result;
    }

    private int[] shiftLeft(int[] mag, int n) {
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = mag.length;
        int[] newMag = null;
        if (nBits == 0) {
            newMag = new int[magLen + nInts];
            System.arraycopy(mag, 0, newMag, 0, magLen);
        } else {
            int i = 0;
            int nBits2 = 32 - nBits;
            int highBits = mag[0] >>> nBits2;
            if (highBits != 0) {
                newMag = new int[magLen + nInts + 1];
                newMag[i++] = highBits;
            } else {
                newMag = new int[magLen + nInts];
            }
            int m = mag[0];
            for (int j = 0; j < magLen - 1; ++j) {
                int next = mag[j + 1];
                newMag[i++] = m << nBits | next >>> nBits2;
                m = next;
            }
            newMag[i] = mag[magLen - 1] << nBits;
        }
        return newMag;
    }

    public BigInteger shiftLeft(int n) {
        if (this.sign == 0 || this.magnitude.length == 0) {
            return ZERO;
        }
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftRight(-n);
        }
        BigInteger result = new BigInteger(this.sign, this.shiftLeft(this.magnitude, n));
        if (this.nBits != -1) {
            int n2 = result.nBits = this.sign > 0 ? this.nBits : this.nBits + n;
        }
        if (this.nBitLength != -1) {
            result.nBitLength = this.nBitLength + n;
        }
        return result;
    }

    private int[] shiftRightInPlace(int start, int[] mag, int n) {
        int nInts = (n >>> 5) + start;
        int nBits = n & 0x1F;
        int magEnd = mag.length - 1;
        if (nInts != start) {
            int i;
            int delta = nInts - start;
            for (i = magEnd; i >= nInts; --i) {
                mag[i] = mag[i - delta];
            }
            for (i = nInts - 1; i >= start; --i) {
                mag[i] = 0;
            }
        }
        if (nBits != 0) {
            int nBits2 = 32 - nBits;
            int m = mag[magEnd];
            for (int i = magEnd; i >= nInts + 1; --i) {
                int next = mag[i - 1];
                mag[i] = m >>> nBits | next << nBits2;
                m = next;
            }
            int n2 = nInts;
            mag[n2] = mag[n2] >>> nBits;
        }
        return mag;
    }

    private int[] shiftRightOneInPlace(int start, int[] mag) {
        int magEnd = mag.length - 1;
        int m = mag[magEnd];
        for (int i = magEnd; i > start; --i) {
            int next = mag[i - 1];
            mag[i] = m >>> 1 | next << 31;
            m = next;
        }
        int n = start;
        mag[n] = mag[n] >>> 1;
        return mag;
    }

    public BigInteger shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        if (n >= this.bitLength()) {
            return this.sign < 0 ? BigInteger.valueOf(-1L) : ZERO;
        }
        int[] res = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, res, 0, res.length);
        return new BigInteger(this.sign, this.shiftRightInPlace(0, res, n));
    }

    public int signum() {
        return this.sign;
    }

    private int[] subtract(int xStart, int[] x, int yStart, int[] y) {
        int iT = x.length;
        int iV = y.length;
        int borrow = 0;
        do {
            long m = ((long)x[--iT] & 0xFFFFFFFFL) - ((long)y[--iV] & 0xFFFFFFFFL) + (long)borrow;
            x[iT] = (int)m;
            borrow = (int)(m >> 63);
        } while (iV > yStart);
        if (borrow != 0) {
            int n;
            do {
                n = --iT;
            } while ((x[n] = x[n] - 1) == -1);
        }
        return x;
    }

    public BigInteger subtract(BigInteger val) {
        BigInteger littlun;
        BigInteger bigun;
        if (val.sign == 0 || val.magnitude.length == 0) {
            return this;
        }
        if (this.sign == 0 || this.magnitude.length == 0) {
            return val.negate();
        }
        if (this.sign != val.sign) {
            return this.add(val.negate());
        }
        int compare = this.compareTo(0, this.magnitude, 0, val.magnitude);
        if (compare == 0) {
            return ZERO;
        }
        if (compare < 0) {
            bigun = val;
            littlun = this;
        } else {
            bigun = this;
            littlun = val;
        }
        int[] res = new int[bigun.magnitude.length];
        System.arraycopy(bigun.magnitude, 0, res, 0, res.length);
        return new BigInteger(this.sign * compare, this.subtract(0, res, 0, littlun.magnitude));
    }

    public byte[] toByteArray() {
        if (this.sign == 0) {
            return new byte[1];
        }
        int bitLength = this.bitLength();
        byte[] bytes = new byte[bitLength / 8 + 1];
        int magIndex = this.magnitude.length;
        int bytesIndex = bytes.length;
        if (this.sign > 0) {
            while (magIndex > 1) {
                int mag = this.magnitude[--magIndex];
                bytes[--bytesIndex] = (byte)mag;
                bytes[--bytesIndex] = (byte)(mag >>> 8);
                bytes[--bytesIndex] = (byte)(mag >>> 16);
                bytes[--bytesIndex] = (byte)(mag >>> 24);
            }
            int lastMag = this.magnitude[0];
            while ((lastMag & 0xFFFFFF00) != 0) {
                bytes[--bytesIndex] = (byte)lastMag;
                lastMag >>>= 8;
            }
            bytes[--bytesIndex] = (byte)lastMag;
        } else {
            boolean carry = true;
            while (magIndex > 1) {
                int mag = ~this.magnitude[--magIndex];
                if (carry) {
                    carry = ++mag == 0;
                }
                bytes[--bytesIndex] = (byte)mag;
                bytes[--bytesIndex] = (byte)(mag >>> 8);
                bytes[--bytesIndex] = (byte)(mag >>> 16);
                bytes[--bytesIndex] = (byte)(mag >>> 24);
            }
            int lastMag = this.magnitude[0];
            if (carry) {
                --lastMag;
            }
            while ((lastMag & 0xFFFFFF00) != 0) {
                bytes[--bytesIndex] = (byte)(~lastMag);
                lastMag >>>= 8;
            }
            bytes[--bytesIndex] = (byte)(~lastMag);
            if (bytesIndex > 0) {
                bytes[--bytesIndex] = -1;
            }
        }
        return bytes;
    }

    public BigInteger xor(BigInteger val) {
        if (this.sign == 0) {
            return val;
        }
        if (val.sign == 0) {
            return this;
        }
        int[] aMag = this.sign > 0 ? this.magnitude : this.add((BigInteger)BigInteger.ONE).magnitude;
        int[] bMag = val.sign > 0 ? val.magnitude : val.add((BigInteger)BigInteger.ONE).magnitude;
        boolean resultNeg = this.sign < 0 && val.sign >= 0 || this.sign >= 0 && val.sign < 0;
        int resultLength = Math.max(aMag.length, bMag.length);
        int[] resultMag = new int[resultLength];
        int aStart = resultMag.length - aMag.length;
        int bStart = resultMag.length - bMag.length;
        for (int i = 0; i < resultMag.length; ++i) {
            int bWord;
            int aWord = i >= aStart ? aMag[i - aStart] : 0;
            int n = bWord = i >= bStart ? bMag[i - bStart] : 0;
            if (this.sign < 0) {
                aWord ^= 0xFFFFFFFF;
            }
            if (val.sign < 0) {
                bWord ^= 0xFFFFFFFF;
            }
            resultMag[i] = aWord ^ bWord;
            if (!resultNeg) continue;
            resultMag[i] = ~resultMag[i];
        }
        BigInteger result = new BigInteger(1, resultMag);
        if (resultNeg) {
            result = result.not();
        }
        return result;
    }

    public BigInteger or(BigInteger value) {
        if (this.sign == 0) {
            return value;
        }
        if (value.sign == 0) {
            return this;
        }
        int[] aMag = this.sign > 0 ? this.magnitude : this.add((BigInteger)BigInteger.ONE).magnitude;
        int[] bMag = value.sign > 0 ? value.magnitude : value.add((BigInteger)BigInteger.ONE).magnitude;
        boolean resultNeg = this.sign < 0 || value.sign < 0;
        int resultLength = Math.max(aMag.length, bMag.length);
        int[] resultMag = new int[resultLength];
        int aStart = resultMag.length - aMag.length;
        int bStart = resultMag.length - bMag.length;
        for (int i = 0; i < resultMag.length; ++i) {
            int bWord;
            int aWord = i >= aStart ? aMag[i - aStart] : 0;
            int n = bWord = i >= bStart ? bMag[i - bStart] : 0;
            if (this.sign < 0) {
                aWord ^= 0xFFFFFFFF;
            }
            if (value.sign < 0) {
                bWord ^= 0xFFFFFFFF;
            }
            resultMag[i] = aWord | bWord;
            if (!resultNeg) continue;
            resultMag[i] = ~resultMag[i];
        }
        BigInteger result = new BigInteger(1, resultMag);
        if (resultNeg) {
            result = result.not();
        }
        return result;
    }

    public BigInteger setBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (this.testBit(n)) {
            return this;
        }
        if (this.sign > 0 && n < this.bitLength() - 1) {
            return this.flipExistingBit(n);
        }
        return this.or(ONE.shiftLeft(n));
    }

    public BigInteger clearBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (!this.testBit(n)) {
            return this;
        }
        if (this.sign > 0 && n < this.bitLength() - 1) {
            return this.flipExistingBit(n);
        }
        return this.andNot(ONE.shiftLeft(n));
    }

    public BigInteger flipBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (this.sign > 0 && n < this.bitLength() - 1) {
            return this.flipExistingBit(n);
        }
        return this.xor(ONE.shiftLeft(n));
    }

    private BigInteger flipExistingBit(int n) {
        int[] mag = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, mag, 0, mag.length);
        int n2 = mag.length - 1 - (n >>> 5);
        mag[n2] = mag[n2] ^ 1 << (n & 0x1F);
        return new BigInteger(this.sign, mag);
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int rdx) {
        if (this.magnitude == null) {
            return "null";
        }
        if (this.sign == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer();
        if (rdx == 16) {
            for (int i = 0; i < this.magnitude.length; ++i) {
                String h = "0000000" + Integer.toHexString(this.magnitude[i]);
                h = h.substring(h.length() - 8);
                sb.append(h);
            }
        } else if (rdx == 2) {
            sb.append('1');
            for (int i = this.bitLength() - 2; i >= 0; --i) {
                sb.append(this.testBit(i) ? (char)'1' : '0');
            }
        } else {
            Stack<String> S = new Stack<String>();
            BigInteger base = new BigInteger(Integer.toString(rdx, rdx), rdx);
            BigInteger u = this.abs();
            while (!u.equals(ZERO)) {
                BigInteger b = u.mod(base);
                if (b.equals(ZERO)) {
                    S.push("0");
                } else {
                    S.push(Integer.toString(b.magnitude[0], rdx));
                }
                u = u.divide(base);
            }
            while (!S.empty()) {
                sb.append((String)S.pop());
            }
        }
        String s = sb.toString();
        while (s.length() > 1 && s.charAt(0) == '0') {
            s = s.substring(1);
        }
        if (s.length() == 0) {
            s = "0";
        } else if (this.sign == -1) {
            s = "-" + s;
        }
        return s;
    }

    public static BigInteger valueOf(long val) {
        if (val == 0L) {
            return ZERO;
        }
        if (val < 0L) {
            if (val == Long.MIN_VALUE) {
                return BigInteger.valueOf(val ^ 0xFFFFFFFFFFFFFFFFL).not();
            }
            return BigInteger.valueOf(-val).negate();
        }
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)val;
            val >>= 8;
        }
        return new BigInteger(b);
    }

    public int getLowestSetBit() {
        int b;
        if (this.sign == 0) {
            return -1;
        }
        int w = this.magnitude.length;
        while (--w > 0 && this.magnitude[w] == 0) {
        }
        int word = this.magnitude[w];
        int n = (word & 0xFFFF) == 0 ? ((word & 0xFF0000) == 0 ? 7 : 15) : (b = (word & 0xFF) == 0 ? 23 : 31);
        while (b > 0 && word << b != Integer.MIN_VALUE) {
            --b;
        }
        return (this.magnitude.length - w) * 32 - (b + 1);
    }

    public boolean testBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Bit position must not be negative");
        }
        if (this.sign < 0) {
            return !this.not().testBit(n);
        }
        int wordNum = n / 32;
        if (wordNum >= this.magnitude.length) {
            return false;
        }
        int word = this.magnitude[this.magnitude.length - 1 - wordNum];
        return (word >> n % 32 & 1) > 0;
    }

    static {
        ZERO_MAGNITUDE = new int[0];
        ZERO = new BigInteger(0, ZERO_MAGNITUDE);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        THREE = BigInteger.valueOf(3L);
        BigInteger.ZERO.nBits = 0;
        BigInteger.ZERO.nBitLength = 0;
        BigInteger.ONE.nBits = 1;
        BigInteger.ONE.nBitLength = 1;
        BigInteger.TWO.nBits = 1;
        BigInteger.TWO.nBitLength = 2;
        primeProducts = new int[primeLists.length];
        for (int i = 0; i < primeLists.length; ++i) {
            int[] primeList = primeLists[i];
            int product = 1;
            for (int j = 0; j < primeList.length; ++j) {
                product *= primeList[j];
            }
            BigInteger.primeProducts[i] = product;
        }
        rndMask = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
        bitCounts = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    }
}

