/*
 * Decompiled with CFR 0.152.
 */
package com.pip.util;

import java.util.Hashtable;
import java.util.Vector;

public class SortHashtable {
    private Hashtable ht = new Hashtable();
    private Hashtable ht2 = new Hashtable();
    private HVector vecKeys = new HVector();
    private HVector vecValues = new HVector();
    private Object[] keys;
    private Object[] values;

    public synchronized void clear() {
        this.ht.clear();
        this.ht2.clear();
        this.vecKeys.removeAllElements();
        this.vecValues.removeAllElements();
        this.keys = null;
        this.values = null;
    }

    public synchronized void put(Object key, Object value) {
        this.remove(key);
        this.vecKeys.addElement(key);
        this.vecValues.addElement(value);
        this.ht2.put(key, new Integer(this.vecKeys.size() - 1));
        this.ht.put(key, value);
        this.keys = null;
        this.values = null;
    }

    public synchronized void remove(Object key) {
        Integer _index = (Integer)this.ht2.get(key);
        if (_index != null) {
            this.vecKeys.removeElementAt(_index);
            this.vecValues.removeElementAt(_index);
            this.ht.remove(key);
            this.ht2.remove(key);
            for (int i = _index.intValue(); i < this.vecKeys.size(); ++i) {
                this.ht2.put(this.vecKeys.elementAt(i), new Integer(i));
            }
        }
        this.keys = null;
        this.values = null;
    }

    public int index(Object key) {
        Integer _index = (Integer)this.ht2.get(key);
        if (_index != null) {
            return _index;
        }
        return -1;
    }

    public Object getKey(int index) {
        return this.vecKeys.elementAt(index);
    }

    public Object getValue(int index) {
        return this.vecValues.elementAt(index);
    }

    public int size() {
        return this.vecKeys.size();
    }

    public Object get(Object key) {
        return this.ht.get(key);
    }

    public Object[] keys() {
        if (this.keys == null) {
            this.keys = this.vecKeys.values();
        }
        return this.keys;
    }

    public Object[] values() {
        if (this.values == null) {
            this.values = this.vecValues.values();
        }
        return this.values;
    }

    private class HVector
    extends Vector {
        private HVector() {
        }

        public synchronized Object[] values() {
            Object[] values = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, values, 0, this.elementCount);
            return values;
        }
    }
}

