/*
 * Decompiled with CFR 0.152.
 */
package com.pip.ui;

import com.pip.common.Tool;
import com.pip.sanguo.GameWorld;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import java.io.IOException;
import java.util.Vector;

public class Quest {
    public static final int EVENT_MASK_CYCLE = 1;
    public static final int EVENT_MASK_POSITION = 2;
    public static final int EVENT_MASK_TOUCHNPC = 4;
    public static final int EVENT_MASK_DIE = 8;
    public static final int EVENT_MASK_CHAT = 16;
    public static final int EVENT_MASK_OPENUI = 32;
    public static final int EVENT_MASK_CLOSECHAT = 64;
    public static int eventMask;
    public static Vector quests;
    public static int touchNpcId;
    public static int touchNpcInstanceId;
    public int id;
    public int type;
    public byte state;
    public VM vm;
    protected int questEventMask;
    public int[] resultData = new int[3];
    public static final byte QUEST_STSATE_CAN_ACCEPT = 0;
    public static final byte QUEST_STATE_DOING = 1;
    public static final byte QUEST_STATE_CAN_FINISH = 2;
    public static final byte QUEST_STATE_REPEAT = 3;
    private static VM gameWorldVM;

    public Quest(int id, int type, byte[] etf) throws IOException {
        this.id = id;
        this.type = type;
        this.vm = new VM(this);
        this.vm.init(etf);
        this.vm.link();
        this.vm.execute(0);
    }

    public Quest(int id, int type) {
        this.id = id;
        this.type = type;
        this.vm = null;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public byte getState() {
        return this.state;
    }

    public static void updateQuestEtf(int id, byte[] etf) throws IOException {
        Quest quest = Quest.findQuest(id, true);
        if (quest != null) {
            quest.vm = new VM(quest);
            quest.vm.init(etf);
            quest.vm.link();
            quest.vm.execute(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void touchNpc(int npcId, int instanceId) {
        VM vm = VMGame.getVMGame("game_world").getVM();
        boolean isTouch = false;
        VM vM = vm;
        synchronized (vM) {
            isTouch = vm.callback("QuestTouchNpc", new int[]{npcId, instanceId}) == 1;
        }
        if (isTouch) {
            touchNpcId = npcId;
            touchNpcInstanceId = instanceId;
            Quest.setEventMask(4);
        }
    }

    public void setQuestEventMask(int mask) {
        this.questEventMask = mask;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String translateText(int questId, String str) {
        char[] arr = str.toCharArray();
        int count = arr.length;
        int state = 0;
        StringBuffer buf = new StringBuffer();
        StringBuffer retBuf = new StringBuffer();
        block7: for (int i = 0; i < count; ++i) {
            char ch = arr[i];
            switch (state) {
                case 0: {
                    if (ch == '$' && i < count - 1 && arr[i + 1] == '{') {
                        ++i;
                        state = 1;
                        buf.setLength(0);
                        continue block7;
                    }
                    if (ch == '<' && i < count - 1 && arr[i + 1] == 'n') {
                        ++i;
                        state = 100;
                        buf.setLength(0);
                        continue block7;
                    }
                    if (ch == '<' && i < count - 1 && arr[i + 1] == 'l') {
                        ++i;
                        state = 101;
                        buf.setLength(0);
                        continue block7;
                    }
                    if (ch == '<' && i < count - 1 && arr[i + 1] == 'm') {
                        ++i;
                        state = 102;
                        buf.setLength(0);
                        continue block7;
                    }
                    retBuf.append(ch);
                    continue block7;
                }
                case 1: {
                    String exprStr;
                    if (ch == '}') {
                        exprStr = buf.toString().trim();
                        if (exprStr.startsWith("v")) {
                            Quest quest = Quest.findQuest(questId, true);
                            if (quest == null) return null;
                            retBuf.append(quest.getVariableValue(Integer.parseInt(exprStr.substring(1))));
                        } else if (exprStr.startsWith("_")) {
                            if (exprStr.equals("_X")) {
                                retBuf.append(GameWorld.player.sprite.getX());
                            } else if (exprStr.equals("_Y")) {
                                retBuf.append(GameWorld.player.sprite.getY());
                            } else {
                                retBuf.append(Tool.getGlobalObject(exprStr));
                            }
                        } else if (exprStr.startsWith("GetItemCount(")) {
                            exprStr = exprStr.substring("GetItemCount(".length());
                            int pos = exprStr.indexOf(41);
                            exprStr = exprStr.substring(0, pos);
                            Quest quest = Quest.findQuest(questId, true);
                            if (quest == null) return null;
                            int itemCount = quest.syscall((short)16394, new int[]{Integer.parseInt(exprStr)});
                            retBuf.append(itemCount);
                        }
                        state = 0;
                        continue block7;
                    }
                    buf.append(ch);
                    continue block7;
                }
                case 100: {
                    String exprStr;
                    if (ch == '>') {
                        exprStr = buf.toString().trim();
                        if (exprStr.endsWith("</n")) {
                            exprStr = buf.toString().trim().substring(1, exprStr.length() - 3);
                            int firstComma = exprStr.indexOf(44);
                            int npcId = Integer.parseInt(exprStr.substring(0, firstComma));
                            retBuf.append("<cff0000>");
                            retBuf.append(exprStr.substring(firstComma + 1, exprStr.length()));
                            retBuf.append("</c>");
                            state = 0;
                            continue block7;
                        }
                        buf.append(ch);
                        continue block7;
                    }
                    buf.append(ch);
                    continue block7;
                }
                case 101: {
                    String exprStr;
                    if (ch == '>') {
                        exprStr = buf.toString().trim();
                        if (exprStr.endsWith("</l")) {
                            exprStr = buf.toString().trim().substring(1, exprStr.length() - 3);
                            int firstComma = exprStr.indexOf(44);
                            int SceneId = Integer.parseInt(exprStr.substring(0, firstComma));
                            retBuf.append("<cff0000>");
                            retBuf.append(exprStr.substring(firstComma + 1, exprStr.length()));
                            retBuf.append("</c>");
                            state = 0;
                            continue block7;
                        }
                        buf.append(ch);
                        continue block7;
                    }
                    buf.append(ch);
                    continue block7;
                }
                case 102: {
                    String exprStr;
                    if (ch == '>') {
                        exprStr = buf.toString().trim();
                        if (exprStr.endsWith("</m")) {
                            exprStr = buf.toString().trim().substring(1, exprStr.length() - 3);
                            retBuf.append("{#VarUIRes,43}");
                            retBuf.append("<i>");
                            retBuf.append(exprStr);
                            retBuf.append("</i>");
                            state = 0;
                            continue block7;
                        }
                        buf.append(ch);
                        continue block7;
                    }
                    buf.append(ch);
                }
            }
        }
        if (state != true) return retBuf.toString();
        retBuf.append("${");
        retBuf.append(buf.toString());
        return retBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTargetStatus(int index) {
        VM vM = this.vm;
        synchronized (vM) {
            return this.vm.callback("target" + index, new int[0]) == 1;
        }
    }

    public static void setVariableValue(int questId, int index, int newValue) {
        Quest quest = Quest.findQuest(questId, true);
        quest.vm.memSave(index, newValue);
    }

    public int getVariableValue(int index) {
        return this.vm.memLoad(index);
    }

    public static Quest addQuest(int id, int type, int startNpcId, int endNpcId, byte[] etf) throws IOException {
        Quest.removeQuest(id, startNpcId, endNpcId);
        Quest quest = new Quest(id, type, etf);
        quests.addElement(quest);
        return quest;
    }

    public static Quest addQuest(int id, int type, int startNpcId, int endNpcId) {
        Quest.removeQuest(id, startNpcId, endNpcId);
        Quest quest = new Quest(id, type);
        quests.addElement(quest);
        return quest;
    }

    public static void removeQuest(int id, int startNpcId, int endNpcId) {
        int size = quests.size();
        for (int i = 0; i < size; ++i) {
            Quest quest = (Quest)quests.elementAt(i);
            if (quest.id != id) continue;
            quests.removeElementAt(i);
            break;
        }
    }

    public static void clearSceneQuests() {
        int size = quests.size();
        for (int i = 0; i < size; ++i) {
            Quest quest = (Quest)quests.elementAt(i);
            if (quest.type != 1) continue;
            quests.removeElementAt(i);
            --i;
            --size;
            break;
        }
    }

    public static void clear() {
        quests.removeAllElements();
        touchNpcId = -1;
    }

    public static Quest findQuest(int id, boolean includeCanAccept) {
        int size = quests.size();
        for (int i = 0; i < size; ++i) {
            Quest quest = (Quest)quests.elementAt(i);
            if (quest.id != id || !includeCanAccept && quest.state == 0) continue;
            return quest;
        }
        return null;
    }

    public static void setEventMask(int mask) {
        eventMask |= mask;
    }

    public static void cycle() {
        int size = quests.size();
        for (int i = 0; i < size; ++i) {
            Quest quest = (Quest)quests.elementAt(i);
            if (quest.state == 0 || (quest.questEventMask & eventMask) == 0) continue;
            quest.vm.execute(1);
        }
        eventMask = 1;
        touchNpcId = -1;
    }

    public static void setGameWorldVM(VM gwv) {
        gameWorldVM = gwv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syscall(short funcID, int[] params) {
        switch (funcID) {
            case 16385: {
                return Quest.findQuest(params[0], false) != null ? 1 : 0;
            }
            case 16386: {
                return this.state == 2 ? 1 : 0;
            }
            case 16387: {
                VM vM = gameWorldVM;
                synchronized (vM) {
                    gameWorldVM.callback("QuestChat", new int[]{gameWorldVM.makeTempObject(this), params[0], gameWorldVM.makeTempObject(this.getText(params[1])), params[2], touchNpcInstanceId});
                    break;
                }
            }
            case 16388: {
                VM vM = gameWorldVM;
                synchronized (vM) {
                    gameWorldVM.callback("QuestMessage", new int[]{gameWorldVM.makeTempObject(this), gameWorldVM.makeTempObject(this.getText(params[0])), params[1], params[2]});
                    break;
                }
            }
            case 16389: {
                VM vM = gameWorldVM;
                synchronized (vM) {
                    gameWorldVM.callback("QuestQuestion", new int[]{gameWorldVM.makeTempObject(this), gameWorldVM.makeTempObject(this.getText(params[0])), gameWorldVM.makeTempObject(this.getText(params[1])), params[2]});
                    break;
                }
            }
            case 16391: {
                GameWorld.instance.sendCommand(14030, new int[]{16391, params[0]});
                break;
            }
            case 16392: {
                GameWorld.instance.sendCommand(14030, new int[]{16392, params[0], params[1], params[2]});
                break;
            }
            case 16393: {
                GameWorld.instance.sendCommand(14030, new int[]{16393});
                break;
            }
            case 16394: {
                VM vm;
                VM vM = vm = VMGame.getVMGame("game_role").getVM();
                synchronized (vM) {
                    return vm.callback("QuestGetItemCount", new int[]{params[0]});
                }
            }
            case 16395: {
                VM vm;
                VM vM = vm = VMGame.getVMGame("game_role").getVM();
                synchronized (vM) {
                    int count = vm.callback("QuestGetItemCount", new int[]{params[0]});
                    return count >= params[1] ? 1 : 0;
                }
            }
            case 16396: {
                if (GameWorld.currentMap == null || GameWorld.player == null) break;
                if (GameWorld.currentMap.id == params[0] && Math.abs(GameWorld.player.sprite.getX() - params[1]) <= 80 && Math.abs(GameWorld.player.sprite.getY() - params[2]) <= 80) {
                    return 1;
                }
                return 0;
            }
            case 16397: {
                if (GameWorld.currentMap != null && GameWorld.currentMap.id == params[0]) {
                    return 1;
                }
                return 0;
            }
            case 16398: {
                if (touchNpcId == params[0]) {
                    return 1;
                }
                return 0;
            }
            case 16402: {
                if (VMGame.getVMGame((String)this.vm.followPointer(params[0])) != null) {
                    return 1;
                }
                return 0;
            }
            case 16403: {
                if (this.resultData[1] == params[0] && this.resultData[2] == params[1]) {
                    return 1;
                }
                return 0;
            }
            case 16404: {
                System.out.println("Quest E_CloseChat : " + params[0]);
                if (this.resultData[1] == params[0]) {
                    return 1;
                }
                return 0;
            }
            case 16405: {
                System.out.println("Quest E_CloseMessage : " + params[0]);
                if (this.resultData[1] == params[0]) {
                    return 1;
                }
                return 0;
            }
            case 16406: {
                this.setQuestEventMask(params[0]);
                break;
            }
            case 16407: {
                return eventMask;
            }
        }
        return 0;
    }

    public String getText(int vmData) {
        return Quest.translateText(this.id, (String)this.vm.followPointer(vmData));
    }

    public Integer getInt(int vmData) {
        return new Integer(vmData);
    }

    public void eventClosed(Object result) {
        int[] uiResult = (int[])result;
        System.arraycopy(uiResult, 0, this.resultData, 0, uiResult.length);
        Quest.setEventMask(64);
        Tool.sendNotifyServer(this.id, this.resultData[1], this.resultData[0], this.resultData[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean interact(int npcId) {
        VM vM = this.vm;
        synchronized (vM) {
            return this.vm.callback("interact", new int[]{npcId}) != 0;
        }
    }

    static {
        quests = new Vector();
        touchNpcId = -1;
        touchNpcInstanceId = -1;
    }
}

