/*
 * Decompiled with CFR 0.152.
 */
package com.pip.sanguo;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.engine.AnimateCache;
import com.pip.engine.GameMap;
import com.pip.engine.GamePackage;
import com.pip.engine.IVMGameProcessor;
import com.pip.io.UASegment;
import com.pip.resource.ResourceAsynLoader;
import com.pip.sanguo.GameExit;
import com.pip.sanguo.GameIcon;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameNetPlayer;
import com.pip.sanguo.GameNpc;
import com.pip.sanguo.GamePanel;
import com.pip.sanguo.GameRole;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameView;
import com.pip.ui.Quest;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import com.pip.util.SortHashtable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameWorld
implements IVMGameProcessor {
    public static GameWorld instance;
    public static GamePanel panel;
    public static byte[] pkgData;
    public static SortHashtable teamInfo;
    public static boolean inLoading;
    public static boolean netplayerNameNearShow;
    private Hashtable gameData = new Hashtable();
    public static Vector moveSegments;
    public VM vm;
    public static Hashtable gameIcons;
    public static Vector gameExits;
    public static Vector gameSprites;
    public static Vector waitRemoveSprites;
    public static Vector leavingSprites;
    public static Hashtable gameSpriteTable;
    public static Hashtable gameSpriteTable2;
    public static int[][] mapCollisionBox;
    public static GamePackage gamePackage;
    public static GameMap currentMap;
    public static int currentAreaId;
    public static GameView gameView;
    public static int playerNextMap;
    public static int playerNextMapInstanceId;
    public static int playerNextX;
    public static int playerNextY;
    public static int viewX;
    public static int viewY;
    public static GameRole player;

    public GameIcon vm_create_icon(int _type, int _id, int _animateIndex) {
        GameSprite father = (GameSprite)gameSpriteTable.get(Tool.getSpriteKey(_type, _id));
        if (father != null) {
            GameIcon icon = GameIcon.createGameIcon(father, _animateIndex);
            if (icon != null) {
                gameIcons.put(new Integer(icon.getId()), icon);
            }
            return icon;
        }
        return null;
    }

    public void vm_close_event(Quest _questProcessor, int[] _data) {
        _questProcessor.eventClosed(_data);
    }

    public GameIcon vm_create_icon2(GameSprite _processor, int _animateIndex) {
        if (_processor != null) {
            GameIcon icon = GameIcon.createGameIcon(_processor, _animateIndex);
            if (icon != null) {
                gameIcons.put(new Integer(icon.getId()), icon);
            }
            return icon;
        }
        return null;
    }

    public void vm_world_show_map_npc_animate(boolean show) {
        GameView.showMapNpcAnimate = show;
        if (gameView != null) {
            GameWorld.gameView.isFirstBgImage = true;
        }
    }

    public void vm_world_set_3dstring_level(int level) {
        GameMain.draw3DStringLevel = level;
    }

    public void vm_world_set_mini_map_config(UASegment _seg) {
        _seg.flush();
        _seg.reset();
        GameView.initMiniMapConfig(_seg);
    }

    public void vm_game_set_mini_map_show(boolean show) {
        GameView.miniMapShow = show;
    }

    public void vm_game_set_mini_map_alpha(int alpha) {
        GameView.miniMapConfig[0] = alpha;
        if (gameView != null) {
            gameView.rebuildMiniMap();
        }
    }

    public Vector vm_game_get_netplayer_list() {
        Vector<GameSprite> ret = new Vector<GameSprite>();
        for (int i = 0; i < gameSprites.size(); ++i) {
            GameSprite gs = (GameSprite)gameSprites.elementAt(i);
            if (gs.getType() != 1) continue;
            ret.addElement(gs);
        }
        return ret;
    }

    public int vm_world_get_target_distance() {
        if (GameWorld.player.target == null) {
            return -1;
        }
        int x1 = GameWorld.player.sprite.getX();
        int y1 = GameWorld.player.sprite.getY();
        int x2 = GameWorld.player.target.sprite.getX();
        int y2 = GameWorld.player.target.sprite.getY();
        int distance = Math.abs(Tool.distance(x1, y1, x2, y2));
        return distance;
    }

    public void vm_game_to_map(int _mapId, int _mapInstanceId, int _x, int _y) {
        GameWorld.goMap(_mapId, _mapInstanceId, _x, _y);
    }

    public void vm_game_add_follower(int _ownerInstanceId, int _followerInstanceId) {
        GameSprite owner = GameWorld.getSprite(_ownerInstanceId);
        GameSprite follower = GameWorld.getSprite(_followerInstanceId);
        if (owner != null && follower != null) {
            owner.addFollower(follower);
        }
    }

    public void vm_game_del_follower() {
        GameSprite owner = GameWorld.player.followOwner;
        if (owner != null) {
            owner.removeFollower(player);
        }
    }

    public boolean vm_world_get_target_can_attack() {
        return GameWorld.player.target != null && GameWorld.player.target.canAttack;
    }

    public Vector vm_game_get_gamesprite_list() {
        return gameSprites;
    }

    public int vm_game_get_map_id() {
        if (currentMap != null) {
            return GameWorld.currentMap.id;
        }
        return -1;
    }

    public void vm_game_do_touch_npc(GameSprite _processor) {
        Quest.touchNpc(_processor.getId(), _processor.getInstanceId());
    }

    public void vm_request_destroy_sprite(GameSprite _sprite) {
        GameWorld.requestDestorySprite(_sprite);
    }

    public String vm_game_current_landmark_name() {
        String landName;
        if (currentMap != null) {
            landName = GameWorld.currentMap.name;
            int extraIdx = landName.indexOf(124);
            if (extraIdx >= 0) {
                landName = landName.substring(0, extraIdx);
            }
        } else {
            landName = "";
        }
        return landName;
    }

    public int vm_game_get_hmsg_count() {
        if (panel != null) {
            Vector _hmsgs = (Vector)GameWorld.panel.hMessageItem.objData;
            if (_hmsgs == null) {
                return 0;
            }
            return _hmsgs.size();
        }
        return 0;
    }

    public int vm_game_get_vmsg_count() {
        if (panel != null) {
            Vector _vmsgs = (Vector)GameWorld.panel.vMessageItem.objData;
            if (_vmsgs == null) {
                return 0;
            }
            return _vmsgs.size();
        }
        return 0;
    }

    public int vm_game_get_dis(GameSprite _gameSprite1, GameSprite _gameSprite2) {
        if (_gameSprite1 != null && _gameSprite2 != null) {
            int x1 = _gameSprite1.sprite.getX();
            int y1 = _gameSprite1.sprite.getY();
            int x2 = _gameSprite2.sprite.getX();
            int y2 = _gameSprite2.sprite.getY();
            return Math.abs(Tool.distance(x1, y1, x2, y2));
        }
        return -1;
    }

    public void vm_game_do_destroy_sprite(int _id, int _instanceId, boolean testLeaving) {
        GameWorld.doDestorySprite(GameWorld.getSprite(_instanceId), testLeaving, false);
    }

    public void vm_world_set_in_loading(boolean _inLoading) {
        inLoading = _inLoading;
    }

    public void vm_world_set_netplayer_name_near_show(boolean _nearShow) {
        netplayerNameNearShow = _nearShow;
    }

    public int[] vm_game_get_mini_map_size() {
        int[] minisize = null;
        minisize = gameView != null ? gameView.getMiniMapSize() : new int[]{0, 0};
        return minisize;
    }

    public boolean vm_world_get_is_team_member(int _instanceId) {
        return teamInfo.get(new Integer(_instanceId)) != null;
    }

    public int vm_game_add_quest_etf(int _questId, int _type, int _startNpcId, int _endNpcId, byte[] _etf) {
        try {
            Quest.addQuest(_questId, _type, _startNpcId, _endNpcId, _etf);
            return 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void vm_game_add_quest(int _questId, int _type, int _startNpcId, int _endNpcId) {
        Quest.addQuest(_questId, _type, _startNpcId, _endNpcId);
    }

    public void vm_game_remove_quest(int _questId, int _startNpcId, int _endNpcId) {
        Quest.removeQuest(_questId, _startNpcId, _endNpcId);
    }

    public int vm_game_update_quest_etf(int _questId, byte[] _etf) {
        try {
            Quest.updateQuestEtf(_questId, _etf);
            return 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void vm_game_set_quest_var(int _questId, int _index, int _var) {
        Quest.setVariableValue(_questId, _index, _var);
    }

    public String vm_game_translate_text(int _questId, String _text) {
        return Quest.translateText(_questId, _text);
    }

    public void vm_game_set_quest_state(int _questId, int _state) {
        Quest quest = Quest.findQuest(_questId, true);
        if (quest != null) {
            quest.setState((byte)_state);
        }
    }

    public int vm_game_get_quest_state(int _questId) {
        Quest quest = Quest.findQuest(_questId, true);
        if (quest != null) {
            return quest.getState();
        }
        return -1;
    }

    public void vm_game_clear_scene_quests() {
        Quest.clearSceneQuests();
    }

    public static Object vm_game_vm_callback(int msgId, Object msg, String vmids, String funcName) {
        return GameWorld.vm_game_vm_callback2(msgId, msg, Tool.splitString(vmids), funcName);
    }

    public static Object vm_game_vm_callback2(int msgId, Object msg, String[] vmids, String funcName) {
        int count = vmids.length;
        for (int i = 0; i < count; ++i) {
            VMGame vg = VMGame.getVMGame(vmids[i]);
            if (vg == null) continue;
            vg.callback(funcName, new Object[]{new Integer(msgId), msg});
        }
        return null;
    }

    public int[] vm_game_build_random_pos_list(int orgX, int orgY, int minOffset, int maxOffset, int count) {
        int[] result = new int[count * 2];
        int s = maxOffset - minOffset;
        for (int i = 0; i < count; ++i) {
            result[i << 1] = Tool.getNextRnd(0, s) + minOffset + orgX;
            result[(i << 1) + 1] = Tool.getNextRnd(0, s) + minOffset + orgY;
        }
        return result;
    }

    public boolean vm_world_in_game_screen() {
        return VMGame.isAllTransparent(true) && gameView != null && player != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendCommand(int command, Object commandData) {
        VM vM = this.vm;
        synchronized (vM) {
            int[] params = new int[]{this.vm.makeTempObject(this), command, this.vm.makeTempObject(commandData)};
            this.vm.callback("GameCommand", params);
        }
    }

    public Object readGameData(String dataName) {
        return this.gameData.get(dataName);
    }

    public void removeGameData(String dataName) {
        this.gameData.remove(dataName);
    }

    public void saveGameData(String dataName, Object data) {
        this.gameData.put(dataName, data);
    }

    public static void clear() {
        teamInfo = null;
        gamePackage = null;
        currentAreaId = -1;
        currentMap = null;
        gameView = null;
        player = null;
        gameSpriteTable.clear();
        gameSpriteTable2.clear();
        gameSprites.removeAllElements();
        gameIcons.clear();
        gameExits.removeAllElements();
        Tool.unitViewCache.clear();
        instance = null;
    }

    public static void moveMap() {
        if (player == null || currentMap == null) {
            return;
        }
        viewX = (short)(GameWorld.player.sprite.getX() - GameMain.viewWidth / 2);
        viewY = (short)(GameWorld.player.sprite.getY() - GameMain.viewHeight / 2);
        if (viewX < 0) {
            viewX = 0;
        }
        if (viewY < 0) {
            viewY = 0;
        }
        short viewMaxX = (short)(GameWorld.currentMap.width - GameMain.viewWidth & 0xFFFF);
        short viewMaxY = (short)(GameWorld.currentMap.height - GameMain.viewHeight & 0xFFFF);
        if (viewX > viewMaxX) {
            viewX = viewMaxX;
        }
        if (viewY > viewMaxY) {
            viewY = viewMaxY;
        }
        if (viewMaxX < 0) {
            viewX = (short)(viewMaxX >> 1);
        }
        if (viewMaxY < 0) {
            viewY = (short)(viewMaxY >> 1);
        }
    }

    public GameWorld() {
        instance = this;
        VMGame.loadVMGame("game_world", (byte)0, true);
        this.vm = VMGame.getVMGame("game_world").getVM();
        Quest.setGameWorldVM(this.vm);
        panel = new GamePanel();
        panel.init();
    }

    public void draw(Graphics g, int low, int high) throws Exception {
        if (gameView != null) {
            gameView.draw(g, viewX, viewY);
            panel.draw(g, low, high);
        }
    }

    public void cycle() {
        GameSprite gs;
        int i;
        GameWorld.checkAndRemoveSprite();
        if (GameMain.tick % 10 == 0) {
            GameWorld.orderNetPlayer();
        }
        if (gameView != null) {
            gameView.cycle(viewX, viewY);
        }
        for (int i2 = 0; i2 < gameSprites.size(); ++i2) {
            GameSprite gs2 = (GameSprite)gameSprites.elementAt(i2);
            gs2.cycle();
        }
        Enumeration emu = gameIcons.elements();
        while (emu.hasMoreElements()) {
            ((GameIcon)emu.nextElement()).cycle();
        }
        for (i = 0; i < gameExits.size(); ++i) {
            gs = (GameExit)gameExits.elementAt(i);
            ((GameExit)gs).cycle();
        }
        for (i = 0; i < leavingSprites.size(); ++i) {
            gs = (GameSprite)leavingSprites.elementAt(i);
            gs.cycle();
            if (gs.chaseMode) continue;
            gs.destroy();
            leavingSprites.removeElementAt(i);
            --i;
        }
        Quest.cycle();
        panel.cycle();
    }

    public void processPacket() {
        UASegment segment = GameMain.instance.nextPacket;
        switch (segment.type) {
            case -1: {
                int s = segment.readInt();
                short t = segment.readShort();
                String msg = segment.readString();
                System.out.println("Unhandled Error found by GameWorld java: " + msg);
                break;
            }
            case 104: {
                segment.reset();
                System.out.println("length=" + segment.data.length);
                for (int i = 0; i < segment.data.length; ++i) {
                    System.out.print("0x" + Integer.toHexString(segment.data[i] & 0xFF));
                    System.out.print(",");
                }
                System.out.println();
                break;
            }
            case 114: {
                Tool.recvLogout(segment);
                break;
            }
            case 115: {
                Tool.recvInvisible(segment);
                break;
            }
            case 186: {
                Tool.recvAttack(segment, false);
                break;
            }
            case 297: {
                Tool.recvAttack(segment, true);
                break;
            }
            case 187: {
                Tool.recvAttacked(segment);
                break;
            }
            case 136: {
                Tool.recvAttackFail(segment);
                break;
            }
            case 134: {
                Tool.recvAllowGomap(segment);
                break;
            }
            case 2382: {
                ResourceAsynLoader.segments.addElement(segment);
                break;
            }
            case 193: 
            case 194: 
            case 195: {
                moveSegments.addElement(segment);
                break;
            }
            case 189: {
                GameMain.resourceManager.recvSyncVersion(segment);
                break;
            }
            case 190: {
                GameMain.resourceManager.syncVersion(true);
                break;
            }
            case 336: {
                Tool.recvChaseServer(segment);
                break;
            }
        }
    }

    public static int collisionWorld(int x, int y, int w, int h, int direct, int step, int oldX, int oldY) {
        int result = step;
        int[] mapBox = GameWorld.getWorldCollisionBox(direct);
        if (mapBox != null) {
            if (Tool.calculateDistance(mapBox[0], mapBox[1], mapBox[2], mapBox[3], x, y, w, h, direct) <= 0) {
                result = Tool.calculateDistance(mapBox[0], mapBox[1], mapBox[2], mapBox[3], oldX, oldY, w, h, direct);
            }
        } else {
            result = 0;
        }
        if (result > step) {
            result = step;
        } else if (result < 0) {
            result = 0;
        }
        result = gameView.collisionMap(x, y, w, h, direct, step, oldX, oldY, result);
        result = gameView.collisionYOrder(x, y, w, h, direct, step, oldX, oldY, result);
        return result;
    }

    private static int[] getWorldCollisionBox(int direct) {
        int[] result = null;
        if (mapCollisionBox == null) {
            mapCollisionBox = new int[4][];
            GameWorld.mapCollisionBox[0] = new int[]{-536870912, GameWorld.currentMap.height - 1, 0x1FFFFFFF, 0x1FFFFFFF};
            GameWorld.mapCollisionBox[2] = new int[]{-536870912, -536870912, 0, 0x1FFFFFFF};
            GameWorld.mapCollisionBox[1] = new int[]{GameWorld.currentMap.width - 1, -536870912, 0x1FFFFFFF, 0x1FFFFFFF};
            GameWorld.mapCollisionBox[3] = new int[]{-536870912, -536870912, 0x1FFFFFFF, 0};
            for (int i = 0; i < mapCollisionBox.length; ++i) {
                GameWorld.mapCollisionBox[i][2] = mapCollisionBox[i][2] - mapCollisionBox[i][0];
                GameWorld.mapCollisionBox[i][3] = mapCollisionBox[i][3] - mapCollisionBox[i][1];
            }
        }
        switch (direct) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                result = mapCollisionBox[direct];
            }
        }
        return result;
    }

    public static void clearGameSprites() {
        int i;
        Vector<GameSprite> needRemove = new Vector<GameSprite>();
        for (i = 0; i < gameSprites.size(); ++i) {
            GameSprite gameSprite = (GameSprite)gameSprites.elementAt(i);
            byte type = gameSprite.getType();
            int id = gameSprite.getId();
            if (type == 1) {
                if (((GameNetPlayer)gameSprite).noNeedRemove) {
                    gameSprite.isOutView = true;
                    continue;
                }
                needRemove.addElement(gameSprite);
                continue;
            }
            if (type != 3 && type != 5 || currentMap == null || GameWorld.currentMap.id != id >> 12) continue;
            needRemove.addElement(gameSprite);
        }
        for (i = 0; i < needRemove.size(); ++i) {
            GameWorld.doDestorySprite((GameSprite)needRemove.elementAt(i), false, false);
        }
        gameExits.removeAllElements();
        gameIcons.clear();
        player.clearTarget();
    }

    public static GameNpc findNpcById(byte type, int id) {
        return (GameNpc)GameWorld.getSprite(type, id);
    }

    public static GameNetPlayer findPlayerById(int id) {
        return (GameNetPlayer)GameWorld.getSprite(1, id);
    }

    public static GameNpc findNpcByInstanceId(int instanceId) {
        return (GameNpc)GameWorld.getSprite(instanceId);
    }

    public static GameNetPlayer findPlayerByInstanceId(int instanceId) {
        return (GameNetPlayer)GameWorld.getSprite(instanceId);
    }

    public static void playerLogout(int instanceId) {
        GameNetPlayer np = (GameNetPlayer)GameWorld.getSprite(instanceId);
        if (np != null) {
            GameWorld.requestDestorySprite(np);
        }
    }

    public static GameSprite getSprite(int type, int id) {
        return (GameSprite)gameSpriteTable.get(Tool.getSpriteKey(type, id));
    }

    public static GameSprite getSprite(int instanceId) {
        return (GameSprite)gameSpriteTable2.get(new Integer(instanceId));
    }

    public static void requestDestorySprite(GameSprite gameSprite) {
        if (gameSprite == null) {
            return;
        }
        waitRemoveSprites.addElement(gameSprite);
    }

    public static void doDestorySprite(GameSprite gameSprite, boolean testLeaving, boolean isWaitingRemove) {
        if (gameSprite == null) {
            return;
        }
        if (gameSprite.followOwner != null) {
            gameSprite.followOwner.removeFollower(gameSprite);
        }
        gameSprite.removeAllFollowers();
        if (isWaitingRemove) {
            int count = gameSprites.size();
            boolean shouldDel = true;
            boolean isBreak = false;
            block0: for (int i = 0; i < count && !isBreak; ++i) {
                GameSprite gs1 = (GameSprite)gameSprites.elementAt(i);
                for (int j = i + 1; j < count; ++j) {
                    GameSprite gs2 = (GameSprite)gameSprites.elementAt(j);
                    if (gs1.getType() != gs2.getType() || gs1.getId() != gs2.getId()) continue;
                    shouldDel = false;
                    isBreak = true;
                    continue block0;
                }
            }
            if (shouldDel) {
                gameSpriteTable.remove(Tool.getSpriteKey(gameSprite.getType(), gameSprite.getId()));
            }
        } else {
            gameSpriteTable.remove(Tool.getSpriteKey(gameSprite.getType(), gameSprite.getId()));
        }
        gameSprites.removeElement(gameSprite);
        gameSpriteTable2.remove(new Integer(gameSprite.getInstanceId()));
        if (GameWorld.player.target == gameSprite) {
            player.clearTarget();
        }
        gameSprite.destroy();
    }

    public static void orderNetPlayer() {
        GameSprite g1 = null;
        GameSprite g2 = null;
        GameNetPlayer n1 = null;
        GameNetPlayer n2 = null;
        for (int i = 0; i < gameSprites.size() - 1; ++i) {
            g1 = (GameSprite)gameSprites.elementAt(i);
            n1 = null;
            if (g1.getType() != 1) continue;
            n1 = (GameNetPlayer)g1;
            for (int j = i + 1; j < gameSprites.size(); ++j) {
                g2 = (GameSprite)gameSprites.elementAt(j);
                if (g2.getType() != 1) continue;
                n2 = (GameNetPlayer)g2;
                if (n2.lastSyncMoveTime <= n1.lastSyncMoveTime) continue;
                gameSprites.setElementAt(n2, i);
                gameSprites.setElementAt(n1, j);
                n1 = n2;
            }
        }
    }

    public static void checkAndRemoveSprite() {
        int i;
        int count = waitRemoveSprites.size();
        Vector<GameSprite> canRemove = new Vector<GameSprite>();
        Vector<GameSprite> restSprite = new Vector<GameSprite>();
        for (i = 0; i < count; ++i) {
            GameSprite gameSprite = (GameSprite)waitRemoveSprites.elementAt(i);
            if (gameSprite.canRemoved()) {
                canRemove.addElement(gameSprite);
                continue;
            }
            restSprite.addElement(gameSprite);
        }
        count = canRemove.size();
        for (i = 0; i < count; ++i) {
            GameWorld.doDestorySprite((GameSprite)canRemove.elementAt(i), false, true);
        }
        waitRemoveSprites = restSprite;
    }

    public static void addSprite(GameSprite gameSprite) {
        gameSprites.addElement(gameSprite);
        gameSpriteTable.put(Tool.getSpriteKey(gameSprite.getType(), gameSprite.getId()), gameSprite);
        gameSpriteTable2.put(new Integer(gameSprite.getInstanceId()), gameSprite);
    }

    public static void BroadcastPacket(UASegment segment) {
        segment.flush();
        segment.reset();
        segment.handled = false;
        Utilities.segments.addElement(segment);
    }

    public static void loadMap() {
        try {
            gameView = null;
            GameWorld.clearGameSprites();
            if (GameMain.animateCacheType == 1) {
                AnimateCache.clearPendingReleaseAnimate();
            }
            currentMap = gamePackage.loadMap(playerNextMap & 0xF);
            gameView = new GameView(currentMap);
            gamePackage = null;
            GameWorld.currentMap.owner = null;
            player.clearChase();
            GameWorld.player.sprite.setMapId(GameWorld.currentMap.id);
            GameWorld.player.sprite.setMapInstanceId(playerNextMapInstanceId);
            player.clearTarget();
            GameWorld.player.sprite.setPosition(playerNextX, playerNextY);
            mapCollisionBox = null;
            GameWorld.panel.state = 1;
            GameWorld.vm_game_vm_callback(20, null, "game_panel", "GameNotify");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void goMap(int nextMap, int nextMapInstanceId, int nextX, int nextY) {
        playerNextMap = nextMap;
        playerNextMapInstanceId = nextMapInstanceId;
        playerNextX = nextX;
        playerNextY = nextY;
    }

    static {
        pkgData = null;
        inLoading = false;
        netplayerNameNearShow = true;
        moveSegments = new Vector();
        gameIcons = new Hashtable();
        gameExits = new Vector();
        gameSprites = new Vector();
        waitRemoveSprites = new Vector();
        leavingSprites = new Vector();
        gameSpriteTable = new Hashtable();
        gameSpriteTable2 = new Hashtable();
        mapCollisionBox = null;
        currentAreaId = -1;
        playerNextMapInstanceId = -1;
    }
}

