/*
 * Decompiled with CFR 0.152.
 */
package com.pip.sanguo;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.io.UASegment;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameWorld;
import com.pip.ui.Quest;
import com.pip.ui.VMGame;
import javax.microedition.lcdui.Graphics;

public class GameRole
extends GameSprite {
    private int lastPostionTime;
    public GameSprite target;
    public boolean autoSelect;
    public boolean battleMode;
    public boolean needSendStop;
    public boolean afterChangeTargetHasMoved;
    public int positionLimit;
    private int lastX;
    private int lastY;
    private int pointMoveDir = -1;
    public final boolean LAYOUT_2468_YES;
    public final boolean LAYOUT_2468_NO;
    private boolean layout2468 = false;
    private boolean dirKeyValid = true;
    private boolean fireKeyValid = true;
    public static int enemyNpcAutoDist = 32;
    public static int allyNpcAutoDist = 16;
    public static int enemyPlayerAutoDist = 0;
    public static int allyPlayerAutoDist = 0;
    public static int teamerAutoDist = 0;
    public static int enemyNpcForceDist = 40;
    public static int allyNpcForceDist = 16;
    public static int enemyPlayerForceDist = 120;
    public static int allyPlayerForceDist = 0;
    public static int teamerForceDist = 0;
    public static final int SELECT_TYPE_ALL = 0;
    public static final int SELECT_TYPE_PK = 1;
    public static final String VAR_SELECT_MODE = "varSelectMode";
    public static final String VAR_WHO_LAST_ATTACKED_ME = "varLastAttacker";

    private GameRole(int type, int id) {
        super(type, id, id);
        this.LAYOUT_2468_YES = true;
        this.LAYOUT_2468_NO = false;
    }

    public static GameRole createRole(int id, String name) {
        GameRole gameRole = new GameRole(0, id);
        gameRole.setName(name);
        gameRole.vm = VMGame.getVMGame("game_role").getVM();
        gameRole.sendCommand(10005, new Integer(id));
        gameRole.sendCommand(10010, null);
        gameRole.autoSelect = true;
        gameRole.infoRecved = true;
        gameRole.positionLimit = GameMain.positionLimit;
        GameMain.resourceManager.currentUpdateTable.clear();
        return gameRole;
    }

    public void vm_role_test_and_change_target(int enemyInstanceId) {
        GameSprite enemySprite = GameWorld.getSprite(enemyInstanceId);
        if (!(enemySprite == null || enemySprite == this || this.target != null && this.target.canAttack)) {
            this.changeTarget(enemySprite);
            this.autoSelect = false;
        }
    }

    public static boolean isCivilPlayer(GameSprite sp) {
        return GameWorld.player.faction == sp.faction && sp.getType() == 1 && !sp.canAttack;
    }

    public static boolean isSelectAllMode() {
        return Tool.getGlobalInt(VAR_SELECT_MODE) == 0;
    }

    private void searchNextTarget() {
        this.autoSelect = false;
        if (GameWorld.gameView != null) {
            if (this.afterChangeTargetHasMoved) {
                GameSprite nearTarget = GameWorld.gameView.findNearTarget(false);
                if (nearTarget != this.target) {
                    this.changeTarget(nearTarget);
                } else {
                    this.changeTarget(GameWorld.gameView.findNextTarget(this.target));
                }
            } else {
                this.changeTarget(GameWorld.gameView.findNextTarget(this.target));
            }
        } else {
            this.changeTarget(null);
        }
        this.afterChangeTargetHasMoved = false;
    }

    public void searchNearestNpc() {
        this.autoSelect = false;
        if (GameWorld.gameView != null) {
            GameSprite nearTarget = GameWorld.gameView.findNearNPC();
            if (nearTarget != null) {
                this.changeTarget(nearTarget);
            } else {
                this.changeTarget(GameWorld.gameView.findNextTarget(this.target));
            }
        } else {
            this.changeTarget(null);
        }
        this.afterChangeTargetHasMoved = false;
    }

    public GameSprite selectNearestCreature() {
        this.autoSelect = false;
        this.afterChangeTargetHasMoved = false;
        GameSprite nearTarget = null;
        if (GameWorld.gameView != null) {
            nearTarget = GameWorld.gameView.findNearCreature();
            if (nearTarget != null) {
                this.changeTarget(nearTarget);
            }
        } else {
            this.changeTarget(null);
        }
        return nearTarget;
    }

    public void vm_role_change_target() {
        if (GameRole.isSelectAllMode()) {
            this.searchNextTarget();
        } else {
            int lastAttackedMeInstId = Tool.getGlobalInt(VAR_WHO_LAST_ATTACKED_ME);
            if (lastAttackedMeInstId != 0) {
                Tool.deleteGlobalVar(VAR_WHO_LAST_ATTACKED_ME);
                this.vm_role_test_and_change_target(lastAttackedMeInstId);
            } else {
                this.searchNextTarget();
            }
        }
    }

    public void vm_role_set_auto_select(boolean _autoSelect) {
        this.autoSelect = _autoSelect;
    }

    public int vm_role_get_target_type() {
        if (this.target != null) {
            return this.target.getType();
        }
        return -1;
    }

    public int vm_role_get_target_id() {
        if (this.target != null) {
            return this.target.getId();
        }
        return -1;
    }

    public String vm_role_get_target_name() {
        if (this.target != null) {
            return this.target.getName();
        }
        return null;
    }

    public GameSprite vm_role_get_target() {
        return this.target;
    }

    public int vm_role_get_target_instanceid() {
        if (this.target != null) {
            return this.target.getInstanceId();
        }
        return -1;
    }

    public void vm_set_game_role_change_2468_mode(boolean yesorno) {
        this.layout2468 = yesorno;
    }

    public boolean vm_sprite_get_dir_key_valid() {
        return this.dirKeyValid;
    }

    public void vm_sprite_set_dir_key_valid(boolean _dirKeyValid) {
        this.dirKeyValid = _dirKeyValid;
    }

    public boolean vm_sprite_get_fire_key_valid() {
        return this.fireKeyValid;
    }

    public void vm_sprite_set_fire_key_valid(boolean _fireKeyValid) {
        this.fireKeyValid = _fireKeyValid;
    }

    public void vm_game_role_set_battle_mode(boolean _inBattle) {
        this.battleMode = _inBattle;
        this.positionLimit = this.battleMode ? GameMain.battleModePositionTime : GameMain.positionLimit;
    }

    public void vm_role_clear_target() {
        this.clearTarget();
    }

    public void vm_game_role_set_target(int _instanceId) {
        GameSprite targetSprite = GameWorld.getSprite(_instanceId);
        if (GameWorld.gameView != null) {
            targetSprite = GameWorld.gameView.checkTarget(targetSprite);
        }
        this.changeTarget(targetSprite);
    }

    public void vm_game_role_set_select_const(int enemyNpcAutoDist, int allyNpcAutoDist, int enemyPlayerAutoDist, int allyPlayerAutoDist, int teamerAutoDist, int enemyNpcForceDist, int allyNpcForceDist, int enemyPlayerForceDist, int allyPlayerForceDist, int teamerForceDist) {
        GameRole.enemyNpcAutoDist = enemyNpcAutoDist;
        GameRole.allyNpcAutoDist = allyNpcAutoDist;
        GameRole.enemyPlayerAutoDist = enemyPlayerAutoDist;
        GameRole.allyPlayerAutoDist = allyPlayerAutoDist;
        GameRole.teamerAutoDist = teamerAutoDist;
        GameRole.enemyNpcForceDist = enemyNpcForceDist;
        GameRole.allyNpcForceDist = allyNpcForceDist;
        GameRole.enemyPlayerForceDist = enemyPlayerForceDist;
        GameRole.allyPlayerForceDist = allyPlayerForceDist;
        GameRole.teamerForceDist = teamerForceDist;
    }

    public void vm_game_role_point_move(int pointMoveDir) {
        this.pointMoveDir = pointMoveDir;
    }

    public void draw(Graphics g, int viewX, int viewY) {
        this.drawAnimate(g, viewX, viewY, true);
        this.sprite.draw(g, viewX, viewY);
        this.drawAnimate(g, viewX, viewY, false);
    }

    public void changeTarget(GameSprite targetSprite) {
        if (targetSprite != this.target) {
            int sendType = -1;
            int sendId = -1;
            if (targetSprite != null) {
                GameSprite targetSprite2 = targetSprite;
                switch (targetSprite2.getType()) {
                    case 1: 
                    case 3: {
                        sendType = targetSprite2.getType();
                        sendId = targetSprite2.getId();
                    }
                }
            }
            GameWorld.panel.sendCommand(15020, new int[]{sendType, sendId});
            if (this.target != null) {
                this.target.sendCommand(10100, new Integer(0));
            }
            if (targetSprite != null) {
                targetSprite.sendCommand(10100, new Integer(1));
            }
            this.target = targetSprite;
        }
    }

    public void cycle() {
        super.cycle();
        this.sprite.cycle();
        if (this.forceWayPointMode || VMGame.state != -1) {
            this.processNotifyServer(this.sprite.getMove(), this.onHorse, this.sprite.getDir());
        } else {
            int newDir = this.sprite.getDir();
            boolean newMoving = false;
            boolean newOnHorse = this.onHorse;
            boolean newHolding = this.hold;
            if (this.dirKeyValid) {
                if ((Utilities.isKeyPressed(19, false) || this.pointMoveDir == 0) && this.layout2468 || Utilities.isKeyPressed(1, false)) {
                    newDir = 0;
                    newMoving = true;
                } else if ((Utilities.isKeyPressed(15, false) || this.pointMoveDir == 2) && this.layout2468 || Utilities.isKeyPressed(2, false)) {
                    newDir = 2;
                    newMoving = true;
                } else if ((Utilities.isKeyPressed(17, false) || this.pointMoveDir == 1) && this.layout2468 || Utilities.isKeyPressed(3, false)) {
                    newDir = 1;
                    newMoving = true;
                } else if ((Utilities.isKeyPressed(13, false) || this.pointMoveDir == 3) && this.layout2468 || Utilities.isKeyPressed(0, false)) {
                    newDir = 3;
                    newMoving = true;
                }
            }
            if (this.fireKeyValid && Utilities.isKeyPressed(4, true) && this.target != null) {
                GameSprite spriteTarget = this.target;
                spriteTarget.sendCommand(10140, null);
            }
            if (newMoving) {
                this.afterChangeTargetHasMoved = true;
            }
            if (this.sprite.getMove() || this.chaseMode) {
                this.processTargetSelect();
            }
            if (newMoving && this.chaseMode) {
                int[] callBackPara = this.chaseCallbackPara;
                this.clearChase();
                if (callBackPara != null) {
                    this.sendCommand(10121, callBackPara);
                }
            }
            if (newMoving && !this.sprite.getMove() && this.dirKeyValid) {
                GameWorld.panel.sendCommand(15040, null);
            }
            this.processNotifyServer(newMoving, newOnHorse, newDir);
            this.processAction(newDir, newMoving, newOnHorse, newHolding);
        }
    }

    public void processTargetSelect() {
        if (this.target != null && this.target != this && !this.target.die) {
            if (Tool.distance(this.target.sprite.getX(), this.target.sprite.getY(), this.sprite.getX(), this.sprite.getY()) > GameMain.lostSelectDistance) {
                this.changeTarget(null);
                this.autoSelect = true;
            }
        } else {
            this.autoSelect = true;
        }
        if (this.autoSelect) {
            GameSprite targetSprite = null;
            if (GameWorld.gameView != null) {
                targetSprite = GameWorld.gameView.findNearTarget(true);
            }
            this.changeTarget(targetSprite);
        }
    }

    public void clearTarget() {
        if (this.target != null) {
            GameWorld.panel.sendCommand(15020, new int[]{-1, -1});
            this.target.sendCommand(10100, new Integer(0));
            this.target = null;
        }
        this.autoSelect = true;
    }

    public void changeHorse(UASegment segment) {
        boolean newOnHorse = segment.readBoolean();
        this.processNotifyServer(false, newOnHorse, this.sprite.getDir());
        this.processAction(this.sprite.getDir(), false, newOnHorse, this.hold);
    }

    public void processNotifyServer(boolean newMoving, boolean newOnHorse, int newDir) {
        int[] newPos = this.sprite.getPosition(0);
        int dx = Math.abs(newPos[1] - this.lastX);
        int dy = Math.abs(newPos[2] - this.lastY);
        boolean needSend = false;
        if (newMoving != this.sprite.getMove()) {
            this.state = newMoving ? (this.state |= 1) : (this.state &= 0xFFFE);
        }
        if (newOnHorse != this.onHorse) {
            this.state = newOnHorse ? (this.state |= 4) : (this.state &= 0xFFFB);
            Tool.sendHorseAction(newDir, newPos[1], newPos[2], newOnHorse);
            this.lastPostionTime = Utilities.getTimeStamp();
        }
        if (this.isFollowing && Utilities.getTimeStamp() - this.lastPostionTime > GameMain.followingNotifyServerTime) {
            needSend = true;
        } else if ((dx > GameMain.positionDistance || dy > GameMain.positionDistance || Utilities.getTimeStamp() - this.lastPostionTime > GameMain.positionTime || this.sprite.getMove() != newMoving || this.sprite.getDir() != newDir) && Utilities.getTimeStamp() - this.lastPostionTime > this.positionLimit) {
            needSend = true;
        }
        if (this.needSendStop && !newMoving) {
            needSend = true;
        }
        if (needSend) {
            this.needSendStop = newMoving;
            if (this.followOwner != null) {
                Tool.sendPosition(newDir, newPos[1], newPos[2], this.state);
            } else {
                Tool.sendPosition(newDir, newPos[1], newPos[2], this.state);
            }
            Quest.setEventMask(2);
            this.lastPostionTime = Utilities.getTimeStamp();
            this.lastX = newPos[1];
            this.lastY = newPos[2];
        }
    }

    public boolean isHumanAnimate() {
        return true;
    }
}

