/*
 * Decompiled with CFR 0.152.
 */
package com.pip.sanguo;

import com.pip.common.Tool;
import com.pip.engine.AnimatePlayer;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameWorld;
import com.pip.ui.VMGame;
import javax.microedition.lcdui.Graphics;

public class GameIcon
extends GameSprite {
    private int[] clip;
    private AnimatePlayer animatePlayer;
    private boolean playAnimate;
    private GameSprite father;
    private static final Tool idKey = new Tool();

    public GameIcon(int type, int id) {
        super(type, id, -2);
    }

    public static GameIcon createGameIcon(GameSprite father, int animateIndex) {
        if (father == null || father.sprite == null || father.sprite.getIconAnimate() == null) {
            return null;
        }
        GameIcon gameIcon = new GameIcon(100, idKey.nextKey());
        gameIcon.vm = VMGame.getVMGame("game_icon").getVM();
        gameIcon.setName(father.getName());
        gameIcon.father = father;
        gameIcon.playAnimate = true;
        gameIcon.animatePlayer = father.sprite.getIconAnimate();
        gameIcon.sprite.addAnimate(gameIcon.animatePlayer.getCopy());
        gameIcon.sprite.setAnimateIndex(gameIcon.animatePlayer.getAnimateName(), animateIndex, 0, -1, null, true);
        gameIcon.sprite.showAnimate(gameIcon.animatePlayer.getAnimateName());
        gameIcon.sprite.setPosition(0, 0);
        return gameIcon;
    }

    public void vm_free_icon() {
        GameWorld.gameIcons.remove(new Integer(this.getId()));
    }

    public void vm_set_icon_position(int x, int y) {
        this.sprite.setPosition(x, y);
    }

    public void vm_set_icon_clip(int x, int y, int w, int h) {
        this.clip = new int[]{x, y, w, h};
    }

    public void vm_set_icon_show(boolean show) {
        this.sprite.setShow(show);
    }

    public void vm_set_icon_index(int index) {
        this.sprite.setAnimateIndex(this.animatePlayer.getAnimateName(), index, 0, -1, null, true);
    }

    public void vm_set_icon_play_animate(boolean playAnimate) {
        this.playAnimate = playAnimate;
    }

    public int vm_get_icon_id() {
        return this.getId();
    }

    public GameSprite vm_get_icon_father() {
        return this.father;
    }

    public void cycle() {
        if (this.playAnimate) {
            this.sprite.cycle();
        }
    }

    public void drawImageIcon(Graphics g, int x, int y) {
        int clipX = 0;
        int clipY = 0;
        int clipW = 0;
        int clipH = 0;
        if (this.clip != null) {
            clipX = g.getClipX();
            clipY = g.getClipY();
            clipW = g.getClipWidth();
            clipH = g.getClipHeight();
            g.setClip(this.clip[0], this.clip[1], this.clip[2], this.clip[3]);
        }
        this.animatePlayer.drawSingleFrame(g, 0, x, y);
        if (this.clip != null) {
            g.setClip(clipX, clipY, clipW, clipH);
        }
    }

    public void draw(Graphics g, int viewX, int viewY) {
        int clipX = 0;
        int clipY = 0;
        int clipW = 0;
        int clipH = 0;
        if (this.clip != null) {
            clipX = g.getClipX();
            clipY = g.getClipY();
            clipW = g.getClipWidth();
            clipH = g.getClipHeight();
            int[] animateBox = this.sprite.getAnimateBox();
            g.setClip(this.clip[0] + animateBox[0], this.clip[1] + animateBox[1], this.clip[2], this.clip[3]);
        }
        this.sprite.draw(g, viewX, viewY);
        if (this.clip != null) {
            g.setClip(clipX, clipY, clipW, clipH);
        }
    }

    public boolean isHumanAnimate() {
        return this.father.isHumanAnimate();
    }
}

