/*
 * Decompiled with CFR 0.152.
 */
package com.pip.resource;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.engine.AnimateCache;
import com.pip.image.ImageSet;
import com.pip.io.UASegment;
import com.pip.resource.ResourceDatabaseRMS;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameWorld;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import com.pip.util.SortHashtable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceManager {
    private SortHashtable imageCache = new SortHashtable();
    private int clientDataVersion = 0;
    private Hashtable localTable = new Hashtable();
    private Hashtable pkgTable = new Hashtable();
    private ResourceDatabaseRMS clientFileDb;
    private ResourceDatabaseRMS dataDb;
    private Vector remainUpdateList = new Vector();
    public SortHashtable currentUpdateTable = new SortHashtable();
    private Hashtable fileDatas = new Hashtable();
    private Hashtable fileDataNums = new Hashtable();
    private int curUpdate;
    private int mode = 0;
    private byte dbCount;
    private int dbLimit = 204800;
    private int configSaveTicks;
    private int nextSaveTick;
    private byte[] clientDataUpdate = null;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_UPDATING = 1;
    private static final int MODE_UPDATED = 2;
    private static final int MODE_NEED_INIT = 3;
    private static final String RES_CLIENT_PREFIX = "sanguo_clt_";
    private static final String RES_DATA_PREFIX = "sanguo_db_";
    public static final String POSTFIX_PKG = ".pkg";
    public static final String POSTFIX_CTN = ".ctn";
    public static final String POSTFIX_PIP = ".pip";
    public static final String POSTFIX_ETF = ".etf";
    public static final String POSTFIX_PNG = ".png";
    public static final byte TYPE_PKG = 0;
    public static final byte TYPE_CTN = 1;
    public static final byte TYPE_PIP = 2;
    public static final byte TYPE_ETF = 3;
    public static final byte TYPE_PNG = 4;
    public static final boolean USE_RESOURCE_PACK = false;
    public static final String PACK_TABLE_FILENAME = "";
    private Hashtable downloads = new Hashtable();

    public ResourceManager() {
        this.dbCount = (byte)16;
        this.nextSaveTick = this.configSaveTicks = 100;
        this.clientFileDb = new ResourceDatabaseRMS(1, Integer.MAX_VALUE, RES_CLIENT_PREFIX, true);
        this.dataDb = new ResourceDatabaseRMS(this.dbCount, this.dbLimit, RES_DATA_PREFIX, false);
    }

    public void clearWholeData() {
        Tool.deleteRMSFile("clientdata.db");
        this.clientFileDb.clearDatabase();
        this.dataDb.clearDatabase();
    }

    public void clear() {
        int count;
        this.saveResourceInfo(true);
        if (this.clientDataUpdate != null) {
            VM.saveRMSFile("clientdata.db", this.clientDataUpdate);
            this.clientDataUpdate = null;
        }
        if ((count = this.currentUpdateTable.size()) > 0) {
            Object[] keys = this.currentUpdateTable.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.imageCache.remove(keys[i]);
            }
        } else {
            this.imageCache.clear();
        }
        this.pkgTable.clear();
    }

    public void initManager(UASegment segment) {
        this.mode = 0;
        segment.handled = true;
    }

    public void loadResourceInfo() {
        if (this.clientFileDb.loadInformation()) {
            Tool.deleteRMSFile("clientdata.db");
        }
        this.loadLocalTable();
        this.dataDb.loadInformation();
    }

    public void saveResourceInfo(boolean saveWholeData) {
        if (saveWholeData) {
            this.clientFileDb.saveInformation(saveWholeData);
            this.dataDb.saveInformation(saveWholeData);
        } else {
            if (this.clientFileDb.isDirty()) {
                GameMain.resourceAsynLoader.addDatabaseAction((byte)111, this.clientFileDb, null, null, saveWholeData ? 1 : 0);
            }
            if (this.dataDb.isDirty()) {
                GameMain.resourceAsynLoader.addDatabaseAction((byte)111, this.dataDb, null, null, saveWholeData ? 1 : 0);
            }
        }
    }

    public void cycle() {
        if (GameMain.tick >= this.nextSaveTick) {
            this.nextSaveTick = GameMain.tick + this.configSaveTicks;
        }
    }

    public byte[] findResource(String name) {
        byte[] result = null;
        if (this.isLocalResource(name)) {
            result = this.clientFileDb.loadFile(name);
            if (result == null) {
                result = Tool.loadLocalResource(ResourceManager.getLocalName(name));
            }
        } else if (name.endsWith(POSTFIX_PKG)) {
            result = this.dataDb.loadFile(name);
            if (result == null && this.pkgTable.containsKey(name)) {
                result = Tool.loadLocalResource(ResourceManager.getLocalName(name));
            }
        } else {
            result = this.dataDb.loadFile(name);
        }
        return result;
    }

    public ImageSet findImageSet(String name, boolean cache) {
        ImageSet result = (ImageSet)this.imageCache.get(name);
        if (result == null) {
            byte[] data = this.findResource(name);
            try {
                result = new ImageSet(data);
                result.fileName = name;
                if (cache) {
                    this.imageCache.put(name, result);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public void requestResource(String name) {
        GameMain.resourceAsynLoader.addLoad((byte)101, name, null);
    }

    public void requestResourceImpl(String name) {
        byte[] data = this.findResource(name);
        if (data == null) {
            Tool.sendGetFile(name);
        }
        if (data != null) {
            this.notifyGame(name, -1, data);
        }
    }

    public void recvFileData(String name, int version, byte[] data, int fileLength, int startIndex) {
        int curFileLen;
        this.curUpdate += data.length;
        byte[] updateDatas = (byte[])this.fileDatas.get(name);
        if (updateDatas == null) {
            updateDatas = new byte[fileLength];
        }
        System.arraycopy(data, 0, updateDatas, startIndex, data.length);
        Integer date = (Integer)this.fileDataNums.get(name);
        int dataLength = 0;
        if (date != null) {
            dataLength = date;
        }
        if ((curFileLen = data.length + dataLength) == fileLength) {
            this.fileDataNums.remove(name);
            this.fileDatas.remove(name);
            this.recvResource(name, version, updateDatas);
        } else {
            this.fileDataNums.put(name, new Integer(curFileLen));
            this.fileDatas.put(name, updateDatas);
        }
    }

    public int getCurUpdate() {
        return this.curUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recvResource(String name, int version, byte[] data) {
        VM vM;
        VM vm;
        VMGame vmg;
        boolean isUpdate = false;
        if (this.remainUpdateList.size() > 0) {
            if (this.remainUpdateList.contains(name)) {
                this.remainUpdateList.removeElement(name);
                isUpdate = true;
            }
            if (this.remainUpdateList.size() == 0) {
                this.mode = 2;
            }
        }
        if (isUpdate) {
            this.clientFileDb.saveFile(name, data, version);
            if (this.remainUpdateList.size() == 0) {
                this.saveResourceInfo(true);
            }
        } else if (this.isLocalResource(name)) {
            GameMain.resourceAsynLoader.addDatabaseAction((byte)110, this.clientFileDb, name, data, version);
        } else {
            GameMain.resourceAsynLoader.addDatabaseAction((byte)110, this.dataDb, name, data, version);
        }
        if (!isUpdate) {
            this.notifyGame(name, version, data);
        }
        if ((vmg = VMGame.getVMGame("game_icon")) != null) {
            vM = vm = vmg.gtvm;
            synchronized (vM) {
                vm.callback("ReceiveFile", new int[]{vm.makeTempObject(name)});
            }
        }
        if ((vmg = VMGame.getVMGame("game_init_once")) != null) {
            vM = vm = vmg.gtvm;
            synchronized (vM) {
                vm.callback("ReceiveFile", new int[]{vm.makeTempObject(name)});
            }
        }
    }

    public void syncVersion(boolean whole) {
        try {
            String name;
            Enumeration emu;
            Vector dataList = this.dataDb.getFileNameList();
            int realcount = this.localTable.size();
            if (whole) {
                emu = this.pkgTable.keys();
                while (emu.hasMoreElements()) {
                    String name2 = (String)emu.nextElement();
                    if (this.dataDb.hasFile(name2)) continue;
                    ++realcount;
                }
                realcount += dataList.size();
            }
            UASegment segment = new UASegment(188);
            segment.writeString(GameMain.getUIModel());
            segment.writeString(GameMain.getClientVersion());
            segment.writeString(GameMain.getModel());
            segment.writeInt(this.clientDataVersion);
            segment.writeShort((short)realcount);
            emu = this.localTable.keys();
            while (emu.hasMoreElements()) {
                name = (String)emu.nextElement();
                segment.writeString(name);
                segment.writeInt((int)((Integer)this.localTable.get(name) & Integer.MAX_VALUE));
            }
            if (whole) {
                emu = this.pkgTable.keys();
                while (emu.hasMoreElements()) {
                    name = (String)emu.nextElement();
                    if (this.dataDb.hasFile(name)) continue;
                    segment.writeString(name);
                    segment.writeInt((int)((Integer)this.pkgTable.get(name) & Integer.MAX_VALUE));
                }
                for (int i = 0; i < dataList.size(); ++i) {
                    String name3 = (String)dataList.elementAt(i);
                    segment.writeString(name3);
                    segment.writeInt(this.dataDb.getFileVersion(name3));
                }
            }
            Utilities.sendRequest(segment);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void recvSyncVersion(UASegment segment) {
        int count = segment.readShort();
        Vector<String> updateList = new Vector<String>();
        this.currentUpdateTable.clear();
        for (int i = 0; i < count; ++i) {
            String name = segment.readString();
            int version = segment.readInt();
            if (name.equals("client.data")) {
                byte[] data = segment.readBytes();
                byte[] data2 = new byte[data.length + 4];
                Tool.setInt(data2, 0, version);
                System.arraycopy(data, 0, data2, 4, data.length);
                this.clientDataUpdate = data2;
                continue;
            }
            if (name.equals("menu1280.pip") && GameMain.viewWidth <= 960) continue;
            if ((version & Integer.MIN_VALUE) != 0) {
                Integer localVersion = null;
                if (this.localTable.containsKey(name)) {
                    localVersion = (Integer)this.localTable.get(name);
                }
                if (localVersion != null && localVersion == version) continue;
                this.localTable.put(name, new Integer(version));
                this.clientFileDb.updateFile(name);
                updateList.addElement(name);
                this.currentUpdateTable.put(name, name);
                continue;
            }
            if (!this.dataDb.hasFile(name) && this.pkgTable.containsKey(name)) {
                this.pkgTable.remove(name);
                continue;
            }
            this.dataDb.updateFile(name);
        }
        this.remainUpdateList = updateList;
        if (this.remainUpdateList.size() > 0) {
            this.mode = 1;
        }
    }

    public void clearClientFileDb() {
        if (this.remainUpdateList.size() > 0) {
            String name;
            int i;
            Vector savedFileNames = this.clientFileDb.getFileNameList();
            Vector<Integer> cacheVersion = new Vector<Integer>();
            Vector<byte[]> cacheData = new Vector<byte[]>();
            for (i = 0; i < savedFileNames.size(); ++i) {
                name = (String)savedFileNames.elementAt(i);
                if (this.remainUpdateList.contains(name)) {
                    cacheData.addElement(new byte[0]);
                } else {
                    cacheData.addElement(this.clientFileDb.loadFile(name));
                }
                cacheVersion.addElement(new Integer(this.clientFileDb.getFileVersion(name)));
            }
            this.clientFileDb.truncateDatabase();
            for (i = 0; i < savedFileNames.size(); ++i) {
                name = (String)savedFileNames.elementAt(i);
                byte[] data = (byte[])cacheData.elementAt(i);
                int version = (Integer)cacheVersion.elementAt(i);
                if (data.length <= 0) continue;
                this.clientFileDb.saveFile(name, data, version);
            }
        }
    }

    public int getUpdateMode() {
        return this.mode;
    }

    public String[] getRemainUpdateList() {
        Object[] result = new String[this.remainUpdateList.size()];
        this.remainUpdateList.copyInto(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalTable() {
        int version;
        this.localTable.clear();
        byte[] clientData = VM.loadRMSFile("clientdata.db");
        if (clientData != null) {
            this.clientDataVersion = Tool.getInt(clientData, 0);
            byte[] arr = new byte[clientData.length - 4];
            System.arraycopy(clientData, 4, arr, 0, clientData.length - 4);
            clientData = arr;
        } else {
            clientData = Tool.loadLocalResource("client.data");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(clientData);
        DataInputStream dis = new DataInputStream(bis);
        try {
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                String name = Tool.readUTF(dis);
                int version2 = dis.readInt();
                this.localTable.put(name, new Integer(version2));
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception e) {}
        }
        byte[] pkgData = Tool.loadLocalResource("pkg.data");
        bis = new ByteArrayInputStream(pkgData);
        dis = new DataInputStream(bis);
        try {
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                String name = Tool.readUTF(dis);
                version = dis.readInt();
                this.pkgTable.put(name, new Integer(version));
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception e) {}
        }
        Vector clientDBFiles = this.clientFileDb.getFileNameList();
        for (int i = 0; i < clientDBFiles.size(); ++i) {
            String name = (String)clientDBFiles.elementAt(i);
            version = this.clientFileDb.getFileVersion(name);
            this.localTable.put(name, new Integer(version | Integer.MIN_VALUE));
        }
    }

    private boolean isLocalResource(String name) {
        Integer version = (Integer)this.localTable.get(name);
        return version != null;
    }

    public void addDownloadFile(String name) {
        this.downloads.put(name, PACK_TABLE_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGame(String name, int version, byte[] data) {
        byte type = ResourceManager.resourceType(name);
        switch (type) {
            case 0: {
                GameWorld.pkgData = data;
                break;
            }
            case 1: {
                AnimateCache.recvAnimate(ResourceManager.getRecvName(name), data);
                break;
            }
            case 2: {
                GameMain.resourceAsynLoader.addLoad((byte)100, ResourceManager.getRecvName(name), data);
                break;
            }
            case 3: {
                VMGame.recvEtfData(ResourceManager.getRecvName(name), data);
            }
            default: {
                VM gwvm;
                VMGame gameWorld = VMGame.getVMGame("game_world");
                if (gameWorld == null || gameWorld.getVM() == null) break;
                VM vM = gwvm = gameWorld.getVM();
                synchronized (vM) {
                    gwvm.callback("RevcFile", new int[]{gwvm.makeTempObject(name), version, gwvm.makeTempObject(data)});
                    break;
                }
            }
        }
    }

    private static byte resourceType(String name) {
        int result = -1;
        if (name.endsWith(POSTFIX_PKG)) {
            result = 0;
        } else if (name.endsWith(POSTFIX_CTN)) {
            result = 1;
        } else if (name.endsWith(POSTFIX_PIP)) {
            result = 2;
        } else if (name.endsWith(POSTFIX_ETF)) {
            result = 3;
        } else if (name.endsWith(POSTFIX_PNG)) {
            result = 4;
        }
        return (byte)result;
    }

    public static String getLocalName(String name) {
        if (ResourceManager.resourceType(name) == 3) {
            return name.substring(0, name.length() - POSTFIX_ETF.length()) + "_" + GameMain.getUIModel() + ".etf.gz";
        }
        return name;
    }

    private static String getRecvName(String name) {
        if (ResourceManager.resourceType(name) == 3) {
            return name.substring(0, name.length() - POSTFIX_ETF.length());
        }
        return name;
    }

    public boolean hasFile(String name) {
        if (this.isLocalResource(name)) {
            return true;
        }
        return this.dataDb.hasFile(name);
    }
}

