/*
 * Decompiled with CFR 0.152.
 */
package com.pip.io;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.io.UASegment;
import com.pip.sanguo.GameMain;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class UASocketConnection
implements Runnable {
    private boolean cut;
    protected DataInputStream _in;
    protected DataOutputStream _out;
    protected StreamConnection _connection;
    protected UASocketConnection _reader;
    protected UASocketConnection _writer;
    protected boolean _isConnected;
    protected static Vector _segments = new Vector();
    private Thread _connectThread = null;
    public long lastWriteTime = Tool.getSystemTime();
    public long lastReadTime = Tool.getSystemTime();
    public static boolean offlineMode = false;
    protected final byte[] HEAD = new byte[]{85, 65};
    protected final byte[] HEAD_RECV = new byte[]{85};
    public static final int TIME_SEND_TIMEOUT = 60000;
    private UASocketConnection parent;
    private byte runType;

    public UASocketConnection(String url) throws IOException {
        int l = url.indexOf("#");
        long serverID = 0L;
        if (l != -1) {
            String sid = url.substring(l + 1);
            url = url.substring(0, l);
            serverID = Long.parseLong(sid, 16);
        }
        this._connection = (StreamConnection)Connector.open((String)url, (int)3, (boolean)true);
        this._in = this._connection.openDataInputStream();
        this._out = this._connection.openDataOutputStream();
        this._isConnected = true;
        _segments.removeAllElements();
        if (serverID != 0L) {
            this._out.writeInt((int)(serverID >> 16));
            this._out.writeShort((short)serverID);
            this._out.flush();
        }
    }

    public UASocketConnection(UASocketConnection par, byte rt) {
        this.parent = par;
        this.runType = rt;
    }

    public void run() {
        if (this.parent == null) {
            this._reader = new UASocketConnection(this, 0);
            new Thread(this._reader).start();
            this._writer = new UASocketConnection(this, 1);
            new Thread(this._writer).start();
        } else if (this.runType == 0) {
            this.runReader();
        } else {
            this.runWriter();
        }
    }

    public void start() {
        this._connectThread = new Thread(this);
        this._connectThread.start();
    }

    public static void writeSegment(UASegment segment) {
        _segments.addElement(segment);
    }

    protected void write(UASegment segment) throws IOException {
        segment.flush();
        if (offlineMode) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.write(this.HEAD);
        dos.writeInt(segment.data.length + this.HEAD.length + 4);
        dos.write(segment.data);
        dos.flush();
        this._out.write(bos.toByteArray());
        this._out.flush();
        dos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int readFull(InputStream in, byte[] buf) throws IOException {
        int len;
        try {
            int l;
            for (len = 0; len < buf.length; len += l) {
                l = in.read(buf, len, buf.length - len);
                if (l >= 0) continue;
                throw new IOException("Wrong protocol");
            }
        }
        catch (Throwable throwable) {
            for (int i = len; i < buf.length; ++i) {
                buf[i] = 0;
            }
            throw throwable;
        }
        for (int i = len; i < buf.length; ++i) {
            buf[i] = 0;
        }
        return len;
    }

    public static long getNumber(byte[] buf, int off, int len) {
        long l = 0L;
        for (int i = 0; i < len; ++i) {
            l <<= 8;
            l += (long)(buf[off + i] & 0xFF);
        }
        return l;
    }

    public UASegment readSegment() throws IOException {
        byte[] head = new byte[2];
        if (UASocketConnection.readFull(this._in, head) != head.length) {
            return null;
        }
        for (int i = 0; i < this.HEAD_RECV.length; ++i) {
            if (this.HEAD[i] == head[i]) continue;
            throw new IOException("Wrong protocol");
        }
        byte[] lenInHead = null;
        switch (head[1]) {
            case 65: {
                lenInHead = new byte[4];
                break;
            }
            case 66: {
                lenInHead = new byte[2];
                break;
            }
            case 67: {
                lenInHead = new byte[1];
                break;
            }
            default: {
                throw new IOException("Wrong protocol");
            }
        }
        if (UASocketConnection.readFull(this._in, lenInHead) != lenInHead.length) {
            return null;
        }
        int len = 0;
        switch (head[1]) {
            case 65: {
                len = (int)UASocketConnection.getNumber(lenInHead, 0, 4);
                break;
            }
            case 66: {
                len = (int)(UASocketConnection.getNumber(lenInHead, 0, 2) & 0xFFFFL);
                break;
            }
            case 67: {
                len = (int)(UASocketConnection.getNumber(lenInHead, 0, 1) & 0xFFL);
            }
        }
        byte[] buf = null;
        if ((len -= head.length + lenInHead.length) > 0 && UASocketConnection.readFull(this._in, buf = new byte[len]) != len) {
            throw new IOException("Not enough input");
        }
        UASegment data = new UASegment(buf);
        return data;
    }

    public void processSegment(UASegment segment) throws IOException {
        Utilities.addSegment(segment);
    }

    public void tryReconnect() {
        Utilities.tryReconnect();
    }

    public void testClose() {
        this._in = null;
    }

    public void close() {
        this._isConnected = false;
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
        }
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (IOException ex3) {
                // empty catch block
            }
        }
        if (this._connection != null) {
            try {
                this._connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._in = null;
        this._out = null;
        this._connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReader() {
        int breakTimes = 0;
        while (this.parent._isConnected) {
            try {
                UASegment segment;
                if (this.parent.cut) {
                    throw new Exception("\u65ad\u7f51\u6d4b\u8bd5");
                }
                if (GameMain.inCycle) {
                    if (breakTimes < 2) {
                        ++breakTimes;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    breakTimes = 0;
                }
                if ((segment = this.parent.readSegment()) == null) continue;
                this.parent.lastReadTime = Tool.getSystemTime();
                this.parent.processSegment(segment);
            }
            catch (Exception ex) {
                try {
                    VM vm;
                    if (!this.parent._isConnected) break;
                    Utilities.closeConnection();
                    this.parent.tryReconnect();
                    VM vM = vm = VMGame.getVMGameByVMKey(VMGame.gameWorldVMGameKey).getVM();
                    synchronized (vM) {
                        vm.callback("DisConnected", null);
                    }
                    VMGame vmg = VMGame.getVMGame("game_init_once");
                    if (vmg == null) break;
                    VM vM2 = vm = vmg.gtvm;
                    synchronized (vM2) {
                        vm.callback("DisConnected", null);
                    }
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWriter() {
        while (this.parent._isConnected) {
            try {
                if (this.parent.cut) {
                    throw new Exception("\u65ad\u7f51\u6d4b\u8bd5");
                }
                while (_segments.size() != 0) {
                    UASegment segment = (UASegment)_segments.elementAt(0);
                    _segments.removeElementAt(0);
                    this.parent.write(segment);
                    this.parent.lastWriteTime = Tool.getSystemTime();
                }
            }
            catch (Exception ex) {
                try {
                    VM vm;
                    if (!this.parent._isConnected) break;
                    Utilities.closeConnection();
                    this.parent.tryReconnect();
                    VM vM = vm = VMGame.getVMGameByVMKey(VMGame.gameWorldVMGameKey).getVM();
                    synchronized (vM) {
                        vm.callback("DisConnected", null);
                    }
                    VMGame vmg = VMGame.getVMGame("game_init_once");
                    if (vmg == null) break;
                    VM vM2 = vm = vmg.gtvm;
                    synchronized (vM2) {
                        vm.callback("DisConnected", null);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                break;
            }
            finally {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void cut(boolean cut) {
        this.cut = cut;
    }
}

