/*
 * Decompiled with CFR 0.152.
 */
package com.pip.io;

import com.pip.common.Tool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class UASegment {
    public short type;
    public byte[] data;
    public boolean handled;
    public int serial = -1;
    public boolean needResponse;
    private int pos;
    private ByteArrayOutputStream segCache = null;
    private DataOutputStream outputCache = null;
    private static final Tool serialKey = new Tool();

    public UASegment(int type) {
        this(type, false);
    }

    public UASegment(int type, boolean needSerial) {
        this.type = (short)type;
        try {
            this.segCache = new ByteArrayOutputStream();
            this.outputCache = new DataOutputStream(this.segCache);
            this.outputCache.writeShort(type);
            if (needSerial) {
                this.serial = serialKey.nextKey();
                this.outputCache.writeInt(this.serial);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public UASegment(byte[] data) {
        this.data = data;
        this.type = (short)UASegment.getNumber(this.data, 0, 2);
        this.pos = 2;
    }

    public void reset() {
        this.pos = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.segCache == null) {
            return;
        }
        try {
            this.outputCache.flush();
            this.data = this.segCache.toByteArray();
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.outputCache.close();
            }
            catch (Exception e) {}
        }
        this.segCache = null;
        this.outputCache = null;
        UASegment.setNumber(this.type, this.data, 0, 2);
    }

    public boolean readBoolean() {
        return this.data[this.pos++] == 1;
    }

    public byte readByte() {
        return this.data[this.pos++];
    }

    public int readUnsignedByte() {
        return this.data[this.pos++] & 0xFF;
    }

    public short readShort() {
        this.pos += 2;
        return (short)UASegment.getNumber(this.data, this.pos - 2, 2);
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readInt() {
        this.pos += 4;
        return (int)UASegment.getNumber(this.data, this.pos - 4, 4);
    }

    public void setInt(int num) {
        UASegment.setNumber(num, this.data, this.pos, 4);
    }

    public long readLong() {
        this.pos += 8;
        return UASegment.getNumber(this.data, this.pos - 8, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString() {
        String i2;
        FilterInputStream dis = null;
        try {
            if ((this.data[this.pos] & 0x80) == 0) {
                dis = new DataInputStream(new ByteArrayInputStream(this.data, this.pos, this.data.length - this.pos));
                this.pos = (int)((long)this.pos + (UASegment.getNumber(this.data, this.pos, 2) + 2L));
                String string = Tool.readUTF((DataInputStream)dis);
                return string;
            }
            int len = (int)(UASegment.getNumber(this.data, this.pos, 2) & 0x7FFFL);
            this.pos += 2;
            char[] charr = new char[len / 2];
            for (int i2 = 0; i2 < charr.length; ++i2) {
                charr[i2] = (char)((this.data[this.pos] & 0xFF) << 8 | this.data[this.pos + 1] & 0xFF);
                this.pos += 2;
            }
            i2 = new String(charr);
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception e) {}
        }
        return i2;
    }

    public boolean[] readBooleans() {
        int len = (int)UASegment.getNumber(this.data, this.pos, 2);
        this.pos += 2;
        boolean[] result = new boolean[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.readBoolean();
        }
        return result;
    }

    public byte[] readBytes() {
        int len = (int)UASegment.getNumber(this.data, this.pos, 4);
        this.pos += 4;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.readByte();
        }
        return result;
    }

    public short[] readShorts() {
        int len = (int)UASegment.getNumber(this.data, this.pos, 2);
        this.pos += 2;
        short[] result = new short[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.readShort();
        }
        return result;
    }

    public int[] readInts() {
        int len = (int)UASegment.getNumber(this.data, this.pos, 2);
        this.pos += 2;
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.readInt();
        }
        return result;
    }

    public long[] readLongs() {
        int len = (int)UASegment.getNumber(this.data, this.pos, 2);
        this.pos += 2;
        long[] result = new long[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.readLong();
        }
        return result;
    }

    public String[] readStrings() {
        int len = (int)UASegment.getNumber(this.data, this.pos, 2);
        this.pos += 2;
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.readString();
        }
        return result;
    }

    public void writeBoolean(boolean b) throws IOException {
        this.outputCache.writeBoolean(b);
    }

    public void writeByte(byte b) throws IOException {
        this.outputCache.writeByte(b);
    }

    public void writeShort(short s) throws IOException {
        this.outputCache.writeShort(s);
    }

    public void writeInt(int n) throws IOException {
        this.outputCache.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.outputCache.writeLong(l);
    }

    public void writeString(String s) throws IOException {
        this.outputCache.writeUTF(s == null ? "" : s);
    }

    public void writeBooleans(boolean[] b) throws IOException {
        this.outputCache.writeShort(b.length);
        for (int i = 0; i < b.length; ++i) {
            this.outputCache.writeBoolean(b[i]);
        }
    }

    public void writeBytes(byte[] b) throws IOException {
        this.outputCache.writeInt(b.length);
        for (int i = 0; i < b.length; ++i) {
            this.outputCache.writeByte(b[i]);
        }
    }

    public void writeShorts(short[] s) throws IOException {
        this.outputCache.writeShort(s.length);
        for (int i = 0; i < s.length; ++i) {
            this.outputCache.writeShort(s[i]);
        }
    }

    public void writeInts(int[] n) throws IOException {
        this.outputCache.writeShort(n.length);
        for (int i = 0; i < n.length; ++i) {
            this.outputCache.writeInt(n[i]);
        }
    }

    public void writeLongs(long[] l) throws IOException {
        this.outputCache.writeShort(l.length);
        for (int i = 0; i < l.length; ++i) {
            this.outputCache.writeLong(l[i]);
        }
    }

    public void writeStrings(String[] s) throws IOException {
        this.outputCache.writeShort(s.length);
        for (int i = 0; i < s.length; ++i) {
            this.outputCache.writeUTF(s[i]);
        }
    }

    public static long getNumber(byte[] buf, int off, int len) {
        long longVal = 0L;
        for (int i = 0; i < len; ++i) {
            longVal <<= 8;
            longVal |= (long)(buf[off + i] & 0xFF);
        }
        return longVal;
    }

    public static void setNumber(int num, byte[] buf, int off, int len) {
        for (int i = len - 1; i >= 0; --i) {
            buf[off + i] = (byte)(num & 0xFF);
            num >>= 8;
        }
    }

    public static HttpConnection getConnection(String url, boolean proxyFlag) throws IOException {
        int ind;
        String proxyUrl = null;
        proxyUrl = proxyFlag ? "10.0.0.172:80" : null;
        String requestUrl = url;
        String realHost = null;
        if (proxyUrl != null && (ind = url.indexOf(47, 7)) >= 0) {
            requestUrl = url.substring(0, 7) + proxyUrl + url.substring(ind);
            realHost = url.substring(7, ind);
        }
        HttpConnection conn = (HttpConnection)Connector.open((String)requestUrl);
        if (realHost != null) {
            conn.setRequestProperty("X-Online-Host", realHost);
        }
        return conn;
    }
}

