/*
 * Decompiled with CFR 0.152.
 */
package com.pip.image;

import com.pip.common.Tool;
import com.pip.image.RGBGraphics;
import com.pip.image.RGBImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class RGBImageSet {
    private static final byte[] HEAD = new byte[]{80, 73, 80};
    private static final byte[] PALETTE_HEAD = new byte[]{80, 76, 84, 69};
    private static final byte[] DATA_HEAD = new byte[]{68, 65, 84, 65};
    private static final byte[] DUNZ_HEAD = new byte[]{68, 85, 78, 90};
    private int[][] palette;
    private int[] frameInfo;
    private byte[][] frameData;
    private int[] frameCollision;
    private Object[] buffer;
    private Hashtable transBuffer;

    public RGBImageSet(InputStream is) throws IOException {
        this.load(new DataInputStream(is));
        this.buffer = new Object[this.palette.length * this.frameData.length];
        for (int i = 0; i < this.palette.length; ++i) {
            for (int j = 0; j < this.frameData.length; ++j) {
                this.buffer[i * this.frameData.length + j] = this.make(i, j);
            }
        }
        this.transBuffer = new Hashtable();
    }

    public void draw(RGBGraphics g, int frame, int x, int y, int trans) {
        this.draw(g, frame, x, y, trans, 20);
    }

    public void draw(RGBGraphics g, int frame, int x, int y, int trans, int anchor) {
        try {
            RGBImage drawData = this.getFrameData(frame, trans);
            int fid = frame % this.frameInfo.length;
            int w = this.frameInfo[fid] >> 10 & 0x3FF;
            int h = this.frameInfo[fid] & 0x3FF;
            if (trans < 4) {
                if ((anchor & 1) > 0) {
                    x -= w / 2;
                } else if ((anchor & 8) > 0) {
                    x -= w;
                }
                if ((anchor & 2) > 0) {
                    y -= h / 2;
                } else if ((anchor & 0x20) > 0) {
                    y -= h;
                }
            } else {
                if ((anchor & 1) > 0) {
                    x -= h / 2;
                } else if ((anchor & 8) > 0) {
                    x -= h;
                }
                if ((anchor & 2) > 0) {
                    y -= w / 2;
                } else if ((anchor & 0x20) > 0) {
                    y -= w;
                }
            }
            g.drawImage(drawData, x, y, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RGBImage getFrameData(int frame, int trans) {
        int id = frame << 16 | trans;
        RGBImage ret = (RGBImage)this.transBuffer.get(new Integer(id));
        if (ret != null) {
            return ret;
        }
        int[] data = (int[])this.buffer[frame];
        int f = frame % this.frameInfo.length;
        int w = this.frameInfo[f] >> 10 & 0x3FF;
        int h = this.frameInfo[f] & 0x3FF;
        data = RGBImageSet.transit(data, w, h, trans);
        if (trans >= 4) {
            int t = h;
            h = w;
            w = t;
        }
        ret = new RGBImage(data, w, h);
        this.transBuffer.put(new Integer(id), ret);
        return ret;
    }

    private Object make(int p, int f) {
        int w = this.frameInfo[f] >> 10 & 0x3FF;
        int h = this.frameInfo[f] & 0x3FF;
        int[] rgb = new int[w * h];
        int[] usePal = this.palette[p];
        byte[] useData = this.frameData[f];
        int id = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                rgb[id] = usePal[useData[id] & 0xFF];
                ++id;
            }
        }
        return rgb;
    }

    private void load(DataInputStream dis) throws IOException {
        dis.skip(3L);
        int c = dis.readByte() & 0xFF;
        this.palette = new int[c][];
        for (int i = 0; i < c; ++i) {
            this.palette[i] = this.readPalette(dis);
        }
        int size = dis.readByte() & 0xFF;
        this.frameInfo = new int[size];
        this.frameData = new byte[size][];
        this.frameCollision = new int[size];
        for (int i = 0; i < size; ++i) {
            this.readFrame(dis, i);
        }
    }

    public void save(DataOutputStream dos) throws IOException {
        int i;
        dos.write(HEAD);
        dos.writeByte(this.palette.length);
        for (i = 0; i < this.palette.length; ++i) {
            this.writePalette(dos, this.palette[i]);
        }
        dos.writeByte(this.frameInfo.length);
        for (i = 0; i < this.frameInfo.length; ++i) {
            this.writeFrame(dos, i);
        }
    }

    public int getWidth(int frame) {
        int ff = frame % this.frameInfo.length;
        return this.frameInfo[ff] >> 10 & 0x3FF;
    }

    public int getHeight(int frame) {
        int ff = frame % this.frameInfo.length;
        return this.frameInfo[ff] & 0x3FF;
    }

    public int getFrameCount() {
        return this.frameInfo.length * this.palette.length;
    }

    public int getBlockCount() {
        return this.frameInfo.length;
    }

    public int getPaletteCount() {
        return this.palette.length;
    }

    public void replacePalette(int index, int[] data) {
        this.palette[index] = data;
    }

    private int[] readPalette(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        int[] ret = new int[len];
        dis.skip(4L);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = dis.readInt();
        }
        return ret;
    }

    private void writePalette(DataOutputStream dos, int[] pdata) throws IOException {
        dos.writeInt(pdata.length);
        dos.write(PALETTE_HEAD);
        for (int i = 0; i < pdata.length; ++i) {
            dos.writeInt(pdata[i]);
        }
    }

    private void readFrame(DataInputStream dis, int index) throws IOException {
        int len = dis.readInt() - 6;
        byte[] head = new byte[4];
        dis.readFully(head);
        byte flip = dis.readByte();
        byte frame = dis.readByte();
        short width = dis.readShort();
        short height = dis.readShort();
        int collision = 0;
        byte c = dis.readByte();
        if (c == 1) {
            collision = dis.readInt();
        }
        byte[] data = new byte[len];
        dis.readFully(data);
        if (head[1] == 65) {
            data = Tool.inflate(data);
        }
        this.frameData[index] = data;
        this.frameInfo[index] = (flip & 7) << 28 | (frame & 0xFF) << 20 | (width & 0x3FF) << 10 | height & 0x3FF;
        this.frameCollision[index] = collision;
    }

    private void writeFrame(DataOutputStream dos, int index) throws IOException {
        dos.writeInt(this.frameData[index].length + 6);
        dos.write(DUNZ_HEAD);
        int info = this.frameInfo[index];
        dos.writeByte(info >> 28);
        dos.writeByte(info >> 20);
        dos.writeShort(info >> 10 & 0x3FF);
        dos.writeShort(info & 0x3FF);
        if (this.frameCollision[index] == 0) {
            dos.writeByte(0);
        } else {
            dos.writeByte(0);
            dos.writeInt(this.frameCollision[index]);
        }
        dos.write(this.frameData[index]);
    }

    private static final int toRGB(int a, int r, int g, int b) {
        if (a > 255) {
            a = 255;
        }
        if (a < 0) {
            a = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g < 0) {
            g = 0;
        }
        if (b < 0) {
            b = 0;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static final int[] parseRGB(int rgb) {
        int aa = rgb >> 24 & 0xFF;
        int rr = rgb >> 16 & 0xFF;
        int gg = rgb >> 8 & 0xFF;
        int bb = rgb & 0xFF;
        return new int[]{aa, rr, gg, bb};
    }

    private static final int lighter(int rgb, int v) {
        int[] c = RGBImageSet.parseRGB(rgb);
        c[1] = c[1] + v * 3;
        c[2] = c[2] + v * 3;
        c[3] = c[3] + v * 3;
        return RGBImageSet.toRGB(c[0], c[1], c[2], c[3]);
    }

    private static final int darker(int rgb, int v) {
        int[] c = RGBImageSet.parseRGB(rgb);
        c[1] = c[1] - v * 3;
        c[2] = c[2] - v * 3;
        c[3] = c[3] - v * 3;
        return RGBImageSet.toRGB(c[0], c[1], c[2], c[3]);
    }

    private static final int gray(int rgb) {
        int y;
        int[] c = RGBImageSet.parseRGB(rgb);
        c[1] = y = c[1] * 299 / 1000 + c[2] * 587 / 1000 + c[3] * 114 / 1000;
        c[2] = y;
        c[3] = y;
        return RGBImageSet.toRGB(c[0], c[1], c[2], c[3]);
    }

    public static int[] transit(int[] rgb, int w, int h, int trans) {
        if (trans == 0) {
            return rgb;
        }
        int[][] ret = trans < 4 ? new int[h][w] : new int[w][h];
        int srcpos = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                switch (trans) {
                    case 1: {
                        ret[h - 1 - y][x] = rgb[srcpos];
                        break;
                    }
                    case 2: {
                        ret[y][w - 1 - x] = rgb[srcpos];
                        break;
                    }
                    case 3: {
                        ret[h - 1 - y][w - 1 - x] = rgb[srcpos];
                        break;
                    }
                    case 4: {
                        ret[x][y] = rgb[srcpos];
                        break;
                    }
                    case 5: {
                        ret[x][h - 1 - y] = rgb[srcpos];
                        break;
                    }
                    case 6: {
                        ret[w - 1 - x][y] = rgb[srcpos];
                        break;
                    }
                    case 7: {
                        ret[w - 1 - x][h - 1 - y] = rgb[srcpos];
                    }
                }
                ++srcpos;
            }
        }
        int[] ret2 = new int[w * h];
        int tarpos = 0;
        for (int i = 0; i < ret.length; ++i) {
            System.arraycopy(ret[i], 0, ret2, tarpos, ret[i].length);
            tarpos += ret[i].length;
        }
        return ret2;
    }
}

